/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import kafka.api.DelegationTokenEndToEndAuthorizationTest;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.CreateDelegationTokenOptions;
import org.apache.kafka.clients.admin.DescribeDelegationTokenOptions;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.internals.Plugin;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.server.authorizer.Authorizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005c\u0001B\u0010!\u0001\u0015BQA\u000b\u0001\u0005\u0002-BQ!\f\u0001\u0005\u00029BQ\u0001\u0010\u0001\u0005\u0002uBQa\u0013\u0001\u0005\u00029BQ\u0001\u0014\u0001\u0005\u0002uBQ!\u0014\u0001\u0005\u00029BQA\u0014\u0001\u0005B=Cq\u0001\u0017\u0001C\u0002\u0013%\u0011\f\u0003\u0004c\u0001\u0001\u0006IA\u0017\u0005\bG\u0002\u0011\r\u0011\"\u0003e\u0011\u0019i\u0007\u0001)A\u0005K\"9a\u000e\u0001b\u0001\n\u0013I\u0006BB8\u0001A\u0003%!\fC\u0004q\u0001\t\u0007I\u0011\u00023\t\rE\u0004\u0001\u0015!\u0003f\u0011\u001d\u0011\bA1A\u0005\neCaa\u001d\u0001!\u0002\u0013Q\u0006b\u0002;\u0001\u0005\u0004%I\u0001\u001a\u0005\u0007k\u0002\u0001\u000b\u0011B3\t\u000fY\u0004!\u0019!C\u00053\"1q\u000f\u0001Q\u0001\niCq\u0001\u001f\u0001C\u0002\u0013%A\r\u0003\u0004z\u0001\u0001\u0006I!\u001a\u0005\u0006u\u0002!\te\u001f\u0005\u0007\u0003\u0003\u0001A\u0011I>\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006!9\u0011\u0011\u0004\u0001\u0005B\u0005m\u0001BBA\u0012\u0001\u0011\u00051\u0010\u0003\u0004\u0002:\u0001!\ta\u001f\u0005\u0007\u0003{\u0001A\u0011A>\u0003c\u0011+G.Z4bi&|g\u000eV8lK:,e\u000e\u001a+p\u000b:$\u0017)\u001e;i_JL'0\u0019;j_:<\u0016\u000e\u001e5Po:,'\u000fV3ti*\u0011\u0011EI\u0001\u0004CBL'\"A\u0012\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\n\t\u0003O!j\u0011\u0001I\u0005\u0003S\u0001\u0012\u0001\u0006R3mK\u001e\fG/[8o)>\\WM\\#oIR{WI\u001c3BkRDwN]5{CRLwN\u001c+fgR\fa\u0001P5oSRtD#\u0001\u0017\u0011\u0005\u001d\u0002\u0011AD!dYR{7.\u001a8De\u0016\fG/Z\u000b\u0002_A\u0011\u0001GO\u0007\u0002c)\u0011!gM\u0001\u0004C\u000ed'B\u0001\u001b6\u0003\u0019\u0019w.\\7p]*\u00111E\u000e\u0006\u0003oa\na!\u00199bG\",'\"A\u001d\u0002\u0007=\u0014x-\u0003\u0002<c\tQ\u0011i\u00197CS:$\u0017N\\4\u0002\u001dQ{7.\u001a8De\u0016\fG/Z!dYV\ta\bE\u0002@\r\"k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005\r#\u0015AC2pY2,7\r^5p]*\tQ)A\u0003tG\u0006d\u0017-\u0003\u0002H\u0001\n\u00191+\u001a;\u0011\u0005AJ\u0015B\u0001&2\u0005I\t5mY3tg\u000e{g\u000e\u001e:pY\u0016sGO]=\u0002!\u0005\u001bG\u000eV8lK:$Um]2sS\n,\u0017\u0001\u0005+pW\u0016tG)Z:de&\u0014W-Q2m\u0003U\t5\r\u001c+pW\u0016tw\n\u001e5fe\u0012+7o\u0019:jE\u0016\fAd\u0019:fCR,G)\u001a7fO\u0006$\u0018n\u001c8U_.,gn\u00149uS>t7\u000fF\u0001Q!\t\tf+D\u0001S\u0015\t\u0019F+A\u0003bI6LgN\u0003\u0002Vk\u000591\r\\5f]R\u001c\u0018BA,S\u0005q\u0019%/Z1uK\u0012+G.Z4bi&|g\u000eV8lK:|\u0005\u000f^5p]N\fq\u0003^8lK:\u0014V-];fgR,'\u000f\u0015:j]\u000eL\u0007/\u00197\u0016\u0003i\u0003\"a\u00171\u000e\u0003qS!!\u00180\u0002\t\u0005,H\u000f\u001b\u0006\u0003?N\n\u0001b]3dkJLG/_\u0005\u0003Cr\u0013abS1gW\u0006\u0004&/\u001b8dSB\fG.\u0001\ru_.,gNU3rk\u0016\u001cH/\u001a:Qe&t7-\u001b9bY\u0002\na\u0003^8lK:\u0014V-];fgR,'\u000fU1tg^|'\u000fZ\u000b\u0002KB\u0011am[\u0007\u0002O*\u0011\u0001.[\u0001\u0005Y\u0006twMC\u0001k\u0003\u0011Q\u0017M^1\n\u00051<'AB*ue&tw-A\fu_.,gNU3rk\u0016\u001cH/\u001a:QCN\u001cxo\u001c:eA\u0005!r\u000e\u001e5fe\u000ec\u0017.\u001a8u!JLgnY5qC2\fQc\u001c;iKJ\u001cE.[3oiB\u0013\u0018N\\2ja\u0006d\u0007%A\npi\",'o\u00117jK:$\b+Y:to>\u0014H-\u0001\u000bpi\",'o\u00117jK:$\b+Y:to>\u0014H\rI\u0001\u001e_RDWM]\"mS\u0016tGOU3rk\u0016\u001cH/\u001a:Qe&t7-\u001b9bY\u0006qr\u000e\u001e5fe\u000ec\u0017.\u001a8u%\u0016\fX/Z:uKJ\u0004&/\u001b8dSB\fG\u000eI\u0001\u001d_RDWM]\"mS\u0016tGOU3rk\u0016\u001cH/\u001a:QCN\u001cxo\u001c:e\u0003uyG\u000f[3s\u00072LWM\u001c;SKF,Xm\u001d;feB\u000b7o]<pe\u0012\u0004\u0013A\u00073fg\u000e\u0014\u0018NY3U_.,gNR1jYB\u0013\u0018N\\2ja\u0006d\u0017a\u00073fg\u000e\u0014\u0018NY3U_.,gNR1jYB\u0013\u0018N\\2ja\u0006d\u0007%A\reKN\u001c'/\u001b2f)>\\WM\u001c$bS2\u0004\u0016m]:x_J$\u0017A\u00073fg\u000e\u0014\u0018NY3U_.,gNR1jYB\u000b7o]<pe\u0012\u0004\u0013AI2p]\u001aLw-\u001e:f'\u0016\u001cWO]5us\u00063G/\u001a:TKJ4XM]:Ti\u0006\u0014H\u000fF\u0001}!\tih0D\u0001E\u0013\tyHI\u0001\u0003V]&$\u0018AL2sK\u0006$X-\u00113eSRLwN\\1m\u0007J,G-\u001a8uS\u0006d7/\u00114uKJ\u001cVM\u001d<feN\u001cF/\u0019:uK\u0012\f1\"Y:tKJ$Hk\\6f]R\u0019A0a\u0002\t\u000f\u0005%!\u00041\u0001\u0002\f\u0005)Ao\\6f]B!\u0011QBA\u000b\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011A\u00033fY\u0016<\u0017\r^5p]*\u0019\u0011\u0011\u00020\n\t\u0005]\u0011q\u0002\u0002\u0010\t\u0016dWmZ1uS>tGk\\6f]\u0006y2M]3bi\u0016$vn[3o%\u0016\fX/Z:uKJ\fE-\\5o\u00072LWM\u001c;\u0015\u0005\u0005u\u0001cA)\u0002 %\u0019\u0011\u0011\u0005*\u0003\u000b\u0005#W.\u001b8\u0002AQ,7\u000f^\"sK\u0006$X\rV8lK:4uN](uQ\u0016\u0014Xk]3s\r\u0006LGn\u001d\u0015\u00049\u0005\u001d\u0002\u0003BA\u0015\u0003ki!!a\u000b\u000b\u0007\u0005\niC\u0003\u0003\u00020\u0005E\u0012a\u00026va&$XM\u001d\u0006\u0004\u0003gA\u0014!\u00026v]&$\u0018\u0002BA\u001c\u0003W\u0011A\u0001V3ti\u0006\u0011C/Z:u\t\u0016\u001c8M]5cKR{7.\u001a8G_J|E\u000f[3s+N,'OR1jYND3!HA\u0014\u0003\r\"Xm\u001d;EKN\u001c'/\u001b2f)>\\WM\u001c$pe>#\b.\u001a:Vg\u0016\u0014\b+Y:tKND3AHA\u0014\u0001")
public class DelegationTokenEndToEndAuthorizationWithOwnerTest
extends DelegationTokenEndToEndAuthorizationTest {
    private final KafkaPrincipal tokenRequesterPrincipal = new KafkaPrincipal("User", "scram-user2");
    private final String tokenRequesterPassword;
    private final KafkaPrincipal otherClientPrincipal = new KafkaPrincipal("User", "other-client-principal");
    private final String otherClientPassword;
    private final KafkaPrincipal otherClientRequesterPrincipal = new KafkaPrincipal("User", "other-client-requester-principal");
    private final String otherClientRequesterPassword;
    private final KafkaPrincipal describeTokenFailPrincipal = new KafkaPrincipal("User", "describe-token-fail-principal");
    private final String describeTokenFailPassword;

    public AclBinding AclTokenCreate() {
        return new AclBinding(new ResourcePattern(ResourceType.USER, this.clientPrincipal().toString(), PatternType.LITERAL), new AccessControlEntry(this.tokenRequesterPrincipal().toString(), "*", AclOperation.CREATE_TOKENS, AclPermissionType.ALLOW));
    }

    public Set<AccessControlEntry> TokenCreateAcl() {
        return (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.tokenRequesterPrincipal().toString(), "*", AclOperation.CREATE_TOKENS, AclPermissionType.ALLOW)}));
    }

    public AclBinding AclTokenDescribe() {
        return new AclBinding(new ResourcePattern(ResourceType.USER, this.clientPrincipal().toString(), PatternType.LITERAL), new AccessControlEntry(this.tokenRequesterPrincipal().toString(), "*", AclOperation.DESCRIBE_TOKENS, AclPermissionType.ALLOW));
    }

    public Set<AccessControlEntry> TokenDescribeAcl() {
        return (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.tokenRequesterPrincipal().toString(), "*", AclOperation.DESCRIBE_TOKENS, AclPermissionType.ALLOW)}));
    }

    public AclBinding AclTokenOtherDescribe() {
        return new AclBinding(new ResourcePattern(ResourceType.USER, this.otherClientPrincipal().toString(), PatternType.LITERAL), new AccessControlEntry(this.otherClientRequesterPrincipal().toString(), "*", AclOperation.DESCRIBE_TOKENS, AclPermissionType.ALLOW));
    }

    @Override
    public CreateDelegationTokenOptions createDelegationTokenOptions() {
        return new CreateDelegationTokenOptions().owner(this.clientPrincipal());
    }

    private KafkaPrincipal tokenRequesterPrincipal() {
        return this.tokenRequesterPrincipal;
    }

    private String tokenRequesterPassword() {
        return this.tokenRequesterPassword;
    }

    private KafkaPrincipal otherClientPrincipal() {
        return this.otherClientPrincipal;
    }

    private String otherClientPassword() {
        return this.otherClientPassword;
    }

    private KafkaPrincipal otherClientRequesterPrincipal() {
        return this.otherClientRequesterPrincipal;
    }

    private String otherClientRequesterPassword() {
        return this.otherClientRequesterPassword;
    }

    private KafkaPrincipal describeTokenFailPrincipal() {
        return this.describeTokenFailPrincipal;
    }

    private String describeTokenFailPassword() {
        return this.describeTokenFailPassword;
    }

    @Override
    public void configureSecurityAfterServersStart() {
        Using$.MODULE$.resource((Object)this.createPrivilegedAdminClient(), (Function1 & Serializable)superuserAdminClient -> {
            DelegationTokenEndToEndAuthorizationWithOwnerTest.$anonfun$configureSecurityAfterServersStart$1(this, superuserAdminClient);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        super.configureSecurityAfterServersStart();
    }

    @Override
    public void createAdditionalCredentialsAfterServersStarted() {
        this.createScramCredentialsViaPrivilegedAdminClient(this.tokenRequesterPrincipal().getName(), this.tokenRequesterPassword());
        this.createScramCredentialsViaPrivilegedAdminClient(this.otherClientPrincipal().getName(), this.otherClientPassword());
        this.createScramCredentialsViaPrivilegedAdminClient(this.otherClientRequesterPrincipal().getName(), this.otherClientRequesterPassword());
        this.createScramCredentialsViaPrivilegedAdminClient(this.describeTokenFailPrincipal().getName(), this.describeTokenFailPassword());
    }

    @Override
    public void assertToken(DelegationToken token) {
        this.assertTokenOwner(this.clientPrincipal(), token);
        this.assertTokenRequester(this.tokenRequesterPrincipal(), token);
    }

    @Override
    public Admin createTokenRequesterAdminClient() {
        return this.createScramAdminClient(this.kafkaClientSaslMechanism(), this.tokenRequesterPrincipal().getName(), this.tokenRequesterPassword());
    }

    @Test
    public void testCreateTokenForOtherUserFails() {
        Assertions.assertTrue((boolean)((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.createDelegationTokens((Function0<CreateDelegationTokenOptions>)(Function0 & Serializable)() -> new CreateDelegationTokenOptions().owner(this.otherClientPrincipal()), false))).getMessage().contains("Delegation Token authorization failed"));
    }

    @Test
    public void testDescribeTokenForOtherUserFails() {
        Using$.MODULE$.resource((Object)this.createScramAdminClient(this.kafkaClientSaslMechanism(), this.describeTokenFailPrincipal().getName(), this.describeTokenFailPassword()), (Function1 & Serializable)describeTokenFailAdminClient -> {
            Using$.MODULE$.resource((Object)this.createScramAdminClient(this.kafkaClientSaslMechanism(), this.otherClientPrincipal().getName(), this.otherClientPassword()), (Function1 & Serializable)otherClientAdminClient -> {
                DelegationTokenEndToEndAuthorizationWithOwnerTest.$anonfun$testDescribeTokenForOtherUserFails$2($this, describeTokenFailAdminClient, otherClientAdminClient);
                return BoxedUnit.UNIT;
            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testDescribeTokenForOtherUserPasses() {
        try (Admin adminClient = this.createTokenRequesterAdminClient();){
            Buffer tokens = CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)adminClient.describeDelegationToken(new DescribeDelegationTokenOptions().owners(java.util.List.of(this.clientPrincipal()))).delegationTokens().get()).asScala();
            Assertions.assertTrue((boolean)tokens.nonEmpty());
            tokens.foreach((Function1 & Serializable)t -> {
                DelegationTokenEndToEndAuthorizationWithOwnerTest.$anonfun$testDescribeTokenForOtherUserPasses$1(this, t);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$configureSecurityAfterServersStart$1(DelegationTokenEndToEndAuthorizationWithOwnerTest $this, Admin superuserAdminClient) {
        superuserAdminClient.createAcls((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)$this.AclTokenOtherDescribe(), (List)new .colon.colon((Object)$this.AclTokenCreate(), (List)new .colon.colon((Object)$this.AclTokenDescribe(), (List)Nil$.MODULE$)))).asJava()).values();
        $this.brokers().foreach((Function1 & Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)$this.TokenCreateAcl().$plus$plus($this.TokenDescribeAcl())), (Plugin<Authorizer>)((Plugin)s.dataPlaneRequestProcessor().authorizerPlugin().get()), new ResourcePattern(ResourceType.USER, $this.clientPrincipal().toString(), PatternType.LITERAL), AccessControlEntryFilter.ANY);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testDescribeTokenForOtherUserFails$2(DelegationTokenEndToEndAuthorizationWithOwnerTest $this, Admin describeTokenFailAdminClient$1, Admin otherClientAdminClient) {
        otherClientAdminClient.createDelegationToken().delegationToken().get();
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)describeTokenFailAdminClient$1.describeDelegationToken(new DescribeDelegationTokenOptions().owners(java.util.List.of($this.otherClientPrincipal()))).delegationTokens().get()).asScala().isEmpty());
    }

    public static final /* synthetic */ void $anonfun$testDescribeTokenForOtherUserPasses$1(DelegationTokenEndToEndAuthorizationWithOwnerTest $this, DelegationToken t) {
        Assertions.assertTrue((boolean)t.tokenInfo().owner().equals((Object)$this.clientPrincipal()));
        Assertions.assertTrue((boolean)t.tokenInfo().tokenRequester().equals((Object)$this.tokenRequesterPrincipal()));
    }

    public DelegationTokenEndToEndAuthorizationWithOwnerTest() {
        this.tokenRequesterPassword = "scram-user2-secret";
        this.otherClientPassword = "other-client-password";
        this.otherClientRequesterPassword = "other-client-requester-password";
        this.describeTokenFailPassword = "describe-token-fail-password";
    }
}

