/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Optional;
import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.security.JaasTestUtils;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.Implicits;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.KafkaShareConsumer;
import org.apache.kafka.clients.consumer.ShareConsumer;
import org.apache.kafka.clients.consumer.internals.AsyncKafkaConsumer;
import org.apache.kafka.clients.consumer.internals.StreamsRebalanceData;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.javaapi.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\rEg!B\"E\u0003\u0003I\u0005\"\u0002)\u0001\t\u0003\t\u0006\"\u0002+\u0001\r#)\u0006\"\u0002/\u0001\t#)\u0006bB/\u0001\u0005\u0004%\tA\u0018\u0005\u0007O\u0002\u0001\u000b\u0011B0\t\u000f!\u0004!\u0019!C\u0001=\"1\u0011\u000e\u0001Q\u0001\n}CqA\u001b\u0001C\u0002\u0013\u0005a\f\u0003\u0004l\u0001\u0001\u0006Ia\u0018\u0005\bY\u0002\u0011\r\u0011\"\u0001_\u0011\u0019i\u0007\u0001)A\u0005?\"9a\u000e\u0001b\u0001\n\u0003q\u0006BB8\u0001A\u0003%q\fC\u0004q\u0001\t\u0007I\u0011\u00010\t\rE\u0004\u0001\u0015!\u0003`\u0011\u001d\u0011\bA1A\u0005\u0002yCaa\u001d\u0001!\u0002\u0013y\u0006b\u0002;\u0001\u0005\u0004%\tA\u0018\u0005\u0007k\u0002\u0001\u000b\u0011B0\t\u000fY\u0004!\u0019!C\u0005o\"9\u0011Q\u0005\u0001!\u0002\u0013A\b\"CA\u001e\u0001\t\u0007I\u0011BA\u001f\u0011!\ty\u0005\u0001Q\u0001\n\u0005}\u0002\"CA,\u0001\t\u0007I\u0011BA-\u0011!\t9\u0007\u0001Q\u0001\n\u0005m\u0003\"CA8\u0001\t\u0007I\u0011BA9\u0011!\tI\t\u0001Q\u0001\n\u0005M\u0004\"CAI\u0001\t\u0007I\u0011BAJ\u0011!\t\u0019\u000b\u0001Q\u0001\n\u0005U\u0005bBAS\u0001\u0011E\u0011q\u0015\u0005\b\u0003s\u0003A\u0011CA^\u0011\u001d\ty\r\u0001C!\u0003#Dq!!9\u0001\t#\n\u0019\u000fC\u0004\u0002|\u0002!\t\"!@\t\u000f\t\u0005\u0001\u0001\"\u0003\u0003\u0004!9!q\u0001\u0001\u0005B\t%\u0001b\u0002B\u000b\u0001\u0011E!q\u0003\u0005\b\u00057\u0001A\u0011\u0001B\u000f\u0011\u001d\u0011Y\u0003\u0001C\u0001\u0005[AqA!\u0013\u0001\t\u0003\u0011Y\u0005C\u0004\u0003P\u0001!\tA!\u0015\t\u0013\tu\u0004!%A\u0005\u0002\t}\u0004\"\u0003BQ\u0001E\u0005I\u0011\u0001BR\u0011%\u0011I\u000bAI\u0001\n\u0003\u0011Y\u000bC\u0004\u00036\u0002!\tAa.\t\u0013\t5\b!%A\u0005\u0002\t=\b\"\u0003B\u0000\u0001E\u0005I\u0011AB\u0001\u0011%\u00199\u0001AI\u0001\n\u0003\u0019I\u0001C\u0005\u0004\u0010\u0001\t\n\u0011\"\u0001\u0004\u0012!911\u0004\u0001\u0005\u0002\ru\u0001\"CB\u001c\u0001E\u0005I\u0011AB\u001d\u0011%\u0019y\u0004AI\u0001\n\u0003\u0019\t\u0005C\u0005\u0004H\u0001\t\n\u0011\"\u0001\u0004J!I1q\n\u0001\u0012\u0002\u0013\u00051\u0011\u000b\u0005\b\u0007/\u0002A\u0011AB-\u0011%\u00199\tAI\u0001\n\u0003\u0019I\tC\u0005\u0004\u0010\u0002\t\n\u0011\"\u0001\u0004\u0012\"I1q\u0013\u0001\u0012\u0002\u0013\u00051\u0011\u0014\u0005\n\u0007?\u0003\u0011\u0013!C\u0001\u0007CCqaa*\u0001\t\u0003\u0019I\u000bC\u0005\u00042\u0002\t\n\u0011\"\u0001\u00044\"I1q\u0017\u0001\u0012\u0002\u0013\u0005!Q\u0016\u0005\b\u0007s\u0003A\u0011AB^\u0011%\u0019\t\rAI\u0001\n\u0003\u0019\u0019\fC\u0005\u0004D\u0002\t\n\u0011\"\u0001\u0003.\"91Q\u0019\u0001\u0005B\r\u001d'AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u000b\u0005\u00153\u0015aA1qS*\tq)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0005CA&O\u001b\u0005a%BA'G\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u0005=c%AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005\u0011\u0006CA*\u0001\u001b\u0005!\u0015a\u00032s_.,'oQ8v]R,\u0012A\u0016\t\u0003/jk\u0011\u0001\u0017\u0006\u00023\u0006)1oY1mC&\u00111\f\u0017\u0002\u0004\u0013:$\u0018a\u00037pO\u0012K'oQ8v]R\fa\u0002\u001d:pIV\u001cWM]\"p]\u001aLw-F\u0001`!\t\u0001W-D\u0001b\u0015\t\u00117-\u0001\u0003vi&d'\"\u00013\u0002\t)\fg/Y\u0005\u0003M\u0006\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0003=\u0001(o\u001c3vG\u0016\u00148i\u001c8gS\u001e\u0004\u0013AD2p]N,X.\u001a:D_:4\u0017nZ\u0001\u0010G>t7/^7fe\u000e{gNZ5hA\u0005\u00192\u000f[1sK\u000e{gn];nKJ\u001cuN\u001c4jO\u0006!2\u000f[1sK\u000e{gn];nKJ\u001cuN\u001c4jO\u0002\nQc\u001d;sK\u0006l7oQ8ogVlWM]\"p]\u001aLw-\u0001\ftiJ,\u0017-\\:D_:\u001cX/\\3s\u0007>tg-[4!\u0003E\tG-\\5o\u00072LWM\u001c;D_:4\u0017nZ\u0001\u0013C\u0012l\u0017N\\\"mS\u0016tGoQ8oM&<\u0007%A\u000btkB,'/^:fe\u000ec\u0017.\u001a8u\u0007>tg-[4\u0002-M,\b/\u001a:vg\u0016\u00148\t\\5f]R\u001cuN\u001c4jO\u0002\nAb]3sm\u0016\u00148i\u001c8gS\u001e\fQb]3sm\u0016\u00148i\u001c8gS\u001e\u0004\u0013\u0001E2p]R\u0014x\u000e\u001c7fe\u000e{gNZ5h\u0003E\u0019wN\u001c;s_2dWM]\"p]\u001aLw\rI\u0001\nG>t7/^7feN,\u0012\u0001\u001f\t\u0005sz\f\t!D\u0001{\u0015\tYH0A\u0004nkR\f'\r\\3\u000b\u0005uD\u0016AC2pY2,7\r^5p]&\u0011qP\u001f\u0002\u0007\u0005V4g-\u001a:1\r\u0005\r\u0011\u0011EA\u001c!!\t)!!\u0007\u0002\u001e\u0005URBAA\u0004\u0015\u0011\tI!a\u0003\u0002\u0011\r|gn];nKJTA!!\u0004\u0002\u0010\u000591\r\\5f]R\u001c(bA$\u0002\u0012)!\u00111CA\u000b\u0003\u0019\t\u0007/Y2iK*\u0011\u0011qC\u0001\u0004_J<\u0017\u0002BA\u000e\u0003\u000f\u0011\u0001bQ8ogVlWM\u001d\t\u0005\u0003?\t\t\u0003\u0004\u0001\u0005\u0017\u0005\rR#!A\u0001\u0002\u000b\u0005\u0011q\u0005\u0002\u0004?\u0012\n\u0014AC2p]N,X.\u001a:tAE!\u0011\u0011FA\u0018!\r9\u00161F\u0005\u0004\u0003[A&a\u0002(pi\"Lgn\u001a\t\u0004/\u0006E\u0012bAA\u001a1\n\u0019\u0011I\\=\u0011\t\u0005}\u0011q\u0007\u0003\f\u0003s)\u0012\u0011!A\u0001\u0006\u0003\t9CA\u0002`II\nab\u001d5be\u0016\u001cuN\\:v[\u0016\u00148/\u0006\u0002\u0002@A!\u0011P`A!a\u0019\t\u0019%a\u0013\u0002TAA\u0011QAA#\u0003\u0013\n\t&\u0003\u0003\u0002H\u0005\u001d!!D*iCJ,7i\u001c8tk6,'\u000f\u0005\u0003\u0002 \u0005-CaCA'/\u0005\u0005\t\u0011!B\u0001\u0003O\u00111a\u0018\u00134\u0003=\u0019\b.\u0019:f\u0007>t7/^7feN\u0004\u0003\u0003BA\u0010\u0003'\"1\"!\u0016\u0018\u0003\u0003\u0005\tQ!\u0001\u0002(\t\u0019q\f\n\u001b\u0002!M$(/Z1ng\u000e{gn];nKJ\u001cXCAA.!\u0011Ih0!\u00181\r\u0005}\u00131MA6!!\t)!!\u0007\u0002b\u0005%\u0004\u0003BA\u0010\u0003G\"1\"!\u001a\u001a\u0003\u0003\u0005\tQ!\u0001\u0002(\t\u0019q\fJ\u001b\u0002#M$(/Z1ng\u000e{gn];nKJ\u001c\b\u0005\u0005\u0003\u0002 \u0005-DaCA73\u0005\u0005\t\u0011!B\u0001\u0003O\u00111a\u0018\u00137\u0003%\u0001(o\u001c3vG\u0016\u00148/\u0006\u0002\u0002tA!\u0011P`A;a\u0019\t9(!\"\u0002\u000eBA\u0011\u0011PA@\u0003\u0007\u000bY)\u0004\u0002\u0002|)!\u0011QPA\u0006\u0003!\u0001(o\u001c3vG\u0016\u0014\u0018\u0002BAA\u0003w\u0012QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\b\u0003BA\u0010\u0003\u000b#1\"a\"\u001c\u0003\u0003\u0005\tQ!\u0001\u0002(\t\u0019q\fJ\u001c\u0002\u0015A\u0014x\u000eZ;dKJ\u001c\b\u0005\u0005\u0003\u0002 \u00055EaCAH7\u0005\u0005\t\u0011!B\u0001\u0003O\u00111a\u0018\u00139\u00031\tG-\\5o\u00072LWM\u001c;t+\t\t)\n\u0005\u0003z}\u0006]\u0005\u0003BAM\u0003?k!!a'\u000b\t\u0005u\u00151B\u0001\u0006C\u0012l\u0017N\\\u0005\u0005\u0003C\u000bYJA\u0003BI6Lg.A\u0007bI6Lgn\u00117jK:$8\u000fI\u0001\u0018S:$XM\u001d\"s_.,'\u000fT5ti\u0016tWM\u001d(b[\u0016,\"!!+\u0011\t\u0005-\u0016QW\u0007\u0003\u0003[SA!a,\u00022\u00069a.\u001a;x_J\\'\u0002BAZ\u0003\u001f\taaY8n[>t\u0017\u0002BA\\\u0003[\u0013A\u0002T5ti\u0016tWM\u001d(b[\u0016\fQ\"\\8eS\u001aL8i\u001c8gS\u001e\u001cH\u0003BA_\u0003\u0007\u00042aVA`\u0013\r\t\t\r\u0017\u0002\u0005+:LG\u000fC\u0004\u0002F~\u0001\r!a2\u0002\u000bA\u0014x\u000e]:\u0011\u000b\u0005%\u00171Z0\u000e\u0003qL1!!4}\u0005\r\u0019V-]\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\u0011\u00111\u001b\t\u0007\u0003\u0013\fY-!6\u0011\t\u0005]\u0017Q\\\u0007\u0003\u00033T1!a7G\u0003\u0019\u0019XM\u001d<fe&!\u0011q\\Am\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002--\u0014\u0018M\u001a;D_:$(o\u001c7mKJ\u001cuN\u001c4jON$B!a2\u0002f\"9\u0011q]\u0011A\u0002\u0005%\u0018\u0001\u0003;fgRLeNZ8\u0011\t\u0005-\u0018q_\u0007\u0003\u0003[T1!RAx\u0015\u0011\t\t0a=\u0002\u000f),\b/\u001b;fe*!\u0011Q_A\u000b\u0003\u0015QWO\\5u\u0013\u0011\tI0!<\u0003\u0011Q+7\u000f^%oM>\f!cY8oM&<WO]3MSN$XM\\3sgR!\u0011QXA\u0000\u0011\u001d\t)M\ta\u0001\u0003\u000f\f\u0011%\u001b8tKJ$8i\u001c8ue>dG.\u001a:MSN$XM\\3sg&3g*Z3eK\u0012$B!!0\u0003\u0006!9\u0011QY\u0012A\u0002\u0005\u001d\u0017!B:fiV\u0003H\u0003BA_\u0005\u0017Aq!a:%\u0001\u0004\tI\u000fK\u0002%\u0005\u001f\u0001B!a;\u0003\u0012%!!1CAw\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u0011I>\u001cV\u000f]3skN,'oU3ukB$B!!0\u0003\u001a!9\u0011q]\u0013A\u0002\u0005%\u0018a\u00023p'\u0016$X\u000f\u001d\u000b\u0007\u0003{\u0013yB!\t\t\u000f\u0005\u001dh\u00051\u0001\u0002j\"9!1\u0005\u0014A\u0002\t\u0015\u0012AE2sK\u0006$Xm\u00144gg\u0016$8\u000fV8qS\u000e\u00042a\u0016B\u0014\u0013\r\u0011I\u0003\u0017\u0002\b\u0005>|G.Z1o\u0003M\u0019G.[3oiN+7-\u001e:jif\u0004&o\u001c9t)\ry&q\u0006\u0005\b\u0005c9\u0003\u0019\u0001B\u001a\u0003%\u0019WM\u001d;BY&\f7\u000f\u0005\u0003\u00036\t\rc\u0002\u0002B\u001c\u0005\u007f\u00012A!\u000fY\u001b\t\u0011YDC\u0002\u0003>!\u000ba\u0001\u0010:p_Rt\u0014b\u0001B!1\u00061\u0001K]3eK\u001aLAA!\u0012\u0003H\t11\u000b\u001e:j]\u001eT1A!\u0011Y\u0003Y\u0019X\u000f]3skN,'oU3dkJLG/\u001f)s_B\u001cHcA0\u0003N!9!\u0011\u0007\u0015A\u0002\tM\u0012AD2sK\u0006$X\r\u0015:pIV\u001cWM]\u000b\u0007\u0005'\u0012IFa\u0018\u0015\u0011\tU#1\rB:\u0005s\u0002\u0002\"!\u001f\u0002\u0000\t]#Q\f\t\u0005\u0003?\u0011I\u0006B\u0004\u0003\\%\u0012\r!a\n\u0003\u0003-\u0003B!a\b\u0003`\u00119!\u0011M\u0015C\u0002\u0005\u001d\"!\u0001,\t\u0013\t\u0015\u0014\u0006%AA\u0002\t\u001d\u0014!D6fsN+'/[1mSj,'\u000f\u0005\u0004\u0003j\t=$qK\u0007\u0003\u0005WRAA!\u001c\u00022\u0006i1/\u001a:jC2L'0\u0019;j_:LAA!\u001d\u0003l\tQ1+\u001a:jC2L'0\u001a:\t\u0013\tU\u0014\u0006%AA\u0002\t]\u0014a\u0004<bYV,7+\u001a:jC2L'0\u001a:\u0011\r\t%$q\u000eB/\u0011!\u0011Y(\u000bI\u0001\u0002\u0004y\u0016aD2p]\u001aLwm\u0014<feJLG-Z:\u00021\r\u0014X-\u0019;f!J|G-^2fe\u0012\"WMZ1vYR$\u0013'\u0006\u0004\u0003\u0002\nu%qT\u000b\u0003\u0005\u0007SCA!\"\u0003\fB!!\u0011\u000eBD\u0013\u0011\u0011IIa\u001b\u0003'\tKH/Z!se\u0006L8+\u001a:jC2L'0\u001a:,\u0005\t5\u0005\u0003\u0002BH\u00053k!A!%\u000b\t\tM%QS\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa&Y\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00057\u0013\tJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$qAa\u0017+\u0005\u0004\t9\u0003B\u0004\u0003b)\u0012\r!a\n\u00021\r\u0014X-\u0019;f!J|G-^2fe\u0012\"WMZ1vYR$#'\u0006\u0004\u0003\u0002\n\u0015&q\u0015\u0003\b\u00057Z#\u0019AA\u0014\t\u001d\u0011\tg\u000bb\u0001\u0003O\t\u0001d\u0019:fCR,\u0007K]8ek\u000e,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0019\u0011iK!-\u00034V\u0011!q\u0016\u0016\u0004?\n-Ea\u0002B.Y\t\u0007\u0011q\u0005\u0003\b\u0005Cb#\u0019AA\u0014\u00039\u0019'/Z1uK\u000e{gn];nKJ,bA!/\u0003@\n\rGC\u0003B^\u0005\u000b\u0014yM!6\u0003XBA\u0011QAA\r\u0005{\u0013\t\r\u0005\u0003\u0002 \t}Fa\u0002B.[\t\u0007\u0011q\u0005\t\u0005\u0003?\u0011\u0019\rB\u0004\u0003b5\u0012\r!a\n\t\u0013\t\u001dW\u0006%AA\u0002\t%\u0017aD6fs\u0012+7/\u001a:jC2L'0\u001a:\u0011\r\t%$1\u001aB_\u0013\u0011\u0011iMa\u001b\u0003\u0019\u0011+7/\u001a:jC2L'0\u001a:\t\u0013\tEW\u0006%AA\u0002\tM\u0017!\u0005<bYV,G)Z:fe&\fG.\u001b>feB1!\u0011\u000eBf\u0005\u0003D\u0001Ba\u001f.!\u0003\u0005\ra\u0018\u0005\n\u00053l\u0003\u0013!a\u0001\u00057\fqbY8oM&<7\u000fV8SK6|g/\u001a\t\u0007\u0005;\u00149Oa\r\u000f\t\t}'1\u001d\b\u0005\u0005s\u0011\t/C\u0001Z\u0013\r\u0011)\u000fW\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011IOa;\u0003\t1K7\u000f\u001e\u0006\u0004\u0005KD\u0016\u0001G2sK\u0006$XmQ8ogVlWM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU1!\u0011\u001fB~\u0005{,\"Aa=+\t\tU(1\u0012\t\u0005\u0005S\u001290\u0003\u0003\u0003z\n-$!\u0006\"zi\u0016\f%O]1z\t\u0016\u001cXM]5bY&TXM\u001d\u0003\b\u00057r#\u0019AA\u0014\t\u001d\u0011\tG\fb\u0001\u0003O\t\u0001d\u0019:fCR,7i\u001c8tk6,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0019\u0011\tpa\u0001\u0004\u0006\u00119!1L\u0018C\u0002\u0005\u001dBa\u0002B1_\t\u0007\u0011qE\u0001\u0019GJ,\u0017\r^3D_:\u001cX/\\3sI\u0011,g-Y;mi\u0012\u001aTC\u0002BW\u0007\u0017\u0019i\u0001B\u0004\u0003\\A\u0012\r!a\n\u0005\u000f\t\u0005\u0004G1\u0001\u0002(\u0005A2M]3bi\u0016\u001cuN\\:v[\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\r\rM1qCB\r+\t\u0019)B\u000b\u0003\u0003\\\n-Ea\u0002B.c\t\u0007\u0011q\u0005\u0003\b\u0005C\n$\u0019AA\u0014\u0003M\u0019'/Z1uKNC\u0017M]3D_:\u001cX/\\3s+\u0019\u0019yb!\n\u0004*QQ1\u0011EB\u0016\u0007_\u0019\u0019d!\u000e\u0011\u0011\u0005\u0015\u0011QIB\u0012\u0007O\u0001B!a\b\u0004&\u00119!1\f\u001aC\u0002\u0005\u001d\u0002\u0003BA\u0010\u0007S!qA!\u00193\u0005\u0004\t9\u0003C\u0005\u0003HJ\u0002\n\u00111\u0001\u0004.A1!\u0011\u000eBf\u0007GA\u0011B!53!\u0003\u0005\ra!\r\u0011\r\t%$1ZB\u0014\u0011!\u0011YH\rI\u0001\u0002\u0004y\u0006\"\u0003BmeA\u0005\t\u0019\u0001Bn\u0003u\u0019'/Z1uKNC\u0017M]3D_:\u001cX/\\3sI\u0011,g-Y;mi\u0012\nTC\u0002By\u0007w\u0019i\u0004B\u0004\u0003\\M\u0012\r!a\n\u0005\u000f\t\u00054G1\u0001\u0002(\u0005i2M]3bi\u0016\u001c\u0006.\u0019:f\u0007>t7/^7fe\u0012\"WMZ1vYR$#'\u0006\u0004\u0003r\u000e\r3Q\t\u0003\b\u00057\"$\u0019AA\u0014\t\u001d\u0011\t\u0007\u000eb\u0001\u0003O\tQd\u0019:fCR,7\u000b[1sK\u000e{gn];nKJ$C-\u001a4bk2$HeM\u000b\u0007\u0005[\u001bYe!\u0014\u0005\u000f\tmSG1\u0001\u0002(\u00119!\u0011M\u001bC\u0002\u0005\u001d\u0012!H2sK\u0006$Xm\u00155be\u0016\u001cuN\\:v[\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\r\rM11KB+\t\u001d\u0011YF\u000eb\u0001\u0003O!qA!\u00197\u0005\u0004\t9#A\u000bde\u0016\fG/Z*ue\u0016\fWn]\"p]N,X.\u001a:\u0016\r\rm31NB8)1\u0019if!\u001d\u0004v\re41PB?!!\u0019yf!\u001a\u0004j\r5TBAB1\u0015\u0011\u0019\u0019'a\u0002\u0002\u0013%tG/\u001a:oC2\u001c\u0018\u0002BB4\u0007C\u0012!#Q:z]\u000e\\\u0015MZ6b\u0007>t7/^7feB!\u0011qDB6\t\u001d\u0011Yf\u000eb\u0001\u0003O\u0001B!a\b\u0004p\u00119!\u0011M\u001cC\u0002\u0005\u001d\u0002\"\u0003BdoA\u0005\t\u0019AB:!\u0019\u0011IGa3\u0004j!I!\u0011[\u001c\u0011\u0002\u0003\u00071q\u000f\t\u0007\u0005S\u0012Ym!\u001c\t\u0011\tmt\u0007%AA\u0002}C\u0011B!78!\u0003\u0005\rAa7\t\u000f\r}t\u00071\u0001\u0004\u0002\u0006!2\u000f\u001e:fC6\u001c(+\u001a2bY\u0006t7-\u001a#bi\u0006\u0004Baa\u0018\u0004\u0004&!1QQB1\u0005Q\u0019FO]3b[N\u0014VMY1mC:\u001cW\rR1uC\u0006y2M]3bi\u0016\u001cFO]3b[N\u001cuN\\:v[\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\r\tE81RBG\t\u001d\u0011Y\u0006\u000fb\u0001\u0003O!qA!\u00199\u0005\u0004\t9#A\u0010de\u0016\fG/Z*ue\u0016\fWn]\"p]N,X.\u001a:%I\u00164\u0017-\u001e7uII*bA!=\u0004\u0014\u000eUEa\u0002B.s\t\u0007\u0011q\u0005\u0003\b\u0005CJ$\u0019AA\u0014\u0003}\u0019'/Z1uKN#(/Z1ng\u000e{gn];nKJ$C-\u001a4bk2$HeM\u000b\u0007\u0005[\u001bYj!(\u0005\u000f\tm#H1\u0001\u0002(\u00119!\u0011\r\u001eC\u0002\u0005\u001d\u0012aH2sK\u0006$Xm\u0015;sK\u0006l7oQ8ogVlWM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU111CBR\u0007K#qAa\u0017<\u0005\u0004\t9\u0003B\u0004\u0003bm\u0012\r!a\n\u0002#\r\u0014X-\u0019;f\u0003\u0012l\u0017N\\\"mS\u0016tG\u000f\u0006\u0004\u0002\u0018\u000e-6q\u0016\u0005\n\u0007[c\u0004\u0013!a\u0001\u0003S\u000bA\u0002\\5ti\u0016tWM\u001d(b[\u0016D\u0001Ba\u001f=!\u0003\u0005\raX\u0001\u001cGJ,\u0017\r^3BI6Lgn\u00117jK:$H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\rU&\u0006BAU\u0005\u0017\u000b1d\u0019:fCR,\u0017\tZ7j]\u000ec\u0017.\u001a8uI\u0011,g-Y;mi\u0012\u0012\u0014AG2sK\u0006$XmU;qKJ,8/\u001a:BI6Lgn\u00117jK:$HCBAL\u0007{\u001by\fC\u0005\u0004.~\u0002\n\u00111\u0001\u0002*\"A!1P \u0011\u0002\u0003\u0007q,\u0001\u0013de\u0016\fG/Z*va\u0016\u0014Xo]3s\u0003\u0012l\u0017N\\\"mS\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0003\u0011\u001a'/Z1uKN+\b/\u001a:vg\u0016\u0014\u0018\tZ7j]\u000ec\u0017.\u001a8uI\u0011,g-Y;mi\u0012\u0012\u0014\u0001\u0003;fCJ$un\u001e8\u0015\u0005\u0005u\u0006f\u0001\"\u0004LB!\u00111^Bg\u0013\u0011\u0019y-!<\u0003\u0013\u00053G/\u001a:FC\u000eD\u0007")
public abstract class IntegrationTestHarness
extends KafkaServerTestHarness {
    private final Properties producerConfig = new Properties();
    private final Properties consumerConfig = new Properties();
    private final Properties shareConsumerConfig = new Properties();
    private final Properties streamsConsumerConfig = new Properties();
    private final Properties adminClientConfig = new Properties();
    private final Properties superuserClientConfig = new Properties();
    private final Properties serverConfig = new Properties();
    private final Properties controllerConfig = new Properties();
    private final Buffer<Consumer<?, ?>> consumers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final Buffer<ShareConsumer<?, ?>> shareConsumers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final Buffer<Consumer<?, ?>> streamsConsumers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final Buffer<KafkaProducer<?, ?>> producers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final Buffer<Admin> adminClients = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);

    public abstract int brokerCount();

    public int logDirCount() {
        return 1;
    }

    public Properties producerConfig() {
        return this.producerConfig;
    }

    public Properties consumerConfig() {
        return this.consumerConfig;
    }

    public Properties shareConsumerConfig() {
        return this.shareConsumerConfig;
    }

    public Properties streamsConsumerConfig() {
        return this.streamsConsumerConfig;
    }

    public Properties adminClientConfig() {
        return this.adminClientConfig;
    }

    public Properties superuserClientConfig() {
        return this.superuserClientConfig;
    }

    public Properties serverConfig() {
        return this.serverConfig;
    }

    public Properties controllerConfig() {
        return this.controllerConfig;
    }

    private Buffer<Consumer<?, ?>> consumers() {
        return this.consumers;
    }

    private Buffer<ShareConsumer<?, ?>> shareConsumers() {
        return this.shareConsumers;
    }

    private Buffer<Consumer<?, ?>> streamsConsumers() {
        return this.streamsConsumers;
    }

    private Buffer<KafkaProducer<?, ?>> producers() {
        return this.producers;
    }

    private Buffer<Admin> adminClients() {
        return this.adminClients;
    }

    public ListenerName interBrokerListenerName() {
        return this.listenerName();
    }

    public void modifyConfigs(Seq<Properties> props) {
        props.foreach((Function1 & Serializable)x$1 -> {
            IntegrationTestHarness.$anonfun$modifyConfigs$1(this, x$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$1 = this.brokerCount();
        Some x$22 = new Some((Object)this.securityProtocol());
        Option<File> x$3 = this.trustStoreFile();
        Option<Properties> x$4 = this.serverSaslProperties();
        int x$5 = this.logDirCount();
        boolean x$6 = true;
        boolean x$7 = true;
        boolean x$8 = true;
        boolean x$9 = false;
        boolean x$10 = false;
        boolean x$11 = false;
        Map x$12 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        boolean x$13 = false;
        int x$14 = 1;
        short x$15 = 1;
        int x$16 = 0;
        boolean x$17 = false;
        Seq<Properties> cfgs = TestUtils$.MODULE$.createBrokerConfigs(x$1, x$6, x$7, (Option<SecurityProtocol>)x$22, x$3, x$4, x$8, x$9, x$10, x$11, (Map<Object, String>)x$12, x$5, x$13, x$14, x$15, x$16, x$17);
        this.configureListeners(cfgs);
        this.modifyConfigs(cfgs);
        cfgs.foreach((Function1 & Serializable)x$2 -> x$2.setProperty("metadata.log.dir", TestUtils.tempDirectory(null, null).getAbsolutePath()));
        this.insertControllerListenersIfNeeded(cfgs);
        return (Seq)cfgs.map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
    }

    @Override
    public Seq<Properties> kraftControllerConfigs(TestInfo testInfo) {
        return new .colon.colon((Object)this.controllerConfig(), (List)Nil$.MODULE$);
    }

    public void configureListeners(Seq<Properties> props) {
        props.foreach((Function1 & Serializable)config -> {
            config.remove("security.inter.broker.protocol");
            config.setProperty("inter.broker.listener.name", this.interBrokerListenerName().value());
            Set listenerNames = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ListenerName[]{this.listenerName(), this.interBrokerListenerName()}));
            String listeners = ((IterableOnceOps)listenerNames.map((Function1 & Serializable)listenerName -> listenerName.value() + "://localhost:" + TestUtils$.MODULE$.RandomPort())).mkString(",");
            String listenerSecurityMap = ((IterableOnceOps)listenerNames.map((Function1 & Serializable)listenerName -> listenerName.value() + ":" + $this.securityProtocol().name)).mkString(",");
            config.setProperty("listeners", listeners);
            config.setProperty("advertised.listeners", listeners);
            return config.setProperty("listener.security.protocol.map", listenerSecurityMap);
        });
    }

    private void insertControllerListenersIfNeeded(Seq<Properties> props) {
        props.foreach((Function1 & Serializable)config -> {
            Object[] securityPairs = config.getProperty("listener.security.protocol.map", "").split(",");
            Object[] toAdd = (String[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])config.getProperty("controller.listener.names", "").split(",")), arg_0 -> IntegrationTestHarness.$anonfun$insertControllerListenersIfNeeded$2$adapted((String[])securityPairs, arg_0));
            if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps(toAdd))) {
                return config.setProperty("listener.security.protocol.map", Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps(securityPairs), ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(toAdd), (Function1 & Serializable)e -> e + ":" + this.controllerListenerSecurityProtocol().toString(), ClassTag$.MODULE$.apply(String.class)), ClassTag$.MODULE$.apply(String.class))).mkString(","));
            }
            return BoxedUnit.UNIT;
        });
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.doSetup(testInfo, true);
    }

    public void doSuperuserSetup(TestInfo testInfo) {
        this.superuserClientConfig().put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
    }

    public void doSetup(TestInfo testInfo, boolean createOffsetsTopic) {
        Properties PropertiesOps_properties = this.producerConfig();
        Object var3_3 = null;
        new Implicits.PropertiesOps(PropertiesOps_properties).$plus$plus$eq(this.clientSecurityProps("producer"));
        Properties PropertiesOps_properties2 = this.consumerConfig();
        Object var4_4 = null;
        new Implicits.PropertiesOps(PropertiesOps_properties2).$plus$plus$eq(this.clientSecurityProps("consumer"));
        Properties PropertiesOps_properties3 = this.shareConsumerConfig();
        Object var5_5 = null;
        new Implicits.PropertiesOps(PropertiesOps_properties3).$plus$plus$eq(this.clientSecurityProps("shareConsumer"));
        Properties PropertiesOps_properties4 = this.adminClientConfig();
        Object var6_6 = null;
        new Implicits.PropertiesOps(PropertiesOps_properties4).$plus$plus$eq(this.clientSecurityProps("adminClient"));
        Properties PropertiesOps_properties5 = this.superuserClientConfig();
        Object var7_7 = null;
        new Implicits.PropertiesOps(PropertiesOps_properties5).$plus$plus$eq(this.superuserSecurityProps("superuserClient"));
        super.setUp(testInfo);
        this.producerConfig().put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        this.producerConfig().putIfAbsent("acks", "-1");
        this.producerConfig().putIfAbsent("key.serializer", ByteArraySerializer.class.getName());
        this.producerConfig().putIfAbsent("value.serializer", ByteArraySerializer.class.getName());
        this.consumerConfig().put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        this.consumerConfig().putIfAbsent("auto.offset.reset", "earliest");
        this.consumerConfig().putIfAbsent("group.id", "group");
        this.consumerConfig().putIfAbsent("key.deserializer", ByteArrayDeserializer.class.getName());
        this.consumerConfig().putIfAbsent("value.deserializer", ByteArrayDeserializer.class.getName());
        this.maybeGroupProtocolSpecified().map((Function1 & Serializable)groupProtocol -> this.consumerConfig().putIfAbsent("group.protocol", groupProtocol.name));
        this.shareConsumerConfig().put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        this.shareConsumerConfig().putIfAbsent("group.id", "group");
        this.shareConsumerConfig().putIfAbsent("key.deserializer", ByteArrayDeserializer.class.getName());
        this.shareConsumerConfig().putIfAbsent("value.deserializer", ByteArrayDeserializer.class.getName());
        this.streamsConsumerConfig().put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        this.streamsConsumerConfig().putIfAbsent("group.id", "group");
        this.streamsConsumerConfig().putIfAbsent("key.deserializer", ByteArrayDeserializer.class.getName());
        this.streamsConsumerConfig().putIfAbsent("value.deserializer", ByteArrayDeserializer.class.getName());
        this.adminClientConfig().put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        this.doSuperuserSetup(testInfo);
        if (createOffsetsTopic) {
            super.createOffsetsTopic(this.listenerName(), this.superuserClientConfig());
            return;
        }
    }

    public Properties clientSecurityProps(String certAlias) {
        return JaasTestUtils.securityConfigs(ConnectionMode.CLIENT, this.securityProtocol(), OptionConverters$.MODULE$.toJava(this.trustStoreFile()), certAlias, "localhost", OptionConverters$.MODULE$.toJava(this.clientSaslProperties()));
    }

    public Properties superuserSecurityProps(String certAlias) {
        return this.clientSecurityProps(certAlias);
    }

    public <K, V> KafkaProducer<K, V> createProducer(Serializer<K> keySerializer, Serializer<V> valueSerializer, Properties configOverrides) {
        Properties props = new Properties();
        new Implicits.PropertiesOps(props).$plus$plus$eq(this.producerConfig());
        new Implicits.PropertiesOps(props).$plus$plus$eq(configOverrides);
        KafkaProducer producer = new KafkaProducer(props, keySerializer, valueSerializer);
        this.producers().$plus$eq((Object)producer);
        return producer;
    }

    public <K, V> ByteArraySerializer createProducer$default$1() {
        return new ByteArraySerializer();
    }

    public <K, V> ByteArraySerializer createProducer$default$2() {
        return new ByteArraySerializer();
    }

    public <K, V> Properties createProducer$default$3() {
        return new Properties();
    }

    public <K, V> Consumer<K, V> createConsumer(Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, Properties configOverrides, List<String> configsToRemove) {
        if (!this.consumerConfig().containsKey("group.protocol")) {
            throw new IllegalStateException("Please specify the group.protocol configuration when creating a KafkaConsumer");
        }
        Properties props = new Properties();
        new Implicits.PropertiesOps(props).$plus$plus$eq(this.consumerConfig());
        new Implicits.PropertiesOps(props).$plus$plus$eq(configOverrides);
        configsToRemove.foreach((Function1 & Serializable)x$4 -> props.remove(x$4));
        KafkaConsumer consumer = new KafkaConsumer(props, keyDeserializer, valueDeserializer);
        this.consumers().$plus$eq((Object)consumer);
        return consumer;
    }

    public <K, V> ByteArrayDeserializer createConsumer$default$1() {
        return new ByteArrayDeserializer();
    }

    public <K, V> ByteArrayDeserializer createConsumer$default$2() {
        return new ByteArrayDeserializer();
    }

    public <K, V> Properties createConsumer$default$3() {
        return new Properties();
    }

    public <K, V> List<String> createConsumer$default$4() {
        return Nil$.MODULE$;
    }

    public <K, V> ShareConsumer<K, V> createShareConsumer(Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, Properties configOverrides, List<String> configsToRemove) {
        Properties props = new Properties();
        new Implicits.PropertiesOps(props).$plus$plus$eq(this.shareConsumerConfig());
        new Implicits.PropertiesOps(props).$plus$plus$eq(configOverrides);
        configsToRemove.foreach((Function1 & Serializable)x$5 -> props.remove(x$5));
        KafkaShareConsumer shareConsumer = new KafkaShareConsumer(props, keyDeserializer, valueDeserializer);
        this.shareConsumers().$plus$eq((Object)shareConsumer);
        return shareConsumer;
    }

    public <K, V> ByteArrayDeserializer createShareConsumer$default$1() {
        return new ByteArrayDeserializer();
    }

    public <K, V> ByteArrayDeserializer createShareConsumer$default$2() {
        return new ByteArrayDeserializer();
    }

    public <K, V> Properties createShareConsumer$default$3() {
        return new Properties();
    }

    public <K, V> List<String> createShareConsumer$default$4() {
        return Nil$.MODULE$;
    }

    public <K, V> AsyncKafkaConsumer<K, V> createStreamsConsumer(Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, Properties configOverrides, List<String> configsToRemove, StreamsRebalanceData streamsRebalanceData) {
        Properties props = new Properties();
        new Implicits.PropertiesOps(props).$plus$plus$eq(this.streamsConsumerConfig());
        new Implicits.PropertiesOps(props).$plus$plus$eq(configOverrides);
        configsToRemove.foreach((Function1 & Serializable)x$6 -> props.remove(x$6));
        AsyncKafkaConsumer streamsConsumer = new AsyncKafkaConsumer(new ConsumerConfig(ConsumerConfig.appendDeserializerToConfig((java.util.Map)Utils.castToStringObjectMap((java.util.Map)props), keyDeserializer, valueDeserializer)), keyDeserializer, valueDeserializer, Optional.of(streamsRebalanceData));
        this.streamsConsumers().$plus$eq((Object)streamsConsumer);
        return streamsConsumer;
    }

    public <K, V> ByteArrayDeserializer createStreamsConsumer$default$1() {
        return new ByteArrayDeserializer();
    }

    public <K, V> ByteArrayDeserializer createStreamsConsumer$default$2() {
        return new ByteArrayDeserializer();
    }

    public <K, V> Properties createStreamsConsumer$default$3() {
        return new Properties();
    }

    public <K, V> List<String> createStreamsConsumer$default$4() {
        return Nil$.MODULE$;
    }

    public Admin createAdminClient(ListenerName listenerName, Properties configOverrides) {
        Properties props = new Properties();
        new Implicits.PropertiesOps(props).$plus$plus$eq(this.adminClientConfig());
        new Implicits.PropertiesOps(props).$plus$plus$eq(configOverrides);
        Admin admin = TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, props);
        this.adminClients().$plus$eq((Object)admin);
        return admin;
    }

    public ListenerName createAdminClient$default$1() {
        return this.listenerName();
    }

    public Properties createAdminClient$default$2() {
        return new Properties();
    }

    public Admin createSuperuserAdminClient(ListenerName listenerName, Properties configOverrides) {
        Properties props = new Properties();
        new Implicits.PropertiesOps(props).$plus$plus$eq(this.superuserClientConfig());
        new Implicits.PropertiesOps(props).$plus$plus$eq(configOverrides);
        Admin admin = TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, props);
        this.adminClients().$plus$eq((Object)admin);
        return admin;
    }

    public ListenerName createSuperuserAdminClient$default$1() {
        return this.listenerName();
    }

    public Properties createSuperuserAdminClient$default$2() {
        return new Properties();
    }

    @Override
    @AfterEach
    public void tearDown() {
        try {
            this.producers().foreach((Function1 & Serializable)x$7 -> {
                x$7.close(Duration.ZERO);
                return BoxedUnit.UNIT;
            });
            this.consumers().foreach((Function1 & Serializable)x$8 -> {
                x$8.wakeup();
                return BoxedUnit.UNIT;
            });
            this.consumers().foreach((Function1 & Serializable)x$9 -> {
                x$9.close(Duration.ZERO);
                return BoxedUnit.UNIT;
            });
            this.shareConsumers().foreach((Function1 & Serializable)x$10 -> {
                x$10.wakeup();
                return BoxedUnit.UNIT;
            });
            this.shareConsumers().foreach((Function1 & Serializable)x$11 -> {
                x$11.close(Duration.ZERO);
                return BoxedUnit.UNIT;
            });
            this.streamsConsumers().foreach((Function1 & Serializable)x$12 -> {
                x$12.wakeup();
                return BoxedUnit.UNIT;
            });
            this.streamsConsumers().foreach((Function1 & Serializable)x$13 -> {
                x$13.close(Duration.ZERO);
                return BoxedUnit.UNIT;
            });
            this.adminClients().foreach((Function1 & Serializable)x$14 -> {
                x$14.close(Duration.ZERO);
                return BoxedUnit.UNIT;
            });
            this.producers().clear();
            this.consumers().clear();
            this.shareConsumers().clear();
            this.streamsConsumers().clear();
            this.adminClients().clear();
        }
        finally {
            super.tearDown();
        }
    }

    public static final /* synthetic */ void $anonfun$modifyConfigs$1(IntegrationTestHarness $this, Properties x$1) {
        new Implicits.PropertiesOps(x$1).$plus$plus$eq($this.serverConfig());
    }

    public static final /* synthetic */ boolean $anonfun$insertControllerListenersIfNeeded$2(String[] securityPairs$1, String e) {
        return !ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])securityPairs$1), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.startsWith(e + ":")));
    }

    public static final /* synthetic */ Object $anonfun$insertControllerListenersIfNeeded$2$adapted(String[] securityPairs$1, String e) {
        return BoxesRunTime.boxToBoolean((boolean)IntegrationTestHarness.$anonfun$insertControllerListenersIfNeeded$2(securityPairs$1, e));
    }
}

