/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kafka.api.BaseProducerSendTest;
import kafka.api.PlaintextProducerSendTest$;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.producer.BufferExhaustedException;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\u0005%e\u0001B\t\u0013\u0001]AQ\u0001\b\u0001\u0005\u0002uAQa\b\u0001\u0005\u0002\u0001BQa\u0014\u0001\u0005\u0002ACQ!\u0016\u0001\u0005\u0002YCQA\u001e\u0001\u0005\u0002]DQ\u0001 \u0001\u0005\u0002uDq!!\u0002\u0001\t\u0003\t9\u0001C\u0004\u0002\u0012\u0001!\t!a\u0005\t\u000f\u0005=\u0002\u0001\"\u0001\u00022!9\u0011q\b\u0001\u0005\u0002\u0005\u0005\u0003bBA(\u0001\u0011\u0005\u0011\u0011\u000b\u0005\b\u00037\u0002A\u0011AA/\u000f\u001d\t9G\u0005E\u0001\u0003S2a!\u0005\n\t\u0002\u0005-\u0004B\u0002\u000f\u000f\t\u0003\t\u0019\bC\u0004\u0002.9!\t!!\u001e\u00033Ac\u0017-\u001b8uKb$\bK]8ek\u000e,'oU3oIR+7\u000f\u001e\u0006\u0003'Q\t1!\u00199j\u0015\u0005)\u0012!B6bM.\f7\u0001A\n\u0003\u0001a\u0001\"!\u0007\u000e\u000e\u0003II!a\u0007\n\u0003)\t\u000b7/\u001a)s_\u0012,8-\u001a:TK:$G+Z:u\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002\u001a\u0001\u0005\u0019B/Z:u/J|gnZ*fe&\fG.\u001b>feR\u0011\u0011e\n\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0005+:LG\u000fC\u0003)\u0005\u0001\u0007\u0011&A\u0007he>,\b\u000f\u0015:pi>\u001cw\u000e\u001c\t\u0003UEr!aK\u0018\u0011\u00051\u001aS\"A\u0017\u000b\u000592\u0012A\u0002\u001fs_>$h(\u0003\u00021G\u00051\u0001K]3eK\u001aL!AM\u001a\u0003\rM#(/\u001b8h\u0015\t\u00014\u0005\u000b\u0003\u0003k\u0005\u0013\u0005C\u0001\u001c@\u001b\u00059$B\u0001\u001d:\u0003\u0019\u0001\u0018M]1ng*\u0011!hO\u0001\bUV\u0004\u0018\u000e^3s\u0015\taT(A\u0003kk:LGOC\u0001?\u0003\ry'oZ\u0005\u0003\u0001^\u0012\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u0003\r\u000bqd\u001f3jgBd\u0017-\u001f(b[\u0016lhf\u001a:pkB\u0004&o\u001c;pG>dWh\u001f\u0019~Q\u0011\u0011Qi\u0013'\u0011\u0005\u0019KU\"A$\u000b\u0005!;\u0014\u0001\u00039s_ZLG-\u001a:\n\u0005);%\u0001D'fi\"|GmU8ve\u000e,\u0017!\u0002<bYV,G&A'\"\u00039\u000b\u0011eZ3u)\u0016\u001cHo\u0012:pkB\u0004&o\u001c;pG>d\u0007+\u0019:b[\u0016$XM]:BY2\f\u0011\u0003^3ti\n\u000bGo\u00195TSj,',\u001a:p)\t\t\u0013\u000bC\u0003)\u0007\u0001\u0007\u0011\u0006\u000b\u0003\u0004k\u0005\u0013\u0005\u0006B\u0002F\u0017Rc\u0013!T\u0001(i\u0016\u001cHOQ1uG\"\u001c\u0016N_3[KJ|gj\u001c)beRLG/[8o\u001d>\u0014VmY8sI.+\u0017\u0010\u0006\u0002\"/\")\u0001\u0006\u0002a\u0001S!BA!W&_?\u0002\\G\u000e\u0005\u0002[96\t1L\u0003\u0002\u0014s%\u0011Ql\u0017\u0002\b)&lWm\\;u=\u0005y\u0011\u0001B;oSR$\u0013!Y\u0005\u0003E\u000e\fqaU#D\u001f:#5K\u0003\u0002eK\u0006AA+[7f+:LGO\u0003\u0002gO\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005!L\u0017\u0001B;uS2T\u0011A[\u0001\u0005U\u00064\u0018-\u0001\u0006uQJ,\u0017\rZ'pI\u0016$\u0013!\\\u0005\u0003]>\fqbU#Q\u0003J\u000bE+R0U\u0011J+\u0015\t\u0012\u0006\u0003aF\f!\u0002\u00165sK\u0006$Wj\u001c3f\u0015\t\u00118,A\u0004US6,w.\u001e;)\t\u0011)\u0014I\u0011\u0015\u0005\t\u0015[U\u000fL\u0001N\u0003)\"Xm\u001d;TK:$7i\\7qe\u0016\u001c8/\u001a3NKN\u001c\u0018mZ3XSRDGj\\4BaB,g\u000e\u001a+j[\u0016$\"!\t=\t\u000b!*\u0001\u0019A\u0015)\t\u0015)\u0014I\u0011\u0015\u0005\u000b\u0015[5\u0010L\u0001N\u00035\"Xm\u001d;TK:$gj\u001c8D_6\u0004(/Z:tK\u0012lUm]:bO\u0016<\u0016\u000e\u001e5M_\u001e\f\u0005\u000f]3oIRKW.\u001a\u000b\u0003CyDQ\u0001\u000b\u0004A\u0002%BCAB\u001bB\u0005\"*a!R&\u0002\u00041\nQ*A\nuKN$\u0018)\u001e;p\u0007J,\u0017\r^3U_BL7\rF\u0002\"\u0003\u0013AQ\u0001K\u0004A\u0002%BCaB\u001bB\u0005\"*q!R&\u0002\u00101\nQ*\u0001\u0016uKN$8+\u001a8e/&$\b.\u00138wC2LGMQ3g_J,\u0017I\u001c3BMR,'\u000fV5nKN$\u0018-\u001c9\u0015\u000f\u0005\n)\"a\u0006\u0002\u001c!)\u0001\u0006\u0003a\u0001S!1\u0011\u0011\u0004\u0005A\u0002%\na#\\3tg\u0006<W\rV5nKN#\u0018-\u001c9D_:4\u0017n\u001a\u0005\b\u0003;A\u0001\u0019AA\u0010\u0003=\u0011XmY8sIRKW.Z:uC6\u0004\bc\u0001\u0012\u0002\"%\u0019\u00111E\u0012\u0003\t1{gn\u001a\u0015\u0005\u0011U\n%\tK\u0003\t\u000b.\u000bI\u0003\f\u0002\u0002,\u0005\u0012\u0011QF\u0001\u0018i&lWm\u001d;b[B\u001cuN\u001c4jOB\u0013xN^5eKJ\fA\u0006^3tiZ\u000bG.\u001b3CK\u001a|'/Z!oI\u00063G/\u001a:US6,7\u000f^1naN\fE\u000f\u00165sKNDw\u000e\u001c3\u0015\u000f\u0005\n\u0019$!\u000e\u00028!)\u0001&\u0003a\u0001S!1\u0011\u0011D\u0005A\u0002%Bq!!\b\n\u0001\u0004\ty\u0002\u000b\u0003\nk\u0005\u0013\u0005&B\u0005F\u0017\u0006uBFAA\u0016\u0003A\"Xm\u001d;WC2LGMQ3g_J,\u0017I\u001c3BMR,'\u000fV5nKN$\u0018-\u001c9t/&$\b.\u001b8UQJ,7\u000f[8mIR9\u0011%a\u0011\u0002F\u0005\u001d\u0003\"\u0002\u0015\u000b\u0001\u0004I\u0003BBA\r\u0015\u0001\u0007\u0011\u0006C\u0004\u0002\u001e)\u0001\r!a\b)\t))\u0014I\u0011\u0015\u0006\u0015\u0015[\u0015Q\n\u0017\u0003\u0003W\tq\u0003^3ti:{gN\u00117pG.Lgn\u001a)s_\u0012,8-\u001a:\u0015\u0007\u0005\n\u0019\u0006C\u0003)\u0017\u0001\u0007\u0011\u0006\u000b\u0003\fk\u0005\u0013\u0005&B\u0006F\u0017\u0006eC&A'\u0002]Q,7\u000f^*f]\u0012\u0014VmY8sI\n\u000bGo\u00195XSRDW*\u0019=SKF,Xm\u001d;TSj,\u0017I\u001c3IS\u001eDWM\u001d\u000b\u0004C\u0005}\u0003\"\u0002\u0015\r\u0001\u0004I\u0003\u0006\u0002\u00076\u0003\nCS\u0001D#L\u0003Kb\u0013!T\u0001\u001a!2\f\u0017N\u001c;fqR\u0004&o\u001c3vG\u0016\u00148+\u001a8e)\u0016\u001cH\u000f\u0005\u0002\u001a\u001dM\u0019a\"!\u001c\u0011\u0007\t\ny'C\u0002\u0002r\r\u0012a!\u00118z%\u00164GCAA5+\t\t9\b\u0005\u0004\u0002z\u0005}\u00141Q\u0007\u0003\u0003wR1!! h\u0003\u0019\u0019HO]3b[&!\u0011\u0011QA>\u0005\u0019\u0019FO]3b[B\u0019a)!\"\n\u0007\u0005\u001duIA\u0005Be\u001e,X.\u001a8ug\u0002")
public class PlaintextProducerSendTest
extends BaseProducerSendTest {
    public static Stream<Arguments> timestampConfigProvider() {
        return PlaintextProducerSendTest$.MODULE$.timestampConfigProvider();
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testWrongSerializer(String groupProtocol) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        producerProps.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        producerProps.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        KafkaProducer<byte[], byte[]> producer = this.registerProducer((KafkaProducer<byte[], byte[]>)new KafkaProducer(producerProps));
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        Assertions.assertThrows(SerializationException.class, () -> producer.send(record));
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testBatchSizeZero(String groupProtocol) {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, 0, this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        this.sendAndVerify(producer, this.sendAndVerify$default$2(), this.sendAndVerify$default$3());
    }

    @Timeout(value=15L, unit=TimeUnit.SECONDS, threadMode=Timeout.ThreadMode.SEPARATE_THREAD)
    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testBatchSizeZeroNoPartitionNoRecordKey(String groupProtocol) {
        int x$2 = this.createProducer$default$1();
        int x$3 = this.createProducer$default$2();
        String x$4 = this.createProducer$default$4();
        long x$5 = this.createProducer$default$5();
        long x$6 = this.createProducer$default$6();
        int numRecords = 10;
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(x$2, x$3, 0, x$4, x$5, x$6);){
            TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), this.topic(), this.brokers(), this.controllerServers(), 2, 1, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
            IndexedSeq futures = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numRecords).map((Function1 & Serializable)i -> PlaintextProducerSendTest.$anonfun$testBatchSizeZeroNoPartitionNoRecordKey$1(this, producer, BoxesRunTime.unboxToInt((Object)i)));
            producer.flush();
            int lastOffset = BoxesRunTime.unboxToInt((Object)futures.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(offset, future) -> BoxesRunTime.boxToInteger((int)PlaintextProducerSendTest.$anonfun$testBatchSizeZeroNoPartitionNoRecordKey$2(this, BoxesRunTime.unboxToInt((Object)offset), future))));
            Assertions.assertEquals((int)numRecords, (int)lastOffset);
        }
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testSendCompressedMessageWithLogAppendTime(String groupProtocol) {
        int x$4 = this.createProducer$default$3();
        long x$5 = this.createProducer$default$5();
        long x$6 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, x$4, "gzip", x$5, x$6);
        this.sendAndVerifyTimestamp(producer, TimestampType.LOG_APPEND_TIME);
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testSendNonCompressedMessageWithLogAppendTime(String groupProtocol) {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        this.sendAndVerifyTimestamp(producer, TimestampType.LOG_APPEND_TIME);
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testAutoCreateTopic(String groupProtocol) {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            ProducerRecord record = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
            Assertions.assertEquals((long)0L, (long)((RecordMetadata)producer.send(record).get()).offset(), (String)"Should have offset 0");
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.admin(), this.topic(), 0, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        }
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"timestampConfigProvider"})
    public void testSendWithInvalidBeforeAndAfterTimestamp(String groupProtocol, String messageTimeStampConfig, long recordTimestamp) {
        Properties topicProps = new Properties();
        long oneMinuteInMs = 3600000L;
        topicProps.setProperty(messageTimeStampConfig, Long.toString(oneMinuteInMs));
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, 1, 2, (Map<Object, Seq<Object>>)x$8, topicProps);
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());){
            Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())).get()).getCause() instanceof InvalidTimestampException));
        }
        int x$10 = this.createProducer$default$1();
        int x$11 = this.createProducer$default$2();
        int x$12 = this.createProducer$default$3();
        long x$13 = this.createProducer$default$5();
        long x$14 = this.createProducer$default$6();
        try (KafkaProducer<byte[], byte[]> compressedProducer = this.createProducer(x$10, x$11, x$12, "gzip", x$13, x$14);){
            Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> compressedProducer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())).get()).getCause() instanceof InvalidTimestampException));
        }
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"timestampConfigProvider"})
    public void testValidBeforeAndAfterTimestampsAtThreshold(String groupProtocol, String messageTimeStampConfig, long recordTimestamp) {
        Properties topicProps = new Properties();
        topicProps.setProperty(messageTimeStampConfig, Long.toString(recordTimestamp));
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, 1, 2, (Map<Object, Seq<Object>>)x$8, topicProps);
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        Assertions.assertDoesNotThrow(() -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())));
        producer.close();
        int x$10 = this.createProducer$default$1();
        int x$11 = this.createProducer$default$2();
        int x$12 = this.createProducer$default$3();
        long x$13 = this.createProducer$default$5();
        long x$14 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> compressedProducer = this.createProducer(x$10, x$11, x$12, "gzip", x$13, x$14);
        Assertions.assertDoesNotThrow(() -> compressedProducer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())));
        compressedProducer.close();
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"timestampConfigProvider"})
    public void testValidBeforeAndAfterTimestampsWithinThreshold(String groupProtocol, String messageTimeStampConfig, long recordTimestamp) {
        Properties topicProps = new Properties();
        long tenMinutesInMs = 36000000L;
        topicProps.setProperty(messageTimeStampConfig, Long.toString(tenMinutesInMs));
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Buffer<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$8 = (Map)Map$.MODULE$.empty();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, 1, 2, (Map<Object, Seq<Object>>)x$8, topicProps);
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6());
        Assertions.assertDoesNotThrow(() -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())));
        producer.close();
        int x$10 = this.createProducer$default$1();
        int x$11 = this.createProducer$default$2();
        int x$12 = this.createProducer$default$3();
        long x$13 = this.createProducer$default$5();
        long x$14 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> compressedProducer = this.createProducer(x$10, x$11, x$12, "gzip", x$13, x$14);
        Assertions.assertDoesNotThrow(() -> compressedProducer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(recordTimestamp), (Object)"key".getBytes(), (Object)"value".getBytes())));
        compressedProducer.close();
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testNonBlockingProducer(String groupProtocol) {
        int x$2 = this.createProducer$default$1();
        int x$3 = this.createProducer$default$2();
        int x$4 = this.createProducer$default$3();
        String x$5 = this.createProducer$default$4();
        long x$6 = this.createProducer$default$6();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$2, x$3, x$4, x$5, 0L, x$6);
        PlaintextProducerSendTest.verifyMetadataNotAvailable$1(this.send$1(producer));
        Future future = this.sendUntilQueued$1(producer);
        this.verifySendSuccess$1(future);
        int x$11 = this.createProducer$default$2();
        String x$12 = this.createProducer$default$4();
        KafkaProducer<byte[], byte[]> producer2 = this.createProducer(15000, x$11, 1100, x$12, 0L, 1500L);
        Future future2 = this.sendUntilQueued$1(producer2);
        PlaintextProducerSendTest.verifyBufferExhausted$1(this.send$1(producer2));
        this.verifySendSuccess$1(future2);
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testSendRecordBatchWithMaxRequestSizeAndHigher(String groupProtocol) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        KafkaProducer<byte[], byte[]> producer = this.registerProducer((KafkaProducer<byte[], byte[]>)new KafkaProducer(producerProps, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer()));
        int keyLengthSize = 1;
        int headerLengthSize = 1;
        int valueLengthSize = 3;
        int overhead = 94 + keyLengthSize + headerLengthSize + valueLengthSize;
        int valueSize = 0x10000C - overhead;
        ProducerRecord record0 = new ProducerRecord(this.topic(), (Object)new byte[0], (Object)new byte[valueSize]);
        Assertions.assertEquals((int)((byte[])record0.value()).length, (int)((RecordMetadata)producer.send(record0).get()).serializedValueSize());
        ProducerRecord record1 = new ProducerRecord(this.topic(), (Object)new byte[0], (Object)new byte[valueSize + 1]);
        Assertions.assertEquals(RecordTooLargeException.class, Assertions.assertThrows(ExecutionException.class, () -> producer.send(record1).get()).getCause().getClass());
    }

    public static final /* synthetic */ Future $anonfun$testBatchSizeZeroNoPartitionNoRecordKey$1(PlaintextProducerSendTest $this, KafkaProducer producer$2, int i) {
        ProducerRecord record = new ProducerRecord($this.topic(), null, (Object)("value" + i).getBytes(StandardCharsets.UTF_8));
        return producer$2.send(record);
    }

    public static final /* synthetic */ int $anonfun$testBatchSizeZeroNoPartitionNoRecordKey$2(PlaintextProducerSendTest $this, int offset, Future future) {
        RecordMetadata recordMetadata = (RecordMetadata)future.get();
        Assertions.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
        return offset + 1;
    }

    private final Future send$1(KafkaProducer producer) {
        return producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)new byte[1000]));
    }

    public static final /* synthetic */ boolean $anonfun$testNonBlockingProducer$2(Future future) {
        if (future.isDone()) {
            try {
                future.get();
                return true;
            }
            catch (ExecutionException executionException) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final Future sendUntilQueued$1(KafkaProducer producer) {
        void var3_7;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            Future computeUntilTrue_result;
            if (PlaintextProducerSendTest.$anonfun$testNonBlockingProducer$2(computeUntilTrue_result = this.send$1(producer))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var10_5 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Future future = (Future)tuple22._1();
        return var3_7;
    }

    private final void verifySendSuccess$1(Future future) {
        RecordMetadata recordMetadata = (RecordMetadata)future.get(30L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)this.topic(), (Object)recordMetadata.topic());
        Assertions.assertEquals((int)0, (int)recordMetadata.partition());
        Assertions.assertTrue((recordMetadata.offset() >= 0L ? 1 : 0) != 0, (String)("Invalid offset " + recordMetadata));
    }

    private static final void verifyMetadataNotAvailable$1(Future future) {
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals(TimeoutException.class, Assertions.assertThrows(ExecutionException.class, () -> future.get()).getCause().getClass());
    }

    private static final void verifyBufferExhausted$1(Future future) {
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals(BufferExhaustedException.class, Assertions.assertThrows(ExecutionException.class, () -> future.get()).getCause().getClass());
    }

    public static final /* synthetic */ Object $anonfun$testNonBlockingProducer$2$adapted(Future future) {
        return BoxesRunTime.boxToBoolean((boolean)PlaintextProducerSendTest.$anonfun$testNonBlockingProducer$2(future));
    }
}

