/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMarkerChannelManager$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TxnMarkerQueue;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.transaction.TransactionState;
import org.apache.kafka.coordinator.transaction.TxnTransitMetadata;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.RequestLocal;
import org.apache.kafka.server.common.TransactionVersion;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.RequestAndCompletionHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedConstruction;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\t]d\u0001B!C\u0001%CQ\u0001\u0015\u0001\u0005\u0002ECq\u0001\u0016\u0001C\u0002\u0013%Q\u000b\u0003\u0004b\u0001\u0001\u0006IA\u0016\u0005\bE\u0002\u0011\r\u0011\"\u0003d\u0011\u0019Q\u0007\u0001)A\u0005I\"91\u000e\u0001b\u0001\n\u0013a\u0007B\u00029\u0001A\u0003%Q\u000eC\u0004r\u0001\t\u0007I\u0011\u0002:\t\re\u0004\u0001\u0015!\u0003t\u0011\u001dQ\bA1A\u0005\nIDaa\u001f\u0001!\u0002\u0013\u0019\bb\u0002?\u0001\u0005\u0004%I! \u0005\b\u0003\u0007\u0001\u0001\u0015!\u0003\u007f\u0011!\t)\u0001\u0001b\u0001\n\u0013i\bbBA\u0004\u0001\u0001\u0006IA \u0005\n\u0003\u0013\u0001!\u0019!C\u0005\u0003\u0017A\u0001\"!\b\u0001A\u0003%\u0011Q\u0002\u0005\n\u0003?\u0001!\u0019!C\u0005\u0003\u0017A\u0001\"!\t\u0001A\u0003%\u0011Q\u0002\u0005\n\u0003G\u0001!\u0019!C\u0005\u0003KA\u0001\"!\f\u0001A\u0003%\u0011q\u0005\u0005\n\u0003_\u0001!\u0019!C\u0005\u0003KA\u0001\"!\r\u0001A\u0003%\u0011q\u0005\u0005\n\u0003g\u0001!\u0019!C\u0005\u0003kA\u0001\"!\u0010\u0001A\u0003%\u0011q\u0007\u0005\n\u0003\u007f\u0001!\u0019!C\u0005\u0003kA\u0001\"!\u0011\u0001A\u0003%\u0011q\u0007\u0005\n\u0003\u0007\u0002!\u0019!C\u0005\u0003\u000bB\u0001\"!\u0014\u0001A\u0003%\u0011q\t\u0005\n\u0003\u001f\u0002!\u0019!C\u0005\u0003\u000bB\u0001\"!\u0015\u0001A\u0003%\u0011q\t\u0005\n\u0003'\u0002!\u0019!C\u0005\u0003\u000bB\u0001\"!\u0016\u0001A\u0003%\u0011q\t\u0005\n\u0003/\u0002!\u0019!C\u0005\u0003\u000bB\u0001\"!\u0017\u0001A\u0003%\u0011q\t\u0005\n\u00037\u0002!\u0019!C\u0005\u0003\u000bB\u0001\"!\u0018\u0001A\u0003%\u0011q\t\u0005\n\u0003?\u0002!\u0019!C\u0005\u0003CB\u0001\"a\u001c\u0001A\u0003%\u00111\r\u0005\n\u0003c\u0002!\u0019!C\u0005\u0003gB\u0001\"a\u001f\u0001A\u0003%\u0011Q\u000f\u0005\n\u0003{\u0002!\u0019!C\u0005\u0003gB\u0001\"a \u0001A\u0003%\u0011Q\u000f\u0005\n\u0003\u0003\u0003!\u0019!C\u0005\u0003\u0007C\u0001\"!+\u0001A\u0003%\u0011Q\u0011\u0005\n\u0003W\u0003!\u0019!C\u0005\u0003[C\u0001\"a/\u0001A\u0003%\u0011q\u0016\u0005\n\u0003{\u0003!\u0019!C\u0005\u0003\u007fC\u0001\"a2\u0001A\u0003%\u0011\u0011\u0019\u0005\b\u0003\u0013\u0004A\u0011BAf\u0011\u001d\ti\r\u0001C\u0001\u0003\u0017Dq!!:\u0001\t\u0003\t9\u000fC\u0004\u0003\u0018\u0001!\t!a3\t\u000f\tm\u0001\u0001\"\u0001\u0002L\"9!q\u0004\u0001\u0005\u0002\u0005-\u0007b\u0002B\u0012\u0001\u0011\u0005\u00111\u001a\u0005\b\u0005O\u0001A\u0011AAf\u0011\u001d\u0011Y\u0003\u0001C\u0001\u0003\u0017DqAa\f\u0001\t\u0003\u0011\t\u0004C\u0004\u0003<\u0001!\t!a3\t\u000f\t}\u0002\u0001\"\u0001\u0003B!9!1\n\u0001\u0005\n\t5\u0003b\u0002B5\u0001\u0011\u0005\u00111\u001a\u0005\b\u0005[\u0002A\u0011\u0002B8\u0005\r\"&/\u00198tC\u000e$\u0018n\u001c8NCJ\\WM]\"iC:tW\r\\'b]\u0006<WM\u001d+fgRT!a\u0011#\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003\u000b\u001a\u000b1bY8pe\u0012Lg.\u0019;pe*\tq)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0005CA&O\u001b\u0005a%\"A'\u0002\u000bM\u001c\u0017\r\\1\n\u0005=c%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002%B\u00111\u000bA\u0007\u0002\u0005\u0006iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016,\u0012A\u0016\t\u0003/~k\u0011\u0001\u0017\u0006\u00033j\u000b\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003\u000fnS!\u0001X/\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0016aA8sO&\u0011\u0001\r\u0017\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0002\u001d5,G/\u00193bi\u0006\u001c\u0015m\u00195fA\u0005ia.\u001a;x_J\\7\t\\5f]R,\u0012\u0001\u001a\t\u0003K\"l\u0011A\u001a\u0006\u0003Oj\u000bqa\u00197jK:$8/\u0003\u0002jM\nia*\u001a;x_J\\7\t\\5f]R\faB\\3uo>\u00148n\u00117jK:$\b%A\buq:\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s+\u0005i\u0007CA*o\u0013\ty'IA\fUe\u0006t7/Y2uS>t7\u000b^1uK6\u000bg.Y4fe\u0006\u0001B\u000f\u001f8Ti\u0006$X-T1oC\u001e,'\u000fI\u0001\u000ba\u0006\u0014H/\u001b;j_:\fT#A:\u0011\u0005Q<X\"A;\u000b\u0005YT\u0016AB2p[6|g.\u0003\u0002yk\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u00039beRLG/[8oc\u0001\n!\u0002]1si&$\u0018n\u001c83\u0003-\u0001\u0018M\u001d;ji&|gN\r\u0011\u0002\u000f\t\u0014xn[3scU\ta\u0010\u0005\u0002u\u007f&\u0019\u0011\u0011A;\u0003\t9{G-Z\u0001\tEJ|7.\u001a:2A\u00059!M]8lKJ\u0014\u0014\u0001\u00032s_.,'O\r\u0011\u0002!Q\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\fTCAA\u0007!\u0011\ty!!\u0007\u000e\u0005\u0005E!\u0002BA\n\u0003+\tA\u0001\\1oO*\u0011\u0011qC\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001c\u0005E!AB*ue&tw-A\tue\u0006t7/Y2uS>t\u0017\r\\%ec\u0001\n\u0001\u0003\u001e:b]N\f7\r^5p]\u0006d\u0017\n\u001a\u001a\u0002#Q\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\u0014\u0004%A\u0006qe>$WoY3s\u0013\u0012\fTCAA\u0014!\rY\u0015\u0011F\u0005\u0004\u0003Wa%\u0001\u0002'p]\u001e\fA\u0002\u001d:pIV\u001cWM]%ec\u0001\n1\u0002\u001d:pIV\u001cWM]%ee\u0005a\u0001O]8ek\u000e,'/\u001333A\u0005i\u0001O]8ek\u000e,'/\u00129pG\",\"!a\u000e\u0011\u0007-\u000bI$C\u0002\u0002<1\u0013Qa\u00155peR\fa\u0002\u001d:pIV\u001cWM]#q_\u000eD\u0007%A\tmCN$\bK]8ek\u000e,'/\u00129pG\"\f!\u0003\\1tiB\u0013x\u000eZ;dKJ,\u0005o\\2iA\u0005\u0011B\u000f\u001f8U_BL7\rU1si&$\u0018n\u001c82+\t\t9\u0005E\u0002L\u0003\u0013J1!a\u0013M\u0005\rIe\u000e^\u0001\u0014ibtGk\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0007I\u0001\u0013ibtGk\u001c9jGB\u000b'\u000f^5uS>t''A\nuq:$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0014\u0004%\u0001\td_>\u0014H-\u001b8bi>\u0014X\t]8dQ\u0006\t2m\\8sI&t\u0017\r^8s\u000bB|7\r\u001b\u0011\u0002#\r|wN\u001d3j]\u0006$xN]#q_\u000eD''\u0001\nd_>\u0014H-\u001b8bi>\u0014X\t]8dQJ\u0002\u0013\u0001\u0004;y]RKW.Z8vi6\u001b\u0018!\u0004;y]RKW.Z8vi6\u001b\b%A\u0005uq:\u0014Vm];miV\u0011\u00111\r\t\u0005\u0003K\nY'\u0004\u0002\u0002h)\u0019\u0011\u0011N;\u0002\u0011I,\u0017/^3tiNLA!!\u001c\u0002h\t\tBK]1og\u0006\u001cG/[8o%\u0016\u001cX\u000f\u001c;\u0002\u0015QDhNU3tk2$\b%\u0001\u0007uq:lU\r^1eCR\f\u0017'\u0006\u0002\u0002vA\u00191+a\u001e\n\u0007\u0005e$IA\nUe\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018-A\u0007uq:lU\r^1eCR\f\u0017\u0007I\u0001\ribtW*\u001a;bI\u0006$\u0018MM\u0001\u000eibtW*\u001a;bI\u0006$\u0018M\r\u0011\u0002-\r\f\u0007\u000f^;sK\u0012,%O]8sg\u000e\u000bG\u000e\u001c2bG.,\"!!\"\u0011\r\u0005\u001d\u0015QRAI\u001b\t\tIIC\u0002\u0002\fv\u000bq!\\8dW&$x.\u0003\u0003\u0002\u0010\u0006%%AD!sOVlWM\u001c;DCB$xN\u001d\t\b\u0017\u0006M\u0015qSAR\u0013\r\t)\n\u0014\u0002\n\rVt7\r^5p]F\u0002B!!'\u0002 6\u0011\u00111\u0014\u0006\u0004\u0003;+\u0018\u0001\u00039s_R|7m\u001c7\n\t\u0005\u0005\u00161\u0014\u0002\u0007\u000bJ\u0014xN]:\u0011\u0007-\u000b)+C\u0002\u0002(2\u0013A!\u00168ji\u000692-\u00199ukJ,G-\u0012:s_J\u001c8)\u00197mE\u0006\u001c7\u000eI\u0001\u0005i&lW-\u0006\u0002\u00020B!\u0011\u0011WA\\\u001b\t\t\u0019LC\u0002\u00026V\fQ!\u001e;jYNLA!!/\u00024\nAQj\\2l)&lW-A\u0003uS6,\u0007%\u0001\bdQ\u0006tg.\u001a7NC:\fw-\u001a:\u0016\u0005\u0005\u0005\u0007cA*\u0002D&\u0019\u0011Q\u0019\"\u0003?Q\u0013\u0018M\\:bGRLwN\\'be.,'o\u00115b]:,G.T1oC\u001e,'/A\bdQ\u0006tg.\u001a7NC:\fw-\u001a:!\u0003%iwnY6DC\u000eDW\r\u0006\u0002\u0002$\u0006AB/Z:u%\u0016lwN^3NKR\u0014\u0018nY:P]\u000ecwn]3)\u0007M\n\t\u000e\u0005\u0003\u0002T\u0006\u0005XBAAk\u0015\u0011\t9.!7\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\\\u0006u\u0017a\u00026va&$XM\u001d\u0006\u0004\u0003?l\u0016!\u00026v]&$\u0018\u0002BAr\u0003+\u0014A\u0001V3ti\u0006\u00013\u000f[8vY\u0012|e\u000e\\=Xe&$X\r\u0016=o\u0007>l\u0007\u000f\\3uS>twJ\\2f)\u0011\t\u0019+!;\t\u000f\u0005-H\u00071\u0001\u0002n\u00061\u0012n\u001d+sC:\u001c\u0018m\u0019;j_:4&'\u00128bE2,G\rE\u0002L\u0003_L1!!=M\u0005\u001d\u0011un\u001c7fC:D3\u0001NA{!\u0011\t90!@\u000e\u0005\u0005e(\u0002BA~\u00033\fa\u0001]1sC6\u001c\u0018\u0002BA\u0000\u0003s\u0014\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:uQ\u001d!$1\u0001B\b\u0005#\u0001BA!\u0002\u0003\f5\u0011!q\u0001\u0006\u0005\u0005\u0013\tI0\u0001\u0005qe>4\u0018\u000eZ3s\u0013\u0011\u0011iAa\u0002\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\tE>|G.Z1og2\"!1\u0003B\u000b3\u0005\t\u0011$\u0001\u0001\u0002GMDw.\u001e7e\u001d>$Hj\\:f)bt7i\\7qY\u0016$\u0018n\u001c8BMR,'\u000fT8bI\"\u001aQ'!5\u0002_MDw.\u001e7e\u000f\u0016tWM]1uK\u0016k\u0007\u000f^=NCB<\u0006.\u001a8O_J+\u0017/^3tiN|U\u000f^:uC:$\u0017N\\4)\u0007Y\n\t.\u0001\u0016tQ>,H\u000eZ$f]\u0016\u0014\u0018\r^3SKF,Xm\u001d;QKJ\u0004\u0016M\u001d;ji&|g\u000eU3s\u0005J|7.\u001a:)\u0007]\n\t.A\u0014tQ>,H\u000eZ*lSB\u001cVM\u001c3NCJ\\WM]:XQ\u0016tG*Z1eKJtu\u000e\u001e$pk:$\u0007f\u0001\u001d\u0002R\u0006\u00114\u000f[8vY\u0012\u001c\u0016M^3G_Jd\u0015\r^3s/\",g\u000eT3bI\u0016\u0014XK\\6o_^t')\u001e;O_R\fe/Y5mC\ndW\rK\u0002:\u0003#\f\u0001h\u001d5pk2$'+Z7pm\u0016l\u0015M]6feN4uN\u001d+y]B\u000b'\u000f^5uS>tw\u000b[3o!\u0006\u0014H/\u001b;j_:,U.[4sCR,G\rK\u0002;\u0003#\fqg\u001d5pk2$7i\\7qY\u0016$X-\u00119qK:$Gk\u001c'pO>sWI\u001c3Uq:<\u0006.\u001a8TK:$W*\u0019:lKJ\u001c8+^2dK\u0016$G\u0003BAR\u0005gAq!a;<\u0001\u0004\ti\u000fK\u0002<\u0003kDsa\u000fB\u0002\u0005\u001f\u0011I\u0004\f\u0003\u0003\u0014\tU\u0011!N:i_VdG-\u00112peR\f\u0005\u000f]3oIR{Gj\\4P]\u0016sG\r\u0016=o/\",gNT8u\u0007>|'\u000fZ5oCR|'/\u0012:s_JD3\u0001PAi\u0003y\u001a\bn\\;mIJ+GO]=BaB,g\u000e\u001a+p\u0019><wJ\\#oIRChn\u00165f]\u000e{wN\u001d3j]\u0006$xN\u001d(pi\u00063\u0018-\u001b7bE2,WI\u001d:peR!\u00111\u0015B\"\u0011\u001d\tY/\u0010a\u0001\u0003[D3!PA{Q\u001di$1\u0001B\b\u0005\u0013bCAa\u0005\u0003\u0016\u0005\t2M]3bi\u0016\u0004\u0016\u000eZ#se>\u0014X*\u00199\u0015\t\t=#Q\r\t\t\u0005#\u00129Fa\u0017\u0003`5\u0011!1\u000b\u0006\u0005\u0005+\n)\"\u0001\u0003vi&d\u0017\u0002\u0002B-\u0005'\u0012q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0003\u0002\u0010\tu\u0013\u0002BA\u0016\u0003#\u0001rA!\u0015\u0003bM\f9*\u0003\u0003\u0003d\tM#aA'ba\"9!q\r A\u0002\u0005]\u0015AB3se>\u00148/A\u000ftQ>,H\u000eZ\"sK\u0006$X-T3ue&\u001c7o\u00148Ti\u0006\u0014H/\u001b8hQ\ry\u0014\u0011[\u0001$C\u0012TWo\u001d;Ue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018MR8s-\u0016\u00148/[8o)\u0019\t\u0019K!\u001d\u0003t!9\u00111\u001e!A\u0002\u00055\bb\u0002B;\u0001\u0002\u0007\u0011QO\u0001\fibtW*\u001a;bI\u0006$\u0018\r")
public class TransactionMarkerChannelManagerTest {
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final NetworkClient networkClient = (NetworkClient)Mockito.mock(NetworkClient.class);
    private final TransactionStateManager txnStateManager = (TransactionStateManager)Mockito.mock(TransactionStateManager.class);
    private final TopicPartition partition1 = new TopicPartition("topic1", 0);
    private final TopicPartition partition2 = new TopicPartition("topic1", 1);
    private final Node broker1 = new Node(1, "host", 10);
    private final Node broker2 = new Node(2, "otherhost", 10);
    private final String transactionalId1;
    private final String transactionalId2;
    private final long producerId1;
    private final long producerId2;
    private final short producerEpoch = (short)0;
    private final short lastProducerEpoch = (short)-1;
    private final int txnTopicPartition1;
    private final int txnTopicPartition2;
    private final int coordinatorEpoch;
    private final int coordinatorEpoch2;
    private final int txnTimeoutMs;
    private final TransactionResult txnResult = TransactionResult.COMMIT;
    private final TransactionMetadata txnMetadata1 = new TransactionMetadata(this.transactionalId1(), this.producerId1(), this.producerId1(), -1L, this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), TransactionState.PREPARE_COMMIT, (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition1(), this.partition2()})), 0L, 0L, TransactionVersion.TV_2);
    private final TransactionMetadata txnMetadata2 = new TransactionMetadata(this.transactionalId2(), this.producerId2(), this.producerId2(), -1L, this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), TransactionState.PREPARE_COMMIT, (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition1()})), 0L, 0L, TransactionVersion.TV_2);
    private final ArgumentCaptor<Function1<Errors, BoxedUnit>> capturedErrorsCallback = ArgumentCaptor.forClass(Function1.class);
    private final MockTime time = new MockTime();
    private final TransactionMarkerChannelManager channelManager = new TransactionMarkerChannelManager(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false)), this.metadataCache(), this.networkClient(), this.txnStateManager(), (Time)this.time());

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    private TransactionStateManager txnStateManager() {
        return this.txnStateManager;
    }

    private TopicPartition partition1() {
        return this.partition1;
    }

    private TopicPartition partition2() {
        return this.partition2;
    }

    private Node broker1() {
        return this.broker1;
    }

    private Node broker2() {
        return this.broker2;
    }

    private String transactionalId1() {
        return this.transactionalId1;
    }

    private String transactionalId2() {
        return this.transactionalId2;
    }

    private long producerId1() {
        return this.producerId1;
    }

    private long producerId2() {
        return this.producerId2;
    }

    private short producerEpoch() {
        return this.producerEpoch;
    }

    private short lastProducerEpoch() {
        return this.lastProducerEpoch;
    }

    private int txnTopicPartition1() {
        return this.txnTopicPartition1;
    }

    private int txnTopicPartition2() {
        return this.txnTopicPartition2;
    }

    private int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    private int coordinatorEpoch2() {
        return this.coordinatorEpoch2;
    }

    private int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    private TransactionResult txnResult() {
        return this.txnResult;
    }

    private TransactionMetadata txnMetadata1() {
        return this.txnMetadata1;
    }

    private TransactionMetadata txnMetadata2() {
        return this.txnMetadata2;
    }

    private ArgumentCaptor<Function1<Errors, BoxedUnit>> capturedErrorsCallback() {
        return this.capturedErrorsCallback;
    }

    private MockTime time() {
        return this.time;
    }

    private TransactionMarkerChannelManager channelManager() {
        return this.channelManager;
    }

    private void mockCache() {
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.txnStateManager().partitionFor(this.transactionalId1()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.txnTopicPartition1()));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.txnStateManager().partitionFor(this.transactionalId2()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.txnTopicPartition2()));
        Mockito.when((Object)this.txnStateManager().getTransactionState((String)ArgumentMatchers.eq((Object)this.transactionalId1()))).thenReturn((Object)new Right((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))));
        Mockito.when((Object)this.txnStateManager().getTransactionState((String)ArgumentMatchers.eq((Object)this.transactionalId2()))).thenReturn((Object)new Right((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata2()))));
        Mockito.when((Object)this.metadataCache().metadataVersion()).thenReturn((Object)MetadataVersion.latestProduction());
    }

    @Test
    public void testRemoveMetricsOnClose() {
        try (MockedConstruction mockMetricsGroupCtor = Mockito.mockConstruction(KafkaMetricsGroup.class);){
            new TransactionMarkerChannelManager(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false)), this.metadataCache(), this.networkClient(), this.txnStateManager(), (Time)this.time()).shutdown();
            KafkaMetricsGroup mockMetricsGroup = (KafkaMetricsGroup)mockMetricsGroupCtor.constructed().get(0);
            TransactionMarkerChannelManager$.MODULE$.MetricNames().foreach((Function1 & Serializable)metricName -> ((KafkaMetricsGroup)Mockito.verify((Object)mockMetricsGroup)).newGauge((String)ArgumentMatchers.eq((Object)metricName), (Supplier)ArgumentMatchers.any()));
            TransactionMarkerChannelManager$.MODULE$.MetricNames().foreach((Function1 & Serializable)x$1 -> {
                TransactionMarkerChannelManagerTest.$anonfun$testRemoveMetricsOnClose$2(mockMetricsGroup, x$1);
                return BoxedUnit.UNIT;
            });
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockMetricsGroup});
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldOnlyWriteTxnCompletionOnce(boolean isTransactionV2Enabled) {
        Future<Try> addMarkerFuture;
        this.mockCache();
        this.adjustTransactionMetadataForVersion(isTransactionV2Enabled, this.txnMetadata2());
        TxnTransitMetadata expectedTransition = this.txnMetadata2().prepareComplete(this.time().milliseconds());
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition1().topic()), ArgumentMatchers.eq((int)this.partition1().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn(Optional.of(this.broker1()));
        this.txnStateManager().appendTransactionToLog((String)ArgumentMatchers.eq((Object)this.transactionalId2()), ArgumentMatchers.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)ArgumentMatchers.eq((Object)expectedTransition), (Function1)this.capturedErrorsCallback().capture(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$2 -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldOnlyWriteTxnCompletionOnce$1(this, expectedTransition, x$2);
            return BoxedUnit.UNIT;
        });
        ExecutorService executor = Executors.newFixedThreadPool(1);
        this.txnMetadata2().lock().lock();
        try {
            addMarkerFuture = executor.submit(() -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), expectedTransition)));
            RequestHeader header = new RequestHeader(ApiKeys.WRITE_TXN_MARKERS, 0, "client", 1);
            WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(Collections.singletonMap(Predef$.MODULE$.long2Long(this.producerId2()), Collections.singletonMap(this.partition1(), Errors.NONE)));
            ClientResponse clientResponse = new ClientResponse(header, null, null, this.time().milliseconds(), this.time().milliseconds(), false, null, null, (AbstractResponse)response);
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TransactionMarkerChannelManagerTest.$anonfun$shouldOnlyWriteTxnCompletionOnce$4(this, clientResponse)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for expected WriteTxnMarkers request");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
        finally {
            this.txnMetadata2().lock().unlock();
            executor.shutdown();
        }
        Assertions.assertNotNull(addMarkerFuture);
        Assertions.assertTrue((boolean)addMarkerFuture.get().isSuccess(), (String)("Add marker task failed with exception " + addMarkerFuture.get().get()));
        ((TransactionStateManager)Mockito.verify((Object)this.txnStateManager())).appendTransactionToLog((String)ArgumentMatchers.eq((Object)this.transactionalId2()), ArgumentMatchers.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)ArgumentMatchers.eq((Object)expectedTransition), (Function1)this.capturedErrorsCallback().capture(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
    }

    @Test
    public void shouldNotLoseTxnCompletionAfterLoad() {
        this.mockCache();
        TxnTransitMetadata expectedTransition = this.txnMetadata2().prepareComplete(this.time().milliseconds());
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition1().topic()), ArgumentMatchers.eq((int)this.partition1().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn(Optional.of(this.broker1()));
        RequestHeader header = new RequestHeader(ApiKeys.WRITE_TXN_MARKERS, 0, "client", 1);
        WriteTxnMarkersResponse successfulResponse = new WriteTxnMarkersResponse(Collections.singletonMap(Predef$.MODULE$.long2Long(this.producerId2()), Collections.singletonMap(this.partition1(), Errors.NONE)));
        ClientResponse successfulClientResponse = new ClientResponse(header, null, null, this.time().milliseconds(), this.time().milliseconds(), false, null, null, (AbstractResponse)successfulResponse);
        ClientResponse disconnectedClientResponse = new ClientResponse(header, null, null, this.time().milliseconds(), this.time().milliseconds(), true, null, null, null);
        .colon.colon clientResponses = new .colon.colon((Object)successfulClientResponse, (List)new .colon.colon((Object)disconnectedClientResponse, (List)Nil$.MODULE$));
        .colon.colon getTransactionStateResponses = new .colon.colon((Object)new Left((Object)Errors.NOT_COORDINATOR), (List)new .colon.colon((Object)new Left((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS), (List)new .colon.colon((Object)new Right((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch2(), this.txnMetadata2()))), (List)Nil$.MODULE$)));
        clientResponses.foreach(arg_0 -> TransactionMarkerChannelManagerTest.$anonfun$shouldNotLoseTxnCompletionAfterLoad$1$adapted(this, (Seq)getTransactionStateResponses, expectedTransition, successfulClientResponse, arg_0));
    }

    @Test
    public void shouldGenerateEmptyMapWhenNoRequestsOutstanding() {
        Assertions.assertTrue((boolean)this.channelManager().generateRequests().isEmpty());
    }

    @Test
    public void shouldGenerateRequestPerPartitionPerBroker() {
        this.mockCache();
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition1().topic()), ArgumentMatchers.eq((int)this.partition1().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn(Optional.of(this.broker1()));
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition2().topic()), ArgumentMatchers.eq((int)this.partition2().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn(Optional.of(this.broker2()));
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), this.txnMetadata2().prepareComplete(this.time().milliseconds()));
        Assertions.assertEquals((int)2, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)2, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        WriteTxnMarkersRequest expectedBroker1Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(Arrays.asList(new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList(this.partition1())), new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId2(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList(this.partition1())))).build();
        WriteTxnMarkersRequest expectedBroker2Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(Arrays.asList(new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList(this.partition2())))).build();
        scala.collection.immutable.Map requests = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.channelManager().generateRequests()).asScala().map((Function1 & Serializable)handler -> new Tuple2((Object)handler.destination, (Object)((WriteTxnMarkersRequest.Builder)handler.request).build()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.broker1()), (Object)expectedBroker1Request), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.broker2()), (Object)expectedBroker2Request)})), (Object)requests);
        Assertions.assertTrue((boolean)this.channelManager().generateRequests().isEmpty());
    }

    @Test
    public void shouldSkipSendMarkersWhenLeaderNotFound() {
        this.mockCache();
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition1().topic()), ArgumentMatchers.eq((int)this.partition1().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn(Optional.empty());
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition2().topic()), ArgumentMatchers.eq((int)this.partition2().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn(Optional.of(this.broker2()));
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        Assertions.assertEquals((int)1, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assertions.assertTrue((boolean)this.channelManager().queueForBroker(this.broker1().id()).isEmpty());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
    }

    @Test
    public void shouldSaveForLaterWhenLeaderUnknownButNotAvailable() {
        this.mockCache();
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition1().topic()), ArgumentMatchers.eq((int)this.partition1().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn(Optional.of(Node.noNode())).thenReturn(Optional.of(Node.noNode())).thenReturn(Optional.of(Node.noNode())).thenReturn(Optional.of(Node.noNode())).thenReturn(Optional.of(this.broker1())).thenReturn(Optional.of(this.broker1()));
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition2().topic()), ArgumentMatchers.eq((int)this.partition2().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn(Optional.of(this.broker2()));
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), this.txnMetadata2().prepareComplete(this.time().milliseconds()));
        Assertions.assertEquals((int)2, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assertions.assertTrue((boolean)this.channelManager().queueForBroker(this.broker1().id()).isEmpty());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        Assertions.assertEquals((int)2, (int)this.channelManager().queueForUnknownBroker().totalNumMarkers());
        Assertions.assertEquals((int)1, (int)this.channelManager().queueForUnknownBroker().totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)1, (int)this.channelManager().queueForUnknownBroker().totalNumMarkers(this.txnTopicPartition2()));
        WriteTxnMarkersRequest expectedBroker1Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(Arrays.asList(new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList(this.partition1())), new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId2(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList(this.partition1())))).build();
        WriteTxnMarkersRequest expectedBroker2Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(Arrays.asList(new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList(this.partition2())))).build();
        scala.collection.immutable.Map firstDrainedRequests = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.channelManager().generateRequests()).asScala().map((Function1 & Serializable)handler -> new Tuple2((Object)handler.destination, (Object)((WriteTxnMarkersRequest.Builder)handler.request).build()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.broker2()), (Object)expectedBroker2Request)})), (Object)firstDrainedRequests);
        scala.collection.immutable.Map secondDrainedRequests = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.channelManager().generateRequests()).asScala().map((Function1 & Serializable)handler -> new Tuple2((Object)handler.destination, (Object)((WriteTxnMarkersRequest.Builder)handler.request).build()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.broker1()), (Object)expectedBroker1Request)})), (Object)secondDrainedRequests);
    }

    @Test
    public void shouldRemoveMarkersForTxnPartitionWhenPartitionEmigrated() {
        this.mockCache();
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition1().topic()), ArgumentMatchers.eq((int)this.partition1().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn(Optional.of(this.broker1()));
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition2().topic()), ArgumentMatchers.eq((int)this.partition2().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn(Optional.of(this.broker2()));
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), this.txnMetadata2().prepareComplete(this.time().milliseconds()));
        Assertions.assertEquals((int)2, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)2, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        this.channelManager().removeMarkersForTxnTopicPartition(this.txnTopicPartition1());
        Assertions.assertEquals((int)1, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldCompleteAppendToLogOnEndTxnWhenSendMarkersSucceed(boolean isTransactionV2Enabled) {
        this.mockCache();
        this.adjustTransactionMetadataForVersion(isTransactionV2Enabled, this.txnMetadata2());
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition1().topic()), ArgumentMatchers.eq((int)this.partition1().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn(Optional.of(this.broker1()));
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition2().topic()), ArgumentMatchers.eq((int)this.partition2().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn(Optional.of(this.broker2()));
        TxnTransitMetadata txnTransitionMetadata2 = this.txnMetadata2().prepareComplete(this.time().milliseconds());
        this.txnStateManager().appendTransactionToLog((String)ArgumentMatchers.eq((Object)this.transactionalId2()), ArgumentMatchers.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)ArgumentMatchers.eq((Object)txnTransitionMetadata2), (Function1)this.capturedErrorsCallback().capture(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$3 -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldCompleteAppendToLogOnEndTxnWhenSendMarkersSucceed$1(this, txnTransitionMetadata2, x$3);
            return BoxedUnit.UNIT;
        });
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), txnTransitionMetadata2);
        Iterable requestAndHandlers = CollectionConverters$.MODULE$.CollectionHasAsScala(this.channelManager().generateRequests()).asScala();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createPidErrorMap(Errors.NONE));
        requestAndHandlers.foreach((Function1 & Serializable)requestAndHandler -> {
            requestAndHandler.handler.onComplete(new ClientResponse(new RequestHeader(ApiKeys.WRITE_TXN_MARKERS, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
            return BoxedUnit.UNIT;
        });
        ((TransactionStateManager)Mockito.verify((Object)this.txnStateManager())).appendTransactionToLog((String)ArgumentMatchers.eq((Object)this.transactionalId2()), ArgumentMatchers.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)ArgumentMatchers.eq((Object)txnTransitionMetadata2), (Function1)this.capturedErrorsCallback().capture(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Assertions.assertEquals((int)0, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.txnMetadata2().pendingState());
        Assertions.assertEquals((Object)TransactionState.COMPLETE_COMMIT, (Object)this.txnMetadata2().state());
    }

    @Test
    public void shouldAbortAppendToLogOnEndTxnWhenNotCoordinatorError() {
        this.mockCache();
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition1().topic()), ArgumentMatchers.eq((int)this.partition1().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn(Optional.of(this.broker1()));
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition2().topic()), ArgumentMatchers.eq((int)this.partition2().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn(Optional.of(this.broker2()));
        TxnTransitMetadata txnTransitionMetadata2 = this.txnMetadata2().prepareComplete(this.time().milliseconds());
        this.txnStateManager().appendTransactionToLog((String)ArgumentMatchers.eq((Object)this.transactionalId2()), ArgumentMatchers.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)ArgumentMatchers.eq((Object)txnTransitionMetadata2), (Function1)this.capturedErrorsCallback().capture(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$4 -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldAbortAppendToLogOnEndTxnWhenNotCoordinatorError$1(this, x$4);
            return BoxedUnit.UNIT;
        });
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), txnTransitionMetadata2);
        Iterable requestAndHandlers = CollectionConverters$.MODULE$.CollectionHasAsScala(this.channelManager().generateRequests()).asScala();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createPidErrorMap(Errors.NONE));
        requestAndHandlers.foreach((Function1 & Serializable)requestAndHandler -> {
            requestAndHandler.handler.onComplete(new ClientResponse(new RequestHeader(ApiKeys.WRITE_TXN_MARKERS, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
            return BoxedUnit.UNIT;
        });
        ((TransactionStateManager)Mockito.verify((Object)this.txnStateManager())).appendTransactionToLog((String)ArgumentMatchers.eq((Object)this.transactionalId2()), ArgumentMatchers.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)ArgumentMatchers.eq((Object)txnTransitionMetadata2), (Function1)this.capturedErrorsCallback().capture(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Assertions.assertEquals((int)0, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.txnMetadata2().pendingState());
        Assertions.assertEquals((Object)TransactionState.PREPARE_COMMIT, (Object)this.txnMetadata2().state());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError(boolean isTransactionV2Enabled) {
        this.mockCache();
        this.adjustTransactionMetadataForVersion(isTransactionV2Enabled, this.txnMetadata2());
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition1().topic()), ArgumentMatchers.eq((int)this.partition1().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn(Optional.of(this.broker1()));
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition2().topic()), ArgumentMatchers.eq((int)this.partition2().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn(Optional.of(this.broker2()));
        TxnTransitMetadata txnTransitionMetadata2 = this.txnMetadata2().prepareComplete(this.time().milliseconds());
        this.txnStateManager().appendTransactionToLog((String)ArgumentMatchers.eq((Object)this.transactionalId2()), ArgumentMatchers.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)ArgumentMatchers.eq((Object)txnTransitionMetadata2), (Function1)this.capturedErrorsCallback().capture(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$5 -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError$1(this, x$5);
            return BoxedUnit.UNIT;
        }).thenAnswer(x$6 -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError$2(this, txnTransitionMetadata2, x$6);
            return BoxedUnit.UNIT;
        });
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), txnTransitionMetadata2);
        Iterable requestAndHandlers = CollectionConverters$.MODULE$.CollectionHasAsScala(this.channelManager().generateRequests()).asScala();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createPidErrorMap(Errors.NONE));
        requestAndHandlers.foreach((Function1 & Serializable)requestAndHandler -> {
            requestAndHandler.handler.onComplete(new ClientResponse(new RequestHeader(ApiKeys.WRITE_TXN_MARKERS, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
            return BoxedUnit.UNIT;
        });
        this.channelManager().generateRequests();
        ((TransactionStateManager)Mockito.verify((Object)this.txnStateManager(), (VerificationMode)Mockito.times((int)2))).appendTransactionToLog((String)ArgumentMatchers.eq((Object)this.transactionalId2()), ArgumentMatchers.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)ArgumentMatchers.eq((Object)txnTransitionMetadata2), (Function1)this.capturedErrorsCallback().capture(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Assertions.assertEquals((int)0, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.txnMetadata2().pendingState());
        Assertions.assertEquals((Object)TransactionState.COMPLETE_COMMIT, (Object)this.txnMetadata2().state());
    }

    private HashMap<Long, Map<TopicPartition, Errors>> createPidErrorMap(Errors errors) {
        HashMap<Long, Map<TopicPartition, Errors>> pidMap = new HashMap<Long, Map<TopicPartition, Errors>>();
        HashMap<TopicPartition, Errors> errorsMap = new HashMap<TopicPartition, Errors>();
        errorsMap.put(this.partition1(), errors);
        pidMap.put(Predef$.MODULE$.long2Long(this.producerId2()), errorsMap);
        return pidMap;
    }

    @Test
    public void shouldCreateMetricsOnStarting() {
        scala.collection.mutable.Map metrics = CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Assertions.assertEquals((int)1, (int)metrics.count((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManagerTest.$anonfun$shouldCreateMetricsOnStarting$1(x0$1))));
        Assertions.assertEquals((int)1, (int)metrics.count((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManagerTest.$anonfun$shouldCreateMetricsOnStarting$2(x0$2))));
    }

    private void adjustTransactionMetadataForVersion(boolean isTransactionV2Enabled, TransactionMetadata txnMetadata) {
        if (isTransactionV2Enabled) {
            txnMetadata.clientTransactionVersion_$eq(TransactionVersion.TV_2);
            txnMetadata.producerEpoch_$eq((short)(this.producerEpoch() + 1));
            txnMetadata.lastProducerEpoch_$eq(this.producerEpoch());
            return;
        }
        txnMetadata.clientTransactionVersion_$eq(TransactionVersion.TV_1);
    }

    public static final /* synthetic */ void $anonfun$testRemoveMetricsOnClose$2(KafkaMetricsGroup mockMetricsGroup$1, String x$1) {
        ((KafkaMetricsGroup)Mockito.verify((Object)mockMetricsGroup$1)).removeMetric(x$1);
    }

    public static final /* synthetic */ void $anonfun$shouldOnlyWriteTxnCompletionOnce$1(TransactionMarkerChannelManagerTest $this, TxnTransitMetadata expectedTransition$1, InvocationOnMock x$2) {
        $this.txnMetadata2().completeTransitionTo(expectedTransition$1);
        ((Function1)$this.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
    }

    public static final /* synthetic */ boolean $anonfun$shouldOnlyWriteTxnCompletionOnce$4(TransactionMarkerChannelManagerTest $this, ClientResponse clientResponse$1) {
        Iterable requests = CollectionConverters$.MODULE$.CollectionHasAsScala($this.channelManager().generateRequests()).asScala();
        if (requests.nonEmpty()) {
            Assertions.assertEquals((int)1, (int)requests.size());
            ((RequestAndCompletionHandler)requests.head()).handler.onComplete(clientResponse$1);
            return true;
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$shouldOnlyWriteTxnCompletionOnce$5() {
        return "Timed out waiting for expected WriteTxnMarkers request";
    }

    public static final /* synthetic */ void $anonfun$shouldNotLoseTxnCompletionAfterLoad$2(TransactionMarkerChannelManagerTest $this, TxnTransitMetadata expectedTransition$2, ClientResponse clientResponse$2, ClientResponse successfulClientResponse$1, Either getTransactionStateResponse) {
        $this.txnMetadata2().topicPartitions().add((Object)$this.partition1());
        Mockito.clearInvocations((Object[])new TransactionStateManager[]{$this.txnStateManager()});
        $this.channelManager().addTxnMarkersToSend($this.coordinatorEpoch(), $this.txnResult(), $this.txnMetadata2(), expectedTransition$2);
        Iterable requests1 = CollectionConverters$.MODULE$.CollectionHasAsScala($this.channelManager().generateRequests()).asScala();
        Assertions.assertEquals((int)1, (int)requests1.size());
        $this.channelManager().removeMarkersForTxnTopicPartition($this.txnTopicPartition2());
        Mockito.when((Object)$this.txnStateManager().getTransactionState((String)ArgumentMatchers.eq((Object)$this.transactionalId2()))).thenReturn((Object)getTransactionStateResponse);
        $this.channelManager().addTxnMarkersToSend($this.coordinatorEpoch2(), $this.txnResult(), $this.txnMetadata2(), expectedTransition$2);
        ((RequestAndCompletionHandler)requests1.head()).handler.onComplete(clientResponse$2);
        Mockito.when((Object)$this.txnStateManager().getTransactionState((String)ArgumentMatchers.eq((Object)$this.transactionalId2()))).thenReturn((Object)new Right((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata($this.coordinatorEpoch2(), $this.txnMetadata2()))));
        Iterable requests2 = CollectionConverters$.MODULE$.CollectionHasAsScala($this.channelManager().generateRequests()).asScala();
        Assertions.assertEquals((int)1, (int)requests2.size());
        ((RequestAndCompletionHandler)requests2.head()).handler.onComplete(successfulClientResponse$1);
        ((TransactionStateManager)Mockito.verify((Object)$this.txnStateManager())).appendTransactionToLog((String)ArgumentMatchers.eq((Object)$this.transactionalId2()), ArgumentMatchers.eq((int)$this.coordinatorEpoch2()), (TxnTransitMetadata)ArgumentMatchers.eq((Object)expectedTransition$2), (Function1)$this.capturedErrorsCallback().capture(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
    }

    public static final /* synthetic */ void $anonfun$shouldCompleteAppendToLogOnEndTxnWhenSendMarkersSucceed$1(TransactionMarkerChannelManagerTest $this, TxnTransitMetadata txnTransitionMetadata2$1, InvocationOnMock x$3) {
        $this.txnMetadata2().completeTransitionTo(txnTransitionMetadata2$1);
        ((Function1)$this.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
    }

    public static final /* synthetic */ void $anonfun$shouldAbortAppendToLogOnEndTxnWhenNotCoordinatorError$1(TransactionMarkerChannelManagerTest $this, InvocationOnMock x$4) {
        $this.txnMetadata2().pendingState_$eq((Option)None$.MODULE$);
        ((Function1)$this.capturedErrorsCallback().getValue()).apply((Object)Errors.NOT_COORDINATOR);
    }

    public static final /* synthetic */ void $anonfun$shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError$1(TransactionMarkerChannelManagerTest $this, InvocationOnMock x$5) {
        ((Function1)$this.capturedErrorsCallback().getValue()).apply((Object)Errors.COORDINATOR_NOT_AVAILABLE);
    }

    public static final /* synthetic */ void $anonfun$shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError$2(TransactionMarkerChannelManagerTest $this, TxnTransitMetadata txnTransitionMetadata2$2, InvocationOnMock x$6) {
        $this.txnMetadata2().completeTransitionTo(txnTransitionMetadata2$2);
        ((Function1)$this.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
    }

    public static final /* synthetic */ boolean $anonfun$shouldCreateMetricsOnStarting$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            String string = ((MetricName)x0$1._1()).getMBeanName();
            String string2 = "kafka.coordinator.transaction:type=TransactionMarkerChannelManager,name=UnknownDestinationQueueSize";
            return string != null && string.equals(string2);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldCreateMetricsOnStarting$2(Tuple2 x0$2) {
        if (x0$2 != null) {
            String string = ((MetricName)x0$2._1()).getMBeanName();
            String string2 = "kafka.coordinator.transaction:type=TransactionMarkerChannelManager,name=LogAppendRetryQueueSize";
            return string != null && string.equals(string2);
        }
        throw new MatchError(null);
    }

    public TransactionMarkerChannelManagerTest() {
        this.transactionalId1 = "txnId1";
        this.transactionalId2 = "txnId2";
        this.producerId1 = 0;
        this.producerId2 = 1;
        this.txnTopicPartition1 = 0;
        this.txnTopicPartition2 = 1;
        this.coordinatorEpoch = 0;
        this.coordinatorEpoch2 = 1;
        this.txnTimeoutMs = 0;
    }

    public static final /* synthetic */ Object $anonfun$shouldNotLoseTxnCompletionAfterLoad$1$adapted(TransactionMarkerChannelManagerTest $this, Seq getTransactionStateResponses$1, TxnTransitMetadata expectedTransition$2, ClientResponse successfulClientResponse$1, ClientResponse clientResponse) {
        getTransactionStateResponses$1.foreach((Function1 & Serializable)getTransactionStateResponse -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldNotLoseTxnCompletionAfterLoad$2($this, expectedTransition$2, clientResponse, successfulClientResponse$1, getTransactionStateResponse);
            return BoxedUnit.UNIT;
        });
        return BoxedUnit.UNIT;
    }
}

