/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.network.Processor;
import kafka.server.ControllerServer;
import kafka.server.KafkaApis;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuorumTestHarness;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.UpdateFeaturesOptions;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.metadata.LeaderAndIsr;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.config.ReplicationConfigs;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\tMf\u0001\u0002\u001c8\u0001qBQa\u0011\u0001\u0005\u0002\u0011Cqa\u0012\u0001C\u0002\u0013\u0005\u0001\n\u0003\u0004P\u0001\u0001\u0006I!\u0013\u0005\b!\u0002\u0011\r\u0011\"\u0001I\u0011\u0019\t\u0006\u0001)A\u0005\u0013\"9!\u000b\u0001b\u0001\n\u0003\u0019\u0006BB,\u0001A\u0003%A\u000bC\u0005Y\u0001\u0001\u0007\t\u0019!C\u00013\"I!\r\u0001a\u0001\u0002\u0004%\ta\u0019\u0005\nS\u0002\u0001\r\u0011!Q!\niC\u0011B\u001b\u0001A\u0002\u0003\u0007I\u0011A-\t\u0013-\u0004\u0001\u0019!a\u0001\n\u0003a\u0007\"\u00038\u0001\u0001\u0004\u0005\t\u0015)\u0003[\u0011\u001dy\u0007\u00011A\u0005\u0002ADqA\u001f\u0001A\u0002\u0013\u00051\u0010\u0003\u0004~\u0001\u0001\u0006K!\u001d\u0005\b}\u0002\u0001\r\u0011\"\u0001\u0000\u0011%\tI\u0001\u0001a\u0001\n\u0003\tY\u0001\u0003\u0005\u0002\u0010\u0001\u0001\u000b\u0015BA\u0001\u0011-\t\t\u0002\u0001a\u0001\u0002\u0004%\t!a\u0005\t\u0017\u00055\u0002\u00011AA\u0002\u0013\u0005\u0011q\u0006\u0005\f\u0003g\u0001\u0001\u0019!A!B\u0013\t)\u0002C\u0005\u00026\u0001\u0011\r\u0011\"\u0001\u00028!A\u00111\t\u0001!\u0002\u0013\tI\u0004C\u0005\u0002F\u0001\u0011\r\u0011\"\u0001\u0002H!A\u0011Q\u000b\u0001!\u0002\u0013\tI\u0005\u0003\u0005\u0002X\u0001\u0011\r\u0011\"\u0001I\u0011\u001d\tI\u0006\u0001Q\u0001\n%C\u0011\"a\u0017\u0001\u0005\u0004%\t!!\u0018\t\u0011\u0005-\u0004\u0001)A\u0005\u0003?B\u0011\"!\u001c\u0001\u0005\u0004%\t!a\u001c\t\u0011\u0005\u0005\u0005\u0001)A\u0005\u0003cB\u0011\"a!\u0001\u0005\u0004%\t!a\u001c\t\u0011\u0005\u0015\u0005\u0001)A\u0005\u0003cBq!a\"\u0001\t\u0003\nI\tC\u0004\u0002,\u0002!\t%!,\t\u000f\u0005]\u0006\u0001\"\u0011\u0002:\"9\u0011q\u0018\u0001\u0005\n\u0005\u0005\u0007bBAd\u0001\u0011%\u0011Q\u0016\u0005\b\u0003\u0013\u0004A\u0011AAf\u0011\u001d\u0011y\u0001\u0001C\u0001\u0005#AqAa\u0007\u0001\t\u0003\u0011i\u0002C\u0004\u0003(\u0001!\tA!\u000b\t\u000f\tM\u0002\u0001\"\u0001\u00036!9!q\b\u0001\u0005\u0002\u00055\u0006b\u0002B!\u0001\u0011\u0005\u0011Q\u0016\u0005\b\u0005\u0007\u0002A\u0011\u0002B#\u0011\u001d\u0011\u0019\u0007\u0001C\u0005\u0005KBqAa\u001b\u0001\t\u0013\u0011i\u0007C\u0004\u0003x\u0001!\tA!\u001f\t\u000f\t\r\u0005\u0001\"\u0003\u0003\u0006\"9!q\u0013\u0001\u0005\n\te\u0005b\u0002BN\u0001\u0011%!Q\u0014\u0002\u001a+:\u001cG.Z1o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o)\u0016\u001cHO\u0003\u00029s\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0015\u0005Q\u0014!B6bM.\f7\u0001A\n\u0003\u0001u\u0002\"AP!\u000e\u0003}R!\u0001Q\u001d\u0002\rM,'O^3s\u0013\t\u0011uHA\tRk>\u0014X/\u001c+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#A#\u0011\u0005\u0019\u0003Q\"A\u001c\u0002\u0013\t\u0014xn[3s\u0013\u0012\fT#A%\u0011\u0005)kU\"A&\u000b\u00031\u000bQa]2bY\u0006L!AT&\u0003\u0007%sG/\u0001\u0006ce>\\WM]%ec\u0001\n\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u001a\u0002\u0015\t\u0014xn[3s\u0013\u0012\u0014\u0004%\u0001\rf]\u0006\u0014G.Z\"p]R\u0014x\u000e\u001c7fINCW\u000f\u001e3po:,\u0012\u0001\u0016\t\u0003\u0015VK!AV&\u0003\u000f\t{w\u000e\\3b]\u0006IRM\\1cY\u0016\u001cuN\u001c;s_2dW\rZ*ikR$wn\u001e8!\u00031\u0019wN\u001c4jOB\u0013x\u000e]:2+\u0005Q\u0006CA.a\u001b\u0005a&BA/_\u0003\u0011)H/\u001b7\u000b\u0003}\u000bAA[1wC&\u0011\u0011\r\u0018\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018\u0001E2p]\u001aLw\r\u0015:paN\ft\fJ3r)\t!w\r\u0005\u0002KK&\u0011am\u0013\u0002\u0005+:LG\u000fC\u0004i\u0013\u0005\u0005\t\u0019\u0001.\u0002\u0007a$\u0013'A\u0007d_:4\u0017n\u001a)s_B\u001c\u0018\u0007I\u0001\rG>tg-[4Qe>\u00048OM\u0001\u0011G>tg-[4Qe>\u00048OM0%KF$\"\u0001Z7\t\u000f!d\u0011\u0011!a\u00015\u0006i1m\u001c8gS\u001e\u0004&o\u001c9te\u0001\nqaY8oM&<7/F\u0001r!\r\u0011Xo^\u0007\u0002g*\u0011AoS\u0001\u000bG>dG.Z2uS>t\u0017B\u0001<t\u0005\r\u0019V-\u001d\t\u0003}aL!!_ \u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\fG>tg-[4t?\u0012*\u0017\u000f\u0006\u0002ey\"9\u0001nDA\u0001\u0002\u0004\t\u0018\u0001C2p]\u001aLwm\u001d\u0011\u0002\u000f\t\u0014xn[3sgV\u0011\u0011\u0011\u0001\t\u0005eV\f\u0019\u0001E\u0002?\u0003\u000bI1!a\u0002@\u0005-Y\u0015MZ6b\u0005J|7.\u001a:\u0002\u0017\t\u0014xn[3sg~#S-\u001d\u000b\u0004I\u00065\u0001\u0002\u00035\u0013\u0003\u0003\u0005\r!!\u0001\u0002\u0011\t\u0014xn[3sg\u0002\nQ!\u00193nS:,\"!!\u0006\u0011\t\u0005]\u0011\u0011F\u0007\u0003\u00033QA!!\u0005\u0002\u001c)!\u0011QDA\u0010\u0003\u001d\u0019G.[3oiNT1AOA\u0011\u0015\u0011\t\u0019#!\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t9#A\u0002pe\u001eLA!a\u000b\u0002\u001a\t)\u0011\tZ7j]\u0006I\u0011\rZ7j]~#S-\u001d\u000b\u0004I\u0006E\u0002\u0002\u00035\u0016\u0003\u0003\u0005\r!!\u0006\u0002\r\u0005$W.\u001b8!\u0003\u0019\u0011\u0018M\u001c3p[V\u0011\u0011\u0011\b\t\u0005\u0003w\ty$\u0004\u0002\u0002>)\u0011QlS\u0005\u0005\u0003\u0003\niD\u0001\u0004SC:$w.\\\u0001\be\u0006tGm\\7!\u0003\u0015!x\u000e]5d+\t\tI\u0005\u0005\u0003\u0002L\u0005ESBAA'\u0015\r\tyEX\u0001\u0005Y\u0006tw-\u0003\u0003\u0002T\u00055#AB*ue&tw-\u0001\u0004u_BL7\rI\u0001\fa\u0006\u0014H/\u001b;j_:LE-\u0001\u0007qCJ$\u0018\u000e^5p]&#\u0007%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0005\u0005}\u0003\u0003BA1\u0003Oj!!a\u0019\u000b\t\u0005\u0015\u0014qD\u0001\u0007G>lWn\u001c8\n\t\u0005%\u00141\r\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013aD6bM.\f\u0017\t]5t\u0019><w-\u001a:\u0016\u0005\u0005E\u0004\u0003BA:\u0003{j!!!\u001e\u000b\t\u0005]\u0014\u0011P\u0001\u0006Y><GG\u001b\u0006\u0005\u0003w\n\t#A\u0004m_\u001e<\u0017N\\4\n\t\u0005}\u0014Q\u000f\u0002\u0007\u0019><w-\u001a:\u0002!-\fgm[1Ba&\u001cHj\\4hKJ\u0004\u0013A\u00068fi^|'o\u001b)s_\u000e,7o]8s\u0019><w-\u001a:\u0002/9,Go^8sWB\u0013xnY3tg>\u0014Hj\\4hKJ\u0004\u0013!B:fiV\u0003Hc\u00013\u0002\f\"9\u0011QR\u0012A\u0002\u0005=\u0015\u0001\u0003;fgRLeNZ8\u0011\t\u0005E\u0015qT\u0007\u0003\u0003'SA!!&\u0002\u0018\u0006\u0019\u0011\r]5\u000b\t\u0005e\u00151T\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\ti*!\n\u0002\u000b),h.\u001b;\n\t\u0005\u0005\u00161\u0013\u0002\t)\u0016\u001cH/\u00138g_\"\u001a1%!*\u0011\t\u0005E\u0015qU\u0005\u0005\u0003S\u000b\u0019J\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002I\"\u001aA%!-\u0011\t\u0005E\u00151W\u0005\u0005\u0003k\u000b\u0019JA\u0005BMR,'/R1dQ\u000612N]1gi\u000e{g\u000e\u001e:pY2,'oQ8oM&<7\u000f\u0006\u0003\u0002<\u0006u\u0006c\u0001:v5\"9\u0011QR\u0013A\u0002\u0005=\u0015\u0001D:uCJ$(I]8lKJ\u001cHc\u00013\u0002D\"9\u0011Q\u0019\u0014A\u0002\u0005m\u0016aB2mkN$XM]\u0001\u001eI&\u001c\u0018M\u00197f\u000b2Lw-\u001b2mK2+\u0017\rZ3s%\u0016\u0004H.[2bg\u0006\u0001C/Z:u+:\u001cG.Z1o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o\u000b:\f'\r\\3e)\r!\u0017Q\u001a\u0005\b\u0003\u001fD\u0003\u0019AAi\u000359'o\\;q!J|Go\\2pYB!\u00111[Aq\u001d\u0011\t).!8\u0011\u0007\u0005]7*\u0004\u0002\u0002Z*\u0019\u00111\\\u001e\u0002\rq\u0012xn\u001c;?\u0013\r\tynS\u0001\u0007!J,G-\u001a4\n\t\u0005M\u00131\u001d\u0006\u0004\u0003?\\\u0005f\u0002\u0015\u0002h\u0006M\u0018Q\u001f\t\u0005\u0003S\fy/\u0004\u0002\u0002l*!\u0011Q^AL\u0003\u0019\u0001\u0018M]1ng&!\u0011\u0011_Av\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0005]\u0006lW-\t\u0002\u0002x\u0006y2\u0010Z5ta2\f\u0017PT1nKvtsM]8vaB\u0013x\u000e^8d_2l4\u0010M?)\u000f!\nYPa\u0002\u0003\nA!\u0011Q B\u0002\u001b\t\tyP\u0003\u0003\u0003\u0002\u0005-\u0018\u0001\u00039s_ZLG-\u001a:\n\t\t\u0015\u0011q \u0002\r\u001b\u0016$\bn\u001c3T_V\u00148-Z\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0005\u0017\t#A!\u0004\u0002C\u001d,G\u000fV3ti\u001e\u0013x.\u001e9Qe>$xnY8m!\u0006\u0014\u0018-\\3uKJ\u001c\u0018\t\u001c7\u0002CQ,7\u000f^+oG2,\u0017M\u001c'fC\u0012,'/\u00127fGRLwN\u001c#jg\u0006\u0014G.\u001a3\u0015\u0007\u0011\u0014\u0019\u0002C\u0004\u0002P&\u0002\r!!5)\u000f%\n9/a=\u0002v\":\u0011&a?\u0003\b\teAF\u0001B\u0006\u0003=\"Xm\u001d;V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8F]\u0006\u0014G.\u001a3CsR{\u0007/[2Pm\u0016\u0014(/\u001b3f)\r!'q\u0004\u0005\b\u0003\u001fT\u0003\u0019AAiQ\u001dQ\u0013q]Az\u0003kDsAKA~\u0005\u000f\u0011)\u0003\f\u0002\u0003\f\u0005\u0001D/Z:u+:\u001cG.Z1o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o\t&\u001c\u0018M\u00197fI\nKHk\u001c9jG>3XM\u001d:jI\u0016$2\u0001\u001aB\u0016\u0011\u001d\tym\u000ba\u0001\u0003#DsaKAt\u0003g\f)\u0010K\u0004,\u0003w\u00149A!\r-\u0005\t-\u0011!\f;fgR,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:LeN^1mS\u0012$v\u000e]5d\u001fZ,'O]5eKR\u0019AMa\u000e\t\u000f\u0005=G\u00061\u0001\u0002R\":A&a:\u0002t\u0006U\bf\u0002\u0017\u0002|\n\u001d!Q\b\u0017\u0003\u0005\u0017\t!E^3sS\u001aLXK\\2mK\u0006tG*Z1eKJ,E.Z2uS>tWI\\1cY\u0016$\u0017a\t<fe&4\u00170\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g\u000eR5tC\ndW\rZ\u0001\tO\u0016$x)Y;hKR!!q\tB0!\u0011\u0011IEa\u0017\u000e\u0005\t-#\u0002\u0002B'\u0005\u001f\nAaY8sK*!!\u0011\u000bB*\u0003\u001diW\r\u001e:jGNTAA!\u0016\u0003X\u00051\u00110Y7nKJT!A!\u0017\u0002\u0007\r|W.\u0003\u0003\u0003^\t-#!B'fi\u0016\u0014\bb\u0002B1_\u0001\u0007\u0011\u0011[\u0001\u000b[\u0016$(/[2OC6,\u0017AD:ikR$wn\u001e8Ce>\\WM\u001d\u000b\u0004I\n\u001d\u0004b\u0002B5a\u0001\u0007\u00111A\u0001\u0007EJ|7.\u001a:\u0002%\r|gn];nK\u0006cG.T3tg\u0006<Wm\u001d\u000b\u0007\u0005_\u0012\tHa\u001d\u0011\tI,\u0018\u0011\u001b\u0005\b\u0003\u000b\n\u0004\u0019AAi\u0011\u0019\u0011)(\ra\u0001\u0013\u0006Ya.^7NKN\u001c\u0018mZ3t\u0003e\"Xm\u001d;U_BL7-\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g.\u00128bE2,w+\u001b;i\u00032$XM\u001d+pa&\u001c7i\u001c8gS\u001e\u001cHc\u00013\u0003|!9\u0011q\u001a\u001aA\u0002\u0005E\u0007f\u0002\u001a\u0002h\u0006M\u0018Q\u001f\u0015\be\u0005m(q\u0001BAY\t\u0011Y!A\tbYR,'\u000fV8qS\u000e\u001cuN\u001c4jON$\u0002Ba\"\u0003\u000e\nE%1\u0013\t\u0005\u0003/\u0011I)\u0003\u0003\u0003\f\u0006e!AE!mi\u0016\u00148i\u001c8gS\u001e\u001c(+Z:vYRDqAa$4\u0001\u0004\t)\"A\u0006bI6Lgn\u00117jK:$\bbBA#g\u0001\u0007\u0011\u0011\u001b\u0005\u0007\u0005+\u001b\u0004\u0019\u0001.\u0002\u0019Q|\u0007/[2D_:4\u0017nZ:\u0002#\r\u0014X-\u0019;f\u0003\u0012l\u0017N\\\"mS\u0016tG\u000f\u0006\u0002\u0002\u0016\u0005\u0019s/Y5u\r>\u0014hj\u001c'fC\u0012,'/\u00118e\u0013N\u0014\b*Y:PY\u0012dU-\u00193fe&#G#\u00023\u0003 \n=\u0006b\u0002BQk\u0001\u0007!1U\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0011\t\t\u0015&1V\u0007\u0003\u0005OSAA!+\u0002 \u0005AQ.\u001a;bI\u0006$\u0018-\u0003\u0003\u0003.\n\u001d&!D'fi\u0006$\u0017\r^1DC\u000eDW\r\u0003\u0004\u00032V\u0002\r!S\u0001\tY\u0016\fG-\u001a:JI\u0002")
public class UncleanLeaderElectionTest
extends QuorumTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private final boolean enableControlledShutdown;
    private Properties configProps1;
    private Properties configProps2;
    private Seq<KafkaConfig> configs = (Seq)Seq$.MODULE$.empty();
    private Seq<KafkaBroker> brokers = (Seq)Seq$.MODULE$.empty();
    private Admin admin;
    private final Random random = new Random();
    private final String topic = "topic" + this.random().nextLong();
    private final int partitionId;
    private final TopicPartition topicPartition = new TopicPartition(this.topic(), this.partitionId());
    private final Logger kafkaApisLogger = LogManager.getLogger(KafkaApis.class);
    private final Logger networkProcessorLogger = LogManager.getLogger(Processor.class);

    public int brokerId1() {
        return this.brokerId1;
    }

    public int brokerId2() {
        return this.brokerId2;
    }

    public boolean enableControlledShutdown() {
        return this.enableControlledShutdown;
    }

    public Properties configProps1() {
        return this.configProps1;
    }

    public void configProps1_$eq(Properties x$1) {
        this.configProps1 = x$1;
    }

    public Properties configProps2() {
        return this.configProps2;
    }

    public void configProps2_$eq(Properties x$1) {
        this.configProps2 = x$1;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public void configs_$eq(Seq<KafkaConfig> x$1) {
        this.configs = x$1;
    }

    public Seq<KafkaBroker> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(Seq<KafkaBroker> x$1) {
        this.brokers = x$1;
    }

    public Admin admin() {
        return this.admin;
    }

    public void admin_$eq(Admin x$1) {
        this.admin = x$1;
    }

    public Random random() {
        return this.random;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Logger kafkaApisLogger() {
        return this.kafkaApisLogger;
    }

    public Logger networkProcessorLogger() {
        return this.networkProcessorLogger;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.configProps1_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        this.configProps2_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false));
        new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)configProps -> configProps.put("controlled.shutdown.enable", Boolean.toString(this.enableControlledShutdown())));
        Configurator.setLevel((String)this.kafkaApisLogger().getName(), (Level)Level.FATAL);
        Configurator.setLevel((String)this.networkProcessorLogger().getName(), (Level)Level.FATAL);
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.brokers().foreach((Function1 & Serializable)broker -> {
            this.shutdownBroker(broker);
            return BoxedUnit.UNIT;
        });
        this.brokers().foreach((Function1 & Serializable)broker -> {
            CoreUtils$.MODULE$.delete(broker.config().logDirs());
            return BoxedUnit.UNIT;
        });
        Configurator.setLevel((String)this.kafkaApisLogger().getName(), (Level)Level.ERROR);
        Configurator.setLevel((String)this.networkProcessorLogger().getName(), (Level)Level.ERROR);
        this.admin().close();
        super.tearDown();
    }

    @Override
    public Seq<Properties> kraftControllerConfigs(TestInfo testInfo) {
        Properties properties = new Properties();
        if (((Method)testInfo.getTestMethod().get()).getName().contains("testUncleanLeaderElectionEnabled")) {
            properties.setProperty("unclean.leader.election.enable", "true");
        }
        properties.setProperty("unclean.leader.election.interval.ms", "10");
        return new .colon.colon((Object)properties, (List)Nil$.MODULE$);
    }

    private void startBrokers(Seq<Properties> cluster) {
        cluster.foreach((Function1 & Serializable)props -> {
            UncleanLeaderElectionTest.$anonfun$startBrokers$1(this, props);
            return BoxedUnit.UNIT;
        });
        Properties adminConfigs = new Properties();
        this.admin_$eq(TestUtils$.MODULE$.createAdminClient(this.brokers(), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), adminConfigs));
    }

    private void disableEligibleLeaderReplicas() {
        if (this.metadataVersion().isAtLeast(MetadataVersion.IBP_4_1_IV0)) {
            this.admin().updateFeatures(java.util.Map.of("eligible.leader.replicas.version", new FeatureUpdate(0, FeatureUpdate.UpgradeType.SAFE_DOWNGRADE)), new UpdateFeaturesOptions()).all().get();
            return;
        }
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testUncleanLeaderElectionEnabled(String groupProtocol) {
        this.configProps1().put("unclean.leader.election.enable", "true");
        this.configProps2().put("unclean.leader.election.enable", "true");
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        this.disableEligibleLeaderReplicas();
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Seq<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$5 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}));
        int x$6 = 1;
        int x$7 = 1;
        Properties x$8 = new Properties();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$6, x$7, (Map<Object, Seq<Object>>)x$5, x$8);
        this.verifyUncleanLeaderElectionEnabled();
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testUncleanLeaderElectionDisabled(String groupProtocol) {
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        this.disableEligibleLeaderReplicas();
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Seq<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$5 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}));
        int x$6 = 1;
        int x$7 = 1;
        Properties x$8 = new Properties();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$6, x$7, (Map<Object, Seq<Object>>)x$5, x$8);
        this.verifyUncleanLeaderElectionDisabled();
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testUncleanLeaderElectionEnabledByTopicOverride(String groupProtocol) {
        this.configProps1().put("unclean.leader.election.enable", "false");
        this.configProps2().put("unclean.leader.election.enable", "false");
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        this.disableEligibleLeaderReplicas();
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "true");
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Seq<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$5 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}));
        int x$7 = 1;
        int x$8 = 1;
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$7, x$8, (Map<Object, Seq<Object>>)x$5, topicProps);
        this.verifyUncleanLeaderElectionEnabled();
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testUncleanLeaderElectionDisabledByTopicOverride(String groupProtocol) {
        this.configProps1().put("unclean.leader.election.enable", "true");
        this.configProps2().put("unclean.leader.election.enable", "true");
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        this.disableEligibleLeaderReplicas();
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "false");
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Seq<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$5 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}));
        int x$7 = 1;
        int x$8 = 1;
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$7, x$8, (Map<Object, Seq<Object>>)x$5, topicProps);
        this.verifyUncleanLeaderElectionDisabled();
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testUncleanLeaderElectionInvalidTopicOverride(String groupProtocol) {
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)Nil$.MODULE$));
        this.disableEligibleLeaderReplicas();
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "invalid");
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Admin x$1 = this.admin();
            String x$2 = this.topic();
            Seq<KafkaBroker> x$3 = this.brokers();
            Seq<ControllerServer> x$4 = this.controllerServers();
            Map x$5 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}));
            int x$7 = 1;
            int x$8 = 1;
            TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$7, x$8, (Map<Object, Seq<Object>>)x$5, topicProps);
        });
        Assertions.assertEquals(InvalidConfigurationException.class, e.getCause().getClass());
    }

    public void verifyUncleanLeaderElectionEnabled() {
        int leaderId = TestUtils$.MODULE$.awaitLeaderChange(this.brokers(), this.topicPartition(), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, 15000L);
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Leader for " + this.topic() + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(" is elected to be: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderId)})));
        Assertions.assertTrue((leaderId == this.brokerId1() || leaderId == this.brokerId2() ? 1 : 0) != 0, (String)("Leader id is set to expected value for topic: " + this.topic()));
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Follower for " + this.topic() + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(" is: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)followerId)})));
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "first", null, 30000, 20000);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic(), this.partitionId(), 15000L);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)Nil$.MODULE$), this.consumeAllMessages(this.topic(), 1));
        ((IterableOps)this.brokers().filter((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$3(followerId, broker)))).map((Function1 & Serializable)broker -> {
            this.shutdownBroker(broker);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "second", null, 30000, 20000);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
        Meter uncleanLeaderElectionsPerSecGauge = this.getGauge("UncleanLeaderElectionsPerSec");
        long uncleanLeaderElectionsPerSec = uncleanLeaderElectionsPerSecGauge.count();
        Assertions.assertEquals((long)0L, (long)uncleanLeaderElectionsPerSec);
        ((IterableOps)this.brokers().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$5(leaderId, x$4)))).map((Function1 & Serializable)broker -> {
            this.shutdownBroker(broker);
            return BoxedUnit.UNIT;
        });
        ((KafkaBroker)this.brokers().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$7(followerId, x$5))).get()).startup();
        Seq<KafkaBroker> x$1 = this.brokers();
        TopicPartition x$2 = this.topicPartition();
        Some x$3 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        None$ x$52 = None$.MODULE$;
        TestUtils$.MODULE$.awaitLeaderChange(x$1, x$2, (Option<Object>)x$52, (Option<Object>)x$3, 30000L);
        uncleanLeaderElectionsPerSec = uncleanLeaderElectionsPerSecGauge.count();
        Assertions.assertEquals((long)1L, (long)uncleanLeaderElectionsPerSec);
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "third", null, 30000, 20000);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"third", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
    }

    /*
     * WARNING - void declaration
     */
    public void verifyUncleanLeaderElectionDisabled() {
        int leaderId = TestUtils$.MODULE$.awaitLeaderChange(this.brokers(), this.topicPartition(), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, 15000L);
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Leader for " + this.topic() + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(" is elected to be: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderId)})));
        Assertions.assertTrue((leaderId == this.brokerId1() || leaderId == this.brokerId2() ? 1 : 0) != 0, (String)("Leader id is set to expected value for topic: " + this.topic()));
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Follower for " + this.topic() + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(" is: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)followerId)})));
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "first", null, 30000, 20000);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic(), this.partitionId(), 15000L);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)Nil$.MODULE$), this.consumeAllMessages(this.topic(), 1));
        ((IterableOps)this.brokers().filter((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$3(followerId, broker)))).map((Function1 & Serializable)broker -> {
            this.shutdownBroker(broker);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "second", null, 30000, 20000);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
        Meter uncleanLeaderElectionsPerSecGauge = this.getGauge("UncleanLeaderElectionsPerSec");
        long uncleanLeaderElectionsPerSec = uncleanLeaderElectionsPerSecGauge.count();
        Assertions.assertEquals((long)0L, (long)uncleanLeaderElectionsPerSec);
        ((IterableOps)this.brokers().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$5(leaderId, x$6)))).map((Function1 & Serializable)broker -> {
            this.shutdownBroker(broker);
            return BoxedUnit.UNIT;
        });
        KafkaBroker followerServer = (KafkaBroker)this.brokers().find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$7(followerId, x$7))).get();
        followerServer.startup();
        this.waitForNoLeaderAndIsrHasOldLeaderId(followerServer.replicaManager().metadataCache(), leaderId);
        uncleanLeaderElectionsPerSec = uncleanLeaderElectionsPerSecGauge.count();
        Assertions.assertEquals((long)0L, (long)uncleanLeaderElectionsPerSec);
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Seq<KafkaBroker> x$1 = this.brokers();
            String x$2 = this.topic();
            TestUtils$.MODULE$.produceMessage(x$1, x$2, "third", null, 1000, 1000);
        });
        Assertions.assertEquals(TimeoutException.class, e.getCause().getClass());
        Assertions.assertEquals((Object)package$.MODULE$.List().empty(), this.consumeAllMessages(this.topic(), 0));
        ((KafkaBroker)this.brokers().find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$9(leaderId, x$8))).get()).startup();
        Seq<KafkaBroker> x$72 = this.brokers();
        TopicPartition x$82 = this.topicPartition();
        Some x$92 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderId));
        None$ x$10 = None$.MODULE$;
        long x$11 = 15000L;
        TestUtils$.MODULE$.awaitLeaderChange(x$72, x$82, (Option<Object>)x$10, (Option<Object>)x$92, x$11);
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "third", null, 30000, 20000);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$10(this, followerServer, followerId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Inconsistent metadata after first server startup");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ((IterableOps)this.brokers().filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$12(leaderId, x$9)))).map((Function1 & Serializable)broker -> {
            this.shutdownBroker(broker);
            return BoxedUnit.UNIT;
        });
        Seq<KafkaBroker> x$12 = this.brokers();
        TopicPartition x$13 = this.topicPartition();
        Some x$14 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        None$ x$15 = None$.MODULE$;
        long x$16 = 15000L;
        TestUtils$.MODULE$.awaitLeaderChange(x$12, x$13, (Option<Object>)x$15, (Option<Object>)x$14, x$16);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)new .colon.colon((Object)"third", (List)Nil$.MODULE$))), this.consumeAllMessages(this.topic(), 3));
    }

    private Meter getGauge(String metricName) {
        return (Meter)((Tuple2)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$getGauge$1(metricName, x0$1))).getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)("Unable to find metric " + metricName));
        }))._2();
    }

    private void shutdownBroker(KafkaBroker broker) {
        broker.shutdown();
        broker.awaitShutdown();
    }

    private Seq<String> consumeAllMessages(String topic, int numMessages) {
        Seq seq;
        String brokerList = TestUtils$.MODULE$.plaintextBootstrapServers(this.brokers());
        GroupProtocol x$2 = this.groupProtocolFromTestParameters();
        String x$3 = "group" + this.random().nextLong();
        StringDeserializer x$5 = new StringDeserializer();
        String x$6 = "earliest";
        boolean x$7 = false;
        int x$8 = 500;
        SecurityProtocol x$9 = SecurityProtocol.PLAINTEXT;
        None$ x$102 = None$.MODULE$;
        None$ x$11 = None$.MODULE$;
        ByteArrayDeserializer x$12 = new ByteArrayDeserializer();
        try (Consumer consumer = TestUtils$.MODULE$.createConsumer(brokerList, x$2, x$3, x$6, false, x$7, x$8, x$9, (Option<File>)x$102, (Option<Properties>)x$11, x$12, x$5);){
            TopicPartition tp = new TopicPartition(topic, this.partitionId());
            consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)tp, (List)Nil$.MODULE$)).asJava());
            consumer.seek(tp, 0L);
            seq = (Seq)TestUtils$.MODULE$.consumeRecords(consumer, numMessages, 15000L).map((Function1 & Serializable)x$10 -> (String)x$10.value());
        }
        return seq;
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testTopicUncleanLeaderElectionEnableWithAlterTopicConfigs(String groupProtocol) {
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        this.disableEligibleLeaderReplicas();
        Admin x$1 = this.admin();
        String x$2 = this.topic();
        Seq<KafkaBroker> x$3 = this.brokers();
        Seq<ControllerServer> x$4 = this.controllerServers();
        Map x$5 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}));
        int x$6 = 1;
        int x$7 = 1;
        Properties x$8 = new Properties();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, x$2, x$3, x$4, x$6, x$7, (Map<Object, Seq<Object>>)x$5, x$8);
        int leaderId = TestUtils$.MODULE$.awaitLeaderChange(this.brokers(), this.topicPartition(), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, 15000L);
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "first", null, 30000, 20000);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), this.topic(), this.partitionId(), 15000L);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)Nil$.MODULE$), this.consumeAllMessages(this.topic(), 1));
        try (Admin adminClient = this.createAdminClient();){
            Properties newProps = new Properties();
            newProps.put(ReplicationConfigs.UNCLEAN_LEADER_ELECTION_ENABLE_CONFIG, "true");
            this.alterTopicConfigs(adminClient, this.topic(), newProps).all().get();
            Seq<KafkaBroker> x$9 = this.brokers();
            TopicPartition x$10 = this.topicPartition();
            Some x$112 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderId));
            None$ x$13 = None$.MODULE$;
            TestUtils$.MODULE$.awaitLeaderChange(x$9, x$10, (Option<Object>)x$13, (Option<Object>)x$112, 10000L);
            newProps.put(ReplicationConfigs.UNCLEAN_LEADER_ELECTION_ENABLE_CONFIG, "false");
            this.alterTopicConfigs(adminClient, this.topic(), newProps).all().get();
            Seq<KafkaBroker> x$14 = this.brokers();
            TopicPartition x$15 = this.topicPartition();
            Some x$16 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderId));
            None$ x$18 = None$.MODULE$;
            TestUtils$.MODULE$.awaitLeaderChange(x$14, x$15, (Option<Object>)x$18, (Option<Object>)x$16, 10000L);
        }
        ((IterableOps)this.brokers().filter((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnableWithAlterTopicConfigs$1(followerId, broker)))).map((Function1 & Serializable)broker -> {
            this.shutdownBroker(broker);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "second", null, 30000, 20000);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
        Meter uncleanLeaderElectionsPerSecGauge = this.getGauge("UncleanLeaderElectionsPerSec");
        long uncleanLeaderElectionsPerSec = uncleanLeaderElectionsPerSecGauge.count();
        Assertions.assertEquals((long)0L, (long)uncleanLeaderElectionsPerSec);
        ((IterableOps)this.brokers().filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnableWithAlterTopicConfigs$3(leaderId, x$11)))).map((Function1 & Serializable)broker -> {
            this.shutdownBroker(broker);
            return BoxedUnit.UNIT;
        });
        KafkaBroker followerBroker = (KafkaBroker)this.brokers().find((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnableWithAlterTopicConfigs$5(followerId, x$12))).get();
        followerBroker.startup();
        this.waitForNoLeaderAndIsrHasOldLeaderId(followerBroker.replicaManager().metadataCache(), leaderId);
        uncleanLeaderElectionsPerSec = uncleanLeaderElectionsPerSecGauge.count();
        Assertions.assertEquals((long)0L, (long)uncleanLeaderElectionsPerSec);
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Seq<KafkaBroker> x$19 = this.brokers();
            String x$20 = this.topic();
            TestUtils$.MODULE$.produceMessage(x$19, x$20, "third", null, 1000, 1000);
        });
        Assertions.assertEquals(TimeoutException.class, e.getCause().getClass());
        Assertions.assertEquals((Object)package$.MODULE$.List().empty(), this.consumeAllMessages(this.topic(), 0));
        try (Admin adminClient2 = this.createAdminClient();){
            Properties newProps = new Properties();
            newProps.put(ReplicationConfigs.UNCLEAN_LEADER_ELECTION_ENABLE_CONFIG, "true");
            this.alterTopicConfigs(adminClient2, this.topic(), newProps).all().get();
        }
        Seq<KafkaBroker> x$25 = this.brokers();
        TopicPartition x$26 = this.topicPartition();
        Some x$27 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        None$ x$29 = None$.MODULE$;
        TestUtils$.MODULE$.awaitLeaderChange(x$25, x$26, (Option<Object>)x$29, (Option<Object>)x$27, 30000L);
        uncleanLeaderElectionsPerSec = uncleanLeaderElectionsPerSecGauge.count();
        Assertions.assertEquals((long)1L, (long)uncleanLeaderElectionsPerSec);
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "third", null, 30000, 20000);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"third", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
    }

    private AlterConfigsResult alterTopicConfigs(Admin adminClient, String topic, Properties topicConfigs) {
        java.util.List configEntries = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.PropertiesHasAsScala(topicConfigs).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return new ConfigEntry(k, v);
            }
            throw new MatchError(null);
        })).toList()).asJava();
        return adminClient.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, topic)), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(configEntries).asScala().map((Function1 & Serializable)e -> new AlterConfigOp(e, AlterConfigOp.OpType.SET))).toSeq()).asJavaCollection())}))).asJava());
    }

    private Admin createAdminClient() {
        Properties config = new Properties();
        String bootstrapServers = TestUtils$.MODULE$.plaintextBootstrapServers(this.brokers());
        config.put("bootstrap.servers", bootstrapServers);
        config.put("metadata.max.age.ms", "10");
        return Admin.create((Properties)config);
    }

    /*
     * WARNING - void declaration
     */
    private void waitForNoLeaderAndIsrHasOldLeaderId(MetadataCache metadataCache, int leaderId) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!UncleanLeaderElectionTest.$anonfun$waitForNoLeaderAndIsrHasOldLeaderId$1(this, metadataCache, leaderId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)UncleanLeaderElectionTest.$anonfun$waitForNoLeaderAndIsrHasOldLeaderId$2(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$startBrokers$1(UncleanLeaderElectionTest $this, Properties props) {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        KafkaBroker broker = $this.createBroker(config, $this.createBroker$default$2(), $this.createBroker$default$3(), $this.createBroker$default$4());
        $this.configs_$eq((Seq<KafkaConfig>)((Seq)$this.configs().$plus$plus((IterableOnce)new .colon.colon((Object)config, (List)Nil$.MODULE$))));
        $this.brokers_$eq((Seq<KafkaBroker>)((Seq)$this.brokers().$plus$plus((IterableOnce)new .colon.colon((Object)broker, (List)Nil$.MODULE$))));
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$3(int followerId$1, KafkaBroker broker) {
        return broker.config().brokerId() == followerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$5(int leaderId$1, KafkaBroker x$4) {
        return x$4.config().brokerId() == leaderId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$7(int followerId$1, KafkaBroker x$5) {
        return x$5.config().brokerId() == followerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$3(int followerId$2, KafkaBroker broker) {
        return broker.config().brokerId() == followerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$5(int leaderId$2, KafkaBroker x$6) {
        return x$6.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$7(int followerId$2, KafkaBroker x$7) {
        return x$7.config().brokerId() == followerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$9(int leaderId$2, KafkaBroker x$8) {
        return x$8.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$10(UncleanLeaderElectionTest $this, KafkaBroker followerServer$1, int followerId$2) {
        Optional partitionInfoOpt = followerServer$1.metadataCache().getLeaderAndIsr($this.topic(), $this.partitionId());
        return partitionInfoOpt.isPresent() && ((LeaderAndIsr)partitionInfoOpt.get()).isr().contains(BoxesRunTime.boxToInteger((int)followerId$2));
    }

    public static final /* synthetic */ String $anonfun$verifyUncleanLeaderElectionDisabled$11() {
        return "Inconsistent metadata after first server startup";
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$12(int leaderId$2, KafkaBroker x$9) {
        return x$9.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$1(String metricName$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((MetricName)x0$1._1()).getName().endsWith(metricName$1);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnableWithAlterTopicConfigs$1(int followerId$3, KafkaBroker broker) {
        return broker.config().brokerId() == followerId$3;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnableWithAlterTopicConfigs$3(int leaderId$3, KafkaBroker x$11) {
        return x$11.config().brokerId() == leaderId$3;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnableWithAlterTopicConfigs$5(int followerId$3, KafkaBroker x$12) {
        return x$12.config().brokerId() == followerId$3;
    }

    public static final /* synthetic */ boolean $anonfun$waitForNoLeaderAndIsrHasOldLeaderId$1(UncleanLeaderElectionTest $this, MetadataCache metadataCache$1, int leaderId$4) {
        return metadataCache$1.getLeaderAndIsr($this.topic(), $this.partitionId()).isPresent() && ((LeaderAndIsr)metadataCache$1.getLeaderAndIsr($this.topic(), $this.partitionId()).get()).leader() == -1 && ((Object)Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)new int[]{leaderId$4}))).equals(((LeaderAndIsr)metadataCache$1.getLeaderAndIsr($this.topic(), $this.partitionId()).get()).isr());
    }

    public static final /* synthetic */ String $anonfun$waitForNoLeaderAndIsrHasOldLeaderId$2(UncleanLeaderElectionTest $this) {
        return "Timed out waiting for broker metadata cache updates the info for topic partition:" + $this.topicPartition();
    }

    public UncleanLeaderElectionTest() {
        this.brokerId1 = 0;
        this.brokerId2 = 1;
        this.enableControlledShutdown = true;
        this.partitionId = 0;
    }
}

