/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import kafka.log.LogCleanerManagerTest;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.LoadedLogOffsets;
import org.apache.kafka.storage.internals.log.LocalLog;
import org.apache.kafka.storage.internals.log.LogCleanerManager;
import org.apache.kafka.storage.internals.log.LogCleaningException;
import org.apache.kafka.storage.internals.log.LogCleaningState;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogLoader;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegments;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.storage.internals.log.LogToClean;
import org.apache.kafka.storage.internals.log.PreCleanStats;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.UnifiedLog;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0005\r-c\u0001\u0002'N\u0001ICQa\u0018\u0001\u0005\u0002\u0001Dqa\u0019\u0001C\u0002\u0013\u0005A\r\u0003\u0004n\u0001\u0001\u0006I!\u001a\u0005\b]\u0002\u0011\r\u0011\"\u0001e\u0011\u0019y\u0007\u0001)A\u0005K\"9\u0001\u000f\u0001b\u0001\n\u0003!\u0007BB9\u0001A\u0003%Q\rC\u0004s\u0001\t\u0007I\u0011\u00013\t\rM\u0004\u0001\u0015!\u0003f\u0011\u001d!\bA1A\u0005\u0002UDq!a\u0001\u0001A\u0003%a\u000f\u0003\u0005\u0002\u0006\u0001\u0011\r\u0011\"\u0001v\u0011\u001d\t9\u0001\u0001Q\u0001\nYD\u0011\"!\u0003\u0001\u0005\u0004%\t!a\u0003\t\u0011\u0005e\u0001\u0001)A\u0005\u0003\u001bA\u0011\"a\u0007\u0001\u0005\u0004%\t!!\b\t\u0011\u0005E\u0002\u0001)A\u0005\u0003?A\u0011\"a\r\u0001\u0005\u0004%\t!!\u000e\t\u0011\u0005\u0015\u0003\u0001)A\u0005\u0003oA\u0011\"a\u0012\u0001\u0005\u0004%\t!!\u0013\t\u0011\u0005E\u0003\u0001)A\u0005\u0003\u0017B\u0011\"a\u0015\u0001\u0005\u0004%\t!!\u0016\t\u0011\u0005u\u0003\u0001)A\u0005\u0003/B\u0011\"a\u0018\u0001\u0005\u0004%\t!!\u0019\t\u0011\u0005U\u0004\u0001)A\u0005\u0003G2a!a\u001e\u0001\u0001\u0005e\u0004BCAA5\t\u0005\t\u0015!\u0003\u0002\u0004\"Q\u0011\u0011\u0012\u000e\u0003\u0002\u0003\u0006I!a#\t\u0015\u0005u%D!A!\u0002\u0013\ty\n\u0003\u0004`5\u0011\u0005\u0011Q\u0015\u0005\b\u0003cSB\u0011IAZ\u0011\u001d\tYL\u0007C!\u0003{Cq!!<\u0001\t\u0003\ty\u000fC\u0004\u0003\b\u0001!IA!\u0003\t\u000f\t=\u0002\u0001\"\u0001\u0002p\"9!\u0011\b\u0001\u0005\u0002\u0005=\bb\u0002B\u001f\u0001\u0011\u0005\u0011q\u001e\u0005\b\u0005\u0003\u0002A\u0011AAx\u0011\u001d\u0011)\u0005\u0001C\u0001\u0003_DqA!\u0013\u0001\t\u0003\ty\u000fC\u0004\u0003N\u0001!\t!a<\t\u000f\tE\u0003\u0001\"\u0001\u0002p\"9!Q\u000b\u0001\u0005\u0002\u0005=\bb\u0002B-\u0001\u0011\u0005\u0011q\u001e\u0005\b\u0005;\u0002A\u0011AAx\u0011\u001d\u0011\t\u0007\u0001C\u0001\u0003_DqA!\u001a\u0001\t\u0003\ty\u000fC\u0004\u0003j\u0001!\t!a<\t\u000f\t5\u0004\u0001\"\u0001\u0002p\"9!\u0011\u000f\u0001\u0005\u0002\u0005=\bb\u0002B;\u0001\u0011\u0005\u0011q\u001e\u0005\b\u0005s\u0002A\u0011AAx\u0011\u001d\u0011i\b\u0001C\u0001\u0003_DqA!!\u0001\t\u0003\ty\u000fC\u0004\u0003\u0006\u0002!\t!a<\t\u000f\t%\u0005\u0001\"\u0001\u0002p\"9!Q\u0012\u0001\u0005\u0002\u0005=\bb\u0002BI\u0001\u0011\u0005\u0011q\u001e\u0005\b\u0005+\u0003A\u0011AAx\u0011\u001d\u0011I\n\u0001C\u0001\u0003_DqA!(\u0001\t\u0003\ty\u000fC\u0004\u0003\"\u0002!\t!a<\t\u000f\t\u0015\u0006\u0001\"\u0001\u0002p\"9!\u0011\u0016\u0001\u0005\u0002\u0005=\bb\u0002BW\u0001\u0011\u0005\u0011q\u001e\u0005\b\u0005c\u0003A\u0011\u0002BZ\u0011\u001d\u00119\f\u0001C\u0005\u0005sCqAa0\u0001\t\u0013\u0011\t\rC\u0005\u0003^\u0002\t\n\u0011\"\u0003\u0003`\"9!Q\u001f\u0001\u0005\n\t]\bb\u0002B\u007f\u0001\u0011%!q \u0005\b\u0007\u001f\u0001A\u0011BB\t\u0011\u001d\u0019I\u0002\u0001C\u0005\u00077A\u0011b!\n\u0001#\u0003%Iaa\n\t\u000f\r-\u0002\u0001\"\u0003\u0004.\t)Bj\\4DY\u0016\fg.\u001a:NC:\fw-\u001a:UKN$(B\u0001(P\u0003\rawn\u001a\u0006\u0002!\u0006)1.\u00194lC\u000e\u00011c\u0001\u0001T3B\u0011AkV\u0007\u0002+*\ta+A\u0003tG\u0006d\u0017-\u0003\u0002Y+\n1\u0011I\\=SK\u001a\u0004\"AW/\u000e\u0003mS!\u0001X(\u0002\u000bU$\u0018\u000e\\:\n\u0005y[&a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0004\"A\u0019\u0001\u000e\u00035\u000ba\u0001^7q\t&\u0014X#A3\u0011\u0005\u0019\\W\"A4\u000b\u0005!L\u0017AA5p\u0015\u0005Q\u0017\u0001\u00026bm\u0006L!\u0001\\4\u0003\t\u0019KG.Z\u0001\bi6\u0004H)\u001b:!\u0003\u001d!X\u000e\u001d#jeJ\n\u0001\u0002^7q\t&\u0014(\u0007I\u0001\u0007Y><G)\u001b:\u0002\u000f1|w\rR5sA\u00059An\\4ESJ\u0014\u0014\u0001\u00037pO\u0012K'O\r\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\ta\u000f\u0005\u0002x\u007f6\t\u0001P\u0003\u0002zu\u000611m\\7n_:T!\u0001U>\u000b\u0005ql\u0018AB1qC\u000eDWMC\u0001\u007f\u0003\ry'oZ\u0005\u0004\u0003\u0003A(A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t''\u0001\tu_BL7\rU1si&$\u0018n\u001c83A\u0005AAn\\4Qe>\u00048/\u0006\u0002\u0002\u000eA!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u0014%\fA!\u001e;jY&!\u0011qCA\t\u0005)\u0001&o\u001c9feRLWm]\u0001\nY><\u0007K]8qg\u0002\n\u0011\u0002\\8h\u0007>tg-[4\u0016\u0005\u0005}\u0001\u0003BA\u0011\u0003[i!!a\t\u000b\u00079\u000b)C\u0003\u0003\u0002(\u0005%\u0012!C5oi\u0016\u0014h.\u00197t\u0015\r\tYC_\u0001\bgR|'/Y4f\u0013\u0011\ty#a\t\u0003\u00131{wmQ8oM&<\u0017A\u00037pO\u000e{gNZ5hA\u0005!A/[7f+\t\t9\u0004\u0005\u0003\u0002:\u0005\u0005SBAA\u001e\u0015\u0011\t\u0019\"!\u0010\u000b\u0007\u0005}\"0\u0001\u0004tKJ4XM]\u0005\u0005\u0003\u0007\nYD\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003\u0019ygMZ:fiV\u0011\u00111\n\t\u0004)\u00065\u0013bAA(+\n\u0019\u0011J\u001c;\u0002\u000f=4gm]3uA\u0005Q\u0002O]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\u001cuN\u001c4jOV\u0011\u0011q\u000b\t\u0005\u0003C\tI&\u0003\u0003\u0002\\\u0005\r\"A\u0007)s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'oQ8oM&<\u0017a\u00079s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'oQ8oM&<\u0007%\u0001\ndY\u0016\fg.\u001a:DQ\u0016\u001c7\u000e]8j]R\u001cXCAA2!\u001d\ty!!\u001aw\u0003SJA!a\u001a\u0002\u0012\t9\u0001*Y:i\u001b\u0006\u0004\b\u0003BA6\u0003cj!!!\u001c\u000b\u0007\u0005=\u0014.\u0001\u0003mC:<\u0017\u0002BA:\u0003[\u0012A\u0001T8oO\u0006\u00192\r\\3b]\u0016\u00148\t[3dWB|\u0017N\u001c;tA\t)Bj\\4DY\u0016\fg.\u001a:NC:\fw-\u001a:N_\u000e\\7c\u0001\u000e\u0002|A!\u0011\u0011EA?\u0013\u0011\ty(a\t\u0003#1{wm\u00117fC:,'/T1oC\u001e,'/A\u0004m_\u001e$\u0015N]:\u0011\u000b\u0005=\u0011QQ3\n\t\u0005\u001d\u0015\u0011\u0003\u0002\u0005\u0019&\u001cH/\u0001\u0003m_\u001e\u001c\bcBAG\u0003'3\u0018qS\u0007\u0003\u0003\u001fSA!!%\u0002\u0012\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005U\u0015q\u0012\u0002\u000e\u0007>t7-\u001e:sK:$X*\u00199\u0011\t\u0005\u0005\u0012\u0011T\u0005\u0005\u00037\u000b\u0019C\u0001\u0006V]&4\u0017.\u001a3M_\u001e\fA\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0007\u0003BA\u0011\u0003CKA!a)\u0002$\t!Bj\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2$\u0002\"a*\u0002,\u00065\u0016q\u0016\t\u0004\u0003SSR\"\u0001\u0001\t\u000f\u0005\u0005e\u00041\u0001\u0002\u0004\"9\u0011\u0011\u0012\u0010A\u0002\u0005-\u0005bBAO=\u0001\u0007\u0011qT\u0001\u0016C2d7\t\\3b]\u0016\u00148\t[3dWB|\u0017N\u001c;t)\t\t)\fE\u0004\u0002\u0010\u0005]f/!\u001b\n\t\u0005e\u0016\u0011\u0003\u0002\u0004\u001b\u0006\u0004\u0018!E;qI\u0006$Xm\u00115fG.\u0004x.\u001b8ugRA\u0011qXAc\u0003\u0013\f9\u000fE\u0002U\u0003\u0003L1!a1V\u0005\u0011)f.\u001b;\t\r\u0005\u001d\u0007\u00051\u0001f\u0003\u001d!\u0017\r^1ESJDq!a3!\u0001\u0004\ti-\u0001\fqCJ$\u0018\u000e^5p]R{W\u000b\u001d3bi\u0016|%/\u00113e!\u0019\ty!a4\u0002T&!\u0011\u0011[A\t\u0005!y\u0005\u000f^5p]\u0006d\u0007cBAk\u0003C4\u0018\u0011\u000e\b\u0005\u0003/\fiN\u0004\u0003\u0002Z\u0006mW\"A5\n\u0007\u0005M\u0011.\u0003\u0003\u0002`\u0006E\u0011aA'ba&!\u00111]As\u0005\u0015)e\u000e\u001e:z\u0015\u0011\ty.!\u0005\t\u000f\u0005%\b\u00051\u0001\u0002l\u0006\t\u0002/\u0019:uSRLwN\u001c+p%\u0016lwN^3\u0011\u000b\u0005=\u0011q\u001a<\u0002\u0011Q,\u0017M\u001d#po:$\"!a0)\u0007\u0005\n\u0019\u0010\u0005\u0003\u0002v\n\rQBAA|\u0015\u0011\tI0a?\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002~\u0006}\u0018a\u00026va&$XM\u001d\u0006\u0004\u0005\u0003i\u0018!\u00026v]&$\u0018\u0002\u0002B\u0003\u0003o\u0014\u0011\"\u00114uKJ,\u0015m\u00195\u00027M,G/\u001e9J]\u000e\u0014X-Y:j]\u001ed\u0017PR5mi\"LHj\\4t)!\tYIa\u0003\u0003(\t-\u0002b\u0002B\u0007E\u0001\u0007!qB\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\b#\u0002B\t\u0005C1h\u0002\u0002B\n\u0005;qAA!\u0006\u0003\u001c5\u0011!q\u0003\u0006\u0004\u00053\t\u0016A\u0002\u001fs_>$h(C\u0001W\u0013\r\u0011y\"V\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\u0019C!\n\u0003\u0007M+\u0017OC\u0002\u0003 UCqA!\u000b#\u0001\u0004\tY%A\bti\u0006\u0014HOT;n\u0005\u0006$8\r[3t\u0011\u001d\u0011iC\ta\u0001\u0003\u0017\naBY1uG\"Len\u0019:f[\u0016tG/\u0001\u0017uKN$xI]1c\r&dG\u000f[5fgR\u001cu.\u001c9bGR,G\rT8h)\"\u0014xn^:Fq\u000e,\u0007\u000f^5p]\"\u001a1Ea\r\u0011\t\u0005U(QG\u0005\u0005\u0005o\t9P\u0001\u0003UKN$\u0018\u0001\u000f;fgR<%/\u00192GS2$\b.[3ti\u000e{W\u000e]1di\u0016$Gj\\4SKR,(O\\:M_\u001e<\u0016\u000e\u001e5ESJ$\u0018.Z:u%\u0006$\u0018n\u001c\u0015\u0004I\tM\u0012!\u000f;fgR<%/\u00192GS2$\b.[3ti\u000e{W\u000e]1di\u0016$Gj\\4JO:|'/Z:V]\u000edW-\u00198bE2,\u0007+\u0019:uSRLwN\\:)\u0007\u0015\u0012\u0019$\u0001\u001duKN$xI]1c\r&dG\u000f[5fgR\u001cu.\u001c9bGR,G\rT8h\u0013\u001etwN]3t\u0013:\u0004&o\\4sKN\u001c\b+\u0019:uSRLwN\\:)\u0007\u0019\u0012\u0019$\u0001+uKN$xI]1c\r&dG\u000f[5fgR\u001cu.\u001c9bGR,G\rT8h\u0013\u001etwN]3t\u0005>$\b.\u00138Qe><'/Z:t!\u0006\u0014H/\u001b;j_:\u001c\u0018I\u001c3V]\u000edW-\u00198bE2,\u0007+\u0019:uSRLwN\\:)\u0007\u001d\u0012\u0019$A\u0015uKN$H)\u001b:us>3gm]3u%\u0016\u001cX\r^%g\u0019\u0006\u0014x-\u001a:UQ\u0006tWI\u001c3PM\u001a\u001cX\r\u001e\u0015\u0004Q\tM\u0012\u0001\f;fgR$\u0015N\u001d;z\u001f\u001a47/\u001a;SKN,G/\u00134T[\u0006dG.\u001a:UQ\u0006t7\u000b^1si>3gm]3uQ\rI#1G\u00014i\u0016\u001cH\u000fT8h'R\f'\u000f^(gMN,G\u000fT1sO\u0016\u0014H\u000b[1o\u0003\u000e$\u0018N^3TK\u001elWM\u001c;CCN,wJ\u001a4tKRD3A\u000bB\u001a\u0003A\"Xm\u001d;ESJ$\u0018p\u00144gg\u0016$H*\u0019:hKJ$\u0006.\u00198BGRLg/Z*fO6,g\u000e\u001e\"bg\u0016|eMZ:fi\"\u001a1Fa\r\u0002\tR,7\u000f\u001e'pON<\u0016\u000e\u001e5TK\u001elWM\u001c;t)>$U\r\\3uKNCw.\u001e7e\u001d>$8i\u001c8tS\u0012,'o\u00117fC:,\b\u000fU8mS\u000eLH)\u001a7fi\u0016dunZ:)\u00071\u0012\u0019$\u0001%uKN$Hj\\4t/&$\bnU3h[\u0016tGo\u001d+p\t\u0016dW\r^3TQ>,H\u000eZ\"p]NLG-\u001a:DY\u0016\fg.\u001e9Q_2L7-_\"p[B\f7\r\u001e#fY\u0016$X\rT8hg\"\u001aQFa\r\u0002\u0005R,7\u000f\u001e'pON<\u0016\u000e\u001e5TK\u001elWM\u001c;t)>$U\r\\3uKNCw.\u001e7e\u0007>t7/\u001b3fe\u000ecW-\u00198vaB{G.[2z\u0007>l\u0007/Y2u\u0019><7\u000fK\u0002/\u0005g\t1\u0006^3ti2{wm]+oI\u0016\u00148\t\\3b]V\u0004\u0018J\\3mS\u001eL'\r\\3G_J\u001cu.\u001c9bGRLwN\u001c\u0015\u0004_\tM\u0012a\f;fgR,\u0006\u000fZ1uK\u000eCWmY6q_&tGo]*i_VdG-\u00113e\u001f\u001a47/\u001a;U_B\u000b'\u000f^5uS>t\u0007f\u0001\u0019\u00034\u0005qC/Z:u+B$\u0017\r^3DQ\u0016\u001c7\u000e]8j]R\u001c8\u000b[8vY\u0012\u0014V-\\8wKB\u000b'\u000f^5uS>tG)\u0019;bQ\r\t$1G\u0001.i\u0016\u001cH\u000fS1oI2,Gj\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0006n\\;mIJ+Wn\u001c<f\t&\u0014\u0018I\u001c3ECR\f\u0007f\u0001\u001a\u00034\u0005iC/Z:u\u001b\u0006L(-\u001a+sk:\u001c\u0017\r^3DQ\u0016\u001c7\u000e]8j]R\u001c\u0006n\\;mIR\u0013XO\\2bi\u0016$\u0015\r^1)\u0007M\u0012\u0019$\u0001\u001fuKN$\u0018\t\u001c;fe\u000eCWmY6q_&tG\u000fR5s'\"|W\u000f\u001c3SK6|g/\u001a#bi\u0006Len\u0015:d\t&\u0014\u0018I\u001c3BI\u0012LeNT3x\t&\u0014\bf\u0001\u001b\u00034\u0005AC/Z:u\u0007>t7-\u001e:sK:$Hj\\4DY\u0016\fg.\u001e9B]\u0012dun\u001a+sk:\u001c\u0017\r^5p]\"\u001aQGa\r\u0002QQ,7\u000f^\"p]\u000e,(O]3oi2{wm\u00117fC:,\b/\u00118e)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8)\u0007Y\u0012\u0019$\u0001\"uKN$Hj\\4t/&$\bnU3h[\u0016tGo\u001d+p\t\u0016dW\r^3TQ>,H\u000e\u001a(pi\u000e{gn]5eKJ,fn\u00197fC:\f'\r\\3QCJ$\u0018\u000e^5p]ND3a\u000eB\u001a\u0003m!Xm\u001d;DY\u0016\fg.\u00192mK>3gm]3ug\u001a{'OT8oK\"\u001a\u0001Ha\r\u0002CQ,7\u000f^\"mK\u0006t\u0017M\u00197f\u001f\u001a47/\u001a;t\u0003\u000e$\u0018N^3TK\u001elWM\u001c;)\u0007e\u0012\u0019$A\u000euKN$8\t\\3b]\u0006\u0014G.Z(gMN,Go\u001d$peRKW.\u001a\u0015\u0004u\tM\u0012\u0001\t;fgR\u001cE.Z1oC\ndWm\u00144gg\u0016$8OR8s'\"|'\u000f\u001e+j[\u0016D3a\u000fB\u001a\u0003!\"Xm\u001d;DY\u0016\fg.\u00192mK>3gm]3ug:+W\rZ:DQ\u0016\u001c7\u000e]8j]R\u0014Vm]3uQ\ra$1G\u0001+i\u0016\u001cH/\u00168eK\u000eLG-\u001a3Ue\u0006t7/Y2uS>t\u0017\r\u001c#bi\u0006tu\u000e^\"mK\u0006t\u0017M\u00197fQ\ri$1G\u0001\u0011i\u0016\u001cH\u000fR8oK\u000ecW-\u00198j]\u001eD3A\u0010B\u001a\u0003A!Xm\u001d;E_:,G)\u001a7fi&tw\rK\u0002@\u0005g\tq\u0006^3ti\u000eCWmY6q_&tG/\u00169eCR,GMR8s\u0013:4\u0018\r\\5e\u001f\u001a47/\u001a;O_\u000ecW-\u00198j]\u001eD3\u0001\u0011B\u001a\u0003A\"Xm\u001d;DQ\u0016\u001c7\u000e]8j]R,\u0006\u000fZ1uK\u00124uN]%om\u0006d\u0017\u000eZ(gMN,GOT8u'\u0016dWm\u0019;fI\"\u001a\u0011Ia\r\u0002)\r\u0014X-\u0019;f\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s)\u0011\tYH!.\t\r9\u0013\u0005\u0019AAL\u0003a\u0019'/Z1uK\u000ecW-\u00198fe6\u000bg.Y4fe6{7m\u001b\u000b\u0005\u0003O\u0013Y\fC\u0004\u0003>\u000e\u0003\r!a#\u0002\tA|w\u000e\\\u0001\nGJ,\u0017\r^3M_\u001e$\u0002\"a&\u0003D\n\u001d'1\u001c\u0005\b\u0005\u000b$\u0005\u0019AA&\u0003-\u0019XmZ7f]R\u001c\u0016N_3\t\u000f\t%G\t1\u0001\u0003L\u0006i1\r\\3b]V\u0004\bk\u001c7jGf\u0004BA!4\u0003V:!!q\u001aBi!\r\u0011)\"V\u0005\u0004\u0005',\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0003X\ne'AB*ue&twMC\u0002\u0003TVCq\u0001\u001e#\u0011\u0002\u0003\u0007a/A\nde\u0016\fG/\u001a'pO\u0012\"WMZ1vYR$3'\u0006\u0002\u0003b*\u001aaOa9,\u0005\t\u0015\b\u0003\u0002Bt\u0005cl!A!;\u000b\t\t-(Q^\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa<V\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005g\u0014IOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1d\u0019:fCR,Gj\\<SKR,g\u000e^5p]2{wmQ8oM&<GCBA\u0010\u0005s\u0014Y\u0010C\u0004\u0003F\u001a\u0003\r!a\u0013\t\u000f\t%g\t1\u0001\u0003L\u0006aqO]5uKJ+7m\u001c:egRQ\u0011qXB\u0001\u0007\u0007\u00199aa\u0003\t\r9;\u0005\u0019AAL\u0011\u001d\u0019)a\u0012a\u0001\u0003\u0017\n!B\\;n\u0005\u0006$8\r[3t\u0011\u001d\u0019Ia\u0012a\u0001\u0003\u0017\nqB]3d_J$7\u000fU3s\u0005\u0006$8\r\u001b\u0005\b\u0007\u001b9\u0005\u0019AA&\u0003E\u0011\u0017\r^2iKN\u0004VM]*fO6,g\u000e^\u0001\u000eCB\u0004XM\u001c3SK\u000e|'\u000fZ:\u0015\r\u0005}61CB\u000b\u0011\u0019q\u0005\n1\u0001\u0002\u0018\"91q\u0003%A\u0002\u0005-\u0013A\u00038v[J+7m\u001c:eg\u00069Q.Y6f\u0019><GCBAL\u0007;\u0019\t\u0003\u0003\u0005\u0004 %\u0003\n\u00111\u0001f\u0003\r!\u0017N\u001d\u0005\b\u0007GI\u0005\u0019AA\u0010\u0003\u0019\u0019wN\u001c4jO\u0006\tR.Y6f\u0019><G\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\r%\"fA3\u0003d\u00069!/Z2pe\u0012\u001cH\u0003CB\u0018\u0007w\u0019yda\u0011\u0011\t\rE2qG\u0007\u0003\u0007gQ1a!\u000ey\u0003\u0019\u0011XmY8sI&!1\u0011HB\u001a\u00055iU-\\8ssJ+7m\u001c:eg\"91QH&A\u0002\u0005-\u0013aA6fs\"91\u0011I&A\u0002\u0005-\u0013!\u0002<bYV,\u0007bBB#\u0017\u0002\u00071qI\u0001\ni&lWm\u001d;b[B\u00042\u0001VB%\u0013\r\t\u0019(\u0016")
public class LogCleanerManagerTest
implements Logging {
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File tmpDir2 = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils.randomPartitionLogDir((File)this.tmpDir());
    private final File logDir2 = TestUtils.randomPartitionLogDir((File)this.tmpDir2());
    private final TopicPartition topicPartition = new TopicPartition("log", 0);
    private final TopicPartition topicPartition2 = new TopicPartition("log2", 0);
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private final MockTime time;
    private final int offset;
    private final ProducerStateManagerConfig producerStateManagerConfig;
    private final HashMap<TopicPartition, Long> cleanerCheckpoints;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File tmpDir2() {
        return this.tmpDir2;
    }

    public File logDir() {
        return this.logDir;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public TopicPartition topicPartition2() {
        return this.topicPartition2;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public int offset() {
        return this.offset;
    }

    public ProducerStateManagerConfig producerStateManagerConfig() {
        return this.producerStateManagerConfig;
    }

    public HashMap<TopicPartition, Long> cleanerCheckpoints() {
        return this.cleanerCheckpoints;
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    private ConcurrentMap<TopicPartition, UnifiedLog> setupIncreasinglyFilthyLogs(Seq<TopicPartition> partitions, int startNumBatches, int batchIncrement) {
        ConcurrentHashMap<TopicPartition, UnifiedLog> logs = new ConcurrentHashMap<TopicPartition, UnifiedLog>();
        IntRef numBatches = IntRef.create((int)startNumBatches);
        partitions.foreach((Function1 & Serializable)tp -> {
            LogCleanerManagerTest.$anonfun$setupIncreasinglyFilthyLogs$1(this, logs, numBatches, batchIncrement, tp);
            return BoxedUnit.UNIT;
        });
        return logs;
    }

    @Test
    public void testGrabFilthiestCompactedLogThrowsException() {
        TopicPartition tp = new TopicPartition("A", 1);
        int logSegmentSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2).sizeInBytes() * 10;
        int logSegmentsCount = 2;
        File tpDir = new File(this.logDir(), "A-1");
        Files.createDirectories(tpDir.toPath(), new FileAttribute[0]);
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        LogConfig config = this.createLowRetentionLogConfig(logSegmentSize, "compact");
        int maxTransactionTimeoutMs = 300000;
        int producerIdExpirationCheckIntervalMs = 600000;
        LogSegments segments = new LogSegments(tp);
        LeaderEpochFileCache leaderEpochCache = UnifiedLog.createLeaderEpochCache((File)tpDir, (TopicPartition)this.topicPartition(), (LogDirFailureChannel)logDirFailureChannel, Optional.empty(), (Scheduler)this.time().scheduler);
        ProducerStateManager producerStateManager = new ProducerStateManager(this.topicPartition(), tpDir, maxTransactionTimeoutMs, this.producerStateManagerConfig(), (Time)this.time());
        LoadedLogOffsets offsets = new LogLoader(tpDir, tp, config, (Scheduler)this.time().scheduler, (Time)this.time(), logDirFailureChannel, true, segments, 0L, 0L, leaderEpochCache, producerStateManager, new ConcurrentHashMap(), false).load();
        LocalLog localLog = new LocalLog(tpDir, config, segments, offsets.recoveryPoint, offsets.nextOffsetMetadata, (Scheduler)this.time().scheduler, (Time)this.time(), tp, logDirFailureChannel);
        public class Kafka_log_LogCleanerManagerTest$LogMock$1
        extends UnifiedLog {
            public Collection<Long> getFirstBatchTimestampForSegments(Collection<LogSegment> segments) {
                throw new IllegalStateException("Error!");
            }

            public Kafka_log_LogCleanerManagerTest$LogMock$1(LogCleanerManagerTest $outer, LoadedLogOffsets offsets$1, LocalLog localLog$1, int producerIdExpirationCheckIntervalMs$1, LeaderEpochFileCache leaderEpochCache$1, ProducerStateManager producerStateManager$1) {
                super(offsets$1.logStartOffset, localLog$1, new BrokerTopicStats(), producerIdExpirationCheckIntervalMs$1, leaderEpochCache$1, producerStateManager$1, Optional.empty(), false, LogOffsetsListener.NO_OP_OFFSETS_LISTENER);
            }
        }
        Kafka_log_LogCleanerManagerTest$LogMock$1 log = new Kafka_log_LogCleanerManagerTest$LogMock$1(null, offsets, localLog, producerIdExpirationCheckIntervalMs, leaderEpochCache, producerStateManager);
        this.writeRecords(log, logSegmentsCount * 2, 10, 2);
        ConcurrentHashMap<TopicPartition, UnifiedLog> logsPool = new ConcurrentHashMap<TopicPartition, UnifiedLog>();
        logsPool.put(tp, log);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logsPool);
        this.cleanerCheckpoints().put(tp, Predef$.MODULE$.long2Long(1L));
        LogCleaningException thrownException = (LogCleaningException)Assertions.assertThrows(LogCleaningException.class, () -> cleanerManager.grabFilthiestCompactedLog((Time)this.time(), new PreCleanStats()).get());
        Assertions.assertEquals((Object)((Object)log), (Object)thrownException.log);
        Assertions.assertTrue((boolean)(thrownException.getCause() instanceof IllegalStateException));
    }

    @Test
    public void testGrabFilthiestCompactedLogReturnsLogWithDirtiestRatio() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        ConcurrentMap<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable)partition -> this.cleanerCheckpoints().put((TopicPartition)partition, Predef$.MODULE$.long2Long(20L)));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), new PreCleanStats()).get();
        Assertions.assertEquals((Object)tp2, (Object)filthiestLog.topicPartition());
        Assertions.assertEquals((Object)tp2, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        ConcurrentMap<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable)partition -> this.cleanerCheckpoints().put((TopicPartition)partition, Predef$.MODULE$.long2Long(20L)));
        cleanerManager.markPartitionUncleanable(((UnifiedLog)logs.get(tp2)).dir().getParent(), tp2);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), new PreCleanStats()).get();
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresInProgressPartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        ConcurrentMap<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable)partition -> this.cleanerCheckpoints().put((TopicPartition)partition, Predef$.MODULE$.long2Long(20L)));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningState.LOG_CLEANING_IN_PROGRESS);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), new PreCleanStats()).get();
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresBothInProgressPartitionsAndUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        ConcurrentMap<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable)partition -> this.cleanerCheckpoints().put((TopicPartition)partition, Predef$.MODULE$.long2Long(20L)));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningState.LOG_CLEANING_IN_PROGRESS);
        cleanerManager.markPartitionUncleanable(((UnifiedLog)logs.get(tp1)).dir().getParent(), tp1);
        Optional filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), new PreCleanStats());
        Assertions.assertEquals(Optional.empty(), (Object)filthiestLog);
    }

    @Test
    public void testDirtyOffsetResetIfLargerThanEndOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ConcurrentMap<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put(tp, Predef$.MODULE$.long2Long(200L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), new PreCleanStats()).get();
        Assertions.assertEquals((long)0L, (long)filthiestLog.firstDirtyOffset());
    }

    @Test
    public void testDirtyOffsetResetIfSmallerThanStartOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ConcurrentMap<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((UnifiedLog)logs.get(tp)).maybeIncrementLogStartOffset(10L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put(tp, Predef$.MODULE$.long2Long(0L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), new PreCleanStats()).get();
        Assertions.assertEquals((long)10L, (long)filthiestLog.firstDirtyOffset());
    }

    @Test
    public void testLogStartOffsetLargerThanActiveSegmentBaseOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        UnifiedLog log = this.createLog(2048, "compact", tp);
        ConcurrentHashMap<TopicPartition, UnifiedLog> logs = new ConcurrentHashMap<TopicPartition, UnifiedLog>();
        logs.put(tp, log);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        Assertions.assertEquals((int)1, (int)log.logSegments().size());
        log.maybeIncrementLogStartOffset(2L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put(tp, Predef$.MODULE$.long2Long(0L));
        Optional filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), new PreCleanStats());
        Assertions.assertEquals(Optional.empty(), (Object)filthiestLog);
    }

    @Test
    public void testDirtyOffsetLargerThanActiveSegmentBaseOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ConcurrentHashMap<TopicPartition, UnifiedLog> logs = new ConcurrentHashMap<TopicPartition, UnifiedLog>();
        UnifiedLog log = this.createLog(2048, "compact", tp);
        logs.put(tp, log);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        Assertions.assertEquals((int)1, (int)log.logSegments().size());
        Assertions.assertEquals((long)0L, (long)log.activeSegment().baseOffset());
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put(tp, Predef$.MODULE$.long2Long(3L));
        Optional filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), new PreCleanStats());
        Assertions.assertEquals(Optional.empty(), (Object)filthiestLog);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderCleanupPolicyDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, (Compression)Compression.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "delete", this.createLog$default$3());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assertions.assertEquals((int)0, (int)readyToDelete, (String)"should have 0 logs ready to be deleted");
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), (Compression)Compression.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "compact,delete", this.createLog$default$3());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assertions.assertEquals((int)1, (int)readyToDelete, (String)"should have 1 logs ready to be deleted");
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), (Compression)Compression.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assertions.assertEquals((int)1, (int)readyToDelete, (String)"should have 1 logs ready to be deleted");
    }

    @Test
    public void testLogsUnderCleanupIneligibleForCompaction() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), (Compression)Compression.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "delete", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        log.appendAsLeader(records, 0);
        log.roll();
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test2".getBytes(), "test2".getBytes(), (Compression)Compression.NONE, -1L, (byte)2), 0);
        log.updateHighWatermark(2L);
        java.util.List deletableLog = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assertions.assertEquals((int)1, (int)deletableLog.size(), (String)"should have 1 logs ready to be deleted");
        Properties logProps = new Properties();
        logProps.put("internal.segment.bytes", Predef$.MODULE$.int2Integer(log.config().segmentSize()));
        logProps.put("retention.ms", Predef$.MODULE$.long2Long(log.config().retentionMs));
        logProps.put("cleanup.policy", "compact");
        logProps.put("min.cleanable.dirty.ratio", Predef$.MODULE$.int2Integer(0));
        LogConfig config = new LogConfig((Map)logProps);
        log.updateConfig(config);
        Option cleanable = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(cleanerManager.grabFilthiestCompactedLog((Time)this.time(), new PreCleanStats())));
        Assertions.assertEquals((int)0, (int)Option$.MODULE$.option2Iterable(cleanable).size(), (String)"should have 0 logs ready to be compacted");
        cleanerManager.resumeCleaning(deletableLog.stream().map(entry -> (TopicPartition)entry.getKey()).collect(Collectors.toSet()));
        Option cleanable2 = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(cleanerManager.grabFilthiestCompactedLog((Time)this.time(), new PreCleanStats())));
        Assertions.assertEquals((int)1, (int)Option$.MODULE$.option2Iterable(cleanable2).size(), (String)"should have 1 logs ready to be compacted");
        logProps.put("cleanup.policy", "delete");
        LogConfig config2 = new LogConfig((Map)logProps);
        log.updateConfig(config2);
        java.util.List deletableLog2 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assertions.assertEquals((int)0, (int)deletableLog2.size(), (String)"should have 0 logs ready to be deleted");
        cleanerManager.doneDeleting(java.util.List.of(((LogToClean)cleanable2.get()).topicPartition()));
        java.util.List deletableLog3 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assertions.assertEquals((int)1, (int)deletableLog3.size(), (String)"should have 1 logs ready to be deleted");
    }

    @Test
    public void testUpdateCheckpointsShouldAddOffsetToPartition() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), (Compression)Compression.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Assertions.assertNotEquals((long)this.offset(), (Long)cleanerManager.allCleanerCheckpoints().getOrDefault(this.topicPartition(), Predef$.MODULE$.long2Long(0L)));
        cleanerManager.updateCheckpoints(this.logDir(), Optional.of(Map.entry(this.topicPartition(), Predef$.MODULE$.long2Long((long)this.offset()))), Optional.empty());
        Assertions.assertEquals((long)this.offset(), (Long)((Long)cleanerManager.allCleanerCheckpoints().get(this.topicPartition())));
    }

    @Test
    public void testUpdateCheckpointsShouldRemovePartitionData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), (Compression)Compression.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Optional.of(Map.entry(this.topicPartition(), Predef$.MODULE$.long2Long((long)this.offset()))), Optional.empty());
        Assertions.assertEquals((long)this.offset(), (Long)((Long)cleanerManager.allCleanerCheckpoints().get(this.topicPartition())));
        cleanerManager.updateCheckpoints(this.logDir(), Optional.empty(), Optional.of(this.topicPartition()));
        Assertions.assertFalse((boolean)cleanerManager.allCleanerCheckpoints().containsKey(this.topicPartition()));
    }

    @Test
    public void testHandleLogDirFailureShouldRemoveDirAndData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), (Compression)Compression.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Optional.of(Map.entry(this.topicPartition(), Predef$.MODULE$.long2Long((long)this.offset()))), Optional.empty());
        cleanerManager.updateCheckpoints(this.logDir2(), Optional.of(Map.entry(this.topicPartition2(), Predef$.MODULE$.long2Long((long)this.offset()))), Optional.empty());
        Assertions.assertEquals((long)this.offset(), (Long)((Long)cleanerManager.allCleanerCheckpoints().get(this.topicPartition())));
        Assertions.assertEquals((long)this.offset(), (Long)((Long)cleanerManager.allCleanerCheckpoints().get(this.topicPartition2())));
        cleanerManager.handleLogDirFailure(this.logDir().getAbsolutePath());
        Assertions.assertEquals((long)this.offset(), (Long)((Long)cleanerManager.allCleanerCheckpoints().get(this.topicPartition2())));
        Assertions.assertFalse((boolean)cleanerManager.allCleanerCheckpoints().containsKey(this.topicPartition()));
    }

    @Test
    public void testMaybeTruncateCheckpointShouldTruncateData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), (Compression)Compression.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        long lowerOffset = 1L;
        long higherOffset = 1000L;
        cleanerManager.updateCheckpoints(this.logDir(), Optional.of(Map.entry(this.topicPartition(), Predef$.MODULE$.long2Long((long)this.offset()))), Optional.empty());
        Assertions.assertEquals((long)this.offset(), (Long)((Long)cleanerManager.allCleanerCheckpoints().get(this.topicPartition())));
        cleanerManager.maybeTruncateCheckpoint(this.logDir(), this.topicPartition(), higherOffset);
        Assertions.assertEquals((long)this.offset(), (Long)((Long)cleanerManager.allCleanerCheckpoints().get(this.topicPartition())));
        cleanerManager.maybeTruncateCheckpoint(this.logDir(), this.topicPartition(), lowerOffset);
        Assertions.assertEquals((long)lowerOffset, (Long)((Long)cleanerManager.allCleanerCheckpoints().get(this.topicPartition())));
    }

    @Test
    public void testAlterCheckpointDirShouldRemoveDataInSrcDirAndAddInNewDir() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), (Compression)Compression.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Optional.of(Map.entry(this.topicPartition(), Predef$.MODULE$.long2Long((long)this.offset()))), Optional.empty());
        Assertions.assertEquals((long)this.offset(), (Long)((Long)cleanerManager.allCleanerCheckpoints().get(this.topicPartition())));
        cleanerManager.alterCheckpointDir(this.topicPartition(), this.logDir(), this.logDir2());
        Assertions.assertEquals((long)this.offset(), (Long)((Long)cleanerManager.allCleanerCheckpoints().get(this.topicPartition())));
        cleanerManager.handleLogDirFailure(this.logDir2().getAbsolutePath());
        Assertions.assertFalse((boolean)cleanerManager.allCleanerCheckpoints().containsKey(this.topicPartition()));
    }

    @Test
    public void testConcurrentLogCleanupAndLogTruncation() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), (Compression)Compression.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "delete", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        java.util.List pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortAndPauseCleaning(log.topicPartition());
        cleanerManager.resumeCleaning(Set.of(log.topicPartition()));
        cleanerManager.resumeCleaning(pausedPartitions.stream().map(entry -> (TopicPartition)entry.getKey()).collect(Collectors.toSet()));
        Assertions.assertEquals(Optional.empty(), (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testConcurrentLogCleanupAndTopicDeletion() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), (Compression)Compression.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "delete", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        java.util.List pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortCleaning(log.topicPartition());
        cleanerManager.resumeCleaning(pausedPartitions.stream().map(entry -> (TopicPartition)entry.getKey()).collect(Collectors.toSet()));
        Assertions.assertEquals(Optional.empty(), (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderUncleanablePartitions() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), (Compression)Compression.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.markPartitionUncleanable(log.dir().getParent(), this.topicPartition());
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assertions.assertEquals((int)0, (int)readyToDelete, (String)"should have 0 logs ready to be deleted");
    }

    @Test
    public void testCleanableOffsetsForNone() {
        Properties logProps = new Properties();
        logProps.put("internal.segment.bytes", Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        UnifiedLog log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0);
        }
        log.updateHighWatermark(50L);
        Optional<Long> lastCleanOffset = Optional.of(BoxesRunTime.boxToLong((long)0L));
        LogCleanerManager.OffsetsToClean cleanableOffsets = LogCleanerManager.cleanableOffsets((UnifiedLog)log, lastCleanOffset, (long)this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)log.highWatermark(), (long)log.lastStableOffset(), (String)"The high watermark equals the last stable offset as no transactions are in progress");
        Assertions.assertEquals((long)log.lastStableOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset is bounded by the last stable offset.");
    }

    @Test
    public void testCleanableOffsetsActiveSegment() {
        Properties logProps = new Properties();
        logProps.put("internal.segment.bytes", Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        UnifiedLog log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0);
        }
        log.updateHighWatermark(log.logEndOffset());
        Optional<Long> lastCleanOffset = Optional.of(BoxesRunTime.boxToLong((long)0L));
        LogCleanerManager.OffsetsToClean cleanableOffsets = LogCleanerManager.cleanableOffsets((UnifiedLog)log, lastCleanOffset, (long)this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)log.activeSegment().baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset begins with the active segment.");
    }

    @Test
    public void testCleanableOffsetsForTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put("internal.segment.bytes", Predef$.MODULE$.int2Integer(1024));
        logProps.put("min.compaction.lag.ms", Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        UnifiedLog log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0);
        }
        LogSegment activeSegAtT0 = log.activeSegment();
        this.time().sleep((long)(compactionLag + 1));
        long t1 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t1), 0);
        }
        log.updateHighWatermark(log.logEndOffset());
        Optional<Long> lastCleanOffset = Optional.of(BoxesRunTime.boxToLong((long)0L));
        LogCleanerManager.OffsetsToClean cleanableOffsets = LogCleanerManager.cleanableOffsets((UnifiedLog)log, lastCleanOffset, (long)this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)activeSegAtT0.baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset begins with the second block of log entries.");
    }

    @Test
    public void testCleanableOffsetsForShortTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put("internal.segment.bytes", Predef$.MODULE$.int2Integer(1024));
        logProps.put("min.compaction.lag.ms", Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        UnifiedLog log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0);
        }
        log.updateHighWatermark(log.logEndOffset());
        this.time().sleep((long)(compactionLag + 1));
        Optional<Long> lastCleanOffset = Optional.of(BoxesRunTime.boxToLong((long)0L));
        LogCleanerManager.OffsetsToClean cleanableOffsets = LogCleanerManager.cleanableOffsets((UnifiedLog)log, lastCleanOffset, (long)this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)log.activeSegment().baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset begins with active segment.");
    }

    @Test
    public void testCleanableOffsetsNeedsCheckpointReset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ConcurrentMap<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((UnifiedLog)logs.get(tp)).maybeIncrementLogStartOffset(10L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        Optional<Long> lastCleanOffset = Optional.of(BoxesRunTime.boxToLong((long)15L));
        Assertions.assertFalse((boolean)LogCleanerManager.cleanableOffsets((UnifiedLog)((UnifiedLog)logs.get(tp)), lastCleanOffset, (long)this.time().milliseconds()).forceUpdateCheckpoint(), (String)"Checkpoint offset should not be reset if valid");
        ((UnifiedLog)logs.get(tp)).maybeIncrementLogStartOffset(20L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        Assertions.assertTrue((boolean)LogCleanerManager.cleanableOffsets((UnifiedLog)((UnifiedLog)logs.get(tp)), lastCleanOffset, (long)this.time().milliseconds()).forceUpdateCheckpoint(), (String)"Checkpoint offset needs to be reset if less than log start offset");
        lastCleanOffset = Optional.of(Predef$.MODULE$.long2Long(25L));
        Assertions.assertTrue((boolean)LogCleanerManager.cleanableOffsets((UnifiedLog)((UnifiedLog)logs.get(tp)), lastCleanOffset, (long)this.time().milliseconds()).forceUpdateCheckpoint(), (String)"Checkpoint offset needs to be reset if greater than log end offset");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUndecidedTransactionalDataNotCleanable() {
        void withEndTransactionMarker_marker;
        void withTransactionalRecords_records;
        void withTransactionalRecords_baseSequence;
        void withTransactionalRecords_records2;
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put("internal.segment.bytes", Predef$.MODULE$.int2Integer(1024));
        logProps.put("min.compaction.lag.ms", Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        UnifiedLog log = this.makeLog(x$2, x$1);
        long producerId = 15L;
        short producerEpoch = (short)0;
        int sequence = 0;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "1".getBytes(), "a".getBytes()), new SimpleRecord(this.time().milliseconds(), "2".getBytes(), "b".getBytes())};
        NoCompression withTransactionalRecords_compression = Compression.NONE;
        Object var11_10 = null;
        simpleRecordArray = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)0L, (Compression)withTransactionalRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)sequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records2), 0);
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "3".getBytes(), "c".getBytes())};
        int n = sequence + 2;
        NoCompression withTransactionalRecords_compression2 = Compression.NONE;
        Object var13_13 = null;
        simpleRecordArray2 = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)0L, (Compression)withTransactionalRecords_compression2, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)withTransactionalRecords_baseSequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records), 0);
        log.roll();
        log.updateHighWatermark(3L);
        this.time().sleep((long)(compactionLag + 1));
        LogCleanerManager.OffsetsToClean cleanableOffsets = LogCleanerManager.cleanableOffsets((UnifiedLog)log, Optional.of(Predef$.MODULE$.long2Long(0L)), (long)this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
        EndTransactionMarker endTransactionMarker = new EndTransactionMarker(ControlRecordType.ABORT, 15);
        long withEndTransactionMarker_timestamp = this.time().milliseconds();
        endTransactionMarker = null;
        log.appendAsLeader(MemoryRecords.withEndTransactionMarker((long)0L, (long)withEndTransactionMarker_timestamp, (int)-1, (long)producerId, (short)producerEpoch, (EndTransactionMarker)withEndTransactionMarker_marker), 0, AppendOrigin.COORDINATOR);
        log.roll();
        log.updateHighWatermark(4L);
        cleanableOffsets = LogCleanerManager.cleanableOffsets((UnifiedLog)log, Optional.of(Predef$.MODULE$.long2Long(0L)), (long)this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assertions.assertEquals((long)3L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
        this.time().sleep((long)(compactionLag + 1));
        cleanableOffsets = LogCleanerManager.cleanableOffsets((UnifiedLog)log, Optional.of(Predef$.MODULE$.long2Long(0L)), (long)this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assertions.assertEquals((long)4L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
    }

    @Test
    public void testDoneCleaning() {
        Properties logProps = new Properties();
        logProps.put("internal.segment.bytes", Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        UnifiedLog log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0);
        }
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningState.logCleaningPaused((int)1));
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningState.LOG_CLEANING_IN_PROGRESS);
        long endOffset = 1L;
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), endOffset);
        Assertions.assertTrue((boolean)cleanerManager.cleaningState(this.topicPartition()).isEmpty());
        Assertions.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().containsKey(this.topicPartition()));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)), (Object)Option$.MODULE$.apply(cleanerManager.allCleanerCheckpoints().get(this.topicPartition())));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningState.LOG_CLEANING_ABORTED);
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), endOffset);
        Assertions.assertEquals((Object)LogCleaningState.logCleaningPaused((int)1), cleanerManager.cleaningState(this.topicPartition()).get());
        Assertions.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().containsKey(this.topicPartition()));
    }

    @Test
    public void testDoneDeleting() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), (Compression)Compression.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "compact,delete", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        TopicPartition tp = new TopicPartition("log", 0);
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneDeleting(java.util.List.of(tp)));
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningState.logCleaningPaused((int)1));
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneDeleting(java.util.List.of(tp)));
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningState.LOG_CLEANING_IN_PROGRESS);
        cleanerManager.doneDeleting(java.util.List.of(tp));
        Assertions.assertTrue((boolean)cleanerManager.cleaningState(tp).isEmpty());
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningState.LOG_CLEANING_ABORTED);
        cleanerManager.doneDeleting(java.util.List.of(tp));
        Assertions.assertEquals((Object)LogCleaningState.logCleaningPaused((int)1), cleanerManager.cleaningState(tp).get());
    }

    @Test
    public void testCheckpointUpdatedForInvalidOffsetNoCleaning() {
        TopicPartition tp = new TopicPartition("foo", 0);
        ConcurrentMap<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((UnifiedLog)logs.get(tp)).maybeIncrementLogStartOffset(20L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put(tp, Predef$.MODULE$.long2Long(15L));
        Optional filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), new PreCleanStats());
        Assertions.assertEquals(Optional.empty(), (Object)filthiestLog, (String)"Log should not be selected for cleaning");
        Assertions.assertEquals((long)20L, (Long)this.cleanerCheckpoints().get(tp), (String)"Unselected log should have checkpoint offset updated");
    }

    @Test
    public void testCheckpointUpdatedForInvalidOffsetNotSelected() {
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)Nil$.MODULE$));
        ConcurrentMap<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        ((UnifiedLog)logs.get(tp0)).maybeIncrementLogStartOffset(15L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put(tp0, Predef$.MODULE$.long2Long(10L));
        this.cleanerCheckpoints().put(tp1, Predef$.MODULE$.long2Long(5L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), new PreCleanStats()).get();
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition(), (String)"Dirtier log should be selected");
        Assertions.assertEquals((long)15L, (Long)this.cleanerCheckpoints().get(tp0), (String)"Unselected log should have checkpoint offset updated");
    }

    private LogCleanerManager createCleanerManager(UnifiedLog log) {
        ConcurrentHashMap<TopicPartition, UnifiedLog> logs = new ConcurrentHashMap<TopicPartition, UnifiedLog>();
        logs.put(this.topicPartition(), log);
        return new LogCleanerManager(java.util.List.of(this.logDir(), this.logDir2()), logs, null);
    }

    private LogCleanerManagerMock createCleanerManagerMock(ConcurrentMap<TopicPartition, UnifiedLog> pool) {
        return new LogCleanerManagerMock(java.util.List.of(this.logDir()), pool, null);
    }

    private UnifiedLog createLog(int segmentSize, String cleanupPolicy, TopicPartition topicPartition) {
        LogConfig config = this.createLowRetentionLogConfig(segmentSize, cleanupPolicy);
        return UnifiedLog.create((File)new File(this.logDir(), LocalLog.logDirName((TopicPartition)topicPartition)), (LogConfig)config, (long)0L, (long)0L, (Scheduler)this.time().scheduler, (BrokerTopicStats)new BrokerTopicStats(), (Time)this.time(), (int)300000, (ProducerStateManagerConfig)this.producerStateManagerConfig(), (int)600000, (LogDirFailureChannel)new LogDirFailureChannel(10), (boolean)true, Optional.empty());
    }

    private TopicPartition createLog$default$3() {
        return new TopicPartition("log", 0);
    }

    private LogConfig createLowRetentionLogConfig(int segmentSize, String cleanupPolicy) {
        Properties logProps = new Properties();
        logProps.put("internal.segment.bytes", Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put("retention.ms", Predef$.MODULE$.int2Integer(1));
        logProps.put("cleanup.policy", cleanupPolicy);
        logProps.put("min.cleanable.dirty.ratio", Predef$.MODULE$.double2Double(0.05));
        return new LogConfig((Map)logProps);
    }

    private void writeRecords(UnifiedLog log, int numBatches, int recordsPerBatch, int batchesPerSegment) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numBatches).foreach((Function1 & Serializable)i -> LogCleanerManagerTest.$anonfun$writeRecords$1(this, log, recordsPerBatch, batchesPerSegment, BoxesRunTime.unboxToInt((Object)i)));
        log.roll();
    }

    /*
     * WARNING - void declaration
     */
    private void appendRecords(UnifiedLog log, int numRecords) {
        void withRecords_records;
        void withRecords_timestampType;
        long startOffset = log.logEndOffset();
        long endOffset = startOffset + (long)numRecords;
        LongRef lastTimestamp = LongRef.create((long)0L);
        IndexedSeq records = (IndexedSeq)new RichLong(Predef$.MODULE$.longWrapper(startOffset)).until((Object)BoxesRunTime.boxToLong((long)endOffset)).map((Function1 & Serializable)offset -> LogCleanerManagerTest.$anonfun$appendRecords$1(this, endOffset, lastTimestamp, BoxesRunTime.unboxToLong((Object)offset)));
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var9_8 = null;
        simpleRecordArray = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records), 1);
        log.maybeIncrementHighWatermark(log.logEndOffsetMetadata());
    }

    private UnifiedLog makeLog(File dir, LogConfig config) {
        return UnifiedLog.create((File)dir, (LogConfig)config, (long)0L, (long)0L, (Scheduler)this.time().scheduler, (BrokerTopicStats)new BrokerTopicStats(), (Time)this.time(), (int)300000, (ProducerStateManagerConfig)this.producerStateManagerConfig(), (int)600000, (LogDirFailureChannel)new LogDirFailureChannel(10), (boolean)true, Optional.empty());
    }

    private File makeLog$default$1() {
        return this.logDir();
    }

    /*
     * WARNING - void declaration
     */
    private MemoryRecords records(int key, int value, long timestamp) {
        void withRecords_records;
        void withRecords_timestampType;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(timestamp, Integer.toString(key).getBytes(), Integer.toString(value).getBytes())};
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        return MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    public static final /* synthetic */ void $anonfun$setupIncreasinglyFilthyLogs$1(LogCleanerManagerTest $this, ConcurrentHashMap logs$1, IntRef numBatches$1, int batchIncrement$1, TopicPartition tp) {
        UnifiedLog log = $this.createLog(2048, "compact", tp);
        logs$1.put(tp, log);
        $this.writeRecords(log, numBatches$1.elem, 1, 5);
        numBatches$1.elem += batchIncrement$1;
    }

    public static final /* synthetic */ Object $anonfun$writeRecords$1(LogCleanerManagerTest $this, UnifiedLog log$2, int recordsPerBatch$1, int batchesPerSegment$1, int i) {
        $this.appendRecords(log$2, recordsPerBatch$1);
        if (i % batchesPerSegment$1 == 0) {
            return log$2.roll();
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendRecords$1(LogCleanerManagerTest $this, long endOffset$1, LongRef lastTimestamp$1, long offset) {
        long currentTimestamp = $this.time().milliseconds();
        if (offset == endOffset$1 - 1L) {
            lastTimestamp$1.elem = currentTimestamp;
        }
        return new SimpleRecord(currentTimestamp, ("key-" + offset).getBytes(), ("value-" + offset).getBytes());
    }

    public LogCleanerManagerTest() {
        this.logProps().put("internal.segment.bytes", Predef$.MODULE$.int2Integer(1024));
        this.logProps().put("segment.index.bytes", Predef$.MODULE$.int2Integer(1024));
        this.logProps().put("cleanup.policy", "compact");
        this.logConfig = new LogConfig((Map)this.logProps());
        this.time = new MockTime(1400000000000L, 1000L);
        this.offset = 999;
        this.producerStateManagerConfig = new ProducerStateManagerConfig(86400000, false);
        this.cleanerCheckpoints = new HashMap();
    }

    public class LogCleanerManagerMock
    extends LogCleanerManager {
        public Map<TopicPartition, Long> allCleanerCheckpoints() {
            return this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints();
        }

        public void updateCheckpoints(File dataDir, Optional<Map.Entry<TopicPartition, Long>> partitionToUpdateOrAdd, Optional<TopicPartition> partitionToRemove) {
            Predef$.MODULE$.assert(partitionToRemove.isEmpty(), (Function0 & Serializable)() -> "partitionToRemove argument with value not yet handled");
            Map.Entry<TopicPartition, Long> entry = partitionToUpdateOrAdd.orElseThrow(() -> new IllegalArgumentException("partitionToUpdateOrAdd==None argument not yet handled"));
            this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().put(entry.getKey(), entry.getValue());
        }

        public /* synthetic */ LogCleanerManagerTest kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer() {
            return LogCleanerManagerTest.this;
        }

        public LogCleanerManagerMock(java.util.List<File> logDirs, ConcurrentMap<TopicPartition, UnifiedLog> logs, LogDirFailureChannel logDirFailureChannel) {
            if (LogCleanerManagerTest.this == null) {
                throw null;
            }
            super(logDirs, logs, logDirFailureChannel);
        }
    }
}

