/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.ThrottledReplicaListValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Uf\u0001\u0002\u000f\u001e\u0001\tBQ!\u000b\u0001\u0005\u0002)BQ!\f\u0001\u0005\u00029BQa\u0010\u0001\u0005\u00029BQ!\u0011\u0001\u0005\u00029BQa\u0011\u0001\u0005\u00029BQ!\u0012\u0001\u0005\u00029BQa\u0012\u0001\u0005\u00029BQ!\u0013\u0001\u0005\u00029BQa\u0013\u0001\u0005\u00029BQ!\u0014\u0001\u0005\u00029BQa\u0014\u0001\u0005\u00029BQ!\u0015\u0001\u0005\nICQa\u0019\u0001\u0005\n\u0011DQ\u0001\u001c\u0001\u0005\u00029BQA\u001c\u0001\u0005\u00029BQ\u0001\u001d\u0001\u0005\u00029BQA\u001d\u0001\u0005\u00029BQ\u0001\u001e\u0001\u0005\nUDa!a\b\u0001\t\u0003q\u0003bBA\u0012\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003'\u0002A\u0011AA+\u0011\u001d\t)\u0007\u0001C\u0001\u0003OBq!!\u001e\u0001\t\u0003\t9\bC\u0004\u0002\u0006\u0002!\t!a\"\t\u000f\u0005U\u0005\u0001\"\u0001\u0002\u0018\"9\u00111\u0015\u0001\u0005\u0002\u0005\u0015\u0006BBAY\u0001\u0011\u0005aFA\u0007M_\u001e\u001cuN\u001c4jOR+7\u000f\u001e\u0006\u0003=}\t1\u0001\\8h\u0015\u0005\u0001\u0013!B6bM.\f7\u0001A\n\u0003\u0001\r\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001,!\ta\u0003!D\u0001\u001e\u0003Y!Xm\u001d;LC\u001a\\\u0017mQ8oM&<Gk\u001c)s_B\u001cH#A\u0018\u0011\u0005\u0011\u0002\u0014BA\u0019&\u0005\u0011)f.\u001b;)\u0005\t\u0019\u0004C\u0001\u001b>\u001b\u0005)$B\u0001\u001c8\u0003\r\t\u0007/\u001b\u0006\u0003qe\nqA[;qSR,'O\u0003\u0002;w\u0005)!.\u001e8ji*\tA(A\u0002pe\u001eL!AP\u001b\u0003\tQ+7\u000f^\u0001\u0015i\u0016\u001cHO\u0012:p[B\u0013x\u000e]:J]Z\fG.\u001b3)\u0005\r\u0019\u0014A\b;fgRLeN^1mS\u0012\u001cu.\u001c9bGRLwN\u001c'bO\u000e{gNZ5hQ\t!1'A\u0013tQ>,H\u000e\u001a,bY&$\u0017\r^3UQJ|G\u000f\u001e7fIJ+\u0007\u000f\\5dCN\u001cuN\u001c4jO\"\u0012QaM\u0001\u0010i\u0016\u001cH\u000fV8Ii6dG+\u00192mK\"\u0012aaM\u0001\u000bi\u0016\u001cH\u000fV8Ii6d\u0007FA\u00044\u0003E!Xm\u001d;U_\u0016s'/[2iK\u0012\u00146\u000f\u001e\u0015\u0003\u0011M\n\u0011\u0002^3tiR{'k\u001d;)\u0005%\u0019\u0014A\u0005;fgR<U\r^\"p]\u001aLwMV1mk\u0016D#AC\u001a\u0002KQ,7\u000f^(wKJ\u0014\u0018\u000e\u001a3f]\u000e{gNZ5hg\u0006\u001bHj\\4hC\ndWm\u0015;sS:<\u0007FA\u00064\u0003\u001dI7OV1mS\u0012$\"a\u0015,\u0011\u0005\u0011\"\u0016BA+&\u0005\u001d\u0011un\u001c7fC:DQa\u0016\u0007A\u0002a\u000b1bY8oM&<g+\u00197vKB\u0011\u0011\f\u0019\b\u00035z\u0003\"aW\u0013\u000e\u0003qS!!X\u0011\u0002\rq\u0012xn\u001c;?\u0013\tyV%\u0001\u0004Qe\u0016$WMZ\u0005\u0003C\n\u0014aa\u0015;sS:<'BA0&\u0003U\t7o]3siB\u0013x\u000e]3sifLeN^1mS\u0012$2aL3h\u0011\u00151W\u00021\u0001Y\u0003\u0011q\u0017-\\3\t\u000b!l\u0001\u0019A5\u0002\rY\fG.^3t!\r!#nI\u0005\u0003W\u0016\u0012!\u0002\u0010:fa\u0016\fG/\u001a3?\u0003\u0005\"Xm\u001d;M_\u000e\fG\u000eT8h%\u0016$XM\u001c;j_:$UM]5wK\u0012\u0004&o\u001c9tQ\tq1'\u0001\u0015uKN$Hj\\2bY2{wMU3uK:$\u0018n\u001c8EKJLg/\u001a3EK\u001a\fW\u000f\u001c;Qe>\u00048\u000f\u000b\u0002\u0010g\u0005QB/Z:u\u0019>\u001c\u0017\r\u001c'pOJ+G/\u001a8uS>t\u0007K]8qg\"\u0012\u0001cM\u0001\"i\u0016\u001cH/\u00138wC2LG\rT8dC2dun\u001a*fi\u0016tG/[8o!J|\u0007o\u001d\u0015\u0003#M\n1\u0005Z8UKN$\u0018J\u001c<bY&$Gj\\2bY2{wMU3uK:$\u0018n\u001c8Qe>\u00048\u000fF\u0005w\u0003\u0007\ti!a\u0006\u0002\u001cA\u0011qo`\u0007\u0002q*\u0011\u0011P_\u0001\u0007G>tg-[4\u000b\u0005md\u0018AB2p[6|gN\u0003\u0002!{*\u0011apO\u0001\u0007CB\f7\r[3\n\u0007\u0005\u0005\u0001PA\bD_:4\u0017nZ#yG\u0016\u0004H/[8o\u0011\u001d\t)A\u0005a\u0001\u0003\u000f\t\u0001\u0003\\8dC2\u0014V\r^3oi&|g.T:\u0011\u0007\u0011\nI!C\u0002\u0002\f\u0015\u0012A\u0001T8oO\"9\u0011q\u0002\nA\u0002\u0005E\u0011a\u00057pG\u0006d'+\u001a;f]RLwN\u001c\"zi\u0016\u001c\bc\u0001\u0013\u0002\u0014%\u0019\u0011QC\u0013\u0003\u0007%sG\u000fC\u0004\u0002\u001aI\u0001\r!!\u0005\u0002\u001dI,G/\u001a8uS>t')\u001f;fg\"9\u0011Q\u0004\nA\u0002\u0005\u001d\u0011a\u0003:fi\u0016tG/[8o\u001bN\fq\u0005^3ti\u0016s\u0017M\u00197f%\u0016lw\u000e^3M_\u001e\u001cFo\u001c:bO\u0016\u001cE.Z1okB\u0004v\u000e\\5ds\"\u00121cM\u0001\u001bi\u0016\u001cH/\u00128bE2,'+Z7pi\u0016dunZ*u_J\fw-\u001a\u000b\u0004_\u0005\u001d\u0002BBA\u0015)\u0001\u00071+A\ftsN\u0014V-\\8uKN#xN]1hK\u0016s\u0017M\u00197fI\"2A#!\fg\u0003s\u0001B!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0004\u0003g9\u0014A\u00029be\u0006l7/\u0003\u0003\u00028\u0005E\"!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006\u0012\u00111H\u0001=i\u0016\u001cH/\u00128bE2,'+Z7pi\u0016dunZ*u_J\fw-\u001a\u0011xSRD\u0007e]=t%\u0016lw\u000e^3Ti>\u0014\u0018mZ3F]\u0006\u0014G.\u001a3;Am\u0004T\u0010K\u0004\u0015\u0003\u007f\tY%!\u0014\u0011\t\u0005\u0005\u0013qI\u0007\u0003\u0003\u0007RA!!\u0012\u00022\u0005A\u0001O]8wS\u0012,'/\u0003\u0003\u0002J\u0005\r#a\u0003,bYV,7k\\;sG\u0016\f\u0001BY8pY\u0016\fgn\u001d\u0017\u0005\u0003\u001f\n\t&G\u0001\u00023\u0005\u0001\u0011a\u0007;fgR$\u0015n]1cY\u0016\u0014V-\\8uK2{wm\u0015;pe\u0006<W\rF\u00020\u0003/Ba!!\u0017\u0016\u0001\u0004\u0019\u0016aF<bgJ+Wn\u001c;f'R|'/Y4f\u000b:\f'\r\\3eQ\u0019)\u0012Q\u00064\u0002^\u0005\u0012\u0011qL\u0001>i\u0016\u001cH\u000fR5tC\ndWMU3n_R,Gj\\4Ti>\u0014\u0018mZ3!o&$\b\u000eI<bgJ+Wn\u001c;f'R|'/Y4f\u000b:\f'\r\\3eu\u0001Z\b' \u0015\b+\u0005}\u00121JA2Y\u0011\ty%!\u0015\u0002SQ,7\u000f\u001e+pa&\u001c7I]3bi&|gnV5uQ&sg/\u00197jIJ+G/\u001a8uS>tG+[7f)\ry\u0013\u0011\u000e\u0005\u0007\u0003S1\u0002\u0019A*)\rY\tiCZA7C\t\ty'A&uKN$Hk\u001c9jG\u000e\u0013X-\u0019;j_:<\u0016\u000e\u001e5J]Z\fG.\u001b3SKR,g\u000e^5p]RKW.\u001a\u0011xSRD\u0007e]=t%\u0016lw\u000e^3Ti>\u0014\u0018mZ3F]\u0006\u0014G.\u001a3;Am\u0004T\u0010K\u0004\u0017\u0003\u007f\tY%a\u001d-\t\u0005=\u0013\u0011K\u0001*i\u0016\u001cH\u000fV8qS\u000e\u001c%/Z1uS>tw+\u001b;i\u0013:4\u0018\r\\5e%\u0016$XM\u001c;j_:\u001c\u0016N_3\u0015\u0007=\nI\b\u0003\u0004\u0002*]\u0001\ra\u0015\u0015\u0007/\u00055b-! \"\u0005\u0005}\u0014a\u0013;fgR$v\u000e]5d\u0007J,\u0017\r^5p]^KG\u000f[%om\u0006d\u0017\u000e\u001a*fi\u0016tG/[8o'&TX\rI<ji\"\u00043/_:SK6|G/Z*u_J\fw-Z#oC\ndW\r\u001a\u001e!wBj\bfB\f\u0002@\u0005-\u00131\u0011\u0017\u0005\u0003\u001f\n\t&\u0001\u000fuKN$h+\u00197jI\u0006$XM\u0011:pW\u0016\u0014Hj\\4D_:4\u0017nZ:\u0015\u0007=\nI\t\u0003\u0004\u0002*a\u0001\ra\u0015\u0015\u00071\u00055b-!$\"\u0005\u0005=\u0015A\u0010;fgR4\u0016\r\\5eCR,'I]8lKJdunZ\"p]\u001aLwm\u001d\u0011xSRD\u0007e]=t%\u0016lw\u000e^3Ti>\u0014\u0018mZ3F]\u0006\u0014G.\u001a3;Am\u0004T\u0010K\u0004\u0019\u0003\u007f\tY%a%-\t\u0005=\u0013\u0011K\u0001\u001fi\u0016\u001cHOV1mS\u0012\u0014V-\\8uK2{wmQ8qs\u0012K7/\u00192mK\u0012$2aLAM\u0011\u0019\tY*\u0007a\u0001'\u0006a1m\u001c9z\t&\u001c\u0018M\u00197fI\"\u001a\u0011$!\f)\u000fe\ty$a\u0013\u0002\"2\"\u0011qJA)\u0003\u0005\"Xm\u001d;WC2LGMU3n_R,Gj\\4EK2,G/Z(o\t&\u001c\u0018M\u00197f)\ry\u0013q\u0015\u0005\u0007\u0003SS\u0002\u0019A*\u0002\u001f\u0011,G.\u001a;f\u001f:$\u0015n]1cY\u0016D3AGA\u0017Q\u001dQ\u0012qHA&\u0003_cC!a\u0014\u0002R\u0005QC/Z:u-\u0006d\u0017\u000eZ1uK^KG\u000f['fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8KE>$7+\u001e9q_J$\bFA\u000e4\u0001")
public class LogConfigTest {
    @Test
    public void testKafkaConfigToProps() {
        long millisInHour = 3600000L;
        long millisInDay = 24L * millisInHour;
        long bytesInGB = 0x40000000L;
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        kafkaProps.put("log.roll.hours", "2");
        kafkaProps.put("log.roll.jitter.hours", "2");
        kafkaProps.put("log.retention.hours", "960");
        kafkaProps.put("log.local.retention.ms", "2592000000");
        kafkaProps.put("log.local.retention.bytes", "4294967296");
        Map logProps = KafkaConfig$.MODULE$.fromProps(kafkaProps).extractLogConfigMap();
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get("segment.ms"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get("segment.jitter.ms"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(40L * millisInDay)), logProps.get("retention.ms"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(30L * millisInDay)), logProps.get("local.retention.ms"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(4L * bytesInGB)), logProps.get("local.retention.bytes"));
    }

    @Test
    public void testFromPropsInvalid() {
        LogConfig.configNames().forEach(name -> {
            switch (name == null ? 0 : name.hashCode()) {
                case -1924377471: {
                    if (!"remote.log.copy.disable".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "remove", "0"}));
                    return;
                }
                case -1339220362: {
                    if (!"retention.ms".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                    return;
                }
                case -924619404: {
                    if (!"compression.lz4.level".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-1"}));
                    return;
                }
                case -772457061: {
                    if (!"retention.bytes".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                    return;
                }
                case -537988164: {
                    if (!"cleanup.policy".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"true", "foobar"}));
                    return;
                }
                case -6022648: {
                    if (!"min.cleanable.dirty.ratio".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                    return;
                }
                case 67637273: {
                    if (!"local.retention.ms".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-3"}));
                    return;
                }
                case 268940301: {
                    if (!"min.insync.replicas".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "0", "-1"}));
                    return;
                }
                case 297509630: {
                    if (!"remote.storage.enable".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_boolean"}));
                    return;
                }
                case 632472856: {
                    if (!"local.retention.bytes".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-3"}));
                    return;
                }
                case 1016887921: {
                    if (!"unclean.leader.election.enable".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not a boolean"}));
                    return;
                }
                case 1235439480: {
                    if (!"compression.gzip.level".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-2"}));
                    return;
                }
                case 1494864455: {
                    if (!"compression.zstd.level".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1"}));
                    return;
                }
                case 1613810815: {
                    if (!"internal.segment.bytes".equals(name)) break;
                    return;
                }
                case 2066335274: {
                    if (!"remote.log.delete.on.disable".equals(name)) break;
                    this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "remove", "0"}));
                    return;
                }
            }
            this.assertPropertyInvalid((String)name, (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-1"}));
        });
    }

    @Test
    public void testInvalidCompactionLagConfig() {
        Properties props = new Properties();
        props.setProperty("max.compaction.lag.ms", "100");
        props.setProperty("min.compaction.lag.ms", "200");
        Assertions.assertThrows(Exception.class, () -> LogConfig.validate((Properties)props));
    }

    @Test
    public void shouldValidateThrottledReplicasConfig() {
        Assertions.assertTrue((boolean)this.isValid("*"));
        Assertions.assertTrue((boolean)this.isValid("* "));
        Assertions.assertTrue((boolean)this.isValid(""));
        Assertions.assertTrue((boolean)this.isValid(" "));
        Assertions.assertTrue((boolean)this.isValid("100:10"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10,15:1"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10,15:1  "));
        Assertions.assertTrue((boolean)this.isValid("100:0,"));
        Assertions.assertFalse((boolean)this.isValid("100"));
        Assertions.assertFalse((boolean)this.isValid("100:"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10:"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100 :0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100: 0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100:0,10 :   "));
        Assertions.assertFalse((boolean)this.isValid("*,100:10"));
        Assertions.assertFalse((boolean)this.isValid("* ,100:10"));
    }

    @Test
    public void testToHtmlTable() {
        String html = LogConfig.configDefCopy().toHtmlTable();
        String expectedConfig = "<td>file.delete.delay.ms</td>";
        Assertions.assertTrue((boolean)html.contains(expectedConfig), (String)("Could not find `" + expectedConfig + "` in:\n " + html));
    }

    @Test
    public void testToHtml() {
        String html = LogConfig.configDefCopy().toHtml(4, key -> "prefix_" + key, Map.of());
        String expectedConfig = "<h4><a id=\"file.delete.delay.ms\"></a><a id=\"prefix_file.delete.delay.ms\" href=\"#prefix_file.delete.delay.ms\">file.delete.delay.ms</a></h4>";
        Assertions.assertTrue((boolean)html.contains(expectedConfig), (String)("Could not find `" + expectedConfig + "` in:\n " + html));
    }

    @Test
    public void testToEnrichedRst() {
        String rst = LogConfig.configDefCopy().toEnrichedRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assertions.assertTrue((boolean)rst.contains(expectedConfig), (String)("Could not find `" + expectedConfig + "` in:\n " + rst));
    }

    @Test
    public void testToRst() {
        String rst = LogConfig.configDefCopy().toRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assertions.assertTrue((boolean)rst.contains(expectedConfig), (String)("Could not find `" + expectedConfig + "` in:\n " + rst));
    }

    @Test
    public void testGetConfigValue() {
        LogConfig.LogConfigDef configDef = LogConfig.configDefCopy();
        String configNameWithNoServerMapping = "log.foo";
        configDef.define(configNameWithNoServerMapping, ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)1), ConfigDef.Importance.MEDIUM, configNameWithNoServerMapping + " doc");
        ConfigDef.ConfigKey deleteDelayKey = (ConfigDef.ConfigKey)configDef.configKeys().get("file.delete.delay.ms");
        String deleteDelayServerDefault = configDef.getConfigValue(deleteDelayKey, "Server Default Property");
        Assertions.assertEquals((Object)ServerLogConfigs.LOG_DELETE_DELAY_MS_CONFIG, (Object)deleteDelayServerDefault);
        ConfigDef.ConfigKey keyWithNoServerMapping = (ConfigDef.ConfigKey)configDef.configKeys().get(configNameWithNoServerMapping);
        Assertions.assertNull((Object)configDef.getConfigValue(keyWithNoServerMapping, "Server Default Property"));
    }

    @Test
    public void testOverriddenConfigsAsLoggableString() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        kafkaProps.put("unknown.broker.password.config", "aaaaa");
        kafkaProps.put(ServerLogConfigs.LOG_RETENTION_BYTES_CONFIG, "50");
        kafkaProps.put("ssl.key.password", "somekeypassword");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties topicOverrides = new Properties();
        topicOverrides.setProperty("min.insync.replicas", "2");
        topicOverrides.setProperty("retention.bytes", "100");
        topicOverrides.setProperty("ssl.truststore.password", "sometrustpasswrd");
        topicOverrides.setProperty("unknown.topic.password.config", "bbbb");
        LogConfig logConfig = LogConfig.fromProps((Map)kafkaConfig.extractLogConfigMap(), (Properties)topicOverrides);
        Assertions.assertEquals((Object)"{min.insync.replicas=2, retention.bytes=100, ssl.truststore.password=(redacted), unknown.topic.password.config=(redacted)}", (Object)logConfig.overriddenConfigsAsLoggableString());
    }

    private boolean isValid(String configValue) {
        try {
            ThrottledReplicaListValidator.ensureValidString((String)"", (String)configValue);
            return true;
        }
        catch (ConfigException configException) {
            return false;
        }
    }

    private void assertPropertyInvalid(String name, Seq<Object> values) {
        values.foreach((Function1 & Serializable)value -> {
            Properties props = new Properties();
            props.setProperty(name, value.toString());
            return (Exception)Assertions.assertThrows(Exception.class, () -> new LogConfig((Map)props), () -> "Property " + name + " should not allow " + value);
        });
    }

    @Test
    public void testLocalLogRetentionDerivedProps() {
        Properties props = new Properties();
        int retentionBytes = 1024;
        long retentionMs = 1000L;
        props.put("retention.bytes", Integer.toString(retentionBytes));
        props.put("retention.ms", Long.toString(retentionMs));
        LogConfig logConfig = new LogConfig((Map)props);
        Assertions.assertEquals((long)retentionMs, (long)logConfig.localRetentionMs());
        Assertions.assertEquals((long)retentionBytes, (long)logConfig.localRetentionBytes());
    }

    @Test
    public void testLocalLogRetentionDerivedDefaultProps() {
        LogConfig logConfig = new LogConfig((Map)new Properties());
        Assertions.assertEquals((long)604800000L, (long)logConfig.localRetentionMs());
        Assertions.assertEquals((long)-1L, (long)logConfig.localRetentionBytes());
    }

    @Test
    public void testLocalLogRetentionProps() {
        Properties props = new Properties();
        int localRetentionMs = 500;
        int localRetentionBytes = 1000;
        props.put("retention.bytes", Integer.toString(2000));
        props.put("retention.ms", Integer.toString(1000));
        props.put("local.retention.ms", Integer.toString(localRetentionMs));
        props.put("local.retention.bytes", Integer.toString(localRetentionBytes));
        LogConfig logConfig = new LogConfig((Map)props);
        Assertions.assertEquals((long)localRetentionMs, (long)logConfig.localRetentionMs());
        Assertions.assertEquals((long)localRetentionBytes, (long)logConfig.localRetentionBytes());
    }

    @Test
    public void testInvalidLocalLogRetentionProps() {
        this.doTestInvalidLocalLogRetentionProps(-3L, 10, 2, 500L);
        this.doTestInvalidLocalLogRetentionProps(500L, -3, 2, 1000L);
        this.doTestInvalidLocalLogRetentionProps(2000L, 2, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(500L, 200, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(-1L, 200, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(2000L, -1, 100, 1000L);
    }

    private ConfigException doTestInvalidLocalLogRetentionProps(long localRetentionMs, int localRetentionBytes, int retentionBytes, long retentionMs) {
        Properties kafkaProps = TestUtils$.MODULE$.createDummyBrokerConfig();
        kafkaProps.put("remote.log.storage.system.enable", "true");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties props = new Properties();
        props.put("remote.storage.enable", "true");
        props.put("retention.bytes", Integer.toString(retentionBytes));
        props.put("retention.ms", Long.toString(retentionMs));
        props.put("local.retention.ms", Long.toString(localRetentionMs));
        props.put("local.retention.bytes", Integer.toString(localRetentionBytes));
        return (ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate(Map.of(), (Properties)props, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled()));
    }

    @Test
    public void testEnableRemoteLogStorageCleanupPolicy() {
        Properties kafkaProps = TestUtils$.MODULE$.createDummyBrokerConfig();
        kafkaProps.put("remote.log.storage.system.enable", "true");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties logProps = new Properties();
        logProps.put("cleanup.policy", "delete");
        logProps.put("remote.storage.enable", "true");
        LogConfigTest.validateCleanupPolicy$1(logProps, kafkaConfig);
        logProps.put("cleanup.policy", "compact");
        Assertions.assertThrows(ConfigException.class, () -> LogConfigTest.validateCleanupPolicy$1(logProps, kafkaConfig));
        logProps.put("cleanup.policy", "delete,compact");
        Assertions.assertThrows(ConfigException.class, () -> LogConfigTest.validateCleanupPolicy$1(logProps, kafkaConfig));
        logProps.put("cleanup.policy", "compact,delete");
        Assertions.assertThrows(ConfigException.class, () -> LogConfigTest.validateCleanupPolicy$1(logProps, kafkaConfig));
        logProps.put("cleanup.policy", "delete,delete,delete");
        LogConfigTest.validateCleanupPolicy$1(logProps, kafkaConfig);
        logProps.put("cleanup.policy", "");
        Assertions.assertThrows(ConfigException.class, () -> LogConfigTest.validateCleanupPolicy$1(logProps, kafkaConfig));
    }

    @ParameterizedTest(name="testEnableRemoteLogStorage with sysRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testEnableRemoteLogStorage(boolean sysRemoteStorageEnabled) {
        Properties kafkaProps = TestUtils$.MODULE$.createDummyBrokerConfig();
        kafkaProps.put("remote.log.storage.system.enable", Boolean.toString(sysRemoteStorageEnabled));
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties logProps = new Properties();
        logProps.put("remote.storage.enable", "true");
        if (sysRemoteStorageEnabled) {
            LogConfig.validate(Map.of(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled());
            return;
        }
        Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate(Map.of(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled()))).getMessage().contains("Tiered Storage functionality is disabled in the broker"));
    }

    @ParameterizedTest(name="testDisableRemoteLogStorage with wasRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testDisableRemoteLogStorage(boolean wasRemoteStorageEnabled) {
        Properties kafkaProps = TestUtils$.MODULE$.createDummyBrokerConfig();
        kafkaProps.put("remote.log.storage.system.enable", "true");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties logProps = new Properties();
        logProps.put("remote.storage.enable", "false");
        if (wasRemoteStorageEnabled) {
            Assertions.assertTrue((boolean)((InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> LogConfig.validate(Map.of("remote.storage.enable", "true"), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled()))).getMessage().contains("It is invalid to disable remote storage without deleting remote data. If you want to keep the remote data and turn to read only, please set `remote.storage.enable=true,remote.log.copy.disable=true`. If you want to disable remote storage and delete all remote data, please set `remote.storage.enable=false,remote.log.delete.on.disable=true`."));
            logProps.put("remote.log.delete.on.disable", "true");
            LogConfig.validate(Map.of("remote.storage.enable", "true"), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled());
            return;
        }
        LogConfig.validate(Map.of(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled());
        LogConfig.validate(Map.of("remote.storage.enable", "false"), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled());
    }

    @ParameterizedTest(name="testTopicCreationWithInvalidRetentionTime with sysRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testTopicCreationWithInvalidRetentionTime(boolean sysRemoteStorageEnabled) {
        Properties kafkaProps = TestUtils$.MODULE$.createDummyBrokerConfig();
        kafkaProps.put("remote.log.storage.system.enable", Boolean.toString(sysRemoteStorageEnabled));
        kafkaProps.put(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, "1000");
        kafkaProps.put("log.local.retention.ms", "900");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties logProps = new Properties();
        logProps.put("remote.storage.enable", Boolean.toString(sysRemoteStorageEnabled));
        logProps.put("retention.ms", "500");
        if (sysRemoteStorageEnabled) {
            Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate(Map.of(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled()))).getMessage().contains("local.retention.ms"));
            return;
        }
        LogConfig.validate(Map.of(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled());
    }

    @ParameterizedTest(name="testTopicCreationWithInvalidRetentionSize with sysRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testTopicCreationWithInvalidRetentionSize(boolean sysRemoteStorageEnabled) {
        Properties props = TestUtils$.MODULE$.createDummyBrokerConfig();
        props.put("remote.log.storage.system.enable", Boolean.toString(sysRemoteStorageEnabled));
        props.put(ServerLogConfigs.LOG_RETENTION_BYTES_CONFIG, "1024");
        props.put("log.local.retention.bytes", "512");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        Properties logProps = new Properties();
        logProps.put("remote.storage.enable", Boolean.toString(sysRemoteStorageEnabled));
        logProps.put("retention.bytes", "128");
        if (sysRemoteStorageEnabled) {
            Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate(Map.of(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled()))).getMessage().contains("local.retention.bytes"));
            return;
        }
        LogConfig.validate(Map.of(), (Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled());
    }

    @ParameterizedTest(name="testValidateBrokerLogConfigs with sysRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testValidateBrokerLogConfigs(boolean sysRemoteStorageEnabled) {
        Properties props = TestUtils$.MODULE$.createDummyBrokerConfig();
        props.put("remote.log.storage.system.enable", Boolean.toString(sysRemoteStorageEnabled));
        props.put(ServerLogConfigs.LOG_RETENTION_BYTES_CONFIG, "1024");
        props.put("log.local.retention.bytes", "2048");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        if (sysRemoteStorageEnabled) {
            Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validateBrokerLogConfigValues((Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled()))).getMessage().contains("local.retention.bytes"));
            return;
        }
        LogConfig.validateBrokerLogConfigValues((Map)kafkaConfig.extractLogConfigMap(), (boolean)kafkaConfig.remoteLogManagerConfig().isRemoteStorageSystemEnabled());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testValidRemoteLogCopyDisabled(boolean copyDisabled) {
        Properties logProps = new Properties();
        logProps.put("remote.log.copy.disable", Boolean.toString(copyDisabled));
        LogConfig.validate((Properties)logProps);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testValidRemoteLogDeleteOnDisable(boolean deleteOnDisable) {
        Properties logProps = new Properties();
        logProps.put("remote.log.delete.on.disable", Boolean.toString(deleteOnDisable));
        LogConfig.validate((Properties)logProps);
    }

    @Test
    public void testValidateWithMetadataVersionJbodSupport() {
        LogConfigTest.validate$1(MetadataVersion.IBP_3_6_IV2, false);
        LogConfigTest.validate$1(MetadataVersion.IBP_3_7_IV0, false);
        LogConfigTest.validate$1(MetadataVersion.IBP_3_7_IV2, false);
        Assertions.assertThrows(IllegalArgumentException.class, () -> LogConfigTest.validate$1(MetadataVersion.IBP_3_6_IV2, true));
        Assertions.assertThrows(IllegalArgumentException.class, () -> LogConfigTest.validate$1(MetadataVersion.IBP_3_7_IV0, true));
        LogConfigTest.validate$1(MetadataVersion.IBP_3_7_IV2, true);
    }

    private static final void validateCleanupPolicy$1(Properties logProps$1, KafkaConfig kafkaConfig$2) {
        LogConfig.validate(Map.of(), (Properties)logProps$1, (Map)kafkaConfig$2.extractLogConfigMap(), (boolean)kafkaConfig$2.remoteLogManagerConfig().isRemoteStorageSystemEnabled());
    }

    private static final void validate$1(MetadataVersion metadataVersion, boolean jbodConfig) {
        int x$2 = jbodConfig ? 2 : 1;
        boolean x$3 = true;
        boolean x$4 = true;
        TestUtils$ createBrokerConfig$default$4_this = TestUtils$.MODULE$;
        Object var21_5 = null;
        int x$5 = createBrokerConfig$default$4_this.RandomPort();
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var22_12 = null;
        int x$11 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var23_15 = null;
        int x$13 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var24_18 = null;
        int x$15 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, x$3, x$4, x$5, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$2, x$17, x$18, x$19, x$20)).validateWithMetadataVersion(metadataVersion);
    }
}

