/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricPredicate;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.metrics.LinuxIoMetricsCollector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=120L)
@ScalaSignature(bytes="\u0006\u0005\u0005\re\u0001\u0002\u000f\u001e\u0001\tBQa\f\u0001\u0005\u0002ABqa\r\u0001C\u0002\u0013\u0005A\u0007\u0003\u0004<\u0001\u0001\u0006I!\u000e\u0005\by\u0001\u0011\r\u0011\"\u00015\u0011\u0019i\u0004\u0001)A\u0005k!9a\b\u0001b\u0001\n\u0003y\u0004B\u0002%\u0001A\u0003%\u0001\tC\u0004J\u0001\t\u0007I\u0011\u0001&\t\rE\u0003\u0001\u0015!\u0003L\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u001d\u0001\u0007A1A\u0005\u0002QBa!\u0019\u0001!\u0002\u0013)\u0004\"\u00022\u0001\t\u0003\u0019\u0007\"\u0002;\u0001\t\u0003\u0019\u0007\"\u0002<\u0001\t\u0003\u0019\u0007\"\u0002=\u0001\t\u0003\u0019\u0007\"\u0002>\u0001\t\u0003\u0019\u0007\"\u0002?\u0001\t\u0003\u0019\u0007\"\u0002@\u0001\t\u0003\u0019\u0007BBA\u0001\u0001\u0011\u00051\r\u0003\u0004\u0002\u0006\u0001!\ta\u0019\u0005\u0007\u0003\u0013\u0001A\u0011A2\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010!1\u00111\u000b\u0001\u0005\u0002\rDq!a\u0016\u0001\t\u0013\tI\u0006C\u0004\u0002l\u0001!I!!\u001c\t\u000f\u0005E\u0004\u0001\"\u0003\u0002t\tYQ*\u001a;sS\u000e\u001cH+Z:u\u0015\tqr$A\u0004nKR\u0014\u0018nY:\u000b\u0003\u0001\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001G%\u0002\"\u0001J\u0014\u000e\u0003\u0015R!AJ\u0010\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0003Q\u0015\u0012acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o\u001d\t\u0003U5j\u0011a\u000b\u0006\u0003Y}\tQ!\u001e;jYNL!AL\u0016\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012!\r\t\u0003e\u0001i\u0011!H\u0001\t]Vlgj\u001c3fgV\tQ\u0007\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtGA\u0002J]R\f\u0011B\\;n\u001d>$Wm\u001d\u0011\u0002\u00119,X\u000eU1siN\f\u0011B\\;n!\u0006\u0014Ho\u001d\u0011\u00023I,\u0017/^5sK\u0012\\\u0015MZ6b'\u0016\u0014h/\u001a:Qe\u00164\u0017\u000e_\u000b\u0002\u0001B\u0011\u0011IR\u0007\u0002\u0005*\u00111\tR\u0001\u0005Y\u0006twMC\u0001F\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0013%AB*ue&tw-\u0001\u000esKF,\u0018N]3e\u0017\u000647.Y*feZ,'\u000f\u0015:fM&D\b%A\bpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9t+\u0005Y\u0005C\u0001'P\u001b\u0005i%B\u0001(E\u0003\u0011)H/\u001b7\n\u0005Ak%A\u0003)s_B,'\u000f^5fg\u0006\u0001rN^3se&$\u0017N\\4Qe>\u00048\u000fI\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\tA\u000bE\u0002V1jk\u0011A\u0016\u0006\u0003/^\n!bY8mY\u0016\u001cG/[8o\u0013\tIfKA\u0002TKF\u0004\"a\u00170\u000e\u0003qS!!X\u0010\u0002\rM,'O^3s\u0013\tyFLA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!\u00038NKN\u001c\u0018mZ3t\u0003)qW*Z:tC\u001e,7\u000fI\u0001&i\u0016\u001cH/T3ue&\u001c7OU3q_J$XM]!gi\u0016\u0014H)\u001a7fi&tw\rV8qS\u000e$\u0012\u0001\u001a\t\u0003m\u0015L!AZ\u001c\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u001b!\u0004\"!\u001b:\u000e\u0003)T!a\u001b7\u0002\u0007\u0005\u0004\u0018N\u0003\u0002n]\u00069!.\u001e9ji\u0016\u0014(BA8q\u0003\u0015QWO\\5u\u0015\u0005\t\u0018aA8sO&\u00111O\u001b\u0002\u0005)\u0016\u001cH/\u0001\u001buKN$(I]8lKJ$v\u000e]5d\u001b\u0016$(/[2t+:\u0014XmZ5ti\u0016\u0014X\rZ!gi\u0016\u0014H)\u001a7fi&tw\rV8qS\u000eD#A\u00045\u0002'Q,7\u000f^\"mkN$XM]%e\u001b\u0016$(/[2)\u0005=A\u0017!\u0006;fgR\u0014%o\\6feN#\u0018\r^3NKR\u0014\u0018n\u0019\u0015\u0003!!\fA\u0004^3tif\u000bW.\\3s\u001b\u0016$(/[2t\u0007>,h\u000e^'fiJL7\r\u000b\u0002\u0012Q\u0006\u0011B/Z:u\u0019&tW\u000f_%p\u001b\u0016$(/[2tQ\t\u0011\u0002.A\u0007uKN$(*\u0014-GS2$XM\u001d\u0015\u0003'!\f1\u0003^3tiV\u0003H-\u0019;f\u00156Cf)\u001b7uKJD#\u0001\u00065\u0002eQ,7\u000f^$f]\u0016\u0014\u0018\r\u001c\"s_.,'\u000fV8qS\u000elU\r\u001e:jGN\f%/Z$sK\u0016$\u0017\u000e\\=SK\u001eL7\u000f^3sK\u0012D#!\u00065\u00021Q,7\u000f^,j]\u0012|wo]*us2,G+Y4OC6,7\u000f\u000b\u0002\u0017Q\u0006\u0001C/Z:u\u0005J|7.\u001a:U_BL7-T3ue&\u001c7OQ=uKNLenT;u)\r!\u0017\u0011\u0003\u0005\b\u0003'9\u0002\u0019AA\u000b\u000359'o\\;q!J|Go\\2pYB!\u0011qCA\u0013\u001d\u0011\tI\"!\t\u0011\u0007\u0005mq'\u0004\u0002\u0002\u001e)\u0019\u0011qD\u0011\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019cN\u0001\u0007!J,G-\u001a4\n\u0007\u001d\u000b9CC\u0002\u0002$]BsaFA\u0016\u0003o\tI\u0004\u0005\u0003\u0002.\u0005MRBAA\u0018\u0015\r\t\t\u0004\\\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u0005U\u0012q\u0006\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f#!a\u000f\u0002?m$\u0017n\u001d9mCft\u0015-\\3~]\u001d\u0014x.\u001e9Qe>$xnY8m{m\u0004T\u0010K\u0004\u0018\u0003\u007f\tY%!\u0014\u0011\t\u0005\u0005\u0013qI\u0007\u0003\u0003\u0007RA!!\u0012\u00020\u0005A\u0001O]8wS\u0012,'/\u0003\u0003\u0002J\u0005\r#\u0001D'fi\"|GmU8ve\u000e,\u0017!\u0002<bYV,GFAA(C\t\t\t&A\u0011hKR$Vm\u001d;He>,\b\u000f\u0015:pi>\u001cw\u000e\u001c)be\u0006lW\r^3sg\u0006cG.\u0001\u000euKN$8JU1gi\u000e{g\u000e\u001e:pY2,'/T3ue&\u001c7\u000f\u000b\u0002\u0019Q\u0006aAo\u001c9jG6+GO]5dgR!\u00111LA1!\u0015)\u0016QLA\u000b\u0013\r\tyF\u0016\u0002\u0004'\u0016$\bbBA23\u0001\u0007\u0011QM\u0001\u0006i>\u0004\u0018n\u0019\t\u0006m\u0005\u001d\u0014QC\u0005\u0004\u0003S:$AB(qi&|g.A\tu_BL7-T3ue&\u001cwI]8vaN$B!a\u0017\u0002p!9\u00111\r\u000eA\u0002\u0005U\u0011\u0001\u00074jYR,'OQ=U_BL7-T3ue&\u001c'+Z4fqR1\u00111LA;\u0003oBaAH\u000eA\u0002\u0005m\u0003bBA27\u0001\u0007\u0011Q\r\u0015\b\u0001\u0005m\u00141JAA!\rI\u0017QP\u0005\u0004\u0003\u007fR'a\u0002+j[\u0016|W\u000f\u001e\u0010\u0002q\u0002")
public class MetricsTest
extends KafkaServerTestHarness {
    private final int numNodes;
    private final int numParts;
    private final String requiredKafkaServerPrefix;
    private final Properties overridingProps = new Properties();
    private final int nMessages;

    public int numNodes() {
        return this.numNodes;
    }

    public int numParts() {
        return this.numParts;
    }

    public String requiredKafkaServerPrefix() {
        return this.requiredKafkaServerPrefix;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numNodes(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
    }

    public int nMessages() {
        return this.nMessages;
    }

    @Test
    public void testMetricsReporterAfterDeletingTopic() {
        String topic = "test-topic-metric";
        this.createTopic(topic, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.deleteTopic(topic, this.deleteTopic$default$2());
        TestUtils$.MODULE$.verifyTopicDeletion(topic, 1, this.brokers());
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic), (String)"Topic metrics exists after deleteTopic");
    }

    @Test
    public void testBrokerTopicMetricsUnregisteredAfterDeletingTopic() {
        String topic = "test-broker-topic-metric";
        this.createTopic(topic, 2, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, this.nMessages(), -1);
        Assertions.assertTrue((boolean)this.topicMetricGroups(topic).nonEmpty(), (String)"Topic metrics don't exist");
        this.brokers().foreach((Function1 & Serializable)b -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsUnregisteredAfterDeletingTopic$1(topic, b);
            return BoxedUnit.UNIT;
        });
        this.deleteTopic(topic, this.deleteTopic$default$2());
        TestUtils$.MODULE$.verifyTopicDeletion(topic, 1, this.brokers());
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), this.topicMetricGroups(topic), (String)"Topic metrics exists after deleteTopic");
    }

    @Test
    public void testClusterIdMetric() {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testClusterIdMetric$1(this, x$2))), (int)1);
    }

    @Test
    public void testBrokerStateMetric() {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testBrokerStateMetric$1(this, x$3))), (int)1);
    }

    @Test
    public void testYammerMetricsCountMetric() {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testYammerMetricsCountMetric$1(this, x$4))), (int)1);
    }

    @Test
    public void testLinuxIoMetrics() {
        int expectedCount = new LinuxIoMetricsCollector("/proc", Time.SYSTEM).usable() ? 1 : 0;
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        ((IterableOnceOps)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"linux-disk-read-bytes", "linux-disk-write-bytes"}))).foreach((Function1 & Serializable)name -> {
            MetricsTest.$anonfun$testLinuxIoMetrics$1(this, metrics, expectedCount, name);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testJMXFilter() {
        Assertions.assertTrue((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName("kafka.controller:type=KafkaController,name=ActiveControllerCount")));
        Assertions.assertFalse((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName(this.requiredKafkaServerPrefix() + "=ClusterId")));
    }

    @Test
    public void testUpdateJMXFilter() {
        this.brokers().foreach((Function1 & Serializable)broker -> {
            MetricsTest.$anonfun$testUpdateJMXFilter$1(broker);
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName("kafka.controller:type=KafkaController,name=ActiveControllerCount")));
        Assertions.assertTrue((boolean)ManagementFactory.getPlatformMBeanServer().isRegistered(new ObjectName(this.requiredKafkaServerPrefix() + "=ClusterId")));
    }

    @Test
    public void testGeneralBrokerTopicMetricsAreGreedilyRegistered() {
        String topic = "test-broker-topic-metric";
        this.createTopic(topic, 2, this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        Assertions.assertTrue((boolean)this.topicMetrics((Option<String>)None$.MODULE$).nonEmpty(), (String)"General topic metrics don't exist");
        Assertions.assertEquals((int)((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().metricMapKeySet().size(), (int)this.topicMetrics((Option<String>)None$.MODULE$).size());
        Assertions.assertEquals((int)0, (int)((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().metricGaugeMap().size());
        Assertions.assertTrue((boolean)this.topicMetricGroups(topic).isEmpty(), (String)"Topic metrics aren't lazily registered");
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, this.nMessages(), -1);
        Assertions.assertTrue((boolean)this.topicMetricGroups(topic).nonEmpty(), (String)"Topic metrics aren't registered");
    }

    @Test
    public void testWindowsStyleTagNames() {
        String path = "C:\\windows-path\\kafka-logs";
        Map tags = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dir"), (Object)path)}));
        String expectedMBeanName = ((IterableOnceOps)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)tags.keySet().head(), ObjectName.quote(path)}))).mkString("=");
        MetricName metric = new KafkaMetricsGroup(this.getClass()).metricName("test-metric", CollectionConverters$.MODULE$.MapHasAsJava(tags).asJava());
        Predef$.MODULE$.assert(metric.getMBeanName().endsWith(expectedMBeanName));
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testBrokerTopicMetricsBytesInOut(String groupProtocol) {
        String topic = "test-bytes-in-out";
        String replicationBytesIn = "ReplicationBytesInPerSec";
        String replicationBytesOut = "ReplicationBytesOutPerSec";
        String bytesIn = "BytesInPerSec,topic=" + topic;
        String bytesOut = "BytesOutPerSec,topic=" + topic;
        Properties topicConfig = new Properties();
        topicConfig.setProperty("min.insync.replicas", "2");
        this.createTopic(topic, 1, this.numNodes(), topicConfig, this.createTopic$default$5(), this.createTopic$default$6());
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, this.nMessages(), -1);
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.brokers().foreach((Function1 & Serializable)broker -> {
            MetricsTest.$anonfun$testBrokerTopicMetricsBytesInOut$1(topic, topicPartition, broker);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.consumeTopicRecords(this.brokers(), topic, this.nMessages(), GroupProtocol.of((String)groupProtocol), "group", SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, 15000L);
        long initialReplicationBytesIn = TestUtils$.MODULE$.meterCount(replicationBytesIn);
        long initialReplicationBytesOut = TestUtils$.MODULE$.meterCount(replicationBytesOut);
        long initialBytesIn = TestUtils$.MODULE$.meterCount(bytesIn);
        long initialBytesOut = TestUtils$.MODULE$.meterCount(bytesOut);
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), topic, this.nMessages(), -1);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(replicationBytesIn) > initialReplicationBytesIn ? 1 : 0) != 0);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(replicationBytesOut) > initialReplicationBytesOut ? 1 : 0) != 0);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(bytesIn) > initialBytesIn ? 1 : 0) != 0);
        Assertions.assertEquals((long)initialBytesOut, (long)TestUtils$.MODULE$.meterCount(bytesOut));
        TestUtils$.MODULE$.consumeTopicRecords(this.brokers(), topic, this.nMessages(), GroupProtocol.of((String)groupProtocol), "group", SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, 15000L);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(bytesOut) > initialBytesOut ? 1 : 0) != 0);
    }

    @Test
    public void testKRaftControllerMetrics() {
        java.util.Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        ((IterableOnceOps)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"kafka.controller:type=KafkaController,name=ActiveControllerCount", "kafka.controller:type=KafkaController,name=GlobalPartitionCount", "kafka.controller:type=KafkaController,name=GlobalTopicCount", "kafka.controller:type=KafkaController,name=LastAppliedRecordLagMs", "kafka.controller:type=KafkaController,name=LastAppliedRecordOffset", "kafka.controller:type=KafkaController,name=LastAppliedRecordTimestamp", "kafka.controller:type=KafkaController,name=LastCommittedRecordOffset", "kafka.controller:type=KafkaController,name=MetadataErrorCount", "kafka.controller:type=KafkaController,name=OfflinePartitionsCount", "kafka.controller:type=KafkaController,name=PreferredReplicaImbalanceCount"}))).foreach((Function1 & Serializable)expected -> {
            MetricsTest.$anonfun$testKRaftControllerMetrics$1(metrics, expected);
            return BoxedUnit.UNIT;
        });
    }

    private Set<String> topicMetrics(Option<String> topic) {
        scala.collection.mutable.Set metricNames = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().map((Function1 & Serializable)x$9 -> x$9.getMBeanName());
        return this.filterByTopicMetricRegex((Set<String>)metricNames, topic);
    }

    private Set<String> topicMetricGroups(String topic) {
        scala.collection.mutable.Set metricGroups = CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().groupedMetrics(MetricPredicate.ALL).keySet()).asScala();
        return this.filterByTopicMetricRegex((Set<String>)metricGroups, (Option<String>)new Some((Object)topic));
    }

    private Set<String> filterByTopicMetricRegex(Set<String> metrics, Option<String> topic) {
        Pattern pattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*BrokerTopicMetrics.*" + topic.map((Function1 & Serializable)t -> "(" + t + ")$").getOrElse((Function0 & Serializable)() -> ""))).pattern();
        return (Set)metrics.filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$filterByTopicMetricRegex$3(pattern, x$10)));
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsUnregisteredAfterDeletingTopic$1(String topic$1, KafkaBroker b) {
        Assertions.assertNotNull((Object)b.brokerTopicStats().topicStats(topic$1));
    }

    public static final /* synthetic */ boolean $anonfun$testClusterIdMetric$1(MetricsTest $this, MetricName x$2) {
        String string = x$2.getMBeanName();
        String string2 = $this.requiredKafkaServerPrefix() + "=ClusterId";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerStateMetric$1(MetricsTest $this, MetricName x$3) {
        String string = x$3.getMBeanName();
        String string2 = $this.requiredKafkaServerPrefix() + "=BrokerState";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testYammerMetricsCountMetric$1(MetricsTest $this, MetricName x$4) {
        String string = x$4.getMBeanName();
        String string2 = $this.requiredKafkaServerPrefix() + "=yammer-metrics-count";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testLinuxIoMetrics$2(MetricsTest $this, String name$1, MetricName x$5) {
        String string = x$5.getMBeanName();
        String string2 = $this.requiredKafkaServerPrefix() + "=" + name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testLinuxIoMetrics$1(MetricsTest $this, java.util.Map metrics$1, int expectedCount$1, String name) {
        Assertions.assertEquals((int)CollectionConverters$.MODULE$.SetHasAsScala(metrics$1.keySet()).asScala().count((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testLinuxIoMetrics$2($this, name, x$5))), (int)expectedCount$1);
    }

    public static final /* synthetic */ void $anonfun$testUpdateJMXFilter$1(KafkaBroker broker) {
        broker.kafkaYammerMetrics().reconfigure(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metrics.jmx.exclude"), (Object)"kafka.controller:type=KafkaController,name=ActiveControllerCount")}))).asJava());
    }

    public static final /* synthetic */ void $anonfun$testBrokerTopicMetricsBytesInOut$1(String topic$2, TopicPartition topicPartition$1, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        TopicPartition x$1 = new TopicPartition(topic$2, 0);
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$1, x$2);
        int brokerId = broker.config().brokerId();
        Option logSize = log.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.size()));
        Assertions.assertTrue((boolean)logSize.exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$7 -> x$7 > 0L), (String)("Expected broker " + brokerId + " to have a Log for " + topicPartition$1 + " with positive size, actual: " + logSize));
    }

    public static final /* synthetic */ boolean $anonfun$testKRaftControllerMetrics$2(String expected$1, MetricName x$8) {
        return x$8.getMBeanName().equals(expected$1);
    }

    public static final /* synthetic */ void $anonfun$testKRaftControllerMetrics$1(java.util.Map metrics$2, String expected) {
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics$2.keySet()).asScala().count((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$testKRaftControllerMetrics$2(expected, x$8))), (String)("Unable to find " + expected));
    }

    public static final /* synthetic */ boolean $anonfun$filterByTopicMetricRegex$3(Pattern pattern$1, String x$10) {
        return pattern$1.matcher(x$10).matches();
    }

    public MetricsTest() {
        this.numNodes = 2;
        this.numParts = 2;
        this.requiredKafkaServerPrefix = "kafka.server:type=KafkaServer,name";
        this.overridingProps().put("num.partitions", Integer.toString(this.numParts()));
        this.overridingProps().put("metrics.jmx.exclude", this.requiredKafkaServerPrefix() + "=ClusterId");
        this.nMessages = 2;
    }
}

