/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterClientQuotasResult;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.test.api.Flaky;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t-f\u0001B\u0017/\u0001MBQA\u000f\u0001\u0005\u0002mBQA\u0010\u0001\u0005B}BqA\u0012\u0001C\u0002\u0013\u0005q\t\u0003\u0004Q\u0001\u0001\u0006I\u0001\u0013\u0005\b#\u0002\u0011\r\u0011\"\u0001S\u0011\u0019y\u0006\u0001)A\u0005'\"9\u0001\r\u0001b\u0001\n\u0003\t\u0007B\u00025\u0001A\u0003%!\rC\u0004j\u0001\t\u0007I\u0011A$\t\r)\u0004\u0001\u0015!\u0003I\u0011\u001dY\u0007A1A\u0005\u0002}Ba\u0001\u001c\u0001!\u0002\u0013\u0001\u0005\"C7\u0001\u0001\u0004\u0005\r\u0011\"\u0001o\u0011%9\b\u00011AA\u0002\u0013\u0005\u0001\u0010C\u0005\u007f\u0001\u0001\u0007\t\u0011)Q\u0005_\"Qq\u0010\u0001a\u0001\u0002\u0004%\t!!\u0001\t\u0017\u0005E\u0001\u00011AA\u0002\u0013\u0005\u00111\u0003\u0005\f\u0003/\u0001\u0001\u0019!A!B\u0013\t\u0019\u0001C\u0006\u0002\u001a\u0001\u0001\r\u00111A\u0005\u0002\u0005m\u0001bCA\u0013\u0001\u0001\u0007\t\u0019!C\u0001\u0003OA1\"a\u000b\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u001e!9\u0011Q\u0006\u0001\u0005B\u0005=\u0002bBA\u001f\u0001\u0011\u0005\u0013q\b\u0005\b\u0003C\u0002A\u0011IA2\u0011\u001d\ti\u0007\u0001C\u0001\u0003GBq!!$\u0001\t\u0003\t\u0019\u0007C\u0004\u0002\u0012\u0002!\t!a\u0019\t\u000f\u0005U\u0005\u0001\"\u0001\u0002d!9\u0011\u0011\u0014\u0001\u0005\n\u0005m\u0005bBAe\u0001\u0011%\u00111\u001a\u0005\b\u00037\u0004A\u0011BAo\u0011\u001d\t\u0019\u000f\u0001C\u0005\u0003KD\u0011\"!?\u0001#\u0003%I!a?\t\u000f\tE\u0001\u0001\"\u0003\u0003\u0014!1!\u0011\u0005\u0001\u0005\u0002}BqAa\t\u0001\t\u0003\u0011)\u0003C\u0004\u00030\u0001!IA!\r\t\u0013\tU\u0002!%A\u0005\n\t]\u0002b\u0002B\u001e\u0001\u0011%!Q\b\u0005\b\u0005\u0007\u0002A\u0011\u0002B#\u0011\u001d\u0011)\u0006\u0001C\u0005\u0005/BqAa\u0018\u0001\t\u0013\u0011\t\u0007C\u0004\u0003h\u0001!IA!\u001b\t\u000f\t]\u0004\u0001\"\u0003\u0003z\tQB)\u001f8b[&\u001c7i\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018\rV3ti*\u0011q\u0006M\u0001\b]\u0016$xo\u001c:l\u0015\u0005\t\u0014!B6bM.\f7\u0001A\n\u0003\u0001Q\u0002\"!\u000e\u001d\u000e\u0003YR!a\u000e\u0019\u0002\rM,'O^3s\u0013\tIdGA\bCCN,'+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\tA\b\u0005\u0002>\u00015\ta&A\u0006ce>\\WM]\"pk:$X#\u0001!\u0011\u0005\u0005#U\"\u0001\"\u000b\u0003\r\u000bQa]2bY\u0006L!!\u0012\"\u0003\u0007%sG/A\u0003u_BL7-F\u0001I!\tIe*D\u0001K\u0015\tYE*\u0001\u0003mC:<'\"A'\u0002\t)\fg/Y\u0005\u0003\u001f*\u0013aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%\u0001\u0005mSN$XM\\3s+\u0005\u0019\u0006C\u0001+^\u001b\u0005)&BA\u0018W\u0015\t9\u0006,\u0001\u0004d_6lwN\u001c\u0006\u0003ceS!AW.\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0016aA8sO&\u0011a,\u0016\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\nY&\u001cH/\u001a8fe\u0002\nA\u0002\\8dC2\fE\r\u001a:fgN,\u0012A\u0019\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003K2\u000b1A\\3u\u0013\t9GMA\u0006J]\u0016$\u0018\t\u001a3sKN\u001c\u0018!\u00047pG\u0006d\u0017\t\u001a3sKN\u001c\b%A\u0006v].twn\u001e8I_N$\u0018\u0001D;oW:|wO\u001c%pgR\u0004\u0013!\b9mC&tG/\u001a=u\u0019&\u001cH/\u001a8fe\u0012+g-Y;miF+x\u000e^1\u0002=Ad\u0017-\u001b8uKb$H*[:uK:,'\u000fR3gCVdG/U;pi\u0006\u0004\u0013\u0001C3yK\u000e,Ho\u001c:\u0016\u0003=\u0004\"\u0001];\u000e\u0003ET!A]:\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002u\u0019\u0006!Q\u000f^5m\u0013\t1\u0018OA\bFq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u00031)\u00070Z2vi>\u0014x\fJ3r)\tIH\u0010\u0005\u0002Bu&\u00111P\u0011\u0002\u0005+:LG\u000fC\u0004~\u001d\u0005\u0005\t\u0019A8\u0002\u0007a$\u0013'A\u0005fq\u0016\u001cW\u000f^8sA\u0005)\u0011\rZ7j]V\u0011\u00111\u0001\t\u0005\u0003\u000b\ti!\u0004\u0002\u0002\b)\u0019q0!\u0003\u000b\u0007\u0005-\u0001,A\u0004dY&,g\u000e^:\n\t\u0005=\u0011q\u0001\u0002\u0006\u0003\u0012l\u0017N\\\u0001\nC\u0012l\u0017N\\0%KF$2!_A\u000b\u0011!i\u0018#!AA\u0002\u0005\r\u0011AB1e[&t\u0007%A\u0004u_BL7-\u00133\u0016\u0005\u0005u\u0001\u0003BA\u0010\u0003Ci\u0011AV\u0005\u0004\u0003G1&\u0001B+vS\u0012\f1\u0002^8qS\u000eLEm\u0018\u0013fcR\u0019\u00110!\u000b\t\u0011u$\u0012\u0011!a\u0001\u0003;\t\u0001\u0002^8qS\u000eLE\rI\u0001\u0018EJ|7.\u001a:Qe>\u0004XM\u001d;z\u001fZ,'O]5eKN$2!_A\u0019\u0011\u001d\t\u0019D\u0006a\u0001\u0003k\t!\u0002\u001d:pa\u0016\u0014H/[3t!\u0011\t9$!\u000f\u000e\u0003ML1!a\u000ft\u0005)\u0001&o\u001c9feRLWm]\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0004s\u0006\u0005\u0003bBA\"/\u0001\u0007\u0011QI\u0001\ti\u0016\u001cH/\u00138g_B!\u0011qIA+\u001b\t\tIE\u0003\u0003\u0002L\u00055\u0013aA1qS*!\u0011qJA)\u0003\u001dQW\u000f]5uKJT1!a\u0015\\\u0003\u0015QWO\\5u\u0013\u0011\t9&!\u0013\u0003\u0011Q+7\u000f^%oM>D3aFA.!\u0011\t9%!\u0018\n\t\u0005}\u0013\u0011\n\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8\u0015\u0003eD3\u0001GA4!\u0011\t9%!\u001b\n\t\u0005-\u0014\u0011\n\u0002\n\u0003\u001a$XM]#bG\"\f!\u0004^3ti\u0012Kh.Y7jG\u000e{gN\\3di&|g.U;pi\u0006Ds!GA9\u0003\u007f\n\t\t\u0005\u0003\u0002t\u0005mTBAA;\u0015\u0011\tY%a\u001e\u000b\u0007\u0005ed+\u0001\u0003uKN$\u0018\u0002BA?\u0003k\u0012QA\u00127bWf\fQA^1mk\u0016\f#!a!\u0002\u0017-\u000beiS!.c]J\u0014(\u000f\u0015\u00043\u0005\u001d\u0005\u0003BA$\u0003\u0013KA!a#\u0002J\t!A+Z:u\u0003\t\"Xm\u001d;Es:\fW.[2MSN$XM\\3s\u0007>tg.Z2uS>t\u0017+^8uC\"\u001a!$a\"\u0002]Q,7\u000f\u001e#z]\u0006l\u0017n\u0019'jgR,g.\u001a:D_:tWm\u0019;j_:\u001c%/Z1uS>t'+\u0019;f#V|G/\u0019\u0015\u00047\u0005\u001d\u0015\u0001\t;fgR$\u0015P\\1nS\u000eL\u0005oQ8o]\u0016\u001cG/[8o%\u0006$X-U;pi\u0006D3\u0001HAD\u0003I\u0011XmY8oM&<WO]3TKJ4XM]:\u0015\u000fe\fi*!)\u0002,\"9\u0011qT\u000fA\u0002\u0005U\u0012\u0001\u00038foB\u0013x\u000e]:\t\u000f\u0005\rV\u00041\u0001\u0002&\u0006y\u0001/\u001a:Ce>\\WM]\"p]\u001aLw\rE\u0002B\u0003OK1!!+C\u0005\u001d\u0011un\u001c7fC:Dq!!,\u001e\u0001\u0004\ty+A\u0007b!J|\u0007\u000fV8WKJLg-\u001f\t\b\u0003\u0006E\u0016QWA[\u0013\r\t\u0019L\u0011\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005]\u0016Q\u0019\b\u0005\u0003s\u000b\t\rE\u0002\u0002<\nk!!!0\u000b\u0007\u0005}&'\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0007\u0014\u0015A\u0002)sK\u0012,g-C\u0002P\u0003\u000fT1!a1C\u0003Y)\b\u000fZ1uK&\u00038i\u001c8oK\u000e$\u0018n\u001c8SCR,G#B=\u0002N\u0006]\u0007bBAh=\u0001\u0007\u0011\u0011[\u0001\u0003SB\u0004R!QAj\u0003kK1!!6C\u0005\u0019y\u0005\u000f^5p]\"1\u0011\u0011\u001c\u0010A\u0002\u0001\u000b1\"\u001e9eCR,GMU1uK\u0006yq/Y5u\r>\u0014H*[:uK:,'\u000fF\u0002z\u0003?Dq!!9 \u0001\u0004\t),\u0001\u0007mSN$XM\\3s\u001d\u0006lW-A\u000bxC&$hi\u001c:D_:4\u0017nZ(o'\u0016\u0014h/\u001a:\u0015\u000fe\f9/a;\u0002p\"9\u0011\u0011\u001e\u0011A\u0002\u0005U\u0016\u0001\u00039s_Bt\u0015-\\3\t\u000f\u00055\b\u00051\u0001\u00026\u0006I\u0001O]8q-\u0006dW/\u001a\u0005\n\u0003c\u0004\u0003\u0013!a\u0001\u0003g\f\u0011\"\\1y/\u0006LG/T:\u0011\u0007\u0005\u000b)0C\u0002\u0002x\n\u0013A\u0001T8oO\u0006yr/Y5u\r>\u00148i\u001c8gS\u001e|enU3sm\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005u(\u0006BAz\u0003\u007f\\#A!\u0001\u0011\t\t\r!QB\u0007\u0003\u0005\u000bQAAa\u0002\u0003\n\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u0017\u0011\u0015AC1o]>$\u0018\r^5p]&!!q\u0002B\u0003\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000faJ|G-^2f%\u0016\fX/Z:u+\t\u0011)\u0002\u0005\u0003\u0003\u0018\tuQB\u0001B\r\u0015\r\u0011YBV\u0001\te\u0016\fX/Z:ug&!!q\u0004B\r\u00059\u0001&o\u001c3vG\u0016\u0014V-];fgR\fqbY8o]\u0016\u001cG/[8o\u0007>,h\u000e^\u0001\bG>tg.Z2u)\u0011\u00119C!\f\u0011\u0007\r\u0014I#C\u0002\u0003,\u0011\u0014aaU8dW\u0016$\bBB)%\u0001\u0004\t),A\rde\u0016\fG/Z!oIZ+'/\u001b4z\u0007>tg.Z2uS>tGcA=\u00034!A\u0011+\nI\u0001\u0002\u0004\t),A\u0012de\u0016\fG/Z!oIZ+'/\u001b4z\u0007>tg.Z2uS>tG\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\te\"\u0006BA[\u0003\u007f\f\u0001C^3sS\u001aL8i\u001c8oK\u000e$\u0018n\u001c8\u0015\u0007e\u0014y\u0004C\u0004\u0003B\u001d\u0002\rAa\n\u0002\rM|7m[3u\u0003Q1XM]5gs6\u000b\u0007pQ8o]\u0016\u001cG/[8ogR)\u0011Pa\u0012\u0003L!1!\u0011\n\u0015A\u0002\u0001\u000ba\"\\1y\u0007>tg.Z2uS>t7\u000fC\u0004\u0003N!\u0002\rAa\u0014\u0002%\r|gN\\3di^KG\u000f\u001b$bS2,(/\u001a\t\u0005\u0003\nE\u00130C\u0002\u0003T\t\u0013\u0011BR;oGRLwN\u001c\u0019\u0002!\r|gN\\3di\u0006sGMV3sS\u001aLH#B=\u0003Z\tm\u0003BB)*\u0001\u0004\t)\fC\u0004\u0003^%\u0002\r!!*\u0002%%<gn\u001c:f\u0013>+\u0005pY3qi&|gn]\u0001\u0017o\u0006LGOR8s\u0007>tg.Z2uS>t7i\\;oiR\u0019\u0011Pa\u0019\t\r\t\u0015$\u00061\u0001A\u0003])\u0007\u0010]3di\u0016$7i\u001c8oK\u000e$\u0018n\u001c8D_VtG/\u0001\u000bwKJLg-_\"p]:,7\r^5p]J\u000bG/\u001a\u000b\ns\n-$q\u000eB:\u0005kBaA!\u001c,\u0001\u0004\u0001\u0015!E7j]\u000e{gN\\3di&|gNU1uK\"1!\u0011O\u0016A\u0002\u0001\u000b\u0011#\\1y\u0007>tg.Z2uS>t'+\u0019;f\u0011\u0019\t6\u00061\u0001\u00026\"9!QL\u0016A\u0002\u0005\u0015\u0016!E1mi\u0016\u00148\t\\5f]R\fVo\u001c;bgR1!1\u0010BA\u0005\u000b\u0003B!!\u0002\u0003~%!!qPA\u0004\u0005]\tE\u000e^3s\u00072LWM\u001c;Rk>$\u0018m\u001d*fgVdG\u000fC\u0004\u0003\u00042\u0002\r!a\u0001\u0002\u0017\u0005$W.\u001b8DY&,g\u000e\u001e\u0005\b\u0005\u000fc\u0003\u0019\u0001BE\u0003\u001d\u0011X-];fgR\u0004\u0002Ba#\u0003\u0012\nU%\u0011U\u0007\u0003\u0005\u001bS1Aa$C\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005'\u0013iIA\u0002NCB\u0004BAa&\u0003\u001e6\u0011!\u0011\u0014\u0006\u0004\u000573\u0016!B9v_R\f\u0017\u0002\u0002BP\u00053\u0013\u0011c\u00117jK:$\u0018+^8uC\u0016sG/\u001b;z!!\u0011YI!%\u00026\n\r\u0006#B!\u0002T\n\u0015\u0006cA!\u0003(&\u0019!\u0011\u0016\"\u0003\r\u0011{WO\u00197f\u0001")
public class DynamicConnectionQuotaTest
extends BaseRequestTest {
    private final String topic;
    private final ListenerName listener = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    private final InetAddress localAddress = InetAddress.getByName("127.0.0.1");
    private final String unknownHost;
    private final int plaintextListenerDefaultQuota;
    private ExecutorService executor;
    private Admin admin;
    private Uuid topicId;

    @Override
    public int brokerCount() {
        return 1;
    }

    public String topic() {
        return this.topic;
    }

    public ListenerName listener() {
        return this.listener;
    }

    public InetAddress localAddress() {
        return this.localAddress;
    }

    public String unknownHost() {
        return this.unknownHost;
    }

    public int plaintextListenerDefaultQuota() {
        return this.plaintextListenerDefaultQuota;
    }

    public ExecutorService executor() {
        return this.executor;
    }

    public void executor_$eq(ExecutorService x$1) {
        this.executor = x$1;
    }

    public Admin admin() {
        return this.admin;
    }

    public void admin_$eq(Admin x$1) {
        this.admin = x$1;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public void topicId_$eq(Uuid x$1) {
        this.topicId = x$1;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put("quota.window.num", "2");
        properties.put("listener.name.plaintext.max.connection.creation.rate", Integer.toString(this.plaintextListenerDefaultQuota()));
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.admin_$eq(this.createAdminClient(this.listener(), this.createAdminClient$default$2()));
        TestUtils$.MODULE$.createTopicWithAdmin(this.admin(), this.topic(), this.brokers(), this.controllerServers(), 1, 1, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.empty()), new Properties());
        this.topicId_$eq(TestUtils$.MODULE$.describeTopic(this.admin(), this.topic()).topicId());
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.admin() != null) {
            this.admin().close();
        }
        try {
            if (this.executor() != null) {
                this.executor().shutdownNow();
                Assertions.assertTrue((boolean)this.executor().awaitTermination(10L, TimeUnit.SECONDS));
            }
        }
        finally {
            super.tearDown();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Flaky(value="KAFKA-17999")
    @Test
    public void testDynamicConnectionQuota() {
        int maxConnectionsPerIP = 5;
        Properties props = new Properties();
        props.put("max.connections.per.ip", Integer.toString(maxConnectionsPerIP));
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)"max.connections.per.ip", (Object)Integer.toString(maxConnectionsPerIP)));
        JFunction0.mcV.sp & Serializable verifyMaxConnections_connectWithFailure = (JFunction0.mcV.sp & Serializable)() -> this.connectAndVerify$1();
        int verifyMaxConnections_initialConnectionCount = this.connectionCount();
        IndexedSeq verifyMaxConnections_conns = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnectionsPerIP - 1).map((Function1 & Serializable)x$15 -> this.connect("PLAINTEXT"));
        this.createAndVerifyConnection("PLAINTEXT");
        long l = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, maxConnectionsPerIP)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"produce request connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        verifyMaxConnections_conns = (IndexedSeq)verifyMaxConnections_conns.$colon$plus((Object)this.connect("PLAINTEXT"));
        Assertions.assertThrows(IOException.class, () -> DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4((Function0)verifyMaxConnections_connectWithFailure));
        ((Socket)verifyMaxConnections_conns.head()).close();
        long l2 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs2 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(this, maxConnectionsPerIP)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime2 + verifyMaxConnections_waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs2), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        this.createAndVerifyConnection("PLAINTEXT");
        verifyMaxConnections_conns.foreach((Function1 & Serializable)x$16 -> {
            x$16.close();
            return BoxedUnit.UNIT;
        });
        long l3 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs3 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(this, verifyMaxConnections_initialConnectionCount)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime3 + verifyMaxConnections_waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Connections not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs3), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        Object var4_3 = null;
        Object var6_5 = null;
        int maxConnectionsPerIPOverride = 7;
        props.put("max.connections.per.ip.overrides", "localhost:" + maxConnectionsPerIPOverride);
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)"max.connections.per.ip.overrides", (Object)("localhost:" + maxConnectionsPerIPOverride)));
        JFunction0.mcV.sp & Serializable verifyMaxConnections_connectWithFailure2 = (JFunction0.mcV.sp & Serializable)() -> this.connectAndVerify$1();
        int verifyMaxConnections_initialConnectionCount2 = this.connectionCount();
        IndexedSeq verifyMaxConnections_conns2 = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnectionsPerIPOverride - 1).map((Function1 & Serializable)x$15 -> this.connect("PLAINTEXT"));
        this.createAndVerifyConnection("PLAINTEXT");
        long l4 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs4 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, maxConnectionsPerIPOverride)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime4 + verifyMaxConnections_waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"produce request connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs4), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        verifyMaxConnections_conns2 = (IndexedSeq)verifyMaxConnections_conns2.$colon$plus((Object)this.connect("PLAINTEXT"));
        Assertions.assertThrows(IOException.class, () -> DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4((Function0)verifyMaxConnections_connectWithFailure2));
        ((Socket)verifyMaxConnections_conns2.head()).close();
        long l5 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs5 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(this, maxConnectionsPerIPOverride)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime5 + verifyMaxConnections_waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)"connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs5), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        this.createAndVerifyConnection("PLAINTEXT");
        verifyMaxConnections_conns2.foreach((Function1 & Serializable)x$16 -> {
            x$16.close();
            return BoxedUnit.UNIT;
        });
        long l6 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs6 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(this, verifyMaxConnections_initialConnectionCount2)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime6 + verifyMaxConnections_waitUntilTrue_waitTimeMs6) {
                Assertions.fail((String)"Connections not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs6), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDynamicListenerConnectionQuota() {
        void verifyMaxConnections_connectWithFailure;
        int initialConnectionCount = this.connectionCount();
        Properties props = new Properties();
        props.put("max.connections", "5");
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)"max.connections", (Object)"5"));
        JFunction0.mcV.sp & Serializable intersect = (JFunction0.mcV.sp & Serializable)() -> this.connectAndVerify$2();
        int verifyMaxConnections_maxConnections = 5;
        int verifyMaxConnections_initialConnectionCount = this.connectionCount();
        IndexedSeq verifyMaxConnections_conns = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.connectionCount()), verifyMaxConnections_maxConnections - 1).map((Function1 & Serializable)x$15 -> this.connect("PLAINTEXT"));
        this.createAndVerifyConnection("PLAINTEXT");
        long l = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, verifyMaxConnections_maxConnections)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime + verifyMaxConnections_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"produce request connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        verifyMaxConnections_conns = (IndexedSeq)verifyMaxConnections_conns.$colon$plus((Object)this.connect("PLAINTEXT"));
        Assertions.assertThrows(IOException.class, () -> DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4((Function0)verifyMaxConnections_connectWithFailure));
        ((Socket)verifyMaxConnections_conns.head()).close();
        long l2 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs2 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(this, verifyMaxConnections_maxConnections)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime2 + verifyMaxConnections_waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs2), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        this.createAndVerifyConnection("PLAINTEXT");
        verifyMaxConnections_conns.foreach((Function1 & Serializable)x$16 -> {
            x$16.close();
            return BoxedUnit.UNIT;
        });
        long l3 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs3 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(this, verifyMaxConnections_initialConnectionCount)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime3 + verifyMaxConnections_waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Connections not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs3), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        intersect = null;
        Object var14_6 = null;
        String newListeners = "PLAINTEXT://localhost:0,INTERNAL://localhost:0";
        props.put("listeners", newListeners);
        props.put("listener.security.protocol.map", "PLAINTEXT:PLAINTEXT,INTERNAL:PLAINTEXT, CONTROLLER: PLAINTEXT");
        props.put("max.connections", "10");
        props.put("listener.name.internal.max.connections", "5");
        props.put("listener.name.plaintext.max.connections", "5");
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)"listeners", (Object)newListeners));
        this.waitForListener("INTERNAL");
        IndexedSeq conns = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.connectionCount()), 5).map((Function1 & Serializable)x$4 -> this.connect("PLAINTEXT"));
        conns = (IndexedSeq)conns.$plus$plus((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(5), 10).map((Function1 & Serializable)x$5 -> this.connect("INTERNAL")));
        conns.foreach((Function1 & Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        conns.foreach((Function1 & Serializable)x$6 -> {
            x$6.close();
            return BoxedUnit.UNIT;
        });
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$6(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Connections not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int maxConnectionsPlaintext = 7;
        String listenerProp = this.listener().configPrefix() + "max.connections";
        props.put(listenerProp, Integer.toString(maxConnectionsPlaintext));
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)listenerProp, (Object)Integer.toString(maxConnectionsPlaintext)));
        JFunction0.mcV.sp & Serializable verifyMaxConnections_connectWithFailure2 = (JFunction0.mcV.sp & Serializable)() -> this.connectAndVerify$2();
        int verifyMaxConnections_initialConnectionCount2 = this.connectionCount();
        IndexedSeq verifyMaxConnections_conns2 = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnectionsPlaintext - 1).map((Function1 & Serializable)x$15 -> this.connect("PLAINTEXT"));
        this.createAndVerifyConnection("PLAINTEXT");
        long l5 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs4 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, maxConnectionsPlaintext)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime4 + verifyMaxConnections_waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"produce request connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs4), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        verifyMaxConnections_conns2 = (IndexedSeq)verifyMaxConnections_conns2.$colon$plus((Object)this.connect("PLAINTEXT"));
        Assertions.assertThrows(IOException.class, () -> DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$4((Function0)verifyMaxConnections_connectWithFailure2));
        ((Socket)verifyMaxConnections_conns2.head()).close();
        long l6 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs5 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(this, maxConnectionsPlaintext)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime5 + verifyMaxConnections_waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)"connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs5), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        this.createAndVerifyConnection("PLAINTEXT");
        verifyMaxConnections_conns2.foreach((Function1 & Serializable)x$16 -> {
            x$16.close();
            return BoxedUnit.UNIT;
        });
        long l7 = 100L;
        long verifyMaxConnections_waitUntilTrue_waitTimeMs6 = 15000L;
        long verifyMaxConnections_waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(this, verifyMaxConnections_initialConnectionCount2)) {
            void verifyMaxConnections_waitUntilTrue_pause;
            if (System.currentTimeMillis() > verifyMaxConnections_waitUntilTrue_startTime6 + verifyMaxConnections_waitUntilTrue_waitTimeMs6) {
                Assertions.fail((String)"Connections not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyMaxConnections_waitUntilTrue_waitTimeMs6), (long)verifyMaxConnections_waitUntilTrue_pause));
        }
        Object var39_23 = null;
        Object var41_25 = null;
        IndexedSeq plaintextConnections = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnectionsPlaintext).map((Function1 & Serializable)x$7 -> this.connect("PLAINTEXT"));
        this.executor_$eq(Executors.newSingleThreadExecutor());
        Future<?> future = this.executor().submit(() -> this.createAndVerifyConnection("PLAINTEXT"));
        Thread.sleep(100L);
        Assertions.assertFalse((boolean)future.isDone());
        ((Socket)plaintextConnections.head()).close();
        future.get(30L, TimeUnit.SECONDS);
        plaintextConnections.foreach((Function1 & Serializable)x$8 -> {
            x$8.close();
            return BoxedUnit.UNIT;
        });
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$12(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Connections not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        IndexedSeq plaintextConns = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.connectionCount()), 5).map((Function1 & Serializable)x$9 -> this.connect("PLAINTEXT"));
        IndexedSeq internalConns = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(5), 10).map((Function1 & Serializable)x$10 -> this.connect("INTERNAL"));
        plaintextConns.foreach((Function1 & Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        internalConns.foreach((Function1 & Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        plaintextConns = (IndexedSeq)plaintextConns.$plus$plus((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 2).map((Function1 & Serializable)x$11 -> this.connect("PLAINTEXT")));
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs3 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$19(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Internal connections not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        plaintextConns.foreach((Function1 & Serializable)socket -> {
            this.verifyConnection(socket);
            return BoxedUnit.UNIT;
        });
        Assertions.assertThrows(IOException.class, () -> internalConns.foreach((Function1 & Serializable)socket -> (ProduceResponse)this.sendAndReceive((AbstractRequest)this.produceRequest(), (Socket)socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class))));
        plaintextConns.foreach((Function1 & Serializable)x$12 -> {
            x$12.close();
            return BoxedUnit.UNIT;
        });
        internalConns.foreach((Function1 & Serializable)x$13 -> {
            x$13.close();
            return BoxedUnit.UNIT;
        });
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$testDynamicListenerConnectionQuota$26(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"Connections not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testDynamicListenerConnectionCreationRateQuota() {
        .colon.colon newListenerNames = new .colon.colon((Object)"PLAINTEXT", (List)new .colon.colon((Object)"EXTERNAL", (List)Nil$.MODULE$));
        String newListeners = "PLAINTEXT://localhost:0,EXTERNAL://localhost:0";
        Properties props = new Properties();
        props.put("listeners", newListeners);
        props.put("listener.security.protocol.map", "PLAINTEXT:PLAINTEXT,EXTERNAL:PLAINTEXT,CONTROLLER:PLAINTEXT");
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)"listeners", (Object)newListeners));
        this.waitForListener("EXTERNAL");
        int initialConnectionCount = this.connectionCount();
        int connRateLimit = 9;
        this.verifyConnectionRate(2 * connRateLimit, this.plaintextListenerDefaultQuota(), "PLAINTEXT", false);
        this.waitForConnectionCount(initialConnectionCount);
        props.clear();
        props.put("max.connection.creation.rate", Integer.toString(connRateLimit));
        this.reconfigureServers(props, false, (Tuple2<String, String>)new Tuple2((Object)"max.connection.creation.rate", (Object)Integer.toString(connRateLimit)));
        this.verifyConnectionRate(8, connRateLimit, "EXTERNAL", false);
        this.waitForConnectionCount(initialConnectionCount);
        int listenerConnRateLimit = 4;
        String plaintextListenerProp = this.listener().configPrefix() + "max.connection.creation.rate";
        props.put("listener.name.external.max.connection.creation.rate", Integer.toString(listenerConnRateLimit));
        props.put(plaintextListenerProp, Integer.toString(listenerConnRateLimit));
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)plaintextListenerProp, (Object)Integer.toString(listenerConnRateLimit)));
        this.executor_$eq(Executors.newFixedThreadPool(newListenerNames.size()));
        ((scala.collection.immutable.Seq)newListenerNames.map((Function1 & Serializable)listener -> this.executor().submit(() -> this.verifyConnectionRate(3, listenerConnRateLimit, (String)listener, false)))).foreach((Function1 & Serializable)x$14 -> x$14.get(40L, TimeUnit.SECONDS));
        this.waitForConnectionCount(initialConnectionCount);
        int newPlaintextRateLimit = 12;
        props.put(plaintextListenerProp, Integer.toString(newPlaintextRateLimit));
        this.reconfigureServers(props, true, (Tuple2<String, String>)new Tuple2((Object)plaintextListenerProp, (Object)Integer.toString(newPlaintextRateLimit)));
        Future<?> plaintextFuture = this.executor().submit(() -> this.verifyConnectionRate(10, newPlaintextRateLimit, "PLAINTEXT", false));
        Future<?> externalFuture = this.executor().submit(() -> this.verifyConnectionRate(3, listenerConnRateLimit, "EXTERNAL", false));
        plaintextFuture.get(40L, TimeUnit.SECONDS);
        externalFuture.get(40L, TimeUnit.SECONDS);
        this.waitForConnectionCount(initialConnectionCount);
    }

    @Test
    public void testDynamicIpConnectionRateQuota() {
        int connRateLimit = 10;
        int initialConnectionCount = this.connectionCount();
        this.verifyConnectionRate(2 * connRateLimit, this.plaintextListenerDefaultQuota(), "PLAINTEXT", false);
        this.waitForConnectionCount(initialConnectionCount);
        this.updateIpConnectionRate((Option<String>)None$.MODULE$, connRateLimit);
        this.verifyConnectionRate(8, connRateLimit, "PLAINTEXT", true);
        this.waitForConnectionCount(initialConnectionCount);
        int newRateLimit = 18;
        this.updateIpConnectionRate((Option<String>)new Some((Object)this.localAddress().getHostAddress()), newRateLimit);
        this.verifyConnectionRate(14, newRateLimit, "PLAINTEXT", true);
        this.waitForConnectionCount(initialConnectionCount);
    }

    /*
     * WARNING - void declaration
     */
    private void reconfigureServers(Properties newProps, boolean perBrokerConfig, Tuple2<String, String> aPropToVerify) {
        int initialConnectionCount = this.connectionCount();
        TestUtils$.MODULE$.incrementalAlterConfigs(this.brokers(), this.admin(), newProps, perBrokerConfig, AlterConfigOp.OpType.SET).all().get();
        this.waitForConfigOnServer((String)aPropToVerify._1(), (String)aPropToVerify._2(), 10000L);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$reconfigureServers$1(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$reconfigureServers$2(this, initialConnectionCount));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateIpConnectionRate(Option<String> ip, int updatedRate) {
        int initialConnectionCount = this.connectionCount();
        ClientQuotaEntity entity = new ClientQuotaEntity(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ip"), ip.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))}))).asJava());
        Map request = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entity), Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connection_creation_rate"), (Object)new Some((Object)BoxesRunTime.boxToDouble((double)updatedRate)))})))}));
        this.alterClientQuotas(this.admin(), (Map<ClientQuotaEntity, Map<String, Option<Object>>>)request).all().get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$updateIpConnectionRate$1(this, ip, updatedRate)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for connection rate update to propagate");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$updateIpConnectionRate$4(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$updateIpConnectionRate$5(this, initialConnectionCount));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    private void waitForListener(String listenerName) {
        long retry_maxWaitMs = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConnectionQuotaTest.$anonfun$waitForListener$1(this, listenerName);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var9_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    private void waitForConfigOnServer(String propName, String propValue, long maxWaitMs) {
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConnectionQuotaTest.$anonfun$waitForConfigOnServer$1(this, propValue, propName);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var10_8 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    private long waitForConfigOnServer$default$3() {
        return 10000L;
    }

    /*
     * WARNING - void declaration
     */
    private ProduceRequest produceRequest() {
        void withRecords_timestampType;
        SimpleRecord[] withRecords_records = new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())};
        NoCompression withRecords_compression = Compression.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var1_2 = null;
        Object var2_1 = null;
        return (ProduceRequest)ProduceRequest.builder((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(java.util.List.of(new ProduceRequestData.TopicProduceData().setTopicId(this.topicId()).setPartitionData(java.util.List.of(new ProduceRequestData.PartitionProduceData().setIndex(0).setRecords((BaseRecords)MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records))))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null), (boolean)false).build();
    }

    public int connectionCount() {
        return ((KafkaBroker)this.brokers().head()).socketServer().connectionCount(this.localAddress());
    }

    public Socket connect(String listener) {
        ListenerName listenerName = ListenerName.normalised((String)listener);
        return new Socket("localhost", ((KafkaBroker)this.brokers().head()).socketServer().boundPort(listenerName));
    }

    private void createAndVerifyConnection(String listener) {
        try (Socket socket = this.connect(listener);){
            this.verifyConnection(socket);
        }
    }

    private String createAndVerifyConnection$default$1() {
        return "PLAINTEXT";
    }

    private void verifyConnection(Socket socket) {
        ProduceResponse produceResponse = (ProduceResponse)this.sendAndReceive((AbstractRequest)this.produceRequest(), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class));
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)produceResponse.data().responses()).asScala().head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)CollectionConverters$.MODULE$.ListHasAsScala(topicProduceResponse.partitionResponses()).asScala().head();
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
    }

    /*
     * WARNING - void declaration
     */
    private void verifyMaxConnections(int maxConnections, Function0<BoxedUnit> connectWithFailure) {
        int initialConnectionCount = this.connectionCount();
        IndexedSeq conns = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.connectionCount()), maxConnections - 1).map((Function1 & Serializable)x$15 -> this.connect("PLAINTEXT"));
        this.createAndVerifyConnection("PLAINTEXT");
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$2(this, maxConnections)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"produce request connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        conns = (IndexedSeq)conns.$colon$plus((Object)this.connect("PLAINTEXT"));
        Assertions.assertThrows(IOException.class, () -> connectWithFailure.apply$mcV$sp());
        ((Socket)conns.head()).close();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$5(this, maxConnections)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"connection is not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        this.createAndVerifyConnection("PLAINTEXT");
        conns.foreach((Function1 & Serializable)x$16 -> {
            x$16.close();
            return BoxedUnit.UNIT;
        });
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$verifyMaxConnections$8(this, initialConnectionCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Connections not closed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
    }

    private void connectAndVerify(String listener, boolean ignoreIOExceptions) {
        try (Socket socket = this.connect(listener);){
            try {
                this.sendAndReceive((AbstractRequest)this.produceRequest(), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class));
            }
            catch (IOException e) {
                if (!ignoreIOExceptions) {
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void waitForConnectionCount(int expectedConnectionCount) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConnectionQuotaTest.$anonfun$waitForConnectionCount$1(this, expectedConnectionCount)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConnectionQuotaTest.$anonfun$waitForConnectionCount$2(this, expectedConnectionCount));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void verifyConnectionRate(int minConnectionRate, int maxConnectionRate, String listener, boolean ignoreIOExceptions) {
        long runTimeMs = TimeUnit.SECONDS.toMillis(13L);
        long startTimeMs = System.currentTimeMillis();
        long endTimeMs = startTimeMs + runTimeMs;
        int connCount = 0;
        while (System.currentTimeMillis() < endTimeMs) {
            this.connectAndVerify(listener, ignoreIOExceptions);
            ++connCount;
        }
        long elapsedMs = System.currentTimeMillis() - startTimeMs;
        double actualRate = (double)connCount / (double)elapsedMs * (double)1000;
        double rateCap = maxConnectionRate < Integer.MAX_VALUE ? 1.2 * (double)maxConnectionRate : 2.147483647E9;
        Assertions.assertTrue((actualRate <= rateCap ? 1 : 0) != 0, (String)("Listener " + listener + " connection rate " + actualRate + " must be below " + rateCap));
        Assertions.assertTrue((actualRate >= (double)minConnectionRate ? 1 : 0) != 0, (String)("Listener " + listener + " connection rate " + actualRate + " must be above " + minConnectionRate));
    }

    private AlterClientQuotasResult alterClientQuotas(Admin adminClient, Map<ClientQuotaEntity, Map<String, Option<Object>>> request) {
        Collection entries = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)request.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                ClientQuotaEntity entity = (ClientQuotaEntity)x0$1._1();
                Map alter = (Map)x0$1._2();
                Collection ops = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)alter.map((Function1 & Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        String key = (String)x0$2._1();
                        Option value = (Option)x0$2._2();
                        return new ClientQuotaAlteration.Op(key, (Double)value.map((Function1 & Serializable)x -> DynamicConnectionQuotaTest.$anonfun$alterClientQuotas$3(BoxesRunTime.unboxToDouble((Object)x))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                    }
                    throw new MatchError(null);
                })).asJavaCollection();
                return new ClientQuotaAlteration(entity, ops);
            }
            throw new MatchError(null);
        })).asJavaCollection();
        return adminClient.alterClientQuotas(entries);
    }

    private final void connectAndVerify$1() {
        try (Socket socket = this.connect(this.connect$default$1(), this.connect$default$2());){
            this.sendAndReceive((AbstractRequest)this.produceRequest(), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class));
        }
    }

    private final void connectAndVerify$2() {
        socket.setSoTimeout(1000);
        try (Socket socket = this.connect("PLAINTEXT");){
            this.sendAndReceive((AbstractRequest)this.produceRequest(), socket, this.sendAndReceive$default$3(), this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ProduceResponse.class));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicListenerConnectionQuota$6(DynamicConnectionQuotaTest $this, int initialConnectionCount$1) {
        return initialConnectionCount$1 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$testDynamicListenerConnectionQuota$7() {
        return "Connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicListenerConnectionQuota$12(DynamicConnectionQuotaTest $this, int initialConnectionCount$1) {
        return initialConnectionCount$1 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$testDynamicListenerConnectionQuota$13() {
        return "Connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicListenerConnectionQuota$19(DynamicConnectionQuotaTest $this) {
        return $this.connectionCount() <= 10;
    }

    public static final /* synthetic */ String $anonfun$testDynamicListenerConnectionQuota$20() {
        return "Internal connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicListenerConnectionQuota$26(DynamicConnectionQuotaTest $this, int initialConnectionCount$1) {
        return initialConnectionCount$1 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$testDynamicListenerConnectionQuota$27() {
        return "Connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$reconfigureServers$1(DynamicConnectionQuotaTest $this, int initialConnectionCount$2) {
        return initialConnectionCount$2 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$reconfigureServers$2(DynamicConnectionQuotaTest $this, int initialConnectionCount$2) {
        return "Admin client connection not closed (initial = " + initialConnectionCount$2 + ", current = " + $this.connectionCount() + ")";
    }

    public static final /* synthetic */ boolean $anonfun$updateIpConnectionRate$1(DynamicConnectionQuotaTest $this, Option ip$1, int updatedRate$1) {
        return ((KafkaBroker)$this.brokers().head()).socketServer().connectionQuotas().connectionRateForIp(InetAddress.getByName((String)ip$1.getOrElse((Function0 & Serializable)() -> $this.unknownHost()))) == updatedRate$1;
    }

    public static final /* synthetic */ String $anonfun$updateIpConnectionRate$3() {
        return "Timed out waiting for connection rate update to propagate";
    }

    public static final /* synthetic */ boolean $anonfun$updateIpConnectionRate$4(DynamicConnectionQuotaTest $this, int initialConnectionCount$3) {
        return initialConnectionCount$3 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$updateIpConnectionRate$5(DynamicConnectionQuotaTest $this, int initialConnectionCount$3) {
        return "Admin client connection not closed (initial = " + initialConnectionCount$3 + ", current = " + $this.connectionCount() + ")";
    }

    public static final /* synthetic */ void $anonfun$waitForListener$1(DynamicConnectionQuotaTest $this, String listenerName$1) {
        try {
            Assertions.assertTrue((((KafkaBroker)$this.brokers().head()).socketServer().boundPort(ListenerName.normalised((String)listenerName$1)) > 0 ? 1 : 0) != 0);
            return;
        }
        catch (KafkaException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static final /* synthetic */ void $anonfun$waitForConfigOnServer$1(DynamicConnectionQuotaTest $this, String propValue$1, String propName$1) {
        Assertions.assertEquals((Object)propValue$1, ((KafkaBroker)$this.brokers().head()).config().originals().get(propName$1));
    }

    public static final /* synthetic */ boolean $anonfun$verifyMaxConnections$2(DynamicConnectionQuotaTest $this, int maxConnections$1) {
        return $this.connectionCount() == maxConnections$1 - 1;
    }

    public static final /* synthetic */ String $anonfun$verifyMaxConnections$3() {
        return "produce request connection is not closed";
    }

    public static final /* synthetic */ boolean $anonfun$verifyMaxConnections$5(DynamicConnectionQuotaTest $this, int maxConnections$1) {
        return $this.connectionCount() == maxConnections$1 - 1;
    }

    public static final /* synthetic */ String $anonfun$verifyMaxConnections$6() {
        return "connection is not closed";
    }

    public static final /* synthetic */ boolean $anonfun$verifyMaxConnections$8(DynamicConnectionQuotaTest $this, int initialConnectionCount$4) {
        return initialConnectionCount$4 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$verifyMaxConnections$9() {
        return "Connections not closed";
    }

    public static final /* synthetic */ boolean $anonfun$waitForConnectionCount$1(DynamicConnectionQuotaTest $this, int expectedConnectionCount$1) {
        return expectedConnectionCount$1 == $this.connectionCount();
    }

    public static final /* synthetic */ String $anonfun$waitForConnectionCount$2(DynamicConnectionQuotaTest $this, int expectedConnectionCount$1) {
        return "Connections not closed (expected = " + expectedConnectionCount$1 + " current = " + $this.connectionCount() + ")";
    }

    public static final /* synthetic */ Double $anonfun$alterClientQuotas$3(double x) {
        return BoxesRunTime.boxToDouble((double)x);
    }

    public DynamicConnectionQuotaTest() {
        this.topic = "test";
        this.unknownHost = "255.255.0.1";
        this.plaintextListenerDefaultQuota = 30;
    }
}

