/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.function.BiFunction;
import kafka.security.authorizer.BaseAuthorizerTest;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.PluginMetrics;
import org.apache.kafka.common.metrics.internals.PluginMetricsImpl;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.controller.MockAclMutator;
import org.apache.kafka.metadata.authorizer.AclMutator;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.apache.kafka.metadata.authorizer.StandardAuthorizerTest;
import org.apache.kafka.security.authorizer.AclEntry;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r=c\u0001\u0002)R\u0001aCQa\u0019\u0001\u0005\u0002\u0011DqA\u001a\u0001C\u0002\u00135q\r\u0003\u0004t\u0001\u0001\u0006i\u0001\u001b\u0005\bi\u0002\u0011\r\u0011\"\u0003v\u0011\u0019a\b\u0001)A\u0005m\"9Q\u0010\u0001b\u0001\n\u0013)\bB\u0002@\u0001A\u0003%a\u000fC\u0004\u0000\u0001\t\u0007I\u0011B;\t\u000f\u0005\u0005\u0001\u0001)A\u0005m\"I\u00111\u0001\u0001C\u0002\u0013%\u0011Q\u0001\u0005\t\u0003'\u0001\u0001\u0015!\u0003\u0002\b!I\u0011Q\u0003\u0001C\u0002\u0013%\u0011Q\u0001\u0005\t\u0003/\u0001\u0001\u0015!\u0003\u0002\b!I\u0011\u0011\u0004\u0001C\u0002\u0013%\u0011Q\u0001\u0005\t\u00037\u0001\u0001\u0015!\u0003\u0002\b!I\u0011Q\u0004\u0001C\u0002\u0013%\u0011q\u0004\u0005\t\u0003_\u0001\u0001\u0015!\u0003\u0002\"!Y\u0011\u0011\u0007\u0001A\u0002\u0003\u0007I\u0011BA\u001a\u0011-\t\t\u0005\u0001a\u0001\u0002\u0004%I!a\u0011\t\u0017\u0005U\u0003\u00011A\u0001B\u0003&\u0011Q\u0007\u0005\f\u0003/\u0002\u0001\u0019!a\u0001\n\u0013\t\u0019\u0004C\u0006\u0002Z\u0001\u0001\r\u00111A\u0005\n\u0005m\u0003bCA0\u0001\u0001\u0007\t\u0011)Q\u0005\u0003kA1\"!\u0019\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002d!Y\u0011\u0011\u0010\u0001A\u0002\u0003\u0007I\u0011BA>\u0011-\ty\b\u0001a\u0001\u0002\u0003\u0006K!!\u001a\u0007\r\u0005\u0005\u0005\u0001AAB\u0011)\t)i\u0007B\u0001B\u0003%\u0011q\u0011\u0005\u000b\u0003;[\"\u0011!Q\u0001\n\u0005\u001d\u0005BB2\u001c\t\u0003\ty\nC\u0004\u0002*n!\t%a+\t\rI\u0003A\u0011IA\u001a\u0011\u001d\ti\f\u0001C\u0001\u0003GBq!a0\u0001\t\u0003\n\t\rC\u0004\u0002N\u0002!\t!a4\t\u000f\u0005\u0005\b\u0001\"\u0011\u0002d\"9\u0011Q\u001e\u0001\u0005\u0002\u0005\r\bbBA|\u0001\u0011\u0005\u00111\u001d\u0005\b\u0003w\u0004A\u0011AAr\u0011\u001d\ty\u0010\u0001C\u0001\u0003GDqAa\u0001\u0001\t\u0003\t\u0019\u000fC\u0004\u0003\b\u0001!\t!a9\t\u000f\t-\u0001\u0001\"\u0001\u0002d\"9!q\u0002\u0001\u0005\u0002\u0005\r\bb\u0002B\n\u0001\u0011\u0005\u00111\u001d\u0005\b\u0005/\u0001A\u0011AAr\u0011\u001d\u0011Y\u0002\u0001C\u0001\u0003GDqAa\b\u0001\t\u0003\t\u0019\u000fC\u0004\u0003$\u0001!\t!a9\t\u000f\t\u001d\u0002\u0001\"\u0001\u0002d\"9!1\u0006\u0001\u0005\u0002\u0005\r\bb\u0002B\u0018\u0001\u0011\u0005\u00111\u001d\u0005\b\u0005g\u0001A\u0011\u0002B\u001b\u0011\u001d\u0011Y\u0005\u0001C\u0005\u0005\u001bBqA!\u0016\u0001\t\u0003\t\u0019\u000fC\u0004\u0003Z\u0001!\t!a9\t\u000f\tu\u0003\u0001\"\u0001\u0002d\"9!\u0011\r\u0001\u0005\u0002\u0005\r\bb\u0002B3\u0001\u0011\u0005\u00111\u001d\u0005\b\u0005S\u0002A\u0011AAr\u0011\u001d\u0011i\u0007\u0001C\u0001\u0003GDqA!\u001d\u0001\t\u0003\t\u0019\u000fC\u0004\u0003v\u0001!\t!a9\t\u000f\te\u0004\u0001\"\u0001\u0002d\"9!Q\u0010\u0001\u0005\u0002\u0005\r\bb\u0002BA\u0001\u0011\u0005\u00111\u001d\u0005\b\u0005\u000b\u0003A\u0011AAr\u0011\u001d\u0011I\t\u0001C\u0001\u0003GDqA!$\u0001\t\u0013\u0011y\tC\u0005\u0003\"\u0002\t\n\u0011\"\u0003\u0003$\"9!\u0011\u0018\u0001\u0005\n\tm\u0006b\u0002Bk\u0001\u0011%!q\u001b\u0005\b\u0005+\u0004A\u0011\u0002Bp\u0011\u001d\u0011)\u000e\u0001C\u0005\u0005_DqAa=\u0001\t\u0013\u0011)\u0010C\u0004\u0003|\u0002!\tA!@\t\u000f\t}\b\u0001\"\u0001\u0004\u0002!91Q\u0005\u0001\u0005\u0002\r\u001d\u0002bBB \u0001\u0011\u00051\u0011\t\u0002\u000f\u0003V$\bn\u001c:ju\u0016\u0014H+Z:u\u0015\t\u00116+\u0001\u0006bkRDwN]5{KJT!\u0001V+\u0002\u0011M,7-\u001e:jifT\u0011AV\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0011l\u0018\t\u00035vk\u0011a\u0017\u0006\u00039V\u000baa]3sm\u0016\u0014\u0018B\u00010\\\u0005E\tVo\u001c:v[R+7\u000f\u001e%be:,7o\u001d\t\u0003A\u0006l\u0011!U\u0005\u0003EF\u0013!CQ1tK\u0006+H\u000f[8sSj,'\u000fV3ti\u00061A(\u001b8jiz\"\u0012!\u001a\t\u0003A\u0002\t\u0011\u0002\u0015'B\u0013:#V\t\u0017+\u0016\u0003!\u0004\"![9\u000e\u0003)T!a\u001b7\u0002\r\r|W.\\8o\u0015\t1VN\u0003\u0002o_\u00061\u0011\r]1dQ\u0016T\u0011\u0001]\u0001\u0004_J<\u0017B\u0001:k\u0005!)e\u000e\u001a9pS:$\u0018A\u0003)M\u0003&sE+\u0012-UA\u0005a\u0011\r\u001c7poJ+\u0017\rZ!dYV\ta\u000f\u0005\u0002xu6\t\u0001P\u0003\u0002zU\u0006\u0019\u0011m\u00197\n\u0005mD(AE!dG\u0016\u001c8oQ8oiJ|G.\u00128uef\fQ\"\u00197m_^\u0014V-\u00193BG2\u0004\u0013!D1mY><xK]5uK\u0006\u001bG.\u0001\bbY2|wo\u0016:ji\u0016\f5\r\u001c\u0011\u0002\u0017\u0011,g.\u001f*fC\u0012\f5\r\\\u0001\rI\u0016t\u0017PU3bI\u0006\u001bG\u000eI\u0001\u0011o&dGmQ1sIJ+7o\\;sG\u0016,\"!a\u0002\u0011\t\u0005%\u0011qB\u0007\u0003\u0003\u0017Q1!!\u0004k\u0003!\u0011Xm]8ve\u000e,\u0017\u0002BA\t\u0003\u0017\u0011qBU3t_V\u00148-\u001a)biR,'O\\\u0001\u0012o&dGmQ1sIJ+7o\\;sG\u0016\u0004\u0013\u0001\u00059sK\u001aL\u00070\u001a3SKN|WO]2f\u0003E\u0001(/\u001a4jq\u0016$'+Z:pkJ\u001cW\rI\u0001\u0010G2,8\u000f^3s%\u0016\u001cx.\u001e:dK\u0006\u00012\r\\;ti\u0016\u0014(+Z:pkJ\u001cW\rI\u0001\u0012o&dGmY1sIB\u0013\u0018N\\2ja\u0006dWCAA\u0011!\u0011\t\u0019#a\u000b\u000e\u0005\u0005\u0015\"\u0002BA\u0014\u0003S\tA!Y;uQ*\u0011AK[\u0005\u0005\u0003[\t)C\u0001\bLC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197\u0002%]LG\u000eZ2be\u0012\u0004&/\u001b8dSB\fG\u000eI\u0001\fCV$\bn\u001c:ju\u0016\u0014\u0018'\u0006\u0002\u00026A!\u0011qGA\u001f\u001b\t\tIDC\u0002S\u0003wQ!\u0001\u00187\n\t\u0005}\u0012\u0011\b\u0002\u000b\u0003V$\bn\u001c:ju\u0016\u0014\u0018aD1vi\"|'/\u001b>feFzF%Z9\u0015\t\u0005\u0015\u0013\u0011\u000b\t\u0005\u0003\u000f\ni%\u0004\u0002\u0002J)\u0011\u00111J\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003\u001f\nIE\u0001\u0003V]&$\b\"CA*'\u0005\u0005\t\u0019AA\u001b\u0003\rAH%M\u0001\rCV$\bn\u001c:ju\u0016\u0014\u0018\u0007I\u0001\fCV$\bn\u001c:ju\u0016\u0014('A\bbkRDwN]5{KJ\u0014t\fJ3r)\u0011\t)%!\u0018\t\u0013\u0005Mc#!AA\u0002\u0005U\u0012\u0001D1vi\"|'/\u001b>feJ\u0002\u0013!C0uKN$\u0018J\u001c4p+\t\t)\u0007\u0005\u0003\u0002h\u0005UTBAA5\u0015\u0011\tY'!\u001c\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002p\u0005E\u0014a\u00026va&$XM\u001d\u0006\u0004\u0003gz\u0017!\u00026v]&$\u0018\u0002BA<\u0003S\u0012\u0001\u0002V3ti&sgm\\\u0001\u000e?R,7\u000f^%oM>|F%Z9\u0015\t\u0005\u0015\u0013Q\u0010\u0005\n\u0003'J\u0012\u0011!a\u0001\u0003K\n!b\u0018;fgRLeNZ8!\u0005=\u0019Uo\u001d;p[B\u0013\u0018N\\2ja\u0006d7cA\u000e\u0002\"\u0005i\u0001O]5oG&\u0004\u0018\r\u001c+za\u0016\u0004B!!#\u0002\u0018:!\u00111RAJ!\u0011\ti)!\u0013\u000e\u0005\u0005=%bAAI/\u00061AH]8pizJA!!&\u0002J\u00051\u0001K]3eK\u001aLA!!'\u0002\u001c\n11\u000b\u001e:j]\u001eTA!!&\u0002J\u0005!a.Y7f)\u0019\t\t+!*\u0002(B\u0019\u00111U\u000e\u000e\u0003\u0001Aq!!\"\u001f\u0001\u0004\t9\tC\u0004\u0002\u001ez\u0001\r!a\"\u0002\r\u0015\fX/\u00197t)\u0011\ti+a-\u0011\t\u0005\u001d\u0013qV\u0005\u0005\u0003c\u000bIEA\u0004C_>dW-\u00198\t\u000f\u0005Uv\u00041\u0001\u00028\u0006\tq\u000e\u0005\u0003\u0002H\u0005e\u0016\u0002BA^\u0003\u0013\u00121!\u00118z\u0003!!Xm\u001d;J]\u001a|\u0017!B:fiV\u0003H\u0003BA#\u0003\u0007Dq!!0#\u0001\u0004\t)\u0007K\u0002#\u0003\u000f\u0004B!a\u001a\u0002J&!\u00111ZA5\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001cXCAAi!\u0011\t\u0019.!8\u000e\u0005\u0005U'\u0002BAl\u00033\fA!\u001e;jY*\u0011\u00111\\\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002`\u0006U'A\u0003)s_B,'\u000f^5fg\u0006AA/Z1s\t><h\u000e\u0006\u0002\u0002F!\u001aA%a:\u0011\t\u0005\u001d\u0014\u0011^\u0005\u0005\u0003W\fIGA\u0005BMR,'/R1dQ\u00069C/Z:u\u0003V$\bn\u001c:ju\u0016$\u0006N]8xg>sgj\u001c8MSR,'/\u00197SKN|WO]2fQ\r)\u0013\u0011\u001f\t\u0005\u0003O\n\u00190\u0003\u0003\u0002v\u0006%$\u0001\u0002+fgR\f!\u0005^3ti\u0006+H\u000f[8sSj,w+\u001b;i\u000b6\u0004H/\u001f*fg>,(oY3OC6,\u0007f\u0001\u0014\u0002r\u0006YB/Z:u\u000b6\u0004H/_!dYRC'o\\<t\u000bb\u001cW\r\u001d;j_:D3aJAy\u00031!Xm\u001d;U_BL7-Q2mQ\rA\u0013\u0011_\u0001#i\u0016\u001cH/\u00117m_^\f5mY3tg^KG\u000f[\"vgR|W\u000e\u0015:j]\u000eL\u0007/\u00197)\u0007%\n\t0A\fuKN$H)\u001a8z)\u0006\\Wm\u001d)sK\u000e,G-\u001a8dK\"\u001a!&!=\u0002%Q,7\u000f^!mY><\u0018\t\u001c7BG\u000e,7o\u001d\u0015\u0004W\u0005E\u0018A\u0006;fgR\u001cV\u000f]3s+N,'\u000fS1t\u0003\u000e\u001cWm]:)\u00071\n\t0A\u0015uKN$8+\u001e9feV\u001bXM],ji\"\u001cUo\u001d;p[B\u0013\u0018N\\2ja\u0006d\u0007*Y:BG\u000e,7o\u001d\u0015\u0004[\u0005E\u0018\u0001\u0005;fgR<\u0016\u000e\u001c3DCJ$\u0017i\u00197tQ\rq\u0013\u0011_\u0001\u000fi\u0016\u001cHOT8BG24u.\u001e8eQ\ry\u0013\u0011_\u0001\u0017i\u0016\u001cHOT8BG24u.\u001e8e\u001fZ,'O]5eK\"\u001a\u0001'!=\u00027Q,7\u000f^!dY\u000e{gNZ5h/&$\bn\u00165ji\u0016\u001c\b/Y2fQ\r\t\u0014\u0011_\u0001\u0016i\u0016\u001cH/Q2m\u001b\u0006t\u0017mZ3nK:$\u0018\tU%tQ\r\u0011\u0014\u0011_\u0001.i\u0016\u001cH\u000fT8dC2\u001cuN\\2veJ,g\u000e^'pI&4\u0017nY1uS>twJ\u001a*fg>,(oY3BG2\u001c\bfA\u001a\u0002r\u0006\u0011B/Z:u\u0003\u000ed\u0017J\u001c5fe&$\u0018M\\2fQ\r!\u0014\u0011_\u0001\u0018i\u0016\u001cH/S7qY&\u001c\u0017\r^5p]N|e-\u00117m_^$b!!\u0012\u00038\t\u0005\u0003b\u0002B\u001dk\u0001\u0007!1H\u0001\ta\u0006\u0014XM\u001c;PaB\u0019qO!\u0010\n\u0007\t}\u0002P\u0001\u0007BG2|\u0005/\u001a:bi&|g\u000eC\u0004\u0003DU\u0002\rA!\u0012\u0002\u0015\u0005dGn\\<fI>\u00038\u000f\u0005\u0004\u0002\n\n\u001d#1H\u0005\u0005\u0005\u0013\nYJA\u0002TKR\fa\u0003^3ti&k\u0007\u000f\\5dCRLwN\\:PM\u0012+g.\u001f\u000b\u0007\u0003\u000b\u0012yE!\u0015\t\u000f\teb\u00071\u0001\u0003<!9!1\u000b\u001cA\u0002\t\u0015\u0013!\u00033f]&,Gm\u00149t\u0003M\"Xm\u001d;BG\u000e,7o]!mY><X\rZ%g\u00032dwn^!dY\u0016C\u0018n\u001d;t\u001f:<\u0016\u000e\u001c3dCJ$'+Z:pkJ\u001cW\rK\u00028\u0003c\fq\u0004^3ti\u0012+G.\u001a;f\u0003\u000edwJ\\,jY\u0012\u001c\u0017M\u001d3SKN|WO]2fQ\rA\u0014\u0011_\u0001#i\u0016\u001cH\u000fR3mKR,\u0017\t\u001c7BG2|enV5mI\u000e\f'\u000f\u001a*fg>,(oY3)\u0007e\n\t0A\u001auKN$\u0018iY2fgN\fE\u000e\\8xK\u0012Le-\u00117m_^\f5\r\\#ySN$8o\u00148Qe\u00164\u0017\u000e_3e%\u0016\u001cx.\u001e:dK\"\u001a!(!=\u0002?Q,7\u000f\u001e#fY\u0016$X-Q2m\u001f:\u0004&/\u001a4jq\u0016$'+Z:pkJ\u001cW\rK\u0002<\u0003c\f!\u0005^3ti\u0012+G.\u001a;f\u00032d\u0017i\u00197P]B\u0013XMZ5yK\u0012\u0014Vm]8ve\u000e,\u0007f\u0001\u001f\u0002r\u0006aB/Z:u\u0003\u0012$\u0017i\u00197t\u001f:d\u0015\u000e^3sC2\u0014Vm]8ve\u000e,\u0007fA\u001f\u0002r\u0006iB/Z:u\u0003\u0012$\u0017i\u00197t\u001f:<\u0016\u000e\u001c3dCJ$'+Z:pkJ\u001cW\rK\u0002?\u0003c\fQ\u0004^3ti\u0006#G-Q2mg>s\u0007K]3gSb,GMU3t_V\u00148-\u001a\u0015\u0004\u007f\u0005E\u0018!\t;fgR\fU\u000f\u001e5pe&TXmV5uQB\u0013XMZ5yK\u0012\u0014Vm]8ve\u000e,\u0007f\u0001!\u0002r\u0006yB/Z:u'&tw\r\\3DQ\u0006\u0014\u0018m\u0019;feJ+7o\\;sG\u0016\f5\r\\:)\u0007\u0005\u000b\t0\u0001\u000buKN$x)\u001a;BG2\u001c\bK]5oG&\u0004\u0018\r\u001c\u0015\u0004\u0005\u0006E\u0018A\u0004;fgR\f5\r\\:GS2$XM\u001d\u0015\u0004\u0007\u0006E\u0018!\f;fgR\fU\u000f\u001e5pe&TXMQ=SKN|WO]2f)f\u0004XMT8BG24u.\u001e8e\u001fZ,'O]5eK\"\u001aA)!=\u0002%\rD\u0017M\\4f\u0003\u000ed\u0017I\u001c3WKJLg-\u001f\u000b\u000b\u0005#\u0013\u0019Ja&\u0003\u001c\n}\u0005#BAE\u0005\u000f2\bb\u0002BK\u000b\u0002\u0007!\u0011S\u0001\r_JLw-\u001b8bY\u0006\u001bGn\u001d\u0005\b\u00053+\u0005\u0019\u0001BI\u0003%\tG\rZ3e\u0003\u000ed7\u000fC\u0004\u0003\u001e\u0016\u0003\rA!%\u0002\u0017I,Wn\u001c<fI\u0006\u001bGn\u001d\u0005\n\u0003\u001b)\u0005\u0013!a\u0001\u0003\u000f\tAd\u00195b]\u001e,\u0017i\u00197B]\u00124VM]5gs\u0012\"WMZ1vYR$C'\u0006\u0002\u0003&*\"\u0011q\u0001BTW\t\u0011I\u000b\u0005\u0003\u0003,\nUVB\u0001BW\u0015\u0011\u0011yK!-\u0002\u0013Ut7\r[3dW\u0016$'\u0002\u0002BZ\u0003\u0013\n!\"\u00198o_R\fG/[8o\u0013\u0011\u00119L!,\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0005bkRDwN]5{KRQ\u0011Q\u0016B_\u0005\u007f\u0013yMa5\t\rI;\u0005\u0019AA\u001b\u0011\u001d\u0011\tm\u0012a\u0001\u0005\u0007\faB]3rk\u0016\u001cHoQ8oi\u0016DH\u000f\u0005\u0003\u0003F\n-WB\u0001Bd\u0015\r\u0011IM[\u0001\te\u0016\fX/Z:ug&!!Q\u001aBd\u00059\u0011V-];fgR\u001cuN\u001c;fqRDqA!5H\u0001\u0004\u0011Y$A\u0005pa\u0016\u0014\u0018\r^5p]\"9\u0011QB$A\u0002\u0005\u001d\u0011aB4fi\u0006\u001bGn\u001d\u000b\u0007\u0005#\u0013INa7\t\rIC\u0005\u0019AA\u001b\u0011\u001d\u0011i\u000e\u0013a\u0001\u0003\u000f\tqB]3t_V\u00148-\u001a)biR,'O\u001c\u000b\u0007\u0005C\u0014IOa;\u0011\r\u0005%%q\tBr!\r9(Q]\u0005\u0004\u0005OD(AC!dY\nKg\u000eZ5oO\"1!+\u0013a\u0001\u0003kAqA!<J\u0001\u0004\t\t#A\u0005qe&t7-\u001b9bYR!!\u0011\u001dBy\u0011\u0019\u0011&\n1\u0001\u00026\u00059a/\u00197jI>\u0003H\u0003BAW\u0005oDqA!?L\u0001\u0004\u0011Y$\u0001\u0002pa\u0006\u00012M]3bi\u0016\fU\u000f\u001e5pe&TXM\u001d\u000b\u0003\u0003k\t1cY8oM&<WO]3BkRDwN]5{KJ$\u0002\"!\u0012\u0004\u0004\r\u00151Q\u0003\u0005\u0007%6\u0003\r!!\u000e\t\u000f\r\u001dQ\n1\u0001\u0004\n\u000591m\u001c8gS\u001e\u001c\b\u0003CAj\u0007\u0017\t9ia\u0004\n\t\r5\u0011Q\u001b\u0002\u0004\u001b\u0006\u0004\b\u0003BA$\u0007#IAaa\u0005\u0002J\t1\u0011I\\=SK\u001aDqaa\u0006N\u0001\u0004\u0019I\"A\u0007qYV<\u0017N\\'fiJL7m\u001d\t\u0005\u00077\u0019\t#\u0004\u0002\u0004\u001e)\u00191q\u00046\u0002\u000f5,GO]5dg&!11EB\u000f\u00055\u0001F.^4j]6+GO]5dg\u0006Y2m\u001c8gS\u001e,(/Z*uC:$\u0017M\u001d3BkRDwN]5{KJ$\u0002\"!\u0012\u0004*\rm2Q\b\u0005\b\u0007Wq\u0005\u0019AB\u0017\u0003I\u0019H/\u00198eCJ$\u0017)\u001e;i_JL'0\u001a:\u0011\t\r=2qG\u0007\u0003\u0007cQ1AUB\u001a\u0015\r\u0019)\u0004\\\u0001\t[\u0016$\u0018\rZ1uC&!1\u0011HB\u0019\u0005I\u0019F/\u00198eCJ$\u0017)\u001e;i_JL'0\u001a:\t\u000f\r\u001da\n1\u0001\u0004\n!91q\u0003(A\u0002\re\u0011\u0001H5oSRL\u0017\r\\5{KN#\u0018M\u001c3be\u0012\fU\u000f\u001e5pe&TXM\u001d\u000b\u0007\u0003\u000b\u001a\u0019e!\u0012\t\u000f\r-r\n1\u0001\u0004.!91qI(A\u0002\r%\u0013AC:feZ,'/\u00138g_B!\u0011qGB&\u0013\u0011\u0019i%!\u000f\u0003)\u0005+H\u000f[8sSj,'oU3sm\u0016\u0014\u0018J\u001c4p\u0001")
public class AuthorizerTest
extends QuorumTestHarness
implements BaseAuthorizerTest {
    private final Endpoint PLAINTEXT;
    private final AccessControlEntry allowReadAcl;
    private final AccessControlEntry allowWriteAcl;
    private final AccessControlEntry denyReadAcl;
    private final ResourcePattern wildCardResource;
    private final ResourcePattern prefixedResource;
    private final ResourcePattern clusterResource;
    private final KafkaPrincipal wildcardPrincipal;
    private Authorizer authorizer1;
    private Authorizer authorizer2;
    private TestInfo _testInfo;
    private String superUsers;
    private String username;
    private KafkaPrincipal principal;
    private RequestContext requestContext;
    private String superUserName;
    private KafkaConfig config;
    private ResourcePattern resource;

    @Override
    @Test
    public void testAuthorizeByResourceTypeMultipleAddAndRemove() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeMultipleAddAndRemove$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeDenyTakesPrecedence() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeDenyTakesPrecedence$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypePrefixedResourceDenyDominate() {
        BaseAuthorizerTest.testAuthorizeByResourceTypePrefixedResourceDenyDominate$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeWildcardResourceDenyDominate() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeWildcardResourceDenyDominate$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeWithAllOperationAce() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeWithAllOperationAce$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeWithAllHostAce() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeWithAllHostAce$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeWithAllPrincipalAce() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeWithAllPrincipalAce$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeSuperUserHasAccess() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeSuperUserHasAccess$(this);
    }

    @Override
    public RequestContext newRequestContext(KafkaPrincipal principal, InetAddress clientAddress, ApiKeys apiKey) {
        return BaseAuthorizerTest.newRequestContext$(this, principal, clientAddress, apiKey);
    }

    @Override
    public ApiKeys newRequestContext$default$3() {
        return BaseAuthorizerTest.newRequestContext$default$3$(this);
    }

    @Override
    public boolean authorizeByResourceType(Authorizer authorizer, RequestContext requestContext, AclOperation operation, ResourceType resourceType) {
        return BaseAuthorizerTest.authorizeByResourceType$(this, authorizer, requestContext, operation, resourceType);
    }

    @Override
    public void addAcls(Authorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        BaseAuthorizerTest.addAcls$(this, authorizer, aces, resourcePattern);
    }

    @Override
    public boolean removeAcls(Authorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        return BaseAuthorizerTest.removeAcls$(this, authorizer, aces, resourcePattern);
    }

    @Override
    public String superUsers() {
        return this.superUsers;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public KafkaPrincipal principal() {
        return this.principal;
    }

    @Override
    public RequestContext requestContext() {
        return this.requestContext;
    }

    @Override
    public String superUserName() {
        return this.superUserName;
    }

    @Override
    public KafkaConfig config() {
        return this.config;
    }

    @Override
    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    @Override
    public ResourcePattern resource() {
        return this.resource;
    }

    @Override
    public void resource_$eq(ResourcePattern x$1) {
        this.resource = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUsers_$eq(String x$1) {
        this.superUsers = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$username_$eq(String x$1) {
        this.username = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$principal_$eq(KafkaPrincipal x$1) {
        this.principal = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$requestContext_$eq(RequestContext x$1) {
        this.requestContext = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUserName_$eq(String x$1) {
        this.superUserName = x$1;
    }

    private final Endpoint PLAINTEXT() {
        return this.PLAINTEXT;
    }

    private AccessControlEntry allowReadAcl() {
        return this.allowReadAcl;
    }

    private AccessControlEntry allowWriteAcl() {
        return this.allowWriteAcl;
    }

    private AccessControlEntry denyReadAcl() {
        return this.denyReadAcl;
    }

    private ResourcePattern wildCardResource() {
        return this.wildCardResource;
    }

    private ResourcePattern prefixedResource() {
        return this.prefixedResource;
    }

    private ResourcePattern clusterResource() {
        return this.clusterResource;
    }

    private KafkaPrincipal wildcardPrincipal() {
        return this.wildcardPrincipal;
    }

    private Authorizer authorizer1() {
        return this.authorizer1;
    }

    private void authorizer1_$eq(Authorizer x$1) {
        this.authorizer1 = x$1;
    }

    private Authorizer authorizer2() {
        return this.authorizer2;
    }

    private void authorizer2_$eq(Authorizer x$1) {
        this.authorizer2 = x$1;
    }

    private TestInfo _testInfo() {
        return this._testInfo;
    }

    private void _testInfo_$eq(TestInfo x$1) {
        this._testInfo = x$1;
    }

    @Override
    public Authorizer authorizer() {
        return this.authorizer1();
    }

    public TestInfo testInfo() {
        return this._testInfo();
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this._testInfo_$eq(testInfo);
        Properties props = this.properties();
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.authorizer1_$eq(this.createAuthorizer());
        this.configureAuthorizer(this.authorizer1(), this.config().originals(), (PluginMetrics)new PluginMetricsImpl(new Metrics(), Map.of()));
        this.authorizer2_$eq(this.createAuthorizer());
        this.configureAuthorizer(this.authorizer2(), this.config().originals(), (PluginMetrics)new PluginMetricsImpl(new Metrics(), Map.of()));
        this.resource_$eq(new ResourcePattern(ResourceType.TOPIC, "foo-" + UUID.randomUUID(), PatternType.LITERAL));
    }

    public Properties properties() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put("super.users", this.superUsers());
        return props;
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.authorizer1().close();
        this.authorizer2().close();
        TestUtils$.MODULE$.clearYammerMetrics();
        super.tearDown();
    }

    @Test
    public void testAuthorizeThrowsOnNonLiteralResource() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.authorize(this.authorizer1(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "something", PatternType.PREFIXED)));
    }

    @Test
    public void testAuthorizeWithEmptyResourceName() {
        Assertions.assertFalse((boolean)this.authorize(this.authorizer1(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL));
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)));
    }

    @Test
    public void testEmptyAclThrowsException() {
        Assertions.assertThrows(ApiException.class, () -> this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)));
    }

    @Test
    public void testTopicAcl() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "rob");
        KafkaPrincipal user3 = new KafkaPrincipal("User", "batman");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl2 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl3 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl4 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry acl5 = new AccessControlEntry(user1.toString(), "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AccessControlEntry acl6 = new AccessControlEntry(user2.toString(), "*", AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl7 = new AccessControlEntry(user3.toString(), "*", AclOperation.WRITE, AclPermissionType.ALLOW);
        Set acls = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3, acl4, acl5, acl6, acl7}));
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        RequestContext host1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RequestContext host2Context = this.newRequestContext(user1, host2, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), host2Context, AclOperation.READ, this.resource()), (String)"User1 should have READ access from host2");
        Assertions.assertFalse((boolean)this.authorize(this.authorizer1(), host1Context, AclOperation.READ, this.resource()), (String)"User1 should not have READ access from host1 due to denyAcl");
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), host1Context, AclOperation.WRITE, this.resource()), (String)"User1 should have WRITE access from host1");
        Assertions.assertFalse((boolean)this.authorize(this.authorizer1(), host2Context, AclOperation.WRITE, this.resource()), (String)"User1 should not have WRITE access from host2 as no allow acl is defined");
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), host1Context, AclOperation.DESCRIBE, this.resource()), (String)"User1 should not have DESCRIBE access from host1");
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), host2Context, AclOperation.DESCRIBE, this.resource()), (String)"User1 should have DESCRIBE access from host2");
        Assertions.assertFalse((boolean)this.authorize(this.authorizer1(), host1Context, AclOperation.ALTER, this.resource()), (String)"User1 should not have edit access from host1");
        Assertions.assertFalse((boolean)this.authorize(this.authorizer1(), host2Context, AclOperation.ALTER, this.resource()), (String)"User1 should not have edit access from host2");
        RequestContext user2Context = this.newRequestContext(user2, host1, this.newRequestContext$default$3());
        RequestContext user3Context = this.newRequestContext(user3, host1, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), user2Context, AclOperation.DESCRIBE, this.resource()), (String)"User2 should have DESCRIBE access from host1");
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), user3Context, AclOperation.DESCRIBE, this.resource()), (String)"User3 should have DESCRIBE access from host2");
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), user2Context, AclOperation.READ, this.resource()), (String)"User2 should have READ access from host1");
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), user3Context, AclOperation.WRITE, this.resource()), (String)"User3 should have WRITE access from host2");
    }

    @Test
    public void testAllowAccessWithCustomPrincipal() {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        CustomPrincipal customUserPrincipal = new CustomPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        AccessControlEntry acl1 = new AccessControlEntry(user.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl2 = new AccessControlEntry(user.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        Set acls = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}));
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        RequestContext host1Context = this.newRequestContext(customUserPrincipal, host1, this.newRequestContext$default$3());
        RequestContext host2Context = this.newRequestContext(customUserPrincipal, host2, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), host2Context, AclOperation.READ, this.resource()), (String)"User1 should have READ access from host2");
        Assertions.assertFalse((boolean)this.authorize(this.authorizer1(), host1Context, AclOperation.READ, this.resource()), (String)"User1 should not have READ access from host1 due to denyAcl");
    }

    @Test
    public void testDenyTakesPrecedence() {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.2.1");
        RequestContext session = this.newRequestContext(user, host, this.newRequestContext$default$3());
        AccessControlEntry allowAll = new AccessControlEntry(AclEntry.WILDCARD_PRINCIPAL_STRING, "*", AclOperation.ALL, AclPermissionType.ALLOW);
        AccessControlEntry denyAcl = new AccessControlEntry(user.toString(), host.getHostAddress(), AclOperation.ALL, AclPermissionType.DENY);
        Set acls = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAll, denyAcl}));
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        Assertions.assertFalse((boolean)this.authorize(this.authorizer1(), session, AclOperation.READ, this.resource()), (String)"deny should take precedence over allow.");
    }

    @Test
    public void testAllowAllAccess() {
        AccessControlEntry allowAllAcl = new AccessControlEntry(AclEntry.WILDCARD_PRINCIPAL_STRING, "*", AclOperation.ALL, AclPermissionType.ALLOW);
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAllAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        RequestContext context = this.newRequestContext(new KafkaPrincipal("User", "random"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), context, AclOperation.READ, this.resource()), (String)"allow all acl should allow access to all.");
    }

    @Test
    public void testSuperUserHasAccess() {
        AccessControlEntry denyAllAcl = new AccessControlEntry(AclEntry.WILDCARD_PRINCIPAL_STRING, "*", AclOperation.ALL, AclPermissionType.DENY);
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        RequestContext session1 = this.newRequestContext(new KafkaPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        RequestContext session2 = this.newRequestContext(new KafkaPrincipal("User", "superuser2"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), session1, AclOperation.READ, this.resource()), (String)"superuser always has access, no matter what acls.");
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), session2, AclOperation.READ, this.resource()), (String)"superuser always has access, no matter what acls.");
    }

    @Test
    public void testSuperUserWithCustomPrincipalHasAccess() {
        AccessControlEntry denyAllAcl = new AccessControlEntry(AclEntry.WILDCARD_PRINCIPAL_STRING, "*", AclOperation.ALL, AclPermissionType.DENY);
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        RequestContext session = this.newRequestContext(new CustomPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"), this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), session, AclOperation.READ, this.resource()), (String)"superuser with custom principal always has access, no matter what acls.");
    }

    @Test
    public void testWildCardAcls() {
        Assertions.assertFalse((boolean)this.authorize(this.authorizer1(), this.requestContext(), AclOperation.READ, this.resource()), (String)"when acls = [], authorizer should fail close.");
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        AccessControlEntry readAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        Set<AccessControlEntry> acls = this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{readAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        RequestContext host1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), host1Context, AclOperation.READ, this.resource()), (String)"User1 should have READ access from host1");
        AccessControlEntry writeAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{writeAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        AccessControlEntry denyWriteOnWildCardResourceAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        this.changeAclAndVerify(acls, (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyWriteOnWildCardResourceAcl}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        Assertions.assertFalse((boolean)this.authorize(this.authorizer1(), host1Context, AclOperation.WRITE, this.resource()), (String)"User1 should not have WRITE access from host1");
    }

    @Test
    public void testNoAclFound() {
        Assertions.assertFalse((boolean)this.authorize(this.authorizer1(), this.requestContext(), AclOperation.READ, this.resource()), (String)"when acls = [], authorizer should deny op.");
    }

    @Test
    public void testNoAclFoundOverride() {
        Properties props = this.properties();
        props.put("allow.everyone.if.no.acl.found", "true");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        try (Authorizer testAuthorizer = this.createAuthorizer();){
            this.configureAuthorizer(testAuthorizer, cfg.originals(), (PluginMetrics)new PluginMetricsImpl(new Metrics(), Map.of()));
            Assertions.assertTrue((boolean)this.authorize(testAuthorizer, this.requestContext(), AclOperation.READ, this.resource()), (String)"when acls = null or [],  authorizer should allow op with allow.everyone = true.");
        }
    }

    @Test
    public void testAclConfigWithWhitespace() {
        Properties props = this.properties();
        props.put("allow.everyone.if.no.acl.found", " true");
        props.replaceAll((BiFunction<? super Object, ? super Object, ?>)((BiFunction<Object, Object, String>)(x$4, v) -> " " + v + " "));
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        try (Authorizer testAuthorizer = this.createAuthorizer();){
            this.configureAuthorizer(testAuthorizer, cfg.originals(), (PluginMetrics)new PluginMetricsImpl(new Metrics(), Map.of()));
            Assertions.assertTrue((boolean)this.authorize(testAuthorizer, this.requestContext(), AclOperation.READ, this.resource()), (String)"when acls = null or [],  authorizer should allow op with allow.everyone = true.");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAclManagementAPIs() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        String host1 = "host1";
        String host2 = "host2";
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1, AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl2 = new AccessControlEntry(user1.toString(), host1, AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry acl3 = new AccessControlEntry(user2.toString(), host2, AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl4 = new AccessControlEntry(user2.toString(), host2, AclOperation.WRITE, AclPermissionType.ALLOW);
        Set<AccessControlEntry> acls = this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3, acl4}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        AccessControlEntry acl5 = new AccessControlEntry(user2.toString(), "*", AclOperation.READ, AclPermissionType.ALLOW);
        acls = this.changeAclAndVerify(acls, (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl5}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AuthorizerTest.$anonfun$testAclManagementAPIs$1(this, acl1, acl2, user1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"changes not propagated in timeout period");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AuthorizerTest.$anonfun$testAclManagementAPIs$4(this, acl3, acl4, acl5, user2)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"changes not propagated in timeout period");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        scala.collection.immutable.Map resourceToAcls = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user2.toString(), "*", AclOperation.READ, AclPermissionType.ALLOW)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.CLUSTER, "*", PatternType.LITERAL)), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user2.toString(), host1, AclOperation.READ, AclPermissionType.ALLOW)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL)), acls), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ResourcePattern(ResourceType.GROUP, "test-ConsumerGroup", PatternType.LITERAL)), acls)}));
        resourceToAcls.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                ResourcePattern key = (ResourcePattern)x0$1._1();
                Set value = (Set)x0$1._2();
                return this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)value, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), key);
            }
            throw new MatchError(null);
        });
        Set expectedAcls = ((IterableOnceOps)resourceToAcls.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.resource()), acls)).flatMap((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                ResourcePattern res = (ResourcePattern)x0$2._1();
                return (Set)((Set)x0$2._2()).map((Function1 & Serializable)acl -> new AclBinding(res, acl));
            }
            throw new MatchError(null);
        })).toSet();
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!AuthorizerTest.$anonfun$testAclManagementAPIs$10(this, expectedAcls)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"changes not propagated in timeout period.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        this.changeAclAndVerify(acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl5}))), this.resource());
        acls = null;
        this.removeAcls(this.authorizer1(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.authorizer1(), this.resource(), AccessControlEntryFilter.ANY);
        acls = this.changeAclAndVerify((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        this.changeAclAndVerify(acls, (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), acls, this.resource());
    }

    @Test
    public void testLocalConcurrentModificationOfResourceAcls() {
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), "*", AclOperation.READ, AclPermissionType.ALLOW);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), "*", AclOperation.READ, AclPermissionType.DENY);
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), commonResource);
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}))), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2}))), this.authorizer1(), commonResource, AccessControlEntryFilter.ANY);
    }

    @Test
    public void testAclInheritance() {
        this.testImplicationsOfAllow(AclOperation.ALL, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DELETE, AclOperation.ALTER, AclOperation.DESCRIBE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE, AclOperation.CREATE_TOKENS, AclOperation.DESCRIBE_TOKENS, AclOperation.TWO_PHASE_COMMIT}))));
        this.testImplicationsOfDeny(AclOperation.ALL, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DELETE, AclOperation.ALTER, AclOperation.DESCRIBE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE, AclOperation.CREATE_TOKENS, AclOperation.DESCRIBE_TOKENS, AclOperation.TWO_PHASE_COMMIT}))));
        this.testImplicationsOfAllow(AclOperation.READ, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfAllow(AclOperation.WRITE, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfAllow(AclOperation.DELETE, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfAllow(AclOperation.ALTER, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}))));
        this.testImplicationsOfDeny(AclOperation.DESCRIBE, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        this.testImplicationsOfAllow(AclOperation.ALTER_CONFIGS, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE_CONFIGS}))));
        this.testImplicationsOfDeny(AclOperation.DESCRIBE_CONFIGS, (Set<AclOperation>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
    }

    private void testImplicationsOfAllow(AclOperation parentOp, Set<AclOperation> allowedOps) {
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.3.1");
        RequestContext hostContext = this.newRequestContext(user, host, this.newRequestContext$default$3());
        AccessControlEntry acl = new AccessControlEntry(user.toString(), "*", parentOp, AclPermissionType.ALLOW);
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), this.clusterResource());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])AclOperation.values()), (Function1 & Serializable)op -> BoxesRunTime.boxToBoolean((boolean)this.validOp(op)))), (Function1 & Serializable)op -> {
            AuthorizerTest.$anonfun$testImplicationsOfAllow$2(this, hostContext, allowedOps, parentOp, op);
            return BoxedUnit.UNIT;
        });
        this.removeAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl}))), this.clusterResource());
    }

    private void testImplicationsOfDeny(AclOperation parentOp, Set<AclOperation> deniedOps) {
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        RequestContext host1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        Set acls = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user1.toString(), "*", parentOp, AclPermissionType.DENY), new AccessControlEntry(user1.toString(), "*", AclOperation.ALL, AclPermissionType.ALLOW)}));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)acls, this.clusterResource());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])AclOperation.values()), (Function1 & Serializable)op -> BoxesRunTime.boxToBoolean((boolean)this.validOp(op)))), (Function1 & Serializable)op -> {
            AuthorizerTest.$anonfun$testImplicationsOfDeny$2(this, host1Context, deniedOps, parentOp, op);
            return BoxedUnit.UNIT;
        });
        this.removeAcls(this.authorizer1(), (Set<AccessControlEntry>)acls, this.clusterResource());
    }

    @Test
    public void testAccessAllowedIfAllowAclExistsOnWildcardResource() {
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.wildCardResource());
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    @Test
    public void testDeleteAclOnWildcardResource() {
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.wildCardResource());
        this.removeAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.wildCardResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl()})), this.getAcls(this.authorizer1(), this.wildCardResource()));
    }

    @Test
    public void testDeleteAllAclOnWildcardResource() {
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.wildCardResource());
        this.removeAcls(this.authorizer1(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.wildCardResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.authorizer1()));
    }

    @Test
    public void testAccessAllowedIfAllowAclExistsOnPrefixedResource() {
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.prefixedResource());
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    @Test
    public void testDeleteAclOnPrefixedResource() {
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.prefixedResource());
        this.removeAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.prefixedResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl()})), this.getAcls(this.authorizer1(), this.prefixedResource()));
    }

    @Test
    public void testDeleteAllAclOnPrefixedResource() {
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.prefixedResource());
        this.removeAcls(this.authorizer1(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.prefixedResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.authorizer1()));
    }

    @Test
    public void testAddAclsOnLiteralResource() {
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.resource());
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()}))), this.resource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), this.getAcls(this.authorizer1(), this.resource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.authorizer1(), this.wildCardResource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.authorizer1(), this.prefixedResource()));
    }

    @Test
    public void testAddAclsOnWildcardResource() {
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.wildCardResource());
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()}))), this.wildCardResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), this.getAcls(this.authorizer1(), this.wildCardResource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.authorizer1(), this.resource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.authorizer1(), this.prefixedResource()));
    }

    @Test
    public void testAddAclsOnPrefixedResource() {
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()}))), this.prefixedResource());
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()}))), this.prefixedResource());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()})), this.getAcls(this.authorizer1(), this.prefixedResource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.authorizer1(), this.wildCardResource()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.getAcls(this.authorizer1(), this.resource()));
    }

    @Test
    public void testAuthorizeWithPrefixedResource() {
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "a_other", PatternType.LITERAL));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "a_other", PatternType.PREFIXED));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "foo-" + UUID.randomUUID(), PatternType.PREFIXED));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "foo-" + UUID.randomUUID(), PatternType.PREFIXED));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "foo-" + UUID.randomUUID() + "-zzz", PatternType.PREFIXED));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "fooo-" + UUID.randomUUID(), PatternType.PREFIXED));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "fo-" + UUID.randomUUID(), PatternType.PREFIXED));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "fop-" + UUID.randomUUID(), PatternType.PREFIXED));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "fon-" + UUID.randomUUID(), PatternType.PREFIXED));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "fon-", PatternType.PREFIXED));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), this.prefixedResource());
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    @Test
    public void testSingleCharacterResourceAcls() {
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "f", PatternType.LITERAL));
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "f", PatternType.LITERAL)));
        Assertions.assertFalse((boolean)this.authorize(this.authorizer1(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.LITERAL)));
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()}))), new ResourcePattern(ResourceType.TOPIC, "_", PatternType.PREFIXED));
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "_foo", PatternType.LITERAL)));
        Assertions.assertTrue((boolean)this.authorize(this.authorizer1(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "_", PatternType.LITERAL)));
        Assertions.assertFalse((boolean)this.authorize(this.authorizer1(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "foo_", PatternType.LITERAL)));
    }

    @Test
    public void testGetAclsPrincipal() {
        AccessControlEntry aclOnSpecificPrincipal = new AccessControlEntry(this.principal().toString(), "*", AclOperation.WRITE, AclPermissionType.ALLOW);
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{aclOnSpecificPrincipal}))), this.resource());
        Assertions.assertEquals((int)0, (int)this.getAcls(this.authorizer1(), this.wildcardPrincipal()).size(), (String)"acl on specific should not be returned for wildcard request");
        Assertions.assertEquals((int)1, (int)this.getAcls(this.authorizer1(), this.principal()).size(), (String)"acl on specific should be returned for specific request");
        Assertions.assertEquals((int)1, (int)this.getAcls(this.authorizer1(), new KafkaPrincipal(this.principal().getPrincipalType(), this.principal().getName())).size(), (String)"acl on specific should be returned for different principal instance");
        this.removeAcls(this.authorizer1(), (Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), this.resource());
        AccessControlEntry aclOnWildcardPrincipal = new AccessControlEntry(AclEntry.WILDCARD_PRINCIPAL_STRING, "*", AclOperation.WRITE, AclPermissionType.ALLOW);
        this.addAcls(this.authorizer1(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{aclOnWildcardPrincipal}))), this.resource());
        Assertions.assertEquals((int)1, (int)this.getAcls(this.authorizer1(), this.wildcardPrincipal()).size(), (String)"acl on wildcard should be returned for wildcard request");
        Assertions.assertEquals((int)0, (int)this.getAcls(this.authorizer1(), this.principal()).size(), (String)"acl on wildcard should not be returned for specific request");
    }

    @Test
    public void testAclsFilter() {
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, "foo-" + UUID.randomUUID(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, "bar-" + UUID.randomUUID(), PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "bar-", PatternType.PREFIXED);
        AclBinding acl1 = new AclBinding(resource1, new AccessControlEntry(this.principal().toString(), "*", AclOperation.READ, AclPermissionType.ALLOW));
        AclBinding acl2 = new AclBinding(resource1, new AccessControlEntry(this.principal().toString(), "192.168.0.1", AclOperation.WRITE, AclPermissionType.ALLOW));
        AclBinding acl3 = new AclBinding(resource2, new AccessControlEntry(this.principal().toString(), "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        AclBinding acl4 = new AclBinding(prefixedResource, new AccessControlEntry(this.wildcardPrincipal().toString(), "*", AclOperation.READ, AclPermissionType.ALLOW));
        this.authorizer1().createAcls((AuthorizableRequestContext)this.requestContext(), java.util.List.of(acl1, acl2, acl3, acl4));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1, acl2, acl3, acl4})), (Object)CollectionConverters$.MODULE$.IterableHasAsScala(this.authorizer1().acls(AclBindingFilter.ANY)).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1, acl2})), (Object)CollectionConverters$.MODULE$.IterableHasAsScala(this.authorizer1().acls(new AclBindingFilter(resource1.toFilter(), AccessControlEntryFilter.ANY))).asScala().toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl4})), (Object)CollectionConverters$.MODULE$.IterableHasAsScala(this.authorizer1().acls(new AclBindingFilter(prefixedResource.toFilter(), AccessControlEntryFilter.ANY))).asScala().toSet());
        AclBindingFilter matchingFilter = new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, resource2.name(), PatternType.MATCH), AccessControlEntryFilter.ANY);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl3, acl4})), (Object)CollectionConverters$.MODULE$.IterableHasAsScala(this.authorizer1().acls(matchingFilter)).asScala().toSet());
        .colon.colon filters = new .colon.colon((Object)matchingFilter, (List)new .colon.colon((Object)acl1.toFilter(), (List)new .colon.colon((Object)new AclBindingFilter(resource2.toFilter(), AccessControlEntryFilter.ANY), (List)new .colon.colon((Object)new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, "baz", PatternType.ANY), AccessControlEntryFilter.ANY), (List)Nil$.MODULE$))));
        Buffer deleteResults = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.authorizer1().deleteAcls((AuthorizableRequestContext)this.requestContext(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)filters).asJava())).asScala().map((Function1 & Serializable)x$5 -> (AclDeleteResult)x$5.toCompletableFuture().get());
        Assertions.assertEquals((Object)package$.MODULE$.List().empty(), (Object)deleteResults.filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)AuthorizerTest.$anonfun$testAclsFilter$2(x$6))));
        filters.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(((AclDeleteResult)deleteResults.apply(i)).aclBindingDeleteResults()).asScala().toSet().filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AuthorizerTest.$anonfun$testAclsFilter$4(x$7)))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl3, acl4})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(((AclDeleteResult)deleteResults.apply(0)).aclBindingDeleteResults()).asScala().map((Function1 & Serializable)x$8 -> x$8.aclBinding())).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(((AclDeleteResult)deleteResults.apply(1)).aclBindingDeleteResults()).asScala().map((Function1 & Serializable)x$9 -> x$9.aclBinding())).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl3})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(((AclDeleteResult)deleteResults.apply(2)).aclBindingDeleteResults()).asScala().map((Function1 & Serializable)x$10 -> x$10.aclBinding())).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(((AclDeleteResult)deleteResults.apply(3)).aclBindingDeleteResults()).asScala().map((Function1 & Serializable)x$11 -> x$11.aclBinding())).toSet());
    }

    @Test
    public void testAuthorizeByResourceTypeNoAclFoundOverride() {
        Properties props = this.properties();
        props.put("allow.everyone.if.no.acl.found", "true");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        try (Authorizer authorizer = this.createAuthorizer();){
            this.configureAuthorizer(authorizer, cfg.originals(), (PluginMetrics)new PluginMetricsImpl(new Metrics(), Map.of()));
            Assertions.assertTrue((boolean)this.authorizeByResourceType(authorizer, this.requestContext(), AclOperation.READ, this.resource().resourceType()), (String)"If allow.everyone.if.no.acl.found = true, caller should have read access to at least one topic");
            Assertions.assertTrue((boolean)this.authorizeByResourceType(authorizer, this.requestContext(), AclOperation.WRITE, this.resource().resourceType()), (String)"If allow.everyone.if.no.acl.found = true, caller should have write access to at least one topic");
        }
    }

    private Set<AccessControlEntry> changeAclAndVerify(Set<AccessControlEntry> originalAcls, Set<AccessControlEntry> addedAcls, Set<AccessControlEntry> removedAcls, ResourcePattern resource) {
        Set acls = originalAcls;
        if (addedAcls.nonEmpty()) {
            this.addAcls(this.authorizer1(), addedAcls, resource);
            acls = (Set)originalAcls.$plus$plus(addedAcls);
        }
        if (removedAcls.nonEmpty()) {
            this.removeAcls(this.authorizer1(), removedAcls, resource);
            acls = (Set)acls.$minus$minus(removedAcls);
        }
        TestUtils$.MODULE$.waitAndVerifyAcls(acls, this.authorizer1(), resource, AccessControlEntryFilter.ANY);
        return acls;
    }

    private ResourcePattern changeAclAndVerify$default$4() {
        return this.resource();
    }

    private boolean authorize(Authorizer authorizer, RequestContext requestContext, AclOperation operation, ResourcePattern resource) {
        Action action = new Action(operation, resource, 1, true, true);
        Object object = CollectionConverters$.MODULE$.ListHasAsScala(authorizer.authorize((AuthorizableRequestContext)requestContext, java.util.List.of(action))).asScala().head();
        AuthorizationResult authorizationResult = AuthorizationResult.ALLOWED;
        return !(object != null ? !object.equals(authorizationResult) : authorizationResult != null);
    }

    private Set<AccessControlEntry> getAcls(Authorizer authorizer, ResourcePattern resourcePattern) {
        return (Set)CollectionConverters$.MODULE$.IterableHasAsScala(authorizer.acls(new AclBindingFilter(resourcePattern.toFilter(), AccessControlEntryFilter.ANY))).asScala().toSet().map((Function1 & Serializable)x$12 -> x$12.entry());
    }

    private Set<AclBinding> getAcls(Authorizer authorizer, KafkaPrincipal principal) {
        AclBindingFilter filter = new AclBindingFilter(ResourcePatternFilter.ANY, new AccessControlEntryFilter(principal.toString(), null, AclOperation.ANY, AclPermissionType.ANY));
        return CollectionConverters$.MODULE$.IterableHasAsScala(authorizer.acls(filter)).asScala().toSet();
    }

    private Set<AclBinding> getAcls(Authorizer authorizer) {
        return CollectionConverters$.MODULE$.IterableHasAsScala(authorizer.acls(AclBindingFilter.ANY)).asScala().toSet();
    }

    private boolean validOp(AclOperation op) {
        AclOperation aclOperation = op;
        AclOperation aclOperation2 = AclOperation.ANY;
        if (aclOperation == null ? aclOperation2 != null : !aclOperation.equals(aclOperation2)) {
            AclOperation aclOperation3 = op;
            AclOperation aclOperation4 = AclOperation.UNKNOWN;
            if (aclOperation3 == null ? aclOperation4 != null : !aclOperation3.equals(aclOperation4)) {
                return true;
            }
        }
        return false;
    }

    public Authorizer createAuthorizer() {
        return new StandardAuthorizer();
    }

    public void configureAuthorizer(Authorizer authorizer, Map<String, Object> configs, PluginMetrics pluginMetrics) {
        this.configureStandardAuthorizer((StandardAuthorizer)authorizer, configs, pluginMetrics);
    }

    public void configureStandardAuthorizer(StandardAuthorizer standardAuthorizer, Map<String, Object> configs, PluginMetrics pluginMetrics) {
        standardAuthorizer.configure(configs);
        standardAuthorizer.withPluginMetrics(pluginMetrics);
        this.initializeStandardAuthorizer(standardAuthorizer, (AuthorizerServerInfo)new StandardAuthorizerTest.AuthorizerTestServerInfo(java.util.List.of(this.PLAINTEXT())));
    }

    public void initializeStandardAuthorizer(StandardAuthorizer standardAuthorizer, AuthorizerServerInfo serverInfo) {
        MockAclMutator aclMutator = new MockAclMutator(standardAuthorizer);
        standardAuthorizer.start(serverInfo);
        standardAuthorizer.setAclMutator((AclMutator)aclMutator);
        standardAuthorizer.completeInitialLoad();
    }

    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$1(AuthorizerTest $this, AccessControlEntry acl1$1, AccessControlEntry acl2$1, KafkaPrincipal user1$1) {
        Object object = ((IterableOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1$1, acl2$1}))).map((Function1 & Serializable)acl -> new AclBinding($this.resource(), acl));
        Set<AclBinding> set = $this.getAcls($this.authorizer1(), user1$1);
        return !(object != null ? !object.equals(set) : set != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$3() {
        return "changes not propagated in timeout period";
    }

    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$4(AuthorizerTest $this, AccessControlEntry acl3$1, AccessControlEntry acl4$1, AccessControlEntry acl5$1, KafkaPrincipal user2$1) {
        Object object = ((IterableOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3$1, acl4$1, acl5$1}))).map((Function1 & Serializable)acl -> new AclBinding($this.resource(), acl));
        Set<AclBinding> set = $this.getAcls($this.authorizer1(), user2$1);
        return !(object != null ? !object.equals(set) : set != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$6() {
        return "changes not propagated in timeout period";
    }

    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$10(AuthorizerTest $this, Set expectedAcls$1) {
        Set set = expectedAcls$1;
        Set<AclBinding> set2 = $this.getAcls($this.authorizer1());
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$11() {
        return "changes not propagated in timeout period.";
    }

    public static final /* synthetic */ void $anonfun$testImplicationsOfAllow$2(AuthorizerTest $this, RequestContext hostContext$1, Set allowedOps$1, AclOperation parentOp$1, AclOperation op) {
        boolean authorized;
        block3: {
            block2: {
                authorized = $this.authorize($this.authorizer1(), hostContext$1, op, $this.clusterResource());
                if (allowedOps$1.contains((Object)op)) break block2;
                AclOperation aclOperation = op;
                if (aclOperation != null ? !aclOperation.equals(parentOp$1) : parentOp$1 != null) break block3;
            }
            Assertions.assertTrue((boolean)authorized, (String)("ALLOW " + parentOp$1 + " should imply ALLOW " + op));
            return;
        }
        Assertions.assertFalse((boolean)authorized, (String)("ALLOW " + parentOp$1 + " should not imply ALLOW " + op));
    }

    public static final /* synthetic */ void $anonfun$testImplicationsOfDeny$2(AuthorizerTest $this, RequestContext host1Context$1, Set deniedOps$1, AclOperation parentOp$2, AclOperation op) {
        boolean authorized;
        block3: {
            block2: {
                authorized = $this.authorize($this.authorizer1(), host1Context$1, op, $this.clusterResource());
                if (deniedOps$1.contains((Object)op)) break block2;
                AclOperation aclOperation = op;
                if (aclOperation != null ? !aclOperation.equals(parentOp$2) : parentOp$2 != null) break block3;
            }
            Assertions.assertFalse((boolean)authorized, (String)("DENY " + parentOp$2 + " should imply DENY " + op));
            return;
        }
        Assertions.assertTrue((boolean)authorized, (String)("DENY " + parentOp$2 + " should not imply DENY " + op));
    }

    public static final /* synthetic */ boolean $anonfun$testAclsFilter$2(AclDeleteResult x$6) {
        return x$6.exception().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testAclsFilter$4(AclDeleteResult.AclBindingDeleteResult x$7) {
        return x$7.exception().isPresent();
    }

    public AuthorizerTest() {
        BaseAuthorizerTest.$init$(this);
        this.PLAINTEXT = new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "127.0.0.1", 9020);
        this.allowReadAcl = new AccessControlEntry(AclEntry.WILDCARD_PRINCIPAL_STRING, "*", AclOperation.READ, AclPermissionType.ALLOW);
        this.allowWriteAcl = new AccessControlEntry(AclEntry.WILDCARD_PRINCIPAL_STRING, "*", AclOperation.WRITE, AclPermissionType.ALLOW);
        this.denyReadAcl = new AccessControlEntry(AclEntry.WILDCARD_PRINCIPAL_STRING, "*", AclOperation.READ, AclPermissionType.DENY);
        this.wildCardResource = new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL);
        this.prefixedResource = new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.PREFIXED);
        this.clusterResource = new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
        this.wildcardPrincipal = SecurityUtils.parseKafkaPrincipal((String)AclEntry.WILDCARD_PRINCIPAL_STRING);
        Statics.releaseFence();
    }

    public class CustomPrincipal
    extends KafkaPrincipal {
        public boolean equals(Object o) {
            return false;
        }

        public /* synthetic */ AuthorizerTest kafka$security$authorizer$AuthorizerTest$CustomPrincipal$$$outer() {
            return AuthorizerTest.this;
        }

        public CustomPrincipal(String principalType, String name) {
            if (AuthorizerTest.this == null) {
                throw null;
            }
            super(principalType, name);
        }
    }
}

