/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.util.Optional;
import kafka.server.AbstractFetcherManager;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerIdAndFetcherId;
import kafka.server.FailedPartitions;
import kafka.server.InitialFetchState;
import kafka.server.OffsetTruncationState;
import kafka.server.TierStateMachine;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.LeaderEndPoint;
import org.apache.kafka.server.PartitionFetchState;
import org.apache.kafka.server.ReplicaFetch;
import org.apache.kafka.server.ReplicaState;
import org.apache.kafka.server.ResultWithPartitions;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.network.BrokerEndPoint;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r-a\u0001\u0002\u0017.\u0001IBQ!\u000f\u0001\u0005\u0002iBQ!\u0010\u0001\u0005\u0002yBQa\u0014\u0001\u0005\nACQ!\u0019\u0001\u0005\u0002yBQA\u001a\u0001\u0005\u0002yBQ\u0001\u001b\u0001\u0005\u0002yBQA\u001b\u0001\u0005\u0002yBQ\u0001\u001c\u0001\u0005\u0002yBQA\u001c\u0001\u0005\u0002yBQ\u0001\u001d\u0001\u0005\nEDqa\u001f\u0001\u0012\u0002\u0013%A\u0010C\u0004\u0002\u0010\u0001!I!!\u0005\t\u0013\u0005u\u0002!%A\u0005\n\u0005}\u0002bBA\"\u0001\u0011%\u0011Q\t\u0004\u0007\u0003\u001b\u0002A!a\u0014\t\u0015\u0005-tB!A!\u0002\u0013\ti\u0007\u0003\u0004:\u001f\u0011\u0005\u0011\u0011\u0010\u0005\u0007\u0003\u0003{A\u0011\t \t\r\u0005\ru\u0002\"\u0011?\u0011\u001d\t)i\u0004C!\u0003\u000fCq!!#\u0010\t\u0003\nY\tC\u0004\u0002F>!\t%a2\t\u000f\u0005mw\u0002\"\u0011\u0002^\"9\u00111]\b\u0005B\u0005\u0015\bb\u0002B\u0010\u001f\u0011\u0005#\u0011\u0005\u0005\n\u0005\u007fy!\u0019!C!\u0005\u0003B\u0001B!\u0013\u0010A\u0003%!1\t\u0005\b\u0005\u0017zA\u0011\tB'\r\u0019\u0011\u0019\u0006\u0001\u0003\u0003V!1\u0011(\bC\u0001\u0005;BqA!\u0019\u001e\t\u0003\u0012\u0019G\u0002\u0004\u0003t\u0001!!Q\u000f\u0005\u000b\u0003W\u0002#\u0011!Q\u0001\n\u00055\u0004B\u0003B?A\t\u0005\t\u0015!\u0003\u0003\u0000!Q!Q\u0011\u0011\u0003\u0002\u0003\u0006IAa\u0016\t\re\u0002C\u0011\u0001BD\u0011\u001d\u0011\t\n\tC)\u0005'CqAa3!\t#\u0012i\rC\u0004\u0003\\\u0002\"\tF!8\t\u000f\t\u0015\b\u0005\"\u0015\u0003h\"9!1\u001f\u0011\u0005R\tU\bb\u0002B}A\u0011E#1 \u0005\b\u0005\u007f\u0004C\u0011KB\u0001\u0005i\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014H+Z:u\u0015\tqs&\u0001\u0004tKJ4XM\u001d\u0006\u0002a\u0005)1.\u00194lC\u000e\u00011C\u0001\u00014!\t!t'D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u000f\t\u0003y\u0001i\u0011!L\u0001\u0014G2,\u0017M\\'fiJL7MU3hSN$(/\u001f\u000b\u0002\u007fA\u0011A\u0007Q\u0005\u0003\u0003V\u0012A!\u00168ji\"\u0012!a\u0011\t\u0003\t6k\u0011!\u0012\u0006\u0003\r\u001e\u000b1!\u00199j\u0015\tA\u0015*A\u0004kkBLG/\u001a:\u000b\u0005)[\u0015!\u00026v]&$(\"\u0001'\u0002\u0007=\u0014x-\u0003\u0002O\u000b\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u001d\u001d,G/T3ue&\u001cg+\u00197vKR\u0011\u0011\u000b\u0016\t\u0003iIK!aU\u001b\u0003\u0007\u0005s\u0017\u0010C\u0003V\u0007\u0001\u0007a+\u0001\u0003oC6,\u0007CA,_\u001d\tAF\f\u0005\u0002Zk5\t!L\u0003\u0002\\c\u00051AH]8pizJ!!X\u001b\u0002\rA\u0013X\rZ3g\u0013\ty\u0006M\u0001\u0004TiJLgn\u001a\u0006\u0003;V\n\u0011\u0004^3ti\u0006#G-\u00118e%\u0016lwN^3QCJ$\u0018\u000e^5p]\"\u0012Aa\u0019\t\u0003\t\u0012L!!Z#\u0003\tQ+7\u000f^\u0001\u001fi\u0016\u001cH/T3ue&\u001cg)Y5mK\u0012\u0004\u0016M\u001d;ji&|gnQ8v]RD#!B2\u00023Q,7\u000f\u001e#fC\u0012$\u0006N]3bI\u000e{WO\u001c;NKR\u0014\u0018n\u0019\u0015\u0003\r\r\fq\u0003^3ti6\u000b\u0017PY3Va\u0012\fG/\u001a+pa&\u001c\u0017\nZ:)\u0005\u001d\u0019\u0017\u0001\u0006;fgR,\u0005\u0010]1oIRC'/Z1e!>|G\u000e\u000b\u0002\tG\u0006!B/Z:u'\"\u0014\u0018N\\6UQJ,\u0017\r\u001a)p_2D#!C2\u0002)Q,7\u000f\u001e*fg&TX\r\u00165sK\u0006$\u0007k\\8m)\u0011y$o^=\t\u000bMT\u0001\u0019\u0001;\u0002%\r,(O]3oi\u001a+Go\u00195feNK'0\u001a\t\u0003iUL!A^\u001b\u0003\u0007%sG\u000fC\u0003y\u0015\u0001\u0007A/\u0001\boK^4U\r^2iKJ\u001c\u0016N_3\t\u000fiT\u0001\u0013!a\u0001i\u0006I!M]8lKJtU/\\\u0001\u001fi\u0016\u001cHOU3tSj,G\u000b\u001b:fC\u0012\u0004vn\u001c7%I\u00164\u0017-\u001e7uIM*\u0012! \u0016\u0003iz\\\u0013a \t\u0005\u0003\u0003\tY!\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003%)hn\u00195fG.,GMC\u0002\u0002\nU\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti!a\u0001\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\nnC.,Gk\u001c9jGB\u000b'\u000f^5uS>tG\u0003CA\n\u0003c\t)$!\u000f\u0011\r\u0005U\u00111DA\u0010\u001b\t\t9BC\u0002\u0002\u001aU\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti\"a\u0006\u0003\u0007M+G\u000f\u0005\u0003\u0002\"\u00055RBAA\u0012\u0015\u0011\t)#a\n\u0002\r\r|W.\\8o\u0015\r\u0001\u0014\u0011\u0006\u0006\u0004\u0003WY\u0015AB1qC\u000eDW-\u0003\u0003\u00020\u0005\r\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007\u0003ga\u0001\u0019\u0001;\u0002\u0011Q|\u0007/[2Ok6Da!a\u000e\r\u0001\u0004!\u0018\u0001\u00049beRLG/[8o\u001dVl\u0007\u0002CA\u001e\u0019A\u0005\t\u0019\u0001,\u0002\u0017Q|\u0007/[2Qe\u00164\u0017\u000e_\u0001\u001d[\u0006\\W\rV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\n3fM\u0006,H\u000e\u001e\u00134+\t\t\tE\u000b\u0002W}\u0006Yq-\u001a;Ce>\\WM]%e)\u0015!\u0018qIA&\u0011\u001d\tIE\u0004a\u0001\u0003?\t!\u0001\u001e9\t\u000bit\u0001\u0019\u0001;\u0003%5{7m\u001b'fC\u0012,'/\u00128e!>Lg\u000e^\n\u0006\u001f\u0005E\u0013\u0011\r\t\u0005\u0003'\ni&\u0004\u0002\u0002V)!\u0011qKA-\u0003\u0011a\u0017M\\4\u000b\u0005\u0005m\u0013\u0001\u00026bm\u0006LA!a\u0018\u0002V\t1qJ\u00196fGR\u0004B!a\u0019\u0002h5\u0011\u0011Q\r\u0006\u0004]\u0005\u001d\u0012\u0002BA5\u0003K\u0012a\u0002T3bI\u0016\u0014XI\u001c3Q_&tG/\u0001\u0007t_V\u00148-\u001a\"s_.,'\u000f\u0005\u0003\u0002p\u0005UTBAA9\u0015\u0011\t\u0019(!\u001a\u0002\u000f9,Go^8sW&!\u0011qOA9\u00059\u0011%o\\6fe\u0016sG\rU8j]R$B!a\u001f\u0002\u0000A\u0019\u0011QP\b\u000e\u0003\u0001Aq!a\u001b\u0012\u0001\u0004\ti'A\u0007j]&$\u0018.\u0019;f\u00072|7/Z\u0001\u0006G2|7/Z\u0001\u000fEJ|7.\u001a:F]\u0012\u0004v.\u001b8u)\t\ti'A\u0003gKR\u001c\u0007\u000e\u0006\u0003\u0002\u000e\u00065\u0006\u0003CAH\u0003+\u000by\"!'\u000e\u0005\u0005E%\u0002BAJ\u00033\nA!\u001e;jY&!\u0011qSAI\u0005\ri\u0015\r\u001d\t\u0005\u00037\u000b9K\u0004\u0003\u0002\u001e\u0006\rVBAAP\u0015\u0011\t\t+a\t\u0002\u000f5,7o]1hK&!\u0011QUAP\u0003E1U\r^2i%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0005\u0003S\u000bYKA\u0007QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0006\u0005\u0003K\u000by\nC\u0004\u00020V\u0001\r!!-\u0002\u0019\u0019,Go\u00195SKF,Xm\u001d;\u0011\t\u0005M\u0016q\u0018\b\u0005\u0003k\u000bY,\u0004\u0002\u00028*!\u0011\u0011XA\u0012\u0003!\u0011X-];fgR\u001c\u0018\u0002BA_\u0003o\u000bABR3uG\"\u0014V-];fgRLA!!1\u0002D\n9!)^5mI\u0016\u0014(\u0002BA_\u0003o\u000b1CZ3uG\",\u0015M\u001d7jKN$xJ\u001a4tKR$b!!3\u0002T\u0006]\u0007\u0003BAf\u0003\u001fl!!!4\u000b\t\u0005\u0015\u0012QM\u0005\u0005\u0003#\fiM\u0001\bPM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195\t\u000f\u0005Ug\u00031\u0001\u0002 \u0005qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007BBAm-\u0001\u0007A/\u0001\ndkJ\u0014XM\u001c;MK\u0006$WM]#q_\u000eD\u0017!\u00054fi\u000eDG*\u0019;fgR|eMZ:fiR1\u0011\u0011ZAp\u0003CDq!!6\u0018\u0001\u0004\ty\u0002\u0003\u0004\u0002Z^\u0001\r\u0001^\u0001\u0015M\u0016$8\r[#q_\u000eDWI\u001c3PM\u001a\u001cX\r^:\u0015\t\u0005\u001d(1\u0002\t\t\u0003\u001f\u000b)*a\b\u0002jB!\u00111\u001eB\u0003\u001d\u0011\tiO!\u0001\u000f\t\u0005=\u0018q \b\u0005\u0003c\fiP\u0004\u0003\u0002t\u0006mh\u0002BA{\u0003st1!WA|\u0013\u0005a\u0015bAA\u0016\u0017&\u0019\u0001'!\u000b\n\t\u0005\u0015\u0012qE\u0005\u0005\u0003C\u000b\u0019#\u0003\u0003\u0003\u0004\u0005}\u0015\u0001I(gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NU3ta>t7/\u001a#bi\u0006LAAa\u0002\u0003\n\tqQ\t]8dQ\u0016sGm\u00144gg\u0016$(\u0002\u0002B\u0002\u0003?CqA!\u0004\u0019\u0001\u0004\u0011y!\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004\u0002\"a$\u0002\u0016\u0006}!\u0011\u0003\t\u0005\u0005'\u0011IB\u0004\u0003\u0002\u001e\nU\u0011\u0002\u0002B\f\u0003?\u000bqd\u00144gg\u0016$hi\u001c:MK\u0006$WM]#q_\u000eD'+Z9vKN$H)\u0019;b\u0013\u0011\u0011YB!\b\u00031=3gm]3u\r>\u0014H*Z1eKJ\u0004\u0016M\u001d;ji&|gN\u0003\u0003\u0003\u0018\u0005}\u0015A\u00032vS2$g)\u001a;dQR!!1\u0005B\u001b!\u0019\t\u0019G!\n\u0003*%!!qEA3\u0005Q\u0011Vm];mi^KG\u000f\u001b)beRLG/[8ogB1\u0011q\u0012B\u0016\u0005_IAA!\f\u0002\u0012\nAq\n\u001d;j_:\fG\u000e\u0005\u0003\u0002d\tE\u0012\u0002\u0002B\u001a\u0003K\u0012ABU3qY&\u001c\u0017MR3uG\"DqA!\u0004\u001a\u0001\u0004\u00119\u0004\u0005\u0005\u0002\u0010\u0006U\u0015q\u0004B\u001d!\u0011\t\u0019Ga\u000f\n\t\tu\u0012Q\r\u0002\u0014!\u0006\u0014H/\u001b;j_:4U\r^2i'R\fG/Z\u0001\u001dSN$&/\u001e8dCRLwN\\(o\r\u0016$8\r[*vaB|'\u000f^3e+\t\u0011\u0019\u0005E\u00025\u0005\u000bJ1Aa\u00126\u0005\u001d\u0011un\u001c7fC:\fQ$[:UeVt7-\u0019;j_:|eNR3uG\"\u001cV\u000f\u001d9peR,G\rI\u0001\u0019M\u0016$8\r[#be2LWm\u001d;M_\u000e\fGn\u00144gg\u0016$HCBAe\u0005\u001f\u0012\t\u0006C\u0004\u0002Vr\u0001\r!a\b\t\r\u0005eG\u00041\u0001u\u0005\u0005junY6SKNL'0\u001a$fi\u000eDWM\u001d+jKJ\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f'\ri\"q\u000b\t\u0004y\te\u0013b\u0001B.[\t\u0001B+[3s'R\fG/Z'bG\"Lg.\u001a\u000b\u0003\u0005?\u00022!! \u001e\u0003\u0015\u0019H/\u0019:u)!\u0011ID!\u001a\u0003h\t-\u0004bBAk?\u0001\u0007\u0011q\u0004\u0005\b\u0005Sz\u0002\u0019\u0001B\u001d\u0003E\u0019WO\u001d:f]R4U\r^2i'R\fG/\u001a\u0005\b\u0005[z\u0002\u0019\u0001B8\u0003I1W\r^2i!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0011\t\tE\u0014q\u0015\b\u0005\u0003[\f\u0019KA\fUKN$(+Z:ju\u00164U\r^2iKJ$\u0006N]3bIN\u0019\u0001Ea\u001e\u0011\u0007q\u0012I(C\u0002\u0003|5\u0012Q#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG-\u0001\tgC&dW\r\u001a)beRLG/[8ogB\u0019AH!!\n\u0007\t\rUF\u0001\tGC&dW\r\u001a)beRLG/[8og\u0006)b-\u001a;dQRKWM]*uCR,W*Y2iS:,G\u0003\u0003BE\u0005\u0017\u0013iIa$\u0011\u0007\u0005u\u0004\u0005C\u0004\u0002l\u0011\u0002\r!!\u001c\t\u000f\tuD\u00051\u0001\u0003\u0000!9!Q\u0011\u0013A\u0002\t]\u0013\u0001\u00069s_\u000e,7o\u001d)beRLG/[8o\t\u0006$\u0018\r\u0006\u0006\u0003\u0016\n=&\u0011\u0017B^\u0005\u007f\u0003R\u0001\u000eBL\u00057K1A!'6\u0005\u0019y\u0005\u000f^5p]B!!Q\u0014BV\u001b\t\u0011yJ\u0003\u0003\u0003\"\n\r\u0016a\u00017pO*!!Q\u0015BT\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0003\u0003*\u0006\u001d\u0012aB:u_J\fw-Z\u0005\u0005\u0005[\u0013yJA\u0007M_\u001e\f\u0005\u000f]3oI&sgm\u001c\u0005\b\u0003+,\u0003\u0019AA\u0010\u0011\u001d\u0011\u0019,\na\u0001\u0005k\u000b1BZ3uG\"|eMZ:fiB\u0019AGa.\n\u0007\teVG\u0001\u0003M_:<\u0007B\u0002B_K\u0001\u0007A/\u0001\u000bqCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000bB|7\r\u001b\u0005\b\u0005\u0003,\u0003\u0019\u0001Bb\u00035\u0001\u0018M\u001d;ji&|g\u000eR1uCB!!Q\u0019Bd\u001b\u0005\u0001\u0013\u0002\u0002Be\u0005s\u0012\u0011BR3uG\"$\u0015\r^1\u0002\u0011Q\u0014XO\\2bi\u0016$Ra\u0010Bh\u0005#Dq!!6'\u0001\u0004\ty\u0002C\u0004\u0003T\u001a\u0002\rA!6\u0002\u001fQ\u0014XO\\2bi&|gn\u0015;bi\u0016\u00042\u0001\u0010Bl\u0013\r\u0011I.\f\u0002\u0016\u001f\u001a47/\u001a;UeVt7-\u0019;j_:\u001cF/\u0019;f\u0003]!(/\u001e8dCR,g)\u001e7ms\u0006sGm\u0015;beR\fE\u000fF\u0003@\u0005?\u0014\t\u000fC\u0004\u0002V\u001e\u0002\r!a\b\t\u000f\t\rx\u00051\u0001\u00036\u00061qN\u001a4tKR\f1\u0002\\1uKN$X\t]8dQR!!\u0011\u001eBy!\u0019\tyIa\u000b\u0003lB!\u00111\u000bBw\u0013\u0011\u0011y/!\u0016\u0003\u000f%sG/Z4fe\"9\u0011Q\u001b\u0015A\u0002\u0005}\u0011A\u00047pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u000b\u0005\u0005k\u00139\u0010C\u0004\u0002V&\u0002\r!a\b\u0002\u00191|w-\u00128e\u001f\u001a47/\u001a;\u0015\t\tU&Q \u0005\b\u0003+T\u0003\u0019AA\u0010\u0003E)g\u000eZ(gMN,GOR8s\u000bB|7\r\u001b\u000b\u0007\u0007\u0007\u0019)aa\u0002\u0011\r\u0005=%1FAe\u0011\u001d\t)n\u000ba\u0001\u0003?Aaa!\u0003,\u0001\u0004!\u0018!B3q_\u000eD\u0007")
public class AbstractFetcherManagerTest {
    @BeforeEach
    public void cleanMetricRegistry() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    private Object getMetricValue(String name) {
        return ((Gauge)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$getMetricValue$1(name, x0$1)))).values().headOption().get()).value();
    }

    @Test
    public void testAddAndRemovePartition() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$1;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$1;
            }
            {
                this.fetcher$1 = fetcher$1;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        long fetchOffset = 10L;
        int leaderEpoch = 15;
        TopicPartition tp = new TopicPartition("topic", 0);
        Uuid topicId = Uuid.randomUuid();
        InitialFetchState initialFetchState = new InitialFetchState((Option)new Some((Object)topicId), new BrokerEndPoint(0, "localhost", 9092), leaderEpoch, fetchOffset);
        Mockito.when((Object)fetcher.leader()).thenReturn((Object)new MockLeaderEndPoint(this, new BrokerEndPoint(0, "localhost", 9092)));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Mockito.when((Object)fetcher.fetchState(tp)).thenReturn((Object)new Some((Object)new PartitionFetchState(Optional.of(topicId), fetchOffset, Optional.empty(), leaderEpoch, Optional.empty(), ReplicaState.TRUNCATING, Optional.empty()))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})))).thenReturn(Map$.MODULE$.empty());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})));
        Assertions.assertEquals((Object)new Some((Object)fetcher), (Object)fetcherManager.getFetcher(tp));
        fetcherManager.removeFetcherForPartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)fetcherManager.getFetcher(tp));
        ((Thread)Mockito.verify((Object)fetcher)).start();
    }

    @Test
    public void testMetricFailedPartitionCount() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$2;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$2;
            }
            {
                this.fetcher$2 = fetcher$2;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        String metricName = "FailedPartitionsCount";
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)this.getMetricValue(metricName));
        fetcherManager.failedPartitions().add(tp);
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)this.getMetricValue(metricName));
        fetcherManager.removeFetcherForPartitions((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)this.getMetricValue(metricName));
    }

    @Test
    public void testDeadThreadCountMetric() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$3;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$3;
            }
            {
                this.fetcher$3 = fetcher$3;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        long fetchOffset = 10L;
        int leaderEpoch = 15;
        TopicPartition tp = new TopicPartition("topic", 0);
        Uuid topicId = Uuid.randomUuid();
        InitialFetchState initialFetchState = new InitialFetchState((Option)new Some((Object)topicId), new BrokerEndPoint(0, "localhost", 9092), leaderEpoch, fetchOffset);
        Mockito.when((Object)fetcher.leader()).thenReturn((Object)new MockLeaderEndPoint(this, new BrokerEndPoint(0, "localhost", 9092)));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fetcher.isThreadFailed())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})));
        Assertions.assertEquals((int)1, (int)fetcherManager.deadThreadCount());
        ((Thread)Mockito.verify((Object)fetcher)).start();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fetcher.isThreadFailed())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Assertions.assertEquals((int)0, (int)fetcherManager.deadThreadCount());
    }

    @Test
    public void testMaybeUpdateTopicIds() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$4;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$4;
            }
            {
                this.fetcher$4 = fetcher$4;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        long fetchOffset = 10L;
        int leaderEpoch = 15;
        TopicPartition tp1 = new TopicPartition("topic1", 0);
        TopicPartition tp2 = new TopicPartition("topic2", 0);
        TopicPartition unknownTp = new TopicPartition("topic2", 1);
        Uuid topicId1 = Uuid.randomUuid();
        Uuid topicId2 = Uuid.randomUuid();
        InitialFetchState initialFetchState1 = new InitialFetchState((Option)None$.MODULE$, new BrokerEndPoint(0, "localhost", 9092), leaderEpoch, fetchOffset);
        InitialFetchState initialFetchState2 = new InitialFetchState((Option)None$.MODULE$, new BrokerEndPoint(1, "localhost", 9092), leaderEpoch, fetchOffset);
        Mockito.when((Object)fetcher.leader()).thenReturn((Object)new MockLeaderEndPoint(this, new BrokerEndPoint(0, "localhost", 9092)));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)initialFetchState1)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1})));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)initialFetchState2)})))).thenReturn(Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2})));
        Mockito.when((Object)fetcher.fetchState(tp1)).thenReturn((Object)new Some((Object)new PartitionFetchState(Optional.empty(), fetchOffset, Optional.empty(), leaderEpoch, Optional.empty(), ReplicaState.TRUNCATING, Optional.empty()))).thenReturn((Object)new Some((Object)new PartitionFetchState(Optional.of(topicId1), fetchOffset, Optional.empty(), leaderEpoch, Optional.empty(), ReplicaState.TRUNCATING, Optional.empty())));
        Mockito.when((Object)fetcher.fetchState(tp2)).thenReturn((Object)new Some((Object)new PartitionFetchState(Optional.empty(), fetchOffset, Optional.empty(), leaderEpoch, Optional.empty(), ReplicaState.TRUNCATING, Optional.empty()))).thenReturn((Object)new Some((Object)new PartitionFetchState(Optional.of(topicId2), fetchOffset, Optional.empty(), leaderEpoch, Optional.empty(), ReplicaState.TRUNCATING, Optional.empty())));
        Map topicIds = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1.topic()), (Object)new Some((Object)topicId1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2.topic()), (Object)new Some((Object)topicId2))}));
        Mockito.when((Object)fetcher.fetchState(unknownTp)).thenReturn((Object)None$.MODULE$);
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)initialFetchState1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)initialFetchState2)})));
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher.fetchState(tp1), (Option)None$.MODULE$);
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher.fetchState(tp2), (Option)None$.MODULE$);
        Map partitionsToUpdate = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)initialFetchState1.leader().id())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToInteger((int)initialFetchState2.leader().id()))}));
        fetcherManager.maybeUpdateTopicIds(partitionsToUpdate, (Function1)topicIds);
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher.fetchState(tp1), (Option)new Some((Object)topicId1));
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher.fetchState(tp2), (Option)new Some((Object)topicId2));
        Map invalidPartitionsToUpdate = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unknownTp), (Object)BoxesRunTime.boxToInteger((int)initialFetchState1.leader().id()))}));
        fetcherManager.maybeUpdateTopicIds(invalidPartitionsToUpdate, (Function1)topicIds);
        Assertions.assertTrue((boolean)fetcher.fetchState(unknownTp).isEmpty());
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownTp})), (Function1)topicIds);
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1})), (Function1)topicIds);
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2})), (Function1)topicIds);
    }

    @Test
    public void testExpandThreadPool() {
        this.testResizeThreadPool(10, 50, 6);
    }

    @Test
    public void testShrinkThreadPool() {
        this.testResizeThreadPool(50, 10, 6);
    }

    private void testResizeThreadPool(int currentFetcherSize, int newFetcherSize, int brokerNum) {
        Set<TopicPartition> fetchingTopicPartitions = this.makeTopicPartition(10, 100, "topic_");
        Set<TopicPartition> failedTopicPartitions = this.makeTopicPartition(2, 5, "topic_failed");
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(this, currentFetcherSize){
            private final /* synthetic */ AbstractFetcherManagerTest $outer;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.$outer.new TestResizeFetcherThread(sourceBroker, this.failedPartitions(), this.$outer.new MockResizeFetcherTierStateMachine());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super("fetcher-manager", "fetcher-manager", currentFetcherSize$1);
            }
        };
        try {
            fetcherManager.addFetcherForPartitions((Map)((IterableOnceOps)fetchingTopicPartitions.map((Function1 & Serializable)tp -> {
                int brokerId = this.getBrokerId((TopicPartition)tp, brokerNum);
                BrokerEndPoint brokerEndPoint = new BrokerEndPoint(brokerId, "kafka-host-" + brokerId, 9092);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)new InitialFetchState((Option)None$.MODULE$, brokerEndPoint, 0, 0L));
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            ((IterableOnceOps)fetchingTopicPartitions.take(20)).foreach(arg_0 -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$2$adapted((AbstractFetcherManager)fetcherManager, arg_0));
            failedTopicPartitions.foreach(arg_0 -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$3$adapted((AbstractFetcherManager)fetcherManager, arg_0));
            fetcherManager.resizeThreadPool(newFetcherSize);
            scala.collection.mutable.Set ownedPartitions = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.empty();
            fetcherManager.fetcherThreadMap().foreachEntry((arg_0, arg_1) -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$4$adapted(this, ownedPartitions, (AbstractFetcherManager)fetcherManager, brokerNum, arg_0, arg_1));
            Assertions.assertEquals(fetchingTopicPartitions, (Object)ownedPartitions);
            Assertions.assertEquals(failedTopicPartitions, (Object)fetcherManager.failedPartitions().partitions());
        }
        finally {
            fetcherManager.closeAllFetchers();
        }
    }

    private int testResizeThreadPool$default$3() {
        return 6;
    }

    private Set<TopicPartition> makeTopicPartition(int topicNum, int partitionNum, String topicPrefix) {
        scala.collection.mutable.Set res = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), topicNum - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            String topic = topicPrefix + i;
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), partitionNum - 1).foreach((Function1 & Serializable)j -> AbstractFetcherManagerTest.$anonfun$makeTopicPartition$2(res, topic, BoxesRunTime.unboxToInt((Object)j)));
        });
        return res.toSet();
    }

    private String makeTopicPartition$default$3() {
        return "topic_";
    }

    private int getBrokerId(TopicPartition tp, int brokerNum) {
        return Utils.abs((int)tp.hashCode()) % brokerNum;
    }

    public static final /* synthetic */ boolean $anonfun$getMetricValue$1(String name$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String string = ((MetricName)x0$1._1()).getName();
            return !(string != null ? !string.equals(name$1) : name$1 != null);
        }
        throw new MatchError(null);
    }

    private static final void verifyFetchState$1(Option fetchState, Option expectedTopicId) {
        Assertions.assertTrue((boolean)fetchState.isDefined());
        Assertions.assertEquals((Object)expectedTopicId, (Object)OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(((PartitionFetchState)fetchState.get()).topicId())));
    }

    public static final /* synthetic */ void $anonfun$testResizeThreadPool$5(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int fetcherId$1, int brokerNum$1, int brokerId$1, TopicPartition tp) {
        ownedPartitions$1.$plus$eq((Object)tp);
        Assertions.assertEquals((int)fetcherManager$1.getFetcherId(tp), (int)fetcherId$1);
        Assertions.assertEquals((int)$this.getBrokerId(tp, brokerNum$1), (int)brokerId$1);
    }

    public static final /* synthetic */ void $anonfun$testResizeThreadPool$4(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int brokerNum$1, BrokerIdAndFetcherId brokerIdAndFetcherId, AbstractFetcherThread fetcherThread) {
        int fetcherId = brokerIdAndFetcherId.fetcherId();
        int brokerId = brokerIdAndFetcherId.brokerId();
        fetcherThread.partitions().foreach((Function1 & Serializable)tp -> {
            AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$5($this, ownedPartitions$1, fetcherManager$1, fetcherId, brokerNum$1, brokerId, tp);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ scala.collection.mutable.Set $anonfun$makeTopicPartition$2(scala.collection.mutable.Set res$1, String topic$1, int j) {
        return (scala.collection.mutable.Set)res$1.$plus$eq((Object)new TopicPartition(topic$1, j));
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$2$adapted(AbstractFetcherManager fetcherManager$1, TopicPartition topicPartition) {
        fetcherManager$1.addFailedPartition(topicPartition);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$3$adapted(AbstractFetcherManager fetcherManager$1, TopicPartition topicPartition) {
        fetcherManager$1.addFailedPartition(topicPartition);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$4$adapted(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int brokerNum$1, BrokerIdAndFetcherId brokerIdAndFetcherId, AbstractFetcherThread fetcherThread) {
        AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$4($this, ownedPartitions$1, fetcherManager$1, brokerNum$1, brokerIdAndFetcherId, fetcherThread);
        return BoxedUnit.UNIT;
    }

    private class MockLeaderEndPoint
    implements LeaderEndPoint {
        private final BrokerEndPoint sourceBroker;
        private final boolean isTruncationOnFetchSupported;
        public final /* synthetic */ AbstractFetcherManagerTest $outer;

        public void initiateClose() {
        }

        public void close() {
        }

        public BrokerEndPoint brokerEndPoint() {
            return this.sourceBroker;
        }

        public java.util.Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
            return java.util.Map.of();
        }

        public OffsetAndEpoch fetchEarliestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
            return new OffsetAndEpoch(1L, 0);
        }

        public OffsetAndEpoch fetchLatestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
            return new OffsetAndEpoch(1L, 0);
        }

        public java.util.Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(java.util.Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
            return java.util.Map.of();
        }

        public ResultWithPartitions<Optional<ReplicaFetch>> buildFetch(java.util.Map<TopicPartition, PartitionFetchState> partitions) {
            return new ResultWithPartitions(Optional.empty(), java.util.Set.of());
        }

        public boolean isTruncationOnFetchSupported() {
            return this.isTruncationOnFetchSupported;
        }

        public OffsetAndEpoch fetchEarliestLocalOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
            return new OffsetAndEpoch(1L, 0);
        }

        public /* synthetic */ AbstractFetcherManagerTest kafka$server$AbstractFetcherManagerTest$MockLeaderEndPoint$$$outer() {
            return this.$outer;
        }

        public MockLeaderEndPoint(AbstractFetcherManagerTest $outer, BrokerEndPoint sourceBroker) {
            this.sourceBroker = sourceBroker;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.isTruncationOnFetchSupported = false;
        }
    }

    private class MockResizeFetcherTierStateMachine
    extends TierStateMachine {
        public PartitionFetchState start(TopicPartition topicPartition, PartitionFetchState currentFetchState, FetchResponseData.PartitionData fetchPartitionData) {
            throw new UnsupportedOperationException("Materializing tier state is not supported in this test.");
        }

        public /* synthetic */ AbstractFetcherManagerTest kafka$server$AbstractFetcherManagerTest$MockResizeFetcherTierStateMachine$$$outer() {
            return AbstractFetcherManagerTest.this;
        }

        public MockResizeFetcherTierStateMachine() {
            if (AbstractFetcherManagerTest.this == null) {
                throw null;
            }
            super(null, null, false);
        }
    }

    private class TestResizeFetcherThread
    extends AbstractFetcherThread {
        public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, int partitionLeaderEpoch, FetchResponseData.PartitionData partitionData) {
            return None$.MODULE$;
        }

        public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        }

        public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        }

        public Optional<Integer> latestEpoch(TopicPartition topicPartition) {
            return Optional.of(Predef$.MODULE$.int2Integer(0));
        }

        public long logStartOffset(TopicPartition topicPartition) {
            return 1L;
        }

        public long logEndOffset(TopicPartition topicPartition) {
            return 1L;
        }

        public Optional<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
            return Optional.of(new OffsetAndEpoch(1L, 0));
        }

        public /* synthetic */ AbstractFetcherManagerTest kafka$server$AbstractFetcherManagerTest$TestResizeFetcherThread$$$outer() {
            return AbstractFetcherManagerTest.this;
        }

        public TestResizeFetcherThread(BrokerEndPoint sourceBroker, FailedPartitions failedPartitions, TierStateMachine fetchTierStateMachine) {
            if (AbstractFetcherManagerTest.this == null) {
                throw null;
            }
            MockLeaderEndPoint x$3 = new MockLeaderEndPoint(AbstractFetcherManagerTest.this, sourceBroker);
            BrokerTopicStats x$7 = new BrokerTopicStats();
            boolean x$8 = true;
            super("test-resize-fetcher", "mock-fetcher", (LeaderEndPoint)x$3, failedPartitions, fetchTierStateMachine, 0, x$8, x$7);
        }
    }
}

