/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;
import kafka.network.RequestChannel;
import kafka.server.AuthHelper;
import kafka.server.AuthHelperTest$;
import org.apache.kafka.clients.admin.EndpointType;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.internals.Plugin;
import org.apache.kafka.common.message.DescribeClusterRequestData;
import org.apache.kafka.common.message.DescribeClusterResponseData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.SetOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005Q<Q\u0001E\t\t\u0002Y1Q\u0001G\t\t\u0002eAQ\u0001I\u0001\u0005\u0002\u0005BQAI\u0001\u0005\u0002\r2A\u0001G\t\u0001\u0011\")\u0001\u0005\u0002C\u0001\u0013\"91\n\u0002b\u0001\n\u0013a\u0005BB+\u0005A\u0003%Q\nC\u0003W\t\u0011\u0005q\u000bC\u0003g\t\u0011\u0005q\u000bC\u0003i\t\u0011\u0005q\u000bC\u0003k\t\u0011\u0005q\u000bC\u0003m\t\u0011\u0005q\u000bC\u0003o\t\u0011\u0005q\u000bC\u0003q\t\u0011\u0005q\u000bC\u0003s\t\u0011\u0005q+\u0001\bBkRD\u0007*\u001a7qKJ$Vm\u001d;\u000b\u0005I\u0019\u0012AB:feZ,'OC\u0001\u0015\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"aF\u0001\u000e\u0003E\u0011a\"Q;uQ\"+G\u000e]3s)\u0016\u001cHo\u0005\u0002\u00025A\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\f\u0002;9,w/T8dW\u0012+7o\u0019:jE\u0016\u001cE.^:uKJ\u0014V-];fgR$2\u0001\n\u001bD!\t)\u0013G\u0004\u0002']9\u0011q\u0005\f\b\u0003Q-j\u0011!\u000b\u0006\u0003UU\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000b\n\u00055\u001a\u0012a\u00028fi^|'o[\u0005\u0003_A\naBU3rk\u0016\u001cHo\u00115b]:,GN\u0003\u0002.'%\u0011!g\r\u0002\b%\u0016\fX/Z:u\u0015\ty\u0003\u0007C\u00036\u0007\u0001\u0007a'\u0001\u0003eCR\f\u0007CA\u001cB\u001b\u0005A$BA\u001d;\u0003\u001diWm]:bO\u0016T!a\u000f\u001f\u0002\r\r|W.\\8o\u0015\t!RH\u0003\u0002?\u007f\u00051\u0011\r]1dQ\u0016T\u0011\u0001Q\u0001\u0004_J<\u0017B\u0001\"9\u0005i!Um]2sS\n,7\t\\;ti\u0016\u0014(+Z9vKN$H)\u0019;b\u0011\u0015!5\u00011\u0001F\u00039\u0011X-];fgR4VM]:j_:\u0004\"a\u0007$\n\u0005\u001dc\"aA%oiN\u0011AA\u0007\u000b\u0002\u0015B\u0011q\u0003B\u0001\tG2LWM\u001c;JIV\tQ\n\u0005\u0002O'6\tqJ\u0003\u0002Q#\u0006!A.\u00198h\u0015\u0005\u0011\u0016\u0001\u00026bm\u0006L!\u0001V(\u0003\rM#(/\u001b8h\u0003%\u0019G.[3oi&#\u0007%A\u0007uKN$\u0018)\u001e;i_JL'0\u001a\u000b\u00021B\u00111$W\u0005\u00035r\u0011A!\u00168ji\"\u0012\u0001\u0002\u0018\t\u0003;\u0012l\u0011A\u0018\u0006\u0003?\u0002\f1!\u00199j\u0015\t\t'-A\u0004kkBLG/\u001a:\u000b\u0005\r|\u0014!\u00026v]&$\u0018BA3_\u0005\u0011!Vm\u001d;\u0002-Q,7\u000f\u001e$jYR,'OQ=BkRDwN]5{K\u0012D#!\u0003/\u0002wQ,7\u000f^\"p[B,H/\u001a#fg\u000e\u0014\u0018NY3DYV\u001cH/\u001a:SKN\u0004xN\\:f-F:\u0016\u000e\u001e5V].twn\u001e8F]\u0012\u0004x.\u001b8u)f\u0004X\r\u000b\u0002\u000b9\u0006YD/Z:u\u0007>l\u0007/\u001e;f\t\u0016\u001c8M]5cK\u000ecWo\u001d;feJ+7\u000f]8og\u00164\u0006gV5uQVs7N\\8x]\u0016sG\r]8j]R$\u0016\u0010]3)\u0005-a\u0016A\u0010;fgR\u001cu.\u001c9vi\u0016$Um]2sS\n,7\t\\;ti\u0016\u0014(+Z:q_:\u001cXMV\u0019XSRDWK\\3ya\u0016\u001cG/\u001a3F]\u0012\u0004x.\u001b8u)f\u0004X\r\u000b\u0002\r9\u0006qD/Z:u\u0007>l\u0007/\u001e;f\t\u0016\u001c8M]5cK\u000ecWo\u001d;feJ+7\u000f]8og\u00164\u0006gV5uQVsW\r\u001f9fGR,G-\u00128ea>Lg\u000e\u001e+za\u0016D#!\u0004/\u0002wQ,7\u000f^\"p[B,H/\u001a#fg\u000e\u0014\u0018NY3DYV\u001cH/\u001a:SKN\u0004xN\\:f/\",'/Z\"p]R\u0014x\u000e\u001c7fe&\u001bhj\u001c;G_VtG\r\u000b\u0002\u000f9\u0006IC/Z:u\u0007>l\u0007/\u001e;f\t\u0016\u001c8M]5cK\u000ecWo\u001d;feJ+7\u000f]8og\u0016\u001cVoY2fgND#a\u0004/")
public class AuthHelperTest {
    private final String clientId;

    public static RequestChannel.Request newMockDescribeClusterRequest(DescribeClusterRequestData data, int requestVersion) {
        return AuthHelperTest$.MODULE$.newMockDescribeClusterRequest(data, requestVersion);
    }

    private String clientId() {
        return this.clientId;
    }

    @Test
    public void testAuthorize() {
        Authorizer authorizer = (Authorizer)Mockito.mock(Authorizer.class);
        Plugin authorizerPlugin = Plugin.wrapInstance((Object)authorizer, null, (String)"authorizer.class.name");
        AclOperation operation = AclOperation.WRITE;
        ResourceType resourceType = ResourceType.TOPIC;
        String resourceName = "topic-1";
        RequestHeader requestHeader = new RequestHeader(ApiKeys.PRODUCE, ApiKeys.PRODUCE.latestVersion(), this.clientId(), 0);
        RequestContext requestContext = new RequestContext(requestHeader, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, false);
        .colon.colon expectedActions = new .colon.colon((Object)new Action(operation, new ResourcePattern(resourceType, resourceName, PatternType.LITERAL), 1, true, true), (List)Nil$.MODULE$);
        Mockito.when((Object)authorizer.authorize((AuthorizableRequestContext)requestContext, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)expectedActions).asJava())).thenReturn((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)AuthorizationResult.ALLOWED, (List)Nil$.MODULE$)).asJava());
        AuthHelper qual$1 = new AuthHelper((Option)new Some((Object)authorizerPlugin));
        boolean x$5 = qual$1.authorize$default$5();
        boolean x$6 = qual$1.authorize$default$6();
        int x$7 = qual$1.authorize$default$7();
        boolean result = qual$1.authorize(requestContext, operation, resourceType, resourceName, x$5, x$6, x$7);
        ((Authorizer)Mockito.verify((Object)authorizer)).authorize((AuthorizableRequestContext)requestContext, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)expectedActions).asJava());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)result));
    }

    @Test
    public void testFilterByAuthorized() {
        Authorizer authorizer = (Authorizer)Mockito.mock(Authorizer.class);
        Plugin authorizerPlugin = Plugin.wrapInstance((Object)authorizer, null, (String)"authorizer.class.name");
        AclOperation operation = AclOperation.WRITE;
        ResourceType resourceType = ResourceType.TOPIC;
        String resourceName1 = "topic-1";
        String resourceName2 = "topic-2";
        String resourceName3 = "topic-3";
        RequestHeader requestHeader = new RequestHeader(ApiKeys.PRODUCE, ApiKeys.PRODUCE.latestVersion(), this.clientId(), 0);
        RequestContext requestContext = new RequestContext(requestHeader, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, false);
        .colon.colon expectedActions = new .colon.colon((Object)new Action(operation, new ResourcePattern(resourceType, resourceName1, PatternType.LITERAL), 2, true, true), (List)new .colon.colon((Object)new Action(operation, new ResourcePattern(resourceType, resourceName2, PatternType.LITERAL), 1, true, true), (List)new .colon.colon((Object)new Action(operation, new ResourcePattern(resourceType, resourceName3, PatternType.LITERAL), 1, true, true), (List)Nil$.MODULE$)));
        Mockito.when((Object)authorizer.authorize((AuthorizableRequestContext)ArgumentMatchers.eq((Object)requestContext), (java.util.List)ArgumentMatchers.argThat(arg_0 -> AuthHelperTest.$anonfun$testFilterByAuthorized$1((Seq)expectedActions, arg_0)))).thenAnswer(invocation -> {
            Buffer actions = CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)invocation.getArgument(1)).asScala();
            return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)actions.map((Function1 & Serializable)action -> {
                if (((SetOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{resourceName1, resourceName3}))).contains((Object)action.resourcePattern().name())) {
                    return AuthorizationResult.ALLOWED;
                }
                return AuthorizationResult.DENIED;
            })).asJava();
        });
        AuthHelper qual$1 = new AuthHelper((Option)new Some((Object)authorizerPlugin));
        .colon.colon x$4 = new .colon.colon((Object)resourceName1, (List)new .colon.colon((Object)resourceName2, (List)new .colon.colon((Object)resourceName1, (List)new .colon.colon((Object)resourceName3, (List)Nil$.MODULE$))));
        boolean x$5 = qual$1.filterByAuthorized$default$5();
        boolean x$6 = qual$1.filterByAuthorized$default$6();
        Function1 & Serializable x$7 = (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x);
        Set result = qual$1.filterByAuthorized(requestContext, operation, resourceType, (Iterable)x$4, x$5, x$6, (Function1)x$7);
        ((Authorizer)Mockito.verify((Object)authorizer)).authorize((AuthorizableRequestContext)ArgumentMatchers.eq((Object)requestContext), (java.util.List)ArgumentMatchers.argThat(arg_0 -> AuthHelperTest.$anonfun$testFilterByAuthorized$5((Seq)expectedActions, arg_0)));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{resourceName1, resourceName3})), (Object)result);
    }

    @Test
    public void testComputeDescribeClusterResponseV1WithUnknownEndpointType() {
        Plugin authorizerPlugin = Plugin.wrapInstance((Object)((Authorizer)Mockito.mock(Authorizer.class)), null, (String)"authorizer.class.name");
        AuthHelper authHelper = new AuthHelper((Option)new Some((Object)authorizerPlugin));
        RequestChannel.Request request = AuthHelperTest$.MODULE$.newMockDescribeClusterRequest(new DescribeClusterRequestData().setEndpointType((byte)123), 1);
        DescribeClusterResponseData responseData = authHelper.computeDescribeClusterResponse(request, EndpointType.BROKER, "ltCWoi9wRhmHSQCIgAznEg", (Function0 & Serializable)() -> new DescribeClusterResponseData.DescribeClusterBrokerCollection(), (Function0)(JFunction0.mcI.sp & Serializable)() -> 1);
        Assertions.assertEquals((Object)new DescribeClusterResponseData().setErrorCode(Errors.UNSUPPORTED_ENDPOINT_TYPE.code()).setErrorMessage("Unsupported endpoint type 123"), (Object)responseData);
    }

    @Test
    public void testComputeDescribeClusterResponseV0WithUnknownEndpointType() {
        Plugin authorizerPlugin = Plugin.wrapInstance((Object)((Authorizer)Mockito.mock(Authorizer.class)), null, (String)"authorizer.class.name");
        AuthHelper authHelper = new AuthHelper((Option)new Some((Object)authorizerPlugin));
        RequestChannel.Request request = AuthHelperTest$.MODULE$.newMockDescribeClusterRequest(new DescribeClusterRequestData().setEndpointType((byte)123), 0);
        DescribeClusterResponseData responseData = authHelper.computeDescribeClusterResponse(request, EndpointType.BROKER, "ltCWoi9wRhmHSQCIgAznEg", (Function0 & Serializable)() -> new DescribeClusterResponseData.DescribeClusterBrokerCollection(), (Function0)(JFunction0.mcI.sp & Serializable)() -> 1);
        Assertions.assertEquals((Object)new DescribeClusterResponseData().setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Unsupported endpoint type 123"), (Object)responseData);
    }

    @Test
    public void testComputeDescribeClusterResponseV1WithUnexpectedEndpointType() {
        Plugin authorizerPlugin = Plugin.wrapInstance((Object)((Authorizer)Mockito.mock(Authorizer.class)), null, (String)"authorizer.class.name");
        AuthHelper authHelper = new AuthHelper((Option)new Some((Object)authorizerPlugin));
        RequestChannel.Request request = AuthHelperTest$.MODULE$.newMockDescribeClusterRequest(new DescribeClusterRequestData().setEndpointType(EndpointType.BROKER.id()), 1);
        DescribeClusterResponseData responseData = authHelper.computeDescribeClusterResponse(request, EndpointType.CONTROLLER, "ltCWoi9wRhmHSQCIgAznEg", (Function0 & Serializable)() -> new DescribeClusterResponseData.DescribeClusterBrokerCollection(), (Function0)(JFunction0.mcI.sp & Serializable)() -> 1);
        Assertions.assertEquals((Object)new DescribeClusterResponseData().setErrorCode(Errors.MISMATCHED_ENDPOINT_TYPE.code()).setErrorMessage("The request was sent to an endpoint of type CONTROLLER, but we wanted an endpoint of type BROKER"), (Object)responseData);
    }

    @Test
    public void testComputeDescribeClusterResponseV0WithUnexpectedEndpointType() {
        Plugin authorizerPlugin = Plugin.wrapInstance((Object)((Authorizer)Mockito.mock(Authorizer.class)), null, (String)"authorizer.class.name");
        AuthHelper authHelper = new AuthHelper((Option)new Some((Object)authorizerPlugin));
        RequestChannel.Request request = AuthHelperTest$.MODULE$.newMockDescribeClusterRequest(new DescribeClusterRequestData().setEndpointType(EndpointType.BROKER.id()), 0);
        DescribeClusterResponseData responseData = authHelper.computeDescribeClusterResponse(request, EndpointType.CONTROLLER, "ltCWoi9wRhmHSQCIgAznEg", (Function0 & Serializable)() -> new DescribeClusterResponseData.DescribeClusterBrokerCollection(), (Function0)(JFunction0.mcI.sp & Serializable)() -> 1);
        Assertions.assertEquals((Object)new DescribeClusterResponseData().setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("The request was sent to an endpoint of type CONTROLLER, but we wanted an endpoint of type BROKER"), (Object)responseData);
    }

    @Test
    public void testComputeDescribeClusterResponseWhereControllerIsNotFound() {
        Plugin authorizerPlugin = Plugin.wrapInstance((Object)((Authorizer)Mockito.mock(Authorizer.class)), null, (String)"authorizer.class.name");
        AuthHelper authHelper = new AuthHelper((Option)new Some((Object)authorizerPlugin));
        RequestChannel.Request request = AuthHelperTest$.MODULE$.newMockDescribeClusterRequest(new DescribeClusterRequestData().setEndpointType(EndpointType.CONTROLLER.id()), 1);
        DescribeClusterResponseData responseData = authHelper.computeDescribeClusterResponse(request, EndpointType.CONTROLLER, "ltCWoi9wRhmHSQCIgAznEg", (Function0 & Serializable)() -> new DescribeClusterResponseData.DescribeClusterBrokerCollection(), (Function0)(JFunction0.mcI.sp & Serializable)() -> 1);
        Assertions.assertEquals((Object)new DescribeClusterResponseData().setClusterId("ltCWoi9wRhmHSQCIgAznEg").setControllerId(-1).setClusterAuthorizedOperations(Integer.MIN_VALUE).setEndpointType((byte)2), (Object)responseData);
    }

    @Test
    public void testComputeDescribeClusterResponseSuccess() {
        Plugin authorizerPlugin = Plugin.wrapInstance((Object)((Authorizer)Mockito.mock(Authorizer.class)), null, (String)"authorizer.class.name");
        AuthHelper authHelper = new AuthHelper((Option)new Some((Object)authorizerPlugin));
        RequestChannel.Request request = AuthHelperTest$.MODULE$.newMockDescribeClusterRequest(new DescribeClusterRequestData().setEndpointType(EndpointType.CONTROLLER.id()), 1);
        DescribeClusterResponseData.DescribeClusterBrokerCollection nodes = new DescribeClusterResponseData.DescribeClusterBrokerCollection(Arrays.asList(new DescribeClusterResponseData.DescribeClusterBroker().setBrokerId(1)).iterator());
        DescribeClusterResponseData responseData = authHelper.computeDescribeClusterResponse(request, EndpointType.CONTROLLER, "ltCWoi9wRhmHSQCIgAznEg", (Function0 & Serializable)() -> nodes, (Function0)(JFunction0.mcI.sp & Serializable)() -> 1);
        Assertions.assertEquals((Object)new DescribeClusterResponseData().setClusterId("ltCWoi9wRhmHSQCIgAznEg").setControllerId(1).setClusterAuthorizedOperations(Integer.MIN_VALUE).setBrokers(nodes).setEndpointType((byte)2), (Object)responseData);
    }

    public static final /* synthetic */ boolean $anonfun$testFilterByAuthorized$1(Seq expectedActions$1, java.util.List t) {
        return t.containsAll(CollectionConverters$.MODULE$.SeqHasAsJava(expectedActions$1).asJava());
    }

    public static final /* synthetic */ boolean $anonfun$testFilterByAuthorized$5(Seq expectedActions$1, java.util.List t) {
        return t.containsAll(CollectionConverters$.MODULE$.SeqHasAsJava(expectedActions$1).asJava());
    }

    public AuthHelperTest() {
        this.clientId = "";
    }
}

