/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.server.AutoTopicCreationManager;
import kafka.server.ControllerMutationQuota;
import kafka.server.DefaultAutoTopicCreationManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.UnboundedControllerMutationQuota$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.coordinator.share.ShareCoordinator;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.server.common.ControllerRequestCompletionHandler;
import org.apache.kafka.server.common.NodeToControllerChannelManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\u0015d\u0001\u0002\u0017.\u0001IBQ!\u000f\u0001\u0005\u0002iBq!\u0010\u0001C\u0002\u0013%a\b\u0003\u0004C\u0001\u0001\u0006Ia\u0010\u0005\n\u0007\u0002\u0001\r\u00111A\u0005\n\u0011C\u0011\u0002\u0013\u0001A\u0002\u0003\u0007I\u0011B%\t\u0013=\u0003\u0001\u0019!A!B\u0013)\u0005b\u0002)\u0001\u0005\u0004%I!\u0015\u0005\u0007;\u0002\u0001\u000b\u0011\u0002*\t\u000fy\u0003!\u0019!C\u0005?\"1q\r\u0001Q\u0001\n\u0001Dq\u0001\u001b\u0001C\u0002\u0013%\u0011\u000e\u0003\u0004s\u0001\u0001\u0006IA\u001b\u0005\bg\u0002\u0011\r\u0011\"\u0003u\u0011\u0019a\b\u0001)A\u0005k\"9Q\u0010\u0001b\u0001\n\u0013q\bbBA\u0006\u0001\u0001\u0006Ia \u0005\f\u0003\u001b\u0001\u0001\u0019!a\u0001\n\u0013\ty\u0001C\u0006\u0002\u0018\u0001\u0001\r\u00111A\u0005\n\u0005e\u0001bCA\u000f\u0001\u0001\u0007\t\u0011)Q\u0005\u0003#A\u0001\"a\b\u0001\u0005\u0004%IA\u0010\u0005\b\u0003C\u0001\u0001\u0015!\u0003@\u0011%\t\u0019\u0003\u0001b\u0001\n\u0013\t)\u0003\u0003\u0005\u0002.\u0001\u0001\u000b\u0011BA\u0014\u0011\u001d\ty\u0003\u0001C\u0001\u0003cAq!!\u0013\u0001\t\u0003\t\t\u0004C\u0004\u0002T\u0001!\t!!\r\t\u000f\u0005]\u0003\u0001\"\u0001\u00022!9\u00111\f\u0001\u0005\u0002\u0005E\u0002bBA0\u0001\u0011%\u0011\u0011\r\u0005\n\u0003\u001f\u0003\u0011\u0013!C\u0005\u0003#C\u0011\"a*\u0001#\u0003%I!!+\t\u000f\u00055\u0006\u0001\"\u0001\u00022!9\u0011\u0011\u0017\u0001\u0005\u0002\u0005E\u0002bBA[\u0001\u0011\u0005\u0011\u0011\u0007\u0005\b\u0003s\u0003A\u0011AA\u0019\u0011\u001d\ti\f\u0001C\u0001\u0003cAq!!1\u0001\t\u0003\t\t\u0004C\u0004\u0002F\u0002!\t!!\r\t\u000f\u0005%\u0007\u0001\"\u0003\u0002L\"9\u00111\u001c\u0001\u0005\n\u0005u\u0007b\u0002B\u0007\u0001\u0011%!q\u0002\u0005\n\u0005_\u0001\u0011\u0013!C\u0005\u0005cAqA!\u000e\u0001\t\u0013\u00119D\u0001\u000fBkR|Gk\u001c9jG\u000e\u0013X-\u0019;j_:l\u0015M\\1hKJ$Vm\u001d;\u000b\u00059z\u0013AB:feZ,'OC\u00011\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u001a\u0011\u0005Q:T\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1\b\u0005\u0002=\u00015\tQ&\u0001\bsKF,Xm\u001d;US6,w.\u001e;\u0016\u0003}\u0002\"\u0001\u000e!\n\u0005\u0005+$aA%oi\u0006y!/Z9vKN$H+[7f_V$\b%\u0001\u0004d_:4\u0017nZ\u000b\u0002\u000bB\u0011AHR\u0005\u0003\u000f6\u00121bS1gW\u0006\u001cuN\u001c4jO\u0006Q1m\u001c8gS\u001e|F%Z9\u0015\u0005)k\u0005C\u0001\u001bL\u0013\taUG\u0001\u0003V]&$\bb\u0002(\u0006\u0003\u0003\u0005\r!R\u0001\u0004q\u0012\n\u0014aB2p]\u001aLw\rI\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0003I\u0003\"aU.\u000e\u0003QS!!\u0016,\u0002\u00115,G/\u00193bi\u0006T!\u0001M,\u000b\u0005aK\u0016AB1qC\u000eDWMC\u0001[\u0003\ry'oZ\u0005\u00039R\u0013Q\"T3uC\u0012\fG/Y\"bG\",\u0017AD7fi\u0006$\u0017\r^1DC\u000eDW\rI\u0001\u0013EJ|7.\u001a:U_\u000e{g\u000e\u001e:pY2,'/F\u0001a!\t\tW-D\u0001c\u0015\t\u0019G-\u0001\u0004d_6lwN\u001c\u0006\u0003]YK!A\u001a2\u0003=9{G-\u001a+p\u0007>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\u0018a\u00052s_.,'\u000fV8D_:$(o\u001c7mKJ\u0004\u0013\u0001E4s_V\u00048i\\8sI&t\u0017\r^8s+\u0005Q\u0007CA6q\u001b\u0005a'BA7o\u0003\u00159'o\\;q\u0015\tyg+A\u0006d_>\u0014H-\u001b8bi>\u0014\u0018BA9m\u0005A9%o\\;q\u0007>|'\u000fZ5oCR|'/A\the>,\boQ8pe\u0012Lg.\u0019;pe\u0002\na\u0003\u001e:b]N\f7\r^5p]\u000e{wN\u001d3j]\u0006$xN]\u000b\u0002kB\u0011aO_\u0007\u0002o*\u0011\u00010_\u0001\fiJ\fgn]1di&|gN\u0003\u0002p_%\u00111p\u001e\u0002\u0017)J\fgn]1di&|gnQ8pe\u0012Lg.\u0019;pe\u00069BO]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'\u000fI\u0001\u0011g\"\f'/Z\"p_J$\u0017N\\1u_J,\u0012a \t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011Q\u00018\u0002\u000bMD\u0017M]3\n\t\u0005%\u00111\u0001\u0002\u0011'\"\f'/Z\"p_J$\u0017N\\1u_J\f\u0011c\u001d5be\u0016\u001cun\u001c:eS:\fGo\u001c:!\u0003a\tW\u000f^8U_BL7m\u0011:fCRLwN\\'b]\u0006<WM]\u000b\u0003\u0003#\u00012\u0001PA\n\u0013\r\t)\"\f\u0002\u0019\u0003V$x\u000eV8qS\u000e\u001c%/Z1uS>tW*\u00198bO\u0016\u0014\u0018\u0001H1vi>$v\u000e]5d\u0007J,\u0017\r^5p]6\u000bg.Y4fe~#S-\u001d\u000b\u0004\u0015\u0006m\u0001\u0002\u0003(\u0013\u0003\u0003\u0005\r!!\u0005\u00023\u0005,Ho\u001c+pa&\u001c7I]3bi&|g.T1oC\u001e,'\u000fI\u0001\u0018S:$XM\u001d8bYR{\u0007/[2QCJ$\u0018\u000e^5p]N\f\u0001$\u001b8uKJt\u0017\r\u001c+pa&\u001c\u0007+\u0019:uSRLwN\\:!\u0003yIg\u000e^3s]\u0006dGk\u001c9jGJ+\u0007\u000f\\5dCRLwN\u001c$bGR|'/\u0006\u0002\u0002(A\u0019A'!\u000b\n\u0007\u0005-RGA\u0003TQ>\u0014H/A\u0010j]R,'O\\1m)>\u0004\u0018n\u0019*fa2L7-\u0019;j_:4\u0015m\u0019;pe\u0002\nQa]3ukB$\u0012A\u0013\u0015\u00041\u0005U\u0002\u0003BA\u001c\u0003\u000bj!!!\u000f\u000b\t\u0005m\u0012QH\u0001\u0004CBL'\u0002BA \u0003\u0003\nqA[;qSR,'OC\u0002\u0002De\u000bQA[;oSRLA!a\u0012\u0002:\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002+Q,7\u000f^\"sK\u0006$Xm\u00144gg\u0016$Hk\u001c9jG\"\u001a\u0011$!\u0014\u0011\t\u0005]\u0012qJ\u0005\u0005\u0003#\nID\u0001\u0003UKN$\u0018A\u0005;fgR\u001c%/Z1uKRCh\u000eV8qS\u000eD3AGA'\u0003e!Xm\u001d;De\u0016\fG/Z*iCJ,7\u000b^1uKR{\u0007/[2)\u0007m\ti%\u0001\u000euKN$8I]3bi\u0016tuN\\%oi\u0016\u0014h.\u00197U_BL7\rK\u0002\u001d\u0003\u001b\nq\u0002^3ti\u000e\u0013X-\u0019;f)>\u0004\u0018n\u0019\u000b\n\u0015\u0006\r\u0014QPAD\u0003\u0017Cq!!\u001a\u001e\u0001\u0004\t9'A\u0005u_BL7MT1nKB!\u0011\u0011NA<\u001d\u0011\tY'a\u001d\u0011\u0007\u00055T'\u0004\u0002\u0002p)\u0019\u0011\u0011O\u0019\u0002\rq\u0012xn\u001c;?\u0013\r\t)(N\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00141\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005UT\u0007C\u0004\u0002\u0000u\u0001\r!!!\u0002\u0015%\u001c\u0018J\u001c;fe:\fG\u000eE\u00025\u0003\u0007K1!!\"6\u0005\u001d\u0011un\u001c7fC:D\u0001\"!#\u001e!\u0003\u0005\raP\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\t\u0013\u00055U\u0004%AA\u0002\u0005\u001d\u0012!\u0005:fa2L7-\u0019;j_:4\u0015m\u0019;pe\u0006IB/Z:u\u0007J,\u0017\r^3U_BL7\r\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019JK\u0002@\u0003+[#!a&\u0011\t\u0005e\u00151U\u0007\u0003\u00037SA!!(\u0002 \u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003C+\u0014AC1o]>$\u0018\r^5p]&!\u0011QUAN\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001ai\u0016\u001cHo\u0011:fCR,Gk\u001c9jG\u0012\"WMZ1vYR$C'\u0006\u0002\u0002,*\"\u0011qEAK\u0003E\"Xm\u001d;U_BL7m\u0011:fCRLwN\\,ji\"lU\r^1eCR\f7i\u001c8uKb$\b+Y:t!JLgnY5qC2D3\u0001IA'\u0003\u0001#Xm\u001d;U_BL7m\u0011:fCRLwN\\,ji\"lU\r^1eCR\f7i\u001c8uKb$x\u000b[3o!JLgnY5qC2\u001cVM\u001d3f\u001d>$H)\u001a4j]\u0016$\u0007fA\u0011\u0002N\u0005\tE/Z:u)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8XSRDW*\u001a;bI\u0006$\u0018mQ8oi\u0016DHOT8SKR\u0014\u00180\u00169p]Vs7/\u001e9q_J$X\r\u001a,feNLwN\u001c\u0015\u0004E\u00055\u0013a\b;fgR\u001c%/Z1uKN#(/Z1ng&sG/\u001a:oC2$v\u000e]5dg\"\u001a1%!\u0014\u0002]Q,7\u000f^\"sK\u0006$Xm\u0015;sK\u0006l7/\u00138uKJt\u0017\r\u001c+pa&\u001c7oV5uQ\u0016k\u0007\u000f^=U_BL7m\u001d\u0015\u0004I\u00055\u0013\u0001\r;fgR\u001c%/Z1uKN#(/Z1ng&sG/\u001a:oC2$v\u000e]5dg^KG\u000f\u001b#fM\u0006,H\u000e^\"p]\u001aLw\rK\u0002&\u0003\u001b\na\u0006^3ti\u000e\u0013X-\u0019;f'R\u0014X-Y7t\u0013:$XM\u001d8bYR{\u0007/[2t!\u0006\u001c8/Z:Qe&t7-\u001b9bY\"\u001aa%!\u0014\u0002S%t\u0017\u000e^5bY&TXMU3rk\u0016\u001cHoQ8oi\u0016DHoV5uQV\u001bXM\u001d)sS:\u001c\u0017\u000e]1m)\t\ti\r\u0005\u0003\u0002P\u0006]WBAAi\u0015\u0011\t\u0019.!6\u0002\u0011I,\u0017/^3tiNT!a\u0019,\n\t\u0005e\u0017\u0011\u001b\u0002\u000f%\u0016\fX/Z:u\u0007>tG/\u001a=u\u0003aIg.\u001b;jC2L'0\u001a*fcV,7\u000f^\"p]R,\u0007\u0010\u001e\u000b\u0007\u0003\u001b\fy.a=\t\u000f\u0005\u0005\b\u00061\u0001\u0002d\u0006q1.\u00194lCB\u0013\u0018N\\2ja\u0006d\u0007\u0003BAs\u0003_l!!a:\u000b\t\u0005%\u00181^\u0001\u0005CV$\bN\u0003\u0003\u0002n\u0006U\u0017\u0001C:fGV\u0014\u0018\u000e^=\n\t\u0005E\u0018q\u001d\u0002\u000f\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0011\u001d\t)\u0010\u000ba\u0001\u0003o\fa\u0002\u001d:j]\u000eL\u0007/\u00197TKJ$W\r\u0005\u0004\u0002z\n\r!qA\u0007\u0003\u0003wTA!!@\u0002\u0000\u0006!Q\u000f^5m\u0015\t\u0011\t!\u0001\u0003kCZ\f\u0017\u0002\u0002B\u0003\u0003w\u0014\u0001b\u00149uS>t\u0017\r\u001c\t\u0005\u0003K\u0014I!\u0003\u0003\u0003\f\u0005\u001d(aE&bM.\f\u0007K]5oG&\u0004\u0018\r\\*fe\u0012,\u0017AG2sK\u0006$X\rV8qS\u000e\fe\u000e\u001a,fe&4\u0017PU3tk2$H#\u0003&\u0003\u0012\t\u0005\"1\u0005B\u0013\u0011\u001d\u0011\u0019\"\u000ba\u0001\u0005+\tQ!\u001a:s_J\u0004BAa\u0006\u0003\u001e5\u0011!\u0011\u0004\u0006\u0005\u00057\t).\u0001\u0005qe>$xnY8m\u0013\u0011\u0011yB!\u0007\u0003\r\u0015\u0013(o\u001c:t\u0011\u001d\t)'\u000ba\u0001\u0003OBq!a *\u0001\u0004\t\t\tC\u0005\u0003(%\u0002\n\u00111\u0001\u0003*\u0005yQ.\u001a;bI\u0006$\u0018mQ8oi\u0016DH\u000fE\u00035\u0005W\ti-C\u0002\u0003.U\u0012aa\u00149uS>t\u0017\u0001J2sK\u0006$X\rV8qS\u000e\fe\u000e\u001a,fe&4\u0017PU3tk2$H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\tM\"\u0006\u0002B\u0015\u0003+\u000b1bZ3u\u001d\u0016<Hk\u001c9jGRA!\u0011\bB0\u0005C\u0012\u0019\u0007\u0005\u0003\u0003<\tec\u0002\u0002B\u001f\u0005'rAAa\u0010\u0003P9!!\u0011\tB'\u001d\u0011\u0011\u0019Ea\u0013\u000f\t\t\u0015#\u0011\n\b\u0005\u0003[\u00129%C\u0001[\u0013\tA\u0016,\u0003\u00021/&\u00111MV\u0005\u0005\u0005#\n).A\u0004nKN\u001c\u0018mZ3\n\t\tU#qK\u0001\u0018\u0007J,\u0017\r^3U_BL7m\u001d*fcV,7\u000f\u001e#bi\u0006TAA!\u0015\u0002V&!!1\fB/\u00059\u0019%/Z1uC\ndW\rV8qS\u000eTAA!\u0016\u0003X!9\u0011QM\u0016A\u0002\u0005\u001d\u0004BBAEW\u0001\u0007q\bC\u0004\u0002\u000e.\u0002\r!a\n")
public class AutoTopicCreationManagerTest {
    private final int requestTimeout;
    private KafkaConfig config;
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final NodeToControllerChannelManager brokerToController = (NodeToControllerChannelManager)Mockito.mock(NodeToControllerChannelManager.class);
    private final GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
    private final TransactionCoordinator transactionCoordinator = (TransactionCoordinator)Mockito.mock(TransactionCoordinator.class);
    private final ShareCoordinator shareCoordinator = (ShareCoordinator)Mockito.mock(ShareCoordinator.class);
    private AutoTopicCreationManager autoTopicCreationManager;
    private final int internalTopicPartitions;
    private final short internalTopicReplicationFactor = (short)2;

    private int requestTimeout() {
        return this.requestTimeout;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private NodeToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    private GroupCoordinator groupCoordinator() {
        return this.groupCoordinator;
    }

    private TransactionCoordinator transactionCoordinator() {
        return this.transactionCoordinator;
    }

    private ShareCoordinator shareCoordinator() {
        return this.shareCoordinator;
    }

    private AutoTopicCreationManager autoTopicCreationManager() {
        return this.autoTopicCreationManager;
    }

    private void autoTopicCreationManager_$eq(AutoTopicCreationManager x$1) {
        this.autoTopicCreationManager = x$1;
    }

    private int internalTopicPartitions() {
        return this.internalTopicPartitions;
    }

    private short internalTopicReplicationFactor() {
        return this.internalTopicReplicationFactor;
    }

    @BeforeEach
    public void setup() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.setProperty("request.timeout.ms", Integer.toString(this.requestTimeout()));
        props.setProperty("offsets.topic.replication.factor", Integer.toString(this.internalTopicPartitions()));
        props.setProperty("transaction.state.log.replication.factor", Integer.toString(this.internalTopicPartitions()));
        props.setProperty("share.coordinator.state.topic.replication.factor", Integer.toString(this.internalTopicPartitions()));
        props.setProperty("offsets.topic.num.partitions", Short.toString(this.internalTopicReplicationFactor()));
        props.setProperty("transaction.state.log.num.partitions", Short.toString(this.internalTopicReplicationFactor()));
        props.setProperty("share.coordinator.state.topic.num.partitions", Short.toString(this.internalTopicReplicationFactor()));
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        java.util.List<Node> aliveBrokers = java.util.List.of(new Node(0, "host0", 0), new Node(1, "host1", 1));
        Mockito.when((Object)this.metadataCache().getAliveBrokerNodes((ListenerName)ArgumentMatchers.any(ListenerName.class))).thenReturn(aliveBrokers);
    }

    @Test
    public void testCreateOffsetTopic() {
        Mockito.when((Object)this.groupCoordinator().groupMetadataTopicConfigs()).thenReturn((Object)new Properties());
        this.testCreateTopic("__consumer_offsets", true, this.internalTopicPartitions(), this.internalTopicReplicationFactor());
    }

    @Test
    public void testCreateTxnTopic() {
        Mockito.when((Object)this.transactionCoordinator().transactionTopicConfigs()).thenReturn((Object)new Properties());
        this.testCreateTopic("__transaction_state", true, this.internalTopicPartitions(), this.internalTopicReplicationFactor());
    }

    @Test
    public void testCreateShareStateTopic() {
        Mockito.when((Object)this.shareCoordinator().shareGroupStateTopicConfigs()).thenReturn((Object)new Properties());
        this.testCreateTopic("__share_group_state", true, this.internalTopicPartitions(), this.internalTopicReplicationFactor());
    }

    @Test
    public void testCreateNonInternalTopic() {
        this.testCreateTopic("topic", false, 1, (short)1);
    }

    private void testCreateTopic(String topicName, boolean isInternal, int numPartitions, short replicationFactor) {
        this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), this.brokerToController(), this.groupCoordinator(), this.transactionCoordinator(), this.shareCoordinator()));
        CreateTopicsRequestData.CreatableTopicCollection topicsCollection = new CreateTopicsRequestData.CreatableTopicCollection();
        topicsCollection.add((ImplicitLinkedHashCollection.Element)this.getNewTopic(topicName, numPartitions, replicationFactor));
        CreateTopicsRequest.Builder requestBody = new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTopics(topicsCollection).setTimeoutMs(this.requestTimeout()));
        this.createTopicAndVerifyResult(Errors.UNKNOWN_TOPIC_OR_PARTITION, topicName, isInternal, (Option<RequestContext>)None$.MODULE$);
        this.createTopicAndVerifyResult(Errors.UNKNOWN_TOPIC_OR_PARTITION, topicName, isInternal, (Option<RequestContext>)None$.MODULE$);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.eq((Object)requestBody), (ControllerRequestCompletionHandler)ArgumentMatchers.any(ControllerRequestCompletionHandler.class));
    }

    private int testCreateTopic$default$3() {
        return 1;
    }

    private short testCreateTopic$default$4() {
        return 1;
    }

    @Test
    public void testTopicCreationWithMetadataContextPassPrincipal() {
        String topicName = "topic";
        KafkaPrincipal userPrincipal = new KafkaPrincipal("User", "user");
        AtomicBoolean serializeIsCalled = new AtomicBoolean(false);
        KafkaPrincipalSerde principalSerde = new KafkaPrincipalSerde(null, userPrincipal, serializeIsCalled){
            private final KafkaPrincipal userPrincipal$1;
            private final AtomicBoolean serializeIsCalled$1;

            public byte[] serialize(KafkaPrincipal principal) {
                Assertions.assertEquals((Object)principal, (Object)this.userPrincipal$1);
                this.serializeIsCalled$1.set(true);
                return principal.toString().getBytes(StandardCharsets.UTF_8);
            }

            public KafkaPrincipal deserialize(byte[] bytes) {
                return SecurityUtils.parseKafkaPrincipal((String)new String(bytes, StandardCharsets.UTF_8));
            }
            {
                this.userPrincipal$1 = userPrincipal$1;
                this.serializeIsCalled$1 = serializeIsCalled$1;
            }
        };
        RequestContext requestContext = this.initializeRequestContext(userPrincipal, Optional.of(principalSerde));
        this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext));
        Assertions.assertTrue((boolean)serializeIsCalled.get());
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)argumentCaptor.capture(), (ControllerRequestCompletionHandler)ArgumentMatchers.any(ControllerRequestCompletionHandler.class));
        EnvelopeRequest capturedRequest = ((EnvelopeRequest.Builder)argumentCaptor.getValue()).build(ApiKeys.ENVELOPE.latestVersion());
        byte[] utf8_bytes = capturedRequest.requestPrincipal();
        Object var8_8 = null;
        Assertions.assertEquals((Object)userPrincipal, (Object)SecurityUtils.parseKafkaPrincipal((String)new String(utf8_bytes, StandardCharsets.UTF_8)));
    }

    @Test
    public void testTopicCreationWithMetadataContextWhenPrincipalSerdeNotDefined() {
        String topicName = "topic";
        RequestContext requestContext = this.initializeRequestContext(KafkaPrincipal.ANONYMOUS, Optional.empty());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext)));
    }

    @Test
    public void testTopicCreationWithMetadataContextNoRetryUponUnsupportedVersion() {
        String topicName = "topic";
        KafkaPrincipalSerde principalSerde = new KafkaPrincipalSerde(null){

            public byte[] serialize(KafkaPrincipal principal) {
                return principal.toString().getBytes(StandardCharsets.UTF_8);
            }

            public KafkaPrincipal deserialize(byte[] bytes) {
                return SecurityUtils.parseKafkaPrincipal((String)new String(bytes, StandardCharsets.UTF_8));
            }
        };
        RequestContext requestContext = this.initializeRequestContext(KafkaPrincipal.ANONYMOUS, Optional.of(principalSerde));
        this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext));
        this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext));
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(AbstractRequest.Builder.class), (ControllerRequestCompletionHandler)argumentCaptor.capture());
        RequestHeader header = new RequestHeader(ApiKeys.ENVELOPE, 0, "client", 1);
        EnvelopeResponse response = new EnvelopeResponse(ByteBuffer.allocate(0), Errors.UNSUPPORTED_VERSION);
        ClientResponse clientResponse = new ClientResponse(header, null, null, 0L, 0L, false, null, null, (AbstractResponse)response);
        ((RequestCompletionHandler)argumentCaptor.getValue()).onComplete(clientResponse);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)1))).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(AbstractRequest.Builder.class), (ControllerRequestCompletionHandler)argumentCaptor.capture());
        this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, (Option)new Some((Object)requestContext));
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(AbstractRequest.Builder.class), (ControllerRequestCompletionHandler)argumentCaptor.capture());
    }

    @Test
    public void testCreateStreamsInternalTopics() {
        CreateTopicsRequestData.CreatableTopicConfigCollection topicConfig = new CreateTopicsRequestData.CreatableTopicConfigCollection();
        topicConfig.add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopicConfig().setName("cleanup.policy").setValue("compact"));
        Map topics = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stream-topic-1"), (Object)new CreateTopicsRequestData.CreatableTopic().setName("stream-topic-1").setNumPartitions(3).setReplicationFactor((short)2).setConfigs(topicConfig)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stream-topic-2"), (Object)new CreateTopicsRequestData.CreatableTopic().setName("stream-topic-2").setNumPartitions(1).setReplicationFactor((short)1))}));
        RequestContext requestContext = this.initializeRequestContextWithUserPrincipal();
        this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), this.brokerToController(), this.groupCoordinator(), this.transactionCoordinator(), this.shareCoordinator()));
        this.autoTopicCreationManager().createStreamsInternalTopics(topics, requestContext);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)argumentCaptor.capture(), (ControllerRequestCompletionHandler)ArgumentMatchers.any(ControllerRequestCompletionHandler.class));
        RequestHeader requestHeader = new RequestHeader(ApiKeys.CREATE_TOPICS, ApiKeys.CREATE_TOPICS.latestVersion(), "clientId", 0);
        EnvelopeRequest capturedRequest = ((EnvelopeRequest.Builder)argumentCaptor.getValue()).build(ApiKeys.ENVELOPE.latestVersion());
        CreateTopicsRequestData.CreatableTopicCollection topicsCollection = new CreateTopicsRequestData.CreatableTopicCollection();
        topicsCollection.add((ImplicitLinkedHashCollection.Element)this.getNewTopic("stream-topic-1", 3, (short)2).setConfigs(topicConfig));
        topicsCollection.add((ImplicitLinkedHashCollection.Element)this.getNewTopic("stream-topic-2", 1, (short)1));
        CreateTopicsRequest requestBody = new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTopics(topicsCollection).setTimeoutMs(this.requestTimeout())).build(ApiKeys.CREATE_TOPICS.latestVersion());
        ByteBuffer forwardedRequestBuffer = capturedRequest.requestData().duplicate();
        Assertions.assertEquals((Object)requestHeader, (Object)RequestHeader.parse((ByteBuffer)forwardedRequestBuffer));
        Assertions.assertEquals((Object)requestBody.data(), (Object)CreateTopicsRequest.parse((Readable)new ByteBufferAccessor(forwardedRequestBuffer), (short)ApiKeys.CREATE_TOPICS.latestVersion()).data());
    }

    @Test
    public void testCreateStreamsInternalTopicsWithEmptyTopics() {
        Map topics = (Map)Map$.MODULE$.empty();
        RequestContext requestContext = this.initializeRequestContextWithUserPrincipal();
        this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), this.brokerToController(), this.groupCoordinator(), this.transactionCoordinator(), this.shareCoordinator()));
        this.autoTopicCreationManager().createStreamsInternalTopics(topics, requestContext);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.never())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(AbstractRequest.Builder.class), (ControllerRequestCompletionHandler)ArgumentMatchers.any(ControllerRequestCompletionHandler.class));
    }

    @Test
    public void testCreateStreamsInternalTopicsWithDefaultConfig() {
        Map topics = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stream-topic-1"), (Object)new CreateTopicsRequestData.CreatableTopic().setName("stream-topic-1").setNumPartitions(-1).setReplicationFactor((short)-1))}));
        RequestContext requestContext = this.initializeRequestContextWithUserPrincipal();
        this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), this.brokerToController(), this.groupCoordinator(), this.transactionCoordinator(), this.shareCoordinator()));
        this.autoTopicCreationManager().createStreamsInternalTopics(topics, requestContext);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)argumentCaptor.capture(), (ControllerRequestCompletionHandler)ArgumentMatchers.any(ControllerRequestCompletionHandler.class));
        EnvelopeRequest capturedRequest = ((EnvelopeRequest.Builder)argumentCaptor.getValue()).build(ApiKeys.ENVELOPE.latestVersion());
        RequestHeader requestHeader = new RequestHeader(ApiKeys.CREATE_TOPICS, ApiKeys.CREATE_TOPICS.latestVersion(), "clientId", 0);
        CreateTopicsRequestData.CreatableTopicCollection topicsCollection = new CreateTopicsRequestData.CreatableTopicCollection();
        topicsCollection.add((ImplicitLinkedHashCollection.Element)this.getNewTopic("stream-topic-1", Predef$.MODULE$.Integer2int(this.config().numPartitions()), (short)this.config().defaultReplicationFactor()));
        CreateTopicsRequest requestBody = new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTopics(topicsCollection).setTimeoutMs(this.requestTimeout())).build(ApiKeys.CREATE_TOPICS.latestVersion());
        ByteBuffer forwardedRequestBuffer = capturedRequest.requestData().duplicate();
        Assertions.assertEquals((Object)requestHeader, (Object)RequestHeader.parse((ByteBuffer)forwardedRequestBuffer));
        Assertions.assertEquals((Object)requestBody.data(), (Object)CreateTopicsRequest.parse((Readable)new ByteBufferAccessor(forwardedRequestBuffer), (short)ApiKeys.CREATE_TOPICS.latestVersion()).data());
    }

    @Test
    public void testCreateStreamsInternalTopicsPassesPrincipal() {
        Map topics = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stream-topic-1"), (Object)new CreateTopicsRequestData.CreatableTopic().setName("stream-topic-1").setNumPartitions(-1).setReplicationFactor((short)-1))}));
        RequestContext requestContext = this.initializeRequestContextWithUserPrincipal();
        this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), this.brokerToController(), this.groupCoordinator(), this.transactionCoordinator(), this.shareCoordinator()));
        this.autoTopicCreationManager().createStreamsInternalTopics(topics, requestContext);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ((NodeToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)argumentCaptor.capture(), (ControllerRequestCompletionHandler)ArgumentMatchers.any(ControllerRequestCompletionHandler.class));
        EnvelopeRequest capturedRequest = ((EnvelopeRequest.Builder)argumentCaptor.getValue()).build(ApiKeys.ENVELOPE.latestVersion());
        byte[] utf8_bytes = capturedRequest.requestPrincipal();
        Object var5_5 = null;
        Assertions.assertEquals((Object)new KafkaPrincipal("User", "user"), (Object)SecurityUtils.parseKafkaPrincipal((String)new String(utf8_bytes, StandardCharsets.UTF_8)));
    }

    private RequestContext initializeRequestContextWithUserPrincipal() {
        KafkaPrincipal userPrincipal = new KafkaPrincipal("User", "user");
        KafkaPrincipalSerde principalSerde = new KafkaPrincipalSerde(null){

            public byte[] serialize(KafkaPrincipal principal) {
                return principal.toString().getBytes(StandardCharsets.UTF_8);
            }

            public KafkaPrincipal deserialize(byte[] bytes) {
                return SecurityUtils.parseKafkaPrincipal((String)new String(bytes, StandardCharsets.UTF_8));
            }
        };
        return this.initializeRequestContext(userPrincipal, Optional.of(principalSerde));
    }

    private RequestContext initializeRequestContext(KafkaPrincipal kafkaPrincipal, Optional<KafkaPrincipalSerde> principalSerde) {
        this.autoTopicCreationManager_$eq((AutoTopicCreationManager)new DefaultAutoTopicCreationManager(this.config(), this.brokerToController(), this.groupCoordinator(), this.transactionCoordinator(), this.shareCoordinator()));
        ApiVersionsResponseData.ApiVersion createTopicApiVersion = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.CREATE_TOPICS.id).setMinVersion(ApiKeys.CREATE_TOPICS.oldestVersion()).setMaxVersion(ApiKeys.CREATE_TOPICS.latestVersion());
        Mockito.when((Object)this.brokerToController().controllerApiVersions()).thenReturn(Optional.of(NodeApiVersions.create(Collections.singleton(createTopicApiVersion))));
        RequestHeader requestHeader = new RequestHeader(ApiKeys.METADATA, ApiKeys.METADATA.latestVersion(), "clientId", 0);
        return new RequestContext(requestHeader, "1", InetAddress.getLocalHost(), Optional.empty(), kafkaPrincipal, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, false, principalSerde);
    }

    private void createTopicAndVerifyResult(Errors error, String topicName, boolean isInternal, Option<RequestContext> metadataContext) {
        Seq topicResponses = this.autoTopicCreationManager().createTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topicName})), (ControllerMutationQuota)UnboundedControllerMutationQuota$.MODULE$, metadataContext);
        Assertions.assertEquals((Object)new .colon.colon((Object)new MetadataResponseData.MetadataResponseTopic().setErrorCode(error.code()).setIsInternal(isInternal).setName(topicName), (List)Nil$.MODULE$), (Object)topicResponses);
    }

    private Option<RequestContext> createTopicAndVerifyResult$default$4() {
        return None$.MODULE$;
    }

    private CreateTopicsRequestData.CreatableTopic getNewTopic(String topicName, int numPartitions, short replicationFactor) {
        return new CreateTopicsRequestData.CreatableTopic().setName(topicName).setNumPartitions(numPartitions).setReplicationFactor(replicationFactor);
    }

    public AutoTopicCreationManagerTest() {
        this.requestTimeout = 100;
        this.internalTopicPartitions = 2;
    }
}

