/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import kafka.server.BaseClientQuotaManagerTest;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerTest$UserClient$;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.network.Session;
import org.apache.kafka.server.config.ClientQuotaManagerConfig;
import org.apache.kafka.server.quota.QuotaType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tEd\u0001\u0002\u001a4\u0001aBQ!\u0010\u0001\u0005\u0002yBq\u0001\u0011\u0001C\u0002\u0013%\u0011\t\u0003\u0004N\u0001\u0001\u0006IA\u0011\u0005\u0006\u001d\u0002!Ia\u0014\u0005\b\u0003\u001b\u0004A\u0011AAh\u0011\u001d\t9\u000f\u0001C\u0005\u0003SDqAa\u0003\u0001\t\u0003\ty\rC\u0004\u0003\u0010\u0001!\t!a4\t\u000f\tM\u0001\u0001\"\u0001\u0002P\"9!q\u0003\u0001\u0005\u0002\u0005=\u0007b\u0002B\u000e\u0001\u0011\u0005\u0011q\u001a\u0005\b\u0005?\u0001A\u0011AAh\u0011\u001d\u0011\u0019\u0003\u0001C\u0001\u0003\u001fDqAa\n\u0001\t\u0003\ty\rC\u0004\u0003,\u0001!\t!a4\u0007\tm\u0003A\t\u0018\u0005\t_B\u0011)\u001a!C\u0001a\"A\u0011\u0010\u0005B\tB\u0003%\u0011\u000f\u0003\u0005{!\tU\r\u0011\"\u0001q\u0011!Y\bC!E!\u0002\u0013\t\b\u0002\u0003?\u0011\u0005+\u0007I\u0011A?\t\u0013\u0005e\u0001C!E!\u0002\u0013q\bBCA\u000e!\tU\r\u0011\"\u0001\u0002\u001e!Q\u0011\u0011\u0006\t\u0003\u0012\u0003\u0006I!a\b\t\ru\u0002B\u0011AA\u0016\u0011%\t)\u0004EA\u0001\n\u0003\t9\u0004C\u0005\u0002BA\t\n\u0011\"\u0001\u0002D!I\u0011\u0011\f\t\u0012\u0002\u0013\u0005\u00111\t\u0005\n\u00037\u0002\u0012\u0013!C\u0001\u0003;B\u0011\"!\u0019\u0011#\u0003%\t!a\u0019\t\u0013\u0005\u001d\u0004#!A\u0005B\u0005%\u0004\"CA=!\u0005\u0005I\u0011AA>\u0011%\t\u0019\tEA\u0001\n\u0003\t)\tC\u0005\u0002\u0012B\t\t\u0011\"\u0011\u0002\u0014\"I\u0011\u0011\u0015\t\u0002\u0002\u0013\u0005\u00111\u0015\u0005\n\u0003[\u0003\u0012\u0011!C!\u0003_C\u0011\"a-\u0011\u0003\u0003%\t%!.\t\u0013\u0005]\u0006#!A\u0005B\u0005e\u0006\"CA^!\u0005\u0005I\u0011IA_\u000f%\u0011y\u0003AA\u0001\u0012\u0013\u0011\tD\u0002\u0005\\\u0001\u0005\u0005\t\u0012\u0002B\u001a\u0011\u0019i\u0014\u0006\"\u0001\u0003L!I\u0011qW\u0015\u0002\u0002\u0013\u0015\u0013\u0011\u0018\u0005\n\u0005\u001bJ\u0013\u0011!CA\u0005\u001fB\u0011B!\u0017*#\u0003%\t!!\u0018\t\u0013\tm\u0013&%A\u0005\u0002\u0005\r\u0004\"\u0003B/S\u0005\u0005I\u0011\u0011B0\u0011%\u0011i'KI\u0001\n\u0003\ti\u0006C\u0005\u0003p%\n\n\u0011\"\u0001\u0002d\t12\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u00025k\u000511/\u001a:wKJT\u0011AN\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\b\u0005\u0002;w5\t1'\u0003\u0002=g\tQ\")Y:f\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'\u000fV3ti\u00061A(\u001b8jiz\"\u0012a\u0010\t\u0003u\u0001\taaY8oM&<W#\u0001\"\u0011\u0005\r[U\"\u0001#\u000b\u0005\u0001+%B\u0001\u001bG\u0015\t1tI\u0003\u0002I\u0013\u00061\u0011\r]1dQ\u0016T\u0011AS\u0001\u0004_J<\u0017B\u0001'E\u0005a\u0019E.[3oiF+x\u000e^1NC:\fw-\u001a:D_:4\u0017nZ\u0001\bG>tg-[4!\u0003A!Xm\u001d;Rk>$\u0018\rU1sg&tw\rF\u0005Q-^\u000b\t-!2\u0002JB\u0011\u0011\u000bV\u0007\u0002%*\t1+A\u0003tG\u0006d\u0017-\u0003\u0002V%\n!QK\\5u\u0011\u0015\u0001E\u00011\u0001C\u0011\u0015AF\u00011\u0001Z\u0003\u001d\u0019G.[3oiF\u0002\"A\u0017\t\u000e\u0003\u0001\u0011!\"V:fe\u000ec\u0017.\u001a8u'\u0011\u0001R\fY2\u0011\u0005Es\u0016BA0S\u0005\u0019\te.\u001f*fMB\u0011\u0011+Y\u0005\u0003EJ\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002eY:\u0011QM\u001b\b\u0003M&l\u0011a\u001a\u0006\u0003Q^\na\u0001\u0010:p_Rt\u0014\"A*\n\u0005-\u0014\u0016a\u00029bG.\fw-Z\u0005\u0003[:\u0014AbU3sS\u0006d\u0017N_1cY\u0016T!a\u001b*\u0002\tU\u001cXM]\u000b\u0002cB\u0011!O\u001e\b\u0003gR\u0004\"A\u001a*\n\u0005U\u0014\u0016A\u0002)sK\u0012,g-\u0003\u0002xq\n11\u000b\u001e:j]\u001eT!!\u001e*\u0002\u000bU\u001cXM\u001d\u0011\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012\f\u0011b\u00197jK:$\u0018\n\u001a\u0011\u0002\u0015\r|gNZ5h+N,'/F\u0001\u007f!\u0011\tv0a\u0001\n\u0007\u0005\u0005!K\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u000b\t\u0019B\u0004\u0003\u0002\b\u0005=a\u0002BA\u0005\u0003\u001bq1AZA\u0006\u0013\u00051\u0014B\u0001\u001b6\u0013\r\t\tbM\u0001\u0013\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'/\u0003\u0003\u0002\u0016\u0005]!A\u0004\"bg\u0016,6/\u001a:F]RLG/\u001f\u0006\u0004\u0003#\u0019\u0014aC2p]\u001aLw-V:fe\u0002\n!cY8oM&<7\t\\5f]R,e\u000e^5usV\u0011\u0011q\u0004\t\u0005#~\f\t\u0003\u0005\u0003\u0002$\u0005\u0015bb\u0001\u001e\u0002\u0010%!\u0011qEA\f\u00059\u0019E.[3oi&#WI\u001c;jif\f1cY8oM&<7\t\\5f]R,e\u000e^5us\u0002\"\u0012\"WA\u0017\u0003_\t\t$a\r\t\u000b=L\u0002\u0019A9\t\u000biL\u0002\u0019A9\t\u000fqL\u0002\u0013!a\u0001}\"I\u00111D\r\u0011\u0002\u0003\u0007\u0011qD\u0001\u0005G>\u0004\u0018\u0010F\u0005Z\u0003s\tY$!\u0010\u0002@!9qN\u0007I\u0001\u0002\u0004\t\bb\u0002>\u001b!\u0003\u0005\r!\u001d\u0005\byj\u0001\n\u00111\u0001\u007f\u0011%\tYB\u0007I\u0001\u0002\u0004\ty\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0015#fA9\u0002H-\u0012\u0011\u0011\n\t\u0005\u0003\u0017\n)&\u0004\u0002\u0002N)!\u0011qJA)\u0003%)hn\u00195fG.,GMC\u0002\u0002TI\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t9&!\u0014\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\f\u0016\u0004}\u0006\u001d\u0013AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003KRC!a\b\u0002H\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u001b\u0011\t\u00055\u0014qO\u0007\u0003\u0003_RA!!\u001d\u0002t\u0005!A.\u00198h\u0015\t\t)(\u0001\u0003kCZ\f\u0017bA<\u0002p\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0010\t\u0004#\u0006}\u0014bAAA%\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qQAG!\r\t\u0016\u0011R\u0005\u0004\u0003\u0017\u0013&aA!os\"I\u0011qR\u0011\u0002\u0002\u0003\u0007\u0011QP\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005U\u0005CBAL\u0003;\u000b9)\u0004\u0002\u0002\u001a*\u0019\u00111\u0014*\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002 \u0006e%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!*\u0002,B\u0019\u0011+a*\n\u0007\u0005%&KA\u0004C_>dW-\u00198\t\u0013\u0005=5%!AA\u0002\u0005\u001d\u0015A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\u001b\u00022\"I\u0011q\u0012\u0013\u0002\u0002\u0003\u0007\u0011QP\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011QP\u0001\ti>\u001cFO]5oOR\u0011\u00111N\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u0015\u0016q\u0018\u0005\n\u0003\u001f;\u0013\u0011!a\u0001\u0003\u000fCa!a1\u0005\u0001\u0004I\u0016aB2mS\u0016tGO\r\u0005\u0007\u0003\u000f$\u0001\u0019A-\u0002\u0019I\fg\u000eZ8n\u00072LWM\u001c;\t\r\u0005-G\u00011\u0001Z\u0003M!WMZ1vYR\u001cuN\u001c4jO\u000ec\u0017.\u001a8u\u00031\"Xm\u001d;Vg\u0016\u0014\u0018+^8uCB\u000b'o]5oO^KG\u000f\u001b#fM\u0006,H\u000e^\"mS\u0016tG/\u00133Rk>$\u0018\rF\u0001QQ\r)\u00111\u001b\t\u0005\u0003+\f\u0019/\u0004\u0002\u0002X*!\u0011\u0011\\An\u0003\r\t\u0007/\u001b\u0006\u0005\u0003;\fy.A\u0004kkBLG/\u001a:\u000b\u0007\u0005\u0005\u0018*A\u0003kk:LG/\u0003\u0003\u0002f\u0006]'\u0001\u0002+fgR\f!b\u00195fG.\fVo\u001c;b)5\u0001\u00161^A{\u0003o\fIPa\u0001\u0003\b!9\u0011Q\u001e\u0004A\u0002\u0005=\u0018\u0001D9v_R\fW*\u00198bO\u0016\u0014\bc\u0001\u001e\u0002r&\u0019\u00111_\u001a\u0003%\rc\u0017.\u001a8u#V|G/Y'b]\u0006<WM\u001d\u0005\u0006_\u001a\u0001\r!\u001d\u0005\u0006u\u001a\u0001\r!\u001d\u0005\b\u0003w4\u0001\u0019AA\u007f\u00035)\u0007\u0010]3di\u0016$'i\\;oIB\u0019\u0011+a@\n\u0007\t\u0005!K\u0001\u0003M_:<\u0007b\u0002B\u0003\r\u0001\u0007\u0011QP\u0001\u0006m\u0006dW/\u001a\u0005\b\u0005\u00131\u0001\u0019AAS\u00039)\u0007\u0010]3diRC'o\u001c;uY\u0016\fQ\u0007^3ti\u001e+G/T1y-\u0006dW/Z%o#V|G/Y,j]\u0012|woV5uQ:{g\u000eR3gCVdG/U;pi\u0006<\u0016N\u001c3po\"\u001aq!a5\u0002AQ,7\u000f^*fi\u0006sGMU3n_Z,G)\u001a4bk2$Xk]3s#V|G/\u0019\u0015\u0004\u0011\u0005M\u0017!\u0007;fgR\u001cV\r^!oIJ+Wn\u001c<f+N,'/U;pi\u0006D3!CAj\u0003}!Xm\u001d;TKR\fe\u000e\u001a*f[>4X-V:fe\u000ec\u0017.\u001a8u#V|G/\u0019\u0015\u0004\u0015\u0005M\u0017!\u0007;fgR\fVo\u001c;b\u0007>tg-[4Qe\u0016\u001cW\rZ3oG\u0016D3aCAj\u0003I!Xm\u001d;Rk>$\u0018MV5pY\u0006$\u0018n\u001c8)\u00071\t\u0019.\u0001\u000fuKN$X\t\u001f9je\u0016$\u0006N]8ui2,G+[7f'\u0016t7o\u001c:)\u00075\t\u0019.\u0001\fuKN$X\t\u001f9je\u0016\fVo\u001c;b'\u0016t7o\u001c:tQ\rq\u00111[\u0001\u0019i\u0016\u001cHo\u00117jK:$\u0018\n\u001a(piN\u000bg.\u001b;ju\u0016$\u0007fA\b\u0002T\u0006QQk]3s\u00072LWM\u001c;\u0011\u0005iK3#B\u0015\u00036\t\u0005\u0003C\u0003B\u001c\u0005{\t\u0018O`A\u001036\u0011!\u0011\b\u0006\u0004\u0005w\u0011\u0016a\u0002:v]RLW.Z\u0005\u0005\u0005\u007f\u0011IDA\tBEN$(/Y2u\rVt7\r^5p]R\u0002BAa\u0011\u0003J5\u0011!Q\t\u0006\u0005\u0005\u000f\n\u0019(\u0001\u0002j_&\u0019QN!\u0012\u0015\u0005\tE\u0012!B1qa2LH#C-\u0003R\tM#Q\u000bB,\u0011\u0015yG\u00061\u0001r\u0011\u0015QH\u00061\u0001r\u0011\u001daH\u0006%AA\u0002yD\u0011\"a\u0007-!\u0003\u0005\r!a\b\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM\nq\"\u00199qYf$C-\u001a4bk2$H\u0005N\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\tG!\u001b\u0011\tE{(1\r\t\t#\n\u0015\u0014/\u001d@\u0002 %\u0019!q\r*\u0003\rQ+\b\u000f\\35\u0011!\u0011YgLA\u0001\u0002\u0004I\u0016a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0004")
public class ClientQuotaManagerTest
extends BaseClientQuotaManagerTest {
    private volatile ClientQuotaManagerTest$UserClient$ UserClient$module;
    private final ClientQuotaManagerConfig config = new ClientQuotaManagerConfig();

    private ClientQuotaManagerTest$UserClient$ UserClient() {
        if (this.UserClient$module == null) {
            this.UserClient$lzycompute$1();
        }
        return this.UserClient$module;
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private void testQuotaParsing(ClientQuotaManagerConfig config, UserClient client1, UserClient client2, UserClient randomClient, UserClient defaultConfigClient) {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(config, this.metrics(), QuotaType.PRODUCE, (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientEntity(), (Option)new Some((Object)new Quota(2000.0, true)));
            clientQuotaManager.updateQuota(client2.configUser(), client2.configClientEntity(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assertions.assertEquals((double)9.223372036854776E18, (double)clientQuotaManager.quota(randomClient.user(), randomClient.clientId()).bound(), (double)0.0, (String)("Default producer quota should be " + 9.223372036854776E18));
            Assertions.assertEquals((double)2000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the overridden value (2000)");
            Assertions.assertEquals((double)4000.0, (double)clientQuotaManager.quota(client2.user(), client2.clientId()).bound(), (double)0.0, (String)"Should return the overridden value (4000)");
            int throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 2500 * config.numQuotaSamples);
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)("throttleTimeMs should be > 0. was " + throttleTimeMs));
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientEntity(), (Option)new Some((Object)new Quota(3000.0, true)));
            Assertions.assertEquals((double)3000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the newly overridden value (3000)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 0.0);
            Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)("throttleTimeMs should be 0. was " + throttleTimeMs));
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientEntity(), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((double)500.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the default value (500)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 0.0);
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)("throttleTimeMs should be > 0. was " + throttleTimeMs));
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientEntity(), (Option)None$.MODULE$);
            clientQuotaManager.updateQuota(defaultConfigClient.configUser(), defaultConfigClient.configClientEntity(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assertions.assertEquals((double)4000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the newly overridden value (4000)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 1000 * config.numQuotaSamples);
            Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)("throttleTimeMs should be 0. was " + throttleTimeMs));
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testUserQuotaParsingWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<ClientQuotaManager.BaseUserEntity>)new Some((Object)new ClientQuotaManager.UserEntity("User1")), (Option<ClientQuotaManager.ClientIdEntity>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<ClientQuotaManager.BaseUserEntity>)new Some((Object)new ClientQuotaManager.UserEntity("User2")), (Option<ClientQuotaManager.ClientIdEntity>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<ClientQuotaManager.BaseUserEntity>)None$.MODULE$, (Option<ClientQuotaManager.ClientIdEntity>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<ClientQuotaManager.BaseUserEntity>)new Some((Object)ClientQuotaManager.DefaultUserEntity$.MODULE$), (Option<ClientQuotaManager.ClientIdEntity>)None$.MODULE$);
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    private void checkQuota(ClientQuotaManager quotaManager, String user, String clientId, long expectedBound, int value, boolean expectThrottle) {
        Assertions.assertEquals((double)expectedBound, (double)quotaManager.quota(user, clientId).bound(), (double)0.0);
        Session session = new Session(new KafkaPrincipal("User", user), InetAddress.getLocalHost());
        Assertions.assertEquals((double)(expectedBound < Long.MAX_VALUE ? (double)(this.config().quotaWindowSizeSeconds * (this.config().numQuotaSamples - 1)) * (double)expectedBound : Double.MAX_VALUE), (double)quotaManager.getMaxValueInQuotaWindow(session, clientId), (double)0.01);
        int throttleTimeMs = this.maybeRecord(quotaManager, user, clientId, value * this.config().numQuotaSamples);
        if (expectThrottle) {
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)("throttleTimeMs should be > 0. was " + throttleTimeMs));
            return;
        }
        Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)("throttleTimeMs should be 0. was " + throttleTimeMs));
    }

    @Test
    public void testGetMaxValueInQuotaWindowWithNonDefaultQuotaWindow() {
        int numFullQuotaWindows = 3;
        ClientQuotaManagerConfig nonDefaultConfig = new ClientQuotaManagerConfig(numFullQuotaWindows + 1);
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(nonDefaultConfig, this.metrics(), QuotaType.FETCH, (Time)this.time(), "", (Option)None$.MODULE$);
        Session userSession = new Session(new KafkaPrincipal("User", "userA"), InetAddress.getLocalHost());
        try {
            Assertions.assertEquals((double)Double.MAX_VALUE, (double)clientQuotaManager.getMaxValueInQuotaWindow(userSession, "client1"), (double)0.01);
            clientQuotaManager.updateQuota((Option)new Some((Object)ClientQuotaManager.DefaultUserEntity$.MODULE$), (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            Assertions.assertEquals((double)(10 * numFullQuotaWindows), (double)clientQuotaManager.getMaxValueInQuotaWindow(userSession, "client1"), (double)0.01);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveDefaultUserQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(), this.metrics(), QuotaType.PRODUCE, (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)ClientQuotaManager.DefaultUserEntity$.MODULE$), (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)ClientQuotaManager.DefaultUserEntity$.MODULE$), (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveUserQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(), this.metrics(), QuotaType.PRODUCE, (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)new ClientQuotaManager.UserEntity("userA")), (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)new ClientQuotaManager.UserEntity("userA")), (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveUserClientQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(), this.metrics(), QuotaType.PRODUCE, (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)new ClientQuotaManager.UserEntity("userA")), (Option)new Some((Object)new ClientQuotaManager.ClientIdEntity("client1")), (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)new ClientQuotaManager.UserEntity("userA")), (Option)new Some((Object)new ClientQuotaManager.ClientIdEntity("client1")), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaConfigPrecedence() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(), this.metrics(), QuotaType.PRODUCE, (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)ClientQuotaManager.DefaultUserEntity$.MODULE$), (Option)None$.MODULE$, (Option)new Some((Object)new Quota(1000.0, true)));
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ClientQuotaManager.DefaultClientIdEntity$.MODULE$), (Option)new Some((Object)new Quota(2000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)ClientQuotaManager.DefaultUserEntity$.MODULE$), (Option)new Some((Object)ClientQuotaManager.DefaultClientIdEntity$.MODULE$), (Option)new Some((Object)new Quota(3000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)new ClientQuotaManager.UserEntity("userA")), (Option)None$.MODULE$, (Option)new Some((Object)new Quota(4000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)new ClientQuotaManager.UserEntity("userA")), (Option)new Some((Object)new ClientQuotaManager.ClientIdEntity("client1")), (Option)new Some((Object)new Quota(5000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)new ClientQuotaManager.UserEntity("userB")), (Option)None$.MODULE$, (Option)new Some((Object)new Quota(6000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)new ClientQuotaManager.UserEntity("userB")), (Option)new Some((Object)new ClientQuotaManager.ClientIdEntity("client1")), (Option)new Some((Object)new Quota(7000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)new ClientQuotaManager.UserEntity("userB")), (Option)new Some((Object)ClientQuotaManager.DefaultClientIdEntity$.MODULE$), (Option)new Some((Object)new Quota(8000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)new ClientQuotaManager.UserEntity("userC")), (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10000.0, true)));
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)new ClientQuotaManager.ClientIdEntity("client1")), (Option)new Some((Object)new Quota(9000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 5000L, 4500, false);
            this.checkQuota(clientQuotaManager, "userA", "client2", 4000L, 4500, true);
            this.checkQuota(clientQuotaManager, "userA", "client3", 4000L, 0, true);
            this.checkQuota(clientQuotaManager, "userA", "client1", 5000L, 0, false);
            this.checkQuota(clientQuotaManager, "userB", "client1", 7000L, 8000, true);
            this.checkQuota(clientQuotaManager, "userB", "client2", 8000L, 7000, false);
            this.checkQuota(clientQuotaManager, "userB", "client3", 8000L, 7000, false);
            this.checkQuota(clientQuotaManager, "userD", "client1", 3000L, 3500, true);
            this.checkQuota(clientQuotaManager, "userD", "client2", 3000L, 2500, false);
            this.checkQuota(clientQuotaManager, "userE", "client1", 3000L, 2500, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)ClientQuotaManager.DefaultUserEntity$.MODULE$), (Option)new Some((Object)ClientQuotaManager.DefaultClientIdEntity$.MODULE$), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userD", "client1", 1000L, 0, false);
            this.checkQuota(clientQuotaManager, "userE", "client4", 1000L, 1500, true);
            this.checkQuota(clientQuotaManager, "userF", "client4", 1000L, 800, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 1000L, 800, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)ClientQuotaManager.DefaultUserEntity$.MODULE$), (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userF", "client4", 2000L, 0, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 2000L, 0, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 2000L, 2500, true);
            this.checkQuota(clientQuotaManager, "userG", "client5", 2000L, 0, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)new ClientQuotaManager.UserEntity("userA")), (Option)None$.MODULE$, (Option)new Some((Object)new Quota(8000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)new ClientQuotaManager.UserEntity("userA")), (Option)new Some((Object)new ClientQuotaManager.ClientIdEntity("client1")), (Option)new Some((Object)new Quota(10000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client2", 8000L, 0, false);
            this.checkQuota(clientQuotaManager, "userA", "client2", 8000L, 4500, true);
            this.checkQuota(clientQuotaManager, "userA", "client1", 10000L, 0, false);
            this.checkQuota(clientQuotaManager, "userA", "client1", 10000L, 6000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)new ClientQuotaManager.UserEntity("userA")), (Option)new Some((Object)new ClientQuotaManager.ClientIdEntity("client1")), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client6", 8000L, 0, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)new ClientQuotaManager.UserEntity("userA")), (Option)new Some((Object)new ClientQuotaManager.ClientIdEntity("client6")), (Option)new Some((Object)new Quota(11000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client6", 11000L, 8500, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)new ClientQuotaManager.UserEntity("userA")), (Option)new Some((Object)ClientQuotaManager.DefaultClientIdEntity$.MODULE$), (Option)new Some((Object)new Quota(12000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)new ClientQuotaManager.UserEntity("userA")), (Option)new Some((Object)new ClientQuotaManager.ClientIdEntity("client6")), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client6", 12000L, 4000, true);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaViolation() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), QuotaType.PRODUCE, (Time)this.time(), "", (Option)None$.MODULE$);
        KafkaMetric queueSizeMetric = (KafkaMetric)this.metrics().metrics().get(this.metrics().metricName("queue-size", "Produce", ""));
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ClientQuotaManager.DefaultClientIdEntity$.MODULE$), (Option)new Some((Object)new Quota(500.0, true)));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
                Assertions.assertEquals((int)0, (int)this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 400.0));
                this.time().sleep(1000L);
            });
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.time().sleep(500L);
            int throttleTime = this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 2300.0);
            Assertions.assertEquals((int)2100, (int)throttleTime, (String)"Should be throttled");
            this.throttle(clientQuotaManager, "ANONYMOUS", "unknown", throttleTime, this.callback());
            Assertions.assertEquals((int)1, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            clientQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)this.numCallbacks());
            this.time().sleep((long)throttleTime);
            clientQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assertions.assertEquals((int)1, (int)this.numCallbacks());
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
                this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 400.0);
                this.time().sleep(1000L);
            });
            Assertions.assertEquals((int)0, (int)this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 0.0), (String)"Should be unthrottled since bursty sample has rolled over");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testExpireThrottleTimeSensor() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), QuotaType.PRODUCE, (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ClientQuotaManager.DefaultClientIdEntity$.MODULE$), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            Assertions.assertTrue((this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 10000.0) > 0 ? 1 : 0) != 0, (String)"Should be throttled");
            Sensor throttleTimeSensor = this.metrics().getSensor("ProduceThrottleTime-:client1");
            Assertions.assertNotNull((Object)throttleTimeSensor, (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)throttleTimeSensor, (String)"Throttle time sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testExpireQuotaSensors() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), QuotaType.PRODUCE, (Time)this.time(), "", (Option)None$.MODULE$);
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ClientQuotaManager.DefaultClientIdEntity$.MODULE$), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            this.metrics().removeSensor("Produce-ANONYMOUS:client1");
            Assertions.assertTrue((this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 10000.0) > 0 ? 1 : 0) != 0, (String)"Should be throttled");
            Assertions.assertNotNull((Object)this.metrics().getSensor("ProduceThrottleTime-:client1"), (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)this.metrics().getSensor("Produce-:client1"), (String)"Byte rate sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testClientIdNotSanitized() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), QuotaType.PRODUCE, (Time)this.time(), "", (Option)None$.MODULE$);
        String clientId = "client@#$%";
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ClientQuotaManager.DefaultClientIdEntity$.MODULE$), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", clientId, 100.0);
            Assertions.assertNotNull((Object)this.metrics().getSensor("ProduceThrottleTime-:" + clientId), (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)this.metrics().getSensor("Produce-:" + clientId), (String)"Byte rate sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    private final void UserClient$lzycompute$1() {
        synchronized (this) {
            if (this.UserClient$module == null) {
                this.UserClient$module = new ClientQuotaManagerTest$UserClient$(this);
            }
            return;
        }
    }

    private class UserClient
    implements Product,
    Serializable {
        private final String user;
        private final String clientId;
        private final Option<ClientQuotaManager.BaseUserEntity> configUser;
        private final Option<ClientQuotaManager.ClientIdEntity> configClientEntity;
        public final /* synthetic */ ClientQuotaManagerTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String user() {
            return this.user;
        }

        public String clientId() {
            return this.clientId;
        }

        public Option<ClientQuotaManager.BaseUserEntity> configUser() {
            return this.configUser;
        }

        public Option<ClientQuotaManager.ClientIdEntity> configClientEntity() {
            return this.configClientEntity;
        }

        public UserClient copy(String user, String clientId, Option<ClientQuotaManager.BaseUserEntity> configUser, Option<ClientQuotaManager.ClientIdEntity> configClientEntity) {
            return new UserClient(this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer(), user, clientId, configUser, configClientEntity);
        }

        public String copy$default$1() {
            return this.user();
        }

        public String copy$default$2() {
            return this.clientId();
        }

        public Option<ClientQuotaManager.BaseUserEntity> copy$default$3() {
            return this.configUser();
        }

        public Option<ClientQuotaManager.ClientIdEntity> copy$default$4() {
            return this.configClientEntity();
        }

        public String productPrefix() {
            return "UserClient";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.user();
                }
                case 1: {
                    return this.clientId();
                }
                case 2: {
                    return this.configUser();
                }
                case 3: {
                    return this.configClientEntity();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UserClient;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "user";
                }
                case 1: {
                    return "clientId";
                }
                case 2: {
                    return "configUser";
                }
                case 3: {
                    return "configClientEntity";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof UserClient && ((UserClient)x$1).kafka$server$ClientQuotaManagerTest$UserClient$$$outer() == this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer())) break block3;
                    UserClient userClient = (UserClient)x$1;
                    String string = this.user();
                    String string2 = userClient.user();
                    if (string != null ? !string.equals(string2) : string2 != null) break block3;
                    String string3 = this.clientId();
                    String string4 = userClient.clientId();
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
                    Option<ClientQuotaManager.BaseUserEntity> option = this.configUser();
                    Option<ClientQuotaManager.BaseUserEntity> option2 = userClient.configUser();
                    if (option != null ? !option.equals(option2) : option2 != null) break block3;
                    Option<ClientQuotaManager.ClientIdEntity> option3 = this.configClientEntity();
                    Option<ClientQuotaManager.ClientIdEntity> option4 = userClient.configClientEntity();
                    if ((option3 != null ? !option3.equals(option4) : option4 != null) || !userClient.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$UserClient$$$outer() {
            return this.$outer;
        }

        public UserClient(ClientQuotaManagerTest $outer, String user, String clientId, Option<ClientQuotaManager.BaseUserEntity> configUser, Option<ClientQuotaManager.ClientIdEntity> configClientEntity) {
            this.user = user;
            this.clientId = clientId;
            this.configUser = configUser;
            this.configClientEntity = configClientEntity;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

