/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import kafka.server.GroupCoordinatorBaseRequestTest;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterConfigProperty;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.test.api.ClusterTestDefaults;
import org.apache.kafka.common.test.api.Type;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.classic.ClassicGroupState;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=120L)
@ClusterTestDefaults(types={Type.KRAFT}, serverProperties={@ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")})
@ScalaSignature(bytes="\u0006\u0005\u0005eh\u0001\u0002\u0011\"\u0001\u0019B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\u0006s\u0001!\tA\u000f\u0005\u0006{\u0001!\tA\u0010\u0005\u00061\u0002!\tA\u0010\u0005\u0006=\u0002!\tA\u0010\u0005\u0006I\u0002!\tA\u0010\u0005\u0006U\u0002!\tA\u0010\u0005\u0006[\u0002!\tA\u0010\u0005\u0006a\u0002!\tA\u0010\u0005\u0006g\u0002!\tA\u0010\u0005\u0006m\u0002!\tA\u0010\u0005\u0006s\u0002!\tA\u0010\u0005\u0006y\u0002!\tA\u0010\u0005\u0006\u007f\u0002!\tA\u0010\u0005\u0007\u0003\u000b\u0001A\u0011\u0001 \t\r\u0005-\u0001\u0001\"\u0001?\u0011\u0019\t\t\u0002\u0001C\u0001}!1\u0011q\u0003\u0001\u0005\u0002yBa!!\b\u0001\t\u0003q\u0004BBA\u0012\u0001\u0011\u0005a\b\u0003\u0004\u0002*\u0001!\tA\u0010\u0005\u0007\u0003_\u0001A\u0011\u0001 \t\r\u0005U\u0002\u0001\"\u0001?\u0011\u0019\tY\u0004\u0001C\u0005}!1\u0011Q\b\u0001\u0005\nyBa!a\u0010\u0001\t\u0013q\u0004bBA!\u0001\u0011%\u00111\t\u0005\b\u0003\u001f\u0002A\u0011BA)\u0011\u001d\t)\u0006\u0001C\u0005\u0003/Bq!a\"\u0001\t\u0013\tI\tC\u0005\u0002$\u0002\t\n\u0011\"\u0003\u0002&\ni2i\u001c8tk6,'\u000f\u0015:pi>\u001cw\u000e\\'jOJ\fG/[8o)\u0016\u001cHO\u0003\u0002#G\u000511/\u001a:wKJT\u0011\u0001J\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0005\u0005\u0002)S5\t\u0011%\u0003\u0002+C\tyrI]8va\u000e{wN\u001d3j]\u0006$xN\u001d\"bg\u0016\u0014V-];fgR$Vm\u001d;\u0002\u000f\rdWo\u001d;feB\u0011QfN\u0007\u0002])\u0011q\u0006M\u0001\u0005i\u0016\u001cHO\u0003\u00022e\u000511m\\7n_:T!\u0001J\u001a\u000b\u0005Q*\u0014AB1qC\u000eDWMC\u00017\u0003\ry'oZ\u0005\u0003q9\u0012qb\u00117vgR,'/\u00138ti\u0006t7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005mb\u0004C\u0001\u0015\u0001\u0011\u0015Y#\u00011\u0001-\u0003\u0005#Xm\u001d;Va\u001e\u0014\u0018\rZ3Ge>lW)\u001c9us\u000ec\u0017m]:jGR{7i\u001c8tk6,'o\u0012:pkB<\u0016\u000e\u001e5CS\u0012L'/Z2uS>t\u0017\r\u001c)pY&\u001c\u0017\u0010F\u0001@!\t\u00015)D\u0001B\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#B\u0005\u0011)f.\u001b;)\t\r1E*\u0014\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013:\n1!\u00199j\u0013\tY\u0005JA\u0006DYV\u001cH/\u001a:UKN$\u0018\u0001E:feZ,'\u000f\u0015:pa\u0016\u0014H/[3tY\u0005q5&B(S'V3\u0006CA$Q\u0013\t\t\u0006JA\u000bDYV\u001cH/\u001a:D_:4\u0017n\u001a)s_B,'\u000f^=\u0002\u0007-,\u00170I\u0001U\u0003}9'o\\;q]\r|gn];nKJtS.[4sCRLwN\u001c\u0018q_2L7-_\u0001\u0006m\u0006dW/Z\u0011\u0002/\u0006i!-\u001b3je\u0016\u001cG/[8oC2\f1\b^3tiV\u0003xM]1eK\u001a\u0013x.\\#naRL8\t\\1tg&\u001cGk\\\"p]N,X.\u001a:He>,\boV5uQV\u0003xM]1eKB{G.[2zQ\u0011!a\t\u0014.-\u0003m[Sa\u0014*T+r\u000b\u0013!X\u0001\bkB<'/\u00193f\u0003u\"Xm\u001d;Va\u001e\u0014\u0018\rZ3Ge>lW)\u001c9us\u000ec\u0017m]:jGR{7i\u001c8tk6,'o\u0012:pkB<\u0016\u000e\u001e5E_^twM]1eKB{G.[2zQ\u0011)a\t\u00141-\u0003\u0005\\Sa\u0014*T+\n\f\u0013aY\u0001\nI><hn\u001a:bI\u0016\fA\b^3tiV\u0003xM]1eK\u001a\u0013x.\\#naRL8\t\\1tg&\u001cGk\\\"p]N,X.\u001a:He>,\boV5uQ\u0012K7/\u00192mK\u0012\u0004v\u000e\\5ds\"\"aA\u0012'gY\u000597&B(S'VC\u0017%A5\u0002\u0011\u0011L7/\u00192mK\u0012\f1\t^3ti\u0012{wO\\4sC\u0012,gI]8n\u000b6\u0004H/_\"p]N,X.\u001a:U_\u000ec\u0017m]:jG\u001e\u0013x.\u001e9XSRD')\u001b3je\u0016\u001cG/[8oC2\u0004v\u000e\\5ds\"\"qA\u0012'mY\u0005q\u0015!\u0010;fgR$un\u001e8he\u0006$WM\u0012:p[\u0016k\u0007\u000f^=D_:\u001cX/\\3s)>\u001cE.Y:tS\u000e<%o\\;q/&$\b.\u00169he\u0006$W\rU8mS\u000eL\b\u0006\u0002\u0005G\u0019>d\u0013aW\u0001@i\u0016\u001cH\u000fR8x]\u001e\u0014\u0018\rZ3Ge>lW)\u001c9us\u000e{gn];nKJ$vn\u00117bgNL7m\u0012:pkB<\u0016\u000e\u001e5E_^twM]1eKB{G.[2zQ\u0011Ia\t\u0014:-\u0003\u0005\fa\b^3ti\u0012{wO\\4sC\u0012,gI]8n\u000b6\u0004H/_\"p]N,X.\u001a:U_\u000ec\u0017m]:jG\u001e\u0013x.\u001e9XSRDG)[:bE2,G\rU8mS\u000eL\b\u0006\u0002\u0006G\u0019Vd\u0013aZ\u0001Ai\u0016\u001cH/\u00169he\u0006$WM\u0012:p[NKW\u000e\u001d7f\u000fJ|W\u000f\u001d+p\u0007>t7/^7fe\u001e\u0013x.\u001e9XSRD')\u001b3je\u0016\u001cG/[8oC2\u0004v\u000e\\5ds\"\"1B\u0012'yY\u0005q\u0015A\u000f;fgR,\u0006o\u001a:bI\u00164%o\\7TS6\u0004H.Z$s_V\u0004Hk\\\"p]N,X.\u001a:He>,\boV5uQV\u0003xM]1eKB{G.[2zQ\u0011aa\tT>-\u0003m\u000bA\b^3tiV\u0003xM]1eK\u001a\u0013x.\\*j[BdWm\u0012:pkB$vnQ8ogVlWM]$s_V\u0004x+\u001b;i\t><hn\u001a:bI\u0016\u0004v\u000e\\5ds\"\"QB\u0012'\u007fY\u0005\t\u0017a\u000f;fgR,\u0006o\u001a:bI\u00164%o\\7TS6\u0004H.Z$s_V\u0004Hk\\\"p]N,X.\u001a:He>,\boV5uQ\u0012K7/\u00192mK\u0012\u0004v\u000e\\5ds\"*aB\u0012'\u0002\u00041\nq-A uKN$xJ\u001c7j]\u0016l\u0015n\u001a:bi&|gnV5uQ\u0016\u000bw-\u001a:BgNLwM\\7f]R\u001cFO]1uK\u001eL\u0018I\u001c3Es:\fW.[2NK6\u0014WM]:)\u000b=1E*!\u0003-\u00039\u000ba\b^3ti>sG.\u001b8f\u001b&<'/\u0019;j_:<\u0016\u000e\u001e5FC\u001e,'/Q:tS\u001etW.\u001a8u'R\u0014\u0018\r^3hs\u0006sGm\u0015;bi&\u001cW*Z7cKJ\u001c\b&\u0002\tG\u0019\u0006=A&\u0001(\u0002\u000bR,7\u000f^(oY&tW-T5he\u0006$\u0018n\u001c8XSRD7i\\8qKJ\fG/\u001b<f\u0003N\u001c\u0018n\u001a8nK:$8\u000b\u001e:bi\u0016<\u00170\u00118e\tft\u0017-\\5d\u001b\u0016l'-\u001a:tQ\u0015\tb\tTA\u000bY\u0005q\u0015\u0001\u0012;fgR|e\u000e\\5oK6KwM]1uS>tw+\u001b;i\u0007>|\u0007/\u001a:bi&4X-Q:tS\u001etW.\u001a8u'R\u0014\u0018\r^3hs\u0006sGm\u0015;bi&\u001cW*Z7cKJ\u001c\b&\u0002\nG\u0019\u0006mA&\u0001(\u00025Q,7\u000f^+qOJ\fG-Z'jOJ\fG/[8o!>d\u0017nY=)\u000bM1E*!\t-\u0003m\u000bA\u0004^3ti\u0012{wO\\4sC\u0012,W*[4sCRLwN\u001c)pY&\u001c\u0017\u0010K\u0003\u0015\r2\u000b9\u0003L\u0001b\u0003\u0019\"Xm\u001d;Va\u001e\u0014\u0018\rZ3XSRDG)[:bE2,G-T5he\u0006$\u0018n\u001c8Q_2L7-\u001f\u0015\u0006+\u0019c\u0015Q\u0006\u0017\u0002O\u0006AC/Z:u\t><hn\u001a:bI\u0016<\u0016\u000e\u001e5ESN\f'\r\\3e\u001b&<'/\u0019;j_:\u0004v\u000e\\5ds\"*aC\u0012'\u000241\nq-A\u001auKN$xJ\u001c7j]\u0016l\u0015n\u001a:bi&|gnV5uQ:{g.R7qif,6/\u001a:ECR\f\u0017J\\!tg&<g.\\3oi\"*qC\u0012'\u0002:1\na*\u0001\u0016uKN$X\u000b]4sC\u0012,gI]8n\u000b6\u0004H/_\"mCN\u001c\u0018n\u0019+p\u0007>t7/^7fe\u001e\u0013x.\u001e9\u0002YQ,7\u000f\u001e#po:<'/\u00193f\rJ|W.R7qif\u001cuN\\:v[\u0016\u0014Hk\\\"mCN\u001c\u0018nY$s_V\u0004\u0018!\u000b;fgR,\u0006o\u001a:bI\u00164%o\\7TS6\u0004H.Z$s_V\u0004Hk\\\"p]N,X.\u001a:He>,\b/\u0001\u0018uKN$xJ\u001c7j]\u0016l\u0015n\u001a:bi&|gnV5uQ\u0016\u000bw-\u001a:BgNLwM\\7f]R\u001cFO]1uK\u001eLHcA \u0002F!9\u0011qI\u000eA\u0002\u0005%\u0013\u0001E;tKN#\u0018\r^5d\u001b\u0016l'-\u001a:t!\r\u0001\u00151J\u0005\u0004\u0003\u001b\n%a\u0002\"p_2,\u0017M\\\u00015i\u0016\u001cHo\u00148mS:,W*[4sCRLwN\\,ji\"\u001cun\u001c9fe\u0006$\u0018N^3BgNLwM\\7f]R\u001cFO]1uK\u001eLHcA \u0002T!9\u0011q\t\u000fA\u0002\u0005%\u0013\u0001C7fi\u0006$\u0017\r^1\u0015\t\u0005e\u0013Q\r\t\u0006\u0001\u0006m\u0013qL\u0005\u0004\u0003;\n%!B!se\u0006L\bc\u0001!\u0002b%\u0019\u00111M!\u0003\t\tKH/\u001a\u0005\b\u0003Oj\u0002\u0019AA5\u0003=ywO\\3e!\u0006\u0014H/\u001b;j_:\u001c\bCBA6\u0003w\n\tI\u0004\u0003\u0002n\u0005]d\u0002BA8\u0003kj!!!\u001d\u000b\u0007\u0005MT%\u0001\u0004=e>|GOP\u0005\u0002\u0005&\u0019\u0011\u0011P!\u0002\u000fA\f7m[1hK&!\u0011QPA@\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005e\u0014\tE\u0002A\u0003\u0007K1!!\"B\u0005\rIe\u000e^\u0001\u000bCN\u001c\u0018n\u001a8nK:$HCBA-\u0003\u0017\u000by\tC\u0004\u0002\u000ez\u0001\r!!\u001b\u0002%\u0005\u001c8/[4oK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0005\n\u0003#s\u0002\u0013!a\u0001\u0003'\u000b\u0001\"^:fe\u0012\u000bG/\u0019\t\u0005\u0003+\u000by*\u0004\u0002\u0002\u0018*!\u0011\u0011TAN\u0003\rq\u0017n\u001c\u0006\u0003\u0003;\u000bAA[1wC&!\u0011\u0011UAL\u0005)\u0011\u0015\u0010^3Ck\u001a4WM]\u0001\u0015CN\u001c\u0018n\u001a8nK:$H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u001d&\u0006BAJ\u0003S[#!a+\u0011\t\u00055\u0016qW\u0007\u0003\u0003_SA!!-\u00024\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003k\u000b\u0015AC1o]>$\u0018\r^5p]&!\u0011\u0011XAX\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0015\u0007\u0001\u0005uV+a4\u0011\t\u0005}\u00161Z\u0007\u0003\u0003\u0003T1!SAb\u0015\u0011\t)-a2\u0002\u000f),\b/\u001b;fe*\u0019\u0011\u0011Z\u001b\u0002\u000b),h.\u001b;\n\t\u00055\u0017\u0011\u0019\u0002\b)&lWm\\;u=\u0005A\bF\u0003\u0001\u0002T\u0006e\u00171\u001c'\u0002hB\u0019q)!6\n\u0007\u0005]\u0007JA\nDYV\u001cH/\u001a:UKN$H)\u001a4bk2$8/A\u0003usB,7\u000f\f\u0002\u0002^\u0012\u0012\u0011q\\\u0005\u0005\u0003C\f\u0019/A\u0003L%\u00063EKC\u0002\u0002f\"\u000bA\u0001V=qK2\"\u0011\u0011^AzW\u001dy%+a;V\u0003_\f#!!<\u00029=4gm]3ug:\"x\u000e]5d]9,XN\f9beRLG/[8og\u0006\u0012\u0011\u0011_\u0001\u0002c-:qJUA{+\u0006=\u0018EAA|\u0003\u0001zgMZ:fiNtCo\u001c9jG:\u0012X\r\u001d7jG\u0006$\u0018n\u001c8/M\u0006\u001cGo\u001c:")
public class ConsumerProtocolMigrationTest
extends GroupCoordinatorBaseRequestTest {
    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.consumer.migration.policy", value="bidirectional")})
    public void testUpgradeFromEmptyClassicToConsumerGroupWithBidirectionalPolicy() {
        this.testUpgradeFromEmptyClassicToConsumerGroup();
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.consumer.migration.policy", value="upgrade")})
    public void testUpgradeFromEmptyClassicToConsumerGroupWithUpgradePolicy() {
        this.testUpgradeFromEmptyClassicToConsumerGroup();
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.consumer.migration.policy", value="downgrade")})
    public void testUpgradeFromEmptyClassicToConsumerGroupWithDowngradePolicy() {
        this.testUpgradeFromEmptyClassicToConsumerGroup();
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.consumer.migration.policy", value="disabled")})
    public void testUpgradeFromEmptyClassicToConsumerGroupWithDisabledPolicy() {
        this.testUpgradeFromEmptyClassicToConsumerGroup();
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.consumer.migration.policy", value="bidirectional")})
    public void testDowngradeFromEmptyConsumerToClassicGroupWithBidirectionalPolicy() {
        this.testDowngradeFromEmptyConsumerToClassicGroup();
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.consumer.migration.policy", value="upgrade")})
    public void testDowngradeFromEmptyConsumerToClassicGroupWithUpgradePolicy() {
        this.testDowngradeFromEmptyConsumerToClassicGroup();
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.consumer.migration.policy", value="downgrade")})
    public void testDowngradeFromEmptyConsumerToClassicGroupWithDowngradePolicy() {
        this.testDowngradeFromEmptyConsumerToClassicGroup();
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.consumer.migration.policy", value="disabled")})
    public void testDowngradeFromEmptyConsumerToClassicGroupWithDisabledPolicy() {
        this.testDowngradeFromEmptyConsumerToClassicGroup();
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.consumer.migration.policy", value="bidirectional")})
    public void testUpgradeFromSimpleGroupToConsumerGroupWithBidirectionalPolicy() {
        this.testUpgradeFromSimpleGroupToConsumerGroup();
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.consumer.migration.policy", value="upgrade")})
    public void testUpgradeFromSimpleGroupToConsumerGroupWithUpgradePolicy() {
        this.testUpgradeFromSimpleGroupToConsumerGroup();
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.consumer.migration.policy", value="downgrade")})
    public void testUpgradeFromSimpleGroupToConsumerGroupWithDowngradePolicy() {
        this.testUpgradeFromSimpleGroupToConsumerGroup();
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.consumer.migration.policy", value="disabled")})
    public void testUpgradeFromSimpleGroupToConsumerGroupWithDisabledPolicy() {
        this.testUpgradeFromSimpleGroupToConsumerGroup();
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.consumer.migration.policy", value="bidirectional")})
    public void testOnlineMigrationWithEagerAssignmentStrategyAndDynamicMembers() {
        this.testOnlineMigrationWithEagerAssignmentStrategy(false);
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.consumer.migration.policy", value="bidirectional")})
    public void testOnlineMigrationWithEagerAssignmentStrategyAndStaticMembers() {
        this.testOnlineMigrationWithEagerAssignmentStrategy(true);
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.consumer.migration.policy", value="bidirectional")})
    public void testOnlineMigrationWithCooperativeAssignmentStrategyAndDynamicMembers() {
        this.testOnlineMigrationWithCooperativeAssignmentStrategy(false);
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.consumer.migration.policy", value="bidirectional")})
    public void testOnlineMigrationWithCooperativeAssignmentStrategyAndStaticMembers() {
        this.testOnlineMigrationWithCooperativeAssignmentStrategy(true);
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.consumer.migration.policy", value="upgrade")})
    public void testUpgradeMigrationPolicy() {
        this.createOffsetsTopic();
        this.createTopic("foo", 3);
        String groupId = "grp";
        this.joinDynamicConsumerGroupWithOldProtocol(groupId, this.metadata((List<Object>)package$.MODULE$.List().empty()), this.assignment((List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), null), this.joinDynamicConsumerGroupWithOldProtocol$default$4());
        String x$2 = Uuid.randomUuid().toString();
        .colon.colon x$4 = new .colon.colon((Object)"foo", (List)Nil$.MODULE$);
        List x$5 = package$.MODULE$.List().empty();
        int x$7 = this.consumerGroupHeartbeat$default$3();
        String x$8 = this.consumerGroupHeartbeat$default$4();
        String x$9 = this.consumerGroupHeartbeat$default$5();
        String x$10 = this.consumerGroupHeartbeat$default$7();
        short x$11 = this.consumerGroupHeartbeat$default$11();
        String memberId2 = this.consumerGroupHeartbeat(groupId, x$2, x$7, x$8, x$9, 300000, x$10, (List<String>)x$4, (List<ConsumerGroupHeartbeatRequestData.TopicPartitions>)x$5, Errors.NONE, x$11).memberId();
        Assertions.assertEquals((Object)new .colon.colon((Object)new ListGroupsResponseData.ListedGroup().setGroupId(groupId).setProtocolType("consumer").setGroupState(ConsumerGroup.ConsumerGroupState.RECONCILING.toString()).setGroupType(Group.GroupType.CONSUMER.toString()), (List)Nil$.MODULE$), this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)new .colon.colon((Object)Group.GroupType.CONSUMER.toString(), (List)Nil$.MODULE$), this.listGroups$default$3()));
        this.leaveGroupWithNewProtocol(groupId, memberId2);
        Assertions.assertEquals((Object)new .colon.colon((Object)new ListGroupsResponseData.ListedGroup().setGroupId(groupId).setProtocolType("consumer").setGroupState(ConsumerGroup.ConsumerGroupState.ASSIGNING.toString()).setGroupType(Group.GroupType.CONSUMER.toString()), (List)Nil$.MODULE$), this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)new .colon.colon((Object)Group.GroupType.CONSUMER.toString(), (List)Nil$.MODULE$), this.listGroups$default$3()));
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.consumer.migration.policy", value="downgrade")})
    public void testDowngradeMigrationPolicy() {
        void var3_3;
        this.createOffsetsTopic();
        this.createTopic("foo", 3);
        String groupId = "grp";
        Tuple2<String, Object> tuple2 = this.joinConsumerGroupWithNewProtocol(groupId, Uuid.randomUuid().toString());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String memberId1 = (String)tuple2._1();
        String x$2 = this.sendJoinRequest(groupId, this.sendJoinRequest$default$2(), this.sendJoinRequest$default$3(), this.sendJoinRequest$default$4(), this.sendJoinRequest$default$5(), this.sendJoinRequest$default$6(), this.sendJoinRequest$default$7()).memberId();
        byte[] x$3 = this.metadata((List<Object>)package$.MODULE$.List().empty());
        String x$4 = this.sendJoinRequest$default$3();
        String x$5 = this.sendJoinRequest$default$4();
        String x$6 = this.sendJoinRequest$default$5();
        short x$7 = this.sendJoinRequest$default$7();
        String memberId2 = this.sendJoinRequest(groupId, x$2, x$4, x$5, x$6, x$3, x$7).memberId();
        Assertions.assertEquals((Object)new SyncGroupResponseData().setErrorCode(Errors.NONE.code()).setProtocolType("consumer").setProtocolName("consumer-range").setAssignment(this.assignment((List<Object>)package$.MODULE$.List().empty(), null)), (Object)this.syncGroupWithOldProtocol(groupId, memberId2, 2, this.syncGroupWithOldProtocol$default$4(), this.syncGroupWithOldProtocol$default$5(), this.syncGroupWithOldProtocol$default$6(), this.syncGroupWithOldProtocol$default$7()));
        this.heartbeat(groupId, 2, memberId2, this.heartbeat$default$4(), this.heartbeat$default$5(), this.heartbeat$default$6());
        .colon.colon x$11 = new .colon.colon((Object)"foo", (List)Nil$.MODULE$);
        List x$12 = package$.MODULE$.List().empty();
        int x$14 = this.consumerGroupHeartbeat$default$3();
        String x$15 = this.consumerGroupHeartbeat$default$4();
        String x$16 = this.consumerGroupHeartbeat$default$5();
        String x$17 = this.consumerGroupHeartbeat$default$7();
        short x$18 = this.consumerGroupHeartbeat$default$11();
        this.consumerGroupHeartbeat(groupId, (String)var3_3, x$14, x$15, x$16, 300000, x$17, (List<String>)x$11, (List<ConsumerGroupHeartbeatRequestData.TopicPartitions>)x$12, Errors.NONE, x$18);
        String x$23 = this.heartbeat$default$4();
        short x$24 = this.heartbeat$default$6();
        this.heartbeat(groupId, 2, memberId2, x$23, Errors.REBALANCE_IN_PROGRESS, x$24);
        this.leaveGroupWithNewProtocol(groupId, (String)var3_3);
        Assertions.assertEquals((Object)new .colon.colon((Object)new ListGroupsResponseData.ListedGroup().setGroupId(groupId).setProtocolType("consumer").setGroupState(ClassicGroupState.PREPARING_REBALANCE.toString()).setGroupType(Group.GroupType.CLASSIC.toString()), (List)Nil$.MODULE$), this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)new .colon.colon((Object)Group.GroupType.CLASSIC.toString(), (List)Nil$.MODULE$), this.listGroups$default$3()));
        .colon.colon x$28 = new .colon.colon((Object)"foo", (List)Nil$.MODULE$);
        List x$29 = package$.MODULE$.List().empty();
        int x$31 = this.consumerGroupHeartbeat$default$3();
        String x$32 = this.consumerGroupHeartbeat$default$4();
        String x$33 = this.consumerGroupHeartbeat$default$5();
        String x$34 = this.consumerGroupHeartbeat$default$7();
        short x$35 = this.consumerGroupHeartbeat$default$11();
        this.consumerGroupHeartbeat(groupId, (String)var3_3, x$31, x$32, x$33, 300000, x$34, (List<String>)x$28, (List<ConsumerGroupHeartbeatRequestData.TopicPartitions>)x$29, Errors.GROUP_ID_NOT_FOUND, x$35);
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.consumer.migration.policy", value="disabled")})
    public void testUpgradeWithDisabledMigrationPolicy() {
        this.createOffsetsTopic();
        this.createTopic("foo", 3);
        String groupId = "grp";
        this.joinDynamicConsumerGroupWithOldProtocol(groupId, this.metadata((List<Object>)package$.MODULE$.List().empty()), this.assignment((List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), null), this.joinDynamicConsumerGroupWithOldProtocol$default$4());
        String x$2 = Uuid.randomUuid().toString();
        .colon.colon x$4 = new .colon.colon((Object)"foo", (List)Nil$.MODULE$);
        List x$5 = package$.MODULE$.List().empty();
        int x$7 = this.consumerGroupHeartbeat$default$3();
        String x$8 = this.consumerGroupHeartbeat$default$4();
        String x$9 = this.consumerGroupHeartbeat$default$5();
        String x$10 = this.consumerGroupHeartbeat$default$7();
        short x$11 = this.consumerGroupHeartbeat$default$11();
        this.consumerGroupHeartbeat(groupId, x$2, x$7, x$8, x$9, 300000, x$10, (List<String>)x$4, (List<ConsumerGroupHeartbeatRequestData.TopicPartitions>)x$5, Errors.GROUP_ID_NOT_FOUND, x$11);
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.consumer.migration.policy", value="disabled")})
    public void testDowngradeWithDisabledMigrationPolicy() {
        void var3_3;
        this.createOffsetsTopic();
        this.createTopic("foo", 3);
        String groupId = "grp";
        Tuple2<String, Object> tuple2 = this.joinConsumerGroupWithNewProtocol(groupId, Uuid.randomUuid().toString());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String memberId1 = (String)tuple2._1();
        String x$2 = this.sendJoinRequest(groupId, this.sendJoinRequest$default$2(), this.sendJoinRequest$default$3(), this.sendJoinRequest$default$4(), this.sendJoinRequest$default$5(), this.sendJoinRequest$default$6(), this.sendJoinRequest$default$7()).memberId();
        byte[] x$3 = this.metadata((List<Object>)package$.MODULE$.List().empty());
        String x$4 = this.sendJoinRequest$default$3();
        String x$5 = this.sendJoinRequest$default$4();
        String x$6 = this.sendJoinRequest$default$5();
        short x$7 = this.sendJoinRequest$default$7();
        this.sendJoinRequest(groupId, x$2, x$4, x$5, x$6, x$3, x$7);
        this.leaveGroupWithNewProtocol(groupId, (String)var3_3);
        Assertions.assertEquals((Object)new .colon.colon((Object)new ListGroupsResponseData.ListedGroup().setGroupId(groupId).setProtocolType("consumer").setGroupState(ConsumerGroup.ConsumerGroupState.ASSIGNING.toString()).setGroupType(Group.GroupType.CONSUMER.toString()), (List)Nil$.MODULE$), this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)new .colon.colon((Object)Group.GroupType.CONSUMER.toString(), (List)Nil$.MODULE$), this.listGroups$default$3()));
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.consumer.migration.policy", value="bidirectional")})
    public void testOnlineMigrationWithNonEmptyUserDataInAssignment() {
        this.createOffsetsTopic();
        this.createTopic("foo", 3);
        String groupId = "grp";
        String memberId1 = (String)this.joinDynamicConsumerGroupWithOldProtocol(groupId, this.metadata((List<Object>)package$.MODULE$.List().empty()), this.assignment((List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), ByteBuffer.allocate(1)), this.joinDynamicConsumerGroupWithOldProtocol$default$4())._1();
        String x$2 = Uuid.randomUuid().toString();
        .colon.colon x$4 = new .colon.colon((Object)"foo", (List)Nil$.MODULE$);
        List x$5 = package$.MODULE$.List().empty();
        int x$7 = this.consumerGroupHeartbeat$default$3();
        String x$8 = this.consumerGroupHeartbeat$default$4();
        String x$9 = this.consumerGroupHeartbeat$default$5();
        String x$10 = this.consumerGroupHeartbeat$default$7();
        short x$11 = this.consumerGroupHeartbeat$default$11();
        String errorMessage = this.consumerGroupHeartbeat(groupId, x$2, x$7, x$8, x$9, 300000, x$10, (List<String>)x$4, (List<ConsumerGroupHeartbeatRequestData.TopicPartitions>)x$5, Errors.GROUP_ID_NOT_FOUND, x$11).errorMessage();
        Assertions.assertEquals((Object)"Cannot upgrade classic group grp to consumer group because an unsupported custom assignor is in use. Please refer to the documentation or switch to a default assignor before re-attempting the upgrade.", (Object)errorMessage);
        Assertions.assertEquals((Object)new .colon.colon((Object)new ListGroupsResponseData.ListedGroup().setGroupId(groupId).setProtocolType("consumer").setGroupState(ClassicGroupState.STABLE.toString()).setGroupType(Group.GroupType.CLASSIC.toString()), (List)Nil$.MODULE$), this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)new .colon.colon((Object)Group.GroupType.CLASSIC.toString(), (List)Nil$.MODULE$), this.listGroups$default$3()));
        this.leaveGroup(groupId, memberId1, false, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
        Assertions.assertEquals((Object)new .colon.colon((Object)new ListGroupsResponseData.ListedGroup().setGroupId(groupId).setProtocolType("consumer").setGroupState(ClassicGroupState.EMPTY.toString()).setGroupType(Group.GroupType.CLASSIC.toString()), (List)Nil$.MODULE$), this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)new .colon.colon((Object)Group.GroupType.CLASSIC.toString(), (List)Nil$.MODULE$), this.listGroups$default$3()));
        String x$13 = Uuid.randomUuid().toString();
        .colon.colon x$15 = new .colon.colon((Object)"foo", (List)Nil$.MODULE$);
        List x$16 = package$.MODULE$.List().empty();
        int x$18 = this.consumerGroupHeartbeat$default$3();
        String x$19 = this.consumerGroupHeartbeat$default$4();
        String x$20 = this.consumerGroupHeartbeat$default$5();
        String x$21 = this.consumerGroupHeartbeat$default$7();
        short x$22 = this.consumerGroupHeartbeat$default$11();
        this.consumerGroupHeartbeat(groupId, x$13, x$18, x$19, x$20, 300000, x$21, (List<String>)x$15, (List<ConsumerGroupHeartbeatRequestData.TopicPartitions>)x$16, Errors.NONE, x$22);
        Assertions.assertEquals((Object)new .colon.colon((Object)new ListGroupsResponseData.ListedGroup().setGroupId(groupId).setProtocolType("consumer").setGroupState(ConsumerGroup.ConsumerGroupState.STABLE.toString()).setGroupType(Group.GroupType.CONSUMER.toString()), (List)Nil$.MODULE$), this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)new .colon.colon((Object)Group.GroupType.CONSUMER.toString(), (List)Nil$.MODULE$), this.listGroups$default$3()));
    }

    /*
     * WARNING - void declaration
     */
    private void testUpgradeFromEmptyClassicToConsumerGroup() {
        void var3_3;
        this.createOffsetsTopic();
        this.createTopic("foo", 3);
        String groupId = "grp";
        Tuple2<String, Object> tuple2 = this.joinDynamicConsumerGroupWithOldProtocol(groupId, this.joinDynamicConsumerGroupWithOldProtocol$default$2(), this.joinDynamicConsumerGroupWithOldProtocol$default$3(), this.joinDynamicConsumerGroupWithOldProtocol$default$4());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String memberId = (String)tuple2._1();
        this.leaveGroup(groupId, (String)var3_3, false, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
        Assertions.assertEquals((Object)new .colon.colon((Object)new ListGroupsResponseData.ListedGroup().setGroupId(groupId).setProtocolType("consumer").setGroupState(ClassicGroupState.EMPTY.toString()).setGroupType(Group.GroupType.CLASSIC.toString()), (List)Nil$.MODULE$), this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)new .colon.colon((Object)Group.GroupType.CLASSIC.toString(), (List)Nil$.MODULE$), this.listGroups$default$3()));
        .colon.colon x$4 = new .colon.colon((Object)"foo", (List)Nil$.MODULE$);
        List x$5 = package$.MODULE$.List().empty();
        int x$7 = this.consumerGroupHeartbeat$default$3();
        String x$8 = this.consumerGroupHeartbeat$default$4();
        String x$9 = this.consumerGroupHeartbeat$default$5();
        String x$10 = this.consumerGroupHeartbeat$default$7();
        short x$11 = this.consumerGroupHeartbeat$default$11();
        this.consumerGroupHeartbeat(groupId, (String)var3_3, x$7, x$8, x$9, 300000, x$10, (List<String>)x$4, (List<ConsumerGroupHeartbeatRequestData.TopicPartitions>)x$5, Errors.NONE, x$11);
        Assertions.assertEquals((Object)new .colon.colon((Object)new ListGroupsResponseData.ListedGroup().setGroupId(groupId).setProtocolType("consumer").setGroupState(ConsumerGroup.ConsumerGroupState.STABLE.toString()).setGroupType(Group.GroupType.CONSUMER.toString()), (List)Nil$.MODULE$), this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)new .colon.colon((Object)Group.GroupType.CONSUMER.toString(), (List)Nil$.MODULE$), this.listGroups$default$3()));
    }

    /*
     * WARNING - void declaration
     */
    private void testDowngradeFromEmptyConsumerToClassicGroup() {
        void var3_3;
        this.createOffsetsTopic();
        this.createTopic("foo", 3);
        String groupId = "grp";
        Tuple2<String, Object> tuple2 = this.joinConsumerGroupWithNewProtocol(groupId, Uuid.randomUuid().toString());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String memberId = (String)tuple2._1();
        this.leaveGroup(groupId, (String)var3_3, true, ApiKeys.CONSUMER_GROUP_HEARTBEAT.latestVersion(this.isUnstableApiEnabled()));
        Assertions.assertEquals((Object)new .colon.colon((Object)new ListGroupsResponseData.ListedGroup().setGroupId(groupId).setProtocolType("consumer").setGroupState(ClassicGroupState.EMPTY.toString()).setGroupType(Group.GroupType.CONSUMER.toString()), (List)Nil$.MODULE$), this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)new .colon.colon((Object)Group.GroupType.CONSUMER.toString(), (List)Nil$.MODULE$), this.listGroups$default$3()));
        this.joinDynamicConsumerGroupWithOldProtocol(groupId, this.joinDynamicConsumerGroupWithOldProtocol$default$2(), this.joinDynamicConsumerGroupWithOldProtocol$default$3(), this.joinDynamicConsumerGroupWithOldProtocol$default$4());
        Assertions.assertEquals((Object)new .colon.colon((Object)new ListGroupsResponseData.ListedGroup().setGroupId(groupId).setProtocolType("consumer").setGroupState(ClassicGroupState.STABLE.toString()).setGroupType(Group.GroupType.CLASSIC.toString()), (List)Nil$.MODULE$), this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)new .colon.colon((Object)Group.GroupType.CLASSIC.toString(), (List)Nil$.MODULE$), this.listGroups$default$3()));
    }

    private void testUpgradeFromSimpleGroupToConsumerGroup() {
        this.createOffsetsTopic();
        String topicName = "foo";
        Uuid topicId = this.createTopic(topicName, 3);
        String groupId = "group-id";
        this.commitOffset(groupId, "member-id", -1, topicName, topicId, 0, 1000L, Errors.NONE, ApiKeys.OFFSET_COMMIT.latestVersion(this.isUnstableApiEnabled()));
        Assertions.assertEquals((Object)new .colon.colon((Object)new ListGroupsResponseData.ListedGroup().setGroupId(groupId).setGroupState(ClassicGroupState.EMPTY.toString()).setGroupType(Group.GroupType.CLASSIC.toString()), (List)Nil$.MODULE$), this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)new .colon.colon((Object)Group.GroupType.CLASSIC.toString(), (List)Nil$.MODULE$), this.listGroups$default$3()));
        String x$2 = Uuid.randomUuid().toString();
        .colon.colon x$4 = new .colon.colon((Object)topicName, (List)Nil$.MODULE$);
        List x$5 = package$.MODULE$.List().empty();
        int x$7 = this.consumerGroupHeartbeat$default$3();
        String x$8 = this.consumerGroupHeartbeat$default$4();
        String x$9 = this.consumerGroupHeartbeat$default$5();
        String x$10 = this.consumerGroupHeartbeat$default$7();
        short x$11 = this.consumerGroupHeartbeat$default$11();
        this.consumerGroupHeartbeat(groupId, x$2, x$7, x$8, x$9, 300000, x$10, (List<String>)x$4, (List<ConsumerGroupHeartbeatRequestData.TopicPartitions>)x$5, Errors.NONE, x$11);
        Assertions.assertEquals((Object)new .colon.colon((Object)new ListGroupsResponseData.ListedGroup().setGroupId(groupId).setProtocolType("consumer").setGroupState(ConsumerGroup.ConsumerGroupState.STABLE.toString()).setGroupType(Group.GroupType.CONSUMER.toString()), (List)Nil$.MODULE$), this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)new .colon.colon((Object)Group.GroupType.CONSUMER.toString(), (List)Nil$.MODULE$), this.listGroups$default$3()));
    }

    private void testOnlineMigrationWithEagerAssignmentStrategy(boolean useStaticMembers) {
        this.createOffsetsTopic();
        Uuid topicId = this.createTopic("foo", 3);
        String groupId = "grp";
        String instanceId1 = "instance-id-1";
        String instanceId2 = "instance-id-2";
        ObjectRef memberId1 = ObjectRef.create(null);
        memberId1.elem = !useStaticMembers ? (String)this.joinDynamicConsumerGroupWithOldProtocol(groupId, this.metadata((List<Object>)package$.MODULE$.List().empty()), this.assignment((List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), this.assignment$default$2()), this.joinDynamicConsumerGroupWithOldProtocol$default$4())._1() : (String)this.joinStaticConsumerGroupWithOldProtocol(groupId, instanceId1, this.metadata((List<Object>)package$.MODULE$.List().empty()), this.assignment((List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), this.assignment$default$2()), this.joinStaticConsumerGroupWithOldProtocol$default$5())._1();
        String x$2 = Uuid.randomUuid().toString();
        String x$3 = useStaticMembers ? instanceId2 : null;
        .colon.colon x$5 = new .colon.colon((Object)"foo", (List)Nil$.MODULE$);
        List x$6 = package$.MODULE$.List().empty();
        int x$8 = this.consumerGroupHeartbeat$default$3();
        String x$9 = this.consumerGroupHeartbeat$default$5();
        String x$10 = this.consumerGroupHeartbeat$default$7();
        short x$11 = this.consumerGroupHeartbeat$default$11();
        String memberId2 = this.consumerGroupHeartbeat(groupId, x$2, x$8, x$3, x$9, 300000, x$10, (List<String>)x$5, (List<ConsumerGroupHeartbeatRequestData.TopicPartitions>)x$6, Errors.NONE, x$11).memberId();
        Assertions.assertEquals((Object)new .colon.colon((Object)new ListGroupsResponseData.ListedGroup().setGroupId(groupId).setProtocolType("consumer").setGroupState(ConsumerGroup.ConsumerGroupState.RECONCILING.toString()).setGroupType(Group.GroupType.CONSUMER.toString()), (List)Nil$.MODULE$), this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)new .colon.colon((Object)Group.GroupType.CONSUMER.toString(), (List)Nil$.MODULE$), this.listGroups$default$3()));
        String x$14 = (String)memberId1.elem;
        String x$16 = this.heartbeat$default$4();
        short x$17 = this.heartbeat$default$6();
        this.heartbeat(groupId, 2, x$14, x$16, Errors.ILLEGAL_GENERATION, x$17);
        String x$22 = this.heartbeat$default$4();
        short x$23 = this.heartbeat$default$6();
        this.heartbeat(groupId, 1, "unknown-member-id", x$22, Errors.UNKNOWN_MEMBER_ID, x$23);
        String x$26 = (String)memberId1.elem;
        String x$28 = this.heartbeat$default$4();
        short x$29 = this.heartbeat$default$6();
        this.heartbeat("unknown-group-id", 1, x$26, x$28, Errors.UNKNOWN_MEMBER_ID, x$29);
        String x$34 = this.heartbeat$default$4();
        short x$35 = this.heartbeat$default$6();
        this.heartbeat(groupId, 1, memberId2, x$34, Errors.UNKNOWN_MEMBER_ID, x$35);
        String x$38 = (String)memberId1.elem;
        String x$40 = this.heartbeat$default$4();
        short x$41 = this.heartbeat$default$6();
        this.heartbeat(groupId, 1, x$38, x$40, Errors.REBALANCE_IN_PROGRESS, x$41);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.OFFSET_COMMIT.oldestVersion()), (int)ApiKeys.OFFSET_COMMIT.latestVersion(this.isUnstableApiEnabled())).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partitionId -> this.commitOffset(groupId, (String)memberId1$1.elem, 1, "foo", topicId, partitionId, 100L + (long)(10 * version) + (long)partitionId, Errors.NONE, (short)version)));
        long committedOffset = 100L + (long)(10 * ApiKeys.OFFSET_COMMIT.latestVersion(this.isUnstableApiEnabled()));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), (int)ApiKeys.OFFSET_FETCH.latestVersion(this.isUnstableApiEnabled())).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> Assertions.assertEquals((Object)new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(groupId).setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(version < 10 ? "foo" : "").setTopicId(version >= 10 ? topicId : Uuid.ZERO_UUID).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(0).setCommittedOffset(committedOffset), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(1).setCommittedOffset(committedOffset + 1L), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(2).setCommittedOffset(committedOffset + 2L), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$)).asJava()), (Object)this.fetchOffsets(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(groupId).setMemberId((String)memberId1$1.elem).setMemberEpoch(1).setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchRequestData.OffsetFetchRequestTopics().setName("foo").setTopicId(topicId).setPartitionIndexes(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$)).asJava()), false, (short)version)));
        String x$43 = (String)memberId1.elem;
        byte[] x$44 = this.metadata((List<Object>)package$.MODULE$.List().empty());
        String x$46 = this.sendJoinRequest$default$3();
        String x$47 = this.sendJoinRequest$default$5();
        short x$48 = this.sendJoinRequest$default$7();
        Assertions.assertEquals((Object)new JoinGroupResponseData().setProtocolName(null).setErrorCode(Errors.INCONSISTENT_GROUP_PROTOCOL.code()), (Object)this.sendJoinRequest(groupId, x$43, x$46, "connect", x$47, x$44, x$48));
        String x$50 = (String)memberId1.elem;
        byte[] x$51 = this.metadata((List<Object>)package$.MODULE$.List().empty());
        String x$52 = this.sendJoinRequest$default$3();
        String x$53 = this.sendJoinRequest$default$4();
        String x$54 = this.sendJoinRequest$default$5();
        short x$55 = this.sendJoinRequest$default$7();
        Assertions.assertEquals((Object)new JoinGroupResponseData().setGenerationId(2).setProtocolType("consumer").setProtocolName("consumer-range").setMemberId((String)memberId1.elem), (Object)this.sendJoinRequest(groupId, x$50, x$52, x$53, x$54, x$51, x$55));
        byte[] x$58 = this.metadata((List<Object>)package$.MODULE$.List().empty());
        String x$60 = this.sendJoinRequest$default$3();
        String x$61 = this.sendJoinRequest$default$4();
        short x$62 = this.sendJoinRequest$default$7();
        Assertions.assertEquals((Object)new JoinGroupResponseData().setProtocolName(null).setErrorCode(Errors.INCONSISTENT_GROUP_PROTOCOL.code()), (Object)this.sendJoinRequest(groupId, "new-member", x$60, x$61, "consumer-roundrobin", x$58, x$62));
        .colon.colon x$67 = new .colon.colon((Object)"foo", (List)Nil$.MODULE$);
        List x$68 = package$.MODULE$.List().empty();
        String x$70 = this.consumerGroupHeartbeat$default$4();
        String x$71 = this.consumerGroupHeartbeat$default$5();
        String x$72 = this.consumerGroupHeartbeat$default$7();
        short x$73 = this.consumerGroupHeartbeat$default$11();
        java.util.List partitionsOfMember2 = ((ConsumerGroupHeartbeatResponseData.TopicPartitions)this.consumerGroupHeartbeat(groupId, memberId2, 2, x$70, x$71, 300000, x$72, (List<String>)x$67, (List<ConsumerGroupHeartbeatRequestData.TopicPartitions>)x$68, Errors.NONE, x$73).assignment().topicPartitions().get(0)).partitions();
        Assertions.assertEquals((Object)new .colon.colon((Object)new ListGroupsResponseData.ListedGroup().setGroupId(groupId).setProtocolType("consumer").setGroupState(ConsumerGroup.ConsumerGroupState.STABLE.toString()).setGroupType(Group.GroupType.CONSUMER.toString()), (List)Nil$.MODULE$), this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)new .colon.colon((Object)Group.GroupType.CONSUMER.toString(), (List)Nil$.MODULE$), this.listGroups$default$3()));
        String x$75 = (String)memberId1.elem;
        String x$80 = this.verifySyncGroupWithOldProtocol$default$4();
        String x$81 = this.verifySyncGroupWithOldProtocol$default$5();
        List<SyncGroupRequestData.SyncGroupRequestAssignment> x$82 = this.verifySyncGroupWithOldProtocol$default$6();
        byte[] x$83 = this.verifySyncGroupWithOldProtocol$default$9();
        short x$84 = this.verifySyncGroupWithOldProtocol$default$11();
        this.verifySyncGroupWithOldProtocol(groupId, x$75, 1, x$80, x$81, x$82, null, null, x$83, Errors.ILLEGAL_GENERATION, x$84);
        String x$86 = (String)memberId1.elem;
        String x$91 = this.verifySyncGroupWithOldProtocol$default$4();
        String x$92 = this.verifySyncGroupWithOldProtocol$default$5();
        List<SyncGroupRequestData.SyncGroupRequestAssignment> x$93 = this.verifySyncGroupWithOldProtocol$default$6();
        byte[] x$94 = this.verifySyncGroupWithOldProtocol$default$9();
        short x$95 = this.verifySyncGroupWithOldProtocol$default$11();
        this.verifySyncGroupWithOldProtocol("unknown-group-id", x$86, 2, x$91, x$92, x$93, null, null, x$94, Errors.UNKNOWN_MEMBER_ID, x$95);
        String x$102 = this.verifySyncGroupWithOldProtocol$default$4();
        String x$103 = this.verifySyncGroupWithOldProtocol$default$5();
        List<SyncGroupRequestData.SyncGroupRequestAssignment> x$104 = this.verifySyncGroupWithOldProtocol$default$6();
        byte[] x$105 = this.verifySyncGroupWithOldProtocol$default$9();
        short x$106 = this.verifySyncGroupWithOldProtocol$default$11();
        this.verifySyncGroupWithOldProtocol(groupId, "unknown-member-id", 2, x$102, x$103, x$104, null, null, x$105, Errors.UNKNOWN_MEMBER_ID, x$106);
        String x$108 = (String)memberId1.elem;
        String x$114 = this.verifySyncGroupWithOldProtocol$default$5();
        List<SyncGroupRequestData.SyncGroupRequestAssignment> x$115 = this.verifySyncGroupWithOldProtocol$default$6();
        byte[] x$116 = this.verifySyncGroupWithOldProtocol$default$9();
        short x$117 = this.verifySyncGroupWithOldProtocol$default$11();
        this.verifySyncGroupWithOldProtocol(groupId, x$108, 2, "connect", x$114, x$115, null, null, x$116, Errors.INCONSISTENT_GROUP_PROTOCOL, x$117);
        String x$119 = (String)memberId1.elem;
        String x$125 = this.verifySyncGroupWithOldProtocol$default$4();
        List<SyncGroupRequestData.SyncGroupRequestAssignment> x$126 = this.verifySyncGroupWithOldProtocol$default$6();
        byte[] x$127 = this.verifySyncGroupWithOldProtocol$default$9();
        short x$128 = this.verifySyncGroupWithOldProtocol$default$11();
        this.verifySyncGroupWithOldProtocol(groupId, x$119, 2, x$125, "consumer-roundrobin", x$126, null, null, x$127, Errors.INCONSISTENT_GROUP_PROTOCOL, x$128);
        String x$130 = (String)memberId1.elem;
        byte[] x$132 = this.assignment((List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$1 -> !partitionsOfMember2.contains(BoxesRunTime.boxToInteger((int)x$1))), this.assignment$default$2());
        String x$133 = this.verifySyncGroupWithOldProtocol$default$4();
        String x$134 = this.verifySyncGroupWithOldProtocol$default$5();
        List<SyncGroupRequestData.SyncGroupRequestAssignment> x$135 = this.verifySyncGroupWithOldProtocol$default$6();
        String x$136 = this.verifySyncGroupWithOldProtocol$default$7();
        String x$137 = this.verifySyncGroupWithOldProtocol$default$8();
        Errors x$138 = this.verifySyncGroupWithOldProtocol$default$10();
        short x$139 = this.verifySyncGroupWithOldProtocol$default$11();
        this.verifySyncGroupWithOldProtocol(groupId, x$130, 2, x$133, x$134, x$135, x$136, x$137, x$132, x$138, x$139);
        if (!useStaticMembers) {
            this.leaveGroupWithNewProtocol(groupId, memberId2);
        } else {
            byte[] x$142 = this.metadata((List<Object>)package$.MODULE$.List().empty());
            byte[] x$144 = this.joinStaticConsumerGroupWithOldProtocol$default$4();
            this.joinStaticConsumerGroupWithOldProtocol(groupId, instanceId2, x$142, x$144, false);
        }
        Assertions.assertEquals((Object)new .colon.colon((Object)new ListGroupsResponseData.ListedGroup().setGroupId(groupId).setProtocolType("consumer").setGroupState(useStaticMembers ? ClassicGroupState.STABLE.toString() : ClassicGroupState.PREPARING_REBALANCE.toString()).setGroupType(Group.GroupType.CLASSIC.toString()), (List)Nil$.MODULE$), this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)new .colon.colon((Object)Group.GroupType.CLASSIC.toString(), (List)Nil$.MODULE$), this.listGroups$default$3()));
    }

    private void testOnlineMigrationWithCooperativeAssignmentStrategy(boolean useStaticMembers) {
        this.createOffsetsTopic();
        Uuid topicId = this.createTopic("foo", 3);
        String groupId = "grp";
        String instanceId1 = "instance-id-1";
        String instanceId2 = "instance-id-2";
        ObjectRef memberId1 = ObjectRef.create(null);
        memberId1.elem = !useStaticMembers ? (String)this.joinDynamicConsumerGroupWithOldProtocol(groupId, this.metadata((List<Object>)package$.MODULE$.List().empty()), this.assignment((List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), this.assignment$default$2()), this.joinDynamicConsumerGroupWithOldProtocol$default$4())._1() : (String)this.joinStaticConsumerGroupWithOldProtocol(groupId, instanceId1, this.metadata((List<Object>)package$.MODULE$.List().empty()), this.assignment((List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), this.assignment$default$2()), this.joinStaticConsumerGroupWithOldProtocol$default$5())._1();
        String x$22 = Uuid.randomUuid().toString();
        String x$32 = useStaticMembers ? instanceId2 : null;
        .colon.colon x$5 = new .colon.colon((Object)"foo", (List)Nil$.MODULE$);
        List x$6 = package$.MODULE$.List().empty();
        int x$8 = this.consumerGroupHeartbeat$default$3();
        String x$9 = this.consumerGroupHeartbeat$default$5();
        String x$10 = this.consumerGroupHeartbeat$default$7();
        short x$11 = this.consumerGroupHeartbeat$default$11();
        String memberId2 = this.consumerGroupHeartbeat(groupId, x$22, x$8, x$32, x$9, 300000, x$10, (List<String>)x$5, (List<ConsumerGroupHeartbeatRequestData.TopicPartitions>)x$6, Errors.NONE, x$11).memberId();
        Assertions.assertEquals((Object)new .colon.colon((Object)new ListGroupsResponseData.ListedGroup().setGroupId(groupId).setProtocolType("consumer").setGroupState(ConsumerGroup.ConsumerGroupState.RECONCILING.toString()).setGroupType(Group.GroupType.CONSUMER.toString()), (List)Nil$.MODULE$), this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)new .colon.colon((Object)Group.GroupType.CONSUMER.toString(), (List)Nil$.MODULE$), this.listGroups$default$3()));
        String x$14 = (String)memberId1.elem;
        String x$16 = this.heartbeat$default$4();
        short x$17 = this.heartbeat$default$6();
        this.heartbeat(groupId, 1, x$14, x$16, Errors.REBALANCE_IN_PROGRESS, x$17);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.OFFSET_COMMIT.oldestVersion()), (int)ApiKeys.OFFSET_COMMIT.latestVersion(this.isUnstableApiEnabled())).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partitionId -> this.commitOffset(groupId, (String)memberId1$2.elem, 1, "foo", topicId, partitionId, 100L + (long)(10 * version) + (long)partitionId, Errors.NONE, (short)version)));
        long committedOffset = 100L + (long)(10 * ApiKeys.OFFSET_COMMIT.latestVersion(this.isUnstableApiEnabled()));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), (int)ApiKeys.OFFSET_FETCH.latestVersion(this.isUnstableApiEnabled())).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> Assertions.assertEquals((Object)new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(groupId).setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(version < 10 ? "foo" : "").setTopicId(version >= 10 ? topicId : Uuid.ZERO_UUID).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(0).setCommittedOffset(committedOffset), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(1).setCommittedOffset(committedOffset + 1L), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(2).setCommittedOffset(committedOffset + 2L), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$)).asJava()), (Object)this.fetchOffsets(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId(groupId).setMemberId((String)memberId1$2.elem).setMemberEpoch(1).setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchRequestData.OffsetFetchRequestTopics().setName("foo").setTopicId(topicId).setPartitionIndexes(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$)).asJava()), false, (short)version)));
        String x$19 = (String)memberId1.elem;
        byte[] x$20 = this.metadata((List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))));
        String x$21 = this.sendJoinRequest$default$3();
        String x$222 = this.sendJoinRequest$default$4();
        String x$23 = this.sendJoinRequest$default$5();
        short x$24 = this.sendJoinRequest$default$7();
        Assertions.assertEquals((Object)new JoinGroupResponseData().setGenerationId(1).setProtocolType("consumer").setProtocolName("consumer-range").setMemberId((String)memberId1.elem), (Object)this.sendJoinRequest(groupId, x$19, x$21, x$222, x$23, x$20, x$24));
        java.util.List partitionsOfMember1 = ConsumerProtocol.deserializeAssignment((ByteBuffer)ByteBuffer.wrap(this.syncGroupWithOldProtocol(groupId, (String)memberId1.elem, 1, this.syncGroupWithOldProtocol$default$4(), this.syncGroupWithOldProtocol$default$5(), this.syncGroupWithOldProtocol$default$6(), this.syncGroupWithOldProtocol$default$7()).assignment())).partitions();
        String x$27 = (String)memberId1.elem;
        String x$29 = this.heartbeat$default$4();
        short x$30 = this.heartbeat$default$6();
        this.heartbeat(groupId, 1, x$27, x$29, Errors.REBALANCE_IN_PROGRESS, x$30);
        String x$322 = (String)memberId1.elem;
        byte[] x$33 = this.metadata((List<Object>)CollectionConverters$.MODULE$.ListHasAsScala(partitionsOfMember1).asScala().toList().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.partition())));
        String x$34 = this.sendJoinRequest$default$3();
        String x$35 = this.sendJoinRequest$default$4();
        String x$36 = this.sendJoinRequest$default$5();
        short x$37 = this.sendJoinRequest$default$7();
        Assertions.assertEquals((Object)new JoinGroupResponseData().setGenerationId(2).setProtocolType("consumer").setProtocolName("consumer-range").setMemberId((String)memberId1.elem), (Object)this.sendJoinRequest(groupId, x$322, x$34, x$35, x$36, x$33, x$37));
        String x$39 = (String)memberId1.elem;
        byte[] x$41 = this.assignment((List<Object>)CollectionConverters$.MODULE$.ListHasAsScala(partitionsOfMember1).asScala().toList().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.partition())), this.assignment$default$2());
        String x$42 = this.verifySyncGroupWithOldProtocol$default$4();
        String x$43 = this.verifySyncGroupWithOldProtocol$default$5();
        List<SyncGroupRequestData.SyncGroupRequestAssignment> x$44 = this.verifySyncGroupWithOldProtocol$default$6();
        String x$45 = this.verifySyncGroupWithOldProtocol$default$7();
        String x$46 = this.verifySyncGroupWithOldProtocol$default$8();
        Errors x$47 = this.verifySyncGroupWithOldProtocol$default$10();
        short x$48 = this.verifySyncGroupWithOldProtocol$default$11();
        this.verifySyncGroupWithOldProtocol(groupId, x$39, 2, x$42, x$43, x$44, x$45, x$46, x$41, x$47, x$48);
        .colon.colon x$53 = new .colon.colon((Object)"foo", (List)Nil$.MODULE$);
        List x$54 = package$.MODULE$.List().empty();
        String x$56 = this.consumerGroupHeartbeat$default$4();
        String x$57 = this.consumerGroupHeartbeat$default$5();
        String x$58 = this.consumerGroupHeartbeat$default$7();
        short x$59 = this.consumerGroupHeartbeat$default$11();
        this.consumerGroupHeartbeat(groupId, memberId2, 2, x$56, x$57, 300000, x$58, (List<String>)x$53, (List<ConsumerGroupHeartbeatRequestData.TopicPartitions>)x$54, Errors.NONE, x$59);
        Assertions.assertEquals((Object)new .colon.colon((Object)new ListGroupsResponseData.ListedGroup().setGroupId(groupId).setProtocolType("consumer").setGroupState(ConsumerGroup.ConsumerGroupState.STABLE.toString()).setGroupType(Group.GroupType.CONSUMER.toString()), (List)Nil$.MODULE$), this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)new .colon.colon((Object)Group.GroupType.CONSUMER.toString(), (List)Nil$.MODULE$), this.listGroups$default$3()));
        if (!useStaticMembers) {
            this.leaveGroupWithNewProtocol(groupId, memberId2);
        } else {
            byte[] x$62 = this.metadata((List<Object>)package$.MODULE$.List().empty());
            byte[] x$64 = this.joinStaticConsumerGroupWithOldProtocol$default$4();
            this.joinStaticConsumerGroupWithOldProtocol(groupId, instanceId2, x$62, x$64, false);
        }
        Assertions.assertEquals((Object)new .colon.colon((Object)new ListGroupsResponseData.ListedGroup().setGroupId(groupId).setProtocolType("consumer").setGroupState(useStaticMembers ? ClassicGroupState.STABLE.toString() : ClassicGroupState.PREPARING_REBALANCE.toString()).setGroupType(Group.GroupType.CLASSIC.toString()), (List)Nil$.MODULE$), this.listGroups((List<String>)package$.MODULE$.List().empty(), (List<String>)new .colon.colon((Object)Group.GroupType.CLASSIC.toString(), (List)Nil$.MODULE$), this.listGroups$default$3()));
    }

    private byte[] metadata(List<Object> ownedPartitions) {
        return ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription(Collections.singletonList("foo"), null, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ownedPartitions.map((Function1 & Serializable)x$4 -> ConsumerProtocolMigrationTest.$anonfun$metadata$1(BoxesRunTime.unboxToInt((Object)x$4)))).asJava()), (short)3).array();
    }

    private byte[] assignment(List<Object> assignedPartitions, ByteBuffer userData) {
        return ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)assignedPartitions.map((Function1 & Serializable)x$5 -> ConsumerProtocolMigrationTest.$anonfun$assignment$1(BoxesRunTime.unboxToInt((Object)x$5)))).asJava(), userData), (short)3).array();
    }

    private ByteBuffer assignment$default$2() {
        return null;
    }

    public static final /* synthetic */ TopicPartition $anonfun$metadata$1(int x$4) {
        return new TopicPartition("foo", x$4);
    }

    public static final /* synthetic */ TopicPartition $anonfun$assignment$1(int x$5) {
        return new TopicPartition("foo", x$5);
    }

    public ConsumerProtocolMigrationTest(ClusterInstance cluster) {
        super(cluster);
    }
}

