/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import kafka.server.ControllerConfigurationValidator;
import kafka.server.KafkaConfig;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001\u0002\r\u001a\u0001yAQ!\n\u0001\u0005\u0002\u0019Bq!\u000b\u0001C\u0002\u0013\u0005!\u0006\u0003\u0004/\u0001\u0001\u0006Ia\u000b\u0005\b_\u0001\u0011\r\u0011\"\u00011\u0011\u0019!\u0004\u0001)A\u0005c!)Q\u0007\u0001C\u0001m!)q\t\u0001C\u0001m!)\u0011\n\u0001C\u0001m!)1\n\u0001C\u0001m!)Q\n\u0001C\u0001m!)q\n\u0001C\u0001m!)\u0011\u000b\u0001C\u0001%\")Q\u000e\u0001C\u0001m!)q\u000e\u0001C\u0001m!)\u0011\u000f\u0001C\u0001m!)1\u000f\u0001C\u0001m!)Q\u000f\u0001C\u0001m!)q\u000f\u0001C\u0001m!)\u0011\u0010\u0001C\u0001m!)1\u0010\u0001C\u0001m!)Q\u0010\u0001C\u0001m!)q\u0010\u0001C\u0001m!1\u00111\u0001\u0001\u0005\u0002Y\u0012AeQ8oiJ|G\u000e\\3s\u0007>tg-[4ve\u0006$\u0018n\u001c8WC2LG-\u0019;peR+7\u000f\u001e\u0006\u00035m\taa]3sm\u0016\u0014(\"\u0001\u000f\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\b\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00059\u0003C\u0001\u0015\u0001\u001b\u0005I\u0012AB2p]\u001aLw-F\u0001,!\tAC&\u0003\u0002.3\tY1*\u00194lC\u000e{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002\n\u0011B^1mS\u0012\fGo\u001c:\u0016\u0003E\u0002\"\u0001\u000b\u001a\n\u0005MJ\"\u0001I\"p]R\u0014x\u000e\u001c7fe\u000e{gNZ5hkJ\fG/[8o-\u0006d\u0017\u000eZ1u_J\f!B^1mS\u0012\fGo\u001c:!\u0003\t\"Xm\u001d;EK\u001a\fW\u000f\u001c;U_BL7MU3t_V\u00148-Z%t%\u0016TWm\u0019;fIR\tq\u0007\u0005\u0002!q%\u0011\u0011(\t\u0002\u0005+:LG\u000f\u000b\u0002\u0007wA\u0011A(R\u0007\u0002{)\u0011ahP\u0001\u0004CBL'B\u0001!B\u0003\u001dQW\u000f]5uKJT!AQ\"\u0002\u000b),h.\u001b;\u000b\u0003\u0011\u000b1a\u001c:h\u0013\t1UH\u0001\u0003UKN$\u0018\u0001\b;fgRLeN^1mS\u0012$v\u000e]5d\u001d\u0006lWMU3kK\u000e$X\r\u001a\u0015\u0003\u000fm\nq\u0003^3tiVs7N\\8x]J+7o\\;sG\u0016$\u0016\u0010]3)\u0005!Y\u0014\u0001\u0007;fgRtU\u000f\u001c7U_BL7mQ8oM&<g+\u00197vK\"\u0012\u0011bO\u0001\u0015i\u0016\u001cHOV1mS\u0012$v\u000e]5d\u0007>tg-[4)\u0005)Y\u0014A\u0006;fgRLeN^1mS\u0012$v\u000e]5d\u0007>tg-[4)\u0005-Y\u0014!\n;fgR$\u0015n]1cY&twMU3n_R,7\u000b^8sC\u001e,Gk\u001c9jG\u000e{gNZ5h)\t94\u000bC\u0003U\u0019\u0001\u0007Q+A\fxCN\u0014V-\\8uKN#xN]1hK\u0016s\u0017M\u00197fIB\u0011\u0001EV\u0005\u0003/\u0006\u0012qAQ8pY\u0016\fg\u000e\u000b\u0003\r3~\u0003\u0007C\u0001.^\u001b\u0005Y&B\u0001/@\u0003\u0019\u0001\u0018M]1ng&\u0011al\u0017\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f\u0013!Y\u0001Hi\u0016\u001cH\u000fR5tC\nd\u0017N\\4SK6|G/Z*u_J\fw-\u001a+pa&\u001c7i\u001c8gS\u001e\u0004s/\u001b;iA]\f7OU3n_R,7\u000b^8sC\u001e,WI\\1cY\u0016$'\bI>1{\"\"AbY5k!\t!w-D\u0001f\u0015\t17,\u0001\u0005qe>4\u0018\u000eZ3s\u0013\tAWMA\u0006WC2,XmU8ve\u000e,\u0017\u0001\u00032p_2,\u0017M\\:-\u0005-d\u0017$A\u0001\u001a\u0003\u0001\tq\u0003^3ti&sg/\u00197jI\n\u0013xn[3s\u000b:$\u0018\u000e^=)\u00055Y\u0014a\u0007;fgRLeN^1mS\u0012tUmZ1uSZ,'I]8lKJLE\r\u000b\u0002\u000fw\u0005aB/Z:u-\u0006d\u0017\u000eZ\"mS\u0016tG/T3ue&\u001c7oQ8oM&<\u0007FA\b<\u00039\"Xm\u001d;J]Z\fG.\u001b3Tk\n\u001c8M]5qi&|gNT1nK\u000ec\u0017.\u001a8u\u001b\u0016$(/[2t\u0007>tg-[4)\u0005AY\u0014A\n;fgRLeN^1mS\u0012Le\u000e^3sm\u0006d7\t\\5f]RlU\r\u001e:jGN\u001cuN\u001c4jO\"\u0012\u0011cO\u0001'i\u0016\u001cH/\u00168eK\u001aLg.\u001a3D_:4\u0017nZ\"mS\u0016tG/T3ue&\u001c7oQ8oM&<\u0007F\u0001\n<\u0003\r\"Xm\u001d;J]Z\fG.\u001b3NCR\u001c\u0007n\u00117jK:$X*\u001a;sS\u000e\u001c8i\u001c8gS\u001eD#aE\u001e\u0002)Q,7\u000f\u001e,bY&$wI]8va\u000e{gNZ5hQ\t!2(A\u0010uKN$\u0018J\u001c<bY&$wI]8va:\u000bW.Z$s_V\u00048i\u001c8gS\u001eD#!F\u001e\u00021Q,7\u000f\u001e(vY2<%o\\;q\u0007>tg-[4WC2,X\r\u000b\u0002\u0017w\u00051B/Z:u\u0013:4\u0018\r\\5e\u000fJ|W\u000f]\"p]\u001aLw\r\u000b\u0002\u0018w\u0001")
public class ControllerConfigurationValidatorTest {
    private final KafkaConfig config = new KafkaConfig((Map)TestUtils$.MODULE$.createDummyBrokerConfig());
    private final ControllerConfigurationValidator validator = new ControllerConfigurationValidator(this.config());

    public KafkaConfig config() {
        return this.config;
    }

    public ControllerConfigurationValidator validator() {
        return this.validator;
    }

    @Test
    public void testDefaultTopicResourceIsRejected() {
        Assertions.assertEquals((Object)"Default topic resources are not allowed.", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, ""), Collections.emptyMap(), Collections.emptyMap())).getMessage());
    }

    @Test
    public void testInvalidTopicNameRejected() {
        Assertions.assertEquals((Object)"Topic name is invalid: '(<-invalid->)' contains one or more characters other than ASCII alphanumerics, '.', '_' and '-'", (Object)Assertions.assertThrows(InvalidTopicException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "(<-invalid->)"), Collections.emptyMap(), Collections.emptyMap())).getMessage());
    }

    @Test
    public void testUnknownResourceType() {
        Assertions.assertEquals((Object)"Unknown resource type BROKER_LOGGER", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "foo"), Collections.emptyMap(), Collections.emptyMap())).getMessage());
    }

    @Test
    public void testNullTopicConfigValue() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "10");
        config.put("segment.bytes", null);
        config.put("segment.ms", null);
        Assertions.assertEquals((Object)"Null value not supported for topic configs: segment.bytes,segment.ms", (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (Map)config, Collections.emptyMap())).getMessage());
    }

    @Test
    public void testValidTopicConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        config.put("segment.bytes", "67108864");
        this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), config, Collections.emptyMap());
    }

    @Test
    public void testInvalidTopicConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        config.put("segment.bytes", "67108864");
        config.put("foobar", "abc");
        Assertions.assertEquals((Object)"Unknown topic config name: foobar", (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (Map)config, Collections.emptyMap())).getMessage());
    }

    @ParameterizedTest(name="testDisablingRemoteStorageTopicConfig with wasRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testDisablingRemoteStorageTopicConfig(boolean wasRemoteStorageEnabled) {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("remote.storage.enable", "false");
        if (wasRemoteStorageEnabled) {
            Assertions.assertEquals((Object)"It is invalid to disable remote storage without deleting remote data. If you want to keep the remote data and turn to read only, please set `remote.storage.enable=true,remote.log.copy.disable=true`. If you want to disable remote storage and delete all remote data, please set `remote.storage.enable=false,remote.log.delete.on.disable=true`.", (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (Map)config, Collections.singletonMap("remote.storage.enable", "true"))).getMessage());
            return;
        }
        this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), config, Collections.emptyMap());
        this.validator().validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), config, Collections.singletonMap("remote.storage.enable", "false"));
    }

    @Test
    public void testInvalidBrokerEntity() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        Assertions.assertEquals((Object)"Unable to parse broker name as a base 10 number.", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.BROKER, "blah"), (Map)config, Collections.emptyMap())).getMessage());
    }

    @Test
    public void testInvalidNegativeBrokerId() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        Assertions.assertEquals((Object)"Invalid negative broker ID.", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.BROKER, "-1"), (Map)config, Collections.emptyMap())).getMessage());
    }

    @Test
    public void testValidClientMetricsConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("interval.ms", "2000");
        config.put("metrics", "org.apache.kafka.client.producer.partition.queue.,org.apache.kafka.client.producer.partition.latency");
        config.put("match", "client_instance_id=b69cc35a-7a54-4790-aa69-cc2bd4ee4538,client_id=1,client_software_name=apache-kafka-java,client_software_version=2.8.0-SNAPSHOT,client_source_address=127.0.0.1,client_source_port=1234");
        this.validator().validate(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "subscription-1"), config, Collections.emptyMap());
    }

    @Test
    public void testInvalidSubscriptionNameClientMetricsConfig() {
        TreeMap config = new TreeMap();
        Assertions.assertEquals((Object)"Subscription name can't be empty", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, ""), (Map)config, Collections.emptyMap())).getMessage());
    }

    @Test
    public void testInvalidIntervalClientMetricsConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("interval.ms", "10");
        Assertions.assertEquals((Object)"Invalid value 10 for interval.ms, interval must be between 100 and 3600000 (1 hour)", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "subscription-1"), (Map)config, Collections.emptyMap())).getMessage());
        config.put("interval.ms", "3600001");
        Assertions.assertEquals((Object)"Invalid value 3600001 for interval.ms, interval must be between 100 and 3600000 (1 hour)", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "subscription-1"), (Map)config, Collections.emptyMap())).getMessage());
    }

    @Test
    public void testUndefinedConfigClientMetricsConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("random", "10");
        Assertions.assertEquals((Object)"Unknown client metrics configuration: random", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "subscription-1"), (Map)config, Collections.emptyMap())).getMessage());
    }

    @Test
    public void testInvalidMatchClientMetricsConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("match", "10");
        Assertions.assertEquals((Object)"Illegal client matching pattern: 10", (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "subscription-1"), (Map)config, Collections.emptyMap())).getMessage());
    }

    @Test
    public void testValidGroupConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("consumer.session.timeout.ms", "50000");
        config.put("consumer.heartbeat.interval.ms", "5000");
        this.validator().validate(new ConfigResource(ConfigResource.Type.GROUP, "group"), config, Collections.emptyMap());
    }

    @Test
    public void testInvalidGroupNameGroupConfig() {
        TreeMap config = new TreeMap();
        Assertions.assertEquals((Object)"Default group resources are not allowed.", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.GROUP, ""), (Map)config, Collections.emptyMap())).getMessage());
    }

    @Test
    public void testNullGroupConfigValue() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("consumer.session.timeout.ms", "50000");
        config.put("consumer.heartbeat.interval.ms", null);
        Assertions.assertEquals((Object)"Null value not supported for group configs: consumer.heartbeat.interval.ms", (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.GROUP, "group"), (Map)config, Collections.emptyMap())).getMessage());
    }

    @Test
    public void testInvalidGroupConfig() {
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("consumer.session.timeout.ms", "50000");
        config.put("foobar", "abc");
        Assertions.assertEquals((Object)"Unknown group config name: foobar", (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> this.validator().validate(new ConfigResource(ConfigResource.Type.GROUP, "group"), (Map)config, Collections.emptyMap())).getMessage());
    }
}

