/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kafka.cluster.Partition;
import kafka.server.DelayedRemoteFetch;
import kafka.server.FetchPartitionStatus;
import kafka.server.ReplicaManager;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.server.LogReadResult;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.storage.log.FetchParams;
import org.apache.kafka.server.storage.log.FetchPartitionData;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.RemoteStorageFetchInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.Int$;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015d\u0001B\u000f\u001f\u0001\rBQA\u000b\u0001\u0005\u0002-BqA\f\u0001C\u0002\u0013%q\u0006\u0003\u00044\u0001\u0001\u0006I\u0001\r\u0005\bi\u0001\u0011\r\u0011\"\u00036\u0011\u0019I\u0004\u0001)A\u0005m!9!\b\u0001b\u0001\n\u0013Y\u0004BB$\u0001A\u0003%A\bC\u0004I\u0001\t\u0007I\u0011B%\t\r5\u0003\u0001\u0015!\u0003K\u0011\u001dq\u0005A1A\u0005\n%Caa\u0014\u0001!\u0002\u0013Q\u0005b\u0002)\u0001\u0005\u0004%I!\u0015\u0005\u0007A\u0002\u0001\u000b\u0011\u0002*\t\u000f\u0005\u0004!\u0019!C\u0005_!1!\r\u0001Q\u0001\nABqa\u0019\u0001C\u0002\u0013%A\r\u0003\u0004i\u0001\u0001\u0006I!\u001a\u0005\bS\u0002\u0011\r\u0011\"\u0003k\u0011\u0019!\b\u0001)A\u0005W\")Q\u000f\u0001C\u0001m\"1\u00111\u0002\u0001\u0005\u0002YDa!a\u0004\u0001\t\u00031\bBBA\n\u0001\u0011\u0005a\u000f\u0003\u0004\u0002\u0018\u0001!\tA\u001e\u0005\b\u00037\u0001A\u0011BA\u000f\u0011\u001d\t9\u0003\u0001C\u0005\u0003SA\u0011\"a\u0013\u0001#\u0003%I!!\u0014\t\u0013\u0005\r\u0004!%A\u0005\n\u00055#A\u0006#fY\u0006LX\r\u001a*f[>$XMR3uG\"$Vm\u001d;\u000b\u0005}\u0001\u0013AB:feZ,'OC\u0001\"\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0013\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tA\u0006\u0005\u0002.\u00015\ta$\u0001\u0005nCb\u0014\u0015\u0010^3t+\u0005\u0001\u0004CA\u00132\u0013\t\u0011dEA\u0002J]R\f\u0011\"\\1y\u0005f$Xm\u001d\u0011\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\ta\u0007\u0005\u0002.o%\u0011\u0001H\b\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0013\u0001\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8o+\u0005a\u0004CA\u001fF\u001b\u0005q$BA A\u0003\u0019\u0019w.\\7p]*\u0011\u0011%\u0011\u0006\u0003\u0005\u000e\u000ba!\u00199bG\",'\"\u0001#\u0002\u0007=\u0014x-\u0003\u0002G}\t\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\\\u0001\u0012i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u0004\u0013a\u00034fi\u000eDwJ\u001a4tKR,\u0012A\u0013\t\u0003K-K!\u0001\u0014\u0014\u0003\t1{gnZ\u0001\rM\u0016$8\r[(gMN,G\u000fI\u0001\u000fY><7\u000b^1si>3gm]3u\u0003=awnZ*uCJ$xJ\u001a4tKR\u0004\u0013AE2veJ,g\u000e\u001e'fC\u0012,'/\u00129pG\",\u0012A\u0015\t\u0004'bSV\"\u0001+\u000b\u0005U3\u0016\u0001B;uS2T\u0011aV\u0001\u0005U\u00064\u0018-\u0003\u0002Z)\nAq\n\u001d;j_:\fG\u000e\u0005\u0002\\=6\tAL\u0003\u0002^-\u0006!A.\u00198h\u0013\tyFLA\u0004J]R,w-\u001a:\u0002'\r,(O]3oi2+\u0017\rZ3s\u000bB|7\r\u001b\u0011\u0002)I,Wn\u001c;f\r\u0016$8\r['bq^\u000b\u0017\u000e^'t\u0003U\u0011X-\\8uK\u001a+Go\u00195NCb<\u0016-\u001b;Ng\u0002\n1BZ3uG\"\u001cF/\u0019;vgV\tQ\r\u0005\u0002.M&\u0011qM\b\u0002\u0015\r\u0016$8\r\u001b)beRLG/[8o'R\fG/^:\u0002\u0019\u0019,Go\u00195Ti\u0006$Xo\u001d\u0011\u0002\u0017\u0019,Go\u00195QCJ\fWn]\u000b\u0002WB\u0011AN]\u0007\u0002[*\u0011an\\\u0001\u0004Y><'B\u00019r\u0003\u001d\u0019Ho\u001c:bO\u0016T!a\b!\n\u0005Ml'a\u0003$fi\u000eD\u0007+\u0019:b[N\fABZ3uG\"\u0004\u0016M]1ng\u0002\n\u0011\u0002^3ti\u001a+Go\u00195\u0015\u0003]\u0004\"!\n=\n\u0005e4#\u0001B+oSRD#\u0001F>\u0011\u0007q\f9!D\u0001~\u0015\tqx0A\u0002ba&TA!!\u0001\u0002\u0004\u00059!.\u001e9ji\u0016\u0014(bAA\u0003\u0007\u0006)!.\u001e8ji&\u0019\u0011\u0011B?\u0003\tQ+7\u000f^\u0001\u0012i\u0016\u001cHOR8mY><XM\u001d$fi\u000eD\u0007FA\u000b|\u0003]!Xm\u001d;O_RdU-\u00193fe>\u0013hi\u001c7m_^,'\u000f\u000b\u0002\u0017w\u0006!B/Z:u\u000bJ\u0014xN\u001d'pOJ+\u0017\rZ%oM>D#aF>\u0002#Q,7\u000f\u001e*fcV,7\u000f^#ya&\u0014\u0018\u0010\u000b\u0002\u0019w\u0006\u0001\"-^5mI\u001a+Go\u00195QCJ\fWn\u001d\u000b\u0006W\u0006}\u00111\u0005\u0005\u0007\u0003CI\u0002\u0019\u0001\u0019\u0002\u0013I,\u0007\u000f\\5dC&#\u0007BBA\u00133\u0001\u0007\u0001'A\u0005nCb<\u0016-\u001b;Ng\u0006y!-^5mIJ+\u0017\r\u001a*fgVdG\u000f\u0006\u0005\u0002,\u0005M\u00121IA$!\u0011\ti#a\f\u000e\u0003EL1!!\rr\u00055aun\u001a*fC\u0012\u0014Vm];mi\"9\u0011Q\u0007\u000eA\u0002\u0005]\u0012!B3se>\u0014\b\u0003BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\u0005ub(\u0001\u0005qe>$xnY8m\u0013\u0011\t\t%a\u000f\u0003\r\u0015\u0013(o\u001c:t\u0011!\t)E\u0007I\u0001\u0002\u0004\u0001\u0014!\u00045jO\"<\u0016\r^3s[\u0006\u00148\u000e\u0003\u0005\u0002Ji\u0001\n\u00111\u00011\u0003QaW-\u00193fe2{wm\u0015;beR|eMZ:fi\u0006I\"-^5mIJ+\u0017\r\u001a*fgVdG\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tyEK\u00021\u0003#Z#!a\u0015\u0011\t\u0005U\u0013qL\u0007\u0003\u0003/RA!!\u0017\u0002\\\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003;2\u0013AC1o]>$\u0018\r^5p]&!\u0011\u0011MA,\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001aEVLG\u000e\u001a*fC\u0012\u0014Vm];mi\u0012\"WMZ1vYR$3\u0007")
public class DelayedRemoteFetchTest {
    private final int maxBytes;
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final TopicIdPartition topicIdPartition = new TopicIdPartition(Uuid.randomUuid(), 0, "topic");
    private final long fetchOffset;
    private final long logStartOffset;
    private final Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(10));
    private final int remoteFetchMaxWaitMs;
    private final FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(this.fetchOffset()), new FetchRequest.PartitionData(Uuid.ZERO_UUID, this.fetchOffset(), this.logStartOffset(), this.maxBytes(), this.currentLeaderEpoch()));
    private final FetchParams fetchParams = this.buildFetchParams(-1, 500);

    private int maxBytes() {
        return this.maxBytes;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    private long fetchOffset() {
        return this.fetchOffset;
    }

    private long logStartOffset() {
        return this.logStartOffset;
    }

    private Optional<Integer> currentLeaderEpoch() {
        return this.currentLeaderEpoch;
    }

    private int remoteFetchMaxWaitMs() {
        return this.remoteFetchMaxWaitMs;
    }

    private FetchPartitionStatus fetchStatus() {
        return this.fetchStatus;
    }

    private FetchParams fetchParams() {
        return this.fetchParams;
    }

    @Test
    public void testFetch() {
        ObjectRef actualTopicPartition = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        future.complete(null);
        RemoteStorageFetchInfo fetchInfo = new RemoteStorageFetchInfo(0, false, this.topicIdPartition().topicPartition(), null, null);
        int highWatermark = 100;
        int leaderLogStartOffset = 10;
        LogReadResult logReadInfo = this.buildReadResult(Errors.NONE, highWatermark, leaderLogStartOffset);
        DelayedRemoteFetch delayedRemoteFetch = new DelayedRemoteFetch(null, future, fetchInfo, (long)this.remoteFetchMaxWaitMs(), (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition()), (Object)this.fetchStatus()), (List)Nil$.MODULE$), this.fetchParams(), (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition()), (Object)logReadInfo), (List)Nil$.MODULE$), this.replicaManager(), (Function1 & Serializable)responses -> {
            DelayedRemoteFetchTest.callback$1(responses, actualTopicPartition, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Mockito.when((Object)this.replicaManager().getPartitionOrException(this.topicIdPartition().topicPartition())).thenReturn(Mockito.mock(Partition.class));
        Assertions.assertTrue((boolean)delayedRemoteFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedRemoteFetch.isCompleted());
        Assertions.assertTrue((boolean)((Option)actualTopicPartition.elem).isDefined());
        Assertions.assertEquals((Object)this.topicIdPartition(), (Object)((Option)actualTopicPartition.elem).get());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
        FetchPartitionData fetchResult = (FetchPartitionData)((Option)fetchResultOpt.elem).get();
        Assertions.assertEquals((Object)Errors.NONE, (Object)fetchResult.error);
        Assertions.assertEquals((long)highWatermark, (long)fetchResult.highWatermark);
        Assertions.assertEquals((long)leaderLogStartOffset, (long)fetchResult.logStartOffset);
    }

    @Test
    public void testFollowerFetch() {
        ObjectRef actualTopicPartition = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        future.complete(null);
        RemoteStorageFetchInfo fetchInfo = new RemoteStorageFetchInfo(0, false, this.topicIdPartition().topicPartition(), null, null);
        int highWatermark = 100;
        int leaderLogStartOffset = 10;
        LogReadResult logReadInfo = this.buildReadResult(Errors.NONE, highWatermark, leaderLogStartOffset);
        FetchParams fetchParams = this.buildFetchParams(1, 500);
        Assertions.assertThrows(IllegalStateException.class, () -> new DelayedRemoteFetch(null, future, fetchInfo, (long)this.remoteFetchMaxWaitMs(), (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition()), (Object)this.fetchStatus()), (List)Nil$.MODULE$), fetchParams, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition()), (Object)logReadInfo), (List)Nil$.MODULE$), this.replicaManager(), (Function1 & Serializable)responses -> {
            DelayedRemoteFetchTest.callback$2(responses, actualTopicPartition, fetchResultOpt);
            return BoxedUnit.UNIT;
        }));
    }

    @Test
    public void testNotLeaderOrFollower() {
        ObjectRef actualTopicPartition = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        Mockito.when((Object)this.replicaManager().getPartitionOrException(this.topicIdPartition().topicPartition())).thenThrow(new Throwable[]{new NotLeaderOrFollowerException("Replica for " + this.topicIdPartition() + " not available")});
        CompletableFuture future = new CompletableFuture();
        RemoteStorageFetchInfo fetchInfo = new RemoteStorageFetchInfo(0, false, this.topicIdPartition().topicPartition(), null, null);
        LogReadResult logReadInfo = this.buildReadResult(Errors.NONE, 0, 0);
        DelayedRemoteFetch delayedRemoteFetch = new DelayedRemoteFetch(null, future, fetchInfo, (long)this.remoteFetchMaxWaitMs(), (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition()), (Object)this.fetchStatus()), (List)Nil$.MODULE$), this.fetchParams(), (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition()), (Object)logReadInfo), (List)Nil$.MODULE$), this.replicaManager(), (Function1 & Serializable)responses -> {
            DelayedRemoteFetchTest.callback$3(responses, actualTopicPartition, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)delayedRemoteFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedRemoteFetch.isCompleted());
        Assertions.assertEquals((Object)this.topicIdPartition(), (Object)((Option)actualTopicPartition.elem).get());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
    }

    @Test
    public void testErrorLogReadInfo() {
        ObjectRef actualTopicPartition = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        Mockito.when((Object)this.replicaManager().getPartitionOrException(this.topicIdPartition().topicPartition())).thenReturn(Mockito.mock(Partition.class));
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        future.complete(null);
        RemoteStorageFetchInfo fetchInfo = new RemoteStorageFetchInfo(0, false, this.topicIdPartition().topicPartition(), null, null);
        LogReadResult logReadInfo = this.buildReadResult(Errors.FENCED_LEADER_EPOCH, 0, 0);
        DelayedRemoteFetch delayedRemoteFetch = new DelayedRemoteFetch(null, future, fetchInfo, (long)this.remoteFetchMaxWaitMs(), (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition()), (Object)this.fetchStatus()), (List)Nil$.MODULE$), this.fetchParams(), (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition()), (Object)logReadInfo), (List)Nil$.MODULE$), this.replicaManager(), (Function1 & Serializable)responses -> {
            DelayedRemoteFetchTest.callback$4(responses, actualTopicPartition, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)delayedRemoteFetch.tryComplete());
        Assertions.assertTrue((boolean)delayedRemoteFetch.isCompleted());
        Assertions.assertEquals((Object)this.topicIdPartition(), (Object)((Option)actualTopicPartition.elem).get());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
        Assertions.assertEquals((Object)Errors.FENCED_LEADER_EPOCH, (Object)((FetchPartitionData)((Option)fetchResultOpt.elem).get()).error);
    }

    @Test
    public void testRequestExpiry() {
        ObjectRef actualTopicPartition = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef fetchResultOpt = ObjectRef.create((Object)None$.MODULE$);
        int highWatermark = 100;
        int leaderLogStartOffset = 10;
        Future remoteFetchTask = (Future)Mockito.mock(Future.class);
        CompletableFuture future = new CompletableFuture();
        RemoteStorageFetchInfo fetchInfo = new RemoteStorageFetchInfo(0, false, this.topicIdPartition().topicPartition(), null, null);
        LogReadResult logReadInfo = this.buildReadResult(Errors.NONE, highWatermark, leaderLogStartOffset);
        DelayedRemoteFetch delayedRemoteFetch = new DelayedRemoteFetch(remoteFetchTask, future, fetchInfo, (long)this.remoteFetchMaxWaitMs(), (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition()), (Object)this.fetchStatus()), (List)Nil$.MODULE$), this.fetchParams(), (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition()), (Object)logReadInfo), (List)Nil$.MODULE$), this.replicaManager(), (Function1 & Serializable)responses -> {
            DelayedRemoteFetchTest.callback$5(responses, actualTopicPartition, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Mockito.when((Object)this.replicaManager().getPartitionOrException(this.topicIdPartition().topicPartition())).thenReturn(Mockito.mock(Partition.class));
        Map metrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        Assertions.assertEquals((int)0, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DelayedRemoteFetchTest.$anonfun$testRequestExpiry$2(x$1))));
        delayedRemoteFetch.run();
        ((Future)Mockito.verify((Object)remoteFetchTask)).cancel(false);
        Assertions.assertTrue((boolean)delayedRemoteFetch.isCompleted());
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.SetHasAsScala(metrics.keySet()).asScala().count((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DelayedRemoteFetchTest.$anonfun$testRequestExpiry$3(x$2))));
        Assertions.assertTrue((boolean)((Option)actualTopicPartition.elem).isDefined());
        Assertions.assertEquals((Object)this.topicIdPartition(), (Object)((Option)actualTopicPartition.elem).get());
        Assertions.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
        FetchPartitionData fetchResult = (FetchPartitionData)((Option)fetchResultOpt.elem).get();
        Assertions.assertEquals((Object)Errors.NONE, (Object)fetchResult.error);
        Assertions.assertEquals((long)highWatermark, (long)fetchResult.highWatermark);
        Assertions.assertEquals((long)leaderLogStartOffset, (long)fetchResult.logStartOffset);
    }

    private FetchParams buildFetchParams(int replicaId, int maxWaitMs) {
        return new FetchParams(replicaId, 1L, (long)maxWaitMs, 1, this.maxBytes(), FetchIsolation.LOG_END, Optional.empty());
    }

    private LogReadResult buildReadResult(Errors error, int highWatermark, int leaderLogStartOffset) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        return new LogReadResult(new FetchDataInfo(LogOffsetMetadata.UNKNOWN_OFFSET_METADATA, (Records)MemoryRecords.EMPTY), Optional.empty(), Int$.MODULE$.int2long(highWatermark), Int$.MODULE$.int2long(leaderLogStartOffset), -1L, -1L, -1L, OptionalLong.empty(), (errors == null ? errors2 != null : !errors.equals(errors2)) ? Optional.of(error.exception()) : Optional.empty());
    }

    private int buildReadResult$default$2() {
        return 0;
    }

    private int buildReadResult$default$3() {
        return 0;
    }

    private static final void callback$1(Seq responses, ObjectRef actualTopicPartition$1, ObjectRef fetchResultOpt$1) {
        Assertions.assertEquals((int)1, (int)responses.size());
        actualTopicPartition$1.elem = new Some(((Tuple2)responses.head())._1());
        fetchResultOpt$1.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$2(Seq responses, ObjectRef actualTopicPartition$2, ObjectRef fetchResultOpt$2) {
        Assertions.assertEquals((int)1, (int)responses.size());
        actualTopicPartition$2.elem = new Some(((Tuple2)responses.head())._1());
        fetchResultOpt$2.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$3(Seq responses, ObjectRef actualTopicPartition$3, ObjectRef fetchResultOpt$3) {
        Assertions.assertEquals((int)1, (int)responses.size());
        actualTopicPartition$3.elem = new Some(((Tuple2)responses.head())._1());
        fetchResultOpt$3.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$4(Seq responses, ObjectRef actualTopicPartition$4, ObjectRef fetchResultOpt$4) {
        Assertions.assertEquals((int)1, (int)responses.size());
        actualTopicPartition$4.elem = new Some(((Tuple2)responses.head())._1());
        fetchResultOpt$4.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$5(Seq responses, ObjectRef actualTopicPartition$5, ObjectRef fetchResultOpt$5) {
        Assertions.assertEquals((int)1, (int)responses.size());
        actualTopicPartition$5.elem = new Some(((Tuple2)responses.head())._1());
        fetchResultOpt$5.elem = new Some(((Tuple2)responses.head())._2());
    }

    public static final /* synthetic */ boolean $anonfun$testRequestExpiry$2(MetricName x$1) {
        String string = x$1.getMBeanName();
        String string2 = "kafka.server:type=DelayedRemoteFetchMetrics,name=ExpiresPerSec";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testRequestExpiry$3(MetricName x$2) {
        String string = x$2.getMBeanName();
        String string2 = "kafka.server:type=DelayedRemoteFetchMetrics,name=ExpiresPerSec";
        return string != null && string.equals(string2);
    }

    public DelayedRemoteFetchTest() {
        this.maxBytes = 1024;
        this.fetchOffset = 500L;
        this.logStartOffset = 0L;
        this.remoteFetchMaxWaitMs = 500;
    }
}

