/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.server.GroupCoordinatorBaseRequestTest;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterConfigProperty;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.test.api.ClusterTestDefaults;
import org.apache.kafka.common.test.api.Type;
import org.apache.kafka.coordinator.group.classic.ClassicGroupState;
import org.junit.jupiter.api.Assertions;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ClusterTestDefaults(types={Type.KRAFT}, serverProperties={@ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")})
@ScalaSignature(bytes="\u0006\u0005U3AAB\u0004\u0001\u0019!A\u0011\u0003\u0001B\u0001B\u0003%!\u0003C\u0003 \u0001\u0011\u0005\u0001\u0005C\u0003$\u0001\u0011\u0005A\u0005C\u00033\u0001\u0011\u0005A\u0005C\u00035\u0001\u0011%QGA\fEK2,G/Z$s_V\u00048OU3rk\u0016\u001cH\u000fV3ti*\u0011\u0001\"C\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003)\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u001bA\u0011abD\u0007\u0002\u000f%\u0011\u0001c\u0002\u0002 \u000fJ|W\u000f]\"p_J$\u0017N\\1u_J\u0014\u0015m]3SKF,Xm\u001d;UKN$\u0018aB2mkN$XM\u001d\t\u0003'ui\u0011\u0001\u0006\u0006\u0003+Y\tA\u0001^3ti*\u0011q\u0003G\u0001\u0007G>lWn\u001c8\u000b\u0005)I\"B\u0001\u000e\u001c\u0003\u0019\t\u0007/Y2iK*\tA$A\u0002pe\u001eL!A\b\u000b\u0003\u001f\rcWo\u001d;fe&s7\u000f^1oG\u0016\fa\u0001P5oSRtDCA\u0011#!\tq\u0001\u0001C\u0003\u0012\u0005\u0001\u0007!#\u0001\u0017uKN$H)\u001a7fi\u0016<%o\\;qg^KG\u000f\u001b(fo\u000e{gn];nKJ<%o\\;q!J|Go\\2pYR\tQ\u0005\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0003V]&$\bFA\u0002-!\ti\u0003'D\u0001/\u0015\tyC#A\u0002ba&L!!\r\u0018\u0003\u0017\rcWo\u001d;feR+7\u000f^\u0001-i\u0016\u001cH\u000fR3mKR,wI]8vaN<\u0016\u000e\u001e5PY\u0012\u001cuN\\:v[\u0016\u0014xI]8vaB\u0013x\u000e^8d_2D#\u0001\u0002\u0017\u0002!Q,7\u000f\u001e#fY\u0016$Xm\u0012:pkB\u001cHCA\u00137\u0011\u00159T\u00011\u00019\u00039)8/\u001a(foB\u0013x\u000e^8d_2\u0004\"AJ\u001d\n\u0005i:#a\u0002\"p_2,\u0017M\u001c\u0015\u0007\u0001qz\u0004IR$\u0011\u00055j\u0014B\u0001 /\u0005M\u0019E.^:uKJ$Vm\u001d;EK\u001a\fW\u000f\u001c;t\u0003\u0015!\u0018\u0010]3tY\u0005\tE%\u0001\"\n\u0005\r#\u0015!B&S\u0003\u001a#&BA#/\u0003\u0011!\u0016\u0010]3\u0002!M,'O^3s!J|\u0007/\u001a:uS\u0016\u001cHF\u0001%SW\u0015IE*T(Q!\ti#*\u0003\u0002L]\t)2\t\\;ti\u0016\u00148i\u001c8gS\u001e\u0004&o\u001c9feRL\u0018aA6fs\u0006\na*\u0001\u000fpM\u001a\u001cX\r^:/i>\u0004\u0018n\u0019\u0018ok6t\u0003/\u0019:uSRLwN\\:\u0002\u000bY\fG.^3\"\u0003E\u000b\u0011!M\u0016\u0006\u00132\u001bv\nU\u0011\u0002)\u0006\u0001sN\u001a4tKR\u001ch\u0006^8qS\u000et#/\u001a9mS\u000e\fG/[8o]\u0019\f7\r^8s\u0001")
public class DeleteGroupsRequestTest
extends GroupCoordinatorBaseRequestTest {
    @ClusterTest
    public void testDeleteGroupsWithNewConsumerGroupProtocol() {
        this.testDeleteGroups(true);
    }

    @ClusterTest
    public void testDeleteGroupsWithOldConsumerGroupProtocol() {
        this.testDeleteGroups(false);
    }

    private void testDeleteGroups(boolean useNewProtocol) {
        this.createOffsetsTopic();
        Uuid topicId = this.createTopic("foo", 3);
        this.joinConsumerGroup("grp-non-empty", useNewProtocol);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.DELETE_GROUPS.oldestVersion()), (int)ApiKeys.DELETE_GROUPS.latestVersion(this.isUnstableApiEnabled())).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            void var5_5;
            Tuple2<String, Object> tuple2 = this.joinConsumerGroup("grp", useNewProtocol);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            String memberId = (String)tuple2._1();
            int n = tuple2._2$mcI$sp();
            this.leaveGroup("grp", (String)var5_5, useNewProtocol, ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled()));
            this.deleteGroups((List<String>)new .colon.colon((Object)"grp-non-empty", (List)new .colon.colon((Object)"grp", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$))), (List<Errors>)new .colon.colon((Object)Errors.NON_EMPTY_GROUP, (List)new .colon.colon((Object)Errors.NONE, (List)new .colon.colon((Object)Errors.GROUP_ID_NOT_FOUND, (List)Nil$.MODULE$))), (short)version);
            if (useNewProtocol) {
                this.commitOffset("grp", (String)var5_5, n, "foo", topicId, 0, 100L, Errors.GROUP_ID_NOT_FOUND, ApiKeys.OFFSET_COMMIT.latestVersion(this.isUnstableApiEnabled()));
                return;
            }
            Assertions.assertEquals((Object)new .colon.colon((Object)new DescribeGroupsResponseData.DescribedGroup().setGroupId("grp").setGroupState(ClassicGroupState.DEAD.toString()).setErrorCode(Errors.GROUP_ID_NOT_FOUND.code()).setErrorMessage("Group grp not found."), (List)Nil$.MODULE$), this.describeGroups((List<String>)new .colon.colon((Object)"grp", (List)Nil$.MODULE$), this.describeGroups$default$2()));
        });
    }

    public DeleteGroupsRequestTest(ClusterInstance cluster) {
        super(cluster);
    }
}

