/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005I4AAC\u0006\u0001!!)1\u0004\u0001C\u00019!)a\u0004\u0001C\u0001?!)1\u0007\u0001C\u0001?!)Q\u0007\u0001C\u0005m!)A\t\u0001C\u0005\u000b\")q\t\u0001C\u0005\u0011\")a\u000b\u0001C\u0005/\"9A\rAI\u0001\n\u0013)\u0007\"\u00029\u0001\t\u0003y\"a\u0006#fY\u0016$X\rV8qS\u000e\u001c(+Z9vKN$H+Z:u\u0015\taQ\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u001d\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u0012+A\u0011!cE\u0007\u0002\u0017%\u0011Ac\u0003\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3tiB\u0011a#G\u0007\u0002/)\u0011\u0001$D\u0001\u0006kRLGn]\u0005\u00035]\u0011q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011!\u0003A\u0001-i\u0016\u001cH\u000fV8qS\u000e$U\r\\3uS>t7\t\\;ti\u0016\u0014\b*Y:PM\u001ad\u0017N\\3QCJ$\u0018\u000e^5p]N$\u0012\u0001\t\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0005+:LG\u000f\u000b\u0002\u0003OA\u0011\u0001&M\u0007\u0002S)\u0011!fK\u0001\u0004CBL'B\u0001\u0017.\u0003\u001dQW\u000f]5uKJT!AL\u0018\u0002\u000b),h.\u001b;\u000b\u0003A\n1a\u001c:h\u0013\t\u0011\u0014F\u0001\u0003UKN$\u0018\u0001\b;fgR4\u0016\r\\5e\t\u0016dW\r^3U_BL7MU3rk\u0016\u001cHo\u001d\u0015\u0003\u0007\u001d\n\u0001E^1mS\u0012\fG/\u001a,bY&$G)\u001a7fi\u0016$v\u000e]5d%\u0016\fX/Z:ugR\u0011\u0001e\u000e\u0005\u0006q\u0011\u0001\r!O\u0001\be\u0016\fX/Z:u!\tQ$)D\u0001<\u0015\taT(\u0001\u0005sKF,Xm\u001d;t\u0015\tqt(\u0001\u0004d_6lwN\u001c\u0006\u0003\u001d\u0001S!!Q\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t\u00195HA\nEK2,G/\u001a+pa&\u001c7OU3rk\u0016\u001cH/A\u0014wC2LG-\u0019;f-\u0006d\u0017\u000e\u001a#fY\u0016$X\rV8qS\u000e\u0014V-];fgR\u001cx+\u001b;i\u0013\u0012\u001cHC\u0001\u0011G\u0011\u0015AT\u00011\u0001:\u0003Y1\u0018\r\\5eCR,Gk\u001c9jG&\u001bH)\u001a7fi\u0016$GC\u0001\u0011J\u0011\u0015Qe\u00011\u0001L\u0003\u0015!x\u000e]5d!\ta5K\u0004\u0002N#B\u0011aJI\u0007\u0002\u001f*\u0011\u0001kD\u0001\u0007yI|w\u000e\u001e \n\u0005I\u0013\u0013A\u0002)sK\u0012,g-\u0003\u0002U+\n11\u000b\u001e:j]\u001eT!A\u0015\u0012\u0002/M,g\u000e\u001a#fY\u0016$X\rV8qS\u000e\u001c(+Z9vKN$Hc\u0001-\\9B\u0011!(W\u0005\u00035n\u0012A\u0003R3mKR,Gk\u001c9jGN\u0014Vm\u001d9p]N,\u0007\"\u0002\u001d\b\u0001\u0004I\u0004bB/\b!\u0003\u0005\rAX\u0001\rg>\u001c7.\u001a;TKJ4XM\u001d\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003C6\tqA\\3uo>\u00148.\u0003\u0002dA\na1k\\2lKR\u001cVM\u001d<fe\u0006\t3/\u001a8e\t\u0016dW\r^3U_BL7m\u001d*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\taM\u000b\u0002_O.\n\u0001\u000e\u0005\u0002j]6\t!N\u0003\u0002lY\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003[\n\n!\"\u00198o_R\fG/[8o\u0013\ty'NA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001\u0004^3ti\u0012+G.\u001a;f)>\u0004\u0018nY:WKJ\u001c\u0018n\u001c8tQ\tIq\u0005")
public class DeleteTopicsRequestTest
extends BaseRequestTest {
    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicDeletionClusterHasOfflinePartitions() {
        String offlineTopic = "topic-1";
        String onlineTopic = "topic-2";
        this.createTopicWithAssignment(offlineTopic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})))}))), this.createTopicWithAssignment$default$3());
        this.createTopicWithAssignment(onlineTopic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})))}))), this.createTopicWithAssignment$default$3());
        this.killBroker(0);
        this.ensureConsistentKRaftMetadata();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicsRequestTest.$anonfun$testTopicDeletionClusterHasOfflinePartitions$1(this, onlineTopic, offlineTopic)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Topic partition is not offline");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.deleteTopic(onlineTopic, this.deleteTopic$default$2());
        this.deleteTopic(offlineTopic, this.deleteTopic$default$2());
        this.ensureConsistentKRaftMetadata();
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteTopicsRequestTest.$anonfun$testTopicDeletionClusterHasOfflinePartitions$5(this, onlineTopic, offlineTopic)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"The topics are found in the Broker's cache");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testValidDeleteTopicRequests() {
        int timeout = 10000;
        this.createTopic("topic-1", this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.validateValidDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList("topic-1")).setTimeoutMs(timeout)).build());
        this.createTopic("topic-3", 5, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic("topic-4", 1, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.validateValidDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList("topic-3", "topic-4")).setTimeoutMs(timeout)).build());
        this.createTopic("topic-7", 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic("topic-6", 1, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        scala.collection.immutable.Map<String, Uuid> ids = this.getTopicIds();
        this.validateValidDeleteTopicRequestsWithIds((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopics(Arrays.asList(new DeleteTopicsRequestData.DeleteTopicState().setTopicId((Uuid)ids.apply((Object)"topic-7")), new DeleteTopicsRequestData.DeleteTopicState().setTopicId((Uuid)ids.apply((Object)"topic-6")))).setTimeoutMs(timeout)).build());
    }

    private void validateValidDeleteTopicRequests(DeleteTopicsRequest request) {
        DeleteTopicsResponse response = this.sendDeleteTopicsRequest(request, this.adminSocketServer());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.MapHasAsScala(response.errorCounts()).asScala().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$validateValidDeleteTopicRequests$1(x$5))).isEmpty(), (String)("There should be no errors, found " + CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)response.data().responses()).asScala()));
        this.ensureConsistentKRaftMetadata();
        request.data().topicNames().forEach(topic -> this.validateTopicIsDeleted((String)topic));
    }

    private void validateValidDeleteTopicRequestsWithIds(DeleteTopicsRequest request) {
        DeleteTopicsResponse response2 = this.sendDeleteTopicsRequest(request, this.adminSocketServer());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.MapHasAsScala(response2.errorCounts()).asScala().find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$validateValidDeleteTopicRequestsWithIds$1(x$6))).isEmpty(), (String)("There should be no errors, found " + CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)response2.data().responses()).asScala()));
        this.ensureConsistentKRaftMetadata();
        response2.data().responses().forEach(response -> this.validateTopicIsDeleted(response.name()));
    }

    /*
     * WARNING - void declaration
     */
    private void validateTopicIsDeleted(String topic) {
        Iterable metadata = CollectionConverters$.MODULE$.CollectionHasAsScala(((MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic, (List)Nil$.MODULE$)).asJava(), true).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class))).topicMetadata()).asScala();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicsRequestTest.$anonfun$validateTopicIsDeleted$1(metadata, topic)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DeleteTopicsRequestTest.$anonfun$validateTopicIsDeleted$3(topic));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private DeleteTopicsResponse sendDeleteTopicsRequest(DeleteTopicsRequest request, SocketServer socketServer) {
        return (DeleteTopicsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DeleteTopicsResponse.class));
    }

    private SocketServer sendDeleteTopicsRequest$default$2() {
        return this.adminSocketServer();
    }

    @Test
    public void testDeleteTopicsVersions() {
        int timeout = 10000;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.DELETE_TOPICS.oldestVersion()), (int)ApiKeys.DELETE_TOPICS.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Creating and deleting tests for version " + version);
            String topicName = "topic-" + version;
            this.createTopic(topicName, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
            DeleteTopicsRequestData data = new DeleteTopicsRequestData().setTimeoutMs(timeout);
            if (version < 6) {
                data.setTopicNames(Arrays.asList(topicName));
            } else {
                data.setTopics(Arrays.asList(new DeleteTopicsRequestData.DeleteTopicState().setName(topicName)));
            }
            this.validateValidDeleteTopicRequests(new DeleteTopicsRequest.Builder(data).build((short)version));
        });
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletionClusterHasOfflinePartitions$1(DeleteTopicsRequestTest $this, String onlineTopic$1, String offlineTopic$1) {
        return ((KafkaBroker)$this.aliveBrokers().head()).metadataCache().getLeaderAndIsr(onlineTopic$1, 0).filter(x$1 -> x$1.leader() == 1).isPresent() && ((KafkaBroker)$this.aliveBrokers().head()).metadataCache().getLeaderAndIsr(offlineTopic$1, 0).filter(x$2 -> x$2.leader() == -1).isPresent();
    }

    public static final /* synthetic */ String $anonfun$testTopicDeletionClusterHasOfflinePartitions$4() {
        return "Topic partition is not offline";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletionClusterHasOfflinePartitions$6(String onlineTopic$1, KafkaBroker x$3) {
        return x$3.metadataCache().contains(onlineTopic$1);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletionClusterHasOfflinePartitions$7(String offlineTopic$1, KafkaBroker x$4) {
        return x$4.metadataCache().contains(offlineTopic$1);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletionClusterHasOfflinePartitions$5(DeleteTopicsRequestTest $this, String onlineTopic$1, String offlineTopic$1) {
        return !$this.aliveBrokers().forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$testTopicDeletionClusterHasOfflinePartitions$6(onlineTopic$1, x$3))) && !$this.aliveBrokers().forall((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$testTopicDeletionClusterHasOfflinePartitions$7(offlineTopic$1, x$4)));
    }

    public static final /* synthetic */ String $anonfun$testTopicDeletionClusterHasOfflinePartitions$8() {
        return "The topics are found in the Broker's cache";
    }

    public static final /* synthetic */ boolean $anonfun$validateValidDeleteTopicRequests$1(Tuple2 x$5) {
        Object object = x$5._1();
        Errors errors = Errors.NONE;
        return object == null ? errors != null : !object.equals(errors);
    }

    public static final /* synthetic */ boolean $anonfun$validateValidDeleteTopicRequestsWithIds$1(Tuple2 x$6) {
        Object object = x$6._1();
        Errors errors = Errors.NONE;
        return object == null ? errors != null : !object.equals(errors);
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicIsDeleted$2(String topic$1, MetadataResponse.TopicMetadata p) {
        if (p.topic().equals(topic$1)) {
            Errors errors = p.error();
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicIsDeleted$1(Iterable metadata$1, String topic$1) {
        return !metadata$1.exists((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$validateTopicIsDeleted$2(topic$1, p)));
    }

    public static final /* synthetic */ String $anonfun$validateTopicIsDeleted$3(String topic$1) {
        return "The topic " + topic$1 + " should not exist";
    }
}

