/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import kafka.network.SocketServer;
import kafka.server.IntegrationTestUtils$;
import kafka.server.KafkaRaftServer$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.DescribeQuorumResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.DescribeQuorumRequest;
import org.apache.kafka.common.requests.DescribeQuorumResponse;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.test.api.ClusterTestDefaults;
import org.apache.kafka.common.test.api.Type;
import org.junit.jupiter.api.Assertions;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ClusterTestDefaults(types={Type.KRAFT})
@ScalaSignature(bytes="\u0006\u0005m3A!\u0002\u0004\u0001\u0017!A!\u0003\u0001B\u0001B\u0003%1\u0003C\u0003!\u0001\u0011\u0005\u0011\u0005C\u0003&\u0001\u0011\u0005a\u0005C\u00032\u0001\u0011%!GA\rEKN\u001c'/\u001b2f#V|'/^7SKF,Xm\u001d;UKN$(BA\u0004\t\u0003\u0019\u0019XM\u001d<fe*\t\u0011\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g-A\u0004dYV\u001cH/\u001a:\u0011\u0005QqR\"A\u000b\u000b\u0005Y9\u0012\u0001\u0002;fgRT!\u0001G\r\u0002\r\r|W.\\8o\u0015\tI!D\u0003\u0002\u001c9\u00051\u0011\r]1dQ\u0016T\u0011!H\u0001\u0004_J<\u0017BA\u0010\u0016\u0005=\u0019E.^:uKJLen\u001d;b]\u000e,\u0017A\u0002\u001fj]&$h\b\u0006\u0002#IA\u00111\u0005A\u0007\u0002\r!)!C\u0001a\u0001'\u0005\u0011B/Z:u\t\u0016\u001c8M]5cKF+xN];n)\u00059\u0003CA\u0007)\u0013\tIcB\u0001\u0003V]&$\bFA\u0002,!\tas&D\u0001.\u0015\tqS#A\u0002ba&L!\u0001M\u0017\u0003\u0017\rcWo\u001d;feR+7\u000f^\u0001\u0012G>tg.Z2u\u0003:$'+Z2fSZ,WCA\u001a8)\t!4\n\u0006\u00026\u0007B\u0011ag\u000e\u0007\u0001\t\u0015ADA1\u0001:\u0005\u0005!\u0016C\u0001\u001e>!\ti1(\u0003\u0002=\u001d\t9aj\u001c;iS:<\u0007C\u0001 B\u001b\u0005y$B\u0001!\u0018\u0003!\u0011X-];fgR\u001c\u0018B\u0001\"@\u0005A\t%m\u001d;sC\u000e$(+Z:q_:\u001cX\rC\u0003E\t\u0001\u000fQ)\u0001\u0005dY\u0006\u001c8\u000fV1h!\r1\u0015*N\u0007\u0002\u000f*\u0011\u0001JD\u0001\be\u00164G.Z2u\u0013\tQuI\u0001\u0005DY\u0006\u001c8\u000fV1h\u0011\u0015aE\u00011\u0001N\u0003\u001d\u0011X-];fgR\u0004\"A\u0010(\n\u0005={$aD!cgR\u0014\u0018m\u0019;SKF,Xm\u001d;)\t\u0001\tF+\u0016\t\u0003YIK!aU\u0017\u0003'\rcWo\u001d;feR+7\u000f\u001e#fM\u0006,H\u000e^:\u0002\u000bQL\b/Z:-\u0003Y#\u0013aV\u0005\u00031f\u000bQa\u0013*B\rRS!AW\u0017\u0002\tQK\b/\u001a")
public class DescribeQuorumRequestTest {
    private final ClusterInstance cluster;

    @ClusterTest
    public void testDescribeQuorum() {
        CollectionConverters$.MODULE$.ListHasAsScala(ApiKeys.DESCRIBE_QUORUM.allVersions()).asScala().foreach((Function1 & Serializable)version -> {
            DescribeQuorumRequestTest.$anonfun$testDescribeQuorum$1(this, version);
            return BoxedUnit.UNIT;
        });
    }

    private <T extends AbstractResponse> T connectAndReceive(AbstractRequest request, ClassTag<T> classTag) {
        return IntegrationTestUtils$.MODULE$.connectAndReceive(request, (SocketServer)CollectionConverters$.MODULE$.CollectionHasAsScala(this.cluster.brokerSocketServers()).asScala().head(), this.cluster.clientListener(), classTag);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorum$2(int leaderId$1, DescribeQuorumResponseData.ReplicaState x$1) {
        return x$1.replicaId() == leaderId$1;
    }

    public static final /* synthetic */ void $anonfun$testDescribeQuorum$6(Short version$1, DescribeQuorumResponseData.ReplicaState state) {
        Assertions.assertTrue((0L < state.logEndOffset() ? 1 : 0) != 0);
        if (BoxesRunTime.equalsNumObject((Number)version$1, (Object)BoxesRunTime.boxToInteger((int)0))) {
            Assertions.assertEquals((long)-1L, (long)state.lastFetchTimestamp());
            Assertions.assertEquals((long)-1L, (long)state.lastCaughtUpTimestamp());
            return;
        }
        Assertions.assertNotEquals((long)-1L, (long)state.lastFetchTimestamp());
        Assertions.assertNotEquals((long)-1L, (long)state.lastCaughtUpTimestamp());
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorum$8(DescribeQuorumRequestTest $this, DescribeQuorumResponseData.Node x$5) {
        return BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)x$5.nodeId()), (Object)CollectionConverters$.MODULE$.SetHasAsScala($this.cluster.controllers().keySet()).asScala().head());
    }

    public static final /* synthetic */ void $anonfun$testDescribeQuorum$1(DescribeQuorumRequestTest $this, Short version) {
        DescribeQuorumRequest request = new DescribeQuorumRequest.Builder(DescribeQuorumRequest.singletonRequest((TopicPartition)KafkaRaftServer$.MODULE$.MetadataPartition())).build(Predef$.MODULE$.Short2short(version));
        DescribeQuorumResponse response = (DescribeQuorumResponse)$this.connectAndReceive((AbstractRequest)request, ClassTag$.MODULE$.apply(DescribeQuorumResponse.class));
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)response.data().errorCode()));
        Assertions.assertEquals((Object)"", (Object)response.data().errorMessage());
        Assertions.assertEquals((int)1, (int)response.data().topics().size());
        DescribeQuorumResponseData.TopicData topicData = (DescribeQuorumResponseData.TopicData)response.data().topics().get(0);
        Assertions.assertEquals((Object)KafkaRaftServer$.MODULE$.MetadataTopic(), (Object)topicData.topicName());
        Assertions.assertEquals((int)1, (int)topicData.partitions().size());
        DescribeQuorumResponseData.PartitionData partitionData = (DescribeQuorumResponseData.PartitionData)topicData.partitions().get(0);
        Assertions.assertEquals((int)KafkaRaftServer$.MODULE$.MetadataPartition().partition(), (int)partitionData.partitionIndex());
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)partitionData.errorCode()));
        Assertions.assertEquals((Object)"", (Object)partitionData.errorMessage());
        Assertions.assertTrue((partitionData.leaderEpoch() > 0 ? 1 : 0) != 0);
        int leaderId = partitionData.leaderId();
        Assertions.assertTrue((leaderId > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((partitionData.leaderEpoch() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((partitionData.highWatermark() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((((DescribeQuorumResponseData.ReplicaState)CollectionConverters$.MODULE$.ListHasAsScala(partitionData.currentVoters()).asScala().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DescribeQuorumRequestTest.$anonfun$testDescribeQuorum$2(leaderId, x$1))).getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)"Failed to find leader among current voter states");
        })).logEndOffset() > 0L ? 1 : 0) != 0);
        Buffer voterData = CollectionConverters$.MODULE$.ListHasAsScala(partitionData.currentVoters()).asScala();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsScala($this.cluster.controllerIds()).asScala(), (Object)((IterableOnceOps)voterData.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.replicaId()))).toSet());
        Buffer observerData = CollectionConverters$.MODULE$.ListHasAsScala(partitionData.observers()).asScala();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsScala($this.cluster.brokerIds()).asScala(), (Object)((IterableOnceOps)observerData.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.replicaId()))).toSet());
        ((IterableOnceOps)voterData.$plus$plus((IterableOnce)observerData)).foreach((Function1 & Serializable)state -> {
            DescribeQuorumRequestTest.$anonfun$testDescribeQuorum$6(version, state);
            return BoxedUnit.UNIT;
        });
        if (Predef$.MODULE$.Short2short(version) >= 2) {
            Iterable nodes = CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)response.data().nodes()).asScala();
            Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsScala($this.cluster.controllerIds()).asScala(), (Object)((IterableOnceOps)nodes.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.nodeId()))).toSet());
            Option node = nodes.find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DescribeQuorumRequestTest.$anonfun$testDescribeQuorum$8($this, x$5)));
            Assertions.assertEquals((Object)$this.cluster.controllerListenerName().value(), (Object)((DescribeQuorumResponseData.Listener)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)((DescribeQuorumResponseData.Node)node.get()).listeners()).asScala().head()).name());
            return;
        }
    }

    public DescribeQuorumRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }
}

