/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogManager;
import kafka.network.ConnectionQuotas;
import kafka.server.BrokerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterClientQuotasOptions;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.coordinator.group.GroupConfig;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.storage.internals.log.UnifiedLog;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=100L)
@ScalaSignature(bytes="\u0006\u0005\u0005Me\u0001B\u000e\u001d\u0001\u0005BQ\u0001\u000b\u0001\u0005\u0002%BQ\u0001\f\u0001\u0005B5BQ!\u000f\u0001\u0005\u0002iBQ\u0001\u0014\u0001\u0005\u0002iBQA\u0014\u0001\u0005\n=CQ\u0001\u001e\u0001\u0005\u0002iBQA\u001e\u0001\u0005\u0002iBQ\u0001\u001f\u0001\u0005\u0002iBQA\u001f\u0001\u0005\u0002iBQ\u0001 \u0001\u0005\u0002iBQA \u0001\u0005\u0002iBa!!\u0001\u0001\t\u0003Q\u0004BBA\u0003\u0001\u0011\u0005!\bC\u0004\u0002\n\u0001!I!a\u0003\t\r\u00055\u0001\u0001\"\u0001;\u0011\u0019\t\t\u0002\u0001C\u0001u!9\u0011Q\u0003\u0001\u0005\n\u0005]\u0001bBA\u0014\u0001\u0011%\u0011\u0011\u0006\u0005\b\u0003[\u0001A\u0011BA\u0018\u0011\u0019\t\u0019\u0007\u0001C\u0001u!1\u0011q\r\u0001\u0005\u0002iBa!a\u001b\u0001\t\u0003Q\u0004BBA8\u0001\u0011\u0005!\b\u0003\u0004\u0002t\u0001!\tA\u000f\u0005\u0007\u0003o\u0002A\u0011\u0001\u001e\t\u000f\u0005m\u0004\u0001\"\u0003\u0002~\t9B)\u001f8b[&\u001c7i\u001c8gS\u001e\u001c\u0005.\u00198hKR+7\u000f\u001e\u0006\u0003;y\taa]3sm\u0016\u0014(\"A\u0010\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\t\t\u0003G\u0019j\u0011\u0001\n\u0006\u0003Ky\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]&\u0011q\u0005\n\u0002\u0017\u0017\u000647.Y*feZ,'\u000fV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012A\u000b\t\u0003W\u0001i\u0011\u0001H\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\ta\u0006E\u00020iYj\u0011\u0001\r\u0006\u0003cI\n!bY8mY\u0016\u001cG/[8o\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b1\u0005\r\u0019V-\u001d\t\u0003W]J!\u0001\u000f\u000f\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0011i\u0016\u001cHoQ8oM&<7\t[1oO\u0016$\u0012a\u000f\t\u0003yuj\u0011AM\u0005\u0003}I\u0012A!\u00168ji\"\u00121\u0001\u0011\t\u0003\u0003*k\u0011A\u0011\u0006\u0003\u0007\u0012\u000b1!\u00199j\u0015\t)e)A\u0004kkBLG/\u001a:\u000b\u0005\u001dC\u0015!\u00026v]&$(\"A%\u0002\u0007=\u0014x-\u0003\u0002L\u0005\n!A+Z:u\u0003q!Xm\u001d;Es:\fW.[2U_BL7mQ8oM&<7\t[1oO\u0016D#\u0001\u0002!\u0002+Q,7\u000f^)v_R\f7i\u001c8gS\u001e\u001c\u0005.\u00198hKR!1\bU/h\u0011\u0015\tV\u00011\u0001S\u0003\u0019)g\u000e^5usB\u00111kW\u0007\u0002)*\u0011QKV\u0001\u0006cV|G/\u0019\u0006\u0003/b\u000baaY8n[>t'BA\u0010Z\u0015\tQ\u0006*\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u00039R\u0013\u0011c\u00117jK:$\u0018+^8uC\u0016sG/\u001b;z\u0011\u0015qV\u00011\u0001`\u0003\u0011)8/\u001a:\u0011\u0005\u0001,W\"A1\u000b\u0005\t\u001c\u0017\u0001B1vi\"T!\u0001\u001a,\u0002\u0011M,7-\u001e:jifL!AZ1\u0003\u001d-\u000bgm[1Qe&t7-\u001b9bY\")\u0001.\u0002a\u0001S\u0006A1\r\\5f]RLE\r\u0005\u0002kc:\u00111n\u001c\t\u0003YJj\u0011!\u001c\u0006\u0003]\u0002\na\u0001\u0010:p_Rt\u0014B\u000193\u0003\u0019\u0001&/\u001a3fM&\u0011!o\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005A\u0014\u0014!\b;fgR\u001cE.[3oi&#\u0017+^8uC\u000e{gNZ5h\u0007\"\fgnZ3)\u0005\u0019\u0001\u0015!\u0007;fgR,6/\u001a:Rk>$\u0018mQ8oM&<7\t[1oO\u0016D#a\u0002!\u00027Q,7\u000f^+tKJ\u001cE.[3oi&#\u0017+^8uC\u000eC\u0017M\\4fQ\tA\u0001)\u0001\u0013uKN$H)\u001a4bk2$8\t\\5f]RLE-U;pi\u0006\u001cuN\u001c4jO\u000eC\u0017M\\4fQ\tI\u0001)\u0001\u0011uKN$H)\u001a4bk2$Xk]3s#V|G/Y\"p]\u001aLwm\u00115b]\u001e,\u0007F\u0001\u0006A\u0003!\"Xm\u001d;EK\u001a\fW\u000f\u001c;Vg\u0016\u00148\t\\5f]RLE-U;pi\u0006\u001cuN\u001c4jO\u000eC\u0017M\\4fQ\tY\u0001)A\ruKN$\u0018\n])v_R\f\u0017J\\5uS\u0006d\u0017N_1uS>t\u0007F\u0001\u0007A\u0003]!Xm\u001d;JaF+x\u000e^1D_:4\u0017nZ\"iC:<W\r\u000b\u0002\u000e\u0001\u0006IA/Z7q)>\u0004\u0018n\u0019\u000b\u0002S\u0006\tD/Z:u\u0007>tg-[4DQ\u0006tw-Z(o\u001d>tW\t_5ti&tw\rV8qS\u000e<\u0016\u000e\u001e5BI6Lgn\u00117jK:$\bFA\bA\u0003\u0019\"Xm\u001d;J]\u000e\u0014X-\\3oi\u0006d\u0017\t\u001c;fe\u0012+g-Y;miR{\u0007/[2D_:4\u0017n\u001a\u0015\u0003!\u0001\u000b\u0001c]3u\u0005J|7.\u001a:D_:4\u0017nZ:\u0015\u000bm\nI\"!\b\t\r\u0005m\u0011\u00031\u0001j\u0003!\u0011'o\\6fe&#\u0007bBA\u0010#\u0001\u0007\u0011\u0011E\u0001\t]\u0016<h+\u00197vKB\u0019A(a\t\n\u0007\u0005\u0015\"G\u0001\u0003M_:<\u0017a\u00053fY\u0016$XM\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001cHcA\u001e\u0002,!1\u00111\u0004\nA\u0002%\f!#\u00197uKJ\u0014%o\\6fe\u000e{gNZ5hgR91(!\r\u00024\u0005U\u0002BBA\u000e'\u0001\u0007\u0011\u000eC\u0004\u0002 M\u0001\r!!\t\t\u000f\u0005]2\u00031\u0001\u0002:\u0005\u0011q\u000e\u001d\t\u0005\u0003w\tiF\u0004\u0003\u0002>\u0005]c\u0002BA \u0003#rA!!\u0011\u0002N9!\u00111IA&\u001d\u0011\t)%!\u0013\u000f\u00071\f9%C\u0001J\u0013\tQ\u0006*\u0003\u0002 3&\u0019\u0011q\n-\u0002\u000f\rd\u0017.\u001a8ug&!\u00111KA+\u0003\u0015\tG-\\5o\u0015\r\ty\u0005W\u0005\u0005\u00033\nY&A\u0007BYR,'oQ8oM&<w\n\u001d\u0006\u0005\u0003'\n)&\u0003\u0003\u0002`\u0005\u0005$AB(q)f\u0004XM\u0003\u0003\u0002Z\u0005m\u0013!\t;fgR\u0014%o\\6fe&#7i\u001c8gS\u001e\u001c\u0005.\u00198hK\u0006sG\rR3mKR,\u0007F\u0001\u000bA\u0003!\"Xm\u001d;EK\u001a\fW\u000f\u001c;Ce>\\WM]%e\u0007>tg-[4DQ\u0006tw-Z!oI\u0012+G.\u001a;fQ\t)\u0002)\u0001\u0012uKN$H)\u001a4bk2$\u0018I\u001c3Ce>\\WM]%e\u0007>tg-[4DQ\u0006tw-\u001a\u0015\u0003-\u0001\u000bA\u0004^3ti\u0012Kh.Y7jG\u001e\u0013x.\u001e9D_:4\u0017nZ\"iC:<W\r\u000b\u0002\u0018\u0001\u0006\tC/Z:u\tft\u0017-\\5d'\"\f'/Z$s_V\u00048i\u001c8gS\u001e\u001c\u0005.\u00198hK\"\u0012\u0001\u0004Q\u0001'i\u0016\u001cH/\u00138de\u0016lWM\u001c;bY\u0006cG/\u001a:EK\u001a\fW\u000f\u001c;He>,\boQ8oM&<\u0007FA\rA\u0003E\u0019'/Z1uK\u0006#W.\u001b8DY&,g\u000e\u001e\u000b\u0003\u0003\u007f\u0002B!!!\u0002\u00046\u0011\u00111L\u0005\u0005\u0003\u000b\u000bYFA\u0003BI6Lg\u000eK\u0004\u0001\u0003\u0013\u000by)!%\u0011\u0007\u0005\u000bY)C\u0002\u0002\u000e\n\u0013q\u0001V5nK>,H/A\u0003wC2,XMH\u0001e\u0001")
public class DynamicConfigChangeTest
extends KafkaServerTestHarness {
    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Properties cfg = TestUtils$.MODULE$.createBrokerConfig(0, true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        return new .colon.colon((Object)KafkaConfig$.MODULE$.fromProps(cfg), (List)Nil$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConfigChange() {
        Long oldVal = Predef$.MODULE$.long2Long(100000L);
        Long newVal = Predef$.MODULE$.long2Long(200000L);
        TopicPartition tp = new TopicPartition("test", 0);
        Properties logProps = new Properties();
        logProps.put("flush.messages", oldVal.toString());
        this.createTopic(tp.topic(), 1, 1, logProps, this.createTopic$default$5(), this.createTopic$default$6());
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testConfigChange$1(this, tp, oldVal);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var25_11 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        Object var11_6 = null;
        Object var14_7 = null;
        Object var17_10 = null;
        try (Admin admin = this.createAdminClient();){
            ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, tp.topic());
            AlterConfigOp op = new AlterConfigOp(new ConfigEntry("flush.messages", newVal.toString()), AlterConfigOp.OpType.SET);
            ConfigResource resource2 = new ConfigResource(ConfigResource.Type.BROKER, "");
            AlterConfigOp op2 = new AlterConfigOp(new ConfigEntry(ServerLogConfigs.LOG_FLUSH_INTERVAL_MS_CONFIG, newVal.toString()), AlterConfigOp.OpType.SET);
            admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource2), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)op2, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
        }
        long l2 = 10000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        LongRef retry_wait2 = LongRef.create((long)1L);
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testConfigChange$2(this, newVal, tp);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait2);
                    Object var26_23 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait2.elem);
                retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDynamicTopicConfigChange() {
        TopicPartition tp = new TopicPartition("test", 0);
        int oldSegmentSize = 0x200000;
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Integer.toString(oldSegmentSize));
        this.createTopic(tp.topic(), 1, 1, logProps, this.createTopic$default$5(), this.createTopic$default$6());
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$1(this, tp, oldSegmentSize);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var26_10 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        Object var12_5 = null;
        Object var15_6 = null;
        Object var18_9 = null;
        int newSegmentSize = 0x200000;
        try (Admin admin = this.createAdminClient();){
            ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, tp.topic());
            AlterConfigOp op = new AlterConfigOp(new ConfigEntry("segment.bytes", Integer.toString(newSegmentSize)), AlterConfigOp.OpType.SET);
            admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
        }
        LogManager qual$2 = ((KafkaBroker)this.brokers().head()).logManager();
        boolean x$4 = qual$2.getLog$default$2();
        UnifiedLog log = (UnifiedLog)qual$2.getLog(tp, x$4).get();
        long l2 = 10000L;
        TestUtils$ retry_this2 = TestUtils$.MODULE$;
        LongRef retry_wait2 = LongRef.create((long)1L);
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$2(newSegmentSize, log);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait2);
                    Object var27_25 = null;
                    retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait2.elem);
                retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                continue;
            }
            break;
        }
        Object var19_20 = null;
        Object var22_21 = null;
        Object var25_24 = null;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> TestUtils$.MODULE$.produceMessage(this.brokers(), tp.topic(), Integer.toString(i), (Long)null, 30000, 20000));
        Assertions.assertTrue((boolean)log.logSegments().stream().allMatch(x$1 -> x$1.size() > 1000), (String)"Log segment size change not applied");
    }

    /*
     * WARNING - void declaration
     */
    private void testQuotaConfigChange(ClientQuotaEntity entity, KafkaPrincipal user, String clientId) {
        try (Admin admin = this.createAdminClient();){
            java.util.List<ClientQuotaAlteration> alterations = Arrays.asList(new ClientQuotaAlteration(entity, Arrays.asList(new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(1000.0)), new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(2000.0)))));
            admin.alterClientQuotas(alterations).all().get();
            QuotaFactory.QuotaManagers quotaManagers = ((KafkaBroker)this.brokers().head()).dataPlaneRequestProcessor().quotas();
            long l = 10000L;
            TestUtils$ retry_this = TestUtils$.MODULE$;
            LongRef retry_wait = LongRef.create((long)1L);
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    DynamicConfigChangeTest.$anonfun$testQuotaConfigChange$1(quotaManagers, user, clientId);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                        Object var31_13 = null;
                        retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(retry_wait.elem);
                    retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                    continue;
                }
                break;
            }
            Object var13_8 = null;
            Object var16_9 = null;
            Object var19_12 = null;
            double defaultProducerQuota = Long.MAX_VALUE;
            double defaultConsumerQuota = Long.MAX_VALUE;
            java.util.List<ClientQuotaAlteration> removals = Arrays.asList(new ClientQuotaAlteration(entity, Arrays.asList(new ClientQuotaAlteration.Op("producer_byte_rate", null), new ClientQuotaAlteration.Op("consumer_byte_rate", null))));
            admin.alterClientQuotas(removals, new AlterClientQuotasOptions().validateOnly(true)).all().get();
            double upperBound_upperBound = 1000.0;
            Assertions.assertEquals((Object)new Quota(upperBound_upperBound, true), (Object)quotaManagers.produce().quota(user, clientId), (String)("User " + user + " clientId " + clientId + " must have same producer quota of 1000"));
            double upperBound_upperBound2 = 2000.0;
            Assertions.assertEquals((Object)new Quota(upperBound_upperBound2, true), (Object)quotaManagers.fetch().quota(user, clientId), (String)("User " + user + " clientId " + clientId + " must have same consumer quota of 2000"));
            admin.alterClientQuotas(removals).all().get();
            long l2 = 10000L;
            TestUtils$ retry_this2 = TestUtils$.MODULE$;
            LongRef retry_wait2 = LongRef.create((long)1L);
            long retry_startTime2 = System.currentTimeMillis();
            while (true) {
                try {
                    DynamicConfigChangeTest.$anonfun$testQuotaConfigChange$2(quotaManagers, user, clientId, defaultProducerQuota, defaultConsumerQuota);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this2.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait2);
                        Object var32_25 = null;
                        retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(retry_wait2.elem);
                    retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                    continue;
                }
                break;
            }
            Object var20_20 = null;
            Object var23_21 = null;
            Object var26_24 = null;
        }
    }

    @Test
    public void testClientIdQuotaConfigChange() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("client-id", "testClient");
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @Test
    public void testUserQuotaConfigChange() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("user", "ANONYMOUS");
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @Test
    public void testUserClientIdQuotaChange() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("user", "ANONYMOUS");
        m.put("client-id", "testClient");
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @Test
    public void testDefaultClientIdQuotaConfigChange() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("client-id", null);
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @Test
    public void testDefaultUserQuotaConfigChange() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("user", null);
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    @Test
    public void testDefaultUserClientIdQuotaConfigChange() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("user", null);
        m.put("client-id", null);
        this.testQuotaConfigChange(new ClientQuotaEntity(m), KafkaPrincipal.ANONYMOUS, "testClient");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIpQuotaInitialization() {
        KafkaBroker broker = (KafkaBroker)this.brokers().head();
        try (Admin admin = this.createAdminClient();){
            java.util.List<ClientQuotaAlteration> alterations = Arrays.asList(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", null)), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(20.0)))), new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", "1.2.3.4")), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0)))));
            admin.alterClientQuotas(alterations).all().get();
        }
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testIpQuotaInitialization$1(broker);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var12_10 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    @Test
    public void testIpQuotaConfigChange() {
        try (Admin admin = this.createAdminClient();){
            java.util.List<ClientQuotaAlteration> alterations = Arrays.asList(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", null)), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(20.0)))), new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", "1.2.3.4")), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", Predef$.MODULE$.double2Double(10.0)))));
            admin.alterClientQuotas(alterations).all().get();
            InetAddress overrideQuotaIp = InetAddress.getByName("1.2.3.4");
            this.verifyConnectionQuota$1(overrideQuotaIp, Predef$.MODULE$.int2Integer(10));
            InetAddress defaultQuotaIp = InetAddress.getByName("2.3.4.5");
            this.verifyConnectionQuota$1(defaultQuotaIp, Predef$.MODULE$.int2Integer(20));
            java.util.List<ClientQuotaAlteration> deletions1 = Arrays.asList(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", "1.2.3.4")), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", null))));
            admin.alterClientQuotas(deletions1).all().get();
            this.verifyConnectionQuota$1(overrideQuotaIp, Predef$.MODULE$.int2Integer(20));
            java.util.List<ClientQuotaAlteration> deletions2 = Arrays.asList(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("ip", null)), Collections.singletonList(new ClientQuotaAlteration.Op("connection_creation_rate", null))));
            admin.alterClientQuotas(deletions2).all().get();
            this.verifyConnectionQuota$1(overrideQuotaIp, Predef$.MODULE$.int2Integer(Integer.MAX_VALUE));
        }
    }

    private String tempTopic() {
        return "testTopic" + TestUtils$.MODULE$.random().nextInt(1000000);
    }

    @Test
    public void testConfigChangeOnNonExistingTopicWithAdminClient() {
        String topic = this.tempTopic();
        try (Admin admin = this.createAdminClient();){
            try {
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
                AlterConfigOp op = new AlterConfigOp(new ConfigEntry("flush.messages", "10000"), AlterConfigOp.OpType.SET);
                admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
                Assertions.fail((String)"Should fail with UnknownTopicOrPartitionException for topic doesn't exist");
            }
            catch (ExecutionException executionException) {
                Assertions.assertTrue((boolean)(executionException.getCause() instanceof UnknownTopicOrPartitionException));
            }
        }
    }

    @Test
    public void testIncrementalAlterDefaultTopicConfig() {
        try (Admin admin = this.createAdminClient();){
            ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, "");
            AlterConfigOp op = new AlterConfigOp(new ConfigEntry("flush.messages", "200000"), AlterConfigOp.OpType.SET);
            KafkaFuture future = admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all();
            TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)future);
        }
    }

    private void setBrokerConfigs(String brokerId, long newValue) {
        this.alterBrokerConfigs(brokerId, newValue, AlterConfigOp.OpType.SET);
    }

    private void deleteBrokerConfigs(String brokerId) {
        this.alterBrokerConfigs(brokerId, 0L, AlterConfigOp.OpType.DELETE);
    }

    private void alterBrokerConfigs(String brokerId, long newValue, AlterConfigOp.OpType op) {
        try (Admin admin = this.createAdminClient();){
            ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER, brokerId);
            AlterConfigOp configOp = new AlterConfigOp(new ConfigEntry("leader.replication.throttled.rate", Long.toString(newValue)), op);
            AlterConfigOp configOp2 = new AlterConfigOp(new ConfigEntry("follower.replication.throttled.rate", Long.toString(newValue)), op);
            AlterConfigOp configOp3 = new AlterConfigOp(new ConfigEntry("replica.alter.log.dirs.io.max.bytes.per.second", Long.toString(newValue)), op);
            Collection configOps = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)configOp, (List)new .colon.colon((Object)configOp2, (List)new .colon.colon((Object)configOp3, (List)Nil$.MODULE$)))).asJavaCollection();
            admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)configOps)}))).asJava()).all().get();
        }
    }

    @Test
    public void testBrokerIdConfigChangeAndDelete() {
        long newValue = 100000L;
        String brokerId = Integer.toString(((KafkaBroker)this.brokers().head()).config().brokerId());
        this.setBrokerConfigs(brokerId, newValue);
        this.brokers().foreach((Function1 & Serializable)b -> {
            DynamicConfigChangeTest.$anonfun$testBrokerIdConfigChangeAndDelete$1(brokerId, newValue, b);
            return BoxedUnit.UNIT;
        });
        this.deleteBrokerConfigs(brokerId);
        this.brokers().foreach((Function1 & Serializable)b -> {
            DynamicConfigChangeTest.$anonfun$testBrokerIdConfigChangeAndDelete$3(b);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDefaultBrokerIdConfigChangeAndDelete() {
        long newValue = 100000L;
        String brokerId = "";
        this.setBrokerConfigs(brokerId, newValue);
        this.brokers().foreach((Function1 & Serializable)b -> {
            DynamicConfigChangeTest.$anonfun$testDefaultBrokerIdConfigChangeAndDelete$1(newValue, b);
            return BoxedUnit.UNIT;
        });
        this.deleteBrokerConfigs(brokerId);
        this.brokers().foreach((Function1 & Serializable)b -> {
            DynamicConfigChangeTest.$anonfun$testDefaultBrokerIdConfigChangeAndDelete$3(b);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDefaultAndBrokerIdConfigChange() {
        long newValue = 100000L;
        String brokerId = Integer.toString(((KafkaBroker)this.brokers().head()).config().brokerId());
        this.setBrokerConfigs(brokerId, newValue);
        long newDefaultValue = 200000L;
        this.setBrokerConfigs("", newDefaultValue);
        this.brokers().foreach((Function1 & Serializable)b -> {
            DynamicConfigChangeTest.$anonfun$testDefaultAndBrokerIdConfigChange$1(brokerId, newValue, newDefaultValue, b);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDynamicGroupConfigChange() {
        int newSessionTimeoutMs = 50000;
        String consumerGroupId = "group-foo";
        try (Admin admin = this.createAdminClient();){
            ConfigResource resource = new ConfigResource(ConfigResource.Type.GROUP, consumerGroupId);
            AlterConfigOp op = new AlterConfigOp(new ConfigEntry("consumer.session.timeout.ms", Integer.toString(newSessionTimeoutMs)), AlterConfigOp.OpType.SET);
            admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
        }
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDynamicGroupConfigChange$1(this, consumerGroupId);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var15_13 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        Object var8_8 = null;
        Object var11_9 = null;
        Object var14_12 = null;
        GroupConfig groupConfig = (GroupConfig)((BrokerServer)this.brokerServers().head()).groupCoordinator().groupConfig(consumerGroupId).get();
        Assertions.assertEquals((int)newSessionTimeoutMs, (int)groupConfig.consumerSessionTimeoutMs());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDynamicShareGroupConfigChange() {
        int newRecordLockDurationMs = 50000;
        String shareGroupId = "group-foo";
        try (Admin admin = this.createAdminClient();){
            ConfigResource resource = new ConfigResource(ConfigResource.Type.GROUP, shareGroupId);
            AlterConfigOp op = new AlterConfigOp(new ConfigEntry("share.record.lock.duration.ms", Integer.toString(newRecordLockDurationMs)), AlterConfigOp.OpType.SET);
            admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
        }
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDynamicShareGroupConfigChange$1(this, shareGroupId);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var15_13 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        Object var8_8 = null;
        Object var11_9 = null;
        Object var14_12 = null;
        GroupConfig groupConfig = (GroupConfig)((BrokerServer)this.brokerServers().head()).groupCoordinator().groupConfig(shareGroupId).get();
        Assertions.assertEquals((int)newRecordLockDurationMs, (int)groupConfig.shareRecordLockDurationMs);
    }

    @Test
    public void testIncrementalAlterDefaultGroupConfig() {
        try (Admin admin = this.createAdminClient();){
            ConfigResource resource = new ConfigResource(ConfigResource.Type.GROUP, "");
            AlterConfigOp op = new AlterConfigOp(new ConfigEntry("consumer.session.timeout.ms", "200000"), AlterConfigOp.OpType.SET);
            KafkaFuture future = admin.incrementalAlterConfigs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all();
            TestUtils.assertFutureThrows(InvalidRequestException.class, (Future)future);
        }
    }

    private Admin createAdminClient() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        return Admin.create((Properties)props);
    }

    public static final /* synthetic */ void $anonfun$testConfigChange$1(DynamicConfigChangeTest $this, TopicPartition tp$1, Long oldVal$1) {
        LogManager qual$1 = ((KafkaBroker)$this.brokers().head()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option logOpt = qual$1.getLog(tp$1, x$2);
        Assertions.assertTrue((boolean)logOpt.isDefined());
        Assertions.assertEquals((Long)oldVal$1, (long)((UnifiedLog)logOpt.get()).config().flushInterval);
    }

    public static final /* synthetic */ void $anonfun$testConfigChange$2(DynamicConfigChangeTest $this, Long newVal$1, TopicPartition tp$1) {
        LogManager qual$2 = ((KafkaBroker)$this.brokers().head()).logManager();
        boolean x$4 = qual$2.getLog$default$2();
        Assertions.assertEquals((Long)newVal$1, (long)((UnifiedLog)qual$2.getLog((TopicPartition)tp$1, (boolean)x$4).get()).config().flushInterval);
    }

    public static final /* synthetic */ void $anonfun$testDynamicTopicConfigChange$1(DynamicConfigChangeTest $this, TopicPartition tp$2, int oldSegmentSize$1) {
        LogManager qual$1 = ((KafkaBroker)$this.brokers().head()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option logOpt = qual$1.getLog(tp$2, x$2);
        Assertions.assertTrue((boolean)logOpt.isDefined());
        Assertions.assertEquals((int)oldSegmentSize$1, (int)((UnifiedLog)logOpt.get()).config().segmentSize());
    }

    public static final /* synthetic */ void $anonfun$testDynamicTopicConfigChange$2(int newSegmentSize$1, UnifiedLog log$1) {
        Assertions.assertEquals((int)newSegmentSize$1, (int)log$1.config().segmentSize());
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigChange$1(QuotaFactory.QuotaManagers quotaManagers$1, KafkaPrincipal user$1, String clientId$1) {
        Quota overrideProducerQuota = quotaManagers$1.produce().quota(user$1, clientId$1);
        Quota overrideConsumerQuota = quotaManagers$1.fetch().quota(user$1, clientId$1);
        double upperBound_upperBound = 1000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound, true), (Object)overrideProducerQuota, (String)("User " + user$1 + " clientId " + clientId$1 + " must have overridden producer quota of 1000"));
        double upperBound_upperBound2 = 2000.0;
        Assertions.assertEquals((Object)new Quota(upperBound_upperBound2, true), (Object)overrideConsumerQuota, (String)("User " + user$1 + " clientId " + clientId$1 + " must have overridden consumer quota of 2000"));
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigChange$2(QuotaFactory.QuotaManagers quotaManagers$1, KafkaPrincipal user$1, String clientId$1, double defaultProducerQuota$1, double defaultConsumerQuota$1) {
        Quota producerQuota = quotaManagers$1.produce().quota(user$1, clientId$1);
        Quota consumerQuota = quotaManagers$1.fetch().quota(user$1, clientId$1);
        Assertions.assertEquals((Object)new Quota(defaultProducerQuota$1, true), (Object)producerQuota, (String)("User " + user$1 + " clientId " + clientId$1 + " must have reset producer quota to " + defaultProducerQuota$1));
        Assertions.assertEquals((Object)new Quota(defaultConsumerQuota$1, true), (Object)consumerQuota, (String)("User " + user$1 + " clientId " + clientId$1 + " must have reset consumer quota to " + defaultConsumerQuota$1));
    }

    public static final /* synthetic */ void $anonfun$testIpQuotaInitialization$1(KafkaBroker broker$1) {
        ConnectionQuotas connectionQuotas = broker$1.socketServer().connectionQuotas();
        Assertions.assertEquals((long)10L, (long)connectionQuotas.connectionRateForIp(InetAddress.getByName("1.2.3.4")));
        Assertions.assertEquals((long)20L, (long)connectionQuotas.connectionRateForIp(InetAddress.getByName("2.4.6.8")));
    }

    public static final /* synthetic */ void $anonfun$testIpQuotaConfigChange$1(ConnectionQuotas connectionQuotas$1, InetAddress ip$1, Integer expectedQuota$1) {
        int quota = connectionQuotas$1.connectionRateForIp(ip$1);
        Assertions.assertEquals((Integer)expectedQuota$1, (int)quota, (String)("Unexpected quota for IP " + ip$1));
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyConnectionQuota$1(InetAddress ip, Integer expectedQuota) {
        ConnectionQuotas connectionQuotas = ((KafkaBroker)this.brokers().head()).socketServer().connectionQuotas();
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testIpQuotaConfigChange$1(connectionQuotas, ip, expectedQuota);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var11_9 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testBrokerIdConfigChangeAndDelete$2(long value$1, KafkaBroker b$1) {
        Assertions.assertEquals((long)value$1, (long)b$1.quotaManagers().leader().upperBound());
        Assertions.assertEquals((long)value$1, (long)b$1.quotaManagers().follower().upperBound());
        Assertions.assertEquals((long)value$1, (long)b$1.quotaManagers().alterLogDirs().upperBound());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testBrokerIdConfigChangeAndDelete$1(String brokerId$1, long newValue$1, KafkaBroker b) {
        String string = Integer.toString(b.config().brokerId());
        long value = !(string != null ? !string.equals(brokerId$1) : brokerId$1 != null) ? newValue$1 : Long.MAX_VALUE;
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testBrokerIdConfigChangeAndDelete$2(value, b);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var13_9 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testBrokerIdConfigChangeAndDelete$4(KafkaBroker b$2) {
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)b$2.quotaManagers().leader().upperBound());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)b$2.quotaManagers().follower().upperBound());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)b$2.quotaManagers().alterLogDirs().upperBound());
    }

    public static final /* synthetic */ void $anonfun$testBrokerIdConfigChangeAndDelete$3(KafkaBroker b) {
        long retry_maxWaitMs = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testBrokerIdConfigChangeAndDelete$4(b);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var8_6 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testDefaultBrokerIdConfigChangeAndDelete$2(long newValue$2, KafkaBroker b$3) {
        Assertions.assertEquals((long)newValue$2, (long)b$3.quotaManagers().leader().upperBound());
        Assertions.assertEquals((long)newValue$2, (long)b$3.quotaManagers().follower().upperBound());
        Assertions.assertEquals((long)newValue$2, (long)b$3.quotaManagers().alterLogDirs().upperBound());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDefaultBrokerIdConfigChangeAndDelete$1(long newValue$2, KafkaBroker b) {
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDefaultBrokerIdConfigChangeAndDelete$2(newValue$2, b);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var10_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testDefaultBrokerIdConfigChangeAndDelete$4(KafkaBroker b$4) {
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)b$4.quotaManagers().leader().upperBound());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)b$4.quotaManagers().follower().upperBound());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)b$4.quotaManagers().alterLogDirs().upperBound());
    }

    public static final /* synthetic */ void $anonfun$testDefaultBrokerIdConfigChangeAndDelete$3(KafkaBroker b) {
        long retry_maxWaitMs = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDefaultBrokerIdConfigChangeAndDelete$4(b);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var8_6 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testDefaultAndBrokerIdConfigChange$2(long value$2, KafkaBroker b$5) {
        Assertions.assertEquals((long)value$2, (long)b$5.quotaManagers().leader().upperBound());
        Assertions.assertEquals((long)value$2, (long)b$5.quotaManagers().follower().upperBound());
        Assertions.assertEquals((long)value$2, (long)b$5.quotaManagers().alterLogDirs().upperBound());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDefaultAndBrokerIdConfigChange$1(String brokerId$2, long newValue$3, long newDefaultValue$1, KafkaBroker b) {
        String string = Integer.toString(b.config().brokerId());
        long value = !(string != null ? !string.equals(brokerId$2) : brokerId$2 != null) ? newValue$3 : newDefaultValue$1;
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDefaultAndBrokerIdConfigChange$2(value, b);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var15_10 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testDynamicGroupConfigChange$1(DynamicConfigChangeTest $this, String consumerGroupId$1) {
        ((KafkaBroker)$this.brokers().head()).groupCoordinator().groupMetadataTopicConfigs();
        Assertions.assertTrue((boolean)((BrokerServer)$this.brokerServers().head()).groupCoordinator().groupConfig(consumerGroupId$1).isPresent());
    }

    public static final /* synthetic */ void $anonfun$testDynamicShareGroupConfigChange$1(DynamicConfigChangeTest $this, String shareGroupId$1) {
        ((KafkaBroker)$this.brokers().head()).groupCoordinator().groupMetadataTopicConfigs();
        Assertions.assertTrue((boolean)((BrokerServer)$this.brokerServers().head()).groupCoordinator().groupConfig(shareGroupId$1).isPresent());
    }
}

