/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.log.LogManager;
import kafka.server.AlterPartitionManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.server.ActionQueue;
import org.apache.kafka.server.DelayedActionQueue;
import org.apache.kafka.server.common.DirectoryEventHandler;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.config.AbstractKafkaConfig;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.UnifiedLog;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tEa\u0001\u0002\u0015*\u00019BQ!\u000e\u0001\u0005\u0002YBq!\u000f\u0001A\u0002\u0013\u0005!\bC\u0004Y\u0001\u0001\u0007I\u0011A-\t\r}\u0003\u0001\u0015)\u0003<\u0011\u001d\u0001\u0007A1A\u0005\u0002\u0005Da!\u001a\u0001!\u0002\u0013\u0011\u0007b\u00024\u0001\u0005\u0004%\ta\u001a\u0005\u0007Q\u0002\u0001\u000b\u0011B)\t\u000f%\u0004!\u0019!C\u0001O\"1!\u000e\u0001Q\u0001\nECqa\u001b\u0001C\u0002\u0013\u0005\u0011\r\u0003\u0004m\u0001\u0001\u0006IA\u0019\u0005\b[\u0002\u0011\r\u0011\"\u0001o\u0011\u00199\b\u0001)A\u0005_\"9\u0001\u0010\u0001b\u0001\n\u0003I\bB\u0002@\u0001A\u0003%!\u0010\u0003\u0005\u0000\u0001\t\u0007I\u0011AA\u0001\u0011!\ti\u0001\u0001Q\u0001\n\u0005\r\u0001\"CA\b\u0001\t\u0007I\u0011AA\t\u0011!\tI\u0003\u0001Q\u0001\n\u0005M\u0001\"CA\u0016\u0001\t\u0007I\u0011AA\u0017\u0011!\ti\u0004\u0001Q\u0001\n\u0005=\u0002bCA \u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0003B1\"!\u0017\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\\!Y\u0011q\f\u0001A\u0002\u0003\u0005\u000b\u0015BA\"\u0011-\t\t\u0007\u0001a\u0001\u0002\u0004%\t!a\u0019\t\u0017\u0005-\u0004\u00011AA\u0002\u0013\u0005\u0011Q\u000e\u0005\f\u0003c\u0002\u0001\u0019!A!B\u0013\t)\u0007C\u0006\u0002t\u0001\u0001\r\u00111A\u0005\u0002\u0005U\u0004bCAG\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u001fC1\"a%\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002x!9\u0011Q\u0013\u0001\u0005\u0002\u0005]\u0005bBAX\u0001\u0011\u0005\u0011q\u0013\u0005\b\u0003s\u0003A\u0011AAL\u0011\u001d\t\u0019\r\u0001C\u0001\u0003/Cq!a2\u0001\t\u0003\t9\nC\u0004\u0002L\u0002!\t!a&\t\u000f\u0005=\u0007\u0001\"\u0003\u0002R\"9!Q\u0002\u0001\u0005\n\t=!!E%te\u0016C\b/\u001b:bi&|g\u000eV3ti*\u0011!fK\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u00031\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001_A\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u001c\u0011\u0005a\u0002Q\"A\u0015\u0002#Q|\u0007/[2QCJ$\u0018\u000e^5p]&\u001b(/F\u0001<!\u0011a\u0014i\u0011+\u000e\u0003uR!AP \u0002\u000f5,H/\u00192mK*\u0011\u0001)M\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\">\u0005\ri\u0015\r\u001d\t\u0005a\u00113\u0015+\u0003\u0002Fc\t1A+\u001e9mKJ\u0002\"a\u0012(\u000f\u0005!c\u0005CA%2\u001b\u0005Q%BA&.\u0003\u0019a$o\\8u}%\u0011Q*M\u0001\u0007!J,G-\u001a4\n\u0005=\u0003&AB*ue&twM\u0003\u0002NcA\u0011\u0001GU\u0005\u0003'F\u00121!\u00138u!\r)f+U\u0007\u0002\u007f%\u0011qk\u0010\u0002\u0004'\u0016\f\u0018!\u0006;pa&\u001c\u0007+\u0019:uSRLwN\\%te~#S-\u001d\u000b\u00035v\u0003\"\u0001M.\n\u0005q\u000b$\u0001B+oSRDqAX\u0002\u0002\u0002\u0003\u00071(A\u0002yIE\n!\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|g.S:sA\u0005\u0019\"/\u001a9mS\u000e\fG*Y4US6,W*\u0019=NgV\t!\r\u0005\u00021G&\u0011A-\r\u0002\u0005\u0019>tw-\u0001\u000bsKBd\u0017nY1MC\u001e$\u0016.\\3NCbl5\u000fI\u0001\u0016e\u0016\u0004H.[2b\r\u0016$8\r[,bSRl\u0015\r_'t+\u0005\t\u0016A\u0006:fa2L7-\u0019$fi\u000eDw+Y5u\u001b\u0006DXj\u001d\u0011\u0002%1,\u0017\rZ3s\u0019><WI\u001c3PM\u001a\u001cX\r^\u0001\u0014Y\u0016\fG-\u001a:M_\u001e,e\u000eZ(gMN,G\u000fI\u0001\u0017Y\u0016\fG-\u001a:M_\u001eD\u0015n\u001a5XCR,'/\\1sW\u00069B.Z1eKJdun\u001a%jO\"<\u0016\r^3s[\u0006\u00148\u000eI\u0001\u0010_Z,'O]5eS:<\u0007K]8qgV\tq\u000e\u0005\u0002qk6\t\u0011O\u0003\u0002sg\u0006!Q\u000f^5m\u0015\u0005!\u0018\u0001\u00026bm\u0006L!A^9\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\tpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9tA\u000591m\u001c8gS\u001e\u001cX#\u0001>\u0011\u0007U36\u0010\u0005\u00029y&\u0011Q0\u000b\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0005d_:4\u0017nZ:!\u0003\u0015!x\u000e]5d+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tIa]\u0001\u0005Y\u0006tw-C\u0002P\u0003\u000f\ta\u0001^8qS\u000e\u0004\u0013\u0001\u0002;j[\u0016,\"!a\u0005\u0011\t\u0005U\u0011QE\u0007\u0003\u0003/Q1A]A\r\u0015\rQ\u00131\u0004\u0006\u0004Y\u0005u!\u0002BA\u0010\u0003C\ta!\u00199bG\",'BAA\u0012\u0003\ry'oZ\u0005\u0005\u0003O\t9B\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003\u001diW\r\u001e:jGN,\"!a\f\u0011\t\u0005E\u0012\u0011H\u0007\u0003\u0003gQA!a\u000b\u00026)!\u0011qGA\u000e\u0003\u0019\u0019w.\\7p]&!\u00111HA\u001a\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\rcV|G/Y'b]\u0006<WM]\u000b\u0003\u0003\u0007\u0002B!!\u0012\u0002T9!\u0011qIA(\u001d\u0011\tI%!\u0014\u000f\u0007%\u000bY%C\u0001-\u0013\tQ3&C\u0002\u0002R%\nA\"U;pi\u00064\u0015m\u0019;pefLA!!\u0016\u0002X\ti\u0011+^8uC6\u000bg.Y4feNT1!!\u0015*\u0003A\tXo\u001c;b\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000fF\u0002[\u0003;B\u0001B\u0018\r\u0002\u0002\u0003\u0007\u00111I\u0001\u000ecV|G/Y'b]\u0006<WM\u001d\u0011\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\u0011\u0011Q\r\t\u0004q\u0005\u001d\u0014bAA5S\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018A\u0005:fa2L7-Y'b]\u0006<WM]0%KF$2AWA8\u0011!q6$!AA\u0002\u0005\u0015\u0014a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002\u001f\u0005dG/\u001a:JgJl\u0015M\\1hKJ,\"!a\u001e\u0011\t\u0005e\u0014q\u0011\b\u0005\u0003w\n\tI\u0004\u0003\u0002J\u0005u\u0014bAA@W\u0005)Q\u000f^5mg&!\u00111QAC\u0003%!Vm\u001d;Vi&d7OC\u0002\u0002\u0000-JA!!#\u0002\f\nIRj\\2l\u00032$XM\u001d)beRLG/[8o\u001b\u0006t\u0017mZ3s\u0015\u0011\t\u0019)!\"\u0002'\u0005dG/\u001a:JgJl\u0015M\\1hKJ|F%Z9\u0015\u0007i\u000b\t\n\u0003\u0005_=\u0005\u0005\t\u0019AA<\u0003A\tG\u000e^3s\u0013N\u0014X*\u00198bO\u0016\u0014\b%A\u0003tKR,\u0006\u000fF\u0001[Q\r\u0001\u00131\u0014\t\u0005\u0003;\u000bY+\u0004\u0002\u0002 *!\u0011\u0011UAR\u0003\r\t\u0007/\u001b\u0006\u0005\u0003K\u000b9+A\u0004kkBLG/\u001a:\u000b\t\u0005%\u0016\u0011E\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003[\u000byJ\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004C\u0005M\u0006\u0003BAO\u0003kKA!a.\u0002 \nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001#i\u0016\u001cH/S:s\u000bb\u0004\u0018N]1uS>tgi\u001c:TiV\u001c7NR8mY><XM]:)\u0007\t\ni\f\u0005\u0003\u0002\u001e\u0006}\u0016\u0002BAa\u0003?\u0013A\u0001V3ti\u0006)C/Z:u\u0013N\u0014X\t\u001f9je\u0006$\u0018n\u001c8JM:{g)\u001a;dQJ+\u0017/^3ti6\u000bG-\u001a\u0015\u0004G\u0005u\u0016!\t;fgRL5O]#ya&\u0014\u0018\r^5p]\u001a{'o\u00157po\u001a{G\u000e\\8xKJ\u001c\bf\u0001\u0013\u0002>\u0006)C/Z:u\u0013N\u0014X\t\u001f9je\u0006$\u0018n\u001c8G_J\u001c\u0015-^4iiV\u0003hi\u001c7m_^,'o\u001d\u0015\u0004K\u0005u\u0016\u0001I4fiB\u000b'\u000f^5uS>tw+\u001b;i\u00032d'+\u001a9mS\u000e\f7/\u00138JgJ$B\"a5\u0002`\u0006\u0005\u0018Q]Ay\u0003k\u0004B!!6\u0002\\6\u0011\u0011q\u001b\u0006\u0004\u00033\\\u0013aB2mkN$XM]\u0005\u0005\u0003;\f9NA\u0005QCJ$\u0018\u000e^5p]\")qP\na\u0001\r\"1\u00111\u001d\u0014A\u0002E\u000b1\u0002]1si&$\u0018n\u001c8JI\"9\u0011q\u0002\u0014A\u0002\u0005\u001d\b\u0003BAu\u0003[l!!a;\u000b\t\u0005}\u0014QG\u0005\u0005\u0003_\fYO\u0001\u0003US6,\u0007BBAzM\u0001\u000710\u0001\u0004d_:4\u0017n\u001a\u0005\b\u0003o4\u0003\u0019AA}\u0003!awnY1m\u0019><\u0007\u0003BA~\u0005\u0013i!!!@\u000b\t\u0005}(\u0011A\u0001\u0004Y><'\u0002\u0002B\u0002\u0005\u000b\t\u0011\"\u001b8uKJt\u0017\r\\:\u000b\t\t\u001d\u00111D\u0001\bgR|'/Y4f\u0013\u0011\u0011Y!!@\u0003\u0015Us\u0017NZ5fI2{w-A\u0004m_\u001elunY6\u0016\u0005\u0005e\b")
public class IsrExpirationTest {
    private scala.collection.mutable.Map<Tuple2<String, Object>, Seq<Object>> topicPartitionIsr = new HashMap();
    private final long replicaLagTimeMaxMs;
    private final int replicaFetchWaitMaxMs;
    private final int leaderLogEndOffset;
    private final long leaderLogHighWatermark;
    private final Properties overridingProps = new Properties();
    private final Seq<KafkaConfig> configs;
    private final String topic;
    private final MockTime time;
    private final Metrics metrics;
    private QuotaFactory.QuotaManagers quotaManager;
    private ReplicaManager replicaManager;
    private TestUtils.MockAlterPartitionManager alterIsrManager;

    public scala.collection.mutable.Map<Tuple2<String, Object>, Seq<Object>> topicPartitionIsr() {
        return this.topicPartitionIsr;
    }

    public void topicPartitionIsr_$eq(scala.collection.mutable.Map<Tuple2<String, Object>, Seq<Object>> x$1) {
        this.topicPartitionIsr = x$1;
    }

    public long replicaLagTimeMaxMs() {
        return this.replicaLagTimeMaxMs;
    }

    public int replicaFetchWaitMaxMs() {
        return this.replicaFetchWaitMaxMs;
    }

    public int leaderLogEndOffset() {
        return this.leaderLogEndOffset;
    }

    public long leaderLogHighWatermark() {
        return this.leaderLogHighWatermark;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public QuotaFactory.QuotaManagers quotaManager() {
        return this.quotaManager;
    }

    public void quotaManager_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManager = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public TestUtils.MockAlterPartitionManager alterIsrManager() {
        return this.alterIsrManager;
    }

    public void alterIsrManager_$eq(TestUtils.MockAlterPartitionManager x$1) {
        this.alterIsrManager = x$1;
    }

    @BeforeEach
    public void setUp() {
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)logManager.liveLogDirs()).thenReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class))));
        this.alterIsrManager_$eq(new TestUtils.MockAlterPartitionManager());
        this.quotaManager_$eq(QuotaFactory.instantiate((KafkaConfig)((KafkaConfig)this.configs().head()), (Metrics)this.metrics(), (Time)this.time(), (String)"", (String)""));
        Metrics x$1 = this.metrics();
        KafkaConfig x$2 = (KafkaConfig)this.configs().head();
        MockTime x$3 = this.time();
        QuotaFactory.QuotaManagers x$6 = this.quotaManager();
        KRaftMetadataCache x$7 = new KRaftMetadataCache(((AbstractKafkaConfig)this.configs().head()).brokerId(), () -> KRaftVersion.KRAFT_VERSION_0);
        LogDirFailureChannel x$8 = new LogDirFailureChannel(((AbstractKafkaConfig)this.configs().head()).logDirs().size());
        TestUtils.MockAlterPartitionManager x$9 = this.alterIsrManager();
        None$ x$10 = None$.MODULE$;
        BrokerTopicStats x$11 = new BrokerTopicStats();
        AtomicBoolean x$12 = new AtomicBoolean(false);
        None$ x$13 = None$.MODULE$;
        None$ x$14 = None$.MODULE$;
        None$ x$15 = None$.MODULE$;
        None$ x$16 = None$.MODULE$;
        None$ x$17 = None$.MODULE$;
        None$ x$18 = None$.MODULE$;
        None$ x$19 = None$.MODULE$;
        Function0 x$20 = ReplicaManager$.MODULE$.$lessinit$greater$default$20();
        None$ x$21 = None$.MODULE$;
        DirectoryEventHandler x$22 = DirectoryEventHandler.NOOP;
        DelayedActionQueue x$23 = new DelayedActionQueue();
        this.replicaManager_$eq(new ReplicaManager(x$2, x$1, (Time)x$3, null, logManager, (Option)x$10, x$6, (MetadataCache)x$7, x$8, (AlterPartitionManager)x$9, x$11, x$12, (Option)x$13, (Option)x$14, (Option)x$15, (Option)x$16, (Option)x$17, (Option)x$18, (Option)x$19, x$20, (Option)x$21, x$22, (ActionQueue)x$23));
    }

    @AfterEach
    public void tearDown() {
        Option$.MODULE$.apply((Object)this.replicaManager()).foreach((Function1 & Serializable)x$5 -> {
            x$5.shutdown(false);
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)this.quotaManager()).foreach((Function1 & Serializable)x$6 -> {
            x$6.shutdown();
            return BoxedUnit.UNIT;
        });
        this.metrics().close();
    }

    @Test
    public void testIsrExpirationForStuckFollowers() {
        UnifiedLog log = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log);
        Assertions.assertEquals((Object)((IterableOnceOps)this.configs().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.brokerId()))).toSet(), (Object)partition0.inSyncReplicaIds(), (String)"All replicas should be in ISR");
        partition0.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchStateOrThrow(new LogOffsetMetadata((long)(this.leaderLogEndOffset() - 1)), 0L, this.time().milliseconds(), (long)this.leaderLogEndOffset(), 1L);
            return BoxedUnit.UNIT;
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR, (String)"No replica should be out of sync");
        this.time().sleep(150L);
        partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{((AbstractKafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR, (String)"Replica 1 should be out of sync");
        ((UnifiedLog)Mockito.verify((Object)log, (VerificationMode)Mockito.atLeastOnce())).logEndOffset();
    }

    @Test
    public void testIsrExpirationIfNoFetchRequestMade() {
        UnifiedLog log = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log);
        Assertions.assertEquals((Object)((IterableOnceOps)this.configs().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.brokerId()))).toSet(), (Object)partition0.inSyncReplicaIds(), (String)"All replicas should be in ISR");
        this.time().sleep(150L);
        Set partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{((AbstractKafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR, (String)"Replica 1 should be out of sync");
        ((UnifiedLog)Mockito.verify((Object)log, (VerificationMode)Mockito.atLeastOnce())).logEndOffset();
    }

    @Test
    public void testIsrExpirationForSlowFollowers() {
        UnifiedLog log = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log);
        Assertions.assertEquals((Object)((IterableOnceOps)this.configs().map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.brokerId()))).toSet(), (Object)partition0.inSyncReplicaIds(), (String)"All replicas should be in ISR");
        partition0.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchStateOrThrow(new LogOffsetMetadata((long)(this.leaderLogEndOffset() - 2)), 0L, this.time().milliseconds(), (long)this.leaderLogEndOffset(), 1L);
            return BoxedUnit.UNIT;
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR, (String)"No replica should be out of sync");
        this.time().sleep(75L);
        partition0.remoteReplicas().foreach((Function1 & Serializable)r -> {
            r.updateFetchStateOrThrow(new LogOffsetMetadata((long)(this.leaderLogEndOffset() - 1)), 0L, this.time().milliseconds(), (long)this.leaderLogEndOffset(), 1L);
            return BoxedUnit.UNIT;
        });
        partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR, (String)"No replica should be out of sync");
        this.time().sleep(75L);
        partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{((AbstractKafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR, (String)"Replica 1 should be out of sync");
        partition0.remoteReplicas().foreach((Function1 & Serializable)r -> {
            r.updateFetchStateOrThrow(new LogOffsetMetadata((long)this.leaderLogEndOffset()), 0L, this.time().milliseconds(), (long)this.leaderLogEndOffset(), 1L);
            return BoxedUnit.UNIT;
        });
        partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR, (String)"No replica should be out of sync");
        ((UnifiedLog)Mockito.verify((Object)log, (VerificationMode)Mockito.atLeastOnce())).logEndOffset();
    }

    @Test
    public void testIsrExpirationForCaughtUpFollowers() {
        UnifiedLog log = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log);
        Assertions.assertEquals((Object)((IterableOnceOps)this.configs().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.brokerId()))).toSet(), (Object)partition0.inSyncReplicaIds(), (String)"All replicas should be in ISR");
        partition0.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchStateOrThrow(new LogOffsetMetadata((long)this.leaderLogEndOffset()), 0L, this.time().milliseconds(), (long)this.leaderLogEndOffset(), 1L);
            return BoxedUnit.UNIT;
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR, (String)"No replica should be out of sync");
        this.time().sleep(150L);
        partition0OSR = partition0.getOutOfSyncReplicas(Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR, (String)"No replica should be out of sync");
        ((UnifiedLog)Mockito.verify((Object)log, (VerificationMode)Mockito.atLeastOnce())).logEndOffset();
    }

    private Partition getPartitionWithAllReplicasInIsr(String topic, int partitionId, Time time, KafkaConfig config, UnifiedLog localLog) {
        int leaderId = config.brokerId();
        TopicPartition tp = new TopicPartition(topic, partitionId);
        Partition partition = this.replicaManager().createPartition(tp);
        partition.setLog(localLog, false);
        partition.updateAssignmentAndIsr((Seq)this.configs().map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.brokerId())), true, ((IterableOnceOps)this.configs().map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.brokerId()))).toSet(), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty(), LeaderRecoveryState.RECOVERED);
        partition.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchStateOrThrow(new LogOffsetMetadata(0L), 0L, time.milliseconds(), 0L, 1L);
            return BoxedUnit.UNIT;
        });
        partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderId)));
        return partition;
    }

    private UnifiedLog logMock() {
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(this.leaderLogEndOffset())));
        return log;
    }

    public IsrExpirationTest() {
        this.replicaLagTimeMaxMs = 100L;
        this.replicaFetchWaitMaxMs = 100;
        this.leaderLogEndOffset = 20;
        this.leaderLogHighWatermark = 20L;
        this.overridingProps().put("replica.lag.time.max.ms", Long.toString(this.replicaLagTimeMaxMs()));
        this.overridingProps().put("replica.fetch.wait.max.ms", Integer.toString(this.replicaFetchWaitMaxMs()));
        this.configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
        this.topic = "foo";
        this.time = new MockTime();
        this.metrics = new Metrics();
    }
}

