/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.log.LogManager;
import kafka.network.SocketServer;
import kafka.raft.KafkaRaftManager;
import kafka.server.BadAuthorizer;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.DummyClientQuotaCallback;
import kafka.server.DummyClientQuotaCallback$;
import kafka.server.FakeConfigurableAuthorizer;
import kafka.server.FakeConfigurableAuthorizer$;
import kafka.server.HostedPartition;
import kafka.server.IntegrationTestUtils$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeMetadataQuorumOptions;
import org.apache.kafka.clients.admin.FeatureMetadata;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.FinalizedVersionRange;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.QuorumInfo;
import org.apache.kafka.clients.admin.SupportedVersionRange;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.UpdateFeaturesOptions;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.Plugin;
import org.apache.kafka.common.message.DescribeClusterRequestData;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeClusterRequest;
import org.apache.kafka.common.requests.DescribeClusterResponse;
import org.apache.kafka.common.test.KafkaClusterTestKit;
import org.apache.kafka.common.test.TestKitNodes;
import org.apache.kafka.controller.Controller;
import org.apache.kafka.controller.QuorumController;
import org.apache.kafka.controller.QuorumControllerIntegrationTestUtils;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.metadata.LeaderAndIsr;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.storage.internals.log.LocalLog;
import org.apache.kafka.storage.internals.log.UnifiedLog;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.CollectionConverters$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Using;
import scala.util.Using$;

@Timeout(value=120L)
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\r=g\u0001B\u001f?\u0001\rCQA\u0013\u0001\u0005\u0002-CqA\u0014\u0001C\u0002\u0013\u0005q\n\u0003\u0004Y\u0001\u0001\u0006I\u0001\u0015\u0005\b3\u0002\u0011\r\u0011\"\u0001P\u0011\u0019Q\u0006\u0001)A\u0005!\")1\f\u0001C\u00019\")1\u000e\u0001C\u00019\")Q\u000e\u0001C\u00019\")q\u000e\u0001C\u00019\")\u0011\u000f\u0001C\u00019\")1\u000f\u0001C\u00019\")Q\u000f\u0001C\u00019\")q\u000f\u0001C\u0001q\"9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0002BBA#\u0001\u0011\u0005A\f\u0003\u0004\u0002J\u0001!\t\u0001\u0018\u0005\u0007\u0003\u001b\u0002A\u0011\u0001/\t\u000f\u0005E\u0003\u0001\"\u0003\u0002T!9\u0011q\u000f\u0001\u0005\n\u0005e\u0004bBAY\u0001\u0011%\u00111\u0017\u0005\b\u0003/\u0004A\u0011BAm\u0011\u001d\t9\u000f\u0001C\u0005\u0003SDa!!?\u0001\t\u0003a\u0006bBA\u007f\u0001\u0011%\u0011q \u0005\b\u0005O\u0001A\u0011\u0002B\u0015\u0011\u001d\u0011I\u0005\u0001C\u0005\u0005\u0017BqAa\u0018\u0001\t\u0013\u0011\t\u0007C\u0004\u0003\n\u0002!IAa#\t\u0013\t\r\u0006!%A\u0005\n\t\u0015\u0006B\u0002B^\u0001\u0011\u0005A\f\u0003\u0004\u0003@\u0002!\t\u0001\u0018\u0005\b\u0005\u0007\u0004A\u0011\u0001Bc\u0011\u001d\u0011\u0019\u0010\u0001C\u0005\u0005kDqa!\u0003\u0001\t\u0013\u0019Y\u0001C\u0004\u0004\u0012\u0001!Iaa\u0005\t\u000f\re\u0001\u0001\"\u0001\u0004\u001c!91Q\u0006\u0001\u0005\u0002\r=\u0002BBB\u001c\u0001\u0011\u0005A\f\u0003\u0004\u0004<\u0001!\t\u0001\u0018\u0005\u0007\u0007\u007f\u0001A\u0011\u0001/\t\u000f\r\r\u0003\u0001\"\u0001\u0004F!11\u0011\u000b\u0001\u0005\u0002qCaa!\u0016\u0001\t\u0003a\u0006BBB-\u0001\u0011\u0005A\f\u0003\u0004\u0004^\u0001!\t\u0001\u0018\u0005\u0007\u0007C\u0002A\u0011\u0001/\t\u000f\r\u0015\u0004\u0001\"\u0001\u0004h!911\u000f\u0001\u0005\u0002\rU\u0004BBBA\u0001\u0011\u0005A\f\u0003\u0004\u0004\u0006\u0002!\t\u0001\u0018\u0005\u0007\u0007\u0013\u0003A\u0011\u0001/\t\r\r5\u0005\u0001\"\u0001]\u0011\u0019\u0019\t\n\u0001C\u00019\"11Q\u0013\u0001\u0005\u0002qCaa!'\u0001\t\u0003a\u0006bBBO\u0001\u0011\u00051q\u0014\u0005\u0007\u0007S\u0003A\u0011\u0001/\t\r\r5\u0006\u0001\"\u0001]\u0011\u0019\u0019\t\f\u0001C\u00019\"11Q\u0017\u0001\u0005\u0002q\u0013\u0001c\u0013*bMR\u001cE.^:uKJ$Vm\u001d;\u000b\u0005}\u0002\u0015AB:feZ,'OC\u0001B\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001#\u0011\u0005\u0015CU\"\u0001$\u000b\u0003\u001d\u000bQa]2bY\u0006L!!\u0013$\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tA\n\u0005\u0002N\u00015\ta(A\u0002m_\u001e,\u0012\u0001\u0015\t\u0003#Zk\u0011A\u0015\u0006\u0003'R\u000bQa\u001d7gi)T\u0011!V\u0001\u0004_J<\u0017BA,S\u0005\u0019aunZ4fe\u0006!An\\4!\u0003\u0011awn\u001a\u001a\u0002\u000b1|wM\r\u0011\u00023Q,7\u000f^\"sK\u0006$Xm\u00117vgR,'/\u00118e\u00072|7/\u001a\u000b\u0002;B\u0011QIX\u0005\u0003?\u001a\u0013A!\u00168ji\"\u0012a!\u0019\t\u0003E&l\u0011a\u0019\u0006\u0003I\u0016\f1!\u00199j\u0015\t1w-A\u0004kkBLG/\u001a:\u000b\u0005!$\u0016!\u00026v]&$\u0018B\u00016d\u0005\u0011!Vm\u001d;\u0002KQ,7\u000f^\"sK\u0006$Xm\u00117vgR,'/\u00118e%\u0016\u001cH/\u0019:u\u0005J|7.\u001a:O_\u0012,\u0007FA\u0004b\u0003%\"Xm\u001d;De\u0016\fG/Z\"mkN$XM]!oIJ+7\u000f^1si\u000e{g\u000e\u001e:pY2,'OT8eK\"\u0012\u0001\"Y\u00010i\u0016\u001cHo\u0011:fCR,7\t\\;ti\u0016\u0014\u0018I\u001c3XC&$hi\u001c:Ce>\\WM]%o%Vtg.\u001b8h'R\fG/\u001a\u0015\u0003\u0013\u0005\f\u0011\u0006^3ti\u000e\u0013X-\u0019;f\u00072,8\u000f^3s\u0003:$7I]3bi\u0016d\u0015n\u001d;EK2,G/\u001a+pa&\u001c\u0007F\u0001\u0006b\u0003\u001d\"Xm\u001d;De\u0016\fG/Z\"mkN$XM]!oI\u000e\u0013X-\u0019;f\u0003:$W*\u00198z)>\u0004\u0018nY:)\u0005-\t\u0017\u0001\u0005;fgR\u001cE.[3oiF+x\u000e^1tQ\ta\u0011-A\ntKR\u001cuN\\:v[\u0016\u0014()\u001f;f%\u0006$X\r\u0006\u0004^s\u0006-\u0011q\u0004\u0005\u0006u6\u0001\ra_\u0001\u0006C\u0012l\u0017N\u001c\t\u0004y\u0006\u001dQ\"A?\u000b\u0005it(bA@\u0002\u0002\u000591\r\\5f]R\u001c(bA!\u0002\u0004)\u0019\u0011Q\u0001+\u0002\r\u0005\u0004\u0018m\u00195f\u0013\r\tI! \u0002\u0006\u0003\u0012l\u0017N\u001c\u0005\b\u0003\u001bi\u0001\u0019AA\b\u0003\u0019)g\u000e^5usB!\u0011\u0011CA\u000e\u001b\t\t\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011!B9v_R\f'\u0002BA\r\u0003\u0003\taaY8n[>t\u0017\u0002BA\u000f\u0003'\u0011\u0011c\u00117jK:$\u0018+^8uC\u0016sG/\u001b;z\u0011\u001d\t\t#\u0004a\u0001\u0003G\tQA^1mk\u0016\u00042!RA\u0013\u0013\r\t9C\u0012\u0002\u0005\u0019>tw-\u0001\u000bhKR\u001cuN\\:v[\u0016\u0014()\u001f;f%\u0006$Xm\u001d\u000b\u0005\u0003[\t\u0019\u0005\u0005\u0005\u00020\u0005u\u0012qBA\u0012\u001d\u0011\t\t$!\u000f\u0011\u0007\u0005Mb)\u0004\u0002\u00026)\u0019\u0011q\u0007\"\u0002\rq\u0012xn\u001c;?\u0013\r\tYDR\u0001\u0007!J,G-\u001a4\n\t\u0005}\u0012\u0011\t\u0002\u0004\u001b\u0006\u0004(bAA\u001e\r\")!P\u0004a\u0001w\u00069B/Z:u\t\u00164\u0017-\u001e7u\u00072LWM\u001c;Rk>$\u0018m\u001d\u0015\u0003\u001f\u0005\fq\u0005^3ti\u000e\u0013X-\u0019;f\u00072,8\u000f^3s/&$\b.\u00113wKJ$\u0018n]3e!>\u0014HOW3s_\"\u0012\u0001#Y\u0001Di\u0016\u001cHo\u0011:fCR,7\t\\;ti\u0016\u0014x+\u001b;i\u0003\u00124XM\u001d;jg\u0016$\u0007j\\:u\u0003:$\u0007k\u001c:u\t&4g-\u001a:f]R4%o\\7T_\u000e\\W\r^*feZ,'\u000f\u000b\u0002\u0012C\u00069Bm\\(o'R\f'\u000f^3e\u0017\u000647.Y\"mkN$XM\u001d\u000b\u0005\u0003+\ni\u0007F\u0002^\u0003/Bq!!\u0017\u0013\u0001\u0004\tY&\u0001\u0004bGRLwN\u001c\t\u0007\u000b\u0006u\u0013\u0011M/\n\u0007\u0005}cIA\u0005Gk:\u001cG/[8ocA!\u00111MA5\u001b\t\t)G\u0003\u0003\u0002h\u0005]\u0011\u0001\u0002;fgRLA!a\u001b\u0002f\t\u00192*\u00194lC\u000ecWo\u001d;feR+7\u000f^&ji\"9\u0011q\u000e\nA\u0002\u0005E\u0014!\u00028pI\u0016\u001c\b\u0003BA2\u0003gJA!!\u001e\u0002f\taA+Z:u\u0017&$hj\u001c3fg\u0006q4/\u001a8e\t\u0016\u001c8M]5cK\u000ecWo\u001d;feJ+\u0017/^3tiR{'i\\;oIB{'\u000f^+oi&d\u0017\t\u001c7Ce>\\WM]:Qe>\u0004\u0018mZ1uK\u0012$b!a\u001f\u0002\u000e\u0006uE\u0003BA?\u0003\u0013\u0003B!a \u0002\u00066\u0011\u0011\u0011\u0011\u0006\u0005\u0003\u0007\u000b9\"\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\t9)!!\u0003/\u0011+7o\u0019:jE\u0016\u001cE.^:uKJ\u0014Vm\u001d9p]N,\u0007bBAF'\u0001\u000f\u0011\u0011M\u0001\bG2,8\u000f^3s\u0011\u001d\tyi\u0005a\u0001\u0003#\u000bA\u0002\\5ti\u0016tWM\u001d(b[\u0016\u0004B!a%\u0002\u001a6\u0011\u0011Q\u0013\u0006\u0005\u0003/\u000b9\"A\u0004oKR<xN]6\n\t\u0005m\u0015Q\u0013\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.\u001a\u0005\b\u0003?\u001b\u0002\u0019AAQ\u0003!9\u0018-\u001b;US6,\u0007\u0003BAR\u0003[k!!!*\u000b\t\u0005\u001d\u0016\u0011V\u0001\tIV\u0014\u0018\r^5p]*\u0019\u00111\u0016$\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u00020\u0006\u0015&A\u0004$j]&$X\rR;sCRLwN\\\u0001\u0016o\u0006LGOR8s%Vtg.\u001b8h\u0005J|7.\u001a:t)\u0019\t),a3\u0002VR!\u0011qWAe!\u0019\tI,a0\u0002D6\u0011\u00111\u0018\u0006\u0004\u0003{3\u0015AC2pY2,7\r^5p]&!\u0011\u0011YA^\u0005\r\u0019V-\u001d\t\u0004\u001b\u0006\u0015\u0017bAAd}\ta!I]8lKJ\u001cVM\u001d<fe\"9\u00111\u0012\u000bA\u0004\u0005\u0005\u0004bBAg)\u0001\u0007\u0011qZ\u0001\u0006G>,h\u000e\u001e\t\u0004\u000b\u0006E\u0017bAAj\r\n\u0019\u0011J\u001c;\t\u000f\u0005}E\u00031\u0001\u0002\"\u0006Y4/\u001a8e\t\u0016\u001c8M]5cK\u000ecWo\u001d;feJ+\u0017/^3tiR{'i\\;oIB{'\u000f^+oi&d'I]8lKJ\u001c\bK]8qC\u001e\fG/\u001a3\u0015\u0015\u0005u\u00141\\Ap\u0003C\f)\u000fC\u0004\u0002^V\u0001\r!a1\u0002\u0017\u0011,7\u000f^5oCRLwN\u001c\u0005\b\u0003\u001f+\u0002\u0019AAI\u0011\u001d\t\u0019/\u0006a\u0001\u0003\u001f\f1#\u001a=qK\u000e$X\r\u001a\"s_.,'oQ8v]RDq!a(\u0016\u0001\u0004\t\t+A\u0013tK:$G)Z:de&\u0014Wm\u00117vgR,'OU3rk\u0016\u001cH\u000fV8C_VtG\rU8siR1\u0011QPAv\u0003oDq!!8\u0017\u0001\u0004\ti\u000f\u0005\u0003\u0002p\u0006MXBAAy\u0015\r\t9\nQ\u0005\u0005\u0003k\f\tP\u0001\u0007T_\u000e\\W\r^*feZ,'\u000fC\u0004\u0002\u0010Z\u0001\r!!%\u0002OQ,7\u000f^\"sK\u0006$Xm\u00117vgR,'/\u00118e!\u0016\u0014hm\u001c:n%\u0016\f7o]5h]6,g\u000e\u001e\u0015\u0003/\u0005\f1c\u00195fG.\u0014V\r\u001d7jG\u0006l\u0015M\\1hKJ$R!\u0018B\u0001\u0005\u0007Aq!a#\u0019\u0001\u0004\t\t\u0007C\u0004\u0003\u0006a\u0001\rAa\u0002\u0002\u001f\u0015D\b/Z2uK\u0012Dun\u001d;j]\u001e\u0004bA!\u0003\u0003\u0014\tea\u0002\u0002B\u0006\u0005\u001fqA!a\r\u0003\u000e%\tq)C\u0002\u0003\u0012\u0019\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0003\u0016\t]!\u0001\u0002'jgRT1A!\u0005G!\u001d)%1DAh\u0005?I1A!\bG\u0005\u0019!V\u000f\u001d7feA1!\u0011\u0002B\n\u0005C\u00012!\u0012B\u0012\u0013\r\u0011)C\u0012\u0002\b\u0005>|G.Z1o\u0003m!(/\u00198tY\u0006$X\rU1si&$\u0018n\u001c8J]\u001a|Gk\\*fcR!!1\u0006B\u0018!\u0019\tI,a0\u0003.A1\u0011\u0011XA`\u0003\u001fDqA!\r\u001a\u0001\u0004\u0011\u0019$\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004bA!\u000e\u0003@\t\u0005SB\u0001B\u001c\u0015\u0011\u0011IDa\u000f\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0005{\tAA[1wC&!!Q\u0003B\u001c!\u0011\u0011\u0019E!\u0012\u000e\u0005\u0005]\u0011\u0002\u0002B$\u0003/\u0011!\u0003V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u00138g_\u0006\u0019r/Y5u\r>\u0014Hk\u001c9jG2K7\u000f^5oOR9QL!\u0014\u0003P\tm\u0003\"\u0002>\u001b\u0001\u0004Y\bb\u0002B)5\u0001\u0007!1K\u0001\u0010Kb\u0004Xm\u0019;fIB\u0013Xm]3oiB1\u0011\u0011XA`\u0005+\u0002B!a\f\u0003X%!!\u0011LA!\u0005\u0019\u0019FO]5oO\"9!Q\f\u000eA\u0002\tM\u0013AD3ya\u0016\u001cG/\u001a3BEN,g\u000e^\u0001\u0011S:\u001c'/Z7f]R\fG.\u00117uKJ$bAa\u0019\u0003l\t5\u0004CBA]\u0003\u007f\u0013)\u0007\u0005\u0003\u0002\u0000\t\u001d\u0014\u0002\u0002B5\u0003\u0003\u0013\u0001\"\u00119j\u000bJ\u0014xN\u001d\u0005\u0006un\u0001\ra\u001f\u0005\b\u0005_Z\u0002\u0019\u0001B9\u0003\u001d\u0019\u0007.\u00198hKN\u0004b!!/\u0002@\nM\u0004cB#\u0003\u001c\tU$\u0011\u0011\t\u0005\u0005o\u0012i(\u0004\u0002\u0003z)!!1PA\f\u0003\u0019\u0019wN\u001c4jO&!!q\u0010B=\u00059\u0019uN\u001c4jOJ+7o\\;sG\u0016\u0004b!!/\u0002@\n\r\u0005c\u0001?\u0003\u0006&\u0019!qQ?\u0003\u001b\u0005cG/\u001a:D_:4\u0017nZ(q\u0003=1\u0018\r\\5eCR,7i\u001c8gS\u001e\u001cH\u0003\u0003BG\u0005'\u0013)Ja(\u0011\u0011\u0005=\u0012Q\bB;\u0005\u001f\u0003\u0002B!\u000e\u0003\u0012\nU#QK\u0005\u0005\u0003\u007f\u00119\u0004C\u0003{9\u0001\u00071\u0010C\u0004\u0003\u0018r\u0001\rA!'\u0002\u0011\u0015D\b/Z2uK\u0012\u0004\u0002\"a\f\u0002>\tU$1\u0014\t\u0007\u0003s\u000byL!(\u0011\u000f\u0015\u0013YB!\u0016\u0003V!I!\u0011\u0015\u000f\u0011\u0002\u0003\u0007!\u0011E\u0001\u000bKbD\u0017-^:uSZ,\u0017!\u0007<bY&$\u0017\r^3D_:4\u0017nZ:%I\u00164\u0017-\u001e7uIM*\"Aa*+\t\t\u0005\"\u0011V\u0016\u0003\u0005W\u0003BA!,\u000386\u0011!q\u0016\u0006\u0005\u0005c\u0013\u0019,A\u0005v]\u000eDWmY6fI*\u0019!Q\u0017$\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003:\n=&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006YB/Z:u\u0013:\u001c'/Z7f]R\fG.\u00117uKJ\u001cuN\u001c4jOND#AH1\u00025Q,7\u000f^*fi2{w\r\u000e6D_:4\u0017nZ;sCRLwN\\:)\u0005}\t\u0017\u0001\u0006;fgR\u001c%/Z1uKB\u000b'\u000f^5uS>t7\u000fF\u0002^\u0005\u000fDqA!3!\u0001\u0004\u0011)&A\u000bnKR\fG-\u0019;b-\u0016\u00148/[8o'R\u0014\u0018N\\4)\u0007\u0001\u0012i\r\u0005\u0003\u0003P\nUWB\u0001Bi\u0015\r\u0011\u0019.Z\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\t]'\u0011\u001b\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\bf\u0002\u0011\u0003\\\n\u001d(\u0011\u001e\t\u0005\u0005;\u0014\u0019/\u0004\u0002\u0003`*!!\u0011\u001dBi\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018\u0002\u0002Bs\u0005?\u00141BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cH\u0006\u0002Bv\u0005_\f#A!<\u0002\u000fMrs'L%Wa\u0005\u0012!\u0011_\u0001\bg9:T&\u0013,3\u00031\u0019G.^:uKJLU.Y4f)\u0019\u00119pa\u0001\u0004\u0006A!!\u0011 B\u0000\u001b\t\u0011YP\u0003\u0003\u0003~\u0006\u0005\u0011!B5nC\u001e,\u0017\u0002BB\u0001\u0005w\u0014Ab\u00117vgR,'/S7bO\u0016Dq!a#\"\u0001\u0004\t\t\u0007C\u0004\u0004\b\u0005\u0002\r!a4\u0002\u0011\t\u0014xn[3s\u0013\u0012\f\u0001C\u0019:pW\u0016\u0014\u0018j]+oM\u0016t7-\u001a3\u0015\r\t\u00052QBB\b\u0011\u001d\u0011iP\ta\u0001\u0005oDqaa\u0002#\u0001\u0004\ty-\u0001\bce>\\WM]%t\u0003\n\u001cXM\u001c;\u0015\r\t\u00052QCB\f\u0011\u001d\u0011ip\ta\u0001\u0005oDqaa\u0002$\u0001\u0004\ty-\u0001\u000buKN$XK\u001c:fO&\u001cH/\u001a:Ce>\\WM\u001d\u000b\u0004;\u000eu\u0001bBB\u0010I\u0001\u0007!\u0011E\u0001\u0019kNLgn\u001a\"p_R\u001cHO]1q\u0007>tGO]8mY\u0016\u0014\bf\u0001\u0013\u0003N\":AEa7\u0004&\r\u001d\u0012\u0001\u00032p_2,\u0017M\\:-\t\r%21F\r\u0002\u0003e\t\u0001!A\tde\u0016\fG/Z!e[&t7\t\\5f]R$Ra_B\u0019\u0007gAq!a#&\u0001\u0004\t\t\u0007C\u0004\u00046\u0015\u0002\rA!\t\u0002'\t|w\u000e^:ue\u0006\u00048i\u001c8ue>dG.\u001a:\u0002EQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3Rk>\u0014X/\u001c*fcV,7\u000f\u001e+p\u0005J|7.\u001a:tQ\t1\u0013-\u0001\u0014uKN$H)Z:de&\u0014W-U;peVl'+Z9vKN$Hk\\\"p]R\u0014x\u000e\u001c7feND#aJ1\u00023Q,7\u000f^+qI\u0006$X-T3uC\u0012\fG/\u0019,feNLwN\u001c\u0015\u0003Q\u0005\f\u0001\u0004^3ti\u0012+7o\u0019:jE\u0016\\%+\u00194u-\u0016\u00148/[8o)\ri6q\t\u0005\b\u0007\u0013J\u0003\u0019\u0001B\u0011\u0003a)8/\u001b8h\u0005>|Go\u001d;sCB\u001cuN\u001c;s_2,'o\u001d\u0015\u0004S\t5\u0007fB\u0015\u0003\\\u000e\u00152q\n\u0017\u0005\u0007W\u0019I#A\u0011uKN$(+Z7pi\u0016dunZ'b]\u0006<WM]%ogR\fg\u000e^5bi&|g\u000e\u000b\u0002+C\u0006\u0001E/Z:u\u0007J,\u0017\r^3DYV\u001cH/\u001a:B]\u0012\u001c%/Z1uKR{\u0007/[2XSRD'+Z7pi\u0016dunZ'b]\u0006<WM]%ogR\fg\u000e^5bi&|g\u000e\u000b\u0002,C\u0006\tB/Z:u':\f\u0007o\u001d5pi\u000e{WO\u001c;)\u00051\n\u0017!\f;fgR\fU\u000f\u001e5pe&TXM\u001d$bS2,(/\u001a$pk:$\u0017J\\\"p]R\u0014x\u000e\u001c7feN#\u0018M\u001d;va\"\u0012Q&Y\u0001(i\u0016\u001cHoU5oO2,7i\u001c8ue>dG.\u001a:TS:<G.\u001a\"s_.,'o\u00117vgR,'\u000f\u000b\u0002/C\u0006)C/Z:u%\u0016\u001cwN\u001c4jOV\u0014XmQ8oiJ|G\u000e\\3s\u00072LWM\u001c;Rk>$\u0018m\u001d\u000b\u0004;\u000e%\u0004bBB6_\u0001\u0007!\u0011E\u0001\u0013G>l'-\u001b8fI\u000e{g\u000e\u001e:pY2,'\u000fK\u00020\u0005\u001bDsa\fBn\u0007K\u0019\t\b\f\u0003\u0004,\r%\u0012a\t;fgR\u0014VmY8oM&<WO]3D_:$(o\u001c7mKJ\fU\u000f\u001e5pe&TXM\u001d\u000b\u0004;\u000e]\u0004bBB=a\u0001\u0007!\u0011E\u0001\rG>l'-\u001b8fI6{G-\u001a\u0015\u0004a\t5\u0007f\u0002\u0019\u0003\\\u000e\u00152q\u0010\u0017\u0005\u0007W\u0019I#A\u000euKN$xJ^3sYfd\u0015M]4f\u0007J,\u0017\r^3U_BL7m\u001d\u0015\u0003c\u0005\fa\u0003^3tiRKW.\u001a3PkRDU-\u0019:uE\u0016\fGo\u001d\u0015\u0003e\u0005\f\u0011\u0005^3tiJ+w-[:uKJ,GmQ8oiJ|G\u000e\\3s\u000b:$\u0007o\\5oiND#aM1\u0002}Q,7\u000f\u001e#je\u0016\u001cG\u000fV8D_:$(o\u001c7mKJ\u001cu.\\7v]&\u001c\u0017\r^5p]\u001a\u000b\u0017\u000e\\:P]>cG-\u001a:NKR\fG-\u0019;b-\u0016\u00148/[8oQ\t!\u0014-\u0001\u001duKN$8\u000b^1siV\u0004x+\u001b;i\u001d>tG)\u001a4bk2$8jQ8oiJ|G\u000e\\3s\tft\u0017-\\5d\u0007>tg-[4ve\u0006$\u0018n\u001c8)\u0005U\n\u0017!\f;fgR$v\u000e]5d\t\u0016dW\r^3e\u0003:$'+Z2sK\u0006$X\rZ,iS2,'I]8lKJL5\u000fR8x]\"\u0012a'Y\u0001?i\u0016\u001cH/\u00112b]\u0012|g.\u001a3GkR,(/\u001a*fa2L7-\u0019*fG>4XM]3e?6\f\u0017N\u001c*fa2L7-Y%o\u001f\u001a4G.\u001b8f\u0019><G)\u001b:)\u0005]\n\u0017!D2paf$\u0015N]3di>\u0014\u0018\u0010F\u0003^\u0007C\u001b)\u000bC\u0004\u0004$b\u0002\rA!\u0016\u0002\u0007M\u00148\rC\u0004\u0004(b\u0002\rA!\u0016\u0002\t\u0011,7\u000f^\u0001>i\u0016\u001cH/\u00112b]\u0012|g.\u001a3GkR,(/\u001a*fa2L7-\u0019*fG>4XM]3e?6\f\u0017N\u001c*fa2L7-Y%o\u001f:d\u0017N\\3M_\u001e$\u0015N\u001d\u0015\u0003s\u0005\fa\u0003^3ti\u000e{g\u000e\u001e:pY2,'OR1jY>4XM\u001d\u0015\u0003u\u0005\fA\u0004^3ti>cGMQ8piN$(/\u00199NKR\fG-\u0019;b\r&dW\r\u000b\u0002<C\u0006AB/Z:u\u0013:\u001c'/Z1tK:+X.S8UQJ,\u0017\rZ:)\u0005q\n\u0007f\u0002\u0001\u0004<\u0006\u00052\u0011\u0019\t\u0004E\u000eu\u0016bAB`G\n9A+[7f_V$h$\u0001=)\u000f\u0001\u0019)-!\t\u0004LB\u0019!ma2\n\u0007\r%7MA\u0002UC\u001e\f#a!4\u0002\u0017%tG/Z4sCRLwN\u001c")
public class KRaftClusterTest {
    private final Logger log = LoggerFactory.getLogger(KRaftClusterTest.class);
    private final Logger log2 = LoggerFactory.getLogger((String)(KRaftClusterTest.class.getCanonicalName() + "2"));

    public Logger log() {
        return this.log;
    }

    public Logger log2() {
        return this.log2;
    }

    @Test
    public void testCreateClusterAndClose() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
        }
    }

    @Test
    public void testCreateClusterAndRestartBrokerNode() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            BrokerServer broker = (BrokerServer)cluster.brokers().values().iterator().next();
            broker.shutdown();
            broker.startup();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndRestartControllerNode() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            ControllerServer controller = (ControllerServer)CollectionConverters$.MODULE$.IteratorHasAsScala(cluster.controllers().values().iterator()).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testCreateClusterAndRestartControllerNode$1(x$1))).next();
            int port = controller.socketServer().boundPort(ListenerName.normalised((String)((Endpoint)controller.config().controllerListeners().head()).listener()));
            controller.shutdown();
            Map config = controller.sharedServer().controllerConfig().props();
            ((HashMap)config).put("listeners", "CONTROLLER://localhost:" + port);
            controller.sharedServer().controllerConfig().updateCurrentConfig(new KafkaConfig(config));
            controller.startup();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndRestartControllerNode$2(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timeout waiting for new controller election");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndWaitForBrokerInRunningState() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndWaitForBrokerInRunningState$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndWaitForBrokerInRunningState$3(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"RaftManager was not initialized.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Assertions.assertEquals((Object)cluster.nodes().clusterId().toString(), (Object)admin.describeCluster().clusterId().get());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndCreateListDeleteTopic() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(3).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateListDeleteTopic$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateListDeleteTopic$3(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"RaftManager was not initialized.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                java.util.List<NewTopic> newTopic = java.util.List.of(new NewTopic("test-topic", 1, (short)3));
                admin.createTopics(newTopic).all().get();
                this.waitForTopicListing(admin, (Seq<String>)new .colon.colon((Object)"test-topic", (List)Nil$.MODULE$), (Seq<String>)Nil$.MODULE$);
                admin.deleteTopics(java.util.List.of("test-topic")).all().get();
                this.waitForTopicListing(admin, (Seq<String>)Nil$.MODULE$, (Seq<String>)new .colon.colon((Object)"test-topic", (List)Nil$.MODULE$));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndCreateAndManyTopics() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(3).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateAndManyTopics$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateAndManyTopics$3(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"RaftManager was not initialized.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                ArrayList<NewTopic> newTopic = new ArrayList<NewTopic>();
                newTopic.add(new NewTopic("test-topic-1", 2, (short)3));
                newTopic.add(new NewTopic("test-topic-2", 2, (short)3));
                newTopic.add(new NewTopic("test-topic-3", 2, (short)3));
                admin.createTopics(newTopic).all().get();
                this.waitForTopicListing(admin, (Seq<String>)new .colon.colon((Object)"test-topic-1", (List)new .colon.colon((Object)"test-topic-2", (List)new .colon.colon((Object)"test-topic-3", (List)Nil$.MODULE$))), (Seq<String>)Nil$.MODULE$);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClientQuotas() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testClientQuotas$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Object var19_19;
                Tuple2 tuple2;
                ClientQuotaEntity entity = new ClientQuotaEntity(Map.of("user", "testkit"));
                ClientQuotaFilter clientQuotaFilter = ClientQuotaFilter.containsOnly((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"testkit"), (List)Nil$.MODULE$)).asJava());
                Map describeResult = KRaftClusterTest.alterThenDescribe$1(entity, (Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("request_percentage", Predef$.MODULE$.double2Double(0.99)), (List)Nil$.MODULE$), clientQuotaFilter, 1, admin);
                Assertions.assertEquals((double)0.99, (double)Predef$.MODULE$.Double2double((Double)((Map)describeResult.get(entity)).get("request_percentage")), (double)1.0E-6);
                describeResult = KRaftClusterTest.alterThenDescribe$1(entity, (Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("request_percentage", Predef$.MODULE$.double2Double(0.97)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(10000.0)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(10001.0)), (List)Nil$.MODULE$))), clientQuotaFilter, 3, admin);
                Assertions.assertEquals((double)0.97, (double)Predef$.MODULE$.Double2double((Double)((Map)describeResult.get(entity)).get("request_percentage")), (double)1.0E-6);
                Assertions.assertEquals((double)10000.0, (double)Predef$.MODULE$.Double2double((Double)((Map)describeResult.get(entity)).get("producer_byte_rate")), (double)1.0E-6);
                Assertions.assertEquals((double)10001.0, (double)Predef$.MODULE$.Double2double((Double)((Map)describeResult.get(entity)).get("consumer_byte_rate")), (double)1.0E-6);
                describeResult = KRaftClusterTest.alterThenDescribe$1(entity, (Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("request_percentage", Predef$.MODULE$.double2Double(0.95)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", null), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", null), (List)Nil$.MODULE$))), clientQuotaFilter, 1, admin);
                Assertions.assertEquals((double)0.95, (double)Predef$.MODULE$.Double2double((Double)((Map)describeResult.get(entity)).get("request_percentage")), (double)1.0E-6);
                KRaftClusterTest.alterThenDescribe$1(entity, (Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("request_percentage", null), (List)Nil$.MODULE$), clientQuotaFilter, 0, admin);
                describeResult = null;
                describeResult = KRaftClusterTest.alterThenDescribe$1(entity, (Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(9999.0)), (List)Nil$.MODULE$), clientQuotaFilter, 1, admin);
                Assertions.assertEquals((double)9999.0, (double)Predef$.MODULE$.Double2double((Double)((Map)describeResult.get(entity)).get("producer_byte_rate")), (double)1.0E-6);
                ClientQuotaEntity entity2 = new ClientQuotaEntity(Map.of("user", "testkit", "client-id", "some-client"));
                clientQuotaFilter = ClientQuotaFilter.containsOnly(java.util.List.of(ClientQuotaFilterComponent.ofEntity((String)"user", (String)"testkit"), ClientQuotaFilterComponent.ofEntity((String)"client-id", (String)"some-client")));
                describeResult = KRaftClusterTest.alterThenDescribe$1(entity2, (Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(9998.0)), (List)Nil$.MODULE$), clientQuotaFilter, 1, admin);
                Assertions.assertEquals((double)9998.0, (double)Predef$.MODULE$.Double2double((Double)((Map)describeResult.get(entity2)).get("producer_byte_rate")), (double)1.0E-6);
                clientQuotaFilter = ClientQuotaFilter.contains(java.util.List.of(ClientQuotaFilterComponent.ofEntity((String)"user", (String)"testkit")));
                long l2 = 100L;
                long tryUntilNoAssertionError_waitTime = 15000L;
                long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
                while (true) {
                    void tryUntilNoAssertionError_pause;
                    Right right;
                    try {
                        Map $anonfun$testClientQuotas$5_results = (Map)admin.describeClientQuotas(clientQuotaFilter).entities().get();
                        Assertions.assertEquals((int)2, (int)$anonfun$testClientQuotas$5_results.size(), (String)"Broker did not see two client quotas");
                        Assertions.assertEquals((double)9999.0, (double)Predef$.MODULE$.Double2double((Double)((Map)$anonfun$testClientQuotas$5_results.get(entity)).get("producer_byte_rate")), (double)1.0E-6);
                        Assertions.assertEquals((double)9998.0, (double)Predef$.MODULE$.Double2double((Double)((Map)$anonfun$testClientQuotas$5_results.get(entity2)).get("producer_byte_rate")), (double)1.0E-6);
                        Object var25_17 = null;
                        BoxedUnit $anonfun$tryUntilNoAssertionError$1_res = BoxedUnit.UNIT;
                        right = new Left((Object)$anonfun$tryUntilNoAssertionError$1_res);
                    }
                    catch (AssertionError $anonfun$tryUntilNoAssertionError$1_ae) {
                        right = new Right((Object)$anonfun$tryUntilNoAssertionError$1_ae);
                    }
                    Object var23_14 = null;
                    Object var24_15 = null;
                    Right tryUntilNoAssertionError_computeUntilTrue_result = right;
                    if (((Either)tryUntilNoAssertionError_computeUntilTrue_result).isLeft()) {
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                        break;
                    }
                    if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + tryUntilNoAssertionError_waitTime) {
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                        break;
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(tryUntilNoAssertionError_waitTime), (long)tryUntilNoAssertionError_pause));
                }
                Object var22_13 = null;
                Tuple2 tuple22 = tuple2;
                if (tuple22 == null) {
                    throw new MatchError(null);
                }
                Either tryUntilNoAssertionError_either = (Either)tuple22._1();
                if (!(var19_19 instanceof Left)) {
                    if (var19_19 instanceof Right) {
                        throw (AssertionError)((Right)var19_19).value();
                    }
                    throw new MatchError((Object)var19_19);
                }
                ((Left)var19_19).value();
                tuple22 = null;
                var19_19 = null;
            }
        }
    }

    public void setConsumerByteRate(Admin admin, ClientQuotaEntity entity, long value) {
        admin.alterClientQuotas(java.util.List.of(new ClientQuotaAlteration(entity, java.util.List.of(new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double((double)value)))))).all().get();
    }

    public scala.collection.immutable.Map<ClientQuotaEntity, Object> getConsumerByteRates(Admin admin) {
        ClientQuotaFilter allFilter = ClientQuotaFilter.contains(java.util.List.of());
        HashMap results = new HashMap();
        ((Map)admin.describeClientQuotas(allFilter).entities().get()).forEach((x0$1, x1$1) -> Option$.MODULE$.apply(x1$1.get("consumer_byte_rate")).foreach((Function1 & Serializable)value -> BoxesRunTime.boxToLong((long)KRaftClusterTest.$anonfun$getConsumerByteRates$2(results, x0$1, value))));
        return CollectionConverters$.MODULE$.MapHasAsScala(results).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDefaultClientQuotas() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testDefaultClientQuotas$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                ClientQuotaEntity defaultUser = new ClientQuotaEntity(Collections.singletonMap("user", null));
                ClientQuotaEntity bobUser = new ClientQuotaEntity(Map.of("user", "bob"));
                long l2 = 30000L;
                TestUtils$ retry_this = TestUtils$.MODULE$;
                LongRef retry_wait = LongRef.create((long)1L);
                long retry_startTime = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testDefaultClientQuotas$3(this, admin);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                            Object var34_12 = null;
                            retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(retry_wait.elem);
                        retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                        continue;
                    }
                    break;
                }
                Object var13_9 = null;
                Object var16_10 = null;
                Object var19_14 = null;
                this.setConsumerByteRate(admin, defaultUser, 100L);
                long l3 = 30000L;
                TestUtils$ retry_this2 = TestUtils$.MODULE$;
                LongRef retry_wait2 = LongRef.create((long)1L);
                long retry_startTime2 = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testDefaultClientQuotas$4(this, defaultUser, admin);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this2.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait2);
                            Object var35_19 = null;
                            retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(retry_wait2.elem);
                        retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                        continue;
                    }
                    break;
                }
                Object var20_16 = null;
                Object var23_17 = null;
                Object var26_21 = null;
                this.setConsumerByteRate(admin, bobUser, 1000L);
                long l4 = 30000L;
                TestUtils$ retry_this3 = TestUtils$.MODULE$;
                LongRef retry_wait3 = LongRef.create((long)1L);
                long retry_startTime3 = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testDefaultClientQuotas$5(this, defaultUser, bobUser, admin);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this3.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait3);
                            Object var36_28 = null;
                            retry_this3.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this3, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(retry_wait3.elem);
                        retry_wait3.elem += package$.MODULE$.min(retry_wait3.elem, 1000L);
                        continue;
                    }
                    break;
                }
                Object var27_23 = null;
                Object var30_24 = null;
                Object var33_27 = null;
            }
        }
    }

    @Test
    public void testCreateClusterWithAdvertisedPortZero() {
        HashMap brokerPropertyOverrides = new HashMap();
        CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)3), (Integral)Numeric.IntIsIntegral$.MODULE$)).asJava().forEach(brokerId -> KRaftClusterTest.$anonfun$testCreateClusterWithAdvertisedPortZero$1(brokerPropertyOverrides, BoxesRunTime.unboxToInt((Object)brokerId)));
        TestKitNodes nodes = new TestKitNodes.Builder().setNumControllerNodes(1).setNumBrokerNodes(3).setPerServerProperties(brokerPropertyOverrides).build();
        try (KafkaClusterTestKit doOnStartedKafkaCluster_cluster = new KafkaClusterTestKit.Builder(nodes).build();){
            doOnStartedKafkaCluster_cluster.format();
            doOnStartedKafkaCluster_cluster.startup();
            KRaftClusterTest.$anonfun$testCreateClusterWithAdvertisedPortZero$2(this, doOnStartedKafkaCluster_cluster);
        }
    }

    @Test
    public void testCreateClusterWithAdvertisedHostAndPortDifferentFromSocketServer() {
        HashMap brokerPropertyOverrides = new HashMap();
        CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)3), (Integral)Numeric.IntIsIntegral$.MODULE$)).asJava().forEach(brokerId -> KRaftClusterTest.$anonfun$testCreateClusterWithAdvertisedHostAndPortDifferentFromSocketServer$1(brokerPropertyOverrides, BoxesRunTime.unboxToInt((Object)brokerId)));
        TestKitNodes nodes = new TestKitNodes.Builder().setNumControllerNodes(1).setNumBrokerNodes(3).setNumDisksPerBroker(1).setPerServerProperties(brokerPropertyOverrides).build();
        try (KafkaClusterTestKit doOnStartedKafkaCluster_cluster = new KafkaClusterTestKit.Builder(nodes).build();){
            doOnStartedKafkaCluster_cluster.format();
            doOnStartedKafkaCluster_cluster.startup();
            KRaftClusterTest.$anonfun$testCreateClusterWithAdvertisedHostAndPortDifferentFromSocketServer$2(this, doOnStartedKafkaCluster_cluster);
        }
    }

    private void doOnStartedKafkaCluster(TestKitNodes nodes, Function1<KafkaClusterTestKit, BoxedUnit> action) {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(nodes).build();){
            cluster.format();
            cluster.startup();
            action.apply((Object)cluster);
        }
    }

    private DescribeClusterResponse sendDescribeClusterRequestToBoundPortUntilAllBrokersPropagated(ListenerName listenerName, FiniteDuration waitTime, KafkaClusterTestKit cluster) {
        long startTime = System.currentTimeMillis();
        Seq<BrokerServer> runningBrokerServers = this.waitForRunningBrokers(1, waitTime, cluster);
        FiniteDuration remainingWaitTime = waitTime.$minus(scala.concurrent.duration.package$.MODULE$.pairLongToDuration(new Tuple2((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTime)), (Object)TimeUnit.MILLISECONDS)));
        return this.sendDescribeClusterRequestToBoundPortUntilBrokersPropagated((BrokerServer)runningBrokerServers.head(), listenerName, cluster.nodes().brokerNodes().size(), remainingWaitTime);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<BrokerServer> waitForRunningBrokers(int count, FiniteDuration waitTime, KafkaClusterTestKit cluster) {
        void var5_9;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = waitTime.toMillis();
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            Seq computeUntilTrue_result;
            if ((computeUntilTrue_result = KRaftClusterTest.getRunningBrokerServers$1(cluster)).nonEmpty()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var12_7 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Seq runningBrokerServers = (Seq)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp(), (String)("After " + waitTime.toMillis() + " ms at least " + count + " broker(s) should be in RUNNING state, but only " + var5_9.size() + " broker(s) are."));
        return var5_9;
    }

    /*
     * WARNING - void declaration
     */
    private DescribeClusterResponse sendDescribeClusterRequestToBoundPortUntilBrokersPropagated(BrokerServer destination, ListenerName listenerName, int expectedBrokerCount, FiniteDuration waitTime) {
        void var6_10;
        Tuple2 tuple2;
        long l = 100L;
        long computeUntilTrue_waitTime = waitTime.toMillis();
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            DescribeClusterResponse computeUntilTrue_result;
            if (KRaftClusterTest.$anonfun$sendDescribeClusterRequestToBoundPortUntilBrokersPropagated$2(expectedBrokerCount, computeUntilTrue_result = this.sendDescribeClusterRequestToBoundPort(destination.socketServer(), listenerName))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var13_8 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        DescribeClusterResponse describeClusterResponse = (DescribeClusterResponse)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp(), (String)("After " + waitTime.toMillis() + " ms Broker is only aware of " + var6_10.nodes().size() + " brokers, but " + expectedBrokerCount + " are expected."));
        return var6_10;
    }

    private DescribeClusterResponse sendDescribeClusterRequestToBoundPort(SocketServer destination, ListenerName listenerName) {
        return (DescribeClusterResponse)IntegrationTestUtils$.MODULE$.connectAndReceive(new DescribeClusterRequest.Builder(new DescribeClusterRequestData()).build(), destination, listenerName, ClassTag$.MODULE$.apply(DescribeClusterResponse.class));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndPerformReassignment() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                HashMap<Integer, java.util.List<Integer>> assignments = new HashMap<Integer, java.util.List<Integer>>();
                assignments.put(Predef$.MODULE$.int2Integer(0), java.util.List.of(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)));
                assignments.put(Predef$.MODULE$.int2Integer(1), java.util.List.of(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)));
                assignments.put(Predef$.MODULE$.int2Integer(2), java.util.List.of(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(0)));
                assignments.put(Predef$.MODULE$.int2Integer(3), java.util.List.of(Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1)));
                admin.createTopics(java.util.List.of(new NewTopic("foo", assignments))).all().get();
                this.waitForTopicListing(admin, (Seq<String>)new .colon.colon((Object)"foo", (List)Nil$.MODULE$), (Seq<String>)Nil$.MODULE$);
                Assertions.assertEquals(Map.of(), (Object)admin.listPartitionReassignments().reassignments().get());
                HashMap<TopicPartition, Optional<NewPartitionReassignment>> reassignments = new HashMap<TopicPartition, Optional<NewPartitionReassignment>>();
                reassignments.put(new TopicPartition("foo", 0), Optional.of(new NewPartitionReassignment(java.util.List.of(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)))));
                reassignments.put(new TopicPartition("foo", 1), Optional.of(new NewPartitionReassignment(java.util.List.of(Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)))));
                reassignments.put(new TopicPartition("foo", 2), Optional.of(new NewPartitionReassignment(java.util.List.of(Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)))));
                reassignments.put(new TopicPartition("foo", 3), Optional.of(new NewPartitionReassignment(java.util.List.of(Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)))));
                admin.alterPartitionReassignments(reassignments).all().get();
                long l = 100L;
                long waitUntilTrue_waitTimeMs = 15000L;
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!KRaftClusterTest.$anonfun$testCreateClusterAndPerformReassignment$1(admin)) {
                    void waitUntilTrue_pause;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)"The reassignment never completed.");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
                Seq<Seq<Object>> seq = Nil$.MODULE$;
                .colon.colon expectedMapping = new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 1, 0}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 0, 1}))), (List)Nil$.MODULE$))));
                long l2 = 100L;
                long waitUntilTrue_waitTimeMs2 = 15000L;
                long waitUntilTrue_startTime2 = System.currentTimeMillis();
                while (true) {
                    void waitUntilTrue_pause;
                    boolean bl;
                    Map $anonfun$testCreateClusterAndPerformReassignment$3_topicInfoMap;
                    if (($anonfun$testCreateClusterAndPerformReassignment$3_topicInfoMap = (Map)admin.describeTopics(java.util.Set.of("foo")).allTopicNames().get()).containsKey("foo")) {
                        seq = this.translatePartitionInfoToSeq(((TopicDescription)$anonfun$testCreateClusterAndPerformReassignment$3_topicInfoMap.get("foo")).partitions());
                        bl = expectedMapping.equals(seq);
                    } else {
                        bl = false;
                    }
                    Object var28_13 = null;
                    if (bl) break;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                        Assertions.fail((String)("Timed out waiting for replica assignments for topic foo. Wanted: " + (Seq)expectedMapping + ". Got: " + seq));
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
                }
                long l3 = 60000L;
                TestUtils$ retry_this = TestUtils$.MODULE$;
                LongRef retry_wait = LongRef.create((long)1L);
                long retry_startTime = System.currentTimeMillis();
                while (true) {
                    try {
                        this.checkReplicaManager(cluster, (List<Tuple2<Object, List<Object>>>)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, true, false, true}))), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, true, false, true}))), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{true, true, true, true}))), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, false, true, true}))), (List)Nil$.MODULE$)))));
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                            Object var27_20 = null;
                            retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(retry_wait.elem);
                        retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                        continue;
                    }
                    break;
                }
                Object var20_15 = null;
                Object var23_16 = null;
                Object var26_19 = null;
            }
        }
    }

    private void checkReplicaManager(KafkaClusterTestKit cluster, List<Tuple2<Object, List<Object>>> expectedHosting) {
        expectedHosting.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$checkReplicaManager$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$8 -> {
            KRaftClusterTest.$anonfun$checkReplicaManager$2(cluster, x$8);
            return BoxedUnit.UNIT;
        });
    }

    private Seq<Seq<Object>> translatePartitionInfoToSeq(java.util.List<TopicPartitionInfo> partitions) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitions).asScala().map((Function1 & Serializable)partition -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partition.replicas()).asScala().map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.id()))).toSeq())).toSeq();
    }

    /*
     * WARNING - void declaration
     */
    private void waitForTopicListing(Admin admin, Seq<String> expectedPresent, Seq<String> expectedAbsent) {
        HashSet topicsNotFound = new HashSet();
        expectedPresent.foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)topicsNotFound.add(x$1)));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            ((Iterable)admin.listTopics().names().get()).forEach(name -> topicsNotFound$1.remove(name));
            scala.collection.mutable.Set set = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)admin.listTopics().names().get()).asScala().filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)expectedAbsent$1.contains((Object)x$10)));
            if (topicsNotFound.isEmpty() && set.isEmpty()) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)("Failed to find topic(s): " + CollectionConverters$.MODULE$.SetHasAsScala(topicsNotFound).asScala() + " and NOT find topic(s): " + set));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private Seq<ApiError> incrementalAlter(Admin admin, Seq<Tuple2<ConfigResource, Seq<AlterConfigOp>>> changes) {
        HashMap configs = new HashMap();
        changes.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                ConfigResource resource = (ConfigResource)x0$1._1();
                Seq ops = (Seq)x0$1._2();
                return configs.put(resource, CollectionConverters$.MODULE$.SeqHasAsJava(ops).asJava());
            }
            throw new MatchError(null);
        });
        Map values = admin.incrementalAlterConfigs(configs).values();
        return (Seq)changes.map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                ConfigResource resource = (ConfigResource)x0$2._1();
                try {
                    ((KafkaFuture)values.get(resource)).get();
                    return ApiError.NONE;
                }
                catch (ExecutionException executionException) {
                    return ApiError.fromThrowable((Throwable)executionException.getCause());
                }
                catch (Throwable throwable) {
                    return ApiError.fromThrowable((Throwable)throwable);
                }
            }
            throw new MatchError(null);
        });
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Map<ConfigResource, Map<String, String>> validateConfigs(Admin admin, scala.collection.immutable.Map<ConfigResource, Seq<Tuple2<String, String>>> expected, boolean exhaustive) {
        scala.collection.mutable.HashMap results = new scala.collection.mutable.HashMap();
        long l = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                KRaftClusterTest.$anonfun$validateConfigs$1(this, admin, expected, results, exhaustive);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var12_11 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        Object var5_6 = null;
        Object var8_7 = null;
        Object var11_10 = null;
        return results.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private boolean validateConfigs$default$3() {
        return false;
    }

    @Test
    public void testIncrementalAlterConfigs() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)Nil$.MODULE$), this.incrementalAlter(admin, (Seq<Tuple2<ConfigResource, Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.BROKER, ""), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("log.roll.ms", "1234567"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("max.connections.per.ip", "60"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, "")), (Object)new .colon.colon((Object)new Tuple2((Object)"log.roll.ms", (Object)"1234567"), (List)new .colon.colon((Object)new Tuple2((Object)"max.connections.per.ip", (Object)"60"), (List)new .colon.colon((Object)new Tuple2((Object)"min.insync.replicas", (Object)"1"), (List)Nil$.MODULE$))))}))), true);
                admin.createTopics(java.util.List.of(new NewTopic("foo", 2, (short)3), new NewTopic("bar", 2, (short)3))).all().get();
                TestUtils$.MODULE$.waitForAllPartitionsMetadata(CollectionConverters$.MODULE$.CollectionHasAsScala(cluster.brokers().values()).asScala().toSeq(), "foo", 2);
                TestUtils$.MODULE$.waitForAllPartitionsMetadata(CollectionConverters$.MODULE$.CollectionHasAsScala(cluster.brokers().values()).asScala().toSeq(), "bar", 2);
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "bar")), (Object)Nil$.MODULE$)}))), false);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)new .colon.colon((Object)new ApiError(Errors.INVALID_CONFIG, "Unknown topic config name: not.a.real.topic.config"), (List)new .colon.colon((Object)new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION, "The topic 'baz' does not exist."), (List)Nil$.MODULE$))), this.incrementalAlter(admin, (Seq<Tuple2<ConfigResource, Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("segment.jitter.ms", "345"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.TOPIC, "bar"), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("not.a.real.topic.config", "789"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.TOPIC, "baz"), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("segment.jitter.ms", "678"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "foo")), (Object)new .colon.colon((Object)new Tuple2((Object)"segment.jitter.ms", (Object)"345"), (List)Nil$.MODULE$))}))), false);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)Nil$.MODULE$), this.incrementalAlter(admin, (Seq<Tuple2<ConfigResource, Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.BROKER, "2"), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("max.connections.per.ip", "7"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, "2")), (Object)new .colon.colon((Object)new Tuple2((Object)"max.connections.per.ip", (Object)"7"), (List)Nil$.MODULE$))}))), false);
            }
        }
    }

    @Test
    public void testSetLog4jConfigurations() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                new .colon.colon((Object)this.log(), (List)new .colon.colon((Object)this.log2(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)x$11 -> {
                    x$11.debug("setting log4j");
                    return BoxedUnit.UNIT;
                });
                ConfigResource broker2 = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "2");
                ConfigResource broker3 = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "3");
                scala.collection.immutable.Map<ConfigResource, Map<String, String>> initialLog4j = this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker2), (Object)Nil$.MODULE$)}))), false);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)new .colon.colon((Object)new ApiError(Errors.INVALID_REQUEST, "APPEND operation is not allowed for the BROKER_LOGGER resource"), (List)Nil$.MODULE$)), this.incrementalAlter(admin, (Seq<Tuple2<ConfigResource, Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)broker2, (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log().getName(), "TRACE"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log2().getName(), "TRACE"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)new Tuple2((Object)broker3, (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log().getName(), "TRACE"), AlterConfigOp.OpType.APPEND), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log2().getName(), "TRACE"), AlterConfigOp.OpType.APPEND), (List)Nil$.MODULE$))), (List)Nil$.MODULE$))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker2), (Object)new .colon.colon((Object)new Tuple2((Object)this.log().getName(), (Object)"TRACE"), (List)new .colon.colon((Object)new Tuple2((Object)this.log2().getName(), (Object)"TRACE"), (List)Nil$.MODULE$)))}))), false);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)new .colon.colon((Object)new ApiError(Errors.INVALID_REQUEST, "SUBTRACT operation is not allowed for the BROKER_LOGGER resource"), (List)Nil$.MODULE$)), this.incrementalAlter(admin, (Seq<Tuple2<ConfigResource, Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)broker2, (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log().getName(), ""), AlterConfigOp.OpType.DELETE), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log2().getName(), ""), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)new Tuple2((Object)broker3, (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log().getName(), "TRACE"), AlterConfigOp.OpType.SUBTRACT), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log2().getName(), "TRACE"), AlterConfigOp.OpType.SUBTRACT), (List)Nil$.MODULE$))), (List)Nil$.MODULE$))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker2), (Object)new .colon.colon((Object)new Tuple2((Object)this.log().getName(), ((Map)initialLog4j.apply((Object)broker2)).get(this.log().getName())), (List)new .colon.colon((Object)new Tuple2((Object)this.log2().getName(), ((Map)initialLog4j.apply((Object)broker2)).get(this.log2().getName())), (List)Nil$.MODULE$)))}))), false);
            }
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"3.7-IV0", "3.7-IV2"})
    public void testCreatePartitions(String metadataVersionString) {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setBootstrapMetadataVersion(MetadataVersion.fromVersionString((String)metadataVersionString)).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Map createResults = admin.createTopics(java.util.List.of(new NewTopic("foo", 1, (short)3), new NewTopic("bar", 2, (short)3))).values();
                ((KafkaFuture)createResults.get("foo")).get();
                ((KafkaFuture)createResults.get("bar")).get();
                Map increaseResults = admin.createPartitions(Map.of("foo", NewPartitions.increaseTo((int)3), "bar", NewPartitions.increaseTo((int)2))).values();
                ((KafkaFuture)increaseResults.get("foo")).get();
                Assertions.assertEquals(InvalidPartitionsException.class, Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)increaseResults.get("bar")).get()).getCause().getClass());
            }
        }
    }

    private ClusterImage clusterImage(KafkaClusterTestKit cluster, int brokerId) {
        return ((BrokerServer)cluster.brokers().get(BoxesRunTime.boxToInteger((int)brokerId))).metadataCache().currentImage().cluster();
    }

    private boolean brokerIsUnfenced(ClusterImage image, int brokerId) {
        Option option = Option$.MODULE$.apply(image.brokers().get(BoxesRunTime.boxToInteger((int)brokerId)));
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            return !((BrokerRegistration)((Some)option).value()).fenced();
        }
        throw new MatchError((Object)option);
    }

    private boolean brokerIsAbsent(ClusterImage image, int brokerId) {
        return Option$.MODULE$.apply(image.brokers().get(BoxesRunTime.boxToInteger((int)brokerId))).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testUnregisterBroker(boolean usingBootstrapController) {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!this.brokerIsUnfenced(this.clusterImage(cluster, 1), 0)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for broker 0 to be unfenced.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            ((KafkaBroker)cluster.brokers().get(BoxesRunTime.boxToInteger((int)0))).shutdown();
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testUnregisterBroker$3(this, cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"Timed out waiting for broker 0 to be fenced.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            try (Admin admin = this.createAdminClient(cluster, usingBootstrapController);){
                admin.unregisterBroker(0);
            }
            long l3 = 100L;
            long waitUntilTrue_waitTimeMs3 = 15000L;
            long waitUntilTrue_startTime3 = System.currentTimeMillis();
            while (!this.brokerIsAbsent(this.clusterImage(cluster, 1), 0)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                    Assertions.fail((String)"Timed out waiting for broker 0 to be fenced.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
            }
        }
    }

    public Admin createAdminClient(KafkaClusterTestKit cluster, boolean bootstrapController) {
        Properties props = bootstrapController ? cluster.newClientPropertiesBuilder().setUsingBootstrapControllers(true).build() : cluster.clientProperties();
        props.put("client.id", this.getClass().getName());
        return Admin.create((Properties)props);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeQuorumRequestToBrokers() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                long l = 100L;
                long waitUntilTrue_waitTimeMs = 15000L;
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$2(cluster, i)) {
                    void waitUntilTrue_pause;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)"Broker Never started up");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
            });
            try (Admin admin = this.createAdminClient(cluster, false);){
                void var7_15;
                Tuple2 tuple2;
                void var5_9;
                Tuple2 tuple22;
                QuorumInfo quorumInfo = (QuorumInfo)admin.describeMetadataQuorum(new DescribeMetadataQuorumOptions()).quorumInfo().get();
                Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsScala(cluster.controllers()).asScala().keySet(), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(quorumInfo.voters()).asScala().map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.replicaId()))).toSet());
                Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.MapHasAsScala(cluster.controllers()).asScala().keySet().contains((Object)Predef$.MODULE$.int2Integer(quorumInfo.leaderId())), (String)("Leader ID " + quorumInfo.leaderId() + " was not a controller ID."));
                long l = 100L;
                long computeUntilTrue_waitTime = 15000L;
                long computeUntilTrue_startTime = System.currentTimeMillis();
                while (true) {
                    void computeUntilTrue_pause;
                    java.util.List computeUntilTrue_result;
                    if (KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$6(computeUntilTrue_result = KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$5(admin))) {
                        tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                        break;
                    }
                    if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                        tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                        break;
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
                }
                Object var16_7 = null;
                Tuple2 tuple23 = tuple22;
                if (tuple23 == null) {
                    throw new MatchError(null);
                }
                java.util.List voters = (java.util.List)tuple23._1();
                Assertions.assertTrue((boolean)tuple23._2$mcZ$sp(), (String)("At least one voter did not return the expected state within timeout.The responses gathered for all the voters: " + var5_9.toString()));
                long l2 = 100L;
                long computeUntilTrue_waitTime2 = 15000L;
                long computeUntilTrue_startTime2 = System.currentTimeMillis();
                while (true) {
                    void computeUntilTrue_pause;
                    java.util.List computeUntilTrue_result;
                    if (KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$9(cluster, computeUntilTrue_result = KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$8(admin))) {
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                        break;
                    }
                    if (System.currentTimeMillis() > computeUntilTrue_startTime2 + computeUntilTrue_waitTime2) {
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                        break;
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime2), (long)computeUntilTrue_pause));
                }
                Object var23_13 = null;
                Tuple2 tuple24 = tuple2;
                if (tuple24 == null) {
                    throw new MatchError(null);
                }
                java.util.List observers = (java.util.List)tuple24._1();
                Assertions.assertTrue((boolean)tuple24._2$mcZ$sp(), (String)("At least one observer did not return the expected state within timeout.The responses gathered for all the observers: " + var7_15.toString()));
            }
        }
    }

    @Test
    public void testDescribeQuorumRequestToControllers() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                long l = 100L;
                long waitUntilTrue_waitTimeMs = 15000L;
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!KRaftClusterTest.$anonfun$testDescribeQuorumRequestToControllers$2(cluster, i)) {
                    void waitUntilTrue_pause;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)"Broker Never started up");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
            });
            try (Admin admin = this.createAdminClient(cluster, true);){
                QuorumInfo quorumInfo = (QuorumInfo)admin.describeMetadataQuorum(new DescribeMetadataQuorumOptions()).quorumInfo().get();
                Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsScala(cluster.controllers()).asScala().keySet(), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(quorumInfo.voters()).asScala().map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.replicaId()))).toSet());
                Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.MapHasAsScala(cluster.controllers()).asScala().keySet().contains((Object)Predef$.MODULE$.int2Integer(quorumInfo.leaderId())), (String)("Leader ID " + quorumInfo.leaderId() + " was not a controller ID."));
                ((ControllerServer)cluster.controllers().get(BoxesRunTime.boxToInteger((int)quorumInfo.leaderId()))).sharedServer().raftManager().client().shutdown(1000);
                KafkaFuture quorumInfo2Future = admin.describeMetadataQuorum(new DescribeMetadataQuorumOptions()).quorumInfo();
                ((ControllerServer)cluster.controllers().get(BoxesRunTime.boxToInteger((int)quorumInfo.leaderId()))).shutdown();
                QuorumInfo quorumInfo2 = (QuorumInfo)quorumInfo2Future.get();
                Assertions.assertTrue((quorumInfo.leaderId() != quorumInfo2.leaderId() ? 1 : 0) != 0);
                Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsScala(cluster.controllers()).asScala().keySet(), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(quorumInfo.voters()).asScala().map((Function1 & Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.replicaId()))).toSet());
                Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.MapHasAsScala(cluster.controllers()).asScala().keySet().contains((Object)Predef$.MODULE$.int2Integer(quorumInfo.leaderId())), (String)("Leader ID " + quorumInfo.leaderId() + " was not a controller ID."));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUpdateMetadataVersion() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.MINIMUM_VERSION).setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.updateFeatures(Map.of("metadata.version", new FeatureUpdate(MetadataVersion.latestTesting().featureLevel(), FeatureUpdate.UpgradeType.UPGRADE)), new UpdateFeaturesOptions());
                Assertions.assertEquals((Object)new SupportedVersionRange(0, 1), ((FeatureMetadata)admin.describeFeatures().featureMetadata().get()).supportedFeatures().get("kraft.version"));
            }
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testUpdateMetadataVersion$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for metadata.version update");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testDescribeKRaftVersion(boolean usingBootstrapControlers) {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).setFeature("kraft.version", (short)1).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.newClientPropertiesBuilder().setUsingBootstrapControllers(usingBootstrapControlers).build());){
                FeatureMetadata featureMetadata = (FeatureMetadata)admin.describeFeatures().featureMetadata().get();
                Assertions.assertEquals((Object)new SupportedVersionRange(0, 1), featureMetadata.supportedFeatures().get("kraft.version"));
                Assertions.assertEquals((Object)new FinalizedVersionRange((short)1, (short)1), featureMetadata.finalizedFeatures().get("kraft.version"));
            }
        }
    }

    @Test
    public void testRemoteLogManagerInstantiation() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).setConfigProp("remote.log.storage.system.enable", (Object)Boolean.toString(true)).setConfigProp("remote.log.metadata.manager.class.name", (Object)"org.apache.kafka.server.log.remote.storage.NoOpRemoteLogMetadataManager").setConfigProp("remote.log.storage.manager.class.name", (Object)"org.apache.kafka.server.log.remote.storage.NoOpRemoteStorageManager").build();){
            cluster.format();
            cluster.startup();
            cluster.brokers().forEach((x$18, server) -> {
                Option option = server.remoteLogManagerOpt();
                if (option instanceof Some) {
                    return;
                }
                if (None$.MODULE$.equals(option)) {
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"RemoteLogManager should be initialized");
                    return;
                }
                throw new MatchError((Object)option);
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndCreateTopicWithRemoteLogManagerInstantiation() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).setConfigProp("remote.log.storage.system.enable", (Object)Boolean.toString(true)).setConfigProp("remote.log.metadata.manager.class.name", (Object)"org.apache.kafka.server.log.remote.storage.NoOpRemoteLogMetadataManager").setConfigProp("remote.log.storage.manager.class.name", (Object)"org.apache.kafka.server.log.remote.storage.NoOpRemoteStorageManager").build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateTopicWithRemoteLogManagerInstantiation$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateTopicWithRemoteLogManagerInstantiation$3(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"RaftManager was not initialized.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                java.util.List<NewTopic> newTopic = java.util.List.of(new NewTopic("test-topic", 1, (short)1));
                admin.createTopics(newTopic).all().get();
                this.waitForTopicListing(admin, (Seq<String>)new .colon.colon((Object)"test-topic", (List)Nil$.MODULE$), (Seq<String>)Nil$.MODULE$);
                admin.deleteTopics(java.util.List.of("test-topic")).all().get();
                this.waitForTopicListing(admin, (Seq<String>)Nil$.MODULE$, (Seq<String>)new .colon.colon((Object)"test-topic", (List)Nil$.MODULE$));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSnapshotCount() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp("metadata.log.max.snapshot.interval.ms", (Object)"500").setConfigProp("metadata.max.idle.interval.ms", (Object)"50").build();){
            cluster.format();
            cluster.startup();
            Path metaLog = FileSystems.getDefault().getPath(((ControllerServer)cluster.controllers().get(BoxesRunTime.boxToInteger((int)3000))).config().metadataLogDir(), "__cluster_metadata-0");
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testSnapshotCount$2(metaLog)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Failed to see at least one snapshot");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Thread.sleep(5000L);
            long countAfterTenIntervals = KRaftClusterTest.snapshotCounter$1(metaLog);
            Assertions.assertTrue((countAfterTenIntervals > 1L ? 1 : 0) != 0, (String)("Expected to see at least one more snapshot, saw " + countAfterTenIntervals));
            Assertions.assertTrue((countAfterTenIntervals < 20L ? 1 : 0) != 0, (String)("Did not expect to see more than twice as many snapshots as snapshot intervals, saw " + countAfterTenIntervals));
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testSnapshotCount$4(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"Failed to see latestSnapshotGeneratedBytes > 0");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
        }
    }

    @Test
    public void testAuthorizerFailureFoundInControllerStartup() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumControllerNodes(3).build()).setConfigProp("authorizer.class.name", (Object)BadAuthorizer.class.getName()).build();){
            cluster.format();
            ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> cluster.startup());
            Assertions.assertEquals((Object)"java.lang.IllegalStateException: test authorizer exception", (Object)exception.getMessage());
            cluster.fatalFaultHandler().setIgnore(true);
        }
    }

    @Test
    public void testSingleControllerSingleBrokerCluster() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.MINIMUM_VERSION).setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testReconfigureControllerClientQuotas(boolean combinedController) {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setCombined(combinedController).setNumControllerNodes(1).build()).setConfigProp("client.quota.callback.class", (Object)DummyClientQuotaCallback.class.getName()).setConfigProp(DummyClientQuotaCallback$.MODULE$.dummyClientQuotaCallbackValueConfigKey(), (Object)"0").build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            KRaftClusterTest.assertConfigValue$1(0, cluster);
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.incrementalAlterConfigs(Map.of(new ConfigResource(ConfigResource.Type.BROKER, ""), java.util.List.of(new AlterConfigOp(new ConfigEntry(DummyClientQuotaCallback$.MODULE$.dummyClientQuotaCallbackValueConfigKey(), "1"), AlterConfigOp.OpType.SET)))).all().get();
            }
            KRaftClusterTest.assertConfigValue$1(1, cluster);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testReconfigureControllerAuthorizer(boolean combinedMode) {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setCombined(combinedMode).setNumControllerNodes(1).build()).setConfigProp("authorizer.class.name", (Object)FakeConfigurableAuthorizer.class.getName()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            KRaftClusterTest.assertFoobarValue$1(0, cluster);
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.incrementalAlterConfigs(Map.of(new ConfigResource(ConfigResource.Type.BROKER, ""), java.util.List.of(new AlterConfigOp(new ConfigEntry(FakeConfigurableAuthorizer$.MODULE$.foobarConfigKey(), "123"), AlterConfigOp.OpType.SET)))).all().get();
            }
            KRaftClusterTest.assertFoobarValue$1(123, cluster);
        }
    }

    @Test
    public void testOverlyLargeCreateTopics() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                ArrayList newTopics = new ArrayList();
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 10000).foreach((Function1)(JFunction1.mcZI.sp & Serializable)i -> newTopics.add(new NewTopic("foo" + i, 100000, (short)1)));
                ExecutionException executionException = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> admin.createTopics((Collection)newTopics).all().get());
                Assertions.assertNotNull((Object)executionException.getCause());
                Assertions.assertEquals(PolicyViolationException.class, executionException.getCause().getClass());
                Assertions.assertEquals((Object)"Excessively large number of partitions per request.", (Object)executionException.getCause().getMessage());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTimedOutHeartbeats() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(3).setNumControllerNodes(1).build()).setConfigProp("broker.heartbeat.interval.ms", (Object)Integer.toString(10)).setConfigProp("broker.session.timeout.ms", (Object)Integer.toString(1000)).build();){
            cluster.format();
            cluster.startup();
            ControllerServer controller = (ControllerServer)cluster.controllers().values().iterator().next();
            controller.controller().waitForReadyBrokers(3).get();
            long l = 60000L;
            TestUtils$ retry_this = TestUtils$.MODULE$;
            LongRef retry_wait = LongRef.create((long)1L);
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    KRaftClusterTest.$anonfun$testTimedOutHeartbeats$1(controller);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                        Object var11_9 = null;
                        retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(retry_wait.elem);
                    retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                    continue;
                }
                break;
            }
            Object var4_4 = null;
            Object var7_5 = null;
            Object var10_8 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRegisteredControllerEndpoints() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            long l = 60000L;
            TestUtils$ retry_this = TestUtils$.MODULE$;
            LongRef retry_wait = LongRef.create((long)1L);
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    KRaftClusterTest.$anonfun$testRegisteredControllerEndpoints$1(cluster);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                        Object var10_8 = null;
                        retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(retry_wait.elem);
                    retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                    continue;
                }
                break;
            }
            Object var3_3 = null;
            Object var6_4 = null;
            Object var9_7 = null;
        }
    }

    @Test
    public void testDirectToControllerCommunicationFailsOnOlderMetadataVersion() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_6_IV2).setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            try (Admin admin = Admin.create((Properties)cluster.newClientPropertiesBuilder().setUsingBootstrapControllers(true).build());){
                ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> admin.describeCluster().clusterId().get(1L, TimeUnit.MINUTES));
                Assertions.assertNotNull((Object)exception.getCause());
                Assertions.assertEquals(UnsupportedVersionException.class, exception.getCause().getClass());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testStartupWithNonDefaultKControllerDynamicConfiguration() {
        java.util.List<ApiMessageAndVersion> bootstrapRecords = java.util.List.of(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(MetadataVersion.IBP_3_7_IV0.featureLevel()), (short)0), new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("").setName("num.io.threads").setValue("9"), (short)0));
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder(BootstrapMetadata.fromRecords(bootstrapRecords, (String)"testRecords")).setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            ControllerServer controller = (ControllerServer)cluster.controllers().values().iterator().next();
            long l = 60000L;
            TestUtils$ retry_this = TestUtils$.MODULE$;
            LongRef retry_wait = LongRef.create((long)1L);
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    KRaftClusterTest.$anonfun$testStartupWithNonDefaultKControllerDynamicConfiguration$1(controller);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                        Object var12_10 = null;
                        retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(retry_wait.elem);
                    retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                    continue;
                }
                break;
            }
            Object var5_5 = null;
            Object var8_6 = null;
            Object var11_9 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicDeletedAndRecreatedWhileBrokerIsDown() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_6_IV2).setNumBrokerNodes(3).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                BrokerServer broker0 = (BrokerServer)cluster.brokers().get(BoxesRunTime.boxToInteger((int)0));
                BrokerServer broker1 = (BrokerServer)cluster.brokers().get(BoxesRunTime.boxToInteger((int)1));
                TopicPartition foo0 = new TopicPartition("foo", 0);
                admin.createTopics(java.util.List.of(new NewTopic("foo", 3, (short)3))).all().get();
                long l = 60000L;
                TestUtils$ retry_this = TestUtils$.MODULE$;
                LongRef retry_wait = LongRef.create((long)1L);
                long retry_startTime = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testTopicDeletedAndRecreatedWhileBrokerIsDown$1(broker0, foo0);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                            Object var32_10 = null;
                            retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(retry_wait.elem);
                        retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                        continue;
                    }
                    break;
                }
                Object var11_7 = null;
                Object var14_8 = null;
                Object var17_12 = null;
                broker0.shutdown();
                long l2 = 60000L;
                TestUtils$ retry_this2 = TestUtils$.MODULE$;
                LongRef retry_wait2 = LongRef.create((long)1L);
                long retry_startTime2 = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testTopicDeletedAndRecreatedWhileBrokerIsDown$2(broker1);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this2.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait2);
                            Object var33_17 = null;
                            retry_this2.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this2, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(retry_wait2.elem);
                        retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                        continue;
                    }
                    break;
                }
                Object var18_14 = null;
                Object var21_15 = null;
                Object var24_19 = null;
                LogManager qual$2 = broker0.logManager();
                boolean x$4 = qual$2.getLog$default$2();
                File logDir = ((UnifiedLog)qual$2.getLog(foo0, x$4).get()).dir();
                Files.write(new File(logDir, "partition.metadata").toPath(), "version: 0\ntopic_id: AAAAAAAAAAAAA7SrBWaJ7g\n".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                broker0.startup();
                long l3 = 60000L;
                TestUtils$ retry_this3 = TestUtils$.MODULE$;
                LongRef retry_wait3 = LongRef.create((long)1L);
                long retry_startTime3 = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testTopicDeletedAndRecreatedWhileBrokerIsDown$3(broker1);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this3.logger().underlying().isInfoEnabled()) {
                            String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait3);
                            Object var34_29 = null;
                            retry_this3.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this3, (String)msgWithLogIdent_msg));
                        }
                        Thread.sleep(retry_wait3.elem);
                        retry_wait3.elem += package$.MODULE$.min(retry_wait3.elem, 1000L);
                        continue;
                    }
                    break;
                }
                Object var25_24 = null;
                Object var28_25 = null;
                Object var31_28 = null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAbandonedFutureReplicaRecovered_mainReplicaInOfflineLogDir() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_7_IV2).setNumBrokerNodes(3).setNumDisksPerBroker(2).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Object var33_28;
                Object var25_19;
                Object var17_12;
                BrokerServer broker0 = (BrokerServer)cluster.brokers().get(BoxesRunTime.boxToInteger((int)0));
                BrokerServer broker1 = (BrokerServer)cluster.brokers().get(BoxesRunTime.boxToInteger((int)1));
                TopicPartition foo0 = new TopicPartition("foo", 0);
                admin.createTopics(java.util.List.of(new NewTopic("foo", 3, (short)3))).all().get();
                long l = 60000L;
                TestUtils$ retry_this = TestUtils$.MODULE$;
                LongRef retry_wait = LongRef.create((long)1L);
                long retry_startTime = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOfflineLogDir$1(broker0, foo0);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        Function0 & Serializable retry_info_msg = () -> TestUtils$.$anonfun$retry$1(retry_wait);
                        Logging.info$((Logging)retry_this, (Function0)retry_info_msg);
                        var17_12 = null;
                        Thread.sleep(retry_wait.elem);
                        retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                        continue;
                    }
                    break;
                }
                Object var10_7 = null;
                Object var13_8 = null;
                Object var16_11 = null;
                var17_12 = null;
                broker0.shutdown();
                long l2 = 60000L;
                TestUtils$ retry_this2 = TestUtils$.MODULE$;
                LongRef retry_wait2 = LongRef.create((long)1L);
                long retry_startTime2 = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOfflineLogDir$2(broker1);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        Function0 & Serializable retry_info_msg = () -> TestUtils$.$anonfun$retry$1(retry_wait2);
                        Logging.info$((Logging)retry_this2, (Function0)retry_info_msg);
                        var25_19 = null;
                        Thread.sleep(retry_wait2.elem);
                        retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                        continue;
                    }
                    break;
                }
                Object var18_14 = null;
                Object var21_15 = null;
                Object var24_18 = null;
                var25_19 = null;
                LogManager qual$2 = broker0.logManager();
                boolean x$4 = qual$2.getLog$default$2();
                ((UnifiedLog)qual$2.getLog(foo0, x$4).get()).renameDir(LocalLog.logFutureDirName((TopicPartition)foo0), false);
                broker0.startup();
                long l3 = 60000L;
                TestUtils$ retry_this3 = TestUtils$.MODULE$;
                LongRef retry_wait3 = LongRef.create((long)1L);
                long retry_startTime3 = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOfflineLogDir$3(broker1, broker0, foo0);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        Function0 & Serializable retry_info_msg = () -> TestUtils$.$anonfun$retry$1(retry_wait3);
                        Logging.info$((Logging)retry_this3, (Function0)retry_info_msg);
                        var33_28 = null;
                        Thread.sleep(retry_wait3.elem);
                        retry_wait3.elem += package$.MODULE$.min(retry_wait3.elem, 1000L);
                        continue;
                    }
                    break;
                }
                Object var26_23 = null;
                Object var29_24 = null;
                Object var32_27 = null;
                var33_28 = null;
            }
        }
    }

    public void copyDirectory(String src, String dest) {
        Files.walk(Paths.get(src, new String[0]), new FileVisitOption[0]).forEach(p -> {
            Path out = Paths.get(dest, ((Object)p).toString().substring(src.length()));
            if (!((Object)p).toString().equals(src)) {
                Files.copy(p, out, new CopyOption[0]);
                return;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAbandonedFutureReplicaRecovered_mainReplicaInOnlineLogDir() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_7_IV2).setNumBrokerNodes(3).setNumDisksPerBroker(2).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Object var38_33;
                Object var30_19;
                Object var22_12;
                BrokerServer broker0 = (BrokerServer)cluster.brokers().get(BoxesRunTime.boxToInteger((int)0));
                BrokerServer broker1 = (BrokerServer)cluster.brokers().get(BoxesRunTime.boxToInteger((int)1));
                TopicPartition foo0 = new TopicPartition("foo", 0);
                admin.createTopics(java.util.List.of(new NewTopic("foo", 3, (short)3))).all().get();
                long l2 = 60000L;
                TestUtils$ retry_this = TestUtils$.MODULE$;
                LongRef retry_wait = LongRef.create((long)1L);
                long retry_startTime = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOnlineLogDir$1(broker0, foo0);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        Function0 & Serializable retry_info_msg = () -> TestUtils$.$anonfun$retry$1(retry_wait);
                        Logging.info$((Logging)retry_this, (Function0)retry_info_msg);
                        var22_12 = null;
                        Thread.sleep(retry_wait.elem);
                        retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                        continue;
                    }
                    break;
                }
                Object var15_7 = null;
                Object var18_8 = null;
                Object var21_11 = null;
                var22_12 = null;
                broker0.shutdown();
                long l3 = 60000L;
                TestUtils$ retry_this2 = TestUtils$.MODULE$;
                LongRef retry_wait2 = LongRef.create((long)1L);
                long retry_startTime2 = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOnlineLogDir$2(broker1);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        Function0 & Serializable retry_info_msg = () -> TestUtils$.$anonfun$retry$1(retry_wait2);
                        Logging.info$((Logging)retry_this2, (Function0)retry_info_msg);
                        var30_19 = null;
                        Thread.sleep(retry_wait2.elem);
                        retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                        continue;
                    }
                    break;
                }
                Object var23_14 = null;
                Object var26_15 = null;
                Object var29_18 = null;
                var30_19 = null;
                LogManager qual$2 = broker0.logManager();
                boolean x$4 = qual$2.getLog$default$2();
                UnifiedLog log = (UnifiedLog)qual$2.getLog(foo0, x$4).get();
                String parentDir = log.parentDir();
                String targetParentDir = broker0.config().logDirs().stream().filter(l -> !l.equals(parentDir)).findFirst().get();
                File targetDirFile = new File(targetParentDir, log.dir().getName());
                targetDirFile.mkdir();
                this.copyDirectory(log.dir().toString(), targetDirFile.toString());
                Assertions.assertTrue((boolean)targetDirFile.exists());
                File originalLogFile = log.dir();
                log.renameDir(LocalLog.logFutureDirName((TopicPartition)foo0), false);
                Assertions.assertFalse((boolean)originalLogFile.exists());
                broker0.startup();
                long l4 = 60000L;
                TestUtils$ retry_this3 = TestUtils$.MODULE$;
                LongRef retry_wait3 = LongRef.create((long)1L);
                long retry_startTime3 = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOnlineLogDir$4(broker1, broker0, foo0, targetDirFile, originalLogFile);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        Function0 & Serializable retry_info_msg = () -> TestUtils$.$anonfun$retry$1(retry_wait3);
                        Logging.info$((Logging)retry_this3, (Function0)retry_info_msg);
                        var38_33 = null;
                        Thread.sleep(retry_wait3.elem);
                        retry_wait3.elem += package$.MODULE$.min(retry_wait3.elem, 1000L);
                        continue;
                    }
                    break;
                }
                Object var31_28 = null;
                Object var34_29 = null;
                Object var37_32 = null;
                var38_33 = null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerFailover() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(5).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testControllerFailover$1(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Broker never made it to RUNNING state.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testControllerFailover$3(cluster)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"RaftManager was not initialized.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.createTopics(java.util.List.of(new NewTopic("test-topic", 1, (short)1))).all().get();
                this.waitForTopicListing(admin, (Seq<String>)new .colon.colon((Object)"test-topic", (List)Nil$.MODULE$), (Seq<String>)Nil$.MODULE$);
                Controller active = cluster.waitForActiveController();
                ((KafkaRaftManager)cluster.raftManagers().get(BoxesRunTime.boxToInteger((int)((QuorumController)active).nodeId()))).shutdown();
                admin.createTopics(java.util.List.of(new NewTopic("test-topic2", 1, (short)1))).all().get();
                this.waitForTopicListing(admin, (Seq<String>)new .colon.colon((Object)"test-topic2", (List)Nil$.MODULE$), (Seq<String>)Nil$.MODULE$);
            }
        }
    }

    @Test
    public void testOldBootstrapMetadataFile() {
        Path baseDirectory = TestUtils.tempDirectory(null, null).toPath();
        Using$.MODULE$.resource((Object)new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).setBaseDirectory(baseDirectory).build()).setDeleteOnClose(false).build(), (Function1 & Serializable)cluster -> {
            KRaftClusterTest.$anonfun$testOldBootstrapMetadataFile$1(cluster);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        BootstrapMetadata oldBootstrapMetadata = BootstrapMetadata.fromRecords(java.util.List.of(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("metadata.version").setFeatureLevel((short)1), (short)0)), (String)"oldBootstrapMetadata");
        Using$.MODULE$.resource((Object)new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).setBaseDirectory(baseDirectory).setBootstrapMetadata(oldBootstrapMetadata).build()).build(), (Function1 & Serializable)cluster -> {
            KRaftClusterTest.$anonfun$testOldBootstrapMetadataFile$2(cluster);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testIncreaseNumIoThreads() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).setConfigProp("num.io.threads", (Object)"4").build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.incrementalAlterConfigs(Map.of(new ConfigResource(ConfigResource.Type.BROKER, ""), java.util.List.of(new AlterConfigOp(new ConfigEntry("num.io.threads", "8"), AlterConfigOp.OpType.SET)))).all().get();
                java.util.List<NewTopic> newTopic = java.util.List.of(new NewTopic("test-topic", 1, (short)1));
                admin.createTopics(newTopic).all().get();
                this.waitForTopicListing(admin, (Seq<String>)new .colon.colon((Object)"test-topic", (List)Nil$.MODULE$), (Seq<String>)Nil$.MODULE$);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndRestartControllerNode$1(ControllerServer x$1) {
        return x$1.controller().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndRestartControllerNode$3(ControllerServer x$2) {
        return x$2.controller().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndRestartControllerNode$2(KafkaClusterTestKit cluster$1) {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(cluster$1.controllers().values().iterator()).asScala().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testCreateClusterAndRestartControllerNode$3(x$2)));
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndRestartControllerNode$4() {
        return "Timeout waiting for new controller election";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndWaitForBrokerInRunningState$1(KafkaClusterTestKit cluster$2) {
        BrokerState brokerState = ((BrokerServer)cluster$2.brokers().get(BoxesRunTime.boxToInteger((int)0))).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndWaitForBrokerInRunningState$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndWaitForBrokerInRunningState$3(KafkaClusterTestKit cluster$2) {
        return ((KafkaRaftManager)cluster$2.raftManagers().get(BoxesRunTime.boxToInteger((int)0))).client().leaderAndEpoch().leaderId().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndWaitForBrokerInRunningState$4() {
        return "RaftManager was not initialized.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateListDeleteTopic$1(KafkaClusterTestKit cluster$3) {
        BrokerState brokerState = ((BrokerServer)cluster$3.brokers().get(BoxesRunTime.boxToInteger((int)0))).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateListDeleteTopic$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateListDeleteTopic$3(KafkaClusterTestKit cluster$3) {
        return ((KafkaRaftManager)cluster$3.raftManagers().get(BoxesRunTime.boxToInteger((int)0))).client().leaderAndEpoch().leaderId().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateListDeleteTopic$4() {
        return "RaftManager was not initialized.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateAndManyTopics$1(KafkaClusterTestKit cluster$4) {
        BrokerState brokerState = ((BrokerServer)cluster$4.brokers().get(BoxesRunTime.boxToInteger((int)0))).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateAndManyTopics$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateAndManyTopics$3(KafkaClusterTestKit cluster$4) {
        return ((KafkaRaftManager)cluster$4.raftManagers().get(BoxesRunTime.boxToInteger((int)0))).client().leaderAndEpoch().leaderId().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateAndManyTopics$4() {
        return "RaftManager was not initialized.";
    }

    public static final /* synthetic */ boolean $anonfun$testClientQuotas$1(KafkaClusterTestKit cluster$5) {
        BrokerState brokerState = ((BrokerServer)cluster$5.brokers().get(BoxesRunTime.boxToInteger((int)0))).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testClientQuotas$2() {
        return "Broker never made it to RUNNING state.";
    }

    private static final Map describeOrFail$1(ClientQuotaFilter filter, Admin admin$1) {
        try {
            return (Map)admin$1.describeClientQuotas(filter).entities().get();
        }
        catch (Throwable t) {
            return (Map)Assertions.fail((String)"DescribeClientQuotas request failed", (Throwable)t);
        }
    }

    public static final /* synthetic */ Map $anonfun$testClientQuotas$3(ClientQuotaFilter filter$1, Admin admin$1) {
        return KRaftClusterTest.describeOrFail$1(filter$1, admin$1);
    }

    public static final /* synthetic */ boolean $anonfun$testClientQuotas$4(ClientQuotaEntity entity$1, int expectCount$1, Map results) {
        return results.getOrDefault(entity$1, Map.of()).size() == expectCount$1;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map alterThenDescribe$1(ClientQuotaEntity entity, Seq quotas, ClientQuotaFilter filter, int expectCount, Admin admin$1) {
        void var7_11;
        Tuple2 tuple2;
        try {
            admin$1.alterClientQuotas(java.util.List.of(new ClientQuotaAlteration(entity, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava(quotas).asJava()))).all().get();
        }
        catch (Throwable t) {
            Assertions.fail((String)"AlterClientQuotas request failed", (Throwable)t);
        }
        long l = 100L;
        long computeUntilTrue_waitTime = 15000L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            Map computeUntilTrue_result;
            if (KRaftClusterTest.$anonfun$testClientQuotas$4(entity, expectCount, computeUntilTrue_result = KRaftClusterTest.describeOrFail$1(filter, admin$1))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Object var14_9 = null;
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Map describeResult = (Map)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp(), (String)"Broker never saw new client quotas");
        return var7_11;
    }

    public static final /* synthetic */ void $anonfun$testClientQuotas$5(Admin admin$1, ObjectRef filter$2, ClientQuotaEntity entity$2, ClientQuotaEntity entity2$1) {
        Map results = (Map)admin$1.describeClientQuotas((ClientQuotaFilter)filter$2.elem).entities().get();
        Assertions.assertEquals((int)2, (int)results.size(), (String)"Broker did not see two client quotas");
        Assertions.assertEquals((double)9999.0, (double)Predef$.MODULE$.Double2double((Double)((Map)results.get(entity$2)).get("producer_byte_rate")), (double)1.0E-6);
        Assertions.assertEquals((double)9998.0, (double)Predef$.MODULE$.Double2double((Double)((Map)results.get(entity2$1)).get("producer_byte_rate")), (double)1.0E-6);
    }

    public static final /* synthetic */ long $anonfun$getConsumerByteRates$2(HashMap results$1, ClientQuotaEntity entity$3, Double value) {
        return BoxesRunTime.unboxToLong((Object)results$1.put(entity$3, BoxesRunTime.boxToLong((long)value.longValue())));
    }

    public static final /* synthetic */ boolean $anonfun$testDefaultClientQuotas$1(KafkaClusterTestKit cluster$6) {
        BrokerState brokerState = ((BrokerServer)cluster$6.brokers().get(BoxesRunTime.boxToInteger((int)0))).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testDefaultClientQuotas$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ void $anonfun$testDefaultClientQuotas$3(KRaftClusterTest $this, Admin admin$2) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$), $this.getConsumerByteRates(admin$2));
    }

    public static final /* synthetic */ void $anonfun$testDefaultClientQuotas$4(KRaftClusterTest $this, ClientQuotaEntity defaultUser$1, Admin admin$2) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultUser$1), (Object)BoxesRunTime.boxToLong((long)100L))})), $this.getConsumerByteRates(admin$2));
    }

    public static final /* synthetic */ void $anonfun$testDefaultClientQuotas$5(KRaftClusterTest $this, ClientQuotaEntity defaultUser$1, ClientQuotaEntity bobUser$1, Admin admin$2) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultUser$1), (Object)BoxesRunTime.boxToLong((long)100L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bobUser$1), (Object)BoxesRunTime.boxToLong((long)1000L))})), $this.getConsumerByteRates(admin$2));
    }

    public static final /* synthetic */ void $anonfun$testCreateClusterWithAdvertisedPortZero$1(Map brokerPropertyOverrides$1, int brokerId) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("listeners", "EXTERNAL://localhost:0");
        props.put("advertised.listeners", "EXTERNAL://localhost:0");
        brokerPropertyOverrides$1.put(Predef$.MODULE$.int2Integer(brokerId), props);
    }

    public static final /* synthetic */ void $anonfun$testCreateClusterWithAdvertisedPortZero$2(KRaftClusterTest $this, KafkaClusterTestKit cluster) {
        $this.sendDescribeClusterRequestToBoundPortUntilAllBrokersPropagated(cluster.nodes().brokerListenerName(), scala.concurrent.duration.package$.MODULE$.pairLongToDuration(new Tuple2((Object)BoxesRunTime.boxToLong((long)15L), (Object)TimeUnit.SECONDS)), cluster).nodes().values().forEach(broker -> {
            Assertions.assertEquals((Object)"localhost", (Object)broker.host(), (String)"Did not advertise configured advertised host");
            Assertions.assertEquals((int)((BrokerServer)cluster.brokers().get(BoxesRunTime.boxToInteger((int)broker.id()))).socketServer().boundPort(cluster.nodes().brokerListenerName()), (int)broker.port(), (String)"Did not advertise bound socket port");
        });
    }

    public static final /* synthetic */ void $anonfun$testCreateClusterWithAdvertisedHostAndPortDifferentFromSocketServer$1(Map brokerPropertyOverrides$2, int brokerId) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("listeners", "EXTERNAL://localhost:0");
        props.put("advertised.listeners", "EXTERNAL://advertised-host-" + brokerId + ":" + (brokerId + 100));
        brokerPropertyOverrides$2.put(Predef$.MODULE$.int2Integer(brokerId), props);
    }

    public static final /* synthetic */ void $anonfun$testCreateClusterWithAdvertisedHostAndPortDifferentFromSocketServer$2(KRaftClusterTest $this, KafkaClusterTestKit cluster) {
        $this.sendDescribeClusterRequestToBoundPortUntilAllBrokersPropagated(cluster.nodes().brokerListenerName(), scala.concurrent.duration.package$.MODULE$.pairLongToDuration(new Tuple2((Object)BoxesRunTime.boxToLong((long)15L), (Object)TimeUnit.SECONDS)), cluster).nodes().values().forEach(broker -> {
            Assertions.assertEquals((Object)("advertised-host-" + broker.id()), (Object)broker.host(), (String)"Did not advertise configured advertised host");
            Assertions.assertEquals((int)(broker.id() + 100), (int)broker.port(), (String)"Did not advertise configured advertised port");
        });
    }

    public static final /* synthetic */ boolean $anonfun$waitForRunningBrokers$1(BrokerServer brokerServer) {
        BrokerState brokerState = brokerServer.brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    private static final Seq getRunningBrokerServers$1(KafkaClusterTestKit cluster$8) {
        return (Seq)CollectionConverters$.MODULE$.CollectionHasAsScala(cluster$8.brokers().values()).asScala().toSeq().filter((Function1 & Serializable)brokerServer -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$waitForRunningBrokers$1(brokerServer)));
    }

    public static final /* synthetic */ Seq $anonfun$waitForRunningBrokers$2(KafkaClusterTestKit cluster$8) {
        return KRaftClusterTest.getRunningBrokerServers$1(cluster$8);
    }

    public static final /* synthetic */ boolean $anonfun$sendDescribeClusterRequestToBoundPortUntilBrokersPropagated$2(int expectedBrokerCount$1, DescribeClusterResponse response) {
        return response.nodes().size() == expectedBrokerCount$1;
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndPerformReassignment$1(Admin admin$3) {
        return ((Map)admin$3.listPartitionReassignments().reassignments().get()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndPerformReassignment$2() {
        return "The reassignment never completed.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndPerformReassignment$3(KRaftClusterTest $this, Admin admin$3, ObjectRef currentMapping$1, Seq expectedMapping$1) {
        Map topicInfoMap = (Map)admin$3.describeTopics(java.util.Set.of("foo")).allTopicNames().get();
        if (topicInfoMap.containsKey("foo")) {
            currentMapping$1.elem = $this.translatePartitionInfoToSeq(((TopicDescription)topicInfoMap.get("foo")).partitions());
            return expectedMapping$1.equals((Object)((Seq)currentMapping$1.elem));
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndPerformReassignment$4(Seq expectedMapping$1, ObjectRef currentMapping$1) {
        return "Timed out waiting for replica assignments for topic foo. Wanted: " + expectedMapping$1 + ". Got: " + (Seq)currentMapping$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$checkReplicaManager$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$checkReplicaManager$3(Tuple2 check$ifrefutable$2) {
        return check$ifrefutable$2 != null;
    }

    public static final /* synthetic */ void $anonfun$checkReplicaManager$4(BrokerServer broker$1, Tuple2 x$7) {
        if (x$7 != null) {
            boolean isHosted = x$7._1$mcZ$sp();
            int partitionId = x$7._2$mcI$sp();
            TopicPartition topicPartition = new TopicPartition("foo", partitionId);
            if (isHosted) {
                Assertions.assertNotEquals((Object)HostedPartition.None$.MODULE$, (Object)broker$1.replicaManager().getPartition(topicPartition), (String)("topicPartition = " + topicPartition));
                return;
            }
            Assertions.assertEquals((Object)HostedPartition.None$.MODULE$, (Object)broker$1.replicaManager().getPartition(topicPartition), (String)("topicPartition = " + topicPartition));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$checkReplicaManager$2(KafkaClusterTestKit cluster$10, Tuple2 x$8) {
        if (x$8 != null) {
            int brokerId = x$8._1$mcI$sp();
            List partitionsIsHosted = (List)x$8._2();
            BrokerServer broker = (BrokerServer)cluster$10.brokers().get(BoxesRunTime.boxToInteger((int)brokerId));
            ((IterableOps)partitionsIsHosted.zipWithIndex()).withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$checkReplicaManager$3(check$ifrefutable$2))).foreach((Function1 & Serializable)x$7 -> {
                KRaftClusterTest.$anonfun$checkReplicaManager$4(broker, x$7);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$waitForTopicListing$2(Admin admin$4, HashSet topicsNotFound$1, ObjectRef extraTopics$1, Seq expectedAbsent$1) {
        ((Iterable)admin$4.listTopics().names().get()).forEach(name -> topicsNotFound$1.remove(name));
        extraTopics$1.elem = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)admin$4.listTopics().names().get()).asScala().filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)expectedAbsent$1.contains((Object)x$10)));
        return topicsNotFound$1.isEmpty() && ((scala.collection.mutable.Set)extraTopics$1.elem).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$waitForTopicListing$5(HashSet topicsNotFound$1, ObjectRef extraTopics$1) {
        return "Failed to find topic(s): " + CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)topicsNotFound$1).asScala() + " and NOT find topic(s): " + (scala.collection.mutable.Set)extraTopics$1.elem;
    }

    public static final /* synthetic */ void $anonfun$validateConfigs$1(KRaftClusterTest $this, Admin admin$5, scala.collection.immutable.Map expected$1, scala.collection.mutable.HashMap results$2, boolean exhaustive$1) {
        try {
            Map values = admin$5.describeConfigs((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)expected$1.keySet()).asJava()).values();
            results$2.clear();
            Assertions.assertEquals((Object)expected$1.keySet(), (Object)CollectionConverters$.MODULE$.SetHasAsScala(values.keySet()).asScala());
            expected$1.foreach((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    ConfigResource resource = (ConfigResource)x0$1._1();
                    Seq pairs = (Seq)x0$1._2();
                    Config config = (Config)((KafkaFuture)values.get(resource)).get();
                    TreeMap actual = new TreeMap();
                    TreeMap expected = new TreeMap();
                    config.entries().forEach(entry -> {
                        actual.put(entry.name(), entry.value());
                        if (!exhaustive$1) {
                            expected.put(entry.name(), entry.value());
                            return;
                        }
                    });
                    pairs.foreach((Function1 & Serializable)x0$2 -> {
                        if (x0$2 != null) {
                            String k = (String)x0$2._1();
                            String v = (String)x0$2._2();
                            return expected.put(k, v);
                        }
                        throw new MatchError(null);
                    });
                    Assertions.assertEquals(expected, actual);
                    return results$2.put((Object)resource, actual);
                }
                throw new MatchError(null);
            });
            return;
        }
        catch (Throwable t) {
            $this.log().warn("Unable to describeConfigs(" + CollectionConverters$.MODULE$.SetHasAsJava((Set)expected$1.keySet()).asJava() + ")", t);
            throw t;
        }
    }

    public static final /* synthetic */ String $anonfun$testUnregisterBroker$2() {
        return "Timed out waiting for broker 0 to be unfenced.";
    }

    public static final /* synthetic */ boolean $anonfun$testUnregisterBroker$3(KRaftClusterTest $this, KafkaClusterTestKit cluster$11) {
        return !$this.brokerIsUnfenced($this.clusterImage(cluster$11, 1), 0);
    }

    public static final /* synthetic */ String $anonfun$testUnregisterBroker$4() {
        return "Timed out waiting for broker 0 to be fenced.";
    }

    public static final /* synthetic */ String $anonfun$testUnregisterBroker$6() {
        return "Timed out waiting for broker 0 to be fenced.";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumRequestToBrokers$2(KafkaClusterTestKit cluster$12, int i$1) {
        BrokerState brokerState = ((BrokerServer)cluster$12.brokers().get(BoxesRunTime.boxToInteger((int)i$1))).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testDescribeQuorumRequestToBrokers$3() {
        return "Broker Never started up";
    }

    public static final /* synthetic */ java.util.List $anonfun$testDescribeQuorumRequestToBrokers$5(Admin admin$6) {
        return ((QuorumInfo)admin$6.describeMetadataQuorum(new DescribeMetadataQuorumOptions()).quorumInfo().get()).voters();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumRequestToBrokers$6(java.util.List voters) {
        return voters.stream().allMatch(voter -> {
            if (voter.logEndOffset() > 0L) {
                OptionalLong optionalLong = voter.lastFetchTimestamp();
                OptionalLong optionalLong2 = OptionalLong.empty();
                if (optionalLong == null ? optionalLong2 != null : !((Object)optionalLong).equals(optionalLong2)) {
                    OptionalLong optionalLong3 = voter.lastCaughtUpTimestamp();
                    OptionalLong optionalLong4 = OptionalLong.empty();
                    if (optionalLong3 == null ? optionalLong4 != null : !((Object)optionalLong3).equals(optionalLong4)) {
                        return true;
                    }
                }
            }
            return false;
        });
    }

    public static final /* synthetic */ java.util.List $anonfun$testDescribeQuorumRequestToBrokers$8(Admin admin$6) {
        return ((QuorumInfo)admin$6.describeMetadataQuorum(new DescribeMetadataQuorumOptions()).quorumInfo().get()).observers();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumRequestToBrokers$9(KafkaClusterTestKit cluster$12, java.util.List observers) {
        Set set = CollectionConverters$.MODULE$.MapHasAsScala(cluster$12.brokers()).asScala().keySet();
        scala.collection.immutable.Set set2 = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(observers).asScala().map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.replicaId()))).toSet();
        return !(set != null ? !set.equals(set2) : set2 != null) && observers.stream().allMatch(observer -> {
            if (observer.logEndOffset() > 0L) {
                OptionalLong optionalLong = observer.lastFetchTimestamp();
                OptionalLong optionalLong2 = OptionalLong.empty();
                if (optionalLong == null ? optionalLong2 != null : !((Object)optionalLong).equals(optionalLong2)) {
                    OptionalLong optionalLong3 = observer.lastCaughtUpTimestamp();
                    OptionalLong optionalLong4 = OptionalLong.empty();
                    if (optionalLong3 == null ? optionalLong4 != null : !((Object)optionalLong3).equals(optionalLong4)) {
                        return true;
                    }
                }
            }
            return false;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumRequestToControllers$2(KafkaClusterTestKit cluster$13, int i$2) {
        BrokerState brokerState = ((BrokerServer)cluster$13.brokers().get(BoxesRunTime.boxToInteger((int)i$2))).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testDescribeQuorumRequestToControllers$3() {
        return "Broker Never started up";
    }

    public static final /* synthetic */ boolean $anonfun$testUpdateMetadataVersion$1(KafkaClusterTestKit cluster$14) {
        return ((BrokerServer)cluster$14.brokers().get(BoxesRunTime.boxToInteger((int)0))).metadataCache().currentImage().features().metadataVersion().equals(Optional.of(MetadataVersion.latestTesting()));
    }

    public static final /* synthetic */ String $anonfun$testUpdateMetadataVersion$2() {
        return "Timed out waiting for metadata.version update";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateTopicWithRemoteLogManagerInstantiation$1(KafkaClusterTestKit cluster$15) {
        BrokerState brokerState = ((BrokerServer)cluster$15.brokers().get(BoxesRunTime.boxToInteger((int)0))).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateTopicWithRemoteLogManagerInstantiation$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateTopicWithRemoteLogManagerInstantiation$3(KafkaClusterTestKit cluster$15) {
        return ((KafkaRaftManager)cluster$15.raftManagers().get(BoxesRunTime.boxToInteger((int)0))).client().leaderAndEpoch().leaderId().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateTopicWithRemoteLogManagerInstantiation$4() {
        return "RaftManager was not initialized.";
    }

    private static final long snapshotCounter$1(Path path) {
        return path.toFile().listFiles((x$19, name) -> name.toLowerCase().endsWith("checkpoint")).length;
    }

    public static final /* synthetic */ boolean $anonfun$testSnapshotCount$2(Path metaLog$1) {
        return KRaftClusterTest.snapshotCounter$1(metaLog$1) > 0L;
    }

    public static final /* synthetic */ String $anonfun$testSnapshotCount$3() {
        return "Failed to see at least one snapshot";
    }

    public static final /* synthetic */ boolean $anonfun$testSnapshotCount$4(KafkaClusterTestKit cluster$16) {
        return ((ControllerServer)cluster$16.controllers().values().iterator().next()).sharedServer().snapshotEmitter().metrics().latestSnapshotGeneratedBytes() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testSnapshotCount$5() {
        return "Failed to see latestSnapshotGeneratedBytes > 0";
    }

    public static final /* synthetic */ void $anonfun$testReconfigureControllerClientQuotas$1(int expected$3, KafkaClusterTestKit cluster$18) {
        Assertions.assertEquals((int)expected$3, (int)((DummyClientQuotaCallback)((Plugin)((ControllerServer)cluster$18.controllers().values().iterator().next()).quotaManagers().clientQuotaCallbackPlugin().get()).get()).value());
        Assertions.assertEquals((int)expected$3, (int)((DummyClientQuotaCallback)((Plugin)((BrokerServer)cluster$18.brokers().values().iterator().next()).quotaManagers().clientQuotaCallbackPlugin().get()).get()).value());
    }

    private static final void assertConfigValue$1(int expected, KafkaClusterTestKit cluster$18) {
        long retry_maxWaitMs = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                KRaftClusterTest.$anonfun$testReconfigureControllerClientQuotas$1(expected, cluster$18);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var9_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testReconfigureControllerAuthorizer$1(int expected$4, KafkaClusterTestKit cluster$19) {
        Assertions.assertEquals((int)expected$4, (int)((FakeConfigurableAuthorizer)((Plugin)((ControllerServer)cluster$19.controllers().values().iterator().next()).authorizerPlugin().get()).get()).foobar().get());
        Assertions.assertEquals((int)expected$4, (int)((FakeConfigurableAuthorizer)((Plugin)((BrokerServer)cluster$19.brokers().values().iterator().next()).authorizerPlugin().get()).get()).foobar().get());
    }

    private static final void assertFoobarValue$1(int expected, KafkaClusterTestKit cluster$19) {
        long retry_maxWaitMs = 60000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                KRaftClusterTest.$anonfun$testReconfigureControllerAuthorizer$1(expected, cluster$19);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = TestUtils$.$anonfun$retry$1(retry_wait);
                    Object var9_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testTimedOutHeartbeats$1(ControllerServer controller$1) {
        CountDownLatch latch = QuorumControllerIntegrationTestUtils.pause((QuorumController)((QuorumController)controller$1.controller()));
        Thread.sleep(1001L);
        latch.countDown();
        Assertions.assertEquals((int)0, (int)controller$1.sharedServer().controllerServerMetrics().fencedBrokerCount());
        Assertions.assertTrue((controller$1.quorumControllerMetrics().timedOutHeartbeats() > 0L ? 1 : 0) != 0, (String)"Expected timedOutHeartbeats to be greater than 0.");
    }

    public static final /* synthetic */ void $anonfun$testRegisteredControllerEndpoints$1(KafkaClusterTestKit cluster$20) {
        Map registeredControllers = ((ControllerServer)cluster$20.controllers().values().iterator().next()).registrationsPublisher().controllers();
        Assertions.assertEquals((int)3, (int)registeredControllers.size(), (String)"Expected 3 controller registrations");
        registeredControllers.values().forEach(registration -> {
            Assertions.assertNotNull(registration.listeners().get("CONTROLLER"));
            Assertions.assertNotEquals((int)0, (int)((Endpoint)registration.listeners().get("CONTROLLER")).port());
        });
    }

    public static final /* synthetic */ void $anonfun$testStartupWithNonDefaultKControllerDynamicConfiguration$1(ControllerServer controller$2) {
        Assertions.assertNotNull((Object)controller$2.controllerApisHandlerPool());
        Assertions.assertEquals((int)9, (int)controller$2.controllerApisHandlerPool().threadPoolSize().get());
    }

    public static final /* synthetic */ void $anonfun$testTopicDeletedAndRecreatedWhileBrokerIsDown$1(BrokerServer broker0$1, TopicPartition foo0$1) {
        LogManager qual$1 = broker0$1.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Assertions.assertTrue((boolean)qual$1.getLog(foo0$1, x$2).isDefined());
    }

    public static final /* synthetic */ void $anonfun$testTopicDeletedAndRecreatedWhileBrokerIsDown$2(BrokerServer broker1$1) {
        Optional info = broker1$1.metadataCache().getLeaderAndIsr("foo", 0);
        Assertions.assertTrue((boolean)info.isPresent());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((LeaderAndIsr)info.get()).isr()).asScala().toSet());
    }

    public static final /* synthetic */ void $anonfun$testTopicDeletedAndRecreatedWhileBrokerIsDown$3(BrokerServer broker1$1) {
        Optional info = broker1$1.metadataCache().getLeaderAndIsr("foo", 0);
        Assertions.assertTrue((boolean)info.isPresent());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((LeaderAndIsr)info.get()).isr()).asScala().toSet());
    }

    public static final /* synthetic */ void $anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOfflineLogDir$1(BrokerServer broker0$2, TopicPartition foo0$2) {
        LogManager qual$1 = broker0$2.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Assertions.assertTrue((boolean)qual$1.getLog(foo0$2, x$2).isDefined());
    }

    public static final /* synthetic */ void $anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOfflineLogDir$2(BrokerServer broker1$2) {
        Optional info = broker1$2.metadataCache().getLeaderAndIsr("foo", 0);
        Assertions.assertTrue((boolean)info.isPresent());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((LeaderAndIsr)info.get()).isr()).asScala().toSet());
    }

    public static final /* synthetic */ void $anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOfflineLogDir$3(BrokerServer broker1$2, BrokerServer broker0$2, TopicPartition foo0$2) {
        Optional info = broker1$2.metadataCache().getLeaderAndIsr("foo", 0);
        Assertions.assertTrue((boolean)info.isPresent());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((LeaderAndIsr)info.get()).isr()).asScala().toSet());
        Assertions.assertTrue((boolean)broker0$2.logManager().getLog(foo0$2, true).isEmpty());
    }

    public static final /* synthetic */ void $anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOnlineLogDir$1(BrokerServer broker0$3, TopicPartition foo0$3) {
        LogManager qual$1 = broker0$3.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Assertions.assertTrue((boolean)qual$1.getLog(foo0$3, x$2).isDefined());
    }

    public static final /* synthetic */ void $anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOnlineLogDir$2(BrokerServer broker1$3) {
        Optional info = broker1$3.metadataCache().getLeaderAndIsr("foo", 0);
        Assertions.assertTrue((boolean)info.isPresent());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((LeaderAndIsr)info.get()).isr()).asScala().toSet());
    }

    public static final /* synthetic */ void $anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOnlineLogDir$4(BrokerServer broker1$3, BrokerServer broker0$3, TopicPartition foo0$3, File targetDirFile$1, File originalLogFile$1) {
        Optional info = broker1$3.metadataCache().getLeaderAndIsr("foo", 0);
        Assertions.assertTrue((boolean)info.isPresent());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((LeaderAndIsr)info.get()).isr()).asScala().toSet());
        Assertions.assertTrue((boolean)broker0$3.logManager().getLog(foo0$3, true).isEmpty());
        Assertions.assertFalse((boolean)targetDirFile$1.exists());
        Assertions.assertTrue((boolean)originalLogFile$1.exists());
    }

    public static final /* synthetic */ boolean $anonfun$testControllerFailover$1(KafkaClusterTestKit cluster$21) {
        BrokerState brokerState = ((BrokerServer)cluster$21.brokers().get(BoxesRunTime.boxToInteger((int)0))).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testControllerFailover$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerFailover$3(KafkaClusterTestKit cluster$21) {
        return ((KafkaRaftManager)cluster$21.raftManagers().get(BoxesRunTime.boxToInteger((int)0))).client().leaderAndEpoch().leaderId().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testControllerFailover$4() {
        return "RaftManager was not initialized.";
    }

    public static final /* synthetic */ void $anonfun$testOldBootstrapMetadataFile$1(KafkaClusterTestKit cluster) {
        cluster.format();
        cluster.startup();
        cluster.waitForReadyBrokers();
    }

    public static final /* synthetic */ void $anonfun$testOldBootstrapMetadataFile$2(KafkaClusterTestKit cluster) {
        cluster.startup();
        cluster.waitForReadyBrokers();
    }

    public static final /* synthetic */ Object $anonfun$testCreateClusterWithAdvertisedPortZero$2$adapted(KRaftClusterTest $this, KafkaClusterTestKit cluster) {
        KRaftClusterTest.$anonfun$testCreateClusterWithAdvertisedPortZero$2($this, cluster);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCreateClusterWithAdvertisedHostAndPortDifferentFromSocketServer$2$adapted(KRaftClusterTest $this, KafkaClusterTestKit cluster) {
        KRaftClusterTest.$anonfun$testCreateClusterWithAdvertisedHostAndPortDifferentFromSocketServer$2($this, cluster);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$waitForRunningBrokers$3$adapted(Seq x$4) {
        return BoxesRunTime.boxToBoolean((boolean)x$4.nonEmpty());
    }

    public static final /* synthetic */ Object $anonfun$sendDescribeClusterRequestToBoundPortUntilBrokersPropagated$2$adapted(int expectedBrokerCount$1, DescribeClusterResponse response) {
        return BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$sendDescribeClusterRequestToBoundPortUntilBrokersPropagated$2(expectedBrokerCount$1, response));
    }

    public static final /* synthetic */ Object $anonfun$testDescribeQuorumRequestToBrokers$6$adapted(java.util.List voters) {
        return BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$6(voters));
    }

    public static final /* synthetic */ Object $anonfun$testDescribeQuorumRequestToBrokers$9$adapted(KafkaClusterTestKit cluster$12, java.util.List observers) {
        return BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$9(cluster$12, observers));
    }

    public static final /* synthetic */ Object $anonfun$testClientQuotas$4$adapted(ClientQuotaEntity entity$1, int expectCount$1, Map results) {
        return BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testClientQuotas$4(entity$1, expectCount$1, results));
    }
}

