/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005-g\u0001\u0002\n\u0014\u0001aAQ!\b\u0001\u0005\u0002yAq\u0001\t\u0001C\u0002\u0013\u0005\u0011\u0005\u0003\u0004+\u0001\u0001\u0006IA\t\u0005\bW\u0001\u0011\r\u0011\"\u0001-\u0011\u0019A\u0004\u0001)A\u0005[!)\u0011\b\u0001C!u!)q\n\u0001C\u0001!\")A\f\u0001C\u0001;\")1\u000f\u0001C\u0001!\"1Q\u000f\u0001Q\u0005\nYD\u0001\"a\r\u0001A\u0013%\u0011Q\u0007\u0005\t\u0003\u0007\u0002\u0001\u0015\"\u0003\u0002F!1\u00111\u000b\u0001\u0005\u0002ACq!a\u0016\u0001\t\u0003\tI\u0006C\u0004\u0002\n\u0002!I!a#\t\rU\u0004A\u0011BAQ\u0011\u001d\ty\u000b\u0001C\u0001\u0003c\u0013a\u0003T5ti>3gm]3ugJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003)U\taa]3sm\u0016\u0014(\"\u0001\f\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0007\t\u00035mi\u0011aE\u0005\u00039M\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"A\u0007\u0001\u0002\u000bQ|\u0007/[2\u0016\u0003\t\u0002\"a\t\u0015\u000e\u0003\u0011R!!\n\u0014\u0002\t1\fgn\u001a\u0006\u0002O\u0005!!.\u0019<b\u0013\tICE\u0001\u0004TiJLgnZ\u0001\u0007i>\u0004\u0018n\u0019\u0011\u0002\u0013A\f'\u000f^5uS>tW#A\u0017\u0011\u000592T\"A\u0018\u000b\u0005A\n\u0014AB2p[6|gN\u0003\u0002\u0017e)\u00111\u0007N\u0001\u0007CB\f7\r[3\u000b\u0003U\n1a\u001c:h\u0013\t9tF\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u0015A\f'\u000f^5uS>t\u0007%A\u0007n_\u0012Lg-_\"p]\u001aLwm\u001d\u000b\u0003w\u0005\u0003\"\u0001P \u000e\u0003uR\u0011AP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0001v\u0012A!\u00168ji\")!I\u0002a\u0001\u0007\u0006)\u0001O]8qgB\u0019AiR%\u000e\u0003\u0015S!AR\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002I\u000b\n\u00191+Z9\u0011\u0005)kU\"A&\u000b\u000513\u0013\u0001B;uS2L!AT&\u0003\u0015A\u0013x\u000e]3si&,7/A\ruKN$H*[:u\u001f\u001a47/\u001a;t\u000bJ\u0014xN]\"pI\u0016\u001cH#A\u001e)\u0005\u001d\u0011\u0006CA*[\u001b\u0005!&BA+W\u0003\r\t\u0007/\u001b\u0006\u0003/b\u000bqA[;qSR,'O\u0003\u0002Zi\u0005)!.\u001e8ji&\u00111\f\u0016\u0002\u0005)\u0016\u001cH/A\u000ebgN,'\u000f\u001e*fgB|gn]3FeJ|'OR8s\u000bB|7\r\u001b\u000b\u0005wy37\u000eC\u0003`\u0011\u0001\u0007\u0001-A\u0003feJ|'\u000f\u0005\u0002bI6\t!M\u0003\u0002d_\u0005A\u0001O]8u_\u000e|G.\u0003\u0002fE\n1QI\u001d:peNDQa\u001a\u0005A\u0002!\f\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\t\u0003y%L!A[\u001f\u0003\u0007%sG\u000fC\u0003m\u0011\u0001\u0007Q.\u0001\ndkJ\u0014XM\u001c;MK\u0006$WM]#q_\u000eD\u0007c\u0001&oa&\u0011qn\u0013\u0002\t\u001fB$\u0018n\u001c8bYB\u00111%]\u0005\u0003e\u0012\u0012q!\u00138uK\u001e,'/\u0001\u000euKN$8)\u001e:sK:$X\t]8dQZ\u000bG.\u001b3bi&|g\u000e\u000b\u0002\n%\u0006Y1/\u001a8e%\u0016\fX/Z:u)\u001d9\u00181DA\u0010\u0003S\u00012\u0001_A\u000b\u001d\rI\u0018q\u0002\b\u0004u\u0006-abA>\u0002\n9\u0019A0a\u0002\u000f\u0007u\f)AD\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u00039\u0012A\u0002\u001fs_>$h(C\u00016\u0013\t\u0019D'\u0003\u0002\u0017e%\u0011\u0001'M\u0005\u0004\u0003\u001by\u0013aB7fgN\fw-Z\u0005\u0005\u0003#\t\u0019\"A\fMSN$xJ\u001a4tKR\u001c(+Z:q_:\u001cX\rR1uC*\u0019\u0011QB\u0018\n\t\u0005]\u0011\u0011\u0004\u0002\u001d\u0019&\u001cHo\u00144gg\u0016$8\u000fU1si&$\u0018n\u001c8SKN\u0004xN\\:f\u0015\u0011\t\t\"a\u0005\t\r\u0005u!\u00021\u0001i\u0003!\u0019XM\u001d<fe&#\u0007bBA\u0011\u0015\u0001\u0007\u00111E\u0001\ni&lWm\u001d;b[B\u00042\u0001PA\u0013\u0013\r\t9#\u0010\u0002\u0005\u0019>tw\rC\u0004\u0002,)\u0001\r!!\f\u0002\u000fY,'o]5p]B\u0019A(a\f\n\u0007\u0005ERHA\u0003TQ>\u0014H/A\ngKR\u001c\u0007n\u00144gg\u0016$\u0018I\u001c3Fa>\u001c\u0007\u000e\u0006\u0005\u00028\u0005u\u0012qHA!!\u0019a\u0014\u0011HA\u0012Q&\u0019\u00111H\u001f\u0003\rQ+\b\u000f\\33\u0011\u0019\tib\u0003a\u0001Q\"9\u0011\u0011E\u0006A\u0002\u0005\r\u0002bBA\u0016\u0017\u0001\u0007\u0011QF\u0001\u001dM\u0016$8\r[(gMN,G/\u00118e\u000bB|7\r[,ji\",%O]8s)!\t9%!\u0014\u0002P\u0005E\u0003\u0003\u0003\u001f\u0002J\u0005\r\u0002.!\f\n\u0007\u0005-SH\u0001\u0004UkBdWm\r\u0005\u0007\u0003;a\u0001\u0019\u00015\t\u000f\u0005\u0005B\u00021\u0001\u0002$!9\u00111\u0006\u0007A\u0002\u00055\u0012a\b;fgR\u0014Vm\u001d9p]N,\u0017J\\2mk\u0012,7\u000fT3bI\u0016\u0014X\t]8dQ\"\u0012QBU\u00016i\u0016\u001cHOU3ta>t7/\u001a#fM\u0006,H\u000e^(gMN,G/\u00118e\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NR8s\u00032dg+\u001a:tS>t7\u000fF\u0002<\u00037Bq!a\u000b\u000f\u0001\u0004\ti\u0003K\u0002\u000f\u0003?\u0002B!!\u0019\u0002h5\u0011\u00111\r\u0006\u0004\u0003K2\u0016A\u00029be\u0006l7/\u0003\u0003\u0002j\u0005\r$!\u0005)be\u0006lW\r^3sSj,G\rV3ti\":a\"!\u001c\u0002~\u0005}\u0004\u0003BA8\u0003sj!!!\u001d\u000b\t\u0005M\u0014QO\u0001\u000bC:tw\u000e^1uS>t'bAA<_\u0005)Q\u000f^5mg&!\u00111PA9\u0005Q\t\u0005/[&fsZ+'o]5p]N\u001cv.\u001e:dK\u00061\u0011\r]5LKf$#!!!\n\t\u0005\r\u0015QQ\u0001\r\u0019&\u001bFkX(G\rN+Ek\u0015\u0006\u0004\u0003\u000f\u0013\u0017aB!qS.+\u0017p]\u0001\u0014CN\u001cXM\u001d;SKN\u0004xN\\:f\u000bJ\u0014xN\u001d\u000b\bw\u00055\u0015qRAI\u0011\u0015yv\u00021\u0001a\u0011\u00159w\u00021\u0001i\u0011\u001d\t\u0019j\u0004a\u0001\u0003+\u000bqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0002\u0018\u0006uUBAAM\u0015\r\tYjL\u0001\te\u0016\fX/Z:ug&!\u0011qTAM\u0005Ia\u0015n\u001d;PM\u001a\u001cX\r^:SKF,Xm\u001d;\u0015\r\u0005\r\u0016\u0011VAW!\u0011\t9*!*\n\t\u0005\u001d\u0016\u0011\u0014\u0002\u0014\u0019&\u001cHo\u00144gg\u0016$8OU3ta>t7/\u001a\u0005\u0007\u0003W\u0003\u0002\u0019\u00015\u0002\u00111,\u0017\rZ3s\u0013\u0012Dq!a%\u0011\u0001\u0004\t)*A\u0006de\u0016\fG/\u001a+pa&\u001cGCBAZ\u0003\u0007\f9\r\u0005\u0004\u00026\u0006u\u0006\u000e\u001b\b\u0005\u0003o\u000bI\f\u0005\u0002\u007f{%\u0019\u00111X\u001f\u0002\rA\u0013X\rZ3g\u0013\u0011\ty,!1\u0003\u00075\u000b\u0007OC\u0002\u0002<vBa!!2\u0012\u0001\u0004A\u0017!\u00048v[B\u000b'\u000f^5uS>t7\u000f\u0003\u0004\u0002JF\u0001\r\u0001[\u0001\u0012e\u0016\u0004H.[2bi&|gNR1di>\u0014\b")
public class ListOffsetsRequestTest
extends BaseRequestTest {
    private final String topic;
    private final TopicPartition partition = new TopicPartition(this.topic(), 0);

    public String topic() {
        return this.topic;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    @Override
    public void modifyConfigs(Seq<Properties> props) {
        super.modifyConfigs(props);
        props.foreach((Function1 & Serializable)p -> p.put("unstable.api.versions.enable", "true"));
    }

    @Test
    public void testListOffsetsErrorCodes() {
        java.util.List targetTimes = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(this.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.partition().partition()).setTimestamp(-2L).setCurrentLeaderEpoch(0), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
        ListOffsetsRequest consumerRequest = (ListOffsetsRequest)ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false, (boolean)false, (boolean)false).setTargetTimes(targetTimes).build();
        ListOffsetsRequest replicaRequest = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)((KafkaBroker)this.brokers().head()).config().brokerId()).setTargetTimes(targetTimes).build();
        ListOffsetsRequest debugReplicaRequest = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)-2).setTargetTimes(targetTimes).build();
        int randomBrokerId = ((KafkaBroker)this.brokers().head()).config().brokerId();
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, consumerRequest);
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, replicaRequest);
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, debugReplicaRequest);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = this.createTopic(1, 2);
        Map topicDescription = (Map)this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2()).describeTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.partition().topic(), (List)Nil$.MODULE$)).asJava()).allTopicNames().get();
        Set replicas = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)((TopicDescription)topicDescription.get(this.partition().topic())).partitions().get(this.partition().partition())).replicas()).asScala().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()))).toSet();
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)this.partition().partition())));
        int follower = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)(JFunction1.mcZI.sp & Serializable)x$2 -> x$2 != leader).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.brokers().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)ListOffsetsRequestTest.$anonfun$testListOffsetsErrorCodes$3(x$3)))).find((Function1)(JFunction1.mcZI.sp & Serializable)x$4 -> !replicas.contains((Object)BoxesRunTime.boxToInteger((int)x$4))).get());
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, follower, consumerRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, follower, replicaRequest);
        this.assertResponseError(Errors.NONE, follower, debugReplicaRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, consumerRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, replicaRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, debugReplicaRequest);
    }

    public void assertResponseErrorForEpoch(Errors error, int brokerId, Optional<Integer> currentLeaderEpoch) {
        ListOffsetsRequestData.ListOffsetsPartition listOffsetPartition = new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.partition().partition()).setTimestamp(-2L);
        if (currentLeaderEpoch.isPresent()) {
            listOffsetPartition.setCurrentLeaderEpoch(Predef$.MODULE$.Integer2int(currentLeaderEpoch.get()));
        }
        java.util.List targetTimes = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(this.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)listOffsetPartition, (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false, (boolean)false, (boolean)false).setTargetTimes(targetTimes).build();
        this.assertResponseError(error, brokerId, request);
    }

    @Test
    public void testCurrentEpochValidation() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(1, 3).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.brokers(), topicPartition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)firstLeaderId)), (Option<Object>)None$.MODULE$, 15000L);
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaBroker>)this.brokers());
        this.assertResponseErrorForEpoch(Errors.NONE, secondLeaderId, Optional.empty());
        this.assertResponseErrorForEpoch(Errors.NONE, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)));
        this.assertResponseErrorForEpoch(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)));
        this.assertResponseErrorForEpoch(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)));
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaBroker>)this.brokers());
        this.assertResponseErrorForEpoch(Errors.NOT_LEADER_OR_FOLLOWER, followerId, Optional.empty());
        this.assertResponseErrorForEpoch(Errors.NOT_LEADER_OR_FOLLOWER, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)));
        this.assertResponseErrorForEpoch(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)));
        this.assertResponseErrorForEpoch(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)));
    }

    private ListOffsetsResponseData.ListOffsetsPartitionResponse sendRequest(int serverId, long timestamp, short version) {
        java.util.List targetTimes = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(this.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.partition().partition()).setTimestamp(timestamp), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
        ListOffsetsRequest.Builder builder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false, (boolean)false, (boolean)false).setTargetTimes(targetTimes);
        ListOffsetsRequest request = version == -1 ? (ListOffsetsRequest)builder.build() : builder.build(version);
        return (ListOffsetsResponseData.ListOffsetsPartitionResponse)CollectionConverters$.MODULE$.ListHasAsScala(((ListOffsetsResponseData.ListOffsetsTopicResponse)CollectionConverters$.MODULE$.ListHasAsScala(this.sendRequest(serverId, request).topics()).asScala().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$sendRequest$1(this, x$5))).get()).partitions()).asScala().find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$sendRequest$2(this, x$6))).get();
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<Object, Object> fetchOffsetAndEpoch(int serverId, long timestamp, short version) {
        void var8_6;
        void var6_5;
        Tuple3<Object, Object, Object> tuple3 = this.fetchOffsetAndEpochWithError(serverId, timestamp, version);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        long offset = BoxesRunTime.unboxToLong((Object)tuple3._1());
        int leaderEpoch = BoxesRunTime.unboxToInt((Object)tuple3._2());
        return new Tuple2.mcJI.sp((long)var6_5, (int)var8_6);
    }

    private Tuple3<Object, Object, Object> fetchOffsetAndEpochWithError(int serverId, long timestamp, short version) {
        ListOffsetsResponseData.ListOffsetsPartitionResponse partitionData = this.sendRequest(serverId, timestamp, version);
        return new Tuple3((Object)BoxesRunTime.boxToLong((long)partitionData.offset()), (Object)BoxesRunTime.boxToInteger((int)partitionData.leaderEpoch()), (Object)BoxesRunTime.boxToShort((short)partitionData.errorCode()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResponseIncludesLeaderEpoch() {
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(1, 3).apply((Object)BoxesRunTime.boxToInteger((int)this.partition().partition())));
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 9, -1);
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "test-10", Predef$.MODULE$.long2Long(System.currentTimeMillis() + 10L), 30000, 20000);
        int firstLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(firstLeaderId, this.partition(), (Iterable<KafkaBroker>)this.brokers());
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(firstLeaderId, -4L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, firstLeaderEpoch), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(9L, firstLeaderEpoch), this.fetchOffsetAndEpoch(firstLeaderId, -3L, (short)-1));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.brokers(), this.partition(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)firstLeaderId)), (Option<Object>)None$.MODULE$, 15000L);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ListOffsetsRequestTest.$anonfun$testResponseIncludesLeaderEpoch$1(this, secondLeaderId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"the second leader does not sync to follower");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, this.partition(), (Iterable<KafkaBroker>)this.brokers());
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, -4L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, -2L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, -2L, (short)-1));
        Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)10L), (Object)BoxesRunTime.boxToInteger((int)secondLeaderEpoch), (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code())), this.fetchOffsetAndEpochWithError(secondLeaderId, -1L, (short)-1));
        Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)9L), (Object)BoxesRunTime.boxToInteger((int)firstLeaderEpoch), (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code())), this.fetchOffsetAndEpochWithError(secondLeaderId, -3L, (short)-1));
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.LIST_OFFSETS)
    public void testResponseDefaultOffsetAndLeaderEpochForAllVersions(short version) {
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(1, 3).apply((Object)BoxesRunTime.boxToInteger((int)this.partition().partition())));
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 9, -1);
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "test-10", Predef$.MODULE$.long2Long(System.currentTimeMillis() + 10L), 30000, 20000);
        if (version >= 1 && version <= 3) {
            Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, 0L, version));
            Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -2L, version));
            Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -1L, version));
            Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToShort((short)Errors.UNSUPPORTED_VERSION.code())), this.fetchOffsetAndEpochWithError(firstLeaderId, -3L, version));
            Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToShort((short)Errors.UNSUPPORTED_VERSION.code())), this.fetchOffsetAndEpochWithError(firstLeaderId, -4L, version));
            return;
        }
        if (version >= 4 && version <= 6) {
            Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, 0L, version));
            Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -2L, version));
            Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -1L, version));
            Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToShort((short)Errors.UNSUPPORTED_VERSION.code())), this.fetchOffsetAndEpochWithError(firstLeaderId, -3L, version));
            Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToShort((short)Errors.UNSUPPORTED_VERSION.code())), this.fetchOffsetAndEpochWithError(firstLeaderId, -4L, version));
            return;
        }
        if (version == 7) {
            Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, 0L, version));
            Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -2L, version));
            Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -1L, version));
            Assertions.assertEquals((Object)new Tuple2.mcJI.sp(9L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -3L, version));
            Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToShort((short)Errors.UNSUPPORTED_VERSION.code())), this.fetchOffsetAndEpochWithError(firstLeaderId, -4L, version));
            return;
        }
        if (version >= 8) {
            Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, 0L, version));
            Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -2L, version));
            Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -1L, version));
            Assertions.assertEquals((Object)new Tuple2.mcJI.sp(9L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -3L, version));
            Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -4L, version));
            return;
        }
    }

    private void assertResponseError(Errors error, int brokerId, ListOffsetsRequest request) {
        ListOffsetsResponse response = this.sendRequest(brokerId, request);
        Assertions.assertEquals((int)request.topics().size(), (int)response.topics().size());
        CollectionConverters$.MODULE$.ListHasAsScala(response.topics()).asScala().foreach((Function1 & Serializable)topic -> {
            ListOffsetsRequestTest.$anonfun$assertResponseError$1(error, topic);
            return BoxedUnit.UNIT;
        });
    }

    private ListOffsetsResponse sendRequest(int leaderId, ListOffsetsRequest request) {
        return (ListOffsetsResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListOffsetsResponse.class));
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(int numPartitions, int replicationFactor) {
        return super.createTopic(this.topic(), numPartitions, replicationFactor, super.createTopic$default$4(), super.createTopic$default$5(), super.createTopic$default$6());
    }

    public static final /* synthetic */ int $anonfun$testListOffsetsErrorCodes$3(KafkaBroker x$3) {
        return x$3.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$sendRequest$1(ListOffsetsRequestTest $this, ListOffsetsResponseData.ListOffsetsTopicResponse x$5) {
        String string = x$5.name();
        String string2 = $this.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$sendRequest$2(ListOffsetsRequestTest $this, ListOffsetsResponseData.ListOffsetsPartitionResponse x$6) {
        return x$6.partitionIndex() == $this.partition().partition();
    }

    public static final /* synthetic */ boolean $anonfun$testResponseIncludesLeaderEpoch$1(ListOffsetsRequestTest $this, int secondLeaderId$1) {
        return $this.sendRequest(secondLeaderId$1, -1L, (short)-1).errorCode() != Errors.OFFSET_NOT_AVAILABLE.code();
    }

    public static final /* synthetic */ String $anonfun$testResponseIncludesLeaderEpoch$2() {
        return "the second leader does not sync to follower";
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$2(Errors error$1, ListOffsetsResponseData.ListOffsetsPartitionResponse partition) {
        Assertions.assertEquals((short)error$1.code(), (short)partition.errorCode());
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$1(Errors error$1, ListOffsetsResponseData.ListOffsetsTopicResponse topic) {
        CollectionConverters$.MODULE$.ListHasAsScala(topic.partitions()).asScala().foreach((Function1 & Serializable)partition -> {
            ListOffsetsRequestTest.$anonfun$assertResponseError$2(error$1, partition);
            return BoxedUnit.UNIT;
        });
    }

    public ListOffsetsRequestTest() {
        this.topic = "topic";
    }
}

