/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import kafka.server.AbstractFetcherThread;
import kafka.server.FailedPartitions;
import kafka.server.InitialFetchState;
import kafka.server.MockLeaderEndPoint;
import kafka.server.MockTierStateMachine;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionState;
import kafka.server.TierStateMachine;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordValidationStats;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.LeaderEndPoint;
import org.apache.kafka.server.ReplicaState;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.log.metrics.BrokerTopicStats;
import org.junit.jupiter.api.Assertions;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tUa\u0001\u0002\u0013&\u0001)B\u0001b\f\u0001\u0003\u0006\u0004%\t\u0001\r\u0005\ti\u0001\u0011\t\u0011)A\u0005c!AQ\u0007\u0001BC\u0002\u0013\u0005a\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u00038\u0011!Y\u0004A!b\u0001\n\u0003a\u0004\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u0011\u0011\u0003!Q1A\u0005\u0002qB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\r\u0002\u0011\t\u0011)A\u0005{!Aq\t\u0001B\u0001B\u0003%\u0001\nC\u0003L\u0001\u0011\u0005A\nC\u0004U\u0001\t\u0007I\u0011B+\t\r1\u0004\u0001\u0015!\u0003W\u0011\u001di\u0007\u00011A\u0005\n9Dq! \u0001A\u0002\u0013%a\u0010C\u0004\u0002\n\u0001\u0001\u000b\u0015B8\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e!9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0001bBA\u000f\u0001\u0011\u0005\u0011q\u0004\u0005\b\u0003\u0003\u0002A\u0011IA\"\u0011\u001d\tY\b\u0001C\u0005\u0003{Bq!a%\u0001\t\u0003\n)\nC\u0004\u0002$\u0002!\t%!*\t\u000f\u00055\u0006\u0001\"\u0011\u00020\"9\u00111\u0017\u0001\u0005B\u0005U\u0006bBA]\u0001\u0011\u0005\u00131\u0018\u0005\b\u0003\u007f\u0003A\u0011IAa\u0011\u001d\t9\u000e\u0001C\u0001\u00033<\u0011\"!:&\u0003\u0003E\t!a:\u0007\u0011\u0011*\u0013\u0011!E\u0001\u0003SDaa\u0013\u0010\u0005\u0002\u0005E\b\"CAz=E\u0005I\u0011AA{\u0011%\u0011YAHI\u0001\n\u0003\t)\u0010C\u0005\u0003\u000ey\t\n\u0011\"\u0001\u0002v\"I!q\u0002\u0010\u0012\u0002\u0013\u0005!\u0011\u0003\u0002\u0012\u001b>\u001c7NR3uG\",'\u000f\u00165sK\u0006$'B\u0001\u0014(\u0003\u0019\u0019XM\u001d<fe*\t\u0001&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Y\u0003C\u0001\u0017.\u001b\u0005)\u0013B\u0001\u0018&\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\f!\"\\8dW2+\u0017\rZ3s+\u0005\t\u0004C\u0001\u00173\u0013\t\u0019TE\u0001\nN_\u000e\\G*Z1eKJ,e\u000e\u001a)pS:$\u0018aC7pG.dU-\u00193fe\u0002\nA#\\8dWRKWM]*uCR,W*Y2iS:,W#A\u001c\u0011\u00051B\u0014BA\u001d&\u0005QiunY6US\u0016\u00148\u000b^1uK6\u000b7\r[5oK\u0006)Rn\\2l)&,'o\u0015;bi\u0016l\u0015m\u00195j]\u0016\u0004\u0013!\u0003:fa2L7-Y%e+\u0005i\u0004C\u0001 B\u001b\u0005y$\"\u0001!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t{$aA%oi\u0006Q!/\u001a9mS\u000e\f\u0017\n\u001a\u0011\u0002\u00111,\u0017\rZ3s\u0013\u0012\f\u0011\u0002\\3bI\u0016\u0014\u0018\n\u001a\u0011\u0002\u001d\u0019,Go\u00195CC\u000e\\wJ\u001a4Ng\u0006\u0001b-Y5mK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\t\u0003Y%K!AS\u0013\u0003!\u0019\u000b\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001c\u0018A\u0002\u001fj]&$h\bF\u0004N\u001d>\u0003\u0016KU*\u0011\u00051\u0002\u0001\"B\u0018\f\u0001\u0004\t\u0004\"B\u001b\f\u0001\u00049\u0004bB\u001e\f!\u0003\u0005\r!\u0010\u0005\b\t.\u0001\n\u00111\u0001>\u0011\u001d15\u0002%AA\u0002uBqaR\u0006\u0011\u0002\u0003\u0007\u0001*\u0001\fsKBd\u0017nY1QCJ$\u0018\u000e^5p]N#\u0018\r^3t+\u00051\u0006\u0003B,]=&l\u0011\u0001\u0017\u0006\u00033j\u000bq!\\;uC\ndWM\u0003\u0002\\\u007f\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005uC&aA'baB\u0011qlZ\u0007\u0002A*\u0011\u0011MY\u0001\u0007G>lWn\u001c8\u000b\u0005!\u001a'B\u00013f\u0003\u0019\t\u0007/Y2iK*\ta-A\u0002pe\u001eL!\u0001\u001b1\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0011AF[\u0005\u0003W\u0016\u0012a\u0002U1si&$\u0018n\u001c8Ti\u0006$X-A\fsKBd\u0017nY1QCJ$\u0018\u000e^5p]N#\u0018\r^3tA\u0005\u0011B.\u0019;fgR,\u0005o\\2i\t\u00164\u0017-\u001e7u+\u0005y\u0007c\u00019vo6\t\u0011O\u0003\u0002sg\u0006!Q\u000f^5m\u0015\u0005!\u0018\u0001\u00026bm\u0006L!A^9\u0003\u0011=\u0003H/[8oC2\u0004\"\u0001_>\u000e\u0003eT!A_:\u0002\t1\fgnZ\u0005\u0003yf\u0014q!\u00138uK\u001e,'/\u0001\fmCR,7\u000f^#q_\u000eDG)\u001a4bk2$x\fJ3r)\ry\u0018Q\u0001\t\u0004}\u0005\u0005\u0011bAA\u0002\u007f\t!QK\\5u\u0011!\t9aDA\u0001\u0002\u0004y\u0017a\u0001=%c\u0005\u0019B.\u0019;fgR,\u0005o\\2i\t\u00164\u0017-\u001e7uA\u0005y1/\u001a;SKBd\u0017nY1Ti\u0006$X\rF\u0003\u0000\u0003\u001f\t\u0019\u0002\u0003\u0004\u0002\u0012E\u0001\rAX\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\t)\"\u0005a\u0001S\u0006)1\u000f^1uK\u0006)\"/\u001a9mS\u000e\f\u0007+\u0019:uSRLwN\\*uCR,GcA5\u0002\u001c!1\u0011\u0011\u0003\nA\u0002y\u000bQ\"\u00193e!\u0006\u0014H/\u001b;j_:\u001cHCBA\u0011\u0003S\t9\u0004E\u0003\u0002$\u0005\u0015b,D\u0001[\u0013\r\t9C\u0017\u0002\u0004'\u0016$\bbBA\u0016'\u0001\u0007\u0011QF\u0001\u0013S:LG/[1m\r\u0016$8\r[*uCR,7\u000fE\u0004\u0002$\u0005=b,!\r\n\u0005uS\u0006c\u0001\u0017\u00024%\u0019\u0011QG\u0013\u0003#%s\u0017\u000e^5bY\u001a+Go\u00195Ti\u0006$X\rC\u0004\u0002:M\u0001\r!a\u000f\u0002\u001f\u0019|'oY3UeVt7-\u0019;j_:\u00042APA\u001f\u0013\r\tyd\u0010\u0002\b\u0005>|G.Z1o\u0003Q\u0001(o\\2fgN\u0004\u0016M\u001d;ji&|g\u000eR1uCRQ\u0011QIA0\u0003C\nY'a\u001c\u0011\u000by\n9%a\u0013\n\u0007\u0005%sH\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u001b\nY&\u0004\u0002\u0002P)!\u0011\u0011KA*\u0003\rawn\u001a\u0006\u0005\u0003+\n9&A\u0005j]R,'O\\1mg*\u0019\u0011\u0011\f2\u0002\u000fM$xN]1hK&!\u0011QLA(\u00055aunZ!qa\u0016tG-\u00138g_\"1\u0011\u0011\u0003\u000bA\u0002yCq!a\u0019\u0015\u0001\u0004\t)'A\u0006gKR\u001c\u0007n\u00144gg\u0016$\bc\u0001 \u0002h%\u0019\u0011\u0011N \u0003\t1{gn\u001a\u0005\u0007\u0003[\"\u0002\u0019A\u001f\u0002+1,\u0017\rZ3s\u000bB|7\r\u001b$peJ+\u0007\u000f\\5dC\"9\u0011\u0011\u000f\u000bA\u0002\u0005M\u0014!\u00049beRLG/[8o\t\u0006$\u0018\r\u0005\u0003\u0002v\u0005]T\"\u0001\u0001\n\u0007\u0005eTFA\u0005GKR\u001c\u0007\u000eR1uC\u0006i\u0002.Y:IS\u001eDWM\u001d)beRLG/[8o\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000e\u0006\u0004\u0002<\u0005}\u0014q\u0012\u0005\b\u0003\u0003+\u0002\u0019AAB\u0003\u0015\u0011\u0017\r^2i!\u0011\t))a#\u000e\u0005\u0005\u001d%bAAEA\u00061!/Z2pe\u0012LA!!$\u0002\b\nY!+Z2pe\u0012\u0014\u0015\r^2i\u0011\u0019\t\t*\u0006a\u0001{\u0005YA.Z1eKJ,\u0005o\\2i\u0003!!(/\u001e8dCR,G#B@\u0002\u0018\u0006e\u0005BBA\t-\u0001\u0007a\fC\u0004\u0002\u001cZ\u0001\r!!(\u0002\u001fQ\u0014XO\\2bi&|gn\u0015;bi\u0016\u00042\u0001LAP\u0013\r\t\t+\n\u0002\u0016\u001f\u001a47/\u001a;UeVt7-\u0019;j_:\u001cF/\u0019;f\u0003]!(/\u001e8dCR,g)\u001e7ms\u0006sGm\u0015;beR\fE\u000fF\u0003\u0000\u0003O\u000bI\u000b\u0003\u0004\u0002\u0012]\u0001\rA\u0018\u0005\b\u0003W;\u0002\u0019AA3\u0003\u0019ygMZ:fi\u0006YA.\u0019;fgR,\u0005o\\2i)\ry\u0017\u0011\u0017\u0005\u0007\u0003#A\u0002\u0019\u00010\u0002\u001d1|wm\u0015;beR|eMZ:fiR!\u0011QMA\\\u0011\u0019\t\t\"\u0007a\u0001=\u0006aAn\\4F]\u0012|eMZ:fiR!\u0011QMA_\u0011\u0019\t\tB\u0007a\u0001=\u0006\tRM\u001c3PM\u001a\u001cX\r\u001e$pe\u0016\u0003xn\u00195\u0015\r\u0005\r\u0017\u0011[Aj!\u0011\u0001X/!2\u0011\t\u0005\u001d\u0017QZ\u0007\u0003\u0003\u0013T1!YAf\u0015\t1#-\u0003\u0003\u0002P\u0006%'AD(gMN,G/\u00118e\u000bB|7\r\u001b\u0005\u0007\u0003#Y\u0002\u0019\u00010\t\r\u0005U7\u00041\u0001>\u0003\u0015)\u0007o\\2i\u0003Y1XM]5gs2\u000b7\u000f\u001e$fi\u000eDW\rZ#q_\u000eDG#B@\u0002\\\u0006}\u0007BBAo9\u0001\u0007a,A\u0005qCJ$\u0018\u000e^5p]\"9\u0011\u0011\u001d\u000fA\u0002\u0005\r\u0018!D3ya\u0016\u001cG/\u001a3Fa>\u001c\u0007\u000e\u0005\u0003?\u0003\u000fj\u0014!E'pG.4U\r^2iKJ$\u0006N]3bIB\u0011AFH\n\u0004=\u0005-\bc\u0001 \u0002n&\u0019\u0011q^ \u0003\r\u0005s\u0017PU3g)\t\t9/A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\u0003oT3!PA}W\t\tY\u0010\u0005\u0003\u0002~\n\u001dQBAA\u0000\u0015\u0011\u0011\tAa\u0001\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0003\u007f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t%\u0011q \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\tM!f\u0001%\u0002z\u0002")
public class MockFetcherThread
extends AbstractFetcherThread {
    private final MockLeaderEndPoint mockLeader;
    private final MockTierStateMachine mockTierStateMachine;
    private final int replicaId;
    private final int leaderId;
    private final scala.collection.mutable.Map<TopicPartition, PartitionState> replicaPartitionStates;
    private Optional<Integer> latestEpochDefault;

    public static FailedPartitions $lessinit$greater$default$6() {
        return new FailedPartitions();
    }

    public static int $lessinit$greater$default$5() {
        return 0;
    }

    public static int $lessinit$greater$default$4() {
        return 1;
    }

    public static int $lessinit$greater$default$3() {
        return 0;
    }

    public MockLeaderEndPoint mockLeader() {
        return this.mockLeader;
    }

    public MockTierStateMachine mockTierStateMachine() {
        return this.mockTierStateMachine;
    }

    public int replicaId() {
        return this.replicaId;
    }

    public int leaderId() {
        return this.leaderId;
    }

    private scala.collection.mutable.Map<TopicPartition, PartitionState> replicaPartitionStates() {
        return this.replicaPartitionStates;
    }

    private Optional<Integer> latestEpochDefault() {
        return this.latestEpochDefault;
    }

    private void latestEpochDefault_$eq(Optional<Integer> x$1) {
        this.latestEpochDefault = x$1;
    }

    public void setReplicaState(TopicPartition topicPartition, PartitionState state) {
        this.replicaPartitionStates().put((Object)topicPartition, (Object)state);
    }

    public PartitionState replicaPartitionState(TopicPartition topicPartition) {
        return (PartitionState)this.replicaPartitionStates().getOrElse((Object)topicPartition, (Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Unknown partition " + topicPartition);
        });
    }

    public Set<TopicPartition> addPartitions(Map<TopicPartition, InitialFetchState> initialFetchStates, boolean forceTruncation) {
        this.latestEpochDefault_$eq(forceTruncation ? Optional.empty() : Optional.of(Predef$.MODULE$.int2Integer(0)));
        Set partitions = super.addPartitions(initialFetchStates);
        this.latestEpochDefault_$eq(Optional.of(Predef$.MODULE$.int2Integer(0)));
        return partitions;
    }

    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, int leaderEpochForReplica, FetchResponseData.PartitionData partitionData) {
        PartitionState state = this.replicaPartitionState(topicPartition);
        if (this.leader().isTruncationOnFetchSupported() && FetchResponse.isDivergingEpoch((FetchResponseData.PartitionData)partitionData)) {
            throw new IllegalStateException("processPartitionData should not be called for a partition with a diverging epoch.");
        }
        if (fetchOffset != state.logEndOffset()) {
            throw new RuntimeException("Offset mismatch for partition " + topicPartition + ": fetched offset = " + fetchOffset + ", log end offset = " + state.logEndOffset() + ".");
        }
        Iterable batches = CollectionConverters$.MODULE$.IterableHasAsScala(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData).batches()).asScala();
        LongRef maxTimestamp = LongRef.create((long)-1L);
        LongRef shallowOffsetOfMaxTimestamp = LongRef.create((long)-1L);
        LongRef lastOffset = LongRef.create((long)state.logEndOffset());
        ObjectRef lastEpoch = ObjectRef.create(Optional.empty());
        BooleanRef skipRemainingBatches = BooleanRef.create((boolean)false);
        batches.foreach((Function1 & Serializable)batch -> {
            MockFetcherThread.$anonfun$processPartitionData$1(this, skipRemainingBatches, leaderEpochForReplica, maxTimestamp, shallowOffsetOfMaxTimestamp, state, lastOffset, lastEpoch, batch);
            return BoxedUnit.UNIT;
        });
        state.logStartOffset_$eq(partitionData.logStartOffset());
        state.highWatermark_$eq(partitionData.highWatermark());
        return new Some((Object)new LogAppendInfo(fetchOffset, lastOffset.elem, (Optional)lastEpoch.elem, maxTimestamp.elem, Time.SYSTEM.milliseconds(), state.logStartOffset(), RecordValidationStats.EMPTY, CompressionType.NONE, FetchResponse.recordsSize((FetchResponseData.PartitionData)partitionData), BoxesRunTime.unboxToLong((Object)batches.headOption().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.lastOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L))));
    }

    private boolean hasHigherPartitionLeaderEpoch(RecordBatch batch, int leaderEpoch) {
        return batch.partitionLeaderEpoch() != -1 && batch.partitionLeaderEpoch() > leaderEpoch;
    }

    public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        PartitionState state = this.replicaPartitionState(topicPartition);
        state.log_$eq((Buffer<RecordBatch>)((Buffer)state.log().takeWhile((Function1 & Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)MockFetcherThread.$anonfun$truncate$1(truncationState, batch)))));
        state.logEndOffset_$eq(BoxesRunTime.unboxToLong((Object)state.log().lastOption().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)MockFetcherThread.$anonfun$truncate$2(x$2))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> state.logStartOffset())));
        state.highWatermark_$eq(package$.MODULE$.min(state.highWatermark(), state.logEndOffset()));
    }

    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        PartitionState state = this.replicaPartitionState(topicPartition);
        state.log().clear();
        if (state.rlmEnabled()) {
            state.localLogStartOffset_$eq(offset);
        } else {
            state.logStartOffset_$eq(offset);
        }
        state.logEndOffset_$eq(offset);
        state.highWatermark_$eq(offset);
    }

    public Optional<Integer> latestEpoch(TopicPartition topicPartition) {
        PartitionState state = this.replicaPartitionState(topicPartition);
        Optional<Integer> partitionLeaderEpoch = OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(state.log().lastOption())).map(x$3 -> Predef$.MODULE$.int2Integer(x$3.partitionLeaderEpoch()));
        if (partitionLeaderEpoch.isPresent()) {
            return partitionLeaderEpoch;
        }
        return this.latestEpochDefault();
    }

    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaPartitionState(topicPartition).logStartOffset();
    }

    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaPartitionState(topicPartition).logEndOffset();
    }

    public Optional<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        OffsetForLeaderEpochRequestData.OffsetForLeaderPartition epochData = new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(topicPartition.partition()).setLeaderEpoch(epoch);
        OffsetForLeaderEpochResponseData.EpochEndOffset result = this.mockLeader().lookupEndOffsetForEpoch(topicPartition, epochData, this.replicaPartitionState(topicPartition));
        if (result.endOffset() == -1L) {
            return Optional.empty();
        }
        return Optional.of(new OffsetAndEpoch(result.endOffset(), result.leaderEpoch()));
    }

    public void verifyLastFetchedEpoch(TopicPartition partition, Option<Object> expectedEpoch) {
        if (this.leader().isTruncationOnFetchSupported()) {
            Assertions.assertEquals((Object)new Some((Object)ReplicaState.FETCHING), (Object)this.fetchState(partition).map((Function1 & Serializable)x$4 -> x$4.state()));
            Assertions.assertEquals(expectedEpoch, (Object)this.fetchState(partition).map((Function1 & Serializable)x$5 -> (Integer)x$5.lastFetchedEpoch().get()));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$processPartitionData$1(MockFetcherThread $this, BooleanRef skipRemainingBatches$1, int leaderEpochForReplica$1, LongRef maxTimestamp$1, LongRef shallowOffsetOfMaxTimestamp$1, PartitionState state$1, LongRef lastOffset$1, ObjectRef lastEpoch$1, RecordBatch batch) {
        batch.ensureValid();
        boolean bl = skipRemainingBatches$1.elem = skipRemainingBatches$1.elem || $this.hasHigherPartitionLeaderEpoch(batch, leaderEpochForReplica$1);
        if (skipRemainingBatches$1.elem) {
            $this.info((Function0 & Serializable)() -> "Skipping batch " + batch + " because leader epoch is " + leaderEpochForReplica$1);
            return;
        }
        if (batch.maxTimestamp() > maxTimestamp$1.elem) {
            maxTimestamp$1.elem = batch.maxTimestamp();
            shallowOffsetOfMaxTimestamp$1.elem = batch.baseOffset();
        }
        state$1.log().append((Object)batch);
        state$1.logEndOffset_$eq(batch.nextOffset());
        lastOffset$1.elem = batch.lastOffset();
        lastEpoch$1.elem = Optional.of(Predef$.MODULE$.int2Integer(batch.partitionLeaderEpoch()));
    }

    public static final /* synthetic */ boolean $anonfun$truncate$1(OffsetTruncationState truncationState$1, RecordBatch batch) {
        return batch.lastOffset() < truncationState$1.offset();
    }

    public static final /* synthetic */ long $anonfun$truncate$2(RecordBatch x$2) {
        return x$2.lastOffset() + 1L;
    }

    public MockFetcherThread(MockLeaderEndPoint mockLeader, MockTierStateMachine mockTierStateMachine, int replicaId, int leaderId, int fetchBackOffMs, FailedPartitions failedPartitions) {
        this.mockLeader = mockLeader;
        this.mockTierStateMachine = mockTierStateMachine;
        this.replicaId = replicaId;
        this.leaderId = leaderId;
        BrokerTopicStats x$7 = new BrokerTopicStats();
        boolean x$8 = true;
        super("mock-fetcher", "mock-fetcher", (LeaderEndPoint)mockLeader, failedPartitions, (TierStateMachine)mockTierStateMachine, fetchBackOffMs, x$8, x$7);
        this.replicaPartitionStates = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.latestEpochDefault = Optional.of(Predef$.MODULE$.int2Integer(0));
        mockTierStateMachine.setFetcher(this);
    }
}

