/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Optional;
import kafka.server.MockFetcherThread;
import kafka.server.TierStateMachine;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.server.LeaderEndPoint;
import org.apache.kafka.server.PartitionFetchState;
import org.apache.kafka.server.ReplicaState;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005E3A\u0001C\u0005\u0001\u001d!A1\u0003\u0001B\u0001B\u0003%A\u0003C\u0003\u001f\u0001\u0011\u0005q\u0004C\u0005#\u0001\u0001\u0007\t\u0019!C\u0001G!Iq\u0005\u0001a\u0001\u0002\u0004%\t\u0001\u000b\u0005\nc\u0001\u0001\r\u0011!Q!\n\u0011BQA\r\u0001\u0005BMBQ!\u0014\u0001\u0005\u00029\u0013A#T8dWRKWM]*uCR,W*Y2iS:,'B\u0001\u0006\f\u0003\u0019\u0019XM\u001d<fe*\tA\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001y\u0001C\u0001\t\u0012\u001b\u0005I\u0011B\u0001\n\n\u0005A!\u0016.\u001a:Ti\u0006$X-T1dQ&tW-\u0001\u0004mK\u0006$WM\u001d\t\u0003+qi\u0011A\u0006\u0006\u0003\u0015]Q!\u0001\u0004\r\u000b\u0005eQ\u0012AB1qC\u000eDWMC\u0001\u001c\u0003\ry'oZ\u0005\u0003;Y\u0011a\u0002T3bI\u0016\u0014XI\u001c3Q_&tG/\u0001\u0004=S:LGO\u0010\u000b\u0003A\u0005\u0002\"\u0001\u0005\u0001\t\u000bM\u0011\u0001\u0019\u0001\u000b\u0002\u000f\u0019,Go\u00195feV\tA\u0005\u0005\u0002\u0011K%\u0011a%\u0003\u0002\u0012\u001b>\u001c7NR3uG\",'\u000f\u00165sK\u0006$\u0017a\u00034fi\u000eDWM]0%KF$\"!K\u0018\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\tUs\u0017\u000e\u001e\u0005\ba\u0011\t\t\u00111\u0001%\u0003\rAH%M\u0001\tM\u0016$8\r[3sA\u0005)1\u000f^1siR!AgN B!\t)R'\u0003\u00027-\t\u0019\u0002+\u0019:uSRLwN\u001c$fi\u000eD7\u000b^1uK\")\u0001H\u0002a\u0001s\u0005qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007C\u0001\u001e>\u001b\u0005Y$B\u0001\u001f\u0018\u0003\u0019\u0019w.\\7p]&\u0011ah\u000f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0015\u0001e\u00011\u00015\u0003E\u0019WO\u001d:f]R4U\r^2i'R\fG/\u001a\u0005\u0006\u0005\u001a\u0001\raQ\u0001\u0013M\u0016$8\r\u001b)beRLG/[8o\t\u0006$\u0018\r\u0005\u0002E\u0015:\u0011Q\tS\u0007\u0002\r*\u0011qiO\u0001\b[\u0016\u001c8/Y4f\u0013\tIe)A\tGKR\u001c\u0007NU3ta>t7/\u001a#bi\u0006L!a\u0013'\u0003\u001bA\u000b'\u000f^5uS>tG)\u0019;b\u0015\tIe)\u0001\u0006tKR4U\r^2iKJ$\"!K(\t\u000bA;\u0001\u0019\u0001\u0013\u0002#5|7m\u001b$fi\u000eDWM\u001d+ie\u0016\fG\r")
public class MockTierStateMachine
extends TierStateMachine {
    private final LeaderEndPoint leader;
    private MockFetcherThread fetcher;

    public MockFetcherThread fetcher() {
        return this.fetcher;
    }

    public void fetcher_$eq(MockFetcherThread x$1) {
        this.fetcher = x$1;
    }

    public PartitionFetchState start(TopicPartition topicPartition, PartitionFetchState currentFetchState, FetchResponseData.PartitionData fetchPartitionData) {
        long leaderEndOffset = this.leader.fetchLatestOffset(topicPartition, currentFetchState.currentLeaderEpoch()).offset();
        long offsetToFetch = this.leader.fetchEarliestLocalOffset(topicPartition, currentFetchState.currentLeaderEpoch()).offset();
        long initialLag = leaderEndOffset - offsetToFetch;
        this.fetcher().truncateFullyAndStartAt(topicPartition, offsetToFetch);
        return new PartitionFetchState(currentFetchState.topicId(), offsetToFetch, Optional.of(Predef$.MODULE$.long2Long(initialLag)), currentFetchState.currentLeaderEpoch(), Optional.empty(), ReplicaState.FETCHING, Optional.of(Predef$.MODULE$.int2Integer(currentFetchState.currentLeaderEpoch())));
    }

    public void setFetcher(MockFetcherThread mockFetcherThread) {
        this.fetcher_$eq(mockFetcherThread);
    }

    public MockTierStateMachine(LeaderEndPoint leader) {
        this.leader = leader;
        super(leader, null, false);
    }
}

