/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kafka.api.SaslSetup;
import kafka.security.JaasTestUtils;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MultipleListenersWithSameSecurityProtocolBaseTest$;
import kafka.server.MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$;
import kafka.server.QuorumTestHarness;
import kafka.utils.Implicits;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\rur!B!C\u0011\u00039e!B%C\u0011\u0003Q\u0005\"B)\u0002\t\u0003\u0011\u0006bB*\u0002\u0005\u0004%\t\u0001\u0016\u0005\u0007;\u0006\u0001\u000b\u0011B+\t\u000fy\u000b!\u0019!C\u0001)\"1q,\u0001Q\u0001\nUCq\u0001Y\u0001C\u0002\u0013\u0005A\u000b\u0003\u0004b\u0003\u0001\u0006I!\u0016\u0005\bE\u0006\u0011\r\u0011\"\u0001U\u0011\u0019\u0019\u0017\u0001)A\u0005+\"9A-\u0001b\u0001\n\u0003!\u0006BB3\u0002A\u0003%Q\u000bC\u0004g\u0003\t\u0007I\u0011\u0001+\t\r\u001d\f\u0001\u0015!\u0003V\r\u0015I%)!\u0001i\u0011\u0015\tv\u0002\"\u0001s\u0011\u001d!xB1A\u0005\nUDa\u0001`\b!\u0002\u00131\bbB?\u0010\u0005\u0004%IA \u0005\b\u0003+y\u0001\u0015!\u0003\u0000\u0011%\t9b\u0004a\u0001\n\u0013\tI\u0002C\u0005\u00024=\u0001\r\u0011\"\u0003\u00026!A\u0011\u0011I\b!B\u0013\tY\u0002C\u0005\u0002D=\u0011\r\u0011\"\u0003\u0002F!A!\u0011G\b!\u0002\u0013\t9\u0005C\u0005\u00034=\u0011\r\u0011\"\u0003\u00036!A!QI\b!\u0002\u0013\u00119\u0004\u0003\u0005\u0003H=\u0011\r\u0011\"\u0005U\u0011\u001d\u0011Ie\u0004Q\u0001\nUC\u0011Ba\u0013\u0010\u0005\u0004%\tB!\u0014\t\u0011\t}s\u0002)A\u0005\u0005\u001fBqA!\u0019\u0010\r#\u0011\u0019\u0007C\u0004\u0003\u0002>1\tBa!\t\u000f\tEu\u0002\"\u0011\u0003\u0014\"9!1W\b\u0005B\tU\u0006b\u0002B`\u001f\u0011\u0005!\u0011\u0019\u0005\b\u0005c|A\u0011\u0003Bz\r\u0019\t\tf\u0004!\u0002T!Q\u00111\u000f\u0014\u0003\u0016\u0004%\t!!\u001e\t\u0015\u0005\u001deE!E!\u0002\u0013\t9\b\u0003\u0006\u0002\n\u001a\u0012)\u001a!C\u0001\u0003\u0017C!\"a''\u0005#\u0005\u000b\u0011BAG\u0011)\tiJ\nBK\u0002\u0013\u0005\u00111\u0012\u0005\u000b\u0003?3#\u0011#Q\u0001\n\u00055\u0005BB)'\t\u0003\t\t\u000bC\u0004\u0002*\u001a\"\t%a+\t\u000f\u0005Mf\u0005\"\u0011\u00026\"9\u0011q\u0019\u0014\u0005B\u0005%\u0007\"CAfM\u0005\u0005I\u0011AAg\u0011%\t)NJI\u0001\n\u0003\t9\u000eC\u0005\u0002n\u001a\n\n\u0011\"\u0001\u0002p\"I\u00111\u001f\u0014\u0012\u0002\u0013\u0005\u0011q\u001e\u0005\t\u0003k4\u0013\u0011!C!)\"I\u0011q\u001f\u0014\u0002\u0002\u0013\u0005\u0011\u0011 \u0005\n\u0003w4\u0013\u0011!C\u0001\u0003{D\u0011B!\u0001'\u0003\u0003%\tEa\u0001\t\u0013\t5a%!A\u0005\u0002\t=\u0001\"\u0003B\nM\u0005\u0005I\u0011\tB\u000b\u000f%\u0019)aDA\u0001\u0012\u0003\u00199AB\u0005\u0002R=\t\t\u0011#\u0001\u0004\n!1\u0011\u000b\u0010C\u0001\u00077A\u0011\"a2=\u0003\u0003%)e!\b\t\u0013\r}A(!A\u0005\u0002\u000e\u0005\u0002\"CB\u0015y\u0005\u0005I\u0011QB\u0016\u0003EjU\u000f\u001c;ja2,G*[:uK:,'o],ji\"\u001c\u0016-\\3TK\u000e,(/\u001b;z!J|Go\\2pY\n\u000b7/\u001a+fgRT!a\u0011#\u0002\rM,'O^3s\u0015\u0005)\u0015!B6bM.\f7\u0001\u0001\t\u0003\u0011\u0006i\u0011A\u0011\u00022\u001bVdG/\u001b9mK2K7\u000f^3oKJ\u001cx+\u001b;i'\u0006lWmU3dkJLG/\u001f)s_R|7m\u001c7CCN,G+Z:u'\t\t1\n\u0005\u0002M\u001f6\tQJC\u0001O\u0003\u0015\u00198-\u00197b\u0013\t\u0001VJ\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d\u000babU3dkJ,\u0017J\u001c;fe:\fG.F\u0001V!\t16,D\u0001X\u0015\tA\u0016,\u0001\u0003mC:<'\"\u0001.\u0002\t)\fg/Y\u0005\u00039^\u0013aa\u0015;sS:<\u0017aD*fGV\u0014X-\u00138uKJt\u0017\r\u001c\u0011\u0002\u001dM+7-\u001e:f\u000bb$XM\u001d8bY\u0006y1+Z2ve\u0016,\u0005\u0010^3s]\u0006d\u0007%\u0001\u0005J]R,'O\\1m\u0003%Ie\u000e^3s]\u0006d\u0007%\u0001\u0005FqR,'O\\1m\u0003%)\u0005\u0010^3s]\u0006d\u0007%\u0001\u0004HgN\f\u0005/[\u0001\b\u000fN\u001c\u0018\t]5!\u0003\u0015\u0001F.Y5o\u0003\u0019\u0001F.Y5oAM\u0019q\"\u001b7\u0011\u0005!S\u0017BA6C\u0005E\tVo\u001c:v[R+7\u000f\u001e%be:,7o\u001d\t\u0003[Bl\u0011A\u001c\u0006\u0003_\u0012\u000b1!\u00199j\u0013\t\thNA\u0005TCNd7+\u001a;vaR\t1\u000f\u0005\u0002I\u001f\u0005qAO];tiN#xN]3GS2,W#\u0001<\u0011\u0005]TX\"\u0001=\u000b\u0005eL\u0016AA5p\u0013\tY\bP\u0001\u0003GS2,\u0017a\u0004;skN$8\u000b^8sK\u001aKG.\u001a\u0011\u0002\u000fM,'O^3sgV\tq\u0010\u0005\u0004\u0002\u0002\u0005-\u0011qB\u0007\u0003\u0003\u0007QA!!\u0002\u0002\b\u00059Q.\u001e;bE2,'bAA\u0005\u001b\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u00055\u00111\u0001\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000fE\u0002I\u0003#I1!a\u0005C\u0005-Y\u0015MZ6b\u0005J|7.\u001a:\u0002\u0011M,'O^3sg\u0002\nQ!\u00193nS:,\"!a\u0007\u0011\t\u0005u\u0011qF\u0007\u0003\u0003?QA!a\u0006\u0002\")!\u00111EA\u0013\u0003\u001d\u0019G.[3oiNT1!RA\u0014\u0015\u0011\tI#a\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\ti#A\u0002pe\u001eLA!!\r\u0002 \t)\u0011\tZ7j]\u0006I\u0011\rZ7j]~#S-\u001d\u000b\u0005\u0003o\ti\u0004E\u0002M\u0003sI1!a\u000fN\u0005\u0011)f.\u001b;\t\u0013\u0005}b#!AA\u0002\u0005m\u0011a\u0001=%c\u00051\u0011\rZ7j]\u0002\n\u0011\u0002\u001d:pIV\u001cWM]:\u0016\u0005\u0005\u001d\u0003\u0003CA\u0001\u0003\u0013\niE!\u0007\n\t\u0005-\u00131\u0001\u0002\u0004\u001b\u0006\u0004\bcAA(M5\tqB\u0001\bDY&,g\u000e^'fi\u0006$\u0017\r^1\u0014\r\u0019Z\u0015QKA.!\ra\u0015qK\u0005\u0004\u00033j%a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003;\niG\u0004\u0003\u0002`\u0005%d\u0002BA1\u0003Oj!!a\u0019\u000b\u0007\u0005\u0015d)\u0001\u0004=e>|GOP\u0005\u0002\u001d&\u0019\u00111N'\u0002\u000fA\f7m[1hK&!\u0011qNA9\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\tY'T\u0001\rY&\u001cH/\u001a8fe:\u000bW.Z\u000b\u0003\u0003o\u0002B!!\u001f\u0002\u00046\u0011\u00111\u0010\u0006\u0005\u0003{\ny(A\u0004oKR<xN]6\u000b\t\u0005\u0005\u0015QE\u0001\u0007G>lWn\u001c8\n\t\u0005\u0015\u00151\u0010\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\u000eY&\u001cH/\u001a8fe:\u000bW.\u001a\u0011\u0002\u001bM\f7\u000f\\'fG\"\fg.[:n+\t\ti\t\u0005\u0003\u0002\u0010\u0006]e\u0002BAI\u0003'\u00032!!\u0019N\u0013\r\t)*T\u0001\u0007!J,G-\u001a4\n\u0007q\u000bIJC\u0002\u0002\u00166\u000bab]1tY6+7\r[1oSNl\u0007%A\u0003u_BL7-\u0001\u0004u_BL7\r\t\u000b\t\u0003\u001b\n\u0019+!*\u0002(\"9\u00111O\u0017A\u0002\u0005]\u0004bBAE[\u0001\u0007\u0011Q\u0012\u0005\b\u0003;k\u0003\u0019AAG\u0003!A\u0017m\u001d5D_\u0012,GCAAW!\ra\u0015qV\u0005\u0004\u0003ck%aA%oi\u00061Q-];bYN$B!a.\u0002>B\u0019A*!/\n\u0007\u0005mVJA\u0004C_>dW-\u00198\t\u000f\u0005}v\u00061\u0001\u0002B\u0006\u0019qN\u00196\u0011\u00071\u000b\u0019-C\u0002\u0002F6\u00131!\u00118z\u0003!!xn\u0015;sS:<GCAAG\u0003\u0011\u0019w\u000e]=\u0015\u0011\u00055\u0013qZAi\u0003'D\u0011\"a\u001d2!\u0003\u0005\r!a\u001e\t\u0013\u0005%\u0015\u0007%AA\u0002\u00055\u0005\"CAOcA\u0005\t\u0019AAG\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!7+\t\u0005]\u00141\\\u0016\u0003\u0003;\u0004B!a8\u0002j6\u0011\u0011\u0011\u001d\u0006\u0005\u0003G\f)/A\u0005v]\u000eDWmY6fI*\u0019\u0011q]'\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002l\u0006\u0005(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAyU\u0011\ti)a7\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!,\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011YA\u0000\u0011%\tydNA\u0001\u0002\u0004\ti+A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011)\u0001\u0005\u0004\u0003\b\t%\u0011\u0011Y\u0007\u0003\u0003\u000fIAAa\u0003\u0002\b\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t9L!\u0005\t\u0013\u0005}\u0012(!AA\u0002\u0005\u0005\u0017A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$2!\u0016B\f\u0011%\tyDOA\u0001\u0002\u0004\ti\u000b\u0005\u0005\u0003\u001c\t\u0005\"Q\u0005B\u0013\u001b\t\u0011iB\u0003\u0003\u0003 \u0005\u0005\u0012\u0001\u00039s_\u0012,8-\u001a:\n\t\t\r\"Q\u0004\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0011\u000b1\u00139Ca\u000b\n\u0007\t%RJA\u0003BeJ\f\u0017\u0010E\u0002M\u0005[I1Aa\fN\u0005\u0011\u0011\u0015\u0010^3\u0002\u0015A\u0014x\u000eZ;dKJ\u001c\b%A\u0005d_:\u001cX/\\3sgV\u0011!q\u0007\t\t\u0003\u0003\tI%!\u0014\u0003:AA!1\bB!\u0005K\u0011)#\u0004\u0002\u0003>)!!qHA\u0011\u0003!\u0019wN\\:v[\u0016\u0014\u0018\u0002\u0002B\"\u0005{\u0011\u0001bQ8ogVlWM]\u0001\u000bG>t7/^7feN\u0004\u0013\u0001G6bM.\f7\t\\5f]R\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[\u0006I2.\u00194lC\u000ec\u0017.\u001a8u'\u0006\u001cH.T3dQ\u0006t\u0017n]7!\u0003eY\u0017MZ6b'\u0016\u0014h/\u001a:TCNdW*Z2iC:L7/\\:\u0016\u0005\t=\u0003c\u0002B)\u0005/*&\u0011L\u0007\u0003\u0005'RAA!\u0016\u0002\b\u0005I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0003\u0017\u0012\u0019\u0006E\u0003\u0003\b\tmS+\u0003\u0003\u0003^\u0005\u001d!aA*fc\u0006Q2.\u00194lCN+'O^3s'\u0006\u001cH.T3dQ\u0006t\u0017n]7tA\u0005\u00112\u000f^1uS\u000eT\u0015-Y:TK\u000e$\u0018n\u001c8t+\t\u0011)\u0007\u0005\u0004\u0003\b\tm#q\r\t\u0005\u0005S\u0012YH\u0004\u0003\u0003l\tUd\u0002\u0002B7\u0005crA!!\u0019\u0003p%\tQ)C\u0002\u0003t\u0011\u000b\u0001b]3dkJLG/_\u0005\u0005\u0005o\u0012I(A\u0007KC\u0006\u001cH+Z:u+RLGn\u001d\u0006\u0004\u0005g\"\u0015\u0002\u0002B?\u0005\u007f\u00121BS1bgN+7\r^5p]*!!q\u000fB=\u0003M!\u0017P\\1nS\u000eT\u0015-Y:TK\u000e$\u0018n\u001c8t+\t\u0011)\t\u0005\u0003\u0003\b\n5UB\u0001BE\u0015\r\u0011Y)W\u0001\u0005kRLG.\u0003\u0003\u0003\u0010\n%%A\u0003)s_B,'\u000f^5fg\u0006)1/\u001a;VaR!\u0011q\u0007BK\u0011\u001d\u00119J\ta\u0001\u00053\u000b\u0001\u0002^3ti&sgm\u001c\t\u0005\u00057\u00139+\u0004\u0002\u0003\u001e*\u0019qNa(\u000b\t\t\u0005&1U\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\u0011)+a\u000b\u0002\u000b),h.\u001b;\n\t\t%&Q\u0014\u0002\t)\u0016\u001cH/\u00138g_\"\u001a!E!,\u0011\t\tm%qV\u0005\u0005\u0005c\u0013iJ\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u000b\u0003\u0003oA3a\tB]!\u0011\u0011YJa/\n\t\tu&Q\u0014\u0002\n\u0003\u001a$XM]#bG\"\f!\u0003^3tiB\u0013x\u000eZ;dK\u000e{gn];nKR!\u0011q\u0007Bb\u0011\u001d\u0011)\r\na\u0001\u0003\u001b\u000bQb\u001a:pkB\u0004&o\u001c;pG>d\u0007f\u0002\u0013\u0003J\nU'q\u001b\t\u0005\u0005\u0017\u0014\t.\u0004\u0002\u0003N*!!q\u001aBP\u0003\u0019\u0001\u0018M]1ng&!!1\u001bBg\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0005]\u0006lW-\t\u0002\u0003Z\u0006y2\u0010Z5ta2\f\u0017PT1nKvtsM]8vaB\u0013x\u000e^8d_2l4\u0010M?)\u000f\u0011\u0012iN!;\u0003lB!!q\u001cBs\u001b\t\u0011\tO\u0003\u0003\u0003d\n5\u0017\u0001\u00039s_ZLG-\u001a:\n\t\t\u001d(\u0011\u001d\u0002\r\u001b\u0016$\bn\u001c3T_V\u00148-Z\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0005[\f#Aa<\u0002C\u001d,G\u000fV3ti\u001e\u0013x.\u001e9Qe>$xnY8m!\u0006\u0014\u0018-\\3uKJ\u001c\u0018\t\u001c7\u0002+\u0005$G\rR=oC6L7MS1bgN+7\r^5p]RQ\u0011q\u0007B{\u0005s\u0014ip!\u0001\t\u000f\t]X\u00051\u0001\u0003\u0006\u0006)\u0001O]8qg\"9!1`\u0013A\u0002\u00055\u0015\u0001\u00037jgR,g.\u001a:\t\u000f\t}X\u00051\u0001\u0002\u000e\u0006IQ.Z2iC:L7/\u001c\u0005\b\u0007\u0007)\u0003\u0019\u0001B4\u0003-Q\u0017-Y:TK\u000e$\u0018n\u001c8\u0002\u001d\rc\u0017.\u001a8u\u001b\u0016$\u0018\rZ1uCB\u0019\u0011q\n\u001f\u0014\u000bq\u001aYaa\u0006\u0011\u0019\r511CA<\u0003\u001b\u000bi)!\u0014\u000e\u0005\r=!bAB\t\u001b\u00069!/\u001e8uS6,\u0017\u0002BB\u000b\u0007\u001f\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84!\r98\u0011D\u0005\u0004\u0003_BHCAB\u0004)\u0005)\u0016!B1qa2LH\u0003CA'\u0007G\u0019)ca\n\t\u000f\u0005Mt\b1\u0001\u0002x!9\u0011\u0011R A\u0002\u00055\u0005bBAO\u007f\u0001\u0007\u0011QR\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019ic!\u000f\u0011\u000b1\u001byca\r\n\u0007\rERJ\u0001\u0004PaRLwN\u001c\t\n\u0019\u000eU\u0012qOAG\u0003\u001bK1aa\u000eN\u0005\u0019!V\u000f\u001d7fg!I11\b!\u0002\u0002\u0003\u0007\u0011QJ\u0001\u0004q\u0012\u0002\u0004")
public abstract class MultipleListenersWithSameSecurityProtocolBaseTest
extends QuorumTestHarness
implements SaslSetup {
    private volatile MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$ ClientMetadata$module;
    private final File trustStoreFile;
    private final ArrayBuffer<KafkaBroker> servers;
    private Admin admin;
    private final Map<ClientMetadata, KafkaProducer<byte[], byte[]>> producers;
    private final Map<ClientMetadata, Consumer<byte[], byte[]>> consumers;
    private final String kafkaClientSaslMechanism;
    private final scala.collection.immutable.Map<String, Seq<String>> kafkaServerSaslMechanisms;
    private File kafka$api$SaslSetup$$workDir;
    private Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    public static String Plain() {
        return MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Plain();
    }

    public static String GssApi() {
        return MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.GssApi();
    }

    public static String External() {
        return MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.External();
    }

    public static String Internal() {
        return MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Internal();
    }

    public static String SecureExternal() {
        return MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureExternal();
    }

    public static String SecureInternal() {
        return MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureInternal();
    }

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, kafkaServerEntryName);
    }

    @Override
    public String jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public String jaasAdminLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasAdminLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasAdminLoginModule$default$2() {
        return SaslSetup.jaasAdminLoginModule$default$2$(this);
    }

    @Override
    public String jaasScramClientLoginModule(String clientSaslScramMechanism, String scramUser, String scramPassword) {
        return SaslSetup.jaasScramClientLoginModule$(this, clientSaslScramMechanism, scramUser, scramPassword);
    }

    @Override
    public Admin createPrivilegedAdminClient() {
        return SaslSetup.createPrivilegedAdminClient$(this);
    }

    @Override
    public Admin createAdminClient(String brokerList, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> clientSaslProperties, String scramMechanism, String user, String password) {
        return SaslSetup.createAdminClient$(this, brokerList, securityProtocol, trustStoreFile, clientSaslProperties, scramMechanism, user, password);
    }

    @Override
    public void createScramCredentialsViaPrivilegedAdminClient(String userName, String password) {
        SaslSetup.createScramCredentialsViaPrivilegedAdminClient$(this, userName, password);
    }

    @Override
    public void createScramCredentials(Admin adminClient, String userName, String password) {
        SaslSetup.createScramCredentials$(this, adminClient, userName, password);
    }

    public MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$ ClientMetadata() {
        if (this.ClientMetadata$module == null) {
            this.ClientMetadata$lzycompute$1();
        }
        return this.ClientMetadata$module;
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    private File trustStoreFile() {
        return this.trustStoreFile;
    }

    private ArrayBuffer<KafkaBroker> servers() {
        return this.servers;
    }

    private Admin admin() {
        return this.admin;
    }

    private void admin_$eq(Admin x$1) {
        this.admin = x$1;
    }

    private Map<ClientMetadata, KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    private Map<ClientMetadata, Consumer<byte[], byte[]>> consumers() {
        return this.consumers;
    }

    public String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    public scala.collection.immutable.Map<String, Seq<String>> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    public abstract Seq<JaasTestUtils.JaasSection> staticJaasSections();

    public abstract Properties dynamicJaasSections();

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.startSasl(this.staticJaasSections());
        super.setUp(testInfo);
        int numServers = 2;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numServers).foreach((Function1 & Serializable)brokerId -> MultipleListenersWithSameSecurityProtocolBaseTest.$anonfun$setUp$1(this, BoxesRunTime.unboxToInt((Object)brokerId)));
        ((IterableOnceOps)this.servers().map((Function1 & Serializable)x$1 -> x$1.config())).foreach((Function1 & Serializable)config -> {
            MultipleListenersWithSameSecurityProtocolBaseTest.$anonfun$setUp$4(config);
            return BoxedUnit.UNIT;
        });
        HashMap<String, String> adminClientConfig = new HashMap<String, String>();
        adminClientConfig.put("bootstrap.servers", TestUtils$.MODULE$.bootstrapServers(this.servers(), new ListenerName(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Internal())));
        this.admin_$eq(Admin.create(adminClientConfig));
        NewTopic newTopic = new NewTopic("__consumer_offsets", 50, (short)2);
        HashMap newTopicConfigs = new HashMap();
        ((KafkaBroker)this.servers().head()).groupCoordinator().groupMetadataTopicConfigs().entrySet().forEach(e -> newTopicConfigs.put(e.getKey().toString(), e.getValue().toString()));
        newTopic.configs(newTopicConfigs);
        this.admin().createTopics(java.util.List.of(newTopic)).all().get(5L, TimeUnit.MINUTES);
        this.createScramCredentials(this.admin(), "scram-user", "scram-user-secret");
        TestUtils$.MODULE$.ensureConsistentKRaftMetadata((Seq<KafkaBroker>)this.servers(), this.controllerServer(), "Timeout waiting for controller metadata propagating to brokers");
        ((KafkaBroker)this.servers().head()).config().listeners().foreach((Function1 & Serializable)endPoint -> {
            MultipleListenersWithSameSecurityProtocolBaseTest.$anonfun$setUp$6(this, endPoint);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    @AfterEach
    public void tearDown() {
        Option$.MODULE$.apply((Object)this.admin()).foreach((Function1 & Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        this.admin_$eq(null);
        this.producers().values().foreach((Function1 & Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
        this.consumers().values().foreach((Function1 & Serializable)x$4 -> {
            x$4.close();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.shutdownServers(this.servers(), true);
        super.tearDown();
        this.closeSasl();
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testProduceConsume(String groupProtocol) {
        this.producers().foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                ClientMetadata clientMetadata = (ClientMetadata)x0$1._1();
                KafkaProducer producer = (KafkaProducer)x0$1._2();
                IndexedSeq producerRecords = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)i -> MultipleListenersWithSameSecurityProtocolBaseTest.$anonfun$testProduceConsume$2(clientMetadata, BoxesRunTime.unboxToInt((Object)i)));
                ((IndexedSeqOps)producerRecords.map((Function1 & Serializable)x$1 -> producer.send(x$1))).map((Function1 & Serializable)x$5 -> (RecordMetadata)x$5.get(10L, TimeUnit.SECONDS));
                Consumer consumer = (Consumer)this.consumers().apply((Object)clientMetadata);
                consumer.subscribe(Set.of(clientMetadata.topic()));
                return TestUtils$.MODULE$.consumeRecords(consumer, producerRecords.size(), 15000L);
            }
            throw new MatchError(null);
        });
    }

    public void addDynamicJaasSection(Properties props, String listener, String mechanism, JaasTestUtils.JaasSection jaasSection) {
        String prefix = new ListenerName(listener).saslMechanismConfigPrefix(mechanism);
        String jaasConfig = jaasSection.getModules().get(0).toString();
        props.put(prefix + "sasl.jaas.config", jaasConfig);
    }

    private final void ClientMetadata$lzycompute$1() {
        synchronized (this) {
            if (this.ClientMetadata$module == null) {
                this.ClientMetadata$module = new MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$setUp$1(MultipleListenersWithSameSecurityProtocolBaseTest $this, int brokerId) {
        Some x$2 = new Some((Object)$this.trustStoreFile());
        boolean x$3 = true;
        boolean x$4 = true;
        TestUtils$ createBrokerConfig$default$4_this = TestUtils$.MODULE$;
        Object var22_5 = null;
        int x$5 = createBrokerConfig$default$4_this.RandomPort();
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = true;
        boolean x$9 = false;
        TestUtils$ createBrokerConfig$default$10_this = TestUtils$.MODULE$;
        Object var23_11 = null;
        int x$10 = createBrokerConfig$default$10_this.RandomPort();
        boolean x$11 = false;
        TestUtils$ createBrokerConfig$default$12_this = TestUtils$.MODULE$;
        Object var24_14 = null;
        int x$12 = createBrokerConfig$default$12_this.RandomPort();
        boolean x$13 = false;
        TestUtils$ createBrokerConfig$default$14_this = TestUtils$.MODULE$;
        Object var25_17 = null;
        int x$14 = createBrokerConfig$default$14_this.RandomPort();
        None$ x$15 = None$.MODULE$;
        int x$16 = 1;
        boolean x$17 = false;
        int x$18 = 1;
        short x$19 = 1;
        boolean x$20 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(brokerId, x$3, x$4, x$5, (Option<SecurityProtocol>)x$6, (Option<File>)x$2, (Option<Properties>)x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20);
        props.put("listeners", MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureInternal() + "://localhost:0, " + MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Internal() + "://localhost:0, " + MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureExternal() + "://localhost:0, " + MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.External() + "://localhost:0");
        props.put("advertised.listeners", props.get("listeners"));
        props.put("listener.security.protocol.map", MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Internal() + ":PLAINTEXT, " + MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureInternal() + ":SASL_SSL," + MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.External() + ":PLAINTEXT, " + MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureExternal() + ":SASL_SSL, CONTROLLER:PLAINTEXT");
        props.put("controller.listener.names", "CONTROLLER");
        props.put("inter.broker.listener.name", MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Internal());
        props.put("sasl.mechanism.inter.broker.protocol", $this.kafkaClientSaslMechanism());
        props.put(new ListenerName(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureInternal()).configPrefix() + "sasl.enabled.mechanisms", ((IterableOnceOps)$this.kafkaServerSaslMechanisms().apply((Object)MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureInternal())).mkString(","));
        props.put(new ListenerName(MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureExternal()).configPrefix() + "sasl.enabled.mechanisms", ((IterableOnceOps)$this.kafkaServerSaslMechanisms().apply((Object)MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureExternal())).mkString(","));
        props.put("sasl.kerberos.service.name", "kafka");
        new Implicits.PropertiesOps(props).$plus$plus$eq($this.dynamicJaasSections());
        new Implicits.PropertiesOps(props).$plus$plus$eq(JaasTestUtils.sslConfigs(ConnectionMode.SERVER, false, Optional.of($this.trustStoreFile()), "server" + brokerId));
        new .colon.colon((Object)MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureInternal(), (List)new .colon.colon((Object)MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureExternal(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)listenerName -> props.put(new ListenerName(listenerName).configPrefix() + "ssl.keystore.location", props.get("ssl.keystore.location")));
        props.put("ssl.keystore.location", "invalid/file/path");
        return (ArrayBuffer)$this.servers().$plus$eq((Object)$this.createBroker(KafkaConfig$.MODULE$.fromProps(props), $this.createBroker$default$2(), $this.createBroker$default$3(), $this.createBroker$default$4()));
    }

    public static final /* synthetic */ void $anonfun$setUp$4(KafkaConfig config) {
        Assertions.assertEquals((int)4, (int)config.listeners().size(), (String)("Unexpected listener count for broker " + config.brokerId()));
        Assertions.assertEquals((Object)MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Internal(), (Object)config.interBrokerListenerName().value(), (String)("Unexpected inter.broker.listener.name for broker " + config.brokerId()));
    }

    private final void addProducerConsumer$1(ListenerName listenerName, String mechanism, Option saslProps, String bootstrapServers$1, Endpoint endPoint$1, Option trustStoreFile$1) {
        String topic = listenerName.value() + this.producers().size();
        this.admin().createTopics(java.util.List.of(new NewTopic(topic, 2, (short)2))).all().get(5L, TimeUnit.MINUTES);
        ClientMetadata clientMetadata = new ClientMetadata(this, listenerName, mechanism, topic);
        SecurityProtocol x$3 = endPoint$1.securityProtocol();
        long x$6 = 60000L;
        long x$7 = 0x100000L;
        int x$8 = Integer.MAX_VALUE;
        int x$9 = 30000;
        int x$10 = 0;
        int x$11 = 16384;
        String x$12 = "none";
        int x$13 = 20000;
        ByteArraySerializer x$14 = new ByteArraySerializer();
        ByteArraySerializer x$15 = new ByteArraySerializer();
        boolean x$16 = false;
        this.producers().update((Object)clientMetadata, TestUtils$.MODULE$.createProducer(bootstrapServers$1, -1, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$3, (Option<File>)trustStoreFile$1, (Option<Properties>)saslProps, x$14, x$15, x$16));
        GroupProtocol x$18 = this.groupProtocolFromTestParameters();
        String x$19 = clientMetadata.toString();
        SecurityProtocol x$20 = endPoint$1.securityProtocol();
        String x$23 = "earliest";
        boolean x$24 = true;
        boolean x$25 = false;
        int x$26 = 500;
        ByteArrayDeserializer x$27 = new ByteArrayDeserializer();
        ByteArrayDeserializer x$28 = new ByteArrayDeserializer();
        this.consumers().update((Object)clientMetadata, TestUtils$.MODULE$.createConsumer(bootstrapServers$1, x$18, x$19, x$23, x$24, x$25, x$26, x$20, (Option<File>)trustStoreFile$1, (Option<Properties>)saslProps, x$27, x$28));
    }

    public static final /* synthetic */ void $anonfun$setUp$6(MultipleListenersWithSameSecurityProtocolBaseTest $this, Endpoint endPoint) {
        ListenerName listenerName = ListenerName.normalised((String)endPoint.listener());
        None$ trustStoreFile = JaasTestUtils.usesSslTransportLayer(endPoint.securityProtocol()) ? new Some((Object)$this.trustStoreFile()) : None$.MODULE$;
        String bootstrapServers = TestUtils$.MODULE$.bootstrapServers($this.servers(), listenerName);
        if (JaasTestUtils.usesSaslAuthentication(endPoint.securityProtocol())) {
            ((IterableOnceOps)$this.kafkaServerSaslMechanisms().apply((Object)endPoint.listener())).foreach(arg_0 -> MultipleListenersWithSameSecurityProtocolBaseTest.$anonfun$setUp$7$adapted($this, listenerName, bootstrapServers, endPoint, (Option)trustStoreFile, arg_0));
            return;
        }
        $this.addProducerConsumer$1(listenerName, "", (Option)None$.MODULE$, bootstrapServers, endPoint, (Option)trustStoreFile);
    }

    public static final /* synthetic */ ProducerRecord $anonfun$testProduceConsume$2(ClientMetadata clientMetadata$1, int i) {
        return new ProducerRecord(clientMetadata$1.topic(), (Object)("key" + i).getBytes(), (Object)("value" + i).getBytes());
    }

    public MultipleListenersWithSameSecurityProtocolBaseTest() {
        SaslSetup.$init$(this);
        this.trustStoreFile = TestUtils.tempFile((String)"truststore", (String)".jks");
        this.servers = new ArrayBuffer();
        this.admin = null;
        this.producers = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.consumers = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.kafkaClientSaslMechanism = MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Plain();
        this.kafkaServerSaslMechanisms = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureExternal()), (Object)new .colon.colon((Object)"SCRAM-SHA-256", (List)new .colon.colon((Object)MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.GssApi(), (List)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.SecureInternal()), (Object)new .colon.colon((Object)MultipleListenersWithSameSecurityProtocolBaseTest$.MODULE$.Plain(), (List)new .colon.colon((Object)"SCRAM-SHA-512", (List)Nil$.MODULE$)))}));
        Statics.releaseFence();
    }

    public static final /* synthetic */ Object $anonfun$setUp$7$adapted(MultipleListenersWithSameSecurityProtocolBaseTest $this, ListenerName listenerName$1, String bootstrapServers$1, Endpoint endPoint$1, Option trustStoreFile$1, String mechanism) {
        $this.addProducerConsumer$1(listenerName$1, mechanism, (Option)new Some((Object)$this.kafkaClientSaslProperties(mechanism, true)), bootstrapServers$1, endPoint$1, trustStoreFile$1);
        return BoxedUnit.UNIT;
    }

    public class ClientMetadata
    implements Product,
    Serializable {
        private final ListenerName listenerName;
        private final String saslMechanism;
        private final String topic;
        public final /* synthetic */ MultipleListenersWithSameSecurityProtocolBaseTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public ListenerName listenerName() {
            return this.listenerName;
        }

        public String saslMechanism() {
            return this.saslMechanism;
        }

        public String topic() {
            return this.topic;
        }

        public int hashCode() {
            return Objects.hash(this.listenerName(), this.saslMechanism());
        }

        public boolean equals(Object obj) {
            if (obj instanceof ClientMetadata && ((ClientMetadata)obj).kafka$server$MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$$$outer() == this.kafka$server$MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$$$outer()) {
                ClientMetadata clientMetadata = (ClientMetadata)obj;
                ListenerName listenerName = this.listenerName();
                ListenerName listenerName2 = clientMetadata.listenerName();
                if (!(listenerName != null ? !listenerName.equals(listenerName2) : listenerName2 != null)) {
                    String string = this.saslMechanism();
                    String string2 = clientMetadata.saslMechanism();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        String string3 = this.topic();
                        String string4 = clientMetadata.topic();
                        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                            return true;
                        }
                    }
                }
                return false;
            }
            return false;
        }

        public String toString() {
            return this.listenerName().value() + ":" + this.saslMechanism() + ":" + this.topic();
        }

        public ClientMetadata copy(ListenerName listenerName, String saslMechanism, String topic) {
            return new ClientMetadata(this.kafka$server$MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$$$outer(), listenerName, saslMechanism, topic);
        }

        public ListenerName copy$default$1() {
            return this.listenerName();
        }

        public String copy$default$2() {
            return this.saslMechanism();
        }

        public String copy$default$3() {
            return this.topic();
        }

        public String productPrefix() {
            return "ClientMetadata";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.listenerName();
                }
                case 1: {
                    return this.saslMechanism();
                }
                case 2: {
                    return this.topic();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ClientMetadata;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "listenerName";
                }
                case 1: {
                    return "saslMechanism";
                }
                case 2: {
                    return "topic";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public /* synthetic */ MultipleListenersWithSameSecurityProtocolBaseTest kafka$server$MultipleListenersWithSameSecurityProtocolBaseTest$ClientMetadata$$$outer() {
            return this.$outer;
        }

        public ClientMetadata(MultipleListenersWithSameSecurityProtocolBaseTest $outer, ListenerName listenerName, String saslMechanism, String topic) {
            this.listenerName = listenerName;
            this.saslMechanism = saslMechanism;
            this.topic = topic;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

