/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.server.GroupCoordinatorBaseRequestTest;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterConfigProperty;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.test.api.ClusterTestDefaults;
import org.apache.kafka.common.test.api.Type;
import org.junit.jupiter.api.Assertions;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ClusterTestDefaults(types={Type.KRAFT}, serverProperties={@ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")})
@ScalaSignature(bytes="\u0006\u0005M4AAD\b\u0001)!A\u0011\u0004\u0001B\u0001B\u0003%!\u0004C\u0003(\u0001\u0011\u0005\u0001\u0006C\u0003,\u0001\u0011\u0005A\u0006C\u0003;\u0001\u0011\u0005A\u0006C\u0003=\u0001\u0011\u0005A\u0006C\u0003?\u0001\u0011\u0005A\u0006C\u0003A\u0001\u0011\u0005A\u0006C\u0003C\u0001\u0011\u0005A\u0006C\u0003E\u0001\u0011%Q\tC\u0003N\u0001\u0011%a\nC\u0003R\u0001\u0011%!\u000bC\u0003V\u0001\u0011\u0005A\u0006C\u0003X\u0001\u0011\u0005AF\u0001\fPM\u001a\u001cX\r\u001e$fi\u000eD'+Z9vKN$H+Z:u\u0015\t\u0001\u0012#\u0001\u0004tKJ4XM\u001d\u0006\u0002%\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0016!\t1r#D\u0001\u0010\u0013\tArBA\u0010He>,\boQ8pe\u0012Lg.\u0019;pe\n\u000b7/\u001a*fcV,7\u000f\u001e+fgR\fqa\u00197vgR,'\u000f\u0005\u0002\u001cK5\tAD\u0003\u0002\u001e=\u0005!A/Z:u\u0015\ty\u0002%\u0001\u0004d_6lwN\u001c\u0006\u0003%\u0005R!AI\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0013aA8sO&\u0011a\u0005\b\u0002\u0010\u00072,8\u000f^3s\u0013:\u001cH/\u00198dK\u00061A(\u001b8jiz\"\"!\u000b\u0016\u0011\u0005Y\u0001\u0001\"B\r\u0003\u0001\u0004Q\u0012A\u000e;fgR\u001c\u0016N\\4mK\u001e\u0013x.\u001e9PM\u001a\u001cX\r\u001e$fi\u000eDw+\u001b;i\u001d\u0016<8i\u001c8tk6,'o\u0012:pkB\u0004&o\u001c;pG>dG#A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0007Q\u0002\"!\u000e\u001d\u000e\u0003YR!a\u000e\u000f\u0002\u0007\u0005\u0004\u0018.\u0003\u0002:m\tY1\t\\;ti\u0016\u0014H+Z:u\u0003Y\"Xm\u001d;TS:<G.Z$s_V\u0004xJ\u001a4tKR4U\r^2i/&$\bn\u00147e\u0007>t7/^7fe\u001e\u0013x.\u001e9Qe>$xnY8mQ\t!A'A\u001duKN$8+\u001b8hY\u0016<%o\\;q\u00032dwJ\u001a4tKR4U\r^2i/&$\bNT3x\u0007>t7/^7fe\u001e\u0013x.\u001e9Qe>$xnY8mQ\t)A'A\u001duKN$8+\u001b8hY\u0016<%o\\;q\u00032dwJ\u001a4tKR4U\r^2i/&$\bn\u00147e\u0007>t7/^7fe\u001e\u0013x.\u001e9Qe>$xnY8mQ\t1A'\u0001\u001cuKN$X*\u001e7uS\u001e\u0013x.\u001e9t\u001f\u001a47/\u001a;GKR\u001c\u0007nV5uQ:+woQ8ogVlWM]$s_V\u0004\bK]8u_\u000e|G\u000e\u000b\u0002\bi\u00051D/Z:u\u001bVdG/[$s_V\u00048o\u00144gg\u0016$h)\u001a;dQ^KG\u000f[(mI\u000e{gn];nKJ<%o\\;q!J|Go\\2pY\"\u0012\u0001\u0002N\u0001\u001bi\u0016\u001cHoU5oO2,wI]8va>3gm]3u\r\u0016$8\r\u001b\u000b\u0004[\u0019[\u0005\"B$\n\u0001\u0004A\u0015AD;tK:+w\u000f\u0015:pi>\u001cw\u000e\u001c\t\u0003]%K!AS\u0018\u0003\u000f\t{w\u000e\\3b]\")A*\u0003a\u0001\u0011\u0006i!/Z9vSJ,7\u000b^1cY\u0016\fQ\u0004^3tiNKgn\u001a7f\u000fJ|W\u000f]!mY>3gm]3u\r\u0016$8\r\u001b\u000b\u0004[=\u0003\u0006\"B$\u000b\u0001\u0004A\u0005\"\u0002'\u000b\u0001\u0004A\u0015!\b;fgRlU\u000f\u001c;ja2,wI]8vaN|eMZ:fi\u001a+Go\u00195\u0015\u00075\u001aF\u000bC\u0003H\u0017\u0001\u0007\u0001\nC\u0003M\u0017\u0001\u0007\u0001*A\u0011uKN$h)\u001a;dQ>3gm]3u/&$\bNU3de\u0016\fG/\u001a3U_BL7\r\u000b\u0002\ri\u0005yA/Z:u\u000fJ|W\u000f]#se>\u00148\u000f\u000b\u0002\u000ei!2\u0001AW/_I\u0016\u0004\"!N.\n\u0005q3$aE\"mkN$XM\u001d+fgR$UMZ1vYR\u001c\u0018!\u0002;za\u0016\u001cH&A0%\u0003\u0001L!!\u00192\u0002\u000b-\u0013\u0016I\u0012+\u000b\u0005\r4\u0014\u0001\u0002+za\u0016\f\u0001c]3sm\u0016\u0014\bK]8qKJ$\u0018.Z:-\u0005\u0019\u00048&B4kW6t\u0007CA\u001bi\u0013\tIgGA\u000bDYV\u001cH/\u001a:D_:4\u0017n\u001a)s_B,'\u000f^=\u0002\u0007-,\u00170I\u0001m\u0003qygMZ:fiNtCo\u001c9jG:rW/\u001c\u0018qCJ$\u0018\u000e^5p]N\fQA^1mk\u0016\f\u0013a\\\u0001\u0002c-*qM[9n]\u0006\n!/\u0001\u0011pM\u001a\u001cX\r^:/i>\u0004\u0018n\u0019\u0018sKBd\u0017nY1uS>tgFZ1di>\u0014\b")
public class OffsetFetchRequestTest
extends GroupCoordinatorBaseRequestTest {
    @ClusterTest
    public void testSingleGroupOffsetFetchWithNewConsumerGroupProtocol() {
        this.testSingleGroupOffsetFetch(true, true);
    }

    @ClusterTest
    public void testSingleGroupOffsetFetchWithOldConsumerGroupProtocol() {
        this.testSingleGroupOffsetFetch(false, false);
    }

    @ClusterTest
    public void testSingleGroupAllOffsetFetchWithNewConsumerGroupProtocol() {
        this.testSingleGroupAllOffsetFetch(true, true);
    }

    @ClusterTest
    public void testSingleGroupAllOffsetFetchWithOldConsumerGroupProtocol() {
        this.testSingleGroupAllOffsetFetch(false, false);
    }

    @ClusterTest
    public void testMultiGroupsOffsetFetchWithNewConsumerGroupProtocol() {
        this.testMultipleGroupsOffsetFetch(true, true);
    }

    @ClusterTest
    public void testMultiGroupsOffsetFetchWithOldConsumerGroupProtocol() {
        this.testMultipleGroupsOffsetFetch(false, false);
    }

    /*
     * WARNING - void declaration
     */
    private void testSingleGroupOffsetFetch(boolean useNewProtocol, boolean requireStable) {
        void var6_6;
        this.createOffsetsTopic();
        Uuid unknownTopicId = Uuid.randomUuid();
        Uuid topicId = this.createTopic("foo", 3);
        Tuple2<String, Object> tuple2 = this.joinConsumerGroup("grp", useNewProtocol);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String memberId = (String)tuple2._1();
        int n = tuple2._2$mcI$sp();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> OffsetFetchRequestTest.$anonfun$testSingleGroupOffsetFetch$1(this, (String)var6_6, n, topicId, arg_0)));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), (int)ApiKeys.OFFSET_FETCH.latestVersion(this.isUnstableApiEnabled())).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> OffsetFetchRequestTest.$anonfun$testSingleGroupOffsetFetch$2(this, topicId, (String)var6_6, n, requireStable, unknownTopicId, useNewProtocol, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private void testSingleGroupAllOffsetFetch(boolean useNewProtocol, boolean requireStable) {
        void var5_5;
        this.createOffsetsTopic();
        Uuid topicId = this.createTopic("foo", 3);
        Tuple2<String, Object> tuple2 = this.joinConsumerGroup("grp", useNewProtocol);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String memberId = (String)tuple2._1();
        int n = tuple2._2$mcI$sp();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> OffsetFetchRequestTest.$anonfun$testSingleGroupAllOffsetFetch$1(this, (String)var5_5, n, topicId, arg_0)));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(2), (int)ApiKeys.OFFSET_FETCH.latestVersion(this.isUnstableApiEnabled())).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> OffsetFetchRequestTest.$anonfun$testSingleGroupAllOffsetFetch$2(this, topicId, (String)var5_5, n, requireStable, useNewProtocol, arg_0)));
    }

    private void testMultipleGroupsOffsetFetch(boolean useNewProtocol, boolean requireStable) {
        this.createOffsetsTopic();
        Uuid unknownTopicId = Uuid.randomUuid();
        Uuid topicId = this.createTopic("foo", 3);
        new .colon.colon((Object)"grp-0", (List)new .colon.colon((Object)"grp-1", (List)new .colon.colon((Object)"grp-2", (List)Nil$.MODULE$))).foreach((Function1 & Serializable)groupId -> {
            OffsetFetchRequestTest.$anonfun$testMultipleGroupsOffsetFetch$1(this, useNewProtocol, topicId, groupId);
            return BoxedUnit.UNIT;
        });
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(8), (int)ApiKeys.OFFSET_FETCH.latestVersion(this.isUnstableApiEnabled())).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> Assertions.assertEquals((Object)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("grp-0").setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(version < 10 ? "foo" : "").setTopicId(version >= 10 ? topicId : Uuid.ZERO_UUID).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OffsetFetchResponseData.OffsetFetchResponsePartitions[]{new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(0).setCommittedOffset(100L), new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(1).setCommittedOffset(101L), new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(5).setCommittedOffset(-1L)}))).asJava()), (List)Nil$.MODULE$)).asJava()), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("grp-1").setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(version < 10 ? "foo" : "").setTopicId(version >= 10 ? topicId : Uuid.ZERO_UUID).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OffsetFetchResponseData.OffsetFetchResponsePartitions[]{new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(0).setCommittedOffset(100L), new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(1).setCommittedOffset(101L), new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(2).setCommittedOffset(102L)}))).asJava()), (List)Nil$.MODULE$)).asJava()), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("grp-2").setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava()), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("grp-3").setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(version < 10 ? "foo" : "").setTopicId(version >= 10 ? topicId : Uuid.ZERO_UUID).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(0).setCommittedOffset(-1L), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava()), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("grp-4").setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(version < 10 ? "foo" : "").setTopicId(version >= 10 ? topicId : Uuid.ZERO_UUID).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OffsetFetchResponseData.OffsetFetchResponsePartitions[]{new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(5).setCommittedOffset(-1L)}))).asJava()), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(version < 10 ? "foo-unknown" : "").setTopicId(version >= 10 ? unknownTopicId : Uuid.ZERO_UUID).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OffsetFetchResponseData.OffsetFetchResponsePartitions[]{new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(0).setCommittedOffset(-1L).setErrorCode(version >= 10 ? Errors.UNKNOWN_TOPIC_ID.code() : Errors.NONE.code())}))).asJava()), (List)Nil$.MODULE$))).asJava()), (List)Nil$.MODULE$))))).toSet(), (Object)this.fetchOffsets((List<OffsetFetchRequestData.OffsetFetchRequestGroup>)new .colon.colon((Object)new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("grp-0").setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchRequestData.OffsetFetchRequestTopics().setName("foo").setTopicId(topicId).setPartitionIndexes(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(5)}))).asJava()), (List)Nil$.MODULE$)).asJava()), (List)new .colon.colon((Object)new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("grp-1").setTopics(null), (List)new .colon.colon((Object)new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("grp-2").setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava()), (List)new .colon.colon((Object)new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("grp-3").setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchRequestData.OffsetFetchRequestTopics().setName("foo").setTopicId(topicId).setPartitionIndexes(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava()), (List)new .colon.colon((Object)new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("grp-4").setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchRequestData.OffsetFetchRequestTopics().setName("foo-unknown").setTopicId(unknownTopicId).setPartitionIndexes(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)}))).asJava()), (List)new .colon.colon((Object)new OffsetFetchRequestData.OffsetFetchRequestTopics().setName("foo").setTopicId(topicId).setPartitionIndexes(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(5)}))).asJava()), (List)Nil$.MODULE$))).asJava()), (List)Nil$.MODULE$))))), requireStable, (short)version).toSet()));
    }

    /*
     * WARNING - void declaration
     */
    @ClusterTest
    public void testFetchOffsetWithRecreatedTopic() {
        void var3_3;
        this.createOffsetsTopic();
        ObjectRef topicId = ObjectRef.create((Object)this.createTopic("foo", 3));
        Tuple2<String, Object> tuple2 = this.joinConsumerGroup("grp", true);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String memberId = (String)tuple2._1();
        int n = tuple2._2$mcI$sp();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> OffsetFetchRequestTest.$anonfun$testFetchOffsetWithRecreatedTopic$1(this, (String)var3_3, n, topicId, arg_0)));
        this.deleteTopic("foo");
        topicId.elem = this.createTopic("foo", 3);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(10), (int)ApiKeys.OFFSET_FETCH.latestVersion(this.isUnstableApiEnabled())).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> OffsetFetchRequestTest.$anonfun$testFetchOffsetWithRecreatedTopic$2(this, topicId, (String)var3_3, n, arg_0)));
    }

    @ClusterTest
    public void testGroupErrors() {
        Uuid topicId = this.createTopic("foo", 3);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.OFFSET_FETCH.oldestVersion()), (int)ApiKeys.OFFSET_FETCH.latestVersion(this.isUnstableApiEnabled())).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> Assertions.assertEquals((Object)(version >= 2 ? new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("unknown").setErrorCode(Errors.NOT_COORDINATOR.code()) : new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("unknown").setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName("foo").setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(0).setErrorCode(Errors.NOT_COORDINATOR.code()).setCommittedOffset(-1L).setCommittedLeaderEpoch(-1).setMetadata(""), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava())), (Object)this.fetchOffsets(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("unknown").setMemberId("").setMemberEpoch(0).setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchRequestData.OffsetFetchRequestTopics().setName("foo").setTopicId(topicId).setPartitionIndexes(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava()), false, (short)version)));
    }

    public static final /* synthetic */ void $anonfun$testSingleGroupOffsetFetch$1(OffsetFetchRequestTest $this, String memberId$1, int memberEpoch$1, Uuid topicId$1, int partitionId) {
        $this.commitOffset("grp", memberId$1, memberEpoch$1, "foo", topicId$1, partitionId, 100L + (long)partitionId, Errors.NONE, ApiKeys.OFFSET_COMMIT.latestVersion($this.isUnstableApiEnabled()));
    }

    public static final /* synthetic */ void $anonfun$testSingleGroupOffsetFetch$2(OffsetFetchRequestTest $this, Uuid topicId$1, String memberId$1, int memberEpoch$1, boolean requireStable$1, Uuid unknownTopicId$1, boolean useNewProtocol$1, int version) {
        Assertions.assertEquals((Object)new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("grp").setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(version < 10 ? "foo" : "").setTopicId(version >= 10 ? topicId$1 : Uuid.ZERO_UUID).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(0).setCommittedOffset(100L), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(1).setCommittedOffset(101L), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(5).setCommittedOffset(-1L), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$)).asJava()), (Object)$this.fetchOffsets(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("grp").setMemberId(memberId$1).setMemberEpoch(memberEpoch$1).setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchRequestData.OffsetFetchRequestTopics().setName("foo").setTopicId(topicId$1).setPartitionIndexes(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(5), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$)).asJava()), requireStable$1, (short)version));
        Assertions.assertEquals((Object)new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("unknown").setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(version < 10 ? "foo" : "").setTopicId(version >= 10 ? topicId$1 : Uuid.ZERO_UUID).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(0).setCommittedOffset(-1L), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(1).setCommittedOffset(-1L), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(5).setCommittedOffset(-1L), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$)).asJava()), (Object)$this.fetchOffsets(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("unknown").setMemberId(memberId$1).setMemberEpoch(memberEpoch$1).setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchRequestData.OffsetFetchRequestTopics().setName("foo").setTopicId(topicId$1).setPartitionIndexes(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(5), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$)).asJava()), requireStable$1, (short)version));
        Assertions.assertEquals((Object)new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("unknown").setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(version < 10 ? "foo" : "").setTopicId(version >= 10 ? topicId$1 : Uuid.ZERO_UUID).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(0).setCommittedOffset(-1L), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(5).setCommittedOffset(-1L), (List)Nil$.MODULE$))).asJava()), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(version < 10 ? "foo-unknown" : "").setTopicId(version >= 10 ? unknownTopicId$1 : Uuid.ZERO_UUID).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(1).setCommittedOffset(-1L).setErrorCode(version >= 10 ? Errors.UNKNOWN_TOPIC_ID.code() : Errors.NONE.code()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$))).asJava()), (Object)$this.fetchOffsets(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("unknown").setMemberId(memberId$1).setMemberEpoch(memberEpoch$1).setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchRequestData.OffsetFetchRequestTopics().setName("foo").setTopicId(topicId$1).setPartitionIndexes(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(5), (List)Nil$.MODULE$))).asJava()), (List)new .colon.colon((Object)new OffsetFetchRequestData.OffsetFetchRequestTopics().setName("foo-unknown").setTopicId(unknownTopicId$1).setPartitionIndexes(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$))).asJava()), requireStable$1, (short)version));
        if (useNewProtocol$1 && version >= 9) {
            Assertions.assertEquals((Object)new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("grp").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()), (Object)$this.fetchOffsets(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("grp").setMemberId("").setMemberEpoch(memberEpoch$1).setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava()), requireStable$1, (short)version));
            Assertions.assertEquals((Object)new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("").setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(version < 10 ? "foo" : "").setTopicId(version >= 10 ? topicId$1 : Uuid.ZERO_UUID).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(0).setCommittedOffset(-1L), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(1).setCommittedOffset(-1L), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(5).setCommittedOffset(-1L), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$)).asJava()), (Object)$this.fetchOffsets(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("").setMemberId(memberId$1).setMemberEpoch(memberEpoch$1).setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchRequestData.OffsetFetchRequestTopics().setName("foo").setTopicId(topicId$1).setPartitionIndexes(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(5), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$)).asJava()), requireStable$1, (short)version));
            Assertions.assertEquals((Object)new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("grp").setErrorCode(Errors.STALE_MEMBER_EPOCH.code()), (Object)$this.fetchOffsets(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("grp").setMemberId(memberId$1).setMemberEpoch(memberEpoch$1 + 1).setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava()), requireStable$1, (short)version));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testSingleGroupAllOffsetFetch$1(OffsetFetchRequestTest $this, String memberId$2, int memberEpoch$2, Uuid topicId$2, int partitionId) {
        $this.commitOffset("grp", memberId$2, memberEpoch$2, "foo", topicId$2, partitionId, 100L + (long)partitionId, Errors.NONE, ApiKeys.OFFSET_COMMIT.latestVersion($this.isUnstableApiEnabled()));
    }

    public static final /* synthetic */ void $anonfun$testSingleGroupAllOffsetFetch$2(OffsetFetchRequestTest $this, Uuid topicId$2, String memberId$2, int memberEpoch$2, boolean requireStable$2, boolean useNewProtocol$2, int version) {
        Assertions.assertEquals((Object)new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("grp").setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(version < 10 ? "foo" : "").setTopicId(version >= 10 ? topicId$2 : Uuid.ZERO_UUID).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(0).setCommittedOffset(100L), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(1).setCommittedOffset(101L), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(2).setCommittedOffset(102L), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$)).asJava()), (Object)$this.fetchOffsets(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("grp").setMemberId(memberId$2).setMemberEpoch(memberEpoch$2).setTopics(null), requireStable$2, (short)version));
        Assertions.assertEquals((Object)new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("unknown"), (Object)$this.fetchOffsets(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("unknown").setMemberId(memberId$2).setMemberEpoch(memberEpoch$2).setTopics(null), requireStable$2, (short)version));
        if (useNewProtocol$2 && version >= 9) {
            Assertions.assertEquals((Object)new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("grp").setErrorCode(Errors.UNKNOWN_MEMBER_ID.code()), (Object)$this.fetchOffsets(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("grp").setMemberId("").setMemberEpoch(memberEpoch$2).setTopics(null), requireStable$2, (short)version));
            Assertions.assertEquals((Object)new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("grp").setErrorCode(Errors.STALE_MEMBER_EPOCH.code()), (Object)$this.fetchOffsets(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("grp").setMemberId(memberId$2).setMemberEpoch(memberEpoch$2 + 1).setTopics(null), requireStable$2, (short)version));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testMultipleGroupsOffsetFetch$2(OffsetFetchRequestTest $this, String groupId$1, String memberId$3, int memberEpoch$3, Uuid topicId$3, int partitionId) {
        $this.commitOffset(groupId$1, memberId$3, memberEpoch$3, "foo", topicId$3, partitionId, 100L + (long)partitionId, Errors.NONE, ApiKeys.OFFSET_COMMIT.latestVersion($this.isUnstableApiEnabled()));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testMultipleGroupsOffsetFetch$1(OffsetFetchRequestTest $this, boolean useNewProtocol$3, Uuid topicId$3, String groupId) {
        void var5_5;
        Tuple2<String, Object> tuple2 = $this.joinConsumerGroup(groupId, useNewProtocol$3);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String memberId = (String)tuple2._1();
        int n = tuple2._2$mcI$sp();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> OffsetFetchRequestTest.$anonfun$testMultipleGroupsOffsetFetch$2($this, groupId, (String)var5_5, n, topicId$3, arg_0)));
    }

    public static final /* synthetic */ void $anonfun$testFetchOffsetWithRecreatedTopic$1(OffsetFetchRequestTest $this, String memberId$4, int memberEpoch$4, ObjectRef topicId$4, int partitionId) {
        $this.commitOffset("grp", memberId$4, memberEpoch$4, "foo", (Uuid)topicId$4.elem, partitionId, 100L + (long)partitionId, Errors.NONE, ApiKeys.OFFSET_COMMIT.latestVersion($this.isUnstableApiEnabled()));
    }

    public static final /* synthetic */ void $anonfun$testFetchOffsetWithRecreatedTopic$2(OffsetFetchRequestTest $this, ObjectRef topicId$4, String memberId$4, int memberEpoch$4, int version) {
        Assertions.assertEquals((Object)new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId("grp").setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponseTopics().setTopicId((Uuid)topicId$4.elem).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(0).setCommittedOffset(-1L), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(1).setCommittedOffset(-1L), (List)new .colon.colon((Object)new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(2).setCommittedOffset(-1L), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$)).asJava()), (Object)$this.fetchOffsets(new OffsetFetchRequestData.OffsetFetchRequestGroup().setGroupId("grp").setMemberId(memberId$4).setMemberEpoch(memberEpoch$4).setTopics(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new OffsetFetchRequestData.OffsetFetchRequestTopics().setTopicId((Uuid)topicId$4.elem).setPartitionIndexes(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$)).asJava()), true, (short)version));
    }

    public OffsetFetchRequestTest(ClusterInstance cluster) {
        super(cluster);
    }
}

