/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.metadata.BrokerState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.VolatileObjectRef;

@Timeout(value=60L)
@ScalaSignature(bytes="\u0006\u0005\u0005eh\u0001B\u0010!\u0001\u0015BQ\u0001\f\u0001\u0005\u00025Bq\u0001\r\u0001C\u0002\u0013\u0005\u0011\u0007\u0003\u0004;\u0001\u0001\u0006IA\r\u0005\bw\u0001\u0011\r\u0011\"\u00012\u0011\u0019a\u0004\u0001)A\u0005e!9Q\b\u0001b\u0001\n\u0003q\u0004BB%\u0001A\u0003%q\bC\u0004K\u0001\t\u0007I\u0011\u0001 \t\r-\u0003\u0001\u0015!\u0003@\u0011\u001da\u0005A1A\u0005\u00025Ca\u0001\u0016\u0001!\u0002\u0013q\u0005bB+\u0001\u0001\u0004%\tA\u0016\u0005\b=\u0002\u0001\r\u0011\"\u0001`\u0011\u0019)\u0007\u0001)Q\u0005/\")a\r\u0001C!O\")A\u000e\u0001C![\"9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\r\u0001bBA$\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003'\u0002A\u0011AA%\u0011\u001d\t9\u0006\u0001C\u0001\u0003\u0013Bq!a\u0017\u0001\t\u0013\ti\u0006C\u0004\u0002\u0014\u0002!I!!&\t\u0011\u0005m\u0006\u0001)C\u0005\u0003{Cq!a4\u0001\t\u0003\tI\u0005C\u0004\u0002R\u0002!\t!!\u0013\t\u000f\u0005U\u0007\u0001\"\u0003\u0002X\"9\u0011\u0011\u001c\u0001\u0005\n\u0005m\u0007bBAr\u0001\u0011%\u0011\u0011\n\u0005\b\u0003K\u0004A\u0011BA%\u0011\u001d\t9\u000f\u0001C\u0005\u0003S\u0014!cU3sm\u0016\u00148\u000b[;uI><h\u000eV3ti*\u0011\u0011EI\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\r\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001MA\u0011qEK\u0007\u0002Q)\u0011\u0011FI\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002,Q\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002]A\u0011q\u0006A\u0007\u0002A\u0005!\u0001n\\:u+\u0005\u0011\u0004CA\u001a9\u001b\u0005!$BA\u001b7\u0003\u0011a\u0017M\\4\u000b\u0003]\nAA[1wC&\u0011\u0011\b\u000e\u0002\u0007'R\u0014\u0018N\\4\u0002\u000b!|7\u000f\u001e\u0011\u0002\u000bQ|\u0007/[2\u0002\rQ|\u0007/[2!\u0003\u0015\u0019XM\u001c;2+\u0005y\u0004c\u0001!He5\t\u0011I\u0003\u0002C\u0007\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003\t\u0016\u000b!bY8mY\u0016\u001cG/[8o\u0015\u00051\u0015!B:dC2\f\u0017B\u0001%B\u0005\u0011a\u0015n\u001d;\u0002\rM,g\u000e^\u0019!\u0003\u0015\u0019XM\u001c;3\u0003\u0019\u0019XM\u001c;3A\u0005A\u0002O]8qgR{7\t[1oO\u0016,\u0006o\u001c8SKN$\u0018M\u001d;\u0016\u00039\u0003\"a\u0014*\u000e\u0003AS!!\u0015\u001c\u0002\tU$\u0018\u000e\\\u0005\u0003'B\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003e\u0001(o\u001c9t)>\u001c\u0005.\u00198hKV\u0003xN\u001c*fgR\f'\u000f\u001e\u0011\u0002\u0017A\u0014\u0018n\u001c:D_:4\u0017nZ\u000b\u0002/B\u0019\u0001,W.\u000e\u0003\u0015K!AW#\u0003\r=\u0003H/[8o!\tyC,\u0003\u0002^A\tY1*\u00194lC\u000e{gNZ5h\u0003=\u0001(/[8s\u0007>tg-[4`I\u0015\fHC\u00011d!\tA\u0016-\u0003\u0002c\u000b\n!QK\\5u\u0011\u001d!W\"!AA\u0002]\u000b1\u0001\u001f\u00132\u00031\u0001(/[8s\u0007>tg-[4!\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cX#\u00015\u0011\u0007%T7,D\u0001D\u0013\tY7IA\u0002TKF\fQa]3u+B$\"\u0001\u00198\t\u000b=\u0004\u0002\u0019\u00019\u0002\u0011Q,7\u000f^%oM>\u0004\"!\u001d>\u000e\u0003IT!a\u001d;\u0002\u0007\u0005\u0004\u0018N\u0003\u0002vm\u00069!.\u001e9ji\u0016\u0014(BA<y\u0003\u0015QWO\\5u\u0015\u0005I\u0018aA8sO&\u00111P\u001d\u0002\t)\u0016\u001cH/\u00138g_\"\u0012\u0001# \t\u0003czL!a :\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\tuKN$8\t\\3b]NCW\u000f\u001e3po:$2\u0001YA\u0003\u0011\u001d\t9!\u0005a\u0001\u0003\u0013\tQb\u001a:pkB\u0004&o\u001c;pG>d\u0007\u0003BA\u0006\u00033qA!!\u0004\u0002\u0016A\u0019\u0011qB#\u000e\u0005\u0005E!bAA\nI\u00051AH]8pizJ1!a\u0006F\u0003\u0019\u0001&/\u001a3fM&\u0019\u0011(a\u0007\u000b\u0007\u0005]Q\tK\u0004\u0012\u0003?\tY#!\f\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\nu\u0003\u0019\u0001\u0018M]1ng&!\u0011\u0011FA\u0012\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0005]\u0006lW-\t\u0002\u00020\u0005y2\u0010Z5ta2\f\u0017PT1nKvtsM]8vaB\u0013x\u000e^8d_2l4\u0010M?)\u000fE\t\u0019$a\u0010\u0002BA!\u0011QGA\u001e\u001b\t\t9D\u0003\u0003\u0002:\u0005\r\u0012\u0001\u00039s_ZLG-\u001a:\n\t\u0005u\u0012q\u0007\u0002\r\u001b\u0016$\bn\u001c3T_V\u00148-Z\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0003\u0007\n#!!\u0012\u0002C\u001d,G\u000fV3ti\u001e\u0013x.\u001e9Qe>$xnY8m!\u0006\u0014\u0018-\\3uKJ\u001c\u0018\t\u001c7\u0002GQ,7\u000f^\"mK\u0006t7\u000b[;uI><h.\u00114uKJ4\u0015-\u001b7fIN#\u0018M\u001d;vaR\t\u0001\rK\u0002\u0013\u0003\u001b\u00022!]A(\u0013\r\t\tF\u001d\u0002\u0005)\u0016\u001cH/A\u001buKN$hj\\\"mK\u0006t7\u000b[;uI><h.\u00114uKJ4\u0015-\u001b7fIN#\u0018M\u001d;va\u0012+X\rV8D_J\u0014X\u000f\u001d;M_\u001e\u001c\bfA\n\u0002N\u0005QC/Z:u'\",H\u000fZ8x]^KG\u000f[&SC\u001a$8i\u001c8ue>dG.\u001a:V]\u00064\u0018-\u001b7bE2,\u0007f\u0001\u000b\u0002N\u0005)c/\u001a:jMf\u001cE.Z1o'\",H\u000fZ8x]\u00063G/\u001a:GC&dW\rZ*uCJ$X\u000f]\u000b\u0005\u0003?\n)\bF\u0002a\u0003CBq!a\u0019\u0016\u0001\b\t)'A\tfq\u000e,\u0007\u000f^5p]\u000ec\u0017m]:UC\u001e\u0004b!a\u001a\u0002n\u0005ETBAA5\u0015\r\tY'R\u0001\be\u00164G.Z2u\u0013\u0011\ty'!\u001b\u0003\u0011\rc\u0017m]:UC\u001e\u0004B!a\u001d\u0002v1\u0001AaBA<+\t\u0007\u0011\u0011\u0010\u0002\u0002\u000bF!\u00111PAA!\rA\u0016QP\u0005\u0004\u0003\u007f*%a\u0002(pi\"Lgn\u001a\t\u0005\u0003\u0007\u000biI\u0004\u0003\u0002\u0006\u0006%e\u0002BA\b\u0003\u000fK\u0011AR\u0005\u0004\u0003\u0017+\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003\u001f\u000b\tJA\u0005Fq\u000e,\u0007\u000f^5p]*\u0019\u00111R#\u0002\u0017\u0005\u001c8/\u001a:u\u0007\u0006,8/\u001a\u000b\u0006A\u0006]\u0015\u0011\u0017\u0005\b\u000333\u0002\u0019AAN\u00035)\u0007\u0010]3di\u0016$7\t\\1tgB\"\u0011QTAS!\u0019\tY!a(\u0002$&!\u0011\u0011UA\u000e\u0005\u0015\u0019E.Y:t!\u0011\t\u0019(!*\u0005\u0019\u0005\u001d\u0016qSA\u0001\u0002\u0003\u0015\t!!+\u0003\u0007}#\u0013'\u0005\u0003\u0002|\u0005-\u0006c\u0001-\u0002.&\u0019\u0011qV#\u0003\u0007\u0005s\u0017\u0010C\u0004\u00024Z\u0001\r!!.\u0002\u0003\u0015\u0004B!a!\u00028&!\u0011\u0011XAI\u0005%!\u0006N]8xC\ndW-\u0001\fjg:{g\u000eR1f[>t7*\u00194lCRC'/Z1e)\u0011\ty,!2\u0011\u0007a\u000b\t-C\u0002\u0002D\u0016\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0002H^\u0001\r!!3\u0002\u0003Q\u00042aMAf\u0013\r\ti\r\u000e\u0002\u0007)\"\u0014X-\u00193\u00029Y,'/\u001b4z\u001d>tG)Y3n_:$\u0006N]3bIN\u001cF/\u0019;vg\u00069B/Z:u\u0007>t7/Z2vi&4Xm\u00155vi\u0012|wO\u001c\u0015\u00043\u00055\u0013AB2p]\u001aLw-F\u0001\\\u0003\u0019\u0011'o\\6feV\u0011\u0011Q\u001c\t\u0004_\u0005}\u0017bAAqA\tY1*\u00194lC\n\u0013xn[3s\u00039\u0019\b.\u001e;e_^t'I]8lKJ\fQB]3ti\u0006\u0014HO\u0011:pW\u0016\u0014\u0018A\u0004:fGJ,\u0017\r^3Ce>\\WM\u001d\u000b\u0004A\u0006-\bbBAw=\u0001\u0007\u0011qX\u0001\bgR\f'\u000f^;qQ\u001d\u0001\u0011\u0011_A \u0003o\u00042!]Az\u0013\r\t)P\u001d\u0002\b)&lWm\\;u=\u0005a\u0004")
public class ServerShutdownTest
extends KafkaServerTestHarness {
    private final String host;
    private final String topic;
    private final List<String> sent1 = new .colon.colon((Object)"hello", (List)new .colon.colon((Object)"there", (List)Nil$.MODULE$));
    private final List<String> sent2 = new .colon.colon((Object)"more", (List)new .colon.colon((Object)"messages", (List)Nil$.MODULE$));
    private final Properties propsToChangeUponRestart = new Properties();
    private Option<KafkaConfig> priorConfig = None$.MODULE$;

    public String host() {
        return this.host;
    }

    public String topic() {
        return this.topic;
    }

    public List<String> sent1() {
        return this.sent1;
    }

    public List<String> sent2() {
        return this.sent2;
    }

    public Properties propsToChangeUponRestart() {
        return this.propsToChangeUponRestart;
    }

    public Option<KafkaConfig> priorConfig() {
        return this.priorConfig;
    }

    public void priorConfig_$eq(Option<KafkaConfig> x$1) {
        this.priorConfig = x$1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        this.priorConfig().foreach((Function1 & Serializable)config -> {
            java.util.Map originals = config.originals();
            Object logDirsValue = originals.get("log.dirs");
            if (logDirsValue != null) {
                return this.propsToChangeUponRestart().put("log.dirs", logDirsValue);
            }
            return this.propsToChangeUponRestart().put("log.dir", originals.get("log.dir"));
        });
        this.priorConfig_$eq((Option<KafkaConfig>)new Some((Object)KafkaConfig$.MODULE$.fromProps((Properties)TestUtils$.MODULE$.createBrokerConfigs(1, true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).head(), this.propsToChangeUponRestart(), true)));
        return new .colon.colon((Object)((KafkaConfig)this.priorConfig().get()), (List)Nil$.MODULE$);
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.priorConfig_$eq((Option<KafkaConfig>)None$.MODULE$);
        this.propsToChangeUponRestart().clear();
        super.setUp(testInfo);
    }

    @ParameterizedTest(name="{displayName}.groupProtocol={0}")
    @MethodSource(value={"getTestGroupProtocolParametersAll"})
    public void testCleanShutdown(String groupProtocol) {
        ObjectRef producer = ObjectRef.create((Object)this.createProducer$1());
        this.createTopic(this.topic(), this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.sent1().map((Function1 & Serializable)value -> ((KafkaProducer)producer$1.elem).send(new ProducerRecord(this.topic(), (Object)Predef$.MODULE$.int2Integer(0), value))).foreach((Function1 & Serializable)x$1 -> (RecordMetadata)x$1.get());
        this.killBroker(0);
        CollectionConverters$.MODULE$.ListHasAsScala(this.config().logDirs()).asScala().foreach((Function1 & Serializable)logDir -> {
            ServerShutdownTest.$anonfun$testCleanShutdown$3(logDir);
            return BoxedUnit.UNIT;
        });
        ((KafkaProducer)producer.elem).close();
        this.restartBroker();
        TestUtils$.MODULE$.waitForPartitionMetadata(new .colon.colon((Object)this.broker(), (List)Nil$.MODULE$), this.topic(), 0, 15000L);
        producer.elem = this.createProducer$1();
        Consumer consumer = this.createConsumer$1();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        Seq consumerRecords = TestUtils$.MODULE$.consumeRecords(consumer, this.sent1().size(), 15000L);
        Assertions.assertEquals(this.sent1(), (Object)consumerRecords.map((Function1 & Serializable)x$2 -> (String)x$2.value()));
        this.sent2().map((Function1 & Serializable)value -> ((KafkaProducer)producer$1.elem).send(new ProducerRecord(this.topic(), (Object)Predef$.MODULE$.int2Integer(0), value))).foreach((Function1 & Serializable)x$3 -> (RecordMetadata)x$3.get());
        Seq consumerRecords2 = TestUtils$.MODULE$.consumeRecords(consumer, this.sent2().size(), 15000L);
        Assertions.assertEquals(this.sent2(), (Object)consumerRecords2.map((Function1 & Serializable)x$4 -> (String)x$4.value()));
        consumer.close();
        ((KafkaProducer)producer.elem).close();
    }

    @Test
    public void testCleanShutdownAfterFailedStartup() {
        this.propsToChangeUponRestart().setProperty("initial.broker.registration.timeout.ms", "1000");
        this.killBroker(0);
        this.shutdownKRaftController();
        this.verifyCleanShutdownAfterFailedStartup(ClassTag$.MODULE$.apply(CancellationException.class));
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testNoCleanShutdownAfterFailedStartupDueToCorruptLogs() {
        this.createTopic(this.topic(), this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.killBroker(0);
        this.config().logDirs().forEach((java.util.function.Consumer<String>)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)V, $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$1(kafka.server.ServerShutdownTest java.lang.String ), (Ljava/lang/String;)V)((ServerShutdownTest)this));
        expectedStatusCode = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        receivedStatusCode = VolatileObjectRef.create((Object)Option$.MODULE$.empty());
        hasHaltProcedureCalled = VolatileBooleanRef.create((boolean)false);
        Exit.setHaltProcedure((Exit.Procedure)(Exit.Procedure)LambdaMetafactory.altMetafactory(null, null, null, (ILjava/lang/String;)V, $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$3(scala.runtime.VolatileBooleanRef scala.runtime.VolatileObjectRef int java.lang.String ), (ILjava/lang/String;)V)((VolatileBooleanRef)hasHaltProcedureCalled, (VolatileObjectRef)receivedStatusCode));
        try {
            Assertions.assertDoesNotThrow((Executable)(Executable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$4(kafka.server.ServerShutdownTest ), ()V)((ServerShutdownTest)this));
            var7_4 = 100L;
            waitUntilTrue_waitTimeMs = 15000L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                if (!hasHaltProcedureCalled.elem) ** GOTO lbl-1000
                v0 = expectedStatusCode;
                var11_7 = (Option)receivedStatusCode.elem;
                if (!(v0 != null ? v0.equals(var11_7) == false : var11_7 != null)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                var11_7 = null;
                if (!v1) {
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)("Expected to halt directly with the expected status code:" + expectedStatusCode.get() + ", but got hasHaltProcedureCalled: " + hasHaltProcedureCalled.elem + " and received status code: " + ((Option)receivedStatusCode.elem).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                    continue;
                }
                break;
            }
        }
        finally {
            Exit.resetHaltProcedure();
        }
    }

    @Test
    public void testShutdownWithKRaftControllerUnavailable() {
        this.shutdownKRaftController();
        this.killBroker(0, Duration.ofSeconds(1L));
        CoreUtils$.MODULE$.delete(this.broker().config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    private <E extends Exception> void verifyCleanShutdownAfterFailedStartup(ClassTag<E> exceptionClassTag) {
        try {
            try {
                this.recreateBroker(true);
                Assertions.fail((String)"Expected KafkaServer setup to fail and throw exception");
            }
            catch (Exception e) {
                this.assertCause(exceptionClassTag.runtimeClass(), e);
                Assertions.assertEquals((Object)BrokerState.SHUTTING_DOWN, (Object)((KafkaBroker)this.brokers().head()).brokerState());
            }
        }
        finally {
            this.killBroker(0);
        }
    }

    private void assertCause(Class<?> expectedClass, Throwable e) {
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (!expectedClass.isInstance(cause)) continue;
            return;
        }
        Assertions.fail((String)("Failed to assert cause of " + e + ", expected cause " + expectedClass));
    }

    private boolean isNonDaemonKafkaThread(Thread t) {
        return !t.isDaemon() && t.isAlive() && t.getName().startsWith(this.getClass().getName());
    }

    public void verifyNonDaemonThreadsStatus() {
        Assertions.assertEquals((int)0, (int)ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(Thread.getAllStackTraces().keySet().toArray()), (Function1 & Serializable)x$6 -> (Thread)x$6, ClassTag$.MODULE$.apply(Thread.class))), (Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)this.isNonDaemonKafkaThread(t))));
    }

    @Test
    public void testConsecutiveShutdown() {
        this.killBroker(0);
        ((KafkaBroker)this.brokers().head()).shutdown();
    }

    private KafkaConfig config() {
        return (KafkaConfig)this.configs().head();
    }

    private KafkaBroker broker() {
        return (KafkaBroker)this.brokers().head();
    }

    private void shutdownBroker() {
        this.killBroker(0);
    }

    private void restartBroker() {
        this.killBroker(0);
        this.restartDeadBrokers(!this.propsToChangeUponRestart().isEmpty());
    }

    private void recreateBroker(boolean startup) {
        this.recreateBrokers(!this.propsToChangeUponRestart().isEmpty(), startup);
    }

    private final KafkaProducer createProducer$1() {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        IntegerSerializer x$2 = new IntegerSerializer();
        StringSerializer x$3 = new StringSerializer();
        int x$4 = -1;
        long x$5 = 60000L;
        long x$6 = 0x100000L;
        int x$7 = Integer.MAX_VALUE;
        int x$8 = 30000;
        int x$9 = 0;
        int x$10 = 16384;
        String x$11 = "none";
        int x$12 = 20000;
        SecurityProtocol x$13 = SecurityProtocol.PLAINTEXT;
        None$ x$14 = None$.MODULE$;
        None$ x$15 = None$.MODULE$;
        boolean x$16 = false;
        return TestUtils$.MODULE$.createProducer(x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Option<File>)x$14, (Option<Properties>)x$15, x$2, x$3, x$16);
    }

    private final Consumer createConsumer$1() {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        GroupProtocol x$2 = this.groupProtocolFromTestParameters();
        IntegerDeserializer x$4 = new IntegerDeserializer();
        StringDeserializer x$5 = new StringDeserializer();
        String x$6 = "group";
        String x$7 = "earliest";
        boolean x$8 = true;
        boolean x$9 = false;
        int x$10 = 500;
        None$ x$11 = None$.MODULE$;
        None$ x$12 = None$.MODULE$;
        return TestUtils$.MODULE$.createConsumer(x$1, x$2, x$6, x$7, x$8, x$9, x$10, SecurityProtocol.PLAINTEXT, (Option<File>)x$11, (Option<Properties>)x$12, x$4, x$5);
    }

    public static final /* synthetic */ void $anonfun$testCleanShutdown$3(String logDir) {
        File OffsetCheckpointFile2 = new File(logDir, "recovery-point-offset-checkpoint");
        Assertions.assertTrue((boolean)OffsetCheckpointFile2.exists());
        Assertions.assertTrue((OffsetCheckpointFile2.length() > 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$1(ServerShutdownTest $this, String dirName) {
        File partitionDir = new File(dirName, $this.topic() + "-0");
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])partitionDir.listFiles()), (Function1 & Serializable)f -> {
            TestUtils$.MODULE$.appendNonsenseToFile(f, TestUtils$.MODULE$.random().nextInt(1024) + 1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$3(VolatileBooleanRef hasHaltProcedureCalled$1, VolatileObjectRef receivedStatusCode$1, int statusCode, String x$5) {
        hasHaltProcedureCalled$1.elem = true;
        receivedStatusCode$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)statusCode));
        throw (Nothing$)BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$4(ServerShutdownTest $this) {
        $this.recreateBroker(true);
    }

    public static final /* synthetic */ boolean $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$5(VolatileBooleanRef hasHaltProcedureCalled$1, Some expectedStatusCode$1, VolatileObjectRef receivedStatusCode$1) {
        if (hasHaltProcedureCalled$1.elem) {
            Some some = expectedStatusCode$1;
            Option option = (Option)receivedStatusCode$1.elem;
            if (!(some != null ? !some.equals(option) : option != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$6(Some expectedStatusCode$1, VolatileBooleanRef hasHaltProcedureCalled$1, VolatileObjectRef receivedStatusCode$1) {
        return "Expected to halt directly with the expected status code:" + expectedStatusCode$1.get() + ", but got hasHaltProcedureCalled: " + hasHaltProcedureCalled$1.elem + " and received status code: " + ((Option)receivedStatusCode$1.elem).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public ServerShutdownTest() {
        this.host = "localhost";
        this.topic = "test";
    }
}

