/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpointFile;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.EpochEntry;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t\u001da\u0001B\u001c9\u0001}BQA\u0012\u0001\u0005\u0002\u001dCqA\u0013\u0001C\u0002\u0013\u00051\n\u0003\u0004X\u0001\u0001\u0006I\u0001\u0014\u0005\b1\u0002\u0011\r\u0011\"\u0001Z\u0011\u0019\t\u0007\u0001)A\u00055\"9!\r\u0001b\u0001\n\u0013\u0019\u0007BB7\u0001A\u0003%A\rC\u0004o\u0001\t\u0007I\u0011B8\t\rU\u0004\u0001\u0015!\u0003q\u0011\u00151\b\u0001\"\u0001x\u0011\u0019\ti\u0001\u0001C\u0001o\"1\u0011\u0011\u0003\u0001\u0005\u0002]Da!!\u0006\u0001\t\u00039\bBBA\r\u0001\u0011\u0005q\u000f\u0003\u0004\u0002\u001e\u0001!\ta\u001e\u0005\u0007\u0003C\u0001A\u0011A<\t\r\u0005\u0015\u0002\u0001\"\u0001x\u0011\u0019\tI\u0003\u0001C\u0001o\"1\u0011Q\u0006\u0001\u0005\u0002]Da!!\r\u0001\t\u00039\bBBA\u001b\u0001\u0011\u0005q\u000f\u0003\u0004\u0002:\u0001!\ta\u001e\u0005\u0007\u0003{\u0001A\u0011A<\t\r\u0005\u0005\u0003\u0001\"\u0001x\u0011\u0019\t)\u0005\u0001C\u0001o\"1\u0011\u0011\n\u0001\u0005\u0002]Da!!\u0014\u0001\t\u00039\bbBA)\u0001\u0011%\u00111\u000b\u0005\u0007\u0003?\u0003A\u0011A<\t\r\u0005\r\u0006\u0001\"\u0001x\u0011\u0019\t9\u000b\u0001C\u0001o\"1\u00111\u0016\u0001\u0005\u0002]Da!a,\u0001\t\u00039\bBBAZ\u0001\u0011\u0005q\u000f\u0003\u0004\u00028\u0002!\ta\u001e\u0005\u0007\u0003w\u0003A\u0011A<\t\r\u0005}\u0006\u0001\"\u0001x\u0011\u0019\t\u0019\r\u0001C\u0001o\"1\u0011q\u0019\u0001\u0005\u0002]Da!a3\u0001\t\u00039\bBBAh\u0001\u0011\u0005q\u000f\u0003\u0004\u0002T\u0002!\ta\u001e\u0005\u0007\u0003/\u0004A\u0011A<\t\r\u0005m\u0007\u0001\"\u0001x\u0011\u0019\ty\u000e\u0001C\u0001o\"1\u00111\u001d\u0001\u0005\u0002]Da!a:\u0001\t\u00039\bBBAv\u0001\u0011\u0005q\u000f\u0003\u0004\u0002p\u0002!\ta\u001e\u0005\u0007\u0003g\u0004A\u0011A<\t\r\u0005]\b\u0001\"\u0001x\u0011\u0019\tY\u0010\u0001C\u0001o\"1\u0011q \u0001\u0005\u0002]DaAa\u0001\u0001\t\u00039(\u0001\u0007'fC\u0012,'/\u00129pG\"4\u0015\u000e\\3DC\u000eDW\rV3ti*\u0011\u0011HO\u0001\u0006KB|7\r\u001b\u0006\u0003wq\naa]3sm\u0016\u0014(\"A\u001f\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0011\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0002\u0007\u0006)1oY1mC&\u0011QI\u0011\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005A\u0005CA%\u0001\u001b\u0005A\u0014A\u0001;q+\u0005a\u0005CA'V\u001b\u0005q%BA(Q\u0003\u0019\u0019w.\\7p]*\u0011Q(\u0015\u0006\u0003%N\u000ba!\u00199bG\",'\"\u0001+\u0002\u0007=\u0014x-\u0003\u0002W\u001d\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0001;qA\u0005AQn\\2l)&lW-F\u0001[!\tYv,D\u0001]\u0015\tif,\u0001\u0003vi&d'BA\u001eQ\u0013\t\u0001GL\u0001\u0005N_\u000e\\G+[7f\u0003%iwnY6US6,\u0007%\u0001\u0006dQ\u0016\u001c7\u000e]8j]R,\u0012\u0001\u001a\t\u0003K.l\u0011A\u001a\u0006\u0003E\u001eT!\u0001[5\u0002\u0013%tG/\u001a:oC2\u001c(B\u00016Q\u0003\u001d\u0019Ho\u001c:bO\u0016L!\u0001\u001c4\u000331+\u0017\rZ3s\u000bB|7\r[\"iK\u000e\\\u0007o\\5oi\u001aKG.Z\u0001\fG\",7m\u001b9pS:$\b%A\u0003dC\u000eDW-F\u0001q!\t\t8/D\u0001s\u0015\tIt-\u0003\u0002ue\n!B*Z1eKJ,\u0005o\\2i\r&dWmQ1dQ\u0016\faaY1dQ\u0016\u0004\u0013!\u0005;fgR\u0004&/\u001a<j_V\u001cX\t]8dQR\t\u0001\u0010\u0005\u0002Bs&\u0011!P\u0011\u0002\u0005+:LG\u000f\u000b\u0002\u000byB\u0019Q0!\u0003\u000e\u0003yT1a`A\u0001\u0003\r\t\u0007/\u001b\u0006\u0005\u0003\u0007\t)!A\u0004kkBLG/\u001a:\u000b\u0007\u0005\u001d1+A\u0003kk:LG/C\u0002\u0002\fy\u0014A\u0001V3ti\u0006)3\u000f[8vY\u0012\fE\rZ#q_\u000eD\u0017I\u001c3NKN\u001c\u0018mZ3PM\u001a\u001cX\r\u001e+p\u0007\u0006\u001c\u0007.\u001a\u0015\u0003\u0017q\faf\u001d5pk2$'+\u001a;ve:dunZ#oI>3gm]3u\u0013\u001ad\u0015\r^3ti\u0016\u0003xn\u00195SKF,Xm\u001d;fI\"\u0012A\u0002`\u00015g\"|W\u000f\u001c3SKR,(O\\+oI\u00164\u0017N\\3e\u001f\u001a47/\u001a;JMVsG-\u001a4j]\u0016$W\t]8dQJ+\u0017/^3ti\u0016$\u0007FA\u0007}\u0003\t\u001b\bn\\;mI:{Go\u0014<fe^\u0014\u0018\u000e^3M_\u001e,e\u000eZ(gMN,GOR8s\u00032+\u0017\rZ3s\u000bB|7\r[(oG\u0016LE\u000fS1t\u0005\u0016,g.Q:tS\u001etW\r\u001a\u0015\u0003\u001dq\f\u0001g\u001d5pk2$WI\u001c4pe\u000e,Wj\u001c8pi>t\u0017nY1mYfLen\u0019:fCNLgnZ*uCJ$xJ\u001a4tKR\u001c\bFA\b}\u0003q\u001a\bn\\;mI:{Go\u0014<fe^\u0014\u0018\u000e^3PM\u001a\u001cX\r\u001e$pe\u0006cU-\u00193fe\u0016\u0003xn\u00195P]\u000e,\u0017\n\u001e%bg\n+WM\\!tg&<g.\u001a3)\u0005Aa\u0018\u0001K:i_VdGMU3ukJtWK\\:vaB|'\u000f^3e\u0013\u001atu.\u00129pG\"\u0014VmY8sI\u0016$\u0007FA\t}\u0003\t\u001b\bn\\;mIJ+G/\u001e:o+:\u001cX\u000f\u001d9peR,G-\u00134O_\u0016\u0003xn\u00195SK\u000e|'\u000fZ3e\u0003:$WK\u001c3fM&tW\rZ#q_\u000eD'+Z9vKN$X\r\u001a\u0015\u0003%q\f\u0001h\u001d5pk2$'+\u001a;ve:4\u0015N]:u\u000bB|7\r[%g%\u0016\fX/Z:uK\u0012,\u0005o\\2i\u0019\u0016\u001c8\u000f\u00165b]\u001aK'o\u001d;Fa>\u001c\u0007\u000e\u000b\u0002\u0014y\u0006)4\u000f[8vY\u0012$&/\u001e8dCR,\u0017JZ'bi\u000eD\u0017N\\4Fa>\u001c\u0007NQ;u\u000b\u0006\u0014H.[3s'R\f'\u000f^5oO>3gm]3uQ\t!B0\u0001%tQ>,H\u000eZ$fi\u001aK'o\u001d;PM\u001a\u001cX\r^(g'V\u00147/Z9vK:$X\t]8dQ^CWM\\(gMN,GOU3rk\u0016\u001cH/\u001a3G_J\u0004&/\u001a<j_V\u001cX\t]8dQ\"\u0012Q\u0003`\u0001Fg\"|W\u000f\u001c3SKR,(O\u001c(fqR\fe/Y5mC\ndW-\u00129pG\"Le\r\u00165fe\u0016L5OT8Fq\u0006\u001cG/\u00129pG\"4uN\u001d+iK>sWMU3rk\u0016\u001cH/\u001a3)\u0005Ya\u0018AM:i_VdGMT8u+B$\u0017\r^3Fa>\u001c\u0007.\u00118e'R\f'\u000f^(gMN,G/\u00134Ji\u0012KGMT8u\u0007\"\fgnZ3)\u0005]a\u0018!R:i_VdGMU3ukJt\u0017J\u001c<bY&$wJ\u001a4tKRLe-\u00129pG\"L5OU3rk\u0016\u001cH/\u001a3XQ&\u001c\u0007.S:O_R\u001cUO\u001d:f]Rd\u0017\u0010\u0016:bG.,G\r\u000b\u0002\u0019y\u0006I3\u000f[8vY\u0012\u001cV\u000f\u001d9peR,\u0005o\\2igRC\u0017\r\u001e#p\u001d>$8\u000b^1si\u001a\u0013x.\u001c.fe>D#!\u0007?\u0002GMDw.\u001e7e!\u0016\u00148/[:u\u000bB|7\r[:CKR<X-\u001a8J]N$\u0018M\\2fg\"\u0012!\u0004`\u0001+g\"|W\u000f\u001c3F]\u001a|'oY3N_:|Go\u001c8jG\u0006dG._%oGJ,\u0017m]5oO\u0016\u0003xn\u00195tQ\tYB0A\u0004u_R+\b\u000f\\3\u0016\r\u0005U\u0013\u0011MA;)\u0011\t9&!\u001f\u0011\u000f\u0005\u000bI&!\u0018\u0002t%\u0019\u00111\f\"\u0003\rQ+\b\u000f\\33!\u0011\ty&!\u0019\r\u0001\u00119\u00111\r\u000fC\u0002\u0005\u0015$!A&\u0012\t\u0005\u001d\u0014Q\u000e\t\u0004\u0003\u0006%\u0014bAA6\u0005\n9aj\u001c;iS:<\u0007cA!\u0002p%\u0019\u0011\u0011\u000f\"\u0003\u0007\u0005s\u0017\u0010\u0005\u0003\u0002`\u0005UDaBA<9\t\u0007\u0011Q\r\u0002\u0002-\"9\u00111\u0010\u000fA\u0002\u0005u\u0014!B3oiJL\b\u0003CA@\u00033\u000bi&a\u001d\u000f\t\u0005\u0005\u00151\u0013\b\u0005\u0003\u0007\u000byI\u0004\u0003\u0002\u0006\u0006-UBAAD\u0015\r\tIIP\u0001\u0007yI|w\u000e\u001e \n\u0005\u00055\u0015\u0001\u00026bm\u0006L1!XAI\u0015\t\ti)\u0003\u0003\u0002\u0016\u0006]\u0015aA'ba*\u0019Q,!%\n\t\u0005m\u0015Q\u0014\u0002\u0006\u000b:$(/\u001f\u0006\u0005\u0003+\u000b9*A\u0015tQ>,H\u000eZ#oM>\u00148-Z(gMN,Go]%oGJ,\u0017m]3N_:|Go\u001c8jG\u0006dG.\u001f\u0015\u0003;q\fAg\u001d5pk2$\u0017J\\2sK\u0006\u001cX-\u00118e)J\f7m[#q_\u000eD7/Q:MK\u0006$WM]:DQ\u0006tw-Z'b]f$\u0016.\\3tQ\tqB0\u0001\u001etQ>,H\u000eZ%oGJ,\u0017m]3B]\u0012$&/Y2l\u000bB|7\r[:Bg\u001a{G\u000e\\8xKJ\u0014VmY3jm\u0016\u001cX*\u00198z\u001b\u0016\u001c8/Y4fg\"\u0012q\u0004`\u0001:g\"|W\u000f\u001c3Ee>\u0004XI\u001c;sS\u0016\u001cxJ\\#q_\u000eD'i\\;oI\u0006\u0014\u0018p\u00165f]J+Wn\u001c<j]\u001ed\u0015\r^3ti\u0016sGO]5fg\"\u0012\u0001\u0005`\u00014g\"|W\u000f\u001c3Qe\u0016\u001cXM\u001d<f%\u0016\u001cX\r^(gMN,Go\u00148DY\u0016\f'/R1sY&,7\u000f^%g\u001f:,W\t_5tiND#!\t?\u0002sMDw.\u001e7e+B$\u0017\r^3TCZ,Gm\u00144gg\u0016$x\u000b[3o\u001f\u001a47/\u001a;U_\u000ecW-\u0019:U_&\u001b()\u001a;xK\u0016tW\t]8dQND#A\t?\u0002KMDw.\u001e7e\u001d>$8\t\\3be\u0006s\u0017\u0010\u001e5j]\u001eLem\u00144gg\u0016$Hk\\#be2L\bFA\u0012}\u0003-\u001a\bn\\;mI:{Go\u00117fCJ\fe.\u001f;iS:<\u0017JZ(gMN,G\u000fV8GSJ\u001cHo\u00144gg\u0016$\bF\u0001\u0013}\u0003%\u001a\bn\\;mIJ+G/Y5o\u0019\u0006$Xm\u001d;Fa>\u001c\u0007n\u00148DY\u0016\f'/\u00117m\u000b\u0006\u0014H.[3ti\"\u0012Q\u0005`\u00018g\"|W\u000f\u001c3Va\u0012\fG/Z(gMN,GOQ3uo\u0016,g.\u00129pG\"\u0014u.\u001e8eCJLWm](o\u00072,\u0017M]#be2LWm\u001d;)\u0005\u0019b\u0018\u0001O:i_VdG-\u00169eCR,wJ\u001a4tKR\u0014U\r^<fK:,\u0005o\\2i\u0005>,h\u000eZ1sS\u0016\u001cxJ\\\"mK\u0006\u0014X)\u0019:mS\u0016\u001cHO\r\u0015\u0003Oq\f1h\u001d5pk2$'+\u001a;bS:d\u0015\r^3ti\u0016\u0003xn\u00195P]\u000ecW-\u0019:BY2,\u0015M\u001d7jKN$\u0018I\u001c3Va\u0012\fG/Z%ug>3gm]3uQ\tAC0A\u001ctQ>,H\u000e\u001a#s_B,e\u000e\u001e:jKN\u0014U\r^<fK:,\u0005o\\2i\u0005>,h\u000eZ1ss^CWM\u001c*f[>4\u0018N\\4OK^,7\u000f\u001e\u0015\u0003Sq\fQc\u001d5pk2$7\t\\3be\u0006cG.\u00128ue&,7\u000f\u000b\u0002+y\u0006y3\u000f[8vY\u0012tu\u000e\u001e*fg\u0016$X\t]8dQ\"K7\u000f^8ss\"+\u0017\rZ%g+:$WMZ5oK\u0012\u0004\u0016m]:fI\"\u00121\u0006`\u00010g\"|W\u000f\u001c3O_R\u0014Vm]3u\u000bB|7\r\u001b%jgR|'/\u001f+bS2Le-\u00168eK\u001aLg.\u001a3QCN\u001cX\r\u001a\u0015\u0003Yq\f!e\u001d5pk2$g)\u001a;dQ2\u000bG/Z:u\u000bB|7\r[(g\u000b6\u0004H/_\"bG\",\u0007FA\u0017}\u0003\u0001\u001a\bn\\;mI\u001a+Go\u00195F]\u0012|eMZ:fi>3W)\u001c9us\u000e\u000b7\r[3)\u00059b\u0018aH:i_VdGm\u00117fCJ,\u0015M\u001d7jKN$xJ\\#naRL8)Y2iK\"\u0012q\u0006`\u0001\u001eg\"|W\u000f\u001c3DY\u0016\f'\u000fT1uKN$xJ\\#naRL8)Y2iK\"\u0012\u0001\u0007`\u0001\u0016i\u0016\u001cHOR5oIB\u0013XM^5pkN,\u0005o\\2iQ\t\tD0A\u000buKN$h)\u001b8e!J,g/[8vg\u0016sGO]=)\u0005Ib\u0018!\u0005;fgR4\u0015N\u001c3OKb$X\t]8dQ\"\u00121\u0007`\u0001\u0012i\u0016\u001cHoR3u\u000bB|7\r[#oiJL\bF\u0001\u001b}\u0003y\u0019\bn\\;mI\u001a+Go\u00195Fa>\u001c\u0007NR8s\u000f&4XM\\(gMN,G\u000f\u000b\u00026y\u0006\t3\u000f[8vY\u0012<&/\u001b;f\u0007\",7m\u001b9pS:$xJ\u001c+sk:\u001c\u0017\r^5p]\"\u0012a\u0007 ")
public class LeaderEpochFileCacheTest {
    private final TopicPartition tp = new TopicPartition("TestTopic", 5);
    private final MockTime mockTime = new MockTime();
    private final LeaderEpochCheckpointFile checkpoint = new LeaderEpochCheckpointFile(TestUtils.tempFile((String)"kafka", (String)".tmp"), new LogDirFailureChannel(1));
    private final LeaderEpochFileCache cache;

    public TopicPartition tp() {
        return this.tp;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    private LeaderEpochCheckpointFile checkpoint() {
        return this.checkpoint;
    }

    private LeaderEpochFileCache cache() {
        return this.cache;
    }

    @Test
    public void testPreviousEpoch() {
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().previousEpoch());
        this.cache().assign(2, 10L);
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().previousEpoch());
        this.cache().assign(4, 15L);
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().previousEpoch());
        this.cache().assign(10, 20L);
        Assertions.assertEquals((Object)OptionalInt.of(4), (Object)this.cache().previousEpoch());
        this.cache().truncateFromEndAsyncFlush(18L);
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().previousEpoch());
    }

    @Test
    public void shouldAddEpochAndMessageOffsetToCache() {
        this.cache().assign(2, 10L);
        int logEndOffset = 11;
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)2)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new EpochEntry(2, 10L), this.cache().epochEntries().get(0));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), this.toTuple(this.cache().endOffsetFor(2, (long)logEndOffset)));
    }

    @Test
    public void shouldReturnLogEndOffsetIfLatestEpochRequested() {
        this.cache().assign(2, 11L);
        this.cache().assign(2, 12L);
        int logEndOffset = 14;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), this.toTuple(this.cache().endOffsetFor(2, (long)logEndOffset)));
    }

    @Test
    public void shouldReturnUndefinedOffsetIfUndefinedEpochRequested() {
        Tuple2.mcIJ.sp expectedEpochEndOffset = new Tuple2.mcIJ.sp(-1, -1L);
        this.cache().assign(2, 11L);
        this.cache().assign(3, 12L);
        Tuple2 epochAndOffsetFor = this.toTuple(this.cache().endOffsetFor(-1, 0L));
        Assertions.assertEquals((Object)expectedEpochEndOffset, epochAndOffsetFor, (String)"Expected undefined epoch and offset if undefined epoch requested. Cache not empty.");
    }

    @Test
    public void shouldNotOverwriteLogEndOffsetForALeaderEpochOnceItHasBeenAssigned() {
        int logEndOffset = 9;
        this.cache().assign(2, (long)logEndOffset);
        this.cache().assign(2, 10L);
        Assertions.assertEquals((long)logEndOffset, (long)((EpochEntry)this.cache().epochEntries().get((int)0)).startOffset);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(2, 9L)), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldEnforceMonotonicallyIncreasingStartOffsets() {
        this.cache().assign(2, 9L);
        this.cache().assign(3, 9L);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(3, 9L)), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotOverwriteOffsetForALeaderEpochOnceItHasBeenAssigned() {
        this.cache().assign(2, 6L);
        this.cache().assign(2, 10L);
        Assertions.assertEquals((long)6L, (long)((EpochEntry)this.cache().epochEntries().get((int)0)).startOffset);
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecorded() {
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), this.toTuple(this.cache().endOffsetFor(0, 0L)));
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecordedAndUndefinedEpochRequested() {
        Tuple2 offsetFor = this.toTuple(this.cache().endOffsetFor(-1, 73L));
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), offsetFor, (String)"Expected undefined epoch and offset if undefined epoch requested. Empty cache.");
    }

    @Test
    public void shouldReturnFirstEpochIfRequestedEpochLessThanFirstEpoch() {
        this.cache().assign(5, 11L);
        this.cache().assign(6, 12L);
        this.cache().assign(7, 13L);
        Tuple2 epochAndOffset = this.toTuple(this.cache().endOffsetFor(4, 0L));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(4, 11), epochAndOffset);
    }

    @Test
    public void shouldTruncateIfMatchingEpochButEarlierStartingOffset() {
        this.cache().assign(5, 11L);
        this.cache().assign(6, 12L);
        this.cache().assign(7, 13L);
        this.cache().assign(7, 12L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(5, 12), this.toTuple(this.cache().endOffsetFor(5, 0L)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(5, 12), this.toTuple(this.cache().endOffsetFor(6, 0L)));
    }

    @Test
    public void shouldGetFirstOffsetOfSubsequentEpochWhenOffsetRequestedForPreviousEpoch() {
        this.cache().assign(1, 11L);
        this.cache().assign(1, 12L);
        this.cache().assign(2, 13L);
        this.cache().assign(2, 14L);
        this.cache().assign(3, 15L);
        this.cache().assign(3, 16L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 15), this.toTuple(this.cache().endOffsetFor(2, 17L)));
    }

    @Test
    public void shouldReturnNextAvailableEpochIfThereIsNoExactEpochForTheOneRequested() {
        this.cache().assign(0, 10L);
        this.cache().assign(2, 13L);
        this.cache().assign(4, 17L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 13), this.toTuple(this.cache().endOffsetFor(1, 0L)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 17), this.toTuple(this.cache().endOffsetFor(2, 0L)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 17), this.toTuple(this.cache().endOffsetFor(3, 0L)));
    }

    @Test
    public void shouldNotUpdateEpochAndStartOffsetIfItDidNotChange() {
        this.cache().assign(2, 6L);
        this.cache().assign(2, 7L);
        Assertions.assertEquals((int)1, (int)this.cache().epochEntries().size());
        Assertions.assertEquals((Object)new EpochEntry(2, 6L), this.cache().epochEntries().get(0));
    }

    @Test
    public void shouldReturnInvalidOffsetIfEpochIsRequestedWhichIsNotCurrentlyTracked() {
        this.cache().assign(2, 100L);
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), this.toTuple(this.cache().endOffsetFor(3, 100L)));
    }

    @Test
    public void shouldSupportEpochsThatDoNotStartFromZero() {
        this.cache().assign(2, 6L);
        int logEndOffset = 7;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), this.toTuple(this.cache().endOffsetFor(2, (long)logEndOffset)));
        Assertions.assertEquals((int)1, (int)this.cache().epochEntries().size());
        Assertions.assertEquals((Object)new EpochEntry(2, 6L), this.cache().epochEntries().get(0));
    }

    @Test
    public void shouldPersistEpochsBetweenInstances() {
        String checkpointPath = TestUtils.tempFile((String)"kafka", (String)".tmp").getAbsolutePath();
        LeaderEpochCheckpointFile checkpoint = new LeaderEpochCheckpointFile(new File(checkpointPath), new LogDirFailureChannel(1));
        new LeaderEpochFileCache(this.tp(), checkpoint, (Scheduler)new MockTime().scheduler).assign(2, 6L);
        LeaderEpochCheckpointFile checkpoint2 = new LeaderEpochCheckpointFile(new File(checkpointPath), new LogDirFailureChannel(1));
        LeaderEpochFileCache cache2 = new LeaderEpochFileCache(this.tp(), checkpoint2, (Scheduler)new MockTime().scheduler);
        Assertions.assertEquals((int)1, (int)cache2.epochEntries().size());
        Assertions.assertEquals((Object)new EpochEntry(2, 6L), cache2.epochEntries().get(0));
    }

    @Test
    public void shouldEnforceMonotonicallyIncreasingEpochs() {
        this.cache().assign(1, 5L);
        this.cache().assign(2, 6L);
        this.cache().assign(1, 7L);
        int logEndOffset = 8;
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)1)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 8), this.toTuple(this.cache().endOffsetFor(1, (long)logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), this.toTuple(this.cache().endOffsetFor(2, (long)logEndOffset)));
        Assertions.assertEquals((Object)new EpochEntry(1, 7L), this.cache().epochEntries().get(0));
    }

    private <K, V> Tuple2<K, V> toTuple(Map.Entry<K, V> entry) {
        return new Tuple2(entry.getKey(), entry.getValue());
    }

    @Test
    public void shouldEnforceOffsetsIncreaseMonotonically() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 5L);
        Assertions.assertEquals((Object)new EpochEntry(3, 5L), this.cache().epochEntries().get(0));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsLeadersChangeManyTimes() {
        long logEndOffset = 0L;
        this.cache().assign(0, 0L);
        this.cache().assign(1, 0L);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)1)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 0), this.toTuple(this.cache().endOffsetFor(1, logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), this.toTuple(this.cache().endOffsetFor(0, logEndOffset)));
        logEndOffset = 5L;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 5), this.toTuple(this.cache().endOffsetFor(1, logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), this.toTuple(this.cache().endOffsetFor(0, logEndOffset)));
        this.cache().assign(2, 5L);
        logEndOffset = 10L;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 10), this.toTuple(this.cache().endOffsetFor(2, logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 5), this.toTuple(this.cache().endOffsetFor(1, logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), this.toTuple(this.cache().endOffsetFor(0, logEndOffset)));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsFollowerReceivesManyMessages() {
        this.cache().assign(0, 0L);
        this.cache().assign(0, 1L);
        this.cache().assign(0, 2L);
        int logEndOffset = 3;
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)0)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, logEndOffset), this.toTuple(this.cache().endOffsetFor(0, (long)logEndOffset)));
        this.cache().assign(1, 3L);
        this.cache().assign(1, 4L);
        this.cache().assign(1, 5L);
        logEndOffset = 6;
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)1)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, logEndOffset), this.toTuple(this.cache().endOffsetFor(1, (long)logEndOffset)));
        this.cache().assign(2, 6L);
        this.cache().assign(2, 7L);
        this.cache().assign(2, 8L);
        logEndOffset = 9;
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)2)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), this.toTuple(this.cache().endOffsetFor(2, (long)logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 3), this.toTuple(this.cache().endOffsetFor(0, (long)logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 6), this.toTuple(this.cache().endOffsetFor(1, (long)logEndOffset)));
    }

    @Test
    public void shouldDropEntriesOnEpochBoundaryWhenRemovingLatestEntries() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEndAsyncFlush(8L);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(2, 6L)), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldPreserveResetOffsetOnClearEarliestIfOneExists() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStartAsyncFlush(8L);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(3, 8L), new EpochEntry(4, 11L)), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldUpdateSavedOffsetWhenOffsetToClearToIsBetweenEpochs() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStartAsyncFlush(9L);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(3, 9L), new EpochEntry(4, 11L)), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToEarly() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStartAsyncFlush(1L);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToFirstOffset() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStartAsyncFlush(6L);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStartAsyncFlush(11L);
        Assertions.assertEquals(Collections.singletonList(new EpochEntry(4, 11L)), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStartAsyncFlush(9L);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(3, 9L), new EpochEntry(4, 11L)), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest2() {
        this.cache().assign(0, 0L);
        this.cache().assign(1, 7L);
        this.cache().assign(2, 10L);
        this.cache().truncateFromStartAsyncFlush(5L);
        Assertions.assertEquals(Arrays.asList(new EpochEntry(0, 5L), new EpochEntry(1, 7L), new EpochEntry(2, 10L)), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliestAndUpdateItsOffset() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStartAsyncFlush(15L);
        Assertions.assertEquals(Collections.singletonList(new EpochEntry(4, 15L)), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldDropEntriesBetweenEpochBoundaryWhenRemovingNewest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEndAsyncFlush(9L);
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)3)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals(Arrays.asList(new EpochEntry(2, 6L), new EpochEntry(3, 8L)), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldClearAllEntries() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().clearAndFlush();
        Assertions.assertEquals((int)0, (int)this.cache().epochEntries().size());
    }

    @Test
    public void shouldNotResetEpochHistoryHeadIfUndefinedPassed() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStartAsyncFlush(-1L);
        Assertions.assertEquals((int)3, (int)this.cache().epochEntries().size());
    }

    @Test
    public void shouldNotResetEpochHistoryTailIfUndefinedPassed() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEndAsyncFlush(-1L);
        Assertions.assertEquals((int)3, (int)this.cache().epochEntries().size());
    }

    @Test
    public void shouldFetchLatestEpochOfEmptyCache() {
        Assertions.assertEquals(Optional.empty(), (Object)this.cache().latestEpoch());
    }

    @Test
    public void shouldFetchEndOffsetOfEmptyCache() {
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), this.toTuple(this.cache().endOffsetFor(7, 0L)));
    }

    @Test
    public void shouldClearEarliestOnEmptyCache() {
        this.cache().truncateFromStartAsyncFlush(7L);
    }

    @Test
    public void shouldClearLatestOnEmptyCache() {
        this.cache().truncateFromEndAsyncFlush(7L);
    }

    @Test
    public void testFindPreviousEpoch() {
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().previousEpoch(2));
        this.cache().assign(2, 10L);
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().previousEpoch(2));
        this.cache().assign(4, 15L);
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().previousEpoch(4));
        this.cache().assign(10, 20L);
        Assertions.assertEquals((Object)OptionalInt.of(4), (Object)this.cache().previousEpoch(10));
        this.cache().truncateFromEndAsyncFlush(18L);
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().previousEpoch(Predef$.MODULE$.Integer2int((Integer)this.cache().latestEpoch().get())));
    }

    @Test
    public void testFindPreviousEntry() {
        Assertions.assertEquals(Optional.empty(), (Object)this.cache().previousEntry(2));
        this.cache().assign(2, 10L);
        Assertions.assertEquals(Optional.empty(), (Object)this.cache().previousEntry(2));
        this.cache().assign(4, 15L);
        Assertions.assertEquals(Optional.of(new EpochEntry(2, 10L)), (Object)this.cache().previousEntry(4));
        this.cache().assign(10, 20L);
        Assertions.assertEquals(Optional.of(new EpochEntry(4, 15L)), (Object)this.cache().previousEntry(10));
        this.cache().truncateFromEndAsyncFlush(18L);
        Assertions.assertEquals(Optional.of(new EpochEntry(2, 10L)), (Object)this.cache().previousEntry(Predef$.MODULE$.Integer2int((Integer)this.cache().latestEpoch().get())));
    }

    @Test
    public void testFindNextEpoch() {
        this.cache().assign(0, 0L);
        this.cache().assign(1, 100L);
        this.cache().assign(2, 200L);
        Assertions.assertEquals((Object)OptionalInt.of(0), (Object)this.cache().nextEpoch(-1));
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)this.cache().nextEpoch(0));
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().nextEpoch(1));
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().nextEpoch(2));
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().nextEpoch(100));
    }

    @Test
    public void testGetEpochEntry() {
        this.cache().assign(2, 100L);
        this.cache().assign(3, 500L);
        this.cache().assign(5, 1000L);
        Assertions.assertEquals((Object)new EpochEntry(2, 100L), this.cache().epochEntry(2).get());
        Assertions.assertEquals((Object)new EpochEntry(3, 500L), this.cache().epochEntry(3).get());
        Assertions.assertEquals((Object)new EpochEntry(5, 1000L), this.cache().epochEntry(5).get());
    }

    @Test
    public void shouldFetchEpochForGivenOffset() {
        this.cache().assign(0, 10L);
        this.cache().assign(1, 20L);
        this.cache().assign(5, 30L);
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)this.cache().epochForOffset(25L));
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)this.cache().epochForOffset(20L));
        Assertions.assertEquals((Object)OptionalInt.of(5), (Object)this.cache().epochForOffset(30L));
        Assertions.assertEquals((Object)OptionalInt.of(5), (Object)this.cache().epochForOffset(50L));
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().epochForOffset(5L));
    }

    @Test
    public void shouldWriteCheckpointOnTruncation() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEndAsyncFlush(11L);
        this.cache().truncateFromStartAsyncFlush(8L);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new EpochEntry(3, 8L), (List)Nil$.MODULE$)).asJava(), (Object)this.checkpoint().read());
    }

    public LeaderEpochFileCacheTest() {
        this.cache = new LeaderEpochFileCache(this.tp(), this.checkpoint(), (Scheduler)this.mockTime().scheduler);
    }
}

