/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.logger;

import java.util.List;
import kafka.server.logger.RuntimeLoggerManager;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeLoggerManagerTest {
    private static final Logger LOG = LoggerFactory.getLogger(RuntimeLoggerManagerTest.class);
    private static final RuntimeLoggerManager MANAGER = new RuntimeLoggerManager(5, LOG);

    @Test
    public void testValidateSetLogLevelConfig() {
        MANAGER.validateLogLevelConfigs(List.of(new IncrementalAlterConfigsRequestData.AlterableConfig().setName(LOG.getName()).setConfigOperation(AlterConfigOp.OpType.SET.id()).setValue("TRACE")));
    }

    @Test
    public void testValidateDeleteLogLevelConfig() {
        MANAGER.validateLogLevelConfigs(List.of(new IncrementalAlterConfigsRequestData.AlterableConfig().setName(LOG.getName()).setConfigOperation(AlterConfigOp.OpType.DELETE.id()).setValue("")));
    }

    @ParameterizedTest
    @ValueSource(bytes={2, 3})
    public void testOperationNotAllowed(byte id) {
        AlterConfigOp.OpType opType = AlterConfigOp.OpType.forId((byte)id);
        Assertions.assertEquals((Object)(String.valueOf(opType) + " operation is not allowed for the BROKER_LOGGER resource"), (Object)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> MANAGER.validateLogLevelConfigs(List.of(new IncrementalAlterConfigsRequestData.AlterableConfig().setName(LOG.getName()).setConfigOperation(id).setValue("TRACE"))))).getMessage());
    }

    @Test
    public void testValidateBogusLogLevelNameNotAllowed() {
        Assertions.assertEquals((Object)("Cannot set the log level of " + LOG.getName() + " to BOGUS as it is not a supported log level. Valid log levels are DEBUG, ERROR, FATAL, INFO, TRACE, WARN"), (Object)((InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> MANAGER.validateLogLevelConfigs(List.of(new IncrementalAlterConfigsRequestData.AlterableConfig().setName(LOG.getName()).setConfigOperation(AlterConfigOp.OpType.SET.id()).setValue("BOGUS"))))).getMessage());
    }

    @Test
    public void testValidateSetRootLogLevelConfig() {
        MANAGER.validateLogLevelConfigs(List.of(new IncrementalAlterConfigsRequestData.AlterableConfig().setName("root").setConfigOperation(AlterConfigOp.OpType.SET.id()).setValue("TRACE")));
    }

    @Test
    public void testValidateRemoveRootLogLevelConfigNotAllowed() {
        Assertions.assertEquals((Object)"Removing the log level of the root logger is not allowed", (Object)((InvalidRequestException)Assertions.assertThrows(InvalidRequestException.class, () -> MANAGER.validateLogLevelConfigs(List.of(new IncrementalAlterConfigsRequestData.AlterableConfig().setName("root").setConfigOperation(AlterConfigOp.OpType.DELETE.id()).setValue(""))))).getMessage());
    }
}

