/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.share;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import kafka.server.share.ShareCoordinatorMetadataCacheHelperImpl;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.CoordinatorNotAvailableException;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.server.share.SharePartitionKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ShareCoordinatorMetadataCacheHelperImplTest {
    @Test
    public void testConstructorThrowsErrorOnNullArgs() {
        Function<SharePartitionKey, Integer> func = sharePartitionKey -> 0;
        Exception e = (Exception)Assertions.assertThrows(NullPointerException.class, () -> new ShareCoordinatorMetadataCacheHelperImpl(null, func, (ListenerName)Mockito.mock(ListenerName.class)));
        Assertions.assertEquals((Object)"metadataCache must not be null", (Object)e.getMessage());
        e = (Exception)Assertions.assertThrows(NullPointerException.class, () -> new ShareCoordinatorMetadataCacheHelperImpl((MetadataCache)Mockito.mock(MetadataCache.class), null, (ListenerName)Mockito.mock(ListenerName.class)));
        Assertions.assertEquals((Object)"keyToPartitionMapper must not be null", (Object)e.getMessage());
        e = (Exception)Assertions.assertThrows(NullPointerException.class, () -> new ShareCoordinatorMetadataCacheHelperImpl((MetadataCache)Mockito.mock(MetadataCache.class), func, null));
        Assertions.assertEquals((Object)"interBrokerListenerName must not be null", (Object)e.getMessage());
    }

    @Test
    public void testContainsTopicReturnsFalseOnException() {
        Function<SharePartitionKey, Integer> func = sharePartitionKey -> 0;
        MetadataCache mockMetadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        Mockito.when((Object)mockMetadataCache.contains((String)ArgumentMatchers.eq((Object)"__share_group_state"))).thenReturn((Object)false);
        ShareCoordinatorMetadataCacheHelperImpl cache = new ShareCoordinatorMetadataCacheHelperImpl(mockMetadataCache, func, (ListenerName)Mockito.mock(ListenerName.class));
        Mockito.when((Object)mockMetadataCache.contains((String)ArgumentMatchers.eq((Object)"__share_group_state"))).thenThrow(new Throwable[]{new RuntimeException("bad stuff")});
        Assertions.assertFalse((boolean)cache.containsTopic("__share_group_state"));
        ((MetadataCache)Mockito.verify((Object)mockMetadataCache, (VerificationMode)Mockito.times((int)1))).contains("__share_group_state");
    }

    @Test
    public void testContainsTopicSuccess() {
        Function<SharePartitionKey, Integer> func = sharePartitionKey -> 0;
        MetadataCache mockMetadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        Mockito.when((Object)mockMetadataCache.contains((String)ArgumentMatchers.eq((Object)"__share_group_state"))).thenReturn((Object)false);
        ShareCoordinatorMetadataCacheHelperImpl cache = new ShareCoordinatorMetadataCacheHelperImpl(mockMetadataCache, func, (ListenerName)Mockito.mock(ListenerName.class));
        Mockito.when((Object)mockMetadataCache.contains((String)ArgumentMatchers.eq((Object)"__share_group_state"))).thenReturn((Object)true);
        Assertions.assertTrue((boolean)cache.containsTopic("__share_group_state"));
        ((MetadataCache)Mockito.verify((Object)mockMetadataCache, (VerificationMode)Mockito.times((int)1))).contains("__share_group_state");
    }

    @Test
    public void testShareCoordinatorReturnsNoNodeWhenNoInternalTopicInCache() {
        Function<SharePartitionKey, Integer> func = sharePartitionKey -> 0;
        MetadataCache mockMetadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        Mockito.when((Object)mockMetadataCache.contains((String)ArgumentMatchers.eq((Object)"__share_group_state"))).thenReturn((Object)false);
        ShareCoordinatorMetadataCacheHelperImpl cache = new ShareCoordinatorMetadataCacheHelperImpl(mockMetadataCache, func, (ListenerName)Mockito.mock(ListenerName.class));
        Assertions.assertEquals((Object)Node.noNode(), (Object)cache.getShareCoordinator(SharePartitionKey.getInstance((String)"group", (Uuid)Uuid.randomUuid(), (int)0), "__share_group_state"));
        ((MetadataCache)Mockito.verify((Object)mockMetadataCache, (VerificationMode)Mockito.times((int)1))).contains((String)ArgumentMatchers.eq((Object)"__share_group_state"));
    }

    @Test
    public void testShareCoordinatorReturnsNoNodeIfTopicMetadataInvalid() {
        Function<SharePartitionKey, Integer> func = sharePartitionKey -> 0;
        MetadataCache mockMetadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        ListenerName mockListenerName = (ListenerName)Mockito.mock(ListenerName.class);
        ShareCoordinatorMetadataCacheHelperImpl cache = new ShareCoordinatorMetadataCacheHelperImpl(mockMetadataCache, func, mockListenerName);
        Mockito.when((Object)mockMetadataCache.contains((String)ArgumentMatchers.eq((Object)"__share_group_state"))).thenReturn((Object)true);
        Mockito.when((Object)mockMetadataCache.getTopicMetadata((Set)ArgumentMatchers.any(), (ListenerName)ArgumentMatchers.eq((Object)mockListenerName), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false))).thenReturn(null);
        Assertions.assertEquals((Object)Node.noNode(), (Object)cache.getShareCoordinator(SharePartitionKey.getInstance((String)"group", (Uuid)Uuid.randomUuid(), (int)0), "__share_group_state"));
        ((MetadataCache)Mockito.verify((Object)mockMetadataCache, (VerificationMode)Mockito.times((int)1))).contains((String)ArgumentMatchers.eq((Object)"__share_group_state"));
        ((MetadataCache)Mockito.verify((Object)mockMetadataCache, (VerificationMode)Mockito.times((int)1))).getTopicMetadata((Set)ArgumentMatchers.any(), (ListenerName)ArgumentMatchers.eq((Object)mockListenerName), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false));
        Mockito.when((Object)mockMetadataCache.getTopicMetadata((Set)ArgumentMatchers.any(), (ListenerName)ArgumentMatchers.eq((Object)mockListenerName), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false))).thenReturn(List.of());
        Assertions.assertEquals((Object)Node.noNode(), (Object)cache.getShareCoordinator(SharePartitionKey.getInstance((String)"group", (Uuid)Uuid.randomUuid(), (int)0), "__share_group_state"));
        ((MetadataCache)Mockito.verify((Object)mockMetadataCache, (VerificationMode)Mockito.times((int)2))).contains((String)ArgumentMatchers.eq((Object)"__share_group_state"));
        ((MetadataCache)Mockito.verify((Object)mockMetadataCache, (VerificationMode)Mockito.times((int)2))).getTopicMetadata((Set)ArgumentMatchers.any(), (ListenerName)ArgumentMatchers.eq((Object)mockListenerName), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false));
        Mockito.when((Object)mockMetadataCache.getTopicMetadata((Set)ArgumentMatchers.any(), (ListenerName)ArgumentMatchers.eq((Object)mockListenerName), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false))).thenReturn(List.of(new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.BROKER_NOT_AVAILABLE.code())));
        Assertions.assertEquals((Object)Node.noNode(), (Object)cache.getShareCoordinator(SharePartitionKey.getInstance((String)"group", (Uuid)Uuid.randomUuid(), (int)0), "__share_group_state"));
        ((MetadataCache)Mockito.verify((Object)mockMetadataCache, (VerificationMode)Mockito.times((int)3))).contains((String)ArgumentMatchers.eq((Object)"__share_group_state"));
        ((MetadataCache)Mockito.verify((Object)mockMetadataCache, (VerificationMode)Mockito.times((int)3))).getTopicMetadata((Set)ArgumentMatchers.any(), (ListenerName)ArgumentMatchers.eq((Object)mockListenerName), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void testShareCoordinatorReturnsNoNodeOnGetAliveNodeEmptyResponse() {
        Function<SharePartitionKey, Integer> func = sharePartitionKey -> 0;
        MetadataCache mockMetadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        ListenerName mockListenerName = (ListenerName)Mockito.mock(ListenerName.class);
        ShareCoordinatorMetadataCacheHelperImpl cache = new ShareCoordinatorMetadataCacheHelperImpl(mockMetadataCache, func, mockListenerName);
        Mockito.when((Object)mockMetadataCache.contains((String)ArgumentMatchers.eq((Object)"__share_group_state"))).thenReturn((Object)true);
        Mockito.when((Object)mockMetadataCache.getTopicMetadata((Set)ArgumentMatchers.any(), (ListenerName)ArgumentMatchers.eq((Object)mockListenerName), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false))).thenReturn(List.of(new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setPartitions(List.of(new MetadataResponseData.MetadataResponsePartition().setPartitionIndex(0).setLeaderId(1)))));
        Mockito.when((Object)mockMetadataCache.getAliveBrokerNode(ArgumentMatchers.eq((int)1), (ListenerName)ArgumentMatchers.eq((Object)mockListenerName))).thenReturn(Optional.empty());
        Assertions.assertEquals((Object)Node.noNode(), (Object)cache.getShareCoordinator(SharePartitionKey.getInstance((String)"group", (Uuid)Uuid.randomUuid(), (int)0), "__share_group_state"));
        ((MetadataCache)Mockito.verify((Object)mockMetadataCache, (VerificationMode)Mockito.times((int)1))).contains((String)ArgumentMatchers.eq((Object)"__share_group_state"));
        ((MetadataCache)Mockito.verify((Object)mockMetadataCache, (VerificationMode)Mockito.times((int)1))).getTopicMetadata((Set)ArgumentMatchers.any(), (ListenerName)ArgumentMatchers.eq((Object)mockListenerName), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false));
        ((MetadataCache)Mockito.verify((Object)mockMetadataCache, (VerificationMode)Mockito.times((int)1))).getAliveBrokerNode(ArgumentMatchers.eq((int)1), (ListenerName)ArgumentMatchers.eq((Object)mockListenerName));
    }

    @Test
    public void testShareCoordinatorReturnsNoNodeOnGetAliveNodeException() {
        Function<SharePartitionKey, Integer> func = sharePartitionKey -> 0;
        MetadataCache mockMetadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        ListenerName mockListenerName = (ListenerName)Mockito.mock(ListenerName.class);
        ShareCoordinatorMetadataCacheHelperImpl cache = new ShareCoordinatorMetadataCacheHelperImpl(mockMetadataCache, func, mockListenerName);
        Mockito.when((Object)mockMetadataCache.contains((String)ArgumentMatchers.eq((Object)"__share_group_state"))).thenReturn((Object)true);
        Mockito.when((Object)mockMetadataCache.getTopicMetadata((Set)ArgumentMatchers.any(), (ListenerName)ArgumentMatchers.eq((Object)mockListenerName), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false))).thenReturn(List.of(new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setPartitions(List.of(new MetadataResponseData.MetadataResponsePartition().setPartitionIndex(0).setLeaderId(1)))));
        Mockito.when((Object)mockMetadataCache.getAliveBrokerNode(ArgumentMatchers.eq((int)1), (ListenerName)ArgumentMatchers.eq((Object)mockListenerName))).thenThrow(new Throwable[]{new CoordinatorNotAvailableException("bad stuff")});
        Assertions.assertEquals((Object)Node.noNode(), (Object)cache.getShareCoordinator(SharePartitionKey.getInstance((String)"group", (Uuid)Uuid.randomUuid(), (int)0), "__share_group_state"));
        ((MetadataCache)Mockito.verify((Object)mockMetadataCache, (VerificationMode)Mockito.times((int)1))).contains((String)ArgumentMatchers.eq((Object)"__share_group_state"));
        ((MetadataCache)Mockito.verify((Object)mockMetadataCache, (VerificationMode)Mockito.times((int)1))).getTopicMetadata((Set)ArgumentMatchers.any(), (ListenerName)ArgumentMatchers.eq((Object)mockListenerName), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false));
        ((MetadataCache)Mockito.verify((Object)mockMetadataCache, (VerificationMode)Mockito.times((int)1))).getAliveBrokerNode(ArgumentMatchers.eq((int)1), (ListenerName)ArgumentMatchers.eq((Object)mockListenerName));
    }

    @Test
    public void testShareCoordinatorSuccess() {
        Function<SharePartitionKey, Integer> func = sharePartitionKey -> 0;
        MetadataCache mockMetadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        ListenerName mockListenerName = (ListenerName)Mockito.mock(ListenerName.class);
        ShareCoordinatorMetadataCacheHelperImpl cache = new ShareCoordinatorMetadataCacheHelperImpl(mockMetadataCache, func, mockListenerName);
        Mockito.when((Object)mockMetadataCache.contains((String)ArgumentMatchers.eq((Object)"__share_group_state"))).thenReturn((Object)true);
        Mockito.when((Object)mockMetadataCache.getTopicMetadata((Set)ArgumentMatchers.any(), (ListenerName)ArgumentMatchers.eq((Object)mockListenerName), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false))).thenReturn(List.of(new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setPartitions(List.of(new MetadataResponseData.MetadataResponsePartition().setPartitionIndex(0).setLeaderId(1)))));
        Node node = new Node(2, "some.domain.name", 65534);
        Mockito.when((Object)mockMetadataCache.getAliveBrokerNode(ArgumentMatchers.eq((int)1), (ListenerName)ArgumentMatchers.eq((Object)mockListenerName))).thenReturn(Optional.of(node));
        Assertions.assertEquals((Object)node, (Object)cache.getShareCoordinator(SharePartitionKey.getInstance((String)"group", (Uuid)Uuid.randomUuid(), (int)0), "__share_group_state"));
        ((MetadataCache)Mockito.verify((Object)mockMetadataCache, (VerificationMode)Mockito.times((int)1))).contains((String)ArgumentMatchers.eq((Object)"__share_group_state"));
        ((MetadataCache)Mockito.verify((Object)mockMetadataCache, (VerificationMode)Mockito.times((int)1))).getTopicMetadata((Set)ArgumentMatchers.any(), (ListenerName)ArgumentMatchers.eq((Object)mockListenerName), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false));
        ((MetadataCache)Mockito.verify((Object)mockMetadataCache, (VerificationMode)Mockito.times((int)1))).getAliveBrokerNode(ArgumentMatchers.eq((int)1), (ListenerName)ArgumentMatchers.eq((Object)mockListenerName));
    }

    @Test
    public void testGetClusterNodesEmptyListOnException() {
        Function<SharePartitionKey, Integer> func = sharePartitionKey -> 0;
        MetadataCache mockMetadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        ListenerName mockListenerName = (ListenerName)Mockito.mock(ListenerName.class);
        ShareCoordinatorMetadataCacheHelperImpl cache = new ShareCoordinatorMetadataCacheHelperImpl(mockMetadataCache, func, mockListenerName);
        Mockito.when((Object)mockMetadataCache.getAliveBrokerNodes((ListenerName)ArgumentMatchers.eq((Object)mockListenerName))).thenThrow(new Throwable[]{new CoordinatorNotAvailableException("scary stuff")});
        Assertions.assertEquals(List.of(), (Object)cache.getClusterNodes());
        ((MetadataCache)Mockito.verify((Object)mockMetadataCache, (VerificationMode)Mockito.times((int)1))).getAliveBrokerNodes((ListenerName)ArgumentMatchers.eq((Object)mockListenerName));
    }

    @Test
    public void testGetClusterNodesSuccess() {
        Function<SharePartitionKey, Integer> func = sharePartitionKey -> 0;
        MetadataCache mockMetadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        ListenerName mockListenerName = (ListenerName)Mockito.mock(ListenerName.class);
        ShareCoordinatorMetadataCacheHelperImpl cache = new ShareCoordinatorMetadataCacheHelperImpl(mockMetadataCache, func, mockListenerName);
        List<Node> nodes = List.of(new Node(0, "some.domain.name", 65534), new Node(1, "some.domain.name", 12345));
        Mockito.when((Object)mockMetadataCache.getAliveBrokerNodes((ListenerName)ArgumentMatchers.eq((Object)mockListenerName))).thenReturn(nodes);
        Assertions.assertEquals(nodes, (Object)cache.getClusterNodes());
        ((MetadataCache)Mockito.verify((Object)mockMetadataCache, (VerificationMode)Mockito.times((int)1))).getAliveBrokerNodes((ListenerName)ArgumentMatchers.eq((Object)mockListenerName));
    }
}

