/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.admin.AdminOperationException;
import kafka.admin.PreferredReplicaLeaderElectionCommand;
import kafka.admin.PreferredReplicaLeaderElectionCommand$;
import kafka.common.TopicAndPartition;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PreferredReplicaLeaderElectionCommand$
implements Logging,
ScalaObject {
    public static final PreferredReplicaLeaderElectionCommand$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new PreferredReplicaLeaderElectionCommand$();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec jsonFileOpt = parser.accepts("path-to-json-file", "The JSON file with the list of partitions for which preferred replica leader election should be done, in the following format - \n{\"partitions\":\n\t[{\"topic\": \"foo\", \"partition\": 1},\n\t {\"topic\": \"foobar\", \"partition\": 2}]\n}\nDefaults to all existing partitions").withRequiredArg().describedAs("list of partitions for which preferred replica leader election needs to be triggered").ofType(String.class);
        ArgumentAcceptingOptionSpec zkConnectOpt = parser.accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{zkConnectOpt}));
        String zkConnect = (String)options.valueOf((OptionSpec)zkConnectOpt);
        ZkClient zkClient = null;
        try {
            zkClient = new ZkClient(zkConnect, 30000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
            Set<TopicAndPartition> partitionsForPreferredReplicaElection = options.has((OptionSpec)jsonFileOpt) ? this.parsePreferredReplicaElectionData(Utils$.MODULE$.readFileAsString((String)options.valueOf((OptionSpec)jsonFileOpt), Utils$.MODULE$.readFileAsString$default$2())) : ZkUtils$.MODULE$.getAllPartitions(zkClient);
            PreferredReplicaLeaderElectionCommand preferredReplicaElectionCommand = new PreferredReplicaLeaderElectionCommand(zkClient, partitionsForPreferredReplicaElection);
            preferredReplicaElectionCommand.moveLeaderToPreferredReplica();
            Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("Successfully started preferred replica election for partitions %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionsForPreferredReplicaElection})));
            if (zkClient == null) return;
        }
        catch (Throwable throwable) {
            try {
                Predef$.MODULE$.println((Object)"Failed to start preferred replica election");
                Predef$.MODULE$.println((Object)Utils$.MODULE$.stackTrace(throwable));
            }
            finally {
                if (zkClient == null) return;
                zkClient.close();
            }
        }
        zkClient.close();
    }

    public scala.collection.immutable.Set<TopicAndPartition> parsePreferredReplicaElectionData(String jsonString) {
        Option<Object> option = Json$.MODULE$.parseFull(jsonString);
        if (option instanceof Some) {
            Some some = (Some)option;
            Object object = some.x();
            Object m = object;
            Option option2 = ((Map)m).get((Object)"partitions");
            if (option2 instanceof Some) {
                Object object2;
                Some some2 = (Some)option2;
                Object partitionsList = object2 = some2.x();
                List partitions = (List)partitionsList;
                return ((TraversableOnce)partitions.map((Function1)new anonfun.parsePreferredReplicaElectionData.1(), List$.MODULE$.canBuildFrom())).toSet();
            }
            None$ none$ = None$.MODULE$;
            Option option3 = option2;
            if (!(none$ != null ? !none$.equals(option3) : option3 != null)) {
                throw new AdminOperationException("Preferred replica election data is empty");
            }
            throw new MatchError((Object)option2);
        }
        None$ none$ = None$.MODULE$;
        Option<Object> option4 = option;
        if (!(none$ != null ? !none$.equals(option4) : option4 != null)) {
            throw new AdminOperationException("Preferred replica election data is empty");
        }
        throw new MatchError(option);
    }

    public void writePreferredReplicaElectionData(ZkClient zkClient, Set<TopicAndPartition> partitionsUndergoingPreferredReplicaElection) {
        String zkPath = ZkUtils$.MODULE$.PreferredReplicaLeaderElectionPath();
        Set partitionsList = (Set)partitionsUndergoingPreferredReplicaElection.map((Function1)new anonfun.1(), Set$.MODULE$.canBuildFrom());
        String jsonData$1 = Json$.MODULE$.encode(Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)"version").$minus$greater((Object)BoxesRunTime.boxToInteger((int)1)), Predef$.MODULE$.any2ArrowAssoc((Object)"partitions").$minus$greater((Object)partitionsList)})));
        try {
            ZkUtils$.MODULE$.createPersistentPath(zkClient, zkPath, jsonData$1);
            this.info((Function0<String>)new anonfun.writePreferredReplicaElectionData.1(jsonData$1));
            return;
        }
        catch (Throwable throwable) {
            throw new AdminOperationException(throwable.toString());
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            scala.collection.immutable.Set<TopicAndPartition> partitionsUndergoingPreferredReplicaElection2 = this.parsePreferredReplicaElectionData((String)ZkUtils$.MODULE$.readData(zkClient, zkPath)._1());
            throw new AdminOperationException(new StringBuilder().append((Object)"Preferred replica leader election currently in progress for ").append((Object)Predef$.MODULE$.augmentString("%s. Aborting operation").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionsUndergoingPreferredReplicaElection2}))).toString());
        }
    }

    private PreferredReplicaLeaderElectionCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

