/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.OutputStream;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignmentCompleted$;
import kafka.admin.ReassignmentFailed$;
import kafka.admin.ReassignmentInProgress$;
import kafka.admin.ReassignmentStatus;
import kafka.common.AdminCommandFailedException;
import kafka.common.TopicAndPartition;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReassignPartitionsCommand$
implements Logging,
ScalaObject {
    public static final ReassignPartitionsCommand$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ReassignPartitionsCommand$();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void main(String[] args) {
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts$1 = new ReassignPartitionsCommand.ReassignPartitionsCommandOptions(args);
        int actions = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts$1.generateOpt(), opts$1.executeOpt(), opts$1.verifyOpt()})).count((Function1)new anonfun.1(opts$1));
        if (actions != 1) {
            opts$1.parser().printHelpOn((OutputStream)System.err);
            Utils$.MODULE$.croak("Command must include exactly one action: --generate, --execute or --verify");
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(opts$1.parser(), opts$1.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts$1.zkConnectOpt()}));
        String zkConnect = (String)opts$1.options().valueOf(opts$1.zkConnectOpt());
        ZkClient zkClient = new ZkClient(zkConnect, 30000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
        try {
            if (opts$1.options().has((OptionSpec)opts$1.verifyOpt())) {
                this.verifyAssignment(zkClient, opts$1);
            } else if (opts$1.options().has((OptionSpec)opts$1.generateOpt())) {
                this.generateAssignment(zkClient, opts$1);
            } else if (opts$1.options().has((OptionSpec)opts$1.executeOpt())) {
                this.executeAssignment(zkClient, opts$1);
            }
            if (zkClient == null) return;
        }
        catch (Throwable throwable) {
            try {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Partitions reassignment failed due to ").append((Object)throwable.getMessage()).toString());
                Predef$.MODULE$.println((Object)Utils$.MODULE$.stackTrace(throwable));
            }
            finally {
                if (zkClient == null) return;
                zkClient.close();
            }
        }
        zkClient.close();
    }

    public void verifyAssignment(ZkClient zkClient, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        if (!opts.options().has(opts.reassignmentJsonFileOpt())) {
            opts.parser().printHelpOn((OutputStream)System.err);
            Utils$.MODULE$.croak("If --verify option is used, command must include --reassignment-json-file that was used during the --execute option");
        }
        String jsonFile = (String)opts.options().valueOf(opts.reassignmentJsonFileOpt());
        String jsonString = Utils$.MODULE$.readFileAsString(jsonFile, Utils$.MODULE$.readFileAsString$default$2());
        Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned = ZkUtils$.MODULE$.parsePartitionReassignmentData(jsonString);
        Predef$.MODULE$.println((Object)"Status of partition reassignment:");
        Map<TopicAndPartition, ReassignmentStatus> reassignedPartitionsStatus = this.checkIfReassignmentSucceeded(zkClient, partitionsToBeReassigned);
        reassignedPartitionsStatus.foreach((Function1)new anonfun.verifyAssignment.1());
    }

    public void generateAssignment(ZkClient zkClient, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        if (!opts.options().has(opts.topicsToMoveJsonFileOpt()) || !opts.options().has(opts.brokerListOpt())) {
            opts.parser().printHelpOn((OutputStream)System.err);
            Utils$.MODULE$.croak("If --generate option is used, command must include both --topics-to-move-json-file and --broker-list options");
        }
        String topicsToMoveJsonFile = (String)opts.options().valueOf(opts.topicsToMoveJsonFileOpt());
        int[] brokerListToReassign$1 = (int[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.augmentString((String)opts.options().valueOf(opts.brokerListOpt())).split(',')).map((Function1)new anonfun.2(), Array$.MODULE$.canBuildFrom((ClassManifest)Manifest$.MODULE$.Int()));
        String topicsToMoveJsonString = Utils$.MODULE$.readFileAsString(topicsToMoveJsonFile, Utils$.MODULE$.readFileAsString$default$2());
        Seq<String> topicsToReassign = ZkUtils$.MODULE$.parseTopicsData(topicsToMoveJsonString);
        scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> topicPartitionsToReassign = ZkUtils$.MODULE$.getReplicaAssignmentForTopics(zkClient, topicsToReassign);
        ObjectRef partitionsToBeReassigned$2 = new ObjectRef((Object)new HashMap());
        scala.collection.immutable.Map groupedByTopic = topicPartitionsToReassign.groupBy((Function1)new anonfun.3());
        groupedByTopic.foreach((Function1)new anonfun.generateAssignment.1(brokerListToReassign$1, partitionsToBeReassigned$2));
        scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> currentPartitionReplicaAssignment = ZkUtils$.MODULE$.getReplicaAssignmentForTopics(zkClient, (Seq<String>)((IterableLike)((Map)partitionsToBeReassigned$2.elem).map((Function1)new anonfun.4(), Iterable$.MODULE$.canBuildFrom())).toSeq());
        Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("Current partition replica assignment\n\n%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZkUtils$.MODULE$.getPartitionReassignmentZkData((Map<TopicAndPartition, Seq<Object>>)currentPartitionReplicaAssignment)})));
        Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("Proposed partition reassignment configuration\n\n%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZkUtils$.MODULE$.getPartitionReassignmentZkData((Map<TopicAndPartition, Seq<Object>>)((Map)partitionsToBeReassigned$2.elem))})));
    }

    public void executeAssignment(ZkClient zkClient, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        String reassignmentJsonFile;
        String reassignmentJsonString;
        Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned;
        if (!opts.options().has(opts.reassignmentJsonFileOpt())) {
            opts.parser().printHelpOn((OutputStream)System.err);
            Utils$.MODULE$.croak("If --execute option is used, command must include --reassignment-json-file that was output during the --generate option");
        }
        if ((partitionsToBeReassigned = ZkUtils$.MODULE$.parsePartitionReassignmentData(reassignmentJsonString = Utils$.MODULE$.readFileAsString(reassignmentJsonFile = (String)opts.options().valueOf(opts.reassignmentJsonFileOpt()), Utils$.MODULE$.readFileAsString$default$2()))).isEmpty()) {
            throw new AdminCommandFailedException(Predef$.MODULE$.augmentString("Partition reassignment data file %s is empty").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{reassignmentJsonFile})));
        }
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(zkClient, partitionsToBeReassigned);
        scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> currentPartitionReplicaAssignment = ZkUtils$.MODULE$.getReplicaAssignmentForTopics(zkClient, (Seq<String>)((IterableLike)partitionsToBeReassigned.map((Function1)new anonfun.5(), Iterable$.MODULE$.canBuildFrom())).toSeq());
        Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("Current partition replica assignment\n\n%s\n\nSave this to use as the --reassignment-json-file option during rollback").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZkUtils$.MODULE$.getPartitionReassignmentZkData((Map<TopicAndPartition, Seq<Object>>)currentPartitionReplicaAssignment)})));
        if (reassignPartitionsCommand.reassignPartitions()) {
            Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("Successfully started reassignment of partitions %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZkUtils$.MODULE$.getPartitionReassignmentZkData(partitionsToBeReassigned)})));
        } else {
            Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("Failed to reassign partitions %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionsToBeReassigned})));
        }
    }

    private Map<TopicAndPartition, ReassignmentStatus> checkIfReassignmentSucceeded(ZkClient zkClient$1, Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned$1) {
        Map partitionsBeingReassigned$1 = ZkUtils$.MODULE$.getPartitionsBeingReassigned(zkClient$1).mapValues((Function1)new anonfun.6());
        return (Map)partitionsToBeReassigned$1.map((Function1)new anonfun.checkIfReassignmentSucceeded.1(zkClient$1, partitionsToBeReassigned$1, partitionsBeingReassigned$1), Map$.MODULE$.canBuildFrom());
    }

    public ReassignmentStatus checkIfPartitionReassignmentSucceeded(ZkClient zkClient, TopicAndPartition topicAndPartition, Seq<Object> reassignedReplicas, Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned, Map<TopicAndPartition, Seq<Object>> partitionsBeingReassigned) {
        Option option;
        block7: {
            Product product;
            block6: {
                Seq<Object> assignedReplicas;
                Seq newReplicas;
                block5: {
                    newReplicas = (Seq)partitionsToBeReassigned.apply((Object)topicAndPartition);
                    option = partitionsBeingReassigned.get((Object)topicAndPartition);
                    if (!(option instanceof Some)) break block5;
                    product = ReassignmentInProgress$.MODULE$;
                    break block6;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block7;
                Seq<Object> seq = assignedReplicas = ZkUtils$.MODULE$.getReplicasForPartition(zkClient, topicAndPartition.topic(), topicAndPartition.partition());
                Seq seq2 = newReplicas;
                if (!(seq != null ? !seq.equals((Object)seq2) : seq2 != null)) {
                    product = ReassignmentCompleted$.MODULE$;
                } else {
                    Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("ERROR: Assigned replicas (%s) don't match the list of replicas for reassignment (%s) for partition %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{assignedReplicas.mkString(","), newReplicas.mkString(","), topicAndPartition})));
                    product = ReassignmentFailed$.MODULE$;
                }
            }
            return product;
        }
        throw new MatchError((Object)option);
    }

    private ReassignPartitionsCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

