/*
 * Decompiled with CFR 0.152.
 */
package kafka.client;

import java.util.Properties;
import kafka.api.TopicMetadataRequest;
import kafka.api.TopicMetadataRequest$;
import kafka.api.TopicMetadataResponse;
import kafka.client.ClientUtils$;
import kafka.cluster.Broker;
import kafka.common.KafkaException;
import kafka.producer.ProducerConfig;
import kafka.producer.ProducerPool$;
import kafka.producer.SyncProducer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.Random$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClientUtils$
implements Logging,
ScalaObject {
    public static final ClientUtils$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ClientUtils$();
    }

    public int fetchTopicMetadata$default$5() {
        return 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TopicMetadataResponse fetchTopicMetadata(Set<String> topics$1, Seq<Broker> brokers, ProducerConfig producerConfig, int correlationId$1) {
        boolean fetchMetaDataSucceeded = false;
        IntRef i$1 = new IntRef(0);
        TopicMetadataRequest topicMetadataRequest = new TopicMetadataRequest(TopicMetadataRequest$.MODULE$.CurrentVersion(), correlationId$1, producerConfig.clientId(), (Seq<String>)topics$1.toSeq());
        TopicMetadataResponse topicMetadataResponse = null;
        Throwable t = null;
        Seq shuffledBrokers$1 = (Seq)Random$.MODULE$.shuffle(brokers, Seq$.MODULE$.canBuildFrom());
        while (i$1.elem < shuffledBrokers$1.size() && !fetchMetaDataSucceeded) {
            SyncProducer producer = ProducerPool$.MODULE$.createSyncProducer(producerConfig, (Broker)shuffledBrokers$1.apply(i$1.elem));
            this.info((Function0<String>)new anonfun.fetchTopicMetadata.1(topics$1, correlationId$1, i$1, shuffledBrokers$1));
            {
                topicMetadataResponse = producer.send(topicMetadataRequest);
                fetchMetaDataSucceeded = true;
                ++i$1.elem;
                producer.close();
            }
        }
        if (fetchMetaDataSucceeded) {
            this.debug((Function0<String>)new anonfun.fetchTopicMetadata.4(topics$1));
            return topicMetadataResponse;
        }
        throw new KafkaException(Predef$.MODULE$.augmentString("fetching topic metadata for topics [%s] from broker [%s] failed").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topics$1, shuffledBrokers$1})), t);
    }

    public TopicMetadataResponse fetchTopicMetadata(Set<String> topics, Seq<Broker> brokers, String clientId, int timeoutMs, int correlationId) {
        Properties props = new Properties();
        props.put("metadata.broker.list", ((TraversableOnce)brokers.map((Function1)new anonfun.fetchTopicMetadata.5(), Seq$.MODULE$.canBuildFrom())).mkString(","));
        props.put("client.id", clientId);
        props.put("request.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)timeoutMs)).toString());
        ProducerConfig producerConfig = new ProducerConfig(props);
        return this.fetchTopicMetadata(topics, brokers, producerConfig, correlationId);
    }

    public Seq<Broker> parseBrokerList(String brokerListStr) {
        Seq<String> brokersStr = Utils$.MODULE$.parseCsvList(brokerListStr);
        return (Seq)((TraversableLike)brokersStr.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new anonfun.parseBrokerList.1(), Seq$.MODULE$.canBuildFrom());
    }

    private ClientUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

