/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.api.LeaderAndIsr;
import kafka.common.NoReplicaOnlineException;
import kafka.common.TopicAndPartition;
import kafka.controller.ControllerContext;
import kafka.controller.PartitionLeaderSelector;
import kafka.controller.ReassignedPartitionLeaderSelector$;
import kafka.controller.ReassignedPartitionsContext;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001=3\u0001\"\u0001\u0002\u0005\u0002\u0003\u0005\ta\u0002\u0002\"%\u0016\f7o]5h]\u0016$\u0007+\u0019:uSRLwN\u001c'fC\u0012,'oU3mK\u000e$xN\u001d\u0006\u0003\u0007\u0011\t!bY8oiJ|G\u000e\\3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0006\u0001!\u0001BC\u0007\t\u0003\u00139i\u0011A\u0003\u0006\u0003\u00171\tA\u0001\\1oO*\tQ\"\u0001\u0003kCZ\f\u0017BA\b\u000b\u0005\u0019y%M[3diB\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0018!\u0006\u0014H/\u001b;j_:dU-\u00193feN+G.Z2u_J\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005e1\"a\u0002'pO\u001eLgn\u001a\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u0003E\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\t\u0003#\rJ!\u0001\n\u0002\u0003#\r{g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000fC\u0003'\u0001\u0011\u0005q%\u0001\u0004=S:LGO\u0010\u000b\u0003Q%\u0002\"!\u0005\u0001\t\u000b\u0005*\u0003\u0019\u0001\u0012\t\u000b-\u0002A\u0011\u0001\u0017\u0002\u0019M,G.Z2u\u0019\u0016\fG-\u001a:\u0015\u00075*U\n\u0005\u0003\u001c]A2\u0014BA\u0018\u001d\u0005\u0019!V\u000f\u001d7feA\u0011\u0011\u0007N\u0007\u0002e)\u00111\u0007B\u0001\u0004CBL\u0017BA\u001b3\u00051aU-\u00193fe\u0006sG-S:s!\r9tH\u0011\b\u0003qur!!\u000f\u001f\u000e\u0003iR!a\u000f\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0012B\u0001 \u001d\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001Q!\u0003\u0007M+\u0017O\u0003\u0002?9A\u00111dQ\u0005\u0003\tr\u00111!\u00138u\u0011\u00151%\u00061\u0001H\u0003E!x\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015\u0012\taaY8n[>t\u0017B\u0001'J\u0005E!v\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\u0005\u0006\u001d*\u0002\r\u0001M\u0001\u0014GV\u0014(/\u001a8u\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d")
public class ReassignedPartitionLeaderSelector
implements PartitionLeaderSelector,
Logging,
ScalaObject {
    public final ControllerContext kafka$controller$ReassignedPartitionLeaderSelector$$controllerContext;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public Tuple2<LeaderAndIsr, Seq<Object>> selectLeader(TopicAndPartition topicAndPartition, LeaderAndIsr currentLeaderAndIsr$1) {
        Seq<Object> reassignedInSyncReplicas = ((ReassignedPartitionsContext)this.kafka$controller$ReassignedPartitionLeaderSelector$$controllerContext.partitionsBeingReassigned().apply((Object)topicAndPartition)).newReplicas();
        int currentLeaderEpoch = currentLeaderAndIsr$1.leaderEpoch();
        int currentLeaderIsrZkPathVersion = currentLeaderAndIsr$1.zkVersion();
        Seq aliveReassignedInSyncReplicas = (Seq)reassignedInSyncReplicas.filter((Function1)new $anonfun$3(this, currentLeaderAndIsr$1));
        Option newLeaderOpt = aliveReassignedInSyncReplicas.headOption();
        Option option = newLeaderOpt;
        if (option instanceof Some) {
            return new Tuple2((Object)new LeaderAndIsr(BoxesRunTime.unboxToInt((Object)((Some)option).x()), currentLeaderEpoch + 1, currentLeaderAndIsr$1.isr(), currentLeaderIsrZkPathVersion + 1), reassignedInSyncReplicas);
        }
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            int n = reassignedInSyncReplicas.size();
            if (n == 0) {
                throw new NoReplicaOnlineException(new StringBuilder().append((Object)"List of reassigned replicas for partition ").append((Object)Predef$.MODULE$.augmentString(" %s is empty. Current leader and ISR: [%s]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, currentLeaderAndIsr$1}))).toString());
            }
            throw new NoReplicaOnlineException(new StringBuilder().append((Object)"None of the reassigned replicas for partition ").append((Object)Predef$.MODULE$.augmentString("%s are in-sync with the leader. Current leader and ISR: [%s]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, currentLeaderAndIsr$1}))).toString());
        }
        throw new MatchError((Object)option);
    }

    public ReassignedPartitionLeaderSelector(ControllerContext controllerContext) {
        this.kafka$controller$ReassignedPartitionLeaderSelector$$controllerContext = controllerContext;
        Logging$class.$init$(this);
        this.logIdent_$eq("[ReassignedPartitionLeaderSelector]: ");
    }
}

