/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import kafka.common.LogCleaningAbortedException;
import kafka.common.TopicAndPartition;
import kafka.log.Cleaner$;
import kafka.log.Cleaner$$anonfun$kafka$log$Cleaner$;
import kafka.log.CleanerStats;
import kafka.log.FileMessageSet;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleaner;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetIndex;
import kafka.log.OffsetMap;
import kafka.message.ByteBufferMessageSet;
import kafka.message.MessageAndOffset;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Throttler;
import kafka.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005]f!C\u0001\u0003\t\u0003\u0005\t\u0011\u0001\u0002\u0007\u0005\u001d\u0019E.Z1oKJT!a\u0001\u0003\u0002\u00071|wMC\u0001\u0006\u0003\u0015Y\u0017MZ6b'\u0011\u0001qaD\u000b\u0011\u0005!iQ\"A\u0005\u000b\u0005)Y\u0011\u0001\u00027b]\u001eT\u0011\u0001D\u0001\u0005U\u00064\u0018-\u0003\u0002\u000f\u0013\t1qJ\u00196fGR\u0004\"\u0001E\n\u000e\u0003EQ!A\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005Q\t\"a\u0002'pO\u001eLgn\u001a\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005\u001d\u0001\t\u0015\r\u0011\"\u0001\u001f\u0003\tIGm\u0001\u0001\u0016\u0003}\u0001\"A\u0006\u0011\n\u0005\u0005:\"aA%oi\"A1\u0005\u0001B\u0001B\u0003%q$A\u0002jI\u0002B\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAJ\u0001\n_\u001a47/\u001a;NCB\u0004\"a\n\u0015\u000e\u0003\tI!!\u000b\u0002\u0003\u0013=3gm]3u\u001b\u0006\u0004\b\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\u0019%|')\u001e4gKJ\u001c\u0016N_3\t\u00115\u0002!\u0011!Q\u0001\n}\tq\"\\1y\u0013>\u0014UO\u001a4feNK'0\u001a\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u0005\u0019B-\u001e9Ck\u001a4WM\u001d'pC\u00124\u0015m\u0019;peB\u0011a#M\u0005\u0003e]\u0011a\u0001R8vE2,\u0007\u0002\u0003\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u001b\u0002\u0013QD'o\u001c;uY\u0016\u0014\bC\u0001\t7\u0013\t9\u0014CA\u0005UQJ|G\u000f\u001e7fe\"A\u0011\b\u0001B\u0001B\u0003%!(\u0001\u0003uS6,\u0007C\u0001\t<\u0013\ta\u0014C\u0001\u0003US6,\u0007\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B \u0002\u0013\rDWmY6E_:,\u0007\u0003\u0002\fA\u0005\"K!!Q\f\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CA\"G\u001b\u0005!%BA#\u0005\u0003\u0019\u0019w.\\7p]&\u0011q\t\u0012\u0002\u0012)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007C\u0001\fJ\u0013\tQuC\u0001\u0003V]&$\b\"\u0002'\u0001\t\u0003i\u0015A\u0002\u001fj]&$h\bF\u0005O\u001fB\u000b&k\u0015+V-B\u0011q\u0005\u0001\u0005\u00069-\u0003\ra\b\u0005\u0006K-\u0003\rA\n\u0005\u0006W-\u0003\ra\b\u0005\u0006[-\u0003\ra\b\u0005\u0006_-\u0003\r\u0001\r\u0005\u0006i-\u0003\r!\u000e\u0005\u0006s-\u0003\rA\u000f\u0005\u0006}-\u0003\ra\u0010\u0005\b1\u0002\u0011\r\u0011\"\u0011Z\u0003)awnZ4fe:\u000bW.Z\u000b\u00025B\u0011\u0001bW\u0005\u00039&\u0011aa\u0015;sS:<\u0007B\u00020\u0001A\u0003%!,A\u0006m_\u001e<WM\u001d(b[\u0016\u0004\u0003b\u00021\u0001\u0005\u0004%\t!Y\u0001\u0006gR\fGo]\u000b\u0002EB\u0011qeY\u0005\u0003I\n\u0011Ab\u00117fC:,'o\u0015;biNDaA\u001a\u0001!\u0002\u0013\u0011\u0017AB:uCR\u001c\b\u0005C\u0004i\u0001\u0001\u0007I\u0011B5\u0002\u0015I,\u0017\r\u001a\"vM\u001a,'/F\u0001k!\tYg.D\u0001m\u0015\ti7\"A\u0002oS>L!a\u001c7\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000fC\u0004r\u0001\u0001\u0007I\u0011\u0002:\u0002\u001dI,\u0017\r\u001a\"vM\u001a,'o\u0018\u0013fcR\u0011\u0001j\u001d\u0005\biB\f\t\u00111\u0001k\u0003\rAH%\r\u0005\u0007m\u0002\u0001\u000b\u0015\u00026\u0002\u0017I,\u0017\r\u001a\"vM\u001a,'\u000f\t\u0005\bq\u0002\u0001\r\u0011\"\u0003j\u0003-9(/\u001b;f\u0005V4g-\u001a:\t\u000fi\u0004\u0001\u0019!C\u0005w\u0006yqO]5uK\n+hMZ3s?\u0012*\u0017\u000f\u0006\u0002Iy\"9A/_A\u0001\u0002\u0004Q\u0007B\u0002@\u0001A\u0003&!.\u0001\u0007xe&$XMQ;gM\u0016\u0014\b\u0005\u0003\u0005\u0002\u0002\u0001!\tAAA\u0002\u0003\u0015\u0019G.Z1o)\u0011\t)!a\u0003\u0011\u0007Y\t9!C\u0002\u0002\n]\u0011A\u0001T8oO\"9\u0011QB@A\u0002\u0005=\u0011!C2mK\u0006t\u0017M\u00197f!\r9\u0013\u0011C\u0005\u0004\u0003'\u0011!A\u0003'pOR{7\t\\3b]\"A\u0011q\u0003\u0001\u0005\u0002\t\tI\"A\u0007dY\u0016\fgnU3h[\u0016tGo\u001d\u000b\n\u0011\u0006m\u00111EA\u001d\u0003{AqaAA\u000b\u0001\u0004\ti\u0002E\u0002(\u0003?I1!!\t\u0003\u0005\raun\u001a\u0005\t\u0003K\t)\u00021\u0001\u0002(\u0005A1/Z4nK:$8\u000f\u0005\u0004\u0002*\u0005=\u00121G\u0007\u0003\u0003WQ1!!\f\u0018\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003c\tYCA\u0002TKF\u00042aJA\u001b\u0013\r\t9D\u0001\u0002\u000b\u0019><7+Z4nK:$\bbBA\u001e\u0003+\u0001\rAJ\u0001\u0004[\u0006\u0004\b\u0002CA \u0003+\u0001\r!!\u0002\u0002\u001f\u0011,G.\u001a;f\u0011>\u0014\u0018N_8o\u001bND\u0001\"a\u0011\u0001\t\u0003\u0011\u0011QI\u0001\nG2,\u0017M\\%oi>$2\u0002SA$\u0003\u0017\ny%a\u0015\u0002V!9\u0011\u0011JA!\u0001\u0004\u0011\u0015!\u0005;pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]\"A\u0011QJA!\u0001\u0004\t\u0019$\u0001\u0004t_V\u00148-\u001a\u0005\t\u0003#\n\t\u00051\u0001\u00024\u0005!A-Z:u\u0011\u001d\tY$!\u0011A\u0002\u0019B\u0001\"a\u0016\u0002B\u0001\u0007\u0011\u0011L\u0001\u000ee\u0016$\u0018-\u001b8EK2,G/Z:\u0011\u0007Y\tY&C\u0002\u0002^]\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002b\u0001!\t!a\u0019\u0002\u0017\u001d\u0014xn\u001e\"vM\u001a,'o\u001d\u000b\u0002\u0011\"9\u0011q\r\u0001\u0005\u0002\u0005\r\u0014A\u0004:fgR|'/\u001a\"vM\u001a,'o\u001d\u0005\t\u0003W\u0002A\u0011\u0001\u0002\u0002n\u0005\u0019rM]8vaN+w-\\3oiN\u0014\u0015pU5{KRA\u0011qNAD\u0003\u001f\u000b\u0019\n\u0005\u0004\u0002r\u0005\u0005\u0015q\u0005\b\u0005\u0003g\niH\u0004\u0003\u0002v\u0005mTBAA<\u0015\r\tI(H\u0001\u0007yI|w\u000e\u001e \n\u0003aI1!a \u0018\u0003\u001d\u0001\u0018mY6bO\u0016LA!a!\u0002\u0006\n!A*[:u\u0015\r\tyh\u0006\u0005\t\u0003K\tI\u00071\u0001\u0002\nB1\u0011\u0011FAF\u0003gIA!!$\u0002,\tA\u0011\n^3sC\ndW\rC\u0004\u0002\u0012\u0006%\u0004\u0019A\u0010\u0002\u000f5\f\u0007pU5{K\"9\u0011QSA5\u0001\u0004y\u0012\u0001D7bq&sG-\u001a=TSj,\u0007\u0002CAM\u0001\u0011\u0005!!a'\u0002\u001d\t,\u0018\u000e\u001c3PM\u001a\u001cX\r^'baRQ\u0011QAAO\u0003?\u000b\u0019+a*\t\u000f\r\t9\n1\u0001\u0002\u001e!A\u0011\u0011UAL\u0001\u0004\t)!A\u0003ti\u0006\u0014H\u000f\u0003\u0005\u0002&\u0006]\u0005\u0019AA\u0003\u0003\r)g\u000e\u001a\u0005\b\u0003w\t9\n1\u0001'\u0011\u001d\tY\u000b\u0001C\u0005\u0003[\u000b\u0001DY;jY\u0012|eMZ:fi6\u000b\u0007OR8s'\u0016<W.\u001a8u)!\t)!a,\u00022\u0006U\u0006bBA%\u0003S\u0003\rA\u0011\u0005\t\u0003g\u000bI\u000b1\u0001\u00024\u000591/Z4nK:$\bbBA\u001e\u0003S\u0003\rA\n")
public class Cleaner
implements Logging,
ScalaObject {
    private final int id;
    public final OffsetMap kafka$log$Cleaner$$offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    public final double kafka$log$Cleaner$$dupBufferLoadFactor;
    private final Throttler throttler;
    private final Time time;
    public final Function1<TopicAndPartition, BoxedUnit> kafka$log$Cleaner$$checkDone;
    private final String loggerName;
    private final CleanerStats stats;
    private ByteBuffer kafka$log$Cleaner$$readBuffer;
    private ByteBuffer kafka$log$Cleaner$$writeBuffer;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public int id() {
        return this.id;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    public CleanerStats stats() {
        return this.stats;
    }

    public final ByteBuffer kafka$log$Cleaner$$readBuffer() {
        return this.kafka$log$Cleaner$$readBuffer;
    }

    private void kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer byteBuffer) {
        this.kafka$log$Cleaner$$readBuffer = byteBuffer;
    }

    public final ByteBuffer kafka$log$Cleaner$$writeBuffer() {
        return this.kafka$log$Cleaner$$writeBuffer;
    }

    private void kafka$log$Cleaner$$writeBuffer_$eq(ByteBuffer byteBuffer) {
        this.kafka$log$Cleaner$$writeBuffer = byteBuffer;
    }

    public long clean(LogToClean cleanable$1) {
        Option option;
        block4: {
            long l;
            long endOffset;
            Log log$2;
            block3: {
                block2: {
                    this.stats().clear();
                    this.info((Function0<String>)new $anonfun$clean$1(this, cleanable$1));
                    log$2 = cleanable$1.log();
                    this.info((Function0<String>)new $anonfun$clean$2(this, cleanable$1));
                    long upperBoundOffset = log$2.activeSegment().baseOffset();
                    endOffset = this.buildOffsetMap(log$2, cleanable$1.firstDirtyOffset(), upperBoundOffset, this.kafka$log$Cleaner$$offsetMap) + 1L;
                    this.stats().indexDone();
                    option = log$2.logSegments(0L, cleanable$1.firstDirtyOffset()).lastOption();
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                    l = 0L;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                l = ((LogSegment)((Some)option).x()).lastModified() - log$2.config().deleteRetentionMs();
            }
            long deleteHorizonMs$1 = l;
            this.info((Function0<String>)new $anonfun$clean$3(this, log$2, deleteHorizonMs$1));
            this.groupSegmentsBySize(log$2.logSegments(0L, endOffset), log$2.config().segmentSize(), log$2.config().maxIndexSize()).foreach((Function1)new $anonfun$clean$4(this, log$2, deleteHorizonMs$1));
            this.stats().allDone();
            return endOffset;
        }
        throw new MatchError((Object)option);
    }

    public void cleanSegments(Log log$4, Seq<LogSegment> segments$1, OffsetMap map$2, long deleteHorizonMs$2) {
        File logFile = new File(new StringBuilder().append((Object)((LogSegment)segments$1.head()).log().file().getPath()).append((Object)Log$.MODULE$.CleanedFileSuffix()).toString());
        logFile.delete();
        File indexFile = new File(new StringBuilder().append((Object)((LogSegment)segments$1.head()).index().file().getPath()).append((Object)Log$.MODULE$.CleanedFileSuffix()).toString());
        indexFile.delete();
        FileMessageSet messages = new FileMessageSet(logFile);
        OffsetIndex index = new OffsetIndex(indexFile, ((LogSegment)segments$1.head()).baseOffset(), ((LogSegment)segments$1.head()).index().maxIndexSize());
        LogSegment cleaned$1 = new LogSegment(messages, index, ((LogSegment)segments$1.head()).baseOffset(), ((LogSegment)segments$1.head()).indexIntervalBytes(), this.time);
        try {
            segments$1.foreach((Function1)new $anonfun$cleanSegments$1(this, log$4, map$2, deleteHorizonMs$2, cleaned$1));
            index.trimToValidSize();
            cleaned$1.flush();
            long modified = ((LogSegment)segments$1.last()).lastModified();
            cleaned$1.lastModified_$eq(modified);
            this.info((Function0<String>)new $anonfun$cleanSegments$2(this, log$4, segments$1, cleaned$1));
            log$4.replaceSegments(cleaned$1, segments$1);
            return;
        }
        catch (LogCleaningAbortedException logCleaningAbortedException) {
            cleaned$1.delete();
            throw logCleaningAbortedException;
        }
    }

    public void cleanInto(TopicAndPartition topicAndPartition, LogSegment source$1, LogSegment dest, OffsetMap map$3, boolean retainDeletes$2) {
        IntRef position$1 = new IntRef(0);
        while (position$1.elem < source$1.log().sizeInBytes()) {
            this.kafka$log$Cleaner$$checkDone.apply((Object)topicAndPartition);
            this.kafka$log$Cleaner$$readBuffer().clear();
            this.kafka$log$Cleaner$$writeBuffer().clear();
            ByteBufferMessageSet messages = new ByteBufferMessageSet(source$1.log().readInto(this.kafka$log$Cleaner$$readBuffer(), position$1.elem));
            this.throttler.maybeThrottle(messages.sizeInBytes());
            IntRef messagesRead$1 = new IntRef(0);
            messages.foreach((Function1)new $anonfun$cleanInto$1(this, source$1, map$3, retainDeletes$2, position$1, messagesRead$1));
            if (this.kafka$log$Cleaner$$writeBuffer().position() > 0) {
                this.kafka$log$Cleaner$$writeBuffer().flip();
                ByteBufferMessageSet retained = new ByteBufferMessageSet(this.kafka$log$Cleaner$$writeBuffer());
                dest.append(((MessageAndOffset)retained.head()).offset(), retained);
                this.throttler.maybeThrottle(this.kafka$log$Cleaner$$writeBuffer().limit());
            }
            if (this.kafka$log$Cleaner$$readBuffer().limit() <= 0 || messagesRead$1.elem != 0) continue;
            this.growBuffers();
        }
        this.restoreBuffers();
    }

    public void growBuffers() {
        if (this.kafka$log$Cleaner$$readBuffer().capacity() >= this.maxIoBufferSize || this.kafka$log$Cleaner$$writeBuffer().capacity() >= this.maxIoBufferSize) {
            throw new IllegalStateException(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxIoBufferSize)})));
        }
        int newSize$1 = package$.MODULE$.min(this.kafka$log$Cleaner$$readBuffer().capacity() * 2, this.maxIoBufferSize);
        this.info((Function0<String>)new $anonfun$growBuffers$1(this, newSize$1));
        this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(newSize$1));
        this.kafka$log$Cleaner$$writeBuffer_$eq(ByteBuffer.allocate(newSize$1));
    }

    public void restoreBuffers() {
        if (this.kafka$log$Cleaner$$readBuffer().capacity() > this.ioBufferSize) {
            this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
        if (this.kafka$log$Cleaner$$writeBuffer().capacity() > this.ioBufferSize) {
            this.kafka$log$Cleaner$$writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments, int maxSize, int maxIndexSize) {
        Nil$ grouped = Nil$.MODULE$;
        List segs = segments.toList();
        while (!segs.isEmpty()) {
            List group = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)segs.head()}));
            long logSize = ((LogSegment)segs.head()).size();
            int indexSize = ((LogSegment)segs.head()).index().sizeInBytes();
            segs = (List)segs.tail();
            while (!segs.isEmpty() && logSize + ((LogSegment)segs.head()).size() < (long)maxSize && indexSize + ((LogSegment)segs.head()).index().sizeInBytes() < maxIndexSize) {
                LogSegment logSegment = (LogSegment)segs.head();
                group = group.$colon$colon((Object)logSegment);
                logSize += ((LogSegment)segs.head()).size();
                indexSize += ((LogSegment)segs.head()).index().sizeInBytes();
                segs = (List)segs.tail();
            }
            grouped = grouped.$colon$colon((Object)group.reverse());
        }
        return grouped.reverse();
    }

    public long buildOffsetMap(Log log$3, long start$1, long end$1, OffsetMap map$1) {
        map$1.clear();
        Seq dirty$1 = log$3.logSegments(start$1, end$1).toSeq();
        this.info((Function0<String>)new $anonfun$buildOffsetMap$1(this, log$3, start$1, end$1, dirty$1));
        LongRef offset$1 = new LongRef(((LogSegment)dirty$1.head()).baseOffset());
        Predef$.MODULE$.require(offset$1.elem == start$1, (Function0)new $anonfun$buildOffsetMap$2(this, log$3, start$1, offset$1));
        long minStopOffset$1 = (long)((double)start$1 + (double)map$1.slots() * this.kafka$log$Cleaner$$dupBufferLoadFactor);
        dirty$1.foreach((Function1)new $anonfun$buildOffsetMap$3(this, log$3, map$1, offset$1, minStopOffset$1));
        this.info((Function0<String>)new $anonfun$buildOffsetMap$4(this, log$3));
        return offset$1.elem;
    }

    public final long kafka$log$Cleaner$$buildOffsetMapForSegment(TopicAndPartition topicAndPartition, LogSegment segment, OffsetMap map$4) {
        IntRef position$2 = new IntRef(0);
        LongRef offset$2 = new LongRef(segment.baseOffset());
        while (position$2.elem < segment.log().sizeInBytes()) {
            this.kafka$log$Cleaner$$checkDone.apply((Object)topicAndPartition);
            this.kafka$log$Cleaner$$readBuffer().clear();
            ByteBufferMessageSet messages = new ByteBufferMessageSet(segment.log().readInto(this.kafka$log$Cleaner$$readBuffer(), position$2.elem));
            this.throttler.maybeThrottle(messages.sizeInBytes());
            int startPosition = position$2.elem;
            messages.foreach((Function1)new $anonfun$kafka$log$Cleaner$$buildOffsetMapForSegment$1(this, map$4, position$2, offset$2));
            if (position$2.elem != startPosition) continue;
            this.growBuffers();
        }
        this.restoreBuffers();
        return offset$2.elem;
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicAndPartition, BoxedUnit> checkDone) {
        this.id = id;
        this.kafka$log$Cleaner$$offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.kafka$log$Cleaner$$dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.time = time;
        this.kafka$log$Cleaner$$checkDone = checkDone;
        Logging$class.$init$(this);
        this.loggerName = LogCleaner.class.getName();
        this.logIdent_$eq(new StringBuilder().append((Object)"Cleaner ").append((Object)BoxesRunTime.boxToInteger((int)id)).append((Object)": ").toString());
        this.stats = new CleanerStats(time);
        this.kafka$log$Cleaner$$readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.kafka$log$Cleaner$$writeBuffer = ByteBuffer.allocate(ioBufferSize);
    }
}

