/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.common.KafkaException;
import kafka.log.FileMessageSet$;
import kafka.log.OffsetPosition;
import kafka.message.ByteBufferMessageSet;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003\u001d\u0019KG.Z'fgN\fw-Z*fi*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0003\b\u0015!\tIA\"D\u0001\u000b\u0015\tYA!A\u0004nKN\u001c\u0018mZ3\n\u00055Q!AC'fgN\fw-Z*fiB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbCA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002C\u000e\u0001\u0005\u0003\u0007I\u0011\u0001\u000f\u0002\t\u0019LG.Z\u000b\u0002;A\u0011adI\u0007\u0002?)\u0011\u0001%I\u0001\u0003S>T\u0011AI\u0001\u0005U\u00064\u0018-\u0003\u0002%?\t!a)\u001b7f\u0011!1\u0003A!a\u0001\n\u00039\u0013\u0001\u00034jY\u0016|F%Z9\u0015\u0005!Z\u0003CA\u000b*\u0013\tQcC\u0001\u0003V]&$\bb\u0002\u0017&\u0003\u0003\u0005\r!H\u0001\u0004q\u0012\n\u0004\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0015B\u000f\u0002\u000b\u0019LG.\u001a\u0011)\u00055\u0002\u0004CA\u000b2\u0013\t\u0011dC\u0001\u0005w_2\fG/\u001b7f\u0011%!\u0004A!b\u0001\n\u0003\u0011Q'A\u0004dQ\u0006tg.\u001a7\u0016\u0003Y\u0002\"a\u000e\u001f\u000e\u0003aR!!\u000f\u001e\u0002\u0011\rD\u0017M\u001c8fYNT!aO\u0011\u0002\u00079Lw.\u0003\u0002>q\tYa)\u001b7f\u0007\"\fgN\\3m\u0011!y\u0004A!A!\u0002\u00131\u0014\u0001C2iC:tW\r\u001c\u0011\t\u0013\u0005\u0003!Q1A\u0005\u0002\t\u0011\u0015!B:uCJ$X#A\"\u0011\u0005U!\u0015BA#\u0017\u0005\rIe\u000e\u001e\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0007\u000611\u000f^1si\u0002B\u0011\"\u0013\u0001\u0003\u0006\u0004%\tA\u0001\"\u0002\u0007\u0015tG\r\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003D\u0003\u0011)g\u000e\u001a\u0011\t\u00115\u0003!\u0011!Q\u0001\n9\u000bq![:TY&\u001cW\r\u0005\u0002\u0016\u001f&\u0011\u0001K\u0006\u0002\b\u0005>|G.Z1o\u0011\u0019\u0011\u0006\u0001\"\u0001\u0005'\u00061A(\u001b8jiz\"b\u0001\u0016,X1fS\u0006CA+\u0001\u001b\u0005\u0011\u0001\"B\u000eR\u0001\u0004i\u0002\"\u0002\u001bR\u0001\u00041\u0004\"B!R\u0001\u0004\u0019\u0005\"B%R\u0001\u0004\u0019\u0005\"B'R\u0001\u0004q\u0005b\u0002/\u0001\u0005\u0004%I!X\u0001\u0006?NL'0Z\u000b\u0002=B\u0011qLZ\u0007\u0002A*\u0011\u0011MY\u0001\u0007CR|W.[2\u000b\u0005\r$\u0017AC2p]\u000e,(O]3oi*\u0011Q-I\u0001\u0005kRLG.\u0003\u0002hA\ni\u0011\t^8nS\u000eLe\u000e^3hKJDa!\u001b\u0001!\u0002\u0013q\u0016AB0tSj,\u0007\u0005C\u0003S\u0001\u0011\u00051\u000eF\u0002UY6DQa\u00076A\u0002uAQ\u0001\u000e6A\u0002YBQA\u0015\u0001\u0005\u0002=$\"\u0001\u00169\t\u000bmq\u0007\u0019A\u000f\t\u000bI\u0003A\u0011\u0001:\u0015\u0007Q\u001bH\u000fC\u0003\u001cc\u0002\u0007Q\u0004C\u0003vc\u0002\u0007a*A\u0004nkR\f'\r\\3\t\u000bI\u0003A\u0011A<\u0015\u000bQC\u0018P_>\t\u000bm1\b\u0019A\u000f\t\u000bQ2\b\u0019\u0001\u001c\t\u000b\u00053\b\u0019A\"\t\u000b%3\b\u0019A\"\t\u000bu\u0004A\u0011\u0001@\u0002\tI,\u0017\r\u001a\u000b\u0005)~\f\u0019\u0001\u0003\u0004\u0002\u0002q\u0004\raQ\u0001\ta>\u001c\u0018\u000e^5p]\"1\u0011Q\u0001?A\u0002\r\u000bAa]5{K\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0011!C:fCJ\u001c\u0007NR8s)\u0019\ti!a\u0005\u0002\u001eA\u0019Q+a\u0004\n\u0007\u0005E!A\u0001\bPM\u001a\u001cX\r\u001e)pg&$\u0018n\u001c8\t\u0011\u0005U\u0011q\u0001a\u0001\u0003/\tA\u0002^1sO\u0016$xJ\u001a4tKR\u00042!FA\r\u0013\r\tYB\u0006\u0002\u0005\u0019>tw\rC\u0004\u0002 \u0005\u001d\u0001\u0019A\"\u0002!M$\u0018M\u001d;j]\u001e\u0004vn]5uS>t\u0007bBA\u0012\u0001\u0011\u0005\u0011QE\u0001\boJLG/\u001a+p)\u001d\u0019\u0015qEA\u0019\u0003kA\u0001\"!\u000b\u0002\"\u0001\u0007\u00111F\u0001\fI\u0016\u001cHo\u00115b]:,G\u000eE\u00028\u0003[I1!a\f9\u0005Q9\u0015\r\u001e5fe&twMQ=uK\u000eC\u0017M\u001c8fY\"A\u00111GA\u0011\u0001\u0004\t9\"A\u0007xe&$X\rU8tSRLwN\u001c\u0005\b\u0003\u000b\t\t\u00031\u0001D\u0011\u001d\tI\u0004\u0001C!\u0003w\t\u0001\"\u001b;fe\u0006$xN\u001d\u000b\u0003\u0003{\u0001b!a\u0010\u0002P\u0005Uc\u0002BA!\u0003\u0017rA!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0004\u0003\u000f2\u0011A\u0002\u001fs_>$h(C\u0001\u0018\u0013\r\tiEF\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t&a\u0015\u0003\u0011%#XM]1u_JT1!!\u0014\u0017!\rI\u0011qK\u0005\u0004\u00033R!\u0001E'fgN\fw-Z!oI>3gm]3u\u0011\u001d\tI\u0004\u0001C\u0001\u0003;\"B!!\u0010\u0002`!9\u0011\u0011MA.\u0001\u0004\u0019\u0015AD7bq6+7o]1hKNK'0\u001a\u0005\b\u0003K\u0002A\u0011AA4\u0003-\u0019\u0018N_3J]\nKH/Z:\u0015\u0003\rCq!a\u001b\u0001\t\u0003\ti'\u0001\u0004baB,g\u000e\u001a\u000b\u0004Q\u0005=\u0004\u0002CA9\u0003S\u0002\r!a\u001d\u0002\u00115,7o]1hKN\u00042!CA;\u0013\r\t9H\u0003\u0002\u0015\u0005f$XMQ;gM\u0016\u0014X*Z:tC\u001e,7+\u001a;\t\u000f\u0005m\u0004\u0001\"\u0001\u0002~\u0005)a\r\\;tQR\t\u0001\u0006C\u0004\u0002\u0002\u0002!\t!! \u0002\u000b\rdwn]3\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002\b\u00061A-\u001a7fi\u0016$\u0012A\u0014\u0005\b\u0003\u0017\u0003A\u0011AAG\u0003)!(/\u001e8dCR,Gk\u001c\u000b\u0004\u0007\u0006=\u0005bBAI\u0003\u0013\u0003\raQ\u0001\u000bi\u0006\u0014x-\u001a;TSj,\u0007bBAK\u0001\u0011\u0005\u0011qS\u0001\te\u0016\fG-\u00138u_R1\u0011\u0011TAQ\u0003K\u0003B!a'\u0002\u001e6\t!(C\u0002\u0002 j\u0012!BQ=uK\n+hMZ3s\u0011!\t\u0019+a%A\u0002\u0005e\u0015A\u00022vM\u001a,'\u000fC\u0004\u0002\u0002\u0005M\u0005\u0019A\"\t\u000f\u0005%\u0006\u0001\"\u0001\u0002,\u0006A!/\u001a8b[\u0016$v\u000eF\u0002O\u0003[Cq!a,\u0002(\u0002\u0007Q$A\u0001gQ\r\u0001\u00111\u0017\t\u0004\u001f\u0005U\u0016bAA\\!\tian\u001c8uQJ,\u0017\rZ:bM\u0016\u0004")
public class FileMessageSet
extends MessageSet
implements Logging,
ScalaObject {
    private volatile File file;
    private final FileChannel channel;
    private final int start;
    private final int end;
    private final AtomicInteger _size;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public File file() {
        return this.file;
    }

    public void file_$eq(File file) {
        this.file = file;
    }

    public FileChannel channel() {
        return this.channel;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    private AtomicInteger _size() {
        return this._size;
    }

    public FileMessageSet(File file, FileChannel channel) {
        this(file, channel, 0, Integer.MAX_VALUE, false);
    }

    public FileMessageSet(File file) {
        this(file, Utils$.MODULE$.openChannel(file, true));
    }

    public FileMessageSet(File file, boolean mutable) {
        this(file, Utils$.MODULE$.openChannel(file, mutable));
    }

    public FileMessageSet(File file, FileChannel channel, int start, int end) {
        this(file, channel, start, end, true);
    }

    public FileMessageSet read(int position, int size2) {
        if (position < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid position: ").append((Object)BoxesRunTime.boxToInteger((int)position)).toString());
        }
        if (size2 < 0) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid size: ").append((Object)BoxesRunTime.boxToInteger((int)size2)).toString());
        }
        return new FileMessageSet(this.file(), this.channel(), this.start() + position, package$.MODULE$.min(this.start() + position + size2, this.sizeInBytes()));
    }

    public OffsetPosition searchFor(long targetOffset, int startingPosition) {
        int position = startingPosition;
        ByteBuffer buffer = ByteBuffer.allocate(MessageSet$.MODULE$.LogOverhead());
        int size2 = this.sizeInBytes();
        while (position + MessageSet$.MODULE$.LogOverhead() < size2) {
            buffer.rewind();
            this.channel().read(buffer, position);
            if (buffer.hasRemaining()) {
                throw new IllegalStateException(Predef$.MODULE$.augmentString("Failed to read complete buffer for targetOffset %d startPosition %d in %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)targetOffset), BoxesRunTime.boxToInteger((int)startingPosition), this.file().getAbsolutePath()})));
            }
            buffer.rewind();
            long offset = buffer.getLong();
            if (offset >= targetOffset) {
                return new OffsetPosition(offset, position);
            }
            int messageSize = buffer.getInt();
            if (messageSize < Message$.MODULE$.MessageOverhead()) {
                throw new IllegalStateException(new StringBuilder().append((Object)"Invalid message size: ").append((Object)BoxesRunTime.boxToInteger((int)messageSize)).toString());
            }
            position += MessageSet$.MODULE$.LogOverhead() + messageSize;
        }
        return null;
    }

    @Override
    public int writeTo(GatheringByteChannel destChannel, long writePosition, int size$1) {
        int newSize = package$.MODULE$.min((int)this.channel().size(), this.end()) - this.start();
        if (newSize < this._size().get()) {
            throw new KafkaException(Predef$.MODULE$.augmentString("Size of FileMessageSet %s has been truncated during write: old size %d, new size %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)this._size().get()), BoxesRunTime.boxToInteger((int)newSize)})));
        }
        int bytesTransferred$1 = (int)this.channel().transferTo((long)this.start() + writePosition, package$.MODULE$.min(size$1, this.sizeInBytes()), destChannel);
        this.trace((Function0<String>)new $anonfun$writeTo$1(this, size$1, bytesTransferred$1));
        return bytesTransferred$1;
    }

    @Override
    public Iterator<MessageAndOffset> iterator() {
        return this.iterator(Integer.MAX_VALUE);
    }

    public Iterator<MessageAndOffset> iterator(int maxMessageSize$1) {
        return new $anon$1(this, maxMessageSize$1);
    }

    @Override
    public int sizeInBytes() {
        return this._size().get();
    }

    public void append(ByteBufferMessageSet messages) {
        int written = messages.writeTo(this.channel(), 0L, messages.sizeInBytes());
        this._size().getAndAdd(written);
    }

    public void flush() {
        this.channel().force(true);
    }

    public void close() {
        this.flush();
        this.channel().close();
    }

    public boolean delete() {
        Utils$.MODULE$.swallow((Function0<BoxedUnit>)new $anonfun$delete$1(this));
        return this.file().delete();
    }

    public int truncateTo(int targetSize) {
        int originalSize = this.sizeInBytes();
        if (targetSize > originalSize || targetSize < 0) {
            throw new KafkaException(new StringBuilder().append((Object)"Attempt to truncate log segment to ").append((Object)BoxesRunTime.boxToInteger((int)targetSize)).append((Object)" bytes failed, ").append((Object)" size of this log segment is ").append((Object)BoxesRunTime.boxToInteger((int)originalSize)).append((Object)" bytes.").toString());
        }
        this.channel().truncate(targetSize);
        this.channel().position(targetSize);
        this._size().set(targetSize);
        return originalSize - targetSize;
    }

    public ByteBuffer readInto(ByteBuffer buffer, int position) {
        this.channel().read(buffer, position);
        buffer.flip();
        return buffer;
    }

    /*
     * WARNING - void declaration
     */
    public boolean renameTo(File f) {
        void var2_2;
        boolean success = this.file().renameTo(f);
        this.file_$eq(f);
        return (boolean)var2_2;
    }

    public FileMessageSet(File file, FileChannel channel, int start, int end, boolean isSlice) {
        this.file = file;
        this.channel = channel;
        this.start = start;
        this.end = end;
        Logging$class.$init$(this);
        this._size = isSlice ? new AtomicInteger(end - start) : new AtomicInteger(package$.MODULE$.min((int)channel.size(), end) - start);
        Object object = isSlice ? BoxedUnit.UNIT : channel.position(channel.size());
    }
}

