/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.common.TopicAndPartition;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.Log;
import kafka.log.LogCleaner$;
import kafka.log.LogCleaner$CleanerThread$;
import kafka.log.LogCleanerManager;
import kafka.log.LogToClean;
import kafka.log.SkimpyOffsetMap;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.Throttler;
import kafka.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005=g\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003\u00151{wm\u00117fC:,'O\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\u0011A1\u0002CA\u0005\u000f\u001b\u0005Q!BA\u0006\r\u0003\u0011a\u0017M\\4\u000b\u00035\tAA[1wC&\u0011qB\u0003\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005E!R\"\u0001\n\u000b\u0005M!\u0011!B;uS2\u001c\u0018BA\u000b\u0013\u0005\u001daunZ4j]\u001e\u0004\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u00111bU2bY\u0006|%M[3di\"AQ\u0004\u0001BC\u0002\u0013\u0005a$\u0001\u0004d_:4\u0017nZ\u000b\u0002?A\u0011\u0001%I\u0007\u0002\u0005%\u0011!E\u0001\u0002\u000e\u00072,\u0017M\\3s\u0007>tg-[4\t\u0011\u0011\u0002!\u0011!Q\u0001\n}\tqaY8oM&<\u0007\u0005\u0003\u0005'\u0001\t\u0015\r\u0011\"\u0001(\u0003\u001dawn\u001a#jeN,\u0012\u0001\u000b\t\u0004/%Z\u0013B\u0001\u0016\u0019\u0005\u0015\t%O]1z!\tas&D\u0001.\u0015\tqC\"\u0001\u0002j_&\u0011\u0001'\f\u0002\u0005\r&dW\r\u0003\u00053\u0001\t\u0005\t\u0015!\u0003)\u0003!awn\u001a#jeN\u0004\u0003\u0002\u0003\u001b\u0001\u0005\u000b\u0007I\u0011A\u001b\u0002\t1|wm]\u000b\u0002mA!\u0011cN\u001d@\u0013\tA$C\u0001\u0003Q_>d\u0007C\u0001\u001e>\u001b\u0005Y$B\u0001\u001f\u0005\u0003\u0019\u0019w.\\7p]&\u0011ah\u000f\u0002\u0012)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007C\u0001\u0011A\u0013\t\t%AA\u0002M_\u001eD\u0001b\u0011\u0001\u0003\u0002\u0003\u0006IAN\u0001\u0006Y><7\u000f\t\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\u0006!A/[7f!\t\tr)\u0003\u0002I%\t!A+[7f\u0011\u0015Q\u0005\u0001\"\u0001L\u0003\u0019a\u0014N\\5u}Q)A*\u0014(P!B\u0011\u0001\u0005\u0001\u0005\u0006;%\u0003\ra\b\u0005\u0006M%\u0003\r\u0001\u000b\u0005\u0006i%\u0003\rA\u000e\u0005\b\u000b&\u0003\n\u00111\u0001G\u0011\u001d\u0011\u0006A1A\u0005\nM\u000bab\u00197fC:,'/T1oC\u001e,'/F\u0001U!\t\u0001S+\u0003\u0002W\u0005\t\tBj\\4DY\u0016\fg.\u001a:NC:\fw-\u001a:\t\ra\u0003\u0001\u0015!\u0003U\u0003=\u0019G.Z1oKJl\u0015M\\1hKJ\u0004\u0003b\u0002.\u0001\u0005\u0004%IaW\u0001\ni\"\u0014x\u000e\u001e;mKJ,\u0012\u0001\u0018\t\u0003#uK!A\u0018\n\u0003\u0013QC'o\u001c;uY\u0016\u0014\bB\u00021\u0001A\u0003%A,\u0001\u0006uQJ|G\u000f\u001e7fe\u0002BqA\u0019\u0001C\u0002\u0013%1-\u0001\u0005dY\u0016\fg.\u001a:t+\u0005!\u0007cA3kY6\taM\u0003\u0002hQ\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003Sb\t!bY8mY\u0016\u001cG/[8o\u0013\tYgM\u0001\u0006J]\u0012,\u00070\u001a3TKF\u0004\"!\u001c8\u000e\u0003\u00011\u0001b\u001c\u0001\u0005\u0002\u0003\u0005I\u0001\u001d\u0002\u000e\u00072,\u0017M\\3s)\"\u0014X-\u00193\u0014\u00079\fh\u0003\u0005\u0002\u0012e&\u00111O\u0005\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fG\r\u0003\u0005v]\n\u0005\t\u0015!\u0003w\u0003!!\bN]3bI&#\u0007CA\fx\u0013\tA\bDA\u0002J]RDQA\u00138\u0005\u0002i$\"\u0001\\>\t\u000bUL\b\u0019\u0001<\t\u000fut'\u0019!C!}\u0006QAn\\4hKJt\u0015-\\3\u0016\u0003}\u00042!CA\u0001\u0013\r\t\u0019A\u0003\u0002\u0007'R\u0014\u0018N\\4\t\u000f\u0005\u001da\u000e)A\u0005\u007f\u0006YAn\\4hKJt\u0015-\\3!\u0011%\tYA\u001cb\u0001\n\u0003\ti!A\u0004dY\u0016\fg.\u001a:\u0016\u0005\u0005=\u0001c\u0001\u0011\u0002\u0012%\u0019\u00111\u0003\u0002\u0003\u000f\rcW-\u00198fe\"A\u0011q\u00038!\u0002\u0013\ty!\u0001\u0005dY\u0016\fg.\u001a:!\u0011\u001d\tYB\u001cC\u0005\u0003;\t\u0011b\u00195fG.$uN\\3\u0015\t\u0005}\u0011Q\u0005\t\u0004/\u0005\u0005\u0012bAA\u00121\t!QK\\5u\u0011\u001d\t9#!\u0007A\u0002e\n\u0011\u0003^8qS\u000e\fe\u000e\u001a)beRLG/[8o\u0011\u001d\tYC\u001cC!\u0003[\ta\u0001Z8X_J\\GCAA\u0010\u0011\u001d\t\tD\u001cC\u0005\u0003[\tAb\u00197fC:|%o\u00157fKBDq!!\u000eo\t\u0003\t9$\u0001\u0005m_\u001e\u001cF/\u0019;t)1\ty\"!\u000f\u0002>\u00055\u0013qKA.\u0011\u001d\tY$a\rA\u0002Y\f!!\u001b3\t\u0011\u0005}\u00121\u0007a\u0001\u0003\u0003\nAA\\1nKB!\u00111IA%\u001d\r9\u0012QI\u0005\u0004\u0003\u000fB\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0004\u0005-#bAA$1!A\u0011qJA\u001a\u0001\u0004\t\t&\u0001\u0003ge>l\u0007cA\f\u0002T%\u0019\u0011Q\u000b\r\u0003\t1{gn\u001a\u0005\t\u00033\n\u0019\u00041\u0001\u0002R\u0005\u0011Ao\u001c\u0005\t\u0003;\n\u0019\u00041\u0001\u0002`\u0005)1\u000f^1ugB\u0019\u0001%!\u0019\n\u0007\u0005\r$A\u0001\u0007DY\u0016\fg.\u001a:Ti\u0006$8\u000fC\u0004\u0002h\u0001\u0001\u000b\u0011\u00023\u0002\u0013\rdW-\u00198feN\u0004\u0003bBA6\u0001\u0011\u0005\u0011QF\u0001\bgR\f'\u000f^;q\u0011\u001d\ty\u0007\u0001C\u0001\u0003[\t\u0001b\u001d5vi\u0012|wO\u001c\u0005\b\u0003g\u0002A\u0011AA;\u00035\t'm\u001c:u\u00072,\u0017M\\5oOR!\u0011qDA<\u0011\u001d\t9#!\u001dA\u0002eBq!a\u001f\u0001\t\u0003\ti(A\u000bbE>\u0014H/\u00118e!\u0006,8/Z\"mK\u0006t\u0017N\\4\u0015\t\u0005}\u0011q\u0010\u0005\b\u0003O\tI\b1\u0001:\u0011\u001d\t\u0019\t\u0001C\u0001\u0003\u000b\u000baB]3tk6,7\t\\3b]&tw\r\u0006\u0003\u0002 \u0005\u001d\u0005bBA\u0014\u0003\u0003\u0003\r!\u000f\u0005\b\u0003\u0017\u0003A\u0011AAG\u00031\tw/Y5u\u00072,\u0017M\\3e))\ty\"a$\u0002\u0014\u0006]\u00151\u0014\u0005\t\u0003#\u000bI\t1\u0001\u0002B\u0005)Ao\u001c9jG\"9\u0011QSAE\u0001\u00041\u0018\u0001\u00029beRD\u0001\"!'\u0002\n\u0002\u0007\u0011\u0011K\u0001\u0007_\u001a47/\u001a;\t\u0015\u0005u\u0015\u0011\u0012I\u0001\u0002\u0004\t\t&A\u0004uS6,w.\u001e;\t\u0013\u0005\u0005\u0006!%A\u0005\u0002\u0005\r\u0016AF1xC&$8\t\\3b]\u0016$G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005\u0015&\u0006BA)\u0003O[#!!+\u0011\t\u0005-\u0016QW\u0007\u0003\u0003[SA!a,\u00022\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003gC\u0012AC1o]>$\u0018\r^5p]&!\u0011qWAW\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0004\n\u0003w\u0013\u0011\u0011!E\u0003\u0003{\u000b!\u0002T8h\u00072,\u0017M\\3s!\r\u0001\u0013q\u0018\u0004\n\u0003\t!\u0019\u0011!E\u0003\u0003\u0003\u001cB!a0\t-!9!*a0\u0005\u0002\u0005\u0015GCAA_\u0011)\tI-a0\u0012\u0002\u0013\u0005\u00111Z\u0001\u000fS:LG\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\tiMK\u0002G\u0003O\u0003")
public class LogCleaner
implements Logging,
ScalaObject {
    private final CleanerConfig config;
    private final File[] logDirs;
    private final Pool<TopicAndPartition, Log> logs;
    public final Time kafka$log$LogCleaner$$time;
    private final LogCleanerManager kafka$log$LogCleaner$$cleanerManager;
    private final Throttler kafka$log$LogCleaner$$throttler;
    private final IndexedSeq<CleanerThread> cleaners;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final Time init$default$4() {
        return LogCleaner$.MODULE$.init$default$4();
    }

    public long awaitCleaned$default$4() {
        return 30000L;
    }

    public CleanerConfig config() {
        return this.config;
    }

    public File[] logDirs() {
        return this.logDirs;
    }

    public Pool<TopicAndPartition, Log> logs() {
        return this.logs;
    }

    public final LogCleanerManager kafka$log$LogCleaner$$cleanerManager() {
        return this.kafka$log$LogCleaner$$cleanerManager;
    }

    public final Throttler kafka$log$LogCleaner$$throttler() {
        return this.kafka$log$LogCleaner$$throttler;
    }

    private IndexedSeq<CleanerThread> cleaners() {
        return this.cleaners;
    }

    public void startup() {
        this.info((Function0<String>)new $anonfun$startup$1(this));
        this.cleaners().foreach((Function1)new $anonfun$startup$2(this));
    }

    public void shutdown() {
        this.info((Function0<String>)new $anonfun$shutdown$1(this));
        this.cleaners().foreach((Function1)new $anonfun$shutdown$2(this));
    }

    public void abortCleaning(TopicAndPartition topicAndPartition) {
        this.kafka$log$LogCleaner$$cleanerManager().abortCleaning(topicAndPartition);
    }

    public void abortAndPauseCleaning(TopicAndPartition topicAndPartition) {
        this.kafka$log$LogCleaner$$cleanerManager().abortAndPauseCleaning(topicAndPartition);
    }

    public void resumeCleaning(TopicAndPartition topicAndPartition) {
        this.kafka$log$LogCleaner$$cleanerManager().resumeCleaning(topicAndPartition);
    }

    public void awaitCleaned(String topic, int part, long offset, long timeout) {
        while (!this.kafka$log$LogCleaner$$cleanerManager().allCleanerCheckpoints().contains((Object)new TopicAndPartition(topic, part))) {
            Thread.sleep(10L);
        }
        return;
    }

    public LogCleaner(CleanerConfig config, File[] logDirs, Pool<TopicAndPartition, Log> logs, Time time) {
        this.config = config;
        this.logDirs = logDirs;
        this.logs = logs;
        this.kafka$log$LogCleaner$$time = time;
        Logging$class.$init$(this);
        this.kafka$log$LogCleaner$$cleanerManager = new LogCleanerManager(logDirs, logs);
        this.kafka$log$LogCleaner$$throttler = new Throttler(config.maxIoBytesPerSecond(), 300L, true, time);
        this.cleaners = (IndexedSeq)((TraversableLike)Predef$.MODULE$.intWrapper(0).until(config.numThreads())).map((Function1)new $anonfun$1(this), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public class CleanerThread
    extends ShutdownableThread
    implements ScalaObject {
        private final String loggerName;
        private final Cleaner cleaner;
        public final LogCleaner $outer;

        public String loggerName() {
            return this.loggerName;
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public final void kafka$log$LogCleaner$CleanerThread$$checkDone(TopicAndPartition topicAndPartition) {
            if (this.isRunning().get()) {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$cleanerManager().checkCleaningAborted(topicAndPartition);
                return;
            }
            throw new ThreadShutdownException();
        }

        public void doWork() {
            this.cleanOrSleep();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void cleanOrSleep() {
            LogToClean logToClean;
            Option<LogToClean> option = this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$cleanerManager().grabFilthiestLog();
            None$ none$ = None$.MODULE$;
            Option<LogToClean> option2 = option;
            if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time.sleep(this.kafka$log$LogCleaner$CleanerThread$$$outer().config().backOffMs());
                return;
            }
            if (!(option instanceof Some)) throw new MatchError(option);
            Some some = (Some)option;
            LogToClean cleanable = logToClean = (LogToClean)some.x();
            long endOffset = cleanable.firstDirtyOffset();
            try {
                endOffset = this.cleaner().clean(cleanable);
                this.logStats(this.cleaner().id(), cleanable.log().name(), cleanable.firstDirtyOffset(), endOffset, this.cleaner().stats());
                return;
            }
            catch (LogCleaningAbortedException logCleaningAbortedException) {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().dir().getParentFile(), endOffset);
            }
            return;
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().dir().getParentFile(), endOffset);
            }
        }

        public void logStats(int id, String name, long from, long to, CleanerStats stats) {
            String message$1 = new StringBuilder().append((Object)Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append((Object)Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)this.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append((Object)Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(this.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append((Object)Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(this.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append((Object)Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append((Object)Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append((Object)Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
            this.info((Function0<String>)new CleanerThread$$anonfun$logStats$1(this, message$1));
        }

        public LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return this.$outer;
        }

        private final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(LogCleaner $outer, int threadId) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(new StringBuilder().append((Object)"kafka-log-cleaner-thread-").append((Object)BoxesRunTime.boxToInteger((int)threadId)).toString(), false);
            this.loggerName = LogCleaner.class.getName();
            if ($outer.config().dedupeBufferSize() / (long)$outer.config().numThreads() > Integer.MAX_VALUE) {
                this.warn((Function0<String>)new CleanerThread$$anonfun$2(this));
            }
            this.cleaner = new Cleaner(threadId, new SkimpyOffsetMap((int)package$.MODULE$.min($outer.config().dedupeBufferSize() / (long)$outer.config().numThreads(), Integer.MAX_VALUE), $outer.config().hashAlgorithm()), $outer.config().ioBufferSize() / $outer.config().numThreads() / 2, $outer.config().maxMessageSize(), $outer.config().dedupeBufferLoadFactor(), $outer.kafka$log$LogCleaner$$throttler(), $outer.kafka$log$LogCleaner$$time, (Function1<TopicAndPartition, BoxedUnit>)new CleanerThread$$anonfun$3(this));
        }
    }
}

