/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import kafka.network.BoundedByteBufferReceive$;
import kafka.network.InvalidRequestException;
import kafka.network.Receive;
import kafka.network.Receive$class;
import kafka.network.Transmission$class;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001!4\u0011\"\u0001\u0002\u0005\u0002\u0003\u0005\t\u0001\u0002\u0004\u00031\t{WO\u001c3fI\nKH/\u001a\"vM\u001a,'OU3dK&4XM\u0003\u0002\u0004\t\u00059a.\u001a;x_J\\'\"A\u0003\u0002\u000b-\fgm[1\u0014\u000b\u00019qbE\r\u0011\u0005!iQ\"A\u0005\u000b\u0005)Y\u0011\u0001\u00027b]\u001eT\u0011\u0001D\u0001\u0005U\u00064\u0018-\u0003\u0002\u000f\u0013\t1qJ\u00196fGR\u0004\"\u0001E\t\u000e\u0003\tI!A\u0005\u0002\u0003\u000fI+7-Z5wKB\u0011AcF\u0007\u0002+)\u0011a\u0003B\u0001\u0006kRLGn]\u0005\u00031U\u0011q\u0001T8hO&tw\r\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2DA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002\u0003\u0011\u0001\u0005\u000b\u0007I\u0011\u0001\u0012\u0002\u000f5\f\u0007pU5{K\u000e\u0001Q#A\u0012\u0011\u0005i!\u0013BA\u0013\u001c\u0005\rIe\u000e\u001e\u0005\tO\u0001\u0011\t\u0011)A\u0005G\u0005AQ.\u0019=TSj,\u0007\u0005C\u0003*\u0001\u0011\u0005!&\u0001\u0004=S:LGO\u0010\u000b\u0003W1\u0002\"\u0001\u0005\u0001\t\u000b\u0001B\u0003\u0019A\u0012\t\u000f9\u0002!\u0019!C\u0005_\u0005Q1/\u001b>f\u0005V4g-\u001a:\u0016\u0003A\u0002\"!\r\u001b\u000e\u0003IR!aM\u0006\u0002\u00079Lw.\u0003\u00026e\tQ!)\u001f;f\u0005V4g-\u001a:\t\r]\u0002\u0001\u0015!\u00031\u0003-\u0019\u0018N_3Ck\u001a4WM\u001d\u0011\t\u000fe\u0002\u0001\u0019!C\u0005_\u0005i1m\u001c8uK:$()\u001e4gKJDqa\u000f\u0001A\u0002\u0013%A(A\td_:$XM\u001c;Ck\u001a4WM]0%KF$\"!\u0010!\u0011\u0005iq\u0014BA \u001c\u0005\u0011)f.\u001b;\t\u000f\u0005S\u0014\u0011!a\u0001a\u0005\u0019\u0001\u0010J\u0019\t\r\r\u0003\u0001\u0015)\u00031\u00039\u0019wN\u001c;f]R\u0014UO\u001a4fe\u0002BQ!\u000b\u0001\u0005\u0002\u0015#\u0012a\u000b\u0005\b\u000f\u0002\u0001\r\u0011\"\u0001I\u0003!\u0019w.\u001c9mKR,W#A%\u0011\u0005iQ\u0015BA&\u001c\u0005\u001d\u0011un\u001c7fC:Dq!\u0014\u0001A\u0002\u0013\u0005a*\u0001\u0007d_6\u0004H.\u001a;f?\u0012*\u0017\u000f\u0006\u0002>\u001f\"9\u0011\tTA\u0001\u0002\u0004I\u0005BB)\u0001A\u0003&\u0011*A\u0005d_6\u0004H.\u001a;fA!)1\u000b\u0001C\u0001_\u00051!-\u001e4gKJDQ!\u0016\u0001\u0005\u0002Y\u000b\u0001B]3bI\u001a\u0013x.\u001c\u000b\u0003G]CQ\u0001\u0017+A\u0002e\u000bqa\u00195b]:,G\u000e\u0005\u0002[;6\t1L\u0003\u0002]e\u0005A1\r[1o]\u0016d7/\u0003\u0002_7\n\u0019\"+Z1eC\ndWMQ=uK\u000eC\u0017M\u001c8fY\")\u0001\r\u0001C\u0005C\u0006\u0011\"-\u001f;f\u0005V4g-\u001a:BY2|7-\u0019;f)\t\u0001$\rC\u0003d?\u0002\u00071%\u0001\u0003tSj,\u0007F\u0001\u0001f!\t!b-\u0003\u0002h+\tian\u001c8uQJ,\u0017\rZ:bM\u0016\u0004")
public class BoundedByteBufferReceive
implements Receive,
Logging,
ScalaObject {
    private final int maxSize;
    private final ByteBuffer sizeBuffer;
    private ByteBuffer contentBuffer;
    private boolean complete;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public int maxSize() {
        return this.maxSize;
    }

    private ByteBuffer sizeBuffer() {
        return this.sizeBuffer;
    }

    private ByteBuffer contentBuffer() {
        return this.contentBuffer;
    }

    private void contentBuffer_$eq(ByteBuffer byteBuffer) {
        this.contentBuffer = byteBuffer;
    }

    public BoundedByteBufferReceive() {
        this(Integer.MAX_VALUE);
    }

    @Override
    public boolean complete() {
        return this.complete;
    }

    public void complete_$eq(boolean bl) {
        this.complete = bl;
    }

    @Override
    public ByteBuffer buffer() {
        this.expectComplete();
        return this.contentBuffer();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readFrom(ReadableByteChannel channel) {
        void var2_2;
        this.expectIncomplete();
        int read2 = 0;
        if (this.sizeBuffer().remaining() > 0) {
            read2 += Utils$.MODULE$.read(channel, this.sizeBuffer());
        }
        if (this.contentBuffer() == null && !this.sizeBuffer().hasRemaining()) {
            this.sizeBuffer().rewind();
            int size2 = this.sizeBuffer().getInt();
            if (size2 <= 0) {
                throw new InvalidRequestException(Predef$.MODULE$.augmentString("%d is not a valid request size.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size2)})));
            }
            if (size2 > this.maxSize()) {
                throw new InvalidRequestException(Predef$.MODULE$.augmentString("Request of length %d is not valid, it is larger than the maximum size of %d bytes.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size2), BoxesRunTime.boxToInteger((int)this.maxSize())})));
            }
            this.contentBuffer_$eq(this.byteBufferAllocate(size2));
        }
        if (this.contentBuffer() != null) {
            read2 = Utils$.MODULE$.read(channel, this.contentBuffer());
            if (!this.contentBuffer().hasRemaining()) {
                this.contentBuffer().rewind();
                this.complete_$eq(true);
            }
        }
        return (int)var2_2;
    }

    private ByteBuffer byteBufferAllocate(int size$1) {
        ByteBuffer buffer = null;
        try {
            buffer = ByteBuffer.allocate(size$1);
            return buffer;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.error((Function0<String>)new $anonfun$byteBufferAllocate$1(this, size$1), (Function0<Throwable>)new $anonfun$byteBufferAllocate$2(this, outOfMemoryError));
            throw outOfMemoryError;
        }
    }

    public BoundedByteBufferReceive(int maxSize) {
        this.maxSize = maxSize;
        Logging$class.$init$(this);
        Transmission$class.$init$(this);
        Receive$class.$init$(this);
        this.sizeBuffer = ByteBuffer.allocate(4);
        this.contentBuffer = null;
        this.complete = false;
    }
}

