/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import kafka.api.ProducerRequest;
import kafka.api.ProducerRequest$;
import kafka.api.ProducerResponse;
import kafka.api.ProducerResponse$;
import kafka.api.RequestKeys$;
import kafka.api.RequestOrResponse;
import kafka.api.TopicMetadataRequest;
import kafka.api.TopicMetadataResponse;
import kafka.api.TopicMetadataResponse$;
import kafka.metrics.KafkaTimer;
import kafka.network.BlockingChannel;
import kafka.network.BlockingChannel$;
import kafka.network.BoundedByteBufferSend;
import kafka.network.Receive;
import kafka.producer.ProducerRequestStats;
import kafka.producer.ProducerRequestStatsRegistry$;
import kafka.producer.SyncProducer$;
import kafka.producer.SyncProducerConfig;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005}t!B\u0001\u0003\u0011\u000b9\u0011\u0001D*z]\u000e\u0004&o\u001c3vG\u0016\u0014(BA\u0002\u0005\u0003!\u0001(o\u001c3vG\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019A!B\u0001C\u0001\u0002#\u00151B\u0001\u0007Ts:\u001c\u0007K]8ek\u000e,'oE\u0002\n\u0019Q\u0001\"!\u0004\n\u000e\u00039Q!a\u0004\t\u0002\t1\fgn\u001a\u0006\u0002#\u0005!!.\u0019<b\u0013\t\u0019bB\u0001\u0004PE*,7\r\u001e\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000fC\u0003\u001c\u0013\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002\u000f!9a$\u0003b\u0001\n\u0003y\u0012A\u0003*fcV,7\u000f^&fsV\t\u0001\u0005\u0005\u0002\u0016C%\u0011!E\u0006\u0002\u0006'\"|'\u000f\u001e\u0005\u0007I%\u0001\u000b\u0011\u0002\u0011\u0002\u0017I+\u0017/^3ti.+\u0017\u0010\t\u0005\bM%\u0011\r\u0011\"\u0001(\u0003=\u0011\u0018M\u001c3p[\u001e+g.\u001a:bi>\u0014X#\u0001\u0015\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-\u0002\u0012\u0001B;uS2L!!\f\u0016\u0003\rI\u000bg\u000eZ8n\u0011\u0019y\u0013\u0002)A\u0005Q\u0005\u0001\"/\u00198e_6<UM\\3sCR|'\u000f\t\u0004\t\u0015\t!\t\u0011!A\u0001cM!\u0001\u0007\u0004\u001a\u0015!\t\u0019d'D\u00015\u0015\t)D!A\u0003vi&d7/\u0003\u00028i\t9Aj\\4hS:<\u0007\u0002C\u001d1\u0005\u000b\u0007I\u0011\u0001\u001e\u0002\r\r|gNZ5h+\u0005Y\u0004C\u0001\u0005=\u0013\ti$A\u0001\nTs:\u001c\u0007K]8ek\u000e,'oQ8oM&<\u0007\u0002C 1\u0005\u0003\u0005\u000b\u0011B\u001e\u0002\u000f\r|gNZ5hA!)1\u0004\rC\u0001\u0003R\u0011!i\u0011\t\u0003\u0011ABQ!\u000f!A\u0002mBq!\u0012\u0019C\u0002\u0013%a)\u0001\u0003m_\u000e\\W#\u0001\u0007\t\r!\u0003\u0004\u0015!\u0003\r\u0003\u0015awnY6!\u0011\u001dQ\u0005\u00071A\u0005\n-\u000b\u0001b\u001d5vi\u0012|wO\\\u000b\u0002\u0019B\u0011Q#T\u0005\u0003\u001dZ\u0011qAQ8pY\u0016\fg\u000eC\u0004Qa\u0001\u0007I\u0011B)\u0002\u0019MDW\u000f\u001e3po:|F%Z9\u0015\u0005I+\u0006CA\u000bT\u0013\t!fC\u0001\u0003V]&$\bb\u0002,P\u0003\u0003\u0005\r\u0001T\u0001\u0004q\u0012\n\u0004B\u0002-1A\u0003&A*A\u0005tQV$Hm\\<oA!\u0012qK\u0017\t\u0003+mK!\u0001\u0018\f\u0003\u0011Y|G.\u0019;jY\u0016DqA\u0018\u0019C\u0002\u0013%q,A\bcY>\u001c7.\u001b8h\u0007\"\fgN\\3m+\u0005\u0001\u0007CA1e\u001b\u0005\u0011'BA2\u0005\u0003\u001dqW\r^<pe.L!!\u001a2\u0003\u001f\tcwnY6j]\u001e\u001c\u0005.\u00198oK2Daa\u001a\u0019!\u0002\u0013\u0001\u0017\u0001\u00052m_\u000e\\\u0017N\\4DQ\u0006tg.\u001a7!\u0011\u001dI\u0007G1A\u0005\u0002)\f!B\u0019:pW\u0016\u0014\u0018J\u001c4p+\u0005Y\u0007C\u00017p\u001d\t)R.\u0003\u0002o-\u00051\u0001K]3eK\u001aL!\u0001]9\u0003\rM#(/\u001b8h\u0015\tqg\u0003\u0003\u0004ta\u0001\u0006Ia[\u0001\fEJ|7.\u001a:J]\u001a|\u0007\u0005C\u0004va\t\u0007I\u0011\u0001<\u0002)A\u0014x\u000eZ;dKJ\u0014V-];fgR\u001cF/\u0019;t+\u00059\bC\u0001\u0005y\u0013\tI(A\u0001\u000bQe>$WoY3s%\u0016\fX/Z:u'R\fGo\u001d\u0005\u0007wB\u0002\u000b\u0011B<\u0002+A\u0014x\u000eZ;dKJ\u0014V-];fgR\u001cF/\u0019;tA!)Q\u0010\rC\u0005}\u0006ia/\u001a:jMf\u0014V-];fgR$\"AU@\t\u000f\u0005\u0005A\u00101\u0001\u0002\u0004\u00059!/Z9vKN$\b\u0003BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%A!A\u0002ba&LA!!\u0004\u0002\b\t\t\"+Z9vKN$xJ\u001d*fgB|gn]3\t\u000f\u0005E\u0001\u0007\"\u0003\u0002\u0014\u00051Am\\*f]\u0012$b!!\u0006\u0002\u001c\u0005u\u0001cA1\u0002\u0018%\u0019\u0011\u0011\u00042\u0003\u000fI+7-Z5wK\"A\u0011\u0011AA\b\u0001\u0004\t\u0019\u0001C\u0005\u0002 \u0005=\u0001\u0013!a\u0001\u0019\u0006a!/Z1e%\u0016\u001c\bo\u001c8tK\"9\u00111\u0005\u0019\u0005\u0002\u0005\u0015\u0012\u0001B:f]\u0012$B!a\n\u0002.A!\u0011QAA\u0015\u0013\u0011\tY#a\u0002\u0003!A\u0013x\u000eZ;dKJ\u0014Vm\u001d9p]N,\u0007\u0002CA\u0018\u0003C\u0001\r!!\r\u0002\u001fA\u0014x\u000eZ;dKJ\u0014V-];fgR\u0004B!!\u0002\u00024%!\u0011QGA\u0004\u0005=\u0001&o\u001c3vG\u0016\u0014(+Z9vKN$\bbBA\u0012a\u0011\u0005\u0011\u0011\b\u000b\u0005\u0003w\t\t\u0005\u0005\u0003\u0002\u0006\u0005u\u0012\u0002BA \u0003\u000f\u0011Q\u0003V8qS\u000elU\r^1eCR\f'+Z:q_:\u001cX\r\u0003\u0005\u0002\u0002\u0005]\u0002\u0019AA\"!\u0011\t)!!\u0012\n\t\u0005\u001d\u0013q\u0001\u0002\u0015)>\u0004\u0018nY'fi\u0006$\u0017\r^1SKF,Xm\u001d;\t\u000f\u0005-\u0003\u0007\"\u0001\u0002N\u0005)1\r\\8tKR\t!\u000bC\u0004\u0002RA\"I!!\u0014\u0002\u0015\u0011L7oY8o]\u0016\u001cG\u000fC\u0004\u0002VA\"I!a\u0016\u0002\u000f\r|gN\\3diR\t\u0001\rC\u0004\u0002\\A\"I!!\u0014\u0002'\u001d,Go\u0014:NC.,7i\u001c8oK\u000e$\u0018n\u001c8\t\u0013\u0005}\u0003'%A\u0005\n\u0005\u0005\u0014\u0001\u00053p'\u0016tG\r\n3fM\u0006,H\u000e\u001e\u00133+\t\t\u0019GK\u0002M\u0003KZ#!a\u001a\u0011\t\u0005%\u00141O\u0007\u0003\u0003WRA!!\u001c\u0002p\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003c2\u0012AC1o]>$\u0018\r^5p]&!\u0011QOA6\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0015\u0004a\u0005e\u0004cA\u001a\u0002|%\u0019\u0011Q\u0010\u001b\u0003\u0015QD'/Z1eg\u00064W\r")
public class SyncProducer
implements Logging,
ScalaObject {
    private final SyncProducerConfig config;
    private final Object lock;
    private volatile boolean shutdown;
    private final BlockingChannel blockingChannel;
    private final String brokerInfo;
    private final ProducerRequestStats producerRequestStats;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final Random randomGenerator() {
        return SyncProducer$.MODULE$.randomGenerator();
    }

    public static final short RequestKey() {
        return SyncProducer$.MODULE$.RequestKey();
    }

    private boolean doSend$default$2() {
        return true;
    }

    public SyncProducerConfig config() {
        return this.config;
    }

    private Object lock() {
        return this.lock;
    }

    private boolean shutdown() {
        return this.shutdown;
    }

    private void shutdown_$eq(boolean bl) {
        this.shutdown = bl;
    }

    private BlockingChannel blockingChannel() {
        return this.blockingChannel;
    }

    public String brokerInfo() {
        return this.brokerInfo;
    }

    public ProducerRequestStats producerRequestStats() {
        return this.producerRequestStats;
    }

    private void verifyRequest(RequestOrResponse request) {
        if (this.logger().isDebugEnabled()) {
            ByteBuffer buffer$1 = new BoundedByteBufferSend(request).buffer();
            this.trace((Function0<String>)new $anonfun$verifyRequest$1(this, buffer$1));
            short requestTypeId = buffer$1.getShort();
            if (requestTypeId == RequestKeys$.MODULE$.ProduceKey()) {
                ProducerRequest request$1 = ProducerRequest$.MODULE$.readFrom(buffer$1);
                this.trace((Function0<String>)new $anonfun$verifyRequest$2(this, request$1));
            }
        }
    }

    public final Receive kafka$producer$SyncProducer$$doSend(RequestOrResponse request$2, boolean readResponse$1) {
        Object object = this.lock();
        synchronized (object) {
            this.verifyRequest(request$2);
            this.getOrMakeConnection();
            ObjectRef response$1 = new ObjectRef(null);
            this.liftedTree1$1(request$2, readResponse$1, response$1);
            Receive receive = (Receive)response$1.elem;
            return receive;
        }
    }

    public ProducerResponse send(ProducerRequest producerRequest$1) {
        int requestSize = producerRequest$1.sizeInBytes();
        this.producerRequestStats().getProducerRequestStats(this.brokerInfo()).requestSizeHist().update(requestSize);
        this.producerRequestStats().getProducerRequestAllBrokersStats().requestSizeHist().update(requestSize);
        ObjectRef response$2 = new ObjectRef(null);
        KafkaTimer specificTimer$1 = this.producerRequestStats().getProducerRequestStats(this.brokerInfo()).requestTimer();
        KafkaTimer aggregateTimer = this.producerRequestStats().getProducerRequestAllBrokersStats().requestTimer();
        aggregateTimer.time(new $anonfun$send$1(this, producerRequest$1, response$2, specificTimer$1));
        return producerRequest$1.requiredAcks() != 0 ? ProducerResponse$.MODULE$.readFrom(((Receive)response$2.elem).buffer()) : null;
    }

    public TopicMetadataResponse send(TopicMetadataRequest request) {
        Receive response = this.kafka$producer$SyncProducer$$doSend(request, this.doSend$default$2());
        return TopicMetadataResponse$.MODULE$.readFrom(response.buffer());
    }

    public void close() {
        Object object = this.lock();
        synchronized (object) {
            this.disconnect();
            this.shutdown_$eq(true);
            return;
        }
    }

    private void disconnect() {
        try {
            if (this.blockingChannel().isConnected()) {
                this.info((Function0<String>)new $anonfun$disconnect$1(this));
                this.blockingChannel().disconnect();
            }
        }
        catch (Exception exception) {
            this.error((Function0<String>)new $anonfun$disconnect$2(this), (Function0<Throwable>)new $anonfun$disconnect$3(this, exception));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BlockingChannel connect() {
        if (this.blockingChannel().isConnected() || this.shutdown()) return this.blockingChannel();
        try {
            this.blockingChannel().connect();
            this.info((Function0<String>)new $anonfun$connect$1(this));
        }
        catch (Exception exception) {
            this.disconnect();
            this.error((Function0<String>)new $anonfun$connect$2(this), (Function0<Throwable>)new $anonfun$connect$3(this, exception));
            throw exception;
        }
        return this.blockingChannel();
    }

    private void getOrMakeConnection() {
        if (!this.blockingChannel().isConnected()) {
            this.connect();
        }
    }

    private final void liftedTree1$1(RequestOrResponse requestOrResponse, boolean bl, ObjectRef objectRef) {
        try {
            this.blockingChannel().send(requestOrResponse);
            if (bl) {
                objectRef.elem = this.blockingChannel().receive();
            } else {
                this.trace((Function0<String>)new $anonfun$liftedTree1$1$1(this));
            }
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (IOException iOException) {
            this.disconnect();
            throw iOException;
        }
    }

    public SyncProducer(SyncProducerConfig config) {
        this.config = config;
        Logging$class.$init$(this);
        this.lock = new Object();
        this.shutdown = false;
        this.blockingChannel = new BlockingChannel(config.host(), config.port(), BlockingChannel$.MODULE$.UseDefaultBufferSize(), config.sendBufferBytes(), config.requestTimeoutMs());
        this.brokerInfo = Predef$.MODULE$.augmentString("host_%s-port_%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{config.host(), BoxesRunTime.boxToInteger((int)config.port())}));
        this.producerRequestStats = ProducerRequestStatsRegistry$.MODULE$.getProducerRequestStats(config.clientId());
        this.trace((Function0<String>)new $anonfun$1(this));
    }
}

