/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.concurrent.CountDownLatch;
import kafka.api.FetchRequest;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.api.Request$;
import kafka.cluster.Broker;
import kafka.common.TopicAndPartition;
import kafka.consumer.SimpleConsumer;
import kafka.tools.ReplicaBuffer;
import kafka.tools.ReplicaFetcher$;
import kafka.tools.ReplicaVerificationTool$;
import kafka.utils.ShutdownableThread;
import kafka.utils.ShutdownableThread$;
import scala.Function0;
import scala.Function1;
import scala.ScalaObject;
import scala.collection.Iterable;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001q4\u0001\"\u0001\u0002\u0005\u0002\u0003\u0005Ia\u0002\u0002\u000f%\u0016\u0004H.[2b\r\u0016$8\r[3s\u0015\t\u0019A!A\u0003u_>d7OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\tYA!A\u0003vi&d7/\u0003\u0002\u000e\u0015\t\u00112\u000b[;uI><h.\u00192mKRC'/Z1e!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0013U\u0001!\u0011!Q\u0001\nYi\u0012\u0001\u00028b[\u0016\u0004\"a\u0006\u000e\u000f\u0005=A\u0012BA\r\u0011\u0003\u0019\u0001&/\u001a3fM&\u00111\u0004\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e\u0001\u0012BA\u000b\r\u0011!y\u0002A!A!\u0002\u0013\u0001\u0013\u0001D:pkJ\u001cWM\u0011:pW\u0016\u0014\bCA\u0011%\u001b\u0005\u0011#BA\u0012\u0005\u0003\u001d\u0019G.^:uKJL!!\n\u0012\u0003\r\t\u0013xn[3s\u0011!9\u0003A!A!\u0002\u0013A\u0013A\u0005;pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]N\u00042!K\u00195\u001d\tQsF\u0004\u0002,]5\tAF\u0003\u0002.\r\u00051AH]8pizJ\u0011!E\u0005\u0003aA\tq\u0001]1dW\u0006<W-\u0003\u00023g\tA\u0011\n^3sC\ndWM\u0003\u00021!A\u0011Q\u0007O\u0007\u0002m)\u0011q\u0007B\u0001\u0007G>lWn\u001c8\n\u0005e2$!\u0005+pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]\"A1\b\u0001B\u0001B\u0003%A(A\u0007sKBd\u0017nY1Ck\u001a4WM\u001d\t\u0003{yj\u0011AA\u0005\u0003\u007f\t\u0011QBU3qY&\u001c\u0017MQ;gM\u0016\u0014\b\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\u0002\u001bM|7m[3u)&lWm\\;u!\ty1)\u0003\u0002E!\t\u0019\u0011J\u001c;\t\u0011\u0019\u0003!\u0011!Q\u0001\n\t\u000b\u0001c]8dW\u0016$()\u001e4gKJ\u001c\u0016N_3\t\u0011!\u0003!\u0011!Q\u0001\n\t\u000b\u0011BZ3uG\"\u001c\u0016N_3\t\u0011)\u0003!\u0011!Q\u0001\n\t\u000bq!\\1y/\u0006LG\u000f\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003C\u0003!i\u0017N\u001c\"zi\u0016\u001c\b\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011B(\u0002\u001d\u0011|g+\u001a:jM&\u001c\u0017\r^5p]B\u0011q\u0002U\u0005\u0003#B\u0011qAQ8pY\u0016\fg\u000eC\u0003T\u0001\u0011\u0005A+\u0001\u0004=S:LGO\u0010\u000b\f+Z;\u0006,\u0017.\\9vsv\f\u0005\u0002>\u0001!)QC\u0015a\u0001-!)qD\u0015a\u0001A!)qE\u0015a\u0001Q!)1H\u0015a\u0001y!)\u0011I\u0015a\u0001\u0005\")aI\u0015a\u0001\u0005\")\u0001J\u0015a\u0001\u0005\")!J\u0015a\u0001\u0005\")AJ\u0015a\u0001\u0005\")aJ\u0015a\u0001\u001f\"9\u0011\r\u0001b\u0001\n\u0003\u0011\u0017AD:j[BdWmQ8ogVlWM]\u000b\u0002GB\u0011AmZ\u0007\u0002K*\u0011a\rB\u0001\tG>t7/^7fe&\u0011\u0001.\u001a\u0002\u000f'&l\u0007\u000f\\3D_:\u001cX/\\3s\u0011\u0019Q\u0007\u0001)A\u0005G\u0006y1/[7qY\u0016\u001cuN\\:v[\u0016\u0014\b\u0005C\u0004m\u0001\t\u0007I\u0011A7\u0002'\u0019,Go\u00195SKF,Xm\u001d;Ck&dG-\u001a:\u0016\u00039\u0004\"a\u001c:\u000e\u0003AT!!\u001d\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0002ta\n\u0019b)\u001a;dQJ+\u0017/^3ti\n+\u0018\u000e\u001c3fe\"1Q\u000f\u0001Q\u0001\n9\fACZ3uG\"\u0014V-];fgR\u0014U/\u001b7eKJ\u0004\u0003\"B<\u0001\t\u0003B\u0018A\u00023p/>\u00148\u000eF\u0001z!\ty!0\u0003\u0002|!\t!QK\\5u\u0001")
public class ReplicaFetcher
extends ShutdownableThread
implements ScalaObject {
    public final Broker kafka$tools$ReplicaFetcher$$sourceBroker;
    private final Iterable<TopicAndPartition> topicAndPartitions;
    public final ReplicaBuffer kafka$tools$ReplicaFetcher$$replicaBuffer;
    public final int kafka$tools$ReplicaFetcher$$fetchSize;
    private final boolean doVerification;
    private final SimpleConsumer simpleConsumer;
    private final FetchRequestBuilder fetchRequestBuilder;

    public SimpleConsumer simpleConsumer() {
        return this.simpleConsumer;
    }

    public FetchRequestBuilder fetchRequestBuilder() {
        return this.fetchRequestBuilder;
    }

    @Override
    public void doWork() {
        CountDownLatch verificationBarrier;
        CountDownLatch fetcherBarrier;
        block5: {
            FetchResponse response;
            block4: {
                fetcherBarrier = this.kafka$tools$ReplicaFetcher$$replicaBuffer.getFetcherBarrier();
                verificationBarrier = this.kafka$tools$ReplicaFetcher$$replicaBuffer.getVerificationBarrier();
                this.topicAndPartitions.foreach((Function1)new $anonfun$doWork$1(this));
                FetchRequest fetchRequest$1 = this.fetchRequestBuilder().build();
                this.debug((Function0<String>)new $anonfun$doWork$2(this, fetchRequest$1));
                response = null;
                try {
                    response = this.simpleConsumer().fetch(fetchRequest$1);
                }
                finally {
                    if (response != null) break block4;
                }
                this.topicAndPartitions.foreach((Function1)new $anonfun$doWork$4(this));
                break block5;
            }
            response.data().foreach((Function1)new $anonfun$doWork$3(this));
        }
        fetcherBarrier.countDown();
        this.debug((Function0<String>)new $anonfun$doWork$5(this));
        fetcherBarrier.await();
        this.debug((Function0<String>)new $anonfun$doWork$6(this));
        if (this.doVerification) {
            this.debug((Function0<String>)new $anonfun$doWork$7(this));
            this.kafka$tools$ReplicaFetcher$$replicaBuffer.verifyCheckSum();
            this.kafka$tools$ReplicaFetcher$$replicaBuffer.createNewFetcherBarrier();
            this.kafka$tools$ReplicaFetcher$$replicaBuffer.createNewVerificationBarrier();
            this.debug((Function0<String>)new $anonfun$doWork$8(this));
            verificationBarrier.countDown();
        }
        verificationBarrier.await();
        this.debug((Function0<String>)new $anonfun$doWork$9(this));
    }

    public ReplicaFetcher(String name, Broker sourceBroker, Iterable<TopicAndPartition> topicAndPartitions, ReplicaBuffer replicaBuffer, int socketTimeout, int socketBufferSize, int fetchSize, int maxWait, int minBytes, boolean doVerification) {
        this.kafka$tools$ReplicaFetcher$$sourceBroker = sourceBroker;
        this.topicAndPartitions = topicAndPartitions;
        this.kafka$tools$ReplicaFetcher$$replicaBuffer = replicaBuffer;
        this.kafka$tools$ReplicaFetcher$$fetchSize = fetchSize;
        this.doVerification = doVerification;
        super(name, ShutdownableThread$.MODULE$.init$default$2());
        this.simpleConsumer = new SimpleConsumer(sourceBroker.host(), sourceBroker.port(), socketTimeout, socketBufferSize, ReplicaVerificationTool$.MODULE$.clientId());
        this.fetchRequestBuilder = new FetchRequestBuilder().clientId(ReplicaVerificationTool$.MODULE$.clientId()).replicaId(Request$.MODULE$.DebuggingConsumerId()).maxWait(maxWait).minBytes(minBytes);
    }
}

