/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.OutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.tools.VerifyConsumerRebalance$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Map;
import scala.runtime.BooleanRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VerifyConsumerRebalance$
implements Logging,
ScalaObject {
    public static final VerifyConsumerRebalance$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new VerifyConsumerRebalance$();
    }

    public void main(String[] args) {
        OptionParser parser$1 = new OptionParser();
        ArgumentAcceptingOptionSpec zkConnectOpt = parser$1.accepts("zookeeper.connect", "ZooKeeper connect string.").withRequiredArg().defaultsTo((Object)"localhost:2181", (Object[])new String[0]).ofType(String.class);
        ArgumentAcceptingOptionSpec groupOpt = parser$1.accepts("group", "Consumer group.").withRequiredArg().ofType(String.class);
        parser$1.accepts("help", "Print this message.");
        OptionSet options$1 = parser$1.parse(args);
        if (options$1.has("help")) {
            parser$1.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{groupOpt})).foreach((Function1)new anonfun.main.1(parser$1, options$1));
        String zkConnect$1 = (String)options$1.valueOf((OptionSpec)zkConnectOpt);
        String group$1 = (String)options$1.valueOf((OptionSpec)groupOpt);
        ZkClient zkClient = null;
        try {
            zkClient = new ZkClient(zkConnect$1, 30000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
            this.debug((Function0<String>)new anonfun.main.2(zkConnect$1, group$1));
            try {
                if (this.validateRebalancingOperation(zkClient, group$1)) {
                    Predef$.MODULE$.println((Object)"Rebalance operation successful !");
                }
                Predef$.MODULE$.println((Object)"Rebalance operation failed !");
            }
            catch (Throwable throwable) {
                this.error((Function0<String>)new anonfun.main.3(), (Function0<Throwable>)new anonfun.main.4(throwable));
            }
            return;
        }
        finally {
            if (zkClient != null) {
                zkClient.close();
            }
        }
    }

    private boolean validateRebalancingOperation(ZkClient zkClient$1, String group$2) {
        this.info((Function0<String>)new anonfun.validateRebalancingOperation.1(group$2));
        BooleanRef rebalanceSucceeded$1 = new BooleanRef(true);
        Map<String, List<String>> consumersPerTopicMap$1 = ZkUtils$.MODULE$.getConsumersPerTopic(zkClient$1, group$2);
        Map<String, Seq<Object>> partitionsPerTopicMap = ZkUtils$.MODULE$.getPartitionsForTopics(zkClient$1, (Seq<String>)consumersPerTopicMap$1.keySet().toSeq());
        partitionsPerTopicMap.foreach((Function1)new anonfun.validateRebalancingOperation.2(zkClient$1, group$2, rebalanceSucceeded$1, consumersPerTopicMap$1));
        return rebalanceSucceeded$1.elem;
    }

    private VerifyConsumerRebalance$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

