/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import kafka.utils.FileLock$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.ScalaObject;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001M3\u0001\"\u0001\u0002\u0005\u0002\u0003\u0005\ta\u0002\u0002\t\r&dW\rT8dW*\u00111\u0001B\u0001\u0006kRLGn\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\t!Q\u0001\"!\u0003\b\u000e\u0003)Q!a\u0003\u0007\u0002\t1\fgn\u001a\u0006\u0002\u001b\u0005!!.\u0019<b\u0013\ty!B\u0001\u0004PE*,7\r\u001e\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011q\u0001T8hO&tw\r\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbCA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002C\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002\t\u0019LG.Z\u000b\u0002;A\u0011a$I\u0007\u0002?)\u0011\u0001\u0005D\u0001\u0003S>L!AI\u0010\u0003\t\u0019KG.\u001a\u0005\tI\u0001\u0011\t\u0011)A\u0005;\u0005)a-\u001b7fA!)a\u0005\u0001C\u0001O\u00051A(\u001b8jiz\"\"\u0001K\u0015\u0011\u0005E\u0001\u0001\"B\u000e&\u0001\u0004i\u0002bB\u0016\u0001\u0005\u0004%I\u0001L\u0001\bG\"\fgN\\3m+\u0005i\u0003C\u0001\u00184\u001b\u0005y#B\u0001\u00192\u0003!\u0019\u0007.\u00198oK2\u001c(B\u0001\u001a\r\u0003\rq\u0017n\\\u0005\u0003i=\u00121BR5mK\u000eC\u0017M\u001c8fY\"1a\u0007\u0001Q\u0001\n5\n\u0001b\u00195b]:,G\u000e\t\u0005\bq\u0001\u0001\r\u0011\"\u0003:\u0003\u00151Gn\\2l+\u0005Q\u0004C\u0001\u0018<\u0013\t\tq\u0006C\u0004>\u0001\u0001\u0007I\u0011\u0002 \u0002\u0013\u0019dwnY6`I\u0015\fHCA C!\t)\u0002)\u0003\u0002B-\t!QK\\5u\u0011\u001d\u0019E(!AA\u0002i\n1\u0001\u001f\u00132\u0011\u0019)\u0005\u0001)Q\u0005u\u00051a\r\\8dW\u0002BQa\u0012\u0001\u0005\u0002!\u000bA\u0001\\8dWR\tq\bC\u0003K\u0001\u0011\u00051*A\u0004uefdunY6\u0015\u00031\u0003\"!F'\n\u000593\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006!\u0002!\t\u0001S\u0001\u0007k:dwnY6\t\u000bI\u0003A\u0011\u0001%\u0002\u000f\u0011,7\u000f\u001e:ps\u0002")
public class FileLock
implements Logging,
ScalaObject {
    private final File file;
    private final FileChannel channel;
    private java.nio.channels.FileLock flock;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public File file() {
        return this.file;
    }

    private FileChannel channel() {
        return this.channel;
    }

    private java.nio.channels.FileLock flock() {
        return this.flock;
    }

    private void flock_$eq(java.nio.channels.FileLock fileLock) {
        this.flock = fileLock;
    }

    public void lock() {
        FileLock fileLock = this;
        synchronized (fileLock) {
            this.trace((Function0<String>)new $anonfun$lock$1(this));
            this.flock_$eq(this.channel().lock());
            return;
        }
    }

    public boolean tryLock() {
        FileLock fileLock = this;
        synchronized (fileLock) {
            this.trace((Function0<String>)new $anonfun$tryLock$1(this));
            Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.liftedTree1$1());
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }

    public void unlock() {
        FileLock fileLock = this;
        synchronized (fileLock) {
            BoxedUnit boxedUnit;
            this.trace((Function0<String>)new $anonfun$unlock$1(this));
            if (this.flock() == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.flock().release();
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void destroy() {
        FileLock fileLock = this;
        synchronized (fileLock) {
            this.unlock();
            this.channel().close();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean liftedTree1$1() {
        void var1_1;
        boolean exceptionResult1 = false;
        try {
            this.flock_$eq(this.channel().tryLock());
            exceptionResult1 = this.flock() != null;
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            exceptionResult1 = false;
        }
        return (boolean)var1_1;
    }

    public FileLock(File file) {
        this.file = file;
        Logging$class.$init$(this);
        file.createNewFile();
        this.channel = new RandomAccessFile(file, "rw").getChannel();
        this.flock = null;
    }
}

