/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Throttler$;
import kafka.utils.Time;
import kafka.utils.Time$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.ScalaObject;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005}a\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003\u0013QC'o\u001c;uY\u0016\u0014(BA\u0002\u0005\u0003\u0015)H/\u001b7t\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0005\u0001!\u0001B\u0003\u0005\u0002\n\u001d5\t!B\u0003\u0002\f\u0019\u0005!A.\u00198h\u0015\u0005i\u0011\u0001\u00026bm\u0006L!a\u0004\u0006\u0003\r=\u0013'.Z2u!\t\t\"#D\u0001\u0003\u0013\t\u0019\"AA\u0004M_\u001e<\u0017N\\4\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t7\u0001\u0011)\u0019!C\u00019\u0005\tB-Z:je\u0016$'+\u0019;f!\u0016\u00148+Z2\u0016\u0003u\u0001\"!\u0006\u0010\n\u0005}1\"A\u0002#pk\ndW\r\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003\u001e\u0003I!Wm]5sK\u0012\u0014\u0016\r^3QKJ\u001cVm\u0019\u0011\t\u0011\r\u0002!Q1A\u0005\u0002\u0011\nqb\u00195fG.Le\u000e^3sm\u0006dWj]\u000b\u0002KA\u0011QCJ\u0005\u0003OY\u0011A\u0001T8oO\"A\u0011\u0006\u0001B\u0001B\u0003%Q%\u0001\tdQ\u0016\u001c7.\u00138uKJ4\u0018\r\\'tA!A1\u0006\u0001BC\u0002\u0013\u0005A&\u0001\u0007uQJ|G\u000f\u001e7f\t><h.F\u0001.!\t)b&\u0003\u00020-\t9!i\\8mK\u0006t\u0007\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\u0002\u001bQD'o\u001c;uY\u0016$un\u001e8!\u0011!\u0019\u0004A!b\u0001\n\u0003!\u0014\u0001\u0002;j[\u0016,\u0012!\u000e\t\u0003#YJ!a\u000e\u0002\u0003\tQKW.\u001a\u0005\ts\u0001\u0011\t\u0011)A\u0005k\u0005)A/[7fA!)1\b\u0001C\u0001y\u00051A(\u001b8jiz\"R!\u0010 @\u0001\u0006\u0003\"!\u0005\u0001\t\u000bmQ\u0004\u0019A\u000f\t\u000f\rR\u0004\u0013!a\u0001K!91F\u000fI\u0001\u0002\u0004i\u0003bB\u001a;!\u0003\u0005\r!\u000e\u0005\b\u0007\u0002\u0011\r\u0011\"\u0003E\u0003\u0011awnY6\u0016\u0003!AaA\u0012\u0001!\u0002\u0013A\u0011!\u00027pG.\u0004\u0003b\u0002%\u0001\u0001\u0004%I\u0001J\u0001\u000ea\u0016\u0014\u0018n\u001c3Ti\u0006\u0014HOT:\t\u000f)\u0003\u0001\u0019!C\u0005\u0017\u0006\t\u0002/\u001a:j_\u0012\u001cF/\u0019:u\u001dN|F%Z9\u0015\u00051{\u0005CA\u000bN\u0013\tqeC\u0001\u0003V]&$\bb\u0002)J\u0003\u0003\u0005\r!J\u0001\u0004q\u0012\n\u0004B\u0002*\u0001A\u0003&Q%\u0001\bqKJLw\u000eZ*uCJ$hj\u001d\u0011\t\u000fQ\u0003\u0001\u0019!C\u00059\u0005iqNY:feZ,GmU8GCJDqA\u0016\u0001A\u0002\u0013%q+A\tpEN,'O^3e'>4\u0015M]0%KF$\"\u0001\u0014-\t\u000fA+\u0016\u0011!a\u0001;!1!\f\u0001Q!\nu\tab\u001c2tKJ4X\rZ*p\r\u0006\u0014\b\u0005C\u0003]\u0001\u0011\u0005Q,A\u0007nCf\u0014W\r\u00165s_R$H.\u001a\u000b\u0003\u0019zCQaX.A\u0002u\t\u0001b\u001c2tKJ4X\r\u001a\u0015\u0003\u0001\u0005\u0004\"!\u00052\n\u0005\r\u0014!A\u0003;ie\u0016\fGm]1gK\u001e)QM\u0001E\u0003M\u0006IA\u000b\u001b:piRdWM\u001d\t\u0003#\u001d4\u0001\"\u0001\u0002\u0005\u0002\u0003E)\u0001[\n\u0004O\"!\u0002\"B\u001eh\t\u0003QG#\u00014\t\u000b1<G\u0011A7\u0002\t5\f\u0017N\u001c\u000b\u0003\u0019:DQa\\6A\u0002A\fA!\u0019:hgB\u0019Q#]:\n\u0005I4\"!B!se\u0006L\bC\u0001;x\u001d\t)R/\u0003\u0002w-\u00051\u0001K]3eK\u001aL!\u0001_=\u0003\rM#(/\u001b8h\u0015\t1h\u0003C\u0004|OF\u0005I\u0011\u0001?\u0002\u001d%t\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\tQP\u000b\u0002&}.\nq\u0010\u0005\u0003\u0002\u0002\u0005-QBAA\u0002\u0015\u0011\t)!a\u0002\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0005-\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00111\u0001\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA\tOF\u0005I\u0011AA\n\u00039Ig.\u001b;%I\u00164\u0017-\u001e7uIM*\"!!\u0006+\u00055r\b\"CA\rOF\u0005I\u0011AA\u000e\u00039Ig.\u001b;%I\u00164\u0017-\u001e7uIQ*\"!!\b+\u0005Ur\b")
public class Throttler
implements Logging,
ScalaObject {
    private final double desiredRatePerSec;
    private final long checkIntervalMs;
    private final boolean throttleDown;
    private final Time time;
    private final Object lock;
    private long periodStartNs;
    private double observedSoFar;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final Time init$default$4() {
        return Throttler$.MODULE$.init$default$4();
    }

    public static final boolean init$default$3() {
        return Throttler$.MODULE$.init$default$3();
    }

    public static final long init$default$2() {
        return Throttler$.MODULE$.init$default$2();
    }

    public static final void main(String[] stringArray) {
        Throttler$.MODULE$.main(stringArray);
    }

    public double desiredRatePerSec() {
        return this.desiredRatePerSec;
    }

    public long checkIntervalMs() {
        return this.checkIntervalMs;
    }

    public boolean throttleDown() {
        return this.throttleDown;
    }

    public Time time() {
        return this.time;
    }

    private Object lock() {
        return this.lock;
    }

    private long periodStartNs() {
        return this.periodStartNs;
    }

    private void periodStartNs_$eq(long l) {
        this.periodStartNs = l;
    }

    private double observedSoFar() {
        return this.observedSoFar;
    }

    private void observedSoFar_$eq(double d) {
        this.observedSoFar = d;
    }

    public void maybeThrottle(double observed) {
        Object object = this.lock();
        synchronized (object) {
            BoxedUnit boxedUnit;
            this.observedSoFar_$eq(this.observedSoFar() + observed);
            long now = this.time().nanoseconds();
            long elapsedNs = now - this.periodStartNs();
            if (elapsedNs > this.checkIntervalMs() * (long)Time$.MODULE$.NsPerMs() && this.observedSoFar() > 0.0) {
                boolean needAdjustment;
                double rateInSecs$1 = this.observedSoFar() * (double)Time$.MODULE$.NsPerSec() / (double)elapsedNs;
                boolean bl = needAdjustment = !(this.throttleDown() ^ rateInSecs$1 > this.desiredRatePerSec());
                if (needAdjustment) {
                    double desiredRateMs = this.desiredRatePerSec() / (double)Time$.MODULE$.MsPerSec();
                    long elapsedMs = elapsedNs / (long)Time$.MODULE$.NsPerMs();
                    long sleepTime$1 = package$.MODULE$.round(this.observedSoFar() / desiredRateMs - (double)elapsedMs);
                    if (sleepTime$1 > 0L) {
                        this.trace((Function0<String>)new $anonfun$maybeThrottle$1(this, rateInSecs$1, sleepTime$1));
                        this.time().sleep(sleepTime$1);
                    }
                }
                this.periodStartNs_$eq(now);
                this.observedSoFar_$eq(0.0);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public Throttler(double desiredRatePerSec, long checkIntervalMs, boolean throttleDown, Time time) {
        this.desiredRatePerSec = desiredRatePerSec;
        this.checkIntervalMs = checkIntervalMs;
        this.throttleDown = throttleDown;
        this.time = time;
        Logging$class.$init$(this);
        this.lock = new Object();
        this.periodStartNs = time.nanoseconds();
        this.observedSoFar = 0.0;
    }
}

