/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.OutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.admin.AdminUtils$;
import kafka.admin.AdministrationException;
import kafka.common.Topic$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenSet;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class CreateTopicCommand$
implements Logging {
    public static final CreateTopicCommand$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new CreateTopicCommand$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        CreateTopicCommand$ createTopicCommand$ = this;
        synchronized (createTopicCommand$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void main(String[] stringArray) {
        OptionParser optionParser = new OptionParser();
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec = optionParser.accepts("topic", "REQUIRED: The topic to be created.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec2 = optionParser.accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec3 = optionParser.accepts("partition", "number of partitions in the topic").withRequiredArg().describedAs("# of partitions").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec4 = optionParser.accepts("replica", "replication factor for each partitions in the topic").withRequiredArg().describedAs("replication factor").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec5 = optionParser.accepts("replica-assignment-list", "for manually assigning replicas to brokers").withRequiredArg().describedAs("broker_id_for_part1_replica1 : broker_id_for_part1_replica2, broker_id_for_part2_replica1 : broker_id_for_part2_replica2, ...").ofType(String.class).defaultsTo((Object)"", (Object[])new String[0]);
        OptionSet optionSet = optionParser.parse(stringArray);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{argumentAcceptingOptionSpec, argumentAcceptingOptionSpec2})).foreach((Function1)new Serializable(optionParser, optionSet){
            public static final long serialVersionUID;
            private final OptionParser parser$1;
            private final OptionSet options$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ArgumentAcceptingOptionSpec<String> argumentAcceptingOptionSpec) {
                if (!this.options$1.has(argumentAcceptingOptionSpec)) {
                    System.err.println(new StringBuilder().append((Object)"Missing required argument \"").append(argumentAcceptingOptionSpec).append((Object)"\"").toString());
                    this.parser$1.printHelpOn((OutputStream)System.err);
                    System.exit(1);
                }
            }
            {
                this.parser$1 = optionParser;
                this.options$1 = optionSet;
            }
        });
        String string = (String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec);
        String string2 = (String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec2);
        int n = (Integer)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec3);
        int n2 = (Integer)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec4);
        String string3 = (String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec5);
        ZkClient zkClient = null;
        try {
            zkClient = new ZkClient(string2, 30000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
            this.createTopic(zkClient, string, n, n2, string3);
            Predef$.MODULE$.println((Object)"creation succeeded!");
            if (zkClient == null) return;
        }
        catch (Throwable throwable) {
            try {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"creation failed because of ").append((Object)throwable.getMessage()).toString());
                Predef$.MODULE$.println((Object)Utils$.MODULE$.stackTrace(throwable));
            }
            finally {
                if (zkClient == null) return;
                zkClient.close();
            }
        }
        zkClient.close();
    }

    public void createTopic(ZkClient zkClient, String string, int n, int n2, String string2) {
        Topic$.MODULE$.validate(string);
        Seq<Object> seq = ZkUtils$.MODULE$.getSortedBrokerList(zkClient);
        String string3 = string2;
        String string4 = "";
        scala.collection.immutable.Map<Object, List<Object>> map = !(string3 != null ? !string3.equals(string4) : string4 != null) ? AdminUtils$.MODULE$.assignReplicasToBrokers(seq, n, n2, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5()) : this.getManualReplicaAssignment(string2, (Set<Object>)seq.toSet());
        this.debug((Function0<String>)new Serializable(string, (Map)map){
            public static final long serialVersionUID;
            private final String topic$1;
            private final Map partitionReplicaAssignment$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Replica assignment list for %s is %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.partitionReplicaAssignment$1}));
            }
            {
                this.topic$1 = string;
                this.partitionReplicaAssignment$1 = map;
            }
        });
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(string, (Map<Object, Seq<Object>>)map, zkClient, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4());
    }

    public String createTopic$default$5() {
        return "";
    }

    public int createTopic$default$4() {
        return 1;
    }

    public int createTopic$default$3() {
        return 1;
    }

    public scala.collection.immutable.Map<Object, List<Object>> getManualReplicaAssignment(String string, Set<Object> set) {
        String[] stringArray = string.split(",");
        HashMap hashMap = new HashMap();
        Predef$.MODULE$.intWrapper(0).until(Predef$.MODULE$.refArrayOps((Object[])stringArray).size()).foreach$mVc$sp((Function1)new Serializable(set, stringArray, hashMap){
            public static final long serialVersionUID;
            private final Set availableBrokerList$1;
            private final String[] partitionList$1;
            private final HashMap ret$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int n) {
                this.apply$mcVI$sp(n);
            }

            public void apply$mcVI$sp(int n) {
                int[] nArray = (int[])Predef$.MODULE$.refArrayOps((Object[])this.partitionList$1[n].split(":")).map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final int apply(String string) {
                        return Predef$.MODULE$.augmentString(string.trim()).toInt();
                    }
                }, Array$.MODULE$.canBuildFrom((ClassManifest)Manifest$.MODULE$.Int()));
                if (Predef$.MODULE$.intArrayOps(nArray).size() <= 0) {
                    throw new AdministrationException("replication factor must be larger than 0");
                }
                if (Predef$.MODULE$.intArrayOps(nArray).size() != Predef$.MODULE$.intArrayOps(nArray).toSet().size()) {
                    throw new AdministrationException(new StringBuilder().append((Object)"duplicate brokers in replica assignment: ").append((Object)nArray).toString());
                }
                if (Predef$.MODULE$.intArrayOps(nArray).toSet().subsetOf((GenSet)this.availableBrokerList$1)) {
                    this.ret$1.put((Object)BoxesRunTime.boxToInteger((int)n), (Object)Predef$.MODULE$.intArrayOps(nArray).toList());
                    if (((SeqLike)this.ret$1.apply((Object)BoxesRunTime.boxToInteger((int)n))).size() != ((SeqLike)this.ret$1.apply((Object)BoxesRunTime.boxToInteger((int)0))).size()) {
                        throw new AdministrationException(new StringBuilder().append((Object)"partition ").append((Object)BoxesRunTime.boxToInteger((int)n)).append((Object)" has different replication factor: ").append((Object)nArray).toString());
                    }
                    return;
                }
                throw new AdministrationException(new StringBuilder().append((Object)"some specified brokers not available. specified brokers: ").append((Object)nArray.toString()).append((Object)"available broker:").append((Object)this.availableBrokerList$1.toString()).toString());
            }
            {
                this.availableBrokerList$1 = set;
                this.partitionList$1 = stringArray;
                this.ret$1 = hashMap;
            }
        });
        return hashMap.toMap(Predef$.MODULE$.conforms());
    }

    private CreateTopicCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

