/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.OutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.cluster.Broker;
import kafka.utils.Utils$;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListTopicCommand$
implements ScalaObject {
    public static final ListTopicCommand$ MODULE$;

    static {
        new ListTopicCommand$();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void main(String[] stringArray) {
        OptionParser optionParser = new OptionParser();
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec = optionParser.accepts("topic", "REQUIRED: The topic to be listed. Defaults to all existing topics.").withRequiredArg().describedAs("topic").ofType(String.class).defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec2 = optionParser.accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        OptionSpecBuilder optionSpecBuilder = optionParser.accepts("under-replicated-partitions", "if set, only show under replicated partitions");
        OptionSpecBuilder optionSpecBuilder2 = optionParser.accepts("unavailable-partitions", "if set, only show partitions whose leader is not available");
        OptionSet optionSet = optionParser.parse(stringArray);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{argumentAcceptingOptionSpec2})).foreach((Function1)new Serializable(optionParser, optionSet){
            public static final long serialVersionUID;
            private final OptionParser parser$1;
            private final OptionSet options$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ArgumentAcceptingOptionSpec<String> argumentAcceptingOptionSpec) {
                if (!this.options$1.has(argumentAcceptingOptionSpec)) {
                    System.err.println(new StringBuilder().append((Object)"Missing required argument \"").append(argumentAcceptingOptionSpec).append((Object)"\"").toString());
                    this.parser$1.printHelpOn((OutputStream)System.err);
                    System.exit(1);
                }
            }
            {
                this.parser$1 = optionParser;
                this.options$1 = optionSet;
            }
        });
        String string = (String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec);
        String string2 = (String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec2);
        boolean bl = optionSet.has((OptionSpec)optionSpecBuilder);
        boolean bl2 = optionSet.has((OptionSpec)optionSpecBuilder2);
        ObjectRef objectRef = new ObjectRef(null);
        try {
            void var15_16;
            Nil$ nil$ = Nil$.MODULE$;
            objectRef.elem = new ZkClient(string2, 30000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
            String string3 = string;
            String string4 = "";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                Seq seq = (Seq)ZkUtils$.MODULE$.getChildrenParentMayNotExist((ZkClient)objectRef.elem, ZkUtils$.MODULE$.BrokerTopicsPath()).sorted((Ordering)Ordering.String$.MODULE$);
            } else {
                List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{string}));
            }
            if (var15_16.size() <= 0) {
                Predef$.MODULE$.println((Object)"no topics exist!");
            }
            Set set = ((TraversableOnce)ZkUtils$.MODULE$.getAllBrokersInCluster((ZkClient)objectRef.elem).map((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final int apply(Broker broker) {
                    return broker.id();
                }
            }, Seq$.MODULE$.canBuildFrom())).toSet();
            var15_16.foreach((Function1)new Serializable(bl, bl2, objectRef, set){
                public static final long serialVersionUID;
                private final boolean reportUnderReplicatedPartitions$1;
                private final boolean reportUnavailablePartitions$1;
                private final ObjectRef zkClient$1;
                private final Set liveBrokers$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(String string) {
                    ListTopicCommand$.MODULE$.showTopic(string, (ZkClient)this.zkClient$1.elem, this.reportUnderReplicatedPartitions$1, this.reportUnavailablePartitions$1, (Set<Object>)this.liveBrokers$1);
                }
                {
                    this.reportUnderReplicatedPartitions$1 = bl;
                    this.reportUnavailablePartitions$1 = bl2;
                    this.zkClient$1 = objectRef;
                    this.liveBrokers$1 = set;
                }
            });
        }
        catch (Throwable throwable) {
            try {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"list topic failed because of ").append((Object)throwable.getMessage()).toString());
                Predef$.MODULE$.println((Object)Utils$.MODULE$.stackTrace(throwable));
            }
            finally {
                if ((ZkClient)objectRef.elem == null) return;
                ((ZkClient)objectRef.elem).close();
            }
        }
        if ((ZkClient)objectRef.elem == null) return;
        ((ZkClient)objectRef.elem).close();
    }

    public void showTopic(String string, ZkClient zkClient, boolean bl, boolean bl2, Set<Object> set) {
        Option option;
        block4: {
            block3: {
                block2: {
                    Map map;
                    option = ZkUtils$.MODULE$.getPartitionAssignmentForTopics(zkClient, (Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{string}))).get((Object)string);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Map map2 = map = (Map)some.x();
                    List list = (List)map2.toList().sortWith((Function2)new Serializable(){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final boolean apply(Tuple2<Object, Seq<Object>> tuple2, Tuple2<Object, Seq<Object>> tuple22) {
                            return tuple2._1$mcI$sp() < tuple22._1$mcI$sp();
                        }
                    });
                    ((LinearSeqOptimized)list.filter((Function1)new Serializable(){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final boolean apply(Tuple2<Object, Seq<Object>> tuple2) {
                            Tuple2<Object, Seq<Object>> tuple22 = tuple2;
                            return tuple22 != null;
                        }
                    })).foreach((Function1)new Serializable(string, zkClient, bl, bl2, set){
                        public static final long serialVersionUID;
                        private final String topic$1;
                        private final ZkClient zkClient$2;
                        private final boolean reportUnderReplicatedPartitions$2;
                        private final boolean reportUnavailablePartitions$2;
                        private final Set liveBrokers$2;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply(Tuple2<Object, Seq<Object>> tuple2) {
                            Tuple2<Object, Seq<Object>> tuple22 = tuple2;
                            if (tuple22 != null) {
                                int n = BoxesRunTime.unboxToInt((Object)tuple22._1());
                                Seq seq = (Seq)tuple22._2();
                                int n2 = n;
                                Seq seq2 = seq;
                                Seq<Object> seq3 = ZkUtils$.MODULE$.getInSyncReplicasForPartition(this.zkClient$2, this.topic$1, n2);
                                Option<Object> option = ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient$2, this.topic$1, n2);
                                if (!this.reportUnderReplicatedPartitions$2 && !this.reportUnavailablePartitions$2 || this.reportUnderReplicatedPartitions$2 && seq3.size() < seq2.size() || this.reportUnavailablePartitions$2 && (!option.isDefined() || !this.liveBrokers$2.contains(option.get()))) {
                                    Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"topic: ").append((Object)this.topic$1).toString());
                                    Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"\tpartition: ").append((Object)BoxesRunTime.boxToInteger((int)n2)).toString());
                                    Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"\tleader: ").append(option.isDefined() ? option.get() : "none").toString());
                                    Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"\treplicas: ").append((Object)seq2.mkString(",")).toString());
                                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"\tisr: ").append((Object)seq3.mkString(",")).toString());
                                }
                                return;
                            }
                            throw new MatchError(tuple22);
                        }
                        {
                            this.topic$1 = string;
                            this.zkClient$2 = zkClient;
                            this.reportUnderReplicatedPartitions$2 = bl;
                            this.reportUnavailablePartitions$2 = bl2;
                            this.liveBrokers$2 = set;
                        }
                    });
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"topic ").append((Object)string).append((Object)" doesn't exist!").toString());
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    private ListTopicCommand$() {
        MODULE$ = this;
    }
}

