/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import kafka.api.FetchResponsePartitionData;
import kafka.api.FetchResponsePartitionData$;
import kafka.network.Send;
import kafka.network.Send$class;
import kafka.network.Transmission$class;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001}3A!\u0001\u0002\u0001\u000f\t\t\u0002+\u0019:uSRLwN\u001c#bi\u0006\u001cVM\u001c3\u000b\u0005\r!\u0011aA1qS*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001A\u0001C\u0006\t\u0003\u00139i\u0011A\u0003\u0006\u0003\u00171\tA\u0001\\1oO*\tQ\"\u0001\u0003kCZ\f\u0017BA\b\u000b\u0005\u0019y%M[3diB\u0011\u0011\u0003F\u0007\u0002%)\u00111\u0003B\u0001\b]\u0016$xo\u001c:l\u0013\t)\"C\u0001\u0003TK:$\u0007CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"aC*dC2\fwJ\u00196fGRD\u0001\"\b\u0001\u0003\u0006\u0004%\tAH\u0001\fa\u0006\u0014H/\u001b;j_:LE-F\u0001 !\t9\u0002%\u0003\u0002\"1\t\u0019\u0011J\u001c;\t\u0011\r\u0002!\u0011!Q\u0001\n}\tA\u0002]1si&$\u0018n\u001c8JI\u0002B\u0001\"\n\u0001\u0003\u0006\u0004%\tAJ\u0001\u000ea\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0016\u0003\u001d\u0002\"\u0001K\u0015\u000e\u0003\tI!A\u000b\u0002\u00035\u0019+Go\u00195SKN\u0004xN\\:f!\u0006\u0014H/\u001b;j_:$\u0015\r^1\t\u00111\u0002!\u0011!Q\u0001\n\u001d\na\u0002]1si&$\u0018n\u001c8ECR\f\u0007\u0005C\u0003/\u0001\u0011\u0005q&\u0001\u0004=S:LGO\u0010\u000b\u0004aE\u0012\u0004C\u0001\u0015\u0001\u0011\u0015iR\u00061\u0001 \u0011\u0015)S\u00061\u0001(\u0011\u001d!\u0004A1A\u0005\ny\t1\"\\3tg\u0006<WmU5{K\"1a\u0007\u0001Q\u0001\n}\tA\"\\3tg\u0006<WmU5{K\u0002Bq\u0001\u000f\u0001A\u0002\u0013%a$\u0001\tnKN\u001c\u0018mZ3t'\u0016tGoU5{K\"9!\b\u0001a\u0001\n\u0013Y\u0014\u0001F7fgN\fw-Z:TK:$8+\u001b>f?\u0012*\u0017\u000f\u0006\u0002=\u007fA\u0011q#P\u0005\u0003}a\u0011A!\u00168ji\"9\u0001)OA\u0001\u0002\u0004y\u0012a\u0001=%c!1!\t\u0001Q!\n}\t\u0011#\\3tg\u0006<Wm]*f]R\u001c\u0016N_3!\u0011\u001d!\u0005A1A\u0005\n\u0015\u000baAY;gM\u0016\u0014X#\u0001$\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%c\u0011a\u00018j_&\u00111\n\u0013\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\bBB'\u0001A\u0003%a)A\u0004ck\u001a4WM\u001d\u0011\t\u000b=\u0003A\u0011\t)\u0002\u0011\r|W\u000e\u001d7fi\u0016,\u0012!\u0015\t\u0003/IK!a\u0015\r\u0003\u000f\t{w\u000e\\3b]\")Q\u000b\u0001C!-\u00069qO]5uKR{GCA\u0010X\u0011\u0015AF\u000b1\u0001Z\u0003\u001d\u0019\u0007.\u00198oK2\u0004\"AW/\u000e\u0003mS!\u0001\u0018%\u0002\u0011\rD\u0017M\u001c8fYNL!AX.\u0003)\u001d\u000bG\u000f[3sS:<')\u001f;f\u0007\"\fgN\\3m\u0001")
public class PartitionDataSend
implements Send {
    private final int partitionId;
    private final FetchResponsePartitionData partitionData;
    private final int messageSize;
    private int messagesSentSize;
    private final ByteBuffer buffer;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public int writeCompletely(GatheringByteChannel gatheringByteChannel) {
        return Send$class.writeCompletely(this, gatheringByteChannel);
    }

    @Override
    public void expectIncomplete() {
        Transmission$class.expectIncomplete(this);
    }

    @Override
    public void expectComplete() {
        Transmission$class.expectComplete(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        PartitionDataSend partitionDataSend = this;
        synchronized (partitionDataSend) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public int partitionId() {
        return this.partitionId;
    }

    public FetchResponsePartitionData partitionData() {
        return this.partitionData;
    }

    private int messageSize() {
        return this.messageSize;
    }

    private int messagesSentSize() {
        return this.messagesSentSize;
    }

    private void messagesSentSize_$eq(int n) {
        this.messagesSentSize = n;
    }

    private ByteBuffer buffer() {
        return this.buffer;
    }

    @Override
    public boolean complete() {
        return !this.buffer().hasRemaining() && this.messagesSentSize() >= this.messageSize();
    }

    @Override
    public int writeTo(GatheringByteChannel gatheringByteChannel) {
        int n = 0;
        if (this.buffer().hasRemaining()) {
            n += gatheringByteChannel.write(this.buffer());
        }
        if (!this.buffer().hasRemaining() && this.messagesSentSize() < this.messageSize()) {
            int n2 = this.partitionData().messages().writeTo(gatheringByteChannel, this.messagesSentSize(), this.messageSize() - this.messagesSentSize());
            this.messagesSentSize_$eq(this.messagesSentSize() + n2);
            n += n2;
        }
        return n;
    }

    public PartitionDataSend(int n, FetchResponsePartitionData fetchResponsePartitionData) {
        this.partitionId = n;
        this.partitionData = fetchResponsePartitionData;
        Logging$class.$init$(this);
        Transmission$class.$init$(this);
        Send$class.$init$(this);
        this.messageSize = fetchResponsePartitionData.messages().sizeInBytes();
        this.messagesSentSize = 0;
        this.buffer = ByteBuffer.allocate(4 + FetchResponsePartitionData$.MODULE$.headerSize());
        this.buffer().putInt(n);
        this.buffer().putShort(fetchResponsePartitionData.error());
        this.buffer().putLong(fetchResponsePartitionData.hw());
        this.buffer().putInt(fetchResponsePartitionData.messages().sizeInBytes());
        this.buffer().rewind();
    }
}

