/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.InvalidOffsetException;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Os$;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import sun.nio.ch.DirectBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tUa\u0001B\u0001\u0003\u0001\u001d\u00111b\u00144gg\u0016$\u0018J\u001c3fq*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0003\t\u0017!\tIa\"D\u0001\u000b\u0015\tYA\"\u0001\u0003mC:<'\"A\u0007\u0002\t)\fg/Y\u0005\u0003\u001f)\u0011aa\u00142kK\u000e$\bCA\t\u0015\u001b\u0005\u0011\"BA\n\u0005\u0003\u0015)H/\u001b7t\u0013\t)\"CA\u0004M_\u001e<\u0017N\\4\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t;\u0001\u0011)\u0019!C\u0001=\u0005!a-\u001b7f+\u0005y\u0002C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\r\u0003\tIw.\u0003\u0002%C\t!a)\u001b7f\u0011!1\u0003A!A!\u0002\u0013y\u0012!\u00024jY\u0016\u0004\u0003\u0002\u0003\u0015\u0001\u0005\u000b\u0007I\u0011A\u0015\u0002\u0015\t\f7/Z(gMN,G/F\u0001+!\t92&\u0003\u0002-1\t!Aj\u001c8h\u0011!q\u0003A!A!\u0002\u0013Q\u0013a\u00032bg\u0016|eMZ:fi\u0002B\u0001\u0002\r\u0001\u0003\u0006\u0004%\t!M\u0001\r[\u0006D\u0018J\u001c3fqNK'0Z\u000b\u0002eA\u0011qcM\u0005\u0003ia\u00111!\u00138u\u0011!1\u0004A!A!\u0002\u0013\u0011\u0014!D7bq&sG-\u001a=TSj,\u0007\u0005C\u00039\u0001\u0011\u0005\u0011(\u0001\u0004=S:LGO\u0010\u000b\u0005uqjd\b\u0005\u0002<\u00015\t!\u0001C\u0003\u001eo\u0001\u0007q\u0004C\u0003)o\u0001\u0007!\u0006C\u00041oA\u0005\t\u0019\u0001\u001a\t\u000f\u0001\u0003!\u0019!C\u0005\u0003\u0006!An\\2l+\u0005\u0011\u0005CA\"K\u001b\u0005!%BA#G\u0003\u0015awnY6t\u0015\t9\u0005*\u0001\u0006d_:\u001cWO\u001d:f]RT!!\u0013\u0007\u0002\tU$\u0018\u000e\\\u0005\u0003\u0017\u0012\u0013QBU3f]R\u0014\u0018M\u001c;M_\u000e\\\u0007BB'\u0001A\u0003%!)A\u0003m_\u000e\\\u0007\u0005C\u0004P\u0001\u0001\u0007I\u0011\u0002)\u0002\t5l\u0017\r]\u000b\u0002#B\u0011!+V\u0007\u0002'*\u0011A\u000bD\u0001\u0004]&|\u0017B\u0001,T\u0005Ai\u0015\r\u001d9fI\nKH/\u001a\"vM\u001a,'\u000fC\u0004Y\u0001\u0001\u0007I\u0011B-\u0002\u00115l\u0017\r]0%KF$\"AW/\u0011\u0005]Y\u0016B\u0001/\u0019\u0005\u0011)f.\u001b;\t\u000fy;\u0016\u0011!a\u0001#\u0006\u0019\u0001\u0010J\u0019\t\r\u0001\u0004\u0001\u0015)\u0003R\u0003\u0015iW.\u00199!\u0011\u001d\u0011\u0007\u00011A\u0005\n\r\fAa]5{KV\tA\r\u0005\u0002fQ6\taM\u0003\u0002h\r\u00061\u0011\r^8nS\u000eL!!\u001b4\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0011\u001dY\u0007\u00011A\u0005\n1\f\u0001b]5{K~#S-\u001d\u000b\u000356DqA\u00186\u0002\u0002\u0003\u0007A\r\u0003\u0004p\u0001\u0001\u0006K\u0001Z\u0001\u0006g&TX\r\t\u0005\bc\u0002\u0001\r\u0011\"\u00012\u0003)i\u0017\r_#oiJLWm\u001d\u0005\bg\u0002\u0001\r\u0011\"\u0001u\u00039i\u0017\r_#oiJLWm]0%KF$\"AW;\t\u000fy\u0013\u0018\u0011!a\u0001e!1q\u000f\u0001Q!\nI\n1\"\\1y\u000b:$(/[3tA!\u0012a/\u001f\t\u0003/iL!a\u001f\r\u0003\u0011Y|G.\u0019;jY\u0016Dq! \u0001A\u0002\u0013\u0005\u0011&\u0001\u0006mCN$xJ\u001a4tKRD\u0001b \u0001A\u0002\u0013\u0005\u0011\u0011A\u0001\u000fY\u0006\u001cHo\u00144gg\u0016$x\fJ3r)\rQ\u00161\u0001\u0005\b=z\f\t\u00111\u0001+\u0011\u001d\t9\u0001\u0001Q!\n)\n1\u0002\\1ti>3gm]3uA!9\u00111\u0002\u0001\u0005\n\u00055\u0011A\u0004:fC\u0012d\u0015m\u001d;PM\u001a\u001cX\r\u001e\u000b\u0002U!9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0011A\u00027p_.,\b\u000f\u0006\u0003\u0002\u0016\u0005m\u0001cA\u001e\u0002\u0018%\u0019\u0011\u0011\u0004\u0002\u0003\u001d=3gm]3u!>\u001c\u0018\u000e^5p]\"9\u0011QDA\b\u0001\u0004Q\u0013\u0001\u0004;be\u001e,Go\u00144gg\u0016$\bbBA\u0011\u0001\u0011%\u00111E\u0001\rS:$W\r_*m_R4uN\u001d\u000b\u0006e\u0005\u0015\u0012q\u0006\u0005\t\u0003O\ty\u00021\u0001\u0002*\u0005\u0019\u0011\u000e\u001a=\u0011\u0007I\u000bY#C\u0002\u0002.M\u0013!BQ=uK\n+hMZ3s\u0011\u001d\ti\"a\bA\u0002)Bq!a\r\u0001\t\u0013\t)$\u0001\bsK2\fG/\u001b<f\u001f\u001a47/\u001a;\u0015\u000bI\n9$a\u000f\t\u0011\u0005e\u0012\u0011\u0007a\u0001\u0003S\taAY;gM\u0016\u0014\bbBA\u001f\u0003c\u0001\rAM\u0001\u0002]\"9\u0011\u0011\t\u0001\u0005\n\u0005\r\u0013\u0001\u00039isNL7-\u00197\u0015\u000bI\n)%a\u0012\t\u0011\u0005e\u0012q\ba\u0001\u0003SAq!!\u0010\u0002@\u0001\u0007!\u0007C\u0004\u0002L\u0001!\t!!\u0014\u0002\u000b\u0015tGO]=\u0015\t\u0005U\u0011q\n\u0005\b\u0003{\tI\u00051\u00013\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+\na!\u00199qK:$G#\u0002.\u0002X\u0005m\u0003bBA-\u0003#\u0002\rAK\u0001\u0007_\u001a47/\u001a;\t\u000f\u0005u\u0013\u0011\u000ba\u0001e\u0005A\u0001o\\:ji&|g\u000eC\u0004\u0002b\u0001!\t!a\u0019\u0002\r%\u001ch)\u001e7m+\t\t)\u0007E\u0002\u0018\u0003OJ1!!\u001b\u0019\u0005\u001d\u0011un\u001c7fC:Dq!!\u001c\u0001\t\u0003\ty'\u0001\u0005ueVt7-\u0019;f)\u0005Q\u0006bBA:\u0001\u0011\u0005\u0011QO\u0001\u000biJ,hnY1uKR{Gc\u0001.\u0002x!9\u0011\u0011LA9\u0001\u0004Q\u0003bBA>\u0001\u0011%\u0011QP\u0001\u0012iJ,hnY1uKR{WI\u001c;sS\u0016\u001cHc\u0001.\u0002\u0000!9\u0011\u0011QA=\u0001\u0004\u0011\u0014aB3oiJLWm\u001d\u0005\b\u0003\u000b\u0003A\u0011AA8\u0003=!(/[7U_Z\u000bG.\u001b3TSj,\u0007bBAE\u0001\u0011\u0005\u00111R\u0001\u0007e\u0016\u001c\u0018N_3\u0015\u0007i\u000bi\tC\u0004\u0002\u0010\u0006\u001d\u0005\u0019\u0001\u001a\u0002\u000f9,woU5{K\"9\u00111\u0013\u0001\u0005\n\u0005U\u0015A\u00034pe\u000e,WK\\7baR\u0019!,a&\t\u000f\u0005e\u0015\u0011\u0013a\u0001#\u0006\tQ\u000eC\u0004\u0002\u001e\u0002!\t!a\u001c\u0002\u000b\u0019dWo\u001d5\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002$\u00061A-\u001a7fi\u0016$\"!!\u001a\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002(R\t!\u0007C\u0004\u0002,\u0002!\t!a\u001c\u0002\u000b\rdwn]3\t\u000f\u0005=\u0006\u0001\"\u0003\u00022\u0006!\"o\\;oIR{W\t_1di6+H\u000e^5qY\u0016$RAMAZ\u0003oCq!!.\u0002.\u0002\u0007!'\u0001\u0004ok6\u0014WM\u001d\u0005\b\u0003s\u000bi\u000b1\u00013\u0003\u00191\u0017m\u0019;pe\"9\u0011Q\u0018\u0001\u0005\n\u0005}\u0016!C7bs\n,Gj\\2l+\u0011\t\t-!3\u0015\t\u0005\r\u0017Q\u001d\u000b\u0005\u0003\u000b\fY\u000e\u0005\u0003\u0002H\u0006%G\u0002\u0001\u0003\t\u0003\u0017\fYL1\u0001\u0002N\n\tA+\u0005\u0003\u0002P\u0006U\u0007cA\f\u0002R&\u0019\u00111\u001b\r\u0003\u000f9{G\u000f[5oOB\u0019q#a6\n\u0007\u0005e\u0007DA\u0002B]fD\u0011\"!8\u0002<\u0012\u0005\r!a8\u0002\u0007\u0019,h\u000eE\u0003\u0018\u0003C\f)-C\u0002\u0002db\u0011\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\b\u0001\u0006m\u0006\u0019AAt!\r\u0019\u0015\u0011^\u0005\u0004\u0003W$%\u0001\u0002'pG.<\u0011\"a<\u0003\u0003\u0003E)!!=\u0002\u0017=3gm]3u\u0013:$W\r\u001f\t\u0004w\u0005Mh\u0001C\u0001\u0003\u0003\u0003E)!!>\u0014\t\u0005M\bB\u0006\u0005\bq\u0005MH\u0011AA})\t\t\t\u0010\u0003\u0006\u0002~\u0006M\u0018\u0013!C\u0001\u0003\u007f\fa\"\u001b8ji\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u0002)\u001a!Ga\u0001,\u0005\t\u0015\u0001\u0003\u0002B\u0004\u0005#i!A!\u0003\u000b\t\t-!QB\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0004\u0019\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005'\u0011IAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class OffsetIndex
implements Logging {
    private final File file;
    private final long baseOffset;
    private final int maxIndexSize;
    private final ReentrantLock lock;
    private MappedByteBuffer kafka$log$OffsetIndex$$mmap;
    private AtomicInteger kafka$log$OffsetIndex$$size;
    private volatile int maxEntries;
    private long lastOffset;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final int init$default$3() {
        return OffsetIndex$.MODULE$.init$default$3();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        OffsetIndex offsetIndex = this;
        synchronized (offsetIndex) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public File file() {
        return this.file;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int maxIndexSize() {
        return this.maxIndexSize;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    public final MappedByteBuffer kafka$log$OffsetIndex$$mmap() {
        return this.kafka$log$OffsetIndex$$mmap;
    }

    public final void kafka$log$OffsetIndex$$mmap_$eq(MappedByteBuffer mappedByteBuffer) {
        this.kafka$log$OffsetIndex$$mmap = mappedByteBuffer;
    }

    public final AtomicInteger kafka$log$OffsetIndex$$size() {
        return this.kafka$log$OffsetIndex$$size;
    }

    private void kafka$log$OffsetIndex$$size_$eq(AtomicInteger atomicInteger) {
        this.kafka$log$OffsetIndex$$size = atomicInteger;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public void maxEntries_$eq(int n) {
        this.maxEntries = n;
    }

    public long lastOffset() {
        return this.lastOffset;
    }

    public void lastOffset_$eq(long l) {
        this.lastOffset = l;
    }

    public final long kafka$log$OffsetIndex$$readLastOffset() {
        return BoxesRunTime.unboxToLong(Utils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID;
            private final OffsetIndex $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                int n = this.$outer.kafka$log$OffsetIndex$$size().get();
                int n2 = n == 0 ? 0 : this.$outer.kafka$log$OffsetIndex$$relativeOffset(this.$outer.kafka$log$OffsetIndex$$mmap(), n - 1);
                return this.$outer.baseOffset() + (long)n2;
            }
            {
                if (offsetIndex == null) {
                    throw new NullPointerException();
                }
                this.$outer = offsetIndex;
            }
        }));
    }

    public OffsetPosition lookup(long l) {
        return (OffsetPosition)this.maybeLock(this.lock(), (Function0)new Serializable(this, l){
            public static final long serialVersionUID;
            private final OffsetIndex $outer;
            private final long targetOffset$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final OffsetPosition apply() {
                ByteBuffer byteBuffer = this.$outer.kafka$log$OffsetIndex$$mmap().duplicate();
                int n = this.$outer.kafka$log$OffsetIndex$$indexSlotFor(byteBuffer, this.targetOffset$1);
                return n == -1 ? new OffsetPosition(this.$outer.baseOffset(), 0) : new OffsetPosition(this.$outer.baseOffset() + (long)this.$outer.kafka$log$OffsetIndex$$relativeOffset(byteBuffer, n), this.$outer.kafka$log$OffsetIndex$$physical(byteBuffer, n));
            }
            {
                if (offsetIndex == null) {
                    throw new NullPointerException();
                }
                this.$outer = offsetIndex;
                this.targetOffset$1 = l;
            }
        });
    }

    public final int kafka$log$OffsetIndex$$indexSlotFor(ByteBuffer byteBuffer, long l) {
        long l2 = l - this.baseOffset();
        if (this.entries() == 0) {
            return -1;
        }
        if ((long)this.kafka$log$OffsetIndex$$relativeOffset(byteBuffer, 0) > l2) {
            return -1;
        }
        int n = 0;
        int n2 = this.entries() - 1;
        while (n < n2) {
            int n3 = (int)package$.MODULE$.ceil((double)n2 / 2.0 + (double)n / 2.0);
            int n4 = this.kafka$log$OffsetIndex$$relativeOffset(byteBuffer, n3);
            if ((long)n4 == l2) {
                return n3;
            }
            if ((long)n4 < l2) {
                n = n3;
                continue;
            }
            n2 = n3 - 1;
        }
        return n;
    }

    public final int kafka$log$OffsetIndex$$relativeOffset(ByteBuffer byteBuffer, int n) {
        return byteBuffer.getInt(n * 8);
    }

    public final int kafka$log$OffsetIndex$$physical(ByteBuffer byteBuffer, int n) {
        return byteBuffer.getInt(n * 8 + 4);
    }

    public OffsetPosition entry(int n) {
        return (OffsetPosition)this.maybeLock(this.lock(), (Function0)new Serializable(this, n){
            public static final long serialVersionUID;
            private final OffsetIndex $outer;
            private final int n$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final OffsetPosition apply() {
                if (this.n$1 >= this.$outer.entries()) {
                    throw new IllegalArgumentException(Predef$.MODULE$.augmentString("Attempt to fetch the %dth entry from an index of size %d.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.n$1), BoxesRunTime.boxToInteger((int)this.$outer.entries())})));
                }
                ByteBuffer byteBuffer = this.$outer.kafka$log$OffsetIndex$$mmap().duplicate();
                return new OffsetPosition(this.$outer.kafka$log$OffsetIndex$$relativeOffset(byteBuffer, this.n$1), this.$outer.kafka$log$OffsetIndex$$physical(byteBuffer, this.n$1));
            }
            {
                if (offsetIndex == null) {
                    throw new NullPointerException();
                }
                this.$outer = offsetIndex;
                this.n$1 = n;
            }
        });
    }

    public void append(long l, int n) {
        Utils$.MODULE$.inLock(this.lock(), new Serializable(this, l, n){
            public static final long serialVersionUID;
            private final OffsetIndex $outer;
            public final long offset$1;
            public final int position$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.require(!this.$outer.isFull(), (Function0)new Serializable(this){
                    public static final long serialVersionUID;
                    private final $anonfun$append$1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Attempt to append to a full index (size = ").append((Object)this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().kafka$log$OffsetIndex$$size()).append((Object)").").toString();
                    }
                    {
                        if (var1_1 == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = var1_1;
                    }
                });
                if (this.$outer.kafka$log$OffsetIndex$$size().get() == 0 || this.offset$1 > this.$outer.lastOffset()) {
                    this.$outer.debug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID;
                        private final $anonfun$append$1 $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Adding index entry %d => %d to %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.offset$1), BoxesRunTime.boxToInteger((int)this.$outer.position$1), this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().file().getName()}));
                        }
                        {
                            if (var1_1 == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = var1_1;
                        }
                    });
                    this.$outer.kafka$log$OffsetIndex$$mmap().putInt((int)(this.offset$1 - this.$outer.baseOffset()));
                    this.$outer.kafka$log$OffsetIndex$$mmap().putInt(this.position$1);
                    this.$outer.kafka$log$OffsetIndex$$size().incrementAndGet();
                    this.$outer.lastOffset_$eq(this.offset$1);
                    Predef$.MODULE$.require(this.$outer.entries() * 8 == this.$outer.kafka$log$OffsetIndex$$mmap().position(), (Function0)new Serializable(this){
                        public static final long serialVersionUID;
                        private final $anonfun$append$1 $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append(this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().entries()).append((Object)" entries but file position in index is ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().kafka$log$OffsetIndex$$mmap().position())).append((Object)".").toString();
                        }
                        {
                            if (var1_1 == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = var1_1;
                        }
                    });
                    return;
                }
                throw new InvalidOffsetException(Predef$.MODULE$.augmentString("Attempt to append an offset (%d) to position %d no larger than the last offset appended (%d) to %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.offset$1), BoxesRunTime.boxToInteger((int)this.$outer.entries()), BoxesRunTime.boxToLong((long)this.$outer.lastOffset()), this.$outer.file().getName()})));
            }

            public OffsetIndex kafka$log$OffsetIndex$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if (offsetIndex == null) {
                    throw new NullPointerException();
                }
                this.$outer = offsetIndex;
                this.offset$1 = l;
                this.position$1 = n;
            }
        });
    }

    public boolean isFull() {
        return this.entries() >= this.maxEntries();
    }

    public void truncate() {
        this.kafka$log$OffsetIndex$$truncateToEntries(0);
    }

    public void truncateTo(long l) {
        Utils$.MODULE$.inLock(this.lock(), new Serializable(this, l){
            public static final long serialVersionUID;
            private final OffsetIndex $outer;
            private final long offset$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ByteBuffer byteBuffer = this.$outer.kafka$log$OffsetIndex$$mmap().duplicate();
                int n = this.$outer.kafka$log$OffsetIndex$$indexSlotFor(byteBuffer, this.offset$2);
                int n2 = n < 0 ? 0 : ((long)this.$outer.kafka$log$OffsetIndex$$relativeOffset(byteBuffer, n) == this.offset$2 - this.$outer.baseOffset() ? n : n + 1);
                this.$outer.kafka$log$OffsetIndex$$truncateToEntries(n2);
            }
            {
                if (offsetIndex == null) {
                    throw new NullPointerException();
                }
                this.$outer = offsetIndex;
                this.offset$2 = l;
            }
        });
    }

    public final void kafka$log$OffsetIndex$$truncateToEntries(int n) {
        Utils$.MODULE$.inLock(this.lock(), new Serializable(this, n){
            public static final long serialVersionUID;
            private final OffsetIndex $outer;
            private final int entries$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$OffsetIndex$$size().set(this.entries$1);
                this.$outer.kafka$log$OffsetIndex$$mmap().position(this.$outer.kafka$log$OffsetIndex$$size().get() * 8);
                this.$outer.lastOffset_$eq(this.$outer.kafka$log$OffsetIndex$$readLastOffset());
            }
            {
                if (offsetIndex == null) {
                    throw new NullPointerException();
                }
                this.$outer = offsetIndex;
                this.entries$1 = n;
            }
        });
    }

    public void trimToValidSize() {
        Utils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID;
            private final OffsetIndex $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.resize(this.$outer.entries() * 8);
            }
            {
                if (offsetIndex == null) {
                    throw new NullPointerException();
                }
                this.$outer = offsetIndex;
            }
        });
    }

    public void resize(int n) {
        Utils$.MODULE$.inLock(this.lock(), new Serializable(this, n){
            public static final long serialVersionUID;
            private final OffsetIndex $outer;
            private final int newSize$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Buffer apply() {
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.$outer.file(), "rws");
                int n = this.$outer.kafka$log$OffsetIndex$$roundToExactMultiple(this.newSize$1, 8);
                int n2 = this.$outer.kafka$log$OffsetIndex$$mmap().position();
                if (Os$.MODULE$.isWindows()) {
                    this.$outer.kafka$log$OffsetIndex$$forceUnmap(this.$outer.kafka$log$OffsetIndex$$mmap());
                }
                Buffer buffer = null;
                try {
                    randomAccessFile.setLength(n);
                    this.$outer.kafka$log$OffsetIndex$$mmap_$eq(randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, n));
                    this.$outer.maxEntries_$eq(this.$outer.kafka$log$OffsetIndex$$mmap().limit() / 8);
                    buffer = this.$outer.kafka$log$OffsetIndex$$mmap().position(n2);
                    Utils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this, randomAccessFile){
                        public static final long serialVersionUID;
                        private final RandomAccessFile raf$2;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.raf$2.close();
                        }
                        {
                            this.raf$2 = randomAccessFile;
                        }
                    });
                    return buffer;
                }
                catch (Throwable throwable) {
                    Utils$.MODULE$.swallow((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
            }
            {
                if (offsetIndex == null) {
                    throw new NullPointerException();
                }
                this.$outer = offsetIndex;
                this.newSize$1 = n;
            }
        });
    }

    public final void kafka$log$OffsetIndex$$forceUnmap(MappedByteBuffer mappedByteBuffer) {
        try {
            if (mappedByteBuffer instanceof DirectBuffer) {
                ((DirectBuffer)((Object)mappedByteBuffer)).cleaner().clean();
            }
        }
        catch (Throwable throwable) {
            this.warn((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Error when freeing index buffer";
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID;
                private final Throwable t$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Throwable apply() {
                    return this.t$1;
                }
                {
                    this.t$1 = throwable;
                }
            });
        }
    }

    public void flush() {
        Utils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID;
            private final OffsetIndex $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final MappedByteBuffer apply() {
                return this.$outer.kafka$log$OffsetIndex$$mmap().force();
            }
            {
                if (offsetIndex == null) {
                    throw new NullPointerException();
                }
                this.$outer = offsetIndex;
            }
        });
    }

    public boolean delete() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;
            private final OffsetIndex $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Deleting index ").append((Object)this.$outer.file().getAbsolutePath()).toString();
            }
            {
                if (offsetIndex == null) {
                    throw new NullPointerException();
                }
                this.$outer = offsetIndex;
            }
        });
        return this.file().delete();
    }

    public int entries() {
        return this.kafka$log$OffsetIndex$$size().get();
    }

    public void close() {
        this.trimToValidSize();
    }

    public final int kafka$log$OffsetIndex$$roundToExactMultiple(int n, int n2) {
        return n2 * (n / n2);
    }

    private <T> T maybeLock(Lock lock2, Function0<T> function0) {
        if (Os$.MODULE$.isWindows()) {
            lock2.lock();
        }
        Object var3_3 = null;
        try {
            return (T)function0.apply();
        }
        finally {
            if (Os$.MODULE$.isWindows()) {
                lock2.unlock();
            }
        }
    }

    private final MappedByteBuffer liftedTree1$1(boolean bl, RandomAccessFile randomAccessFile) {
        MappedByteBuffer mappedByteBuffer = null;
        try {
            long l;
            if (bl) {
                if (this.maxIndexSize() < 8) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid max index size: ").append((Object)BoxesRunTime.boxToInteger((int)this.maxIndexSize())).toString());
                }
                randomAccessFile.setLength(this.kafka$log$OffsetIndex$$roundToExactMultiple(this.maxIndexSize(), 8));
            }
            if ((l = randomAccessFile.length()) < 0L || l % 8L != 0L) {
                throw new IllegalStateException(new StringBuilder().append((Object)"Index file ").append((Object)this.file().getName()).append((Object)" is corrupt, found ").append((Object)BoxesRunTime.boxToLong((long)l)).append((Object)" bytes which is not positive or not a multiple of 8.").toString());
            }
            MappedByteBuffer mappedByteBuffer2 = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, l);
            Buffer buffer = bl ? mappedByteBuffer2.position(0) : mappedByteBuffer2.position(this.kafka$log$OffsetIndex$$roundToExactMultiple(mappedByteBuffer2.limit(), 8));
            mappedByteBuffer = mappedByteBuffer2;
            Utils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this, randomAccessFile){
                public static final long serialVersionUID;
                private final RandomAccessFile raf$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.raf$1.close();
                }
                {
                    this.raf$1 = randomAccessFile;
                }
            });
            return mappedByteBuffer;
        }
        catch (Throwable throwable) {
            Utils$.MODULE$.swallow((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
    }

    public OffsetIndex(File file, long l, int n) {
        this.file = file;
        this.baseOffset = l;
        this.maxIndexSize = n;
        Logging$class.$init$(this);
        this.lock = new ReentrantLock();
        boolean bl = file.createNewFile();
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        this.kafka$log$OffsetIndex$$mmap = this.liftedTree1$1(bl, randomAccessFile);
        this.kafka$log$OffsetIndex$$size = new AtomicInteger(this.kafka$log$OffsetIndex$$mmap().position() / 8);
        this.maxEntries = this.kafka$log$OffsetIndex$$mmap().limit() / 8;
        this.lastOffset = this.kafka$log$OffsetIndex$$readLastOffset();
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;
            private final OffsetIndex $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Loaded index file %s with maxEntries = %d, maxIndexSize = %d, entries = %d, lastOffset = %d, file position = %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)this.$outer.maxEntries()), BoxesRunTime.boxToInteger((int)this.$outer.maxIndexSize()), BoxesRunTime.boxToInteger((int)this.$outer.entries()), BoxesRunTime.boxToLong((long)this.$outer.lastOffset()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$OffsetIndex$$mmap().position())}));
            }
            {
                if (offsetIndex == null) {
                    throw new NullPointerException();
                }
                this.$outer = offsetIndex;
            }
        });
    }
}

