/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kafka.api.OffsetRequest$;
import kafka.consumer.Consumer$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerConnector;
import kafka.consumer.KafkaStream;
import kafka.tools.ReplayLogProducer;
import kafka.tools.ReplayLogProducer$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZkUtils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ReplayLogProducer$
implements Logging {
    public static final ReplayLogProducer$ MODULE$;
    private final String GroupId;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ReplayLogProducer$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ReplayLogProducer$ replayLogProducer$ = this;
        synchronized (replayLogProducer$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    private String GroupId() {
        return this.GroupId;
    }

    public void main(String[] stringArray) {
        ReplayLogProducer.Config config = new ReplayLogProducer.Config(stringArray);
        ExecutorService executorService = Executors.newFixedThreadPool(config.numThreads());
        CountDownLatch countDownLatch = new CountDownLatch(config.numThreads());
        ZkUtils$.MODULE$.maybeDeletePath(config.zkConnect(), new StringBuilder().append((Object)"/consumers/").append((Object)this.GroupId()).toString());
        Thread.sleep(500L);
        Properties properties = new Properties();
        properties.put("group.id", this.GroupId());
        properties.put("zookeeper.connect", config.zkConnect());
        properties.put("consumer.timeout.ms", "10000");
        properties.put("auto.offset.reset", OffsetRequest$.MODULE$.SmallestTimeString());
        properties.put("fetch.message.max.bytes", ((Object)BoxesRunTime.boxToInteger((int)0x100000)).toString());
        properties.put("socket.receive.buffer.bytes", ((Object)BoxesRunTime.boxToInteger((int)0x200000)).toString());
        ConsumerConfig consumerConfig = new ConsumerConfig(properties);
        ConsumerConnector consumerConnector = Consumer$.MODULE$.create(consumerConfig);
        Map<String, List<KafkaStream<byte[], byte[]>>> map = consumerConnector.createMessageStreams((Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)config.inputTopic()).$minus$greater((Object)BoxesRunTime.boxToInteger((int)config.numThreads()))}))));
        ObjectRef objectRef = new ObjectRef((Object)Nil$.MODULE$);
        ((IterableLike)map.filter((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<String, List<KafkaStream<byte[], byte[]>>> tuple2) {
                Tuple2<String, List<KafkaStream<byte[], byte[]>>> tuple22 = tuple2;
                return tuple22 != null;
            }
        })).foreach((Function1)new Serializable(config, objectRef){
            public static final long serialVersionUID;
            public final ReplayLogProducer.Config config$1;
            public final ObjectRef threadList$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<String, List<KafkaStream<byte[], byte[]>>> tuple2) {
                Tuple2<String, List<KafkaStream<byte[], byte[]>>> tuple22 = tuple2;
                if (tuple22 != null) {
                    ((LinearSeqOptimized)tuple22._2()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID;
                        private final anonfun.main.2 $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply(KafkaStream<byte[], byte[]> kafkaStream) {
                            this.$outer.threadList$1.elem = ((List)this.$outer.threadList$1.elem).$colon$colon((Object)new ReplayLogProducer.ZKConsumerThread(this.$outer.config$1, kafkaStream));
                        }
                        {
                            if (var1_1 == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = var1_1;
                        }
                    });
                    return;
                }
                throw new MatchError(tuple22);
            }
            {
                this.config$1 = config;
                this.threadList$1 = objectRef;
            }
        });
        ((List)objectRef.elem).foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ReplayLogProducer.ZKConsumerThread zKConsumerThread) {
                zKConsumerThread.start();
            }
        });
        ((List)objectRef.elem).foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ReplayLogProducer.ZKConsumerThread zKConsumerThread) {
                zKConsumerThread.shutdown();
            }
        });
        consumerConnector.shutdown();
    }

    private ReplayLogProducer$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.GroupId = "replay-log-producer";
    }
}

